/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g
 *     -                            On : 2014-07-13 13:49:01
 *     -                for the parser : CvcParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of CVC4.
 ** Copyright (c) 2009-2014  New York University and The University of Iowa
 ** See the file COPYING in the top-level source directory for licensing
 ** information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "CvcParser.h"


#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"
#include "util/output.h"

#include <vector>
#include <string>
#include <sstream>

#define REPEAT_COMMAND(k, CommandCtor)                      \
  ({                                                        \
    unsigned __k = (k);                                     \
    (__k <= 1)                                              \
      ? (Command*) new CommandCtor                          \
      : ({                                                  \
          CommandSequence* __seq = new CommandSequence();   \
          while(__k-- > 0) {                                \
            __seq->addCommand(new CommandCtor);             \
          }                                                 \
          (Command*) __seq;                                 \
        });                                                 \
  })

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which will be defined
 * by ANTLR *after* this section. (If they were functions, PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Parser*)PARSER->super)
#undef EXPR_MANAGER
#define EXPR_MANAGER PARSER_STATE->getExprManager()
#undef MK_EXPR
#define MK_EXPR EXPR_MANAGER->mkExpr
#undef MK_CONST
#define MK_CONST EXPR_MANAGER->mkConst
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

#define ENSURE_BV_SIZE(k, f)                                   \
{                                                              \
  unsigned size = BitVectorType(f.getType()).getSize();        \
  if(k > size) {                                               \
    f = MK_EXPR(MK_CONST(BitVectorZeroExtend(k - size)), f);   \
  } else if (k < size) {                                       \
    f = MK_EXPR(MK_CONST(BitVectorExtract(k - 1, 0)), f);      \
  }                                                            \
}


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pCvcParser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pCvcParser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pCvcParser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pCvcParser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   CvcParserTokenNames[172+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ABS_TOK",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ARITH_VAR_ORDER_TOK",
        (pANTLR3_UINT8) "ARRAY_TOK",
        (pANTLR3_UINT8) "ARROW_TOK",
        (pANTLR3_UINT8) "ASSERTIONS_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "ASSIGN_TOK",
        (pANTLR3_UINT8) "ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "BAR",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BITVECTOR_TOK",
        (pANTLR3_UINT8) "BOOLEAN_TOK",
        (pANTLR3_UINT8) "BVAND_TOK",
        (pANTLR3_UINT8) "BVASHR_TOK",
        (pANTLR3_UINT8) "BVCOMP_TOK",
        (pANTLR3_UINT8) "BVGE_TOK",
        (pANTLR3_UINT8) "BVGT_TOK",
        (pANTLR3_UINT8) "BVLE_TOK",
        (pANTLR3_UINT8) "BVLSHR_TOK",
        (pANTLR3_UINT8) "BVLT_TOK",
        (pANTLR3_UINT8) "BVMULT_TOK",
        (pANTLR3_UINT8) "BVNAND_TOK",
        (pANTLR3_UINT8) "BVNEG_TOK",
        (pANTLR3_UINT8) "BVNOR_TOK",
        (pANTLR3_UINT8) "BVPLUS_TOK",
        (pANTLR3_UINT8) "BVREPEAT_TOK",
        (pANTLR3_UINT8) "BVROTL_TOK",
        (pANTLR3_UINT8) "BVROTR_TOK",
        (pANTLR3_UINT8) "BVSDIV_TOK",
        (pANTLR3_UINT8) "BVSGE_TOK",
        (pANTLR3_UINT8) "BVSGT_TOK",
        (pANTLR3_UINT8) "BVSHL_TOK",
        (pANTLR3_UINT8) "BVSLE_TOK",
        (pANTLR3_UINT8) "BVSLT_TOK",
        (pANTLR3_UINT8) "BVSMOD_TOK",
        (pANTLR3_UINT8) "BVSREM_TOK",
        (pANTLR3_UINT8) "BVSUB_TOK",
        (pANTLR3_UINT8) "BVUDIV_TOK",
        (pANTLR3_UINT8) "BVUMINUS_TOK",
        (pANTLR3_UINT8) "BVUREM_TOK",
        (pANTLR3_UINT8) "BVXNOR_TOK",
        (pANTLR3_UINT8) "BVXOR_TOK",
        (pANTLR3_UINT8) "BVZEROEXTEND_TOK",
        (pANTLR3_UINT8) "CALL_TOK",
        (pANTLR3_UINT8) "CHECKSAT_TOK",
        (pANTLR3_UINT8) "CHECK_TYPE_TOK",
        (pANTLR3_UINT8) "COLON",
        (pANTLR3_UINT8) "COMMA",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONCAT_TOK",
        (pANTLR3_UINT8) "CONTEXT_TOK",
        (pANTLR3_UINT8) "COUNTEREXAMPLE_TOK",
        (pANTLR3_UINT8) "COUNTERMODEL_TOK",
        (pANTLR3_UINT8) "DATATYPE_TOK",
        (pANTLR3_UINT8) "DBG_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISEQUAL_TOK",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "DOT",
        (pANTLR3_UINT8) "DOTDOT",
        (pANTLR3_UINT8) "DUMP_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_CLOSURE_TOK",
        (pANTLR3_UINT8) "DUMP_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_SIG_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_ASSUMPTIONS_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_PROOF_TOK",
        (pANTLR3_UINT8) "DUMP_TCC_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "ELSEIF_TOK",
        (pANTLR3_UINT8) "ELSE_TOK",
        (pANTLR3_UINT8) "ENDIF_TOK",
        (pANTLR3_UINT8) "END_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "ESCAPE",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "EXP_TOK",
        (pANTLR3_UINT8) "FALSE_TOK",
        (pANTLR3_UINT8) "FLOOR_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "FORGET_TOK",
        (pANTLR3_UINT8) "GEQ_TOK",
        (pANTLR3_UINT8) "GET_CHILD_TOK",
        (pANTLR3_UINT8) "GET_OP_TOK",
        (pANTLR3_UINT8) "GET_TYPE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GT_TOK",
        (pANTLR3_UINT8) "HASHPAREN",
        (pANTLR3_UINT8) "HASHSQ",
        (pANTLR3_UINT8) "HELP_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "IDENTIFIER",
        (pANTLR3_UINT8) "IFF_TOK",
        (pANTLR3_UINT8) "IF_TOK",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INTDIV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INT_TOK",
        (pANTLR3_UINT8) "IN_TOK",
        (pANTLR3_UINT8) "IS_INTEGER_TOK",
        (pANTLR3_UINT8) "LAMBDA",
        (pANTLR3_UINT8) "LBRACE",
        (pANTLR3_UINT8) "LBRACKET",
        (pANTLR3_UINT8) "LEFTSHIFT_TOK",
        (pANTLR3_UINT8) "LEQ_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN",
        (pANTLR3_UINT8) "LT_TOK",
        (pANTLR3_UINT8) "MEMBER_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "MOD_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMBER_OR_RANGEOP",
        (pANTLR3_UINT8) "OF_TOK",
        (pANTLR3_UINT8) "OPTION_TOK",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PARENHASH",
        (pANTLR3_UINT8) "PATTERN_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POPTO_SCOPE_TOK",
        (pANTLR3_UINT8) "POPTO_TOK",
        (pANTLR3_UINT8) "POP_SCOPE_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "PRINT_TOK",
        (pANTLR3_UINT8) "PRINT_TYPE_TOK",
        (pANTLR3_UINT8) "PUSH_SCOPE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUERY_TOK",
        (pANTLR3_UINT8) "RBRACE",
        (pANTLR3_UINT8) "RBRACKET",
        (pANTLR3_UINT8) "REAL_TOK",
        (pANTLR3_UINT8) "RESET_TOK",
        (pANTLR3_UINT8) "RIGHTSHIFT_TOK",
        (pANTLR3_UINT8) "RPAREN",
        (pANTLR3_UINT8) "SCONCAT_TOK",
        (pANTLR3_UINT8) "SCONTAINS_TOK",
        (pANTLR3_UINT8) "SEMICOLON",
        (pANTLR3_UINT8) "SET_TOK",
        (pANTLR3_UINT8) "SINDEXOF_TOK",
        (pANTLR3_UINT8) "SPREFIXOF_TOK",
        (pANTLR3_UINT8) "SQHASH",
        (pANTLR3_UINT8) "SREPLACE_TOK",
        (pANTLR3_UINT8) "SSUBSTR_TOK",
        (pANTLR3_UINT8) "SSUFFIXOF_TOK",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STOINTEGER_TOK",
        (pANTLR3_UINT8) "STORE_TOK",
        (pANTLR3_UINT8) "STOSTRING_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL",
        (pANTLR3_UINT8) "STRING_TOK",
        (pANTLR3_UINT8) "SUBSTITUTE_TOK",
        (pANTLR3_UINT8) "SUBTYPE_TOK",
        (pANTLR3_UINT8) "SX_TOK",
        (pANTLR3_UINT8) "THEN_TOK",
        (pANTLR3_UINT8) "TRACE_TOK",
        (pANTLR3_UINT8) "TRANSFORM_TOK",
        (pANTLR3_UINT8) "TRUE_TOK",
        (pANTLR3_UINT8) "TYPE_TOK",
        (pANTLR3_UINT8) "UNDERSCORE",
        (pANTLR3_UINT8) "UNTRACE_TOK",
        (pANTLR3_UINT8) "WHERE_TOK",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "WITH_TOK",
        (pANTLR3_UINT8) "XOR_TOK"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::Expr
	parseExpr    (pCvcParser ctx);
static 
 CVC4::Command*
	parseCommand    (pCvcParser ctx);
static 
 CVC4::Command*
	command    (pCvcParser ctx);
static 
 void
	typeOrVarLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	mainCommand    (pCvcParser ctx, CVC4::Command*& cmd);
static 
 void
	simpleSymbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pCvcParser ctx, CVC4::SExpr& sexpr);
static 
 void
	toplevelDeclaration    (pCvcParser ctx, CVC4::Command*& cmd);
static 
 void
	boundVarDecl    (pCvcParser ctx, std::vector<std::string>& ids, CVC4::Type& t);
static 
 void
	boundVarDecls    (pCvcParser ctx);
static 
 void
	boundVarDeclsReturn    (pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types);
static 
 void
	boundVarDeclReturn    (pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types);
static 
 void
	declareTypes    (pCvcParser ctx, CVC4::Command*& cmd, const std::vector<std::string>& idList);
static 
 void
	declareVariables    (pCvcParser ctx, CVC4::Command*& cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel);
static 
 void
	identifierList    (pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	identifier    (pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	type    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedType    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	restrictedTypePossiblyFunctionLHS    (pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check, bool& lhs);
static 
 void
	parameterization    (pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::Type>& params);
static 
 CVC4::parser::cvc::mySubrangeBound
	bound    (pCvcParser ctx);
static 
 void
	typeLetDecl    (pCvcParser ctx, CVC4::parser::DeclarationCheck check);
static 
 void
	formula    (pCvcParser ctx, CVC4::Expr& f);
static 
 size_t
	morecomparisons    (pCvcParser ctx, std::vector<CVC4::Expr>& expressions, std::vector<unsigned>& operators);
static 
 size_t
	nots    (pCvcParser ctx);
static 
 void
	prefixFormula    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	instantiationPatterns    (pCvcParser ctx, CVC4::Expr& expr);
static 
 void
	letDecl    (pCvcParser ctx);
static 
 void
	booleanBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	comparison    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	comparisonBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	term    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	arithmeticBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	storeTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	arrayStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	tupleStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	recordStore    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	uminusTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvBinaryOpTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvBinop    (pCvcParser ctx, unsigned& op);
static 
 void
	bvNegTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	postfixTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	bvTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	stringTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	simpleTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	typeAscription    (pCvcParser ctx, const CVC4::Expr& f, CVC4::Type& t);
static 
 void
	recordEntry    (pCvcParser ctx, std::string& name, CVC4::Expr& ex);
static 
 void
	iteTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	iteElseTerm    (pCvcParser ctx, CVC4::Expr& f);
static 
 void
	datatypeDef    (pCvcParser ctx, std::vector<CVC4::Datatype>& datatypes);
static 
 void
	constructorDef    (pCvcParser ctx, CVC4::Datatype& type);
static 
 void
	selector    (pCvcParser ctx, CVC4::DatatypeConstructor& ctor);
static 
 unsigned
	numeral    (pCvcParser ctx);
static 
 CVC4::Rational
	integer    (pCvcParser ctx);
static 
 void
	str    (pCvcParser ctx, std::string& s);
static 
 ANTLR3_BOOLEAN
	synpred1_Cvc    (pCvcParser ctx);
static void	CvcParserFree(pCvcParser ctx);
static void     CvcParserReset (pCvcParser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "/home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return CvcParserNewSSD(instream, NULL);
}

/** \brief Create a new CvcParser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pCvcParser
CvcParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pCvcParser ctx;	    /* Context structure we will build and return   */

    ctx	= (pCvcParser) ANTLR3_CALLOC(1, sizeof(CvcParser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in CvcParser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our CvcParser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->command	= command;
    ctx->typeOrVarLetDecl	= typeOrVarLetDecl;
    ctx->mainCommand	= mainCommand;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->toplevelDeclaration	= toplevelDeclaration;
    ctx->boundVarDecl	= boundVarDecl;
    ctx->boundVarDecls	= boundVarDecls;
    ctx->boundVarDeclsReturn	= boundVarDeclsReturn;
    ctx->boundVarDeclReturn	= boundVarDeclReturn;
    ctx->declareTypes	= declareTypes;
    ctx->declareVariables	= declareVariables;
    ctx->identifierList	= identifierList;
    ctx->identifier	= identifier;
    ctx->type	= type;
    ctx->restrictedType	= restrictedType;
    ctx->restrictedTypePossiblyFunctionLHS	= restrictedTypePossiblyFunctionLHS;
    ctx->parameterization	= parameterization;
    ctx->bound	= bound;
    ctx->typeLetDecl	= typeLetDecl;
    ctx->formula	= formula;
    ctx->morecomparisons	= morecomparisons;
    ctx->nots	= nots;
    ctx->prefixFormula	= prefixFormula;
    ctx->instantiationPatterns	= instantiationPatterns;
    ctx->letDecl	= letDecl;
    ctx->booleanBinop	= booleanBinop;
    ctx->comparison	= comparison;
    ctx->comparisonBinop	= comparisonBinop;
    ctx->term	= term;
    ctx->arithmeticBinop	= arithmeticBinop;
    ctx->storeTerm	= storeTerm;
    ctx->arrayStore	= arrayStore;
    ctx->tupleStore	= tupleStore;
    ctx->recordStore	= recordStore;
    ctx->uminusTerm	= uminusTerm;
    ctx->bvBinaryOpTerm	= bvBinaryOpTerm;
    ctx->bvBinop	= bvBinop;
    ctx->bvNegTerm	= bvNegTerm;
    ctx->postfixTerm	= postfixTerm;
    ctx->bvTerm	= bvTerm;
    ctx->stringTerm	= stringTerm;
    ctx->simpleTerm	= simpleTerm;
    ctx->typeAscription	= typeAscription;
    ctx->recordEntry	= recordEntry;
    ctx->iteTerm	= iteTerm;
    ctx->iteElseTerm	= iteElseTerm;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->numeral	= numeral;
    ctx->integer	= integer;
    ctx->str	= str;
    ctx->synpred1_Cvc	= synpred1_Cvc;
    ctx->free			= CvcParserFree;
    ctx->reset			= CvcParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = CvcParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
CvcParserReset (pCvcParser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 CvcParserFree(pCvcParser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return CvcParserTokenNames;
}



    // Idea and code guidance from Sam Harwell,
    // http://www.antlr.org/wiki/display/ANTLR3/Operator+precedence+parser

    bool isRightToLeft(int type) {
      // return true here for any operators that are right-to-left associative
      switch(type) {
      case IMPLIES_TOK: return true;
      default: return false;
      }
    }/* isRightToLeft() */

    int getOperatorPrecedence(int type) {
      switch(type) {
      case BITVECTOR_TOK: return 1;
      //case DOT:
      case LPAREN:
      case LBRACE: return 2;
      case LBRACKET: return 3;
      case ARROW_TOK: return 4;
      case IS_INTEGER_TOK: return 5;
      case BVSLT_TOK:
      case BVSLE_TOK:
      case BVSGT_TOK:
      case BVSGE_TOK: return 6;
      case BVLT_TOK:
      case BVLE_TOK:
      case BVGT_TOK:
      case BVGE_TOK: return 7;
      case LEFTSHIFT_TOK:
      case RIGHTSHIFT_TOK: return 8;
      case SX_TOK:
      case BVZEROEXTEND_TOK:
      case BVREPEAT_TOK:
      case BVROTL_TOK:
      case BVROTR_TOK: return 9;
      case BVUDIV_TOK:
      case BVSDIV_TOK:
      case BVUREM_TOK:
      case BVSREM_TOK:
      case BVSMOD_TOK:
      case BVSHL_TOK:
      case BVASHR_TOK:
      case BVLSHR_TOK: return 10;
      case BVUMINUS_TOK:
      case BVPLUS_TOK:
      case BVSUB_TOK: return 11;
      case BVNEG_TOK: return 12;
      case BVXNOR_TOK: return 13;
      case BVNOR_TOK:
      case BVCOMP_TOK: return 14;
      case BVNAND_TOK: return 15;
      case BVXOR_TOK: return 16;
      case BVAND_TOK: return 17;
      case BAR: return 18;
      case CONCAT_TOK: return 19;
    //case UMINUS_TOK: return 20;
      case WITH_TOK: return 21;
      case EXP_TOK: return 22;
      case STAR_TOK:
      case INTDIV_TOK:
      case DIV_TOK:
      case MOD_TOK: return 23;
      case PLUS_TOK:
      case MINUS_TOK: return 24;
      case LEQ_TOK:
      case LT_TOK:
      case GEQ_TOK:
      case GT_TOK:
      case MEMBER_TOK: return 25;
      case EQUAL_TOK:
      case DISEQUAL_TOK: return 26;
      case NOT_TOK: return 27;
      case AND_TOK: return 28;
      case OR_TOK:
      case XOR_TOK: return 29;
      case IMPLIES_TOK: return 30;// right-to-left
      case IFF_TOK: return 31;
      case FORALL_TOK:
      case EXISTS_TOK: return 32;
      case ASSIGN_TOK:
      case IN_TOK: return 33;

      default:
        std::stringstream ss;
        ss << "internal error: no entry in precedence table for operator " << CvcParserTokenNames[type];
        throw ParserException(ss.str());
      }
    }/* getOperatorPrecedence() */

    Kind getOperatorKind(int type, bool& negate) {
      negate = false;

      switch(type) {
        // booleanBinop
      case IFF_TOK: return kind::IFF;
      case IMPLIES_TOK: return kind::IMPLIES;
      case OR_TOK: return kind::OR;
      case XOR_TOK: return kind::XOR;
      case AND_TOK: return kind::AND;

        // comparisonBinop
      case EQUAL_TOK: return kind::EQUAL;
      case DISEQUAL_TOK: negate = true; return kind::EQUAL;
      case GT_TOK: return kind::GT;
      case GEQ_TOK: return kind::GEQ;
      case LT_TOK: return kind::LT;
      case LEQ_TOK: return kind::LEQ;
      case MEMBER_TOK: return kind::MEMBER;

        // arithmeticBinop
      case PLUS_TOK: return kind::PLUS;
      case MINUS_TOK: return kind::MINUS;
      case STAR_TOK: return kind::MULT;
      case INTDIV_TOK: return kind::INTS_DIVISION;
      case MOD_TOK: return kind::INTS_MODULUS;
      case DIV_TOK: return kind::DIVISION;
      case EXP_TOK: return kind::POW;

        // bvBinop
      case CONCAT_TOK: return kind::BITVECTOR_CONCAT;
      case BAR: return kind::BITVECTOR_OR;
      case BVAND_TOK: return kind::BITVECTOR_AND;
      }

      std::stringstream ss;
      ss << "internal error: no entry in operator-kind table for operator " << CvcParserTokenNames[type];
      throw ParserException(ss.str());

    }/* getOperatorKind() */

    unsigned findPivot(const std::vector<unsigned>& operators,
                       unsigned startIndex, unsigned stopIndex) {
      unsigned pivot = startIndex;
      unsigned pivotRank = getOperatorPrecedence(operators[pivot]);
      /*Debug("prec") << "initial pivot at " << pivot
                    << "(" << CvcParserTokenNames[operators[pivot]] << ") "
                    << "level " << pivotRank << std::endl;*/
      for(unsigned i = startIndex + 1; i <= stopIndex; ++i) {
        unsigned current = getOperatorPrecedence(operators[i]);
        bool rtl = isRightToLeft(operators[i]);
        if(current > pivotRank || (current == pivotRank && !rtl)) {
          /*Debug("prec") << "new pivot at " << i
                        << "(" << CvcParserTokenNames[operators[i]] << ") "
                        << "level " << current << " rtl == " << rtl << std::endl;*/
          pivot = i;
          pivotRank = current;
        }
      }
      return pivot;
    }/* findPivot() */

    Expr createPrecedenceTree(Parser* parser, ExprManager* em,
                              const std::vector<CVC4::Expr>& expressions,
                              const std::vector<unsigned>& operators,
                              unsigned startIndex, unsigned stopIndex) {
      assert(expressions.size() == operators.size() + 1);
      assert(startIndex < expressions.size());
      assert(stopIndex < expressions.size());
      assert(startIndex <= stopIndex);

      if(stopIndex == startIndex) {
        return expressions[startIndex];
      }

      unsigned pivot = findPivot(operators, startIndex, stopIndex - 1);
      //Debug("prec") << "pivot[" << startIndex << "," << stopIndex - 1 << "] at " << pivot << std::endl;
      bool negate;
      Kind k = getOperatorKind(operators[pivot], negate);
      Expr lhs = createPrecedenceTree(parser, em, expressions, operators, startIndex, pivot);
      Expr rhs = createPrecedenceTree(parser, em, expressions, operators, pivot + 1, stopIndex);

      switch(k) {
      case kind::EQUAL: {
        if(lhs.getType().isBoolean()) {
          if(parser->strictModeEnabled()) {
            WarningOnce() << "Warning: in strict parsing mode, will not convert BOOL = BOOL to BOOL <=> BOOL" << std::endl;
          } else {
            k = kind::IFF;
          }
        }
        break;
      }
      case kind::LEQ          : if(lhs.getType().isSet()) { k = kind::SUBSET; } break;
      case kind::MINUS        : if(lhs.getType().isSet()) { k = kind::SETMINUS; } break;
      case kind::BITVECTOR_AND: if(lhs.getType().isSet()) { k = kind::INTERSECTION; } break;
      case kind::BITVECTOR_OR : if(lhs.getType().isSet()) { k = kind::UNION; } break;
      default: break;
      }
      Expr e = em->mkExpr(k, lhs, rhs);
      return negate ? em->mkExpr(kind::NOT, e) : e;
    }/* createPrecedenceTree() recursive variant */

    Expr createPrecedenceTree(Parser* parser, ExprManager* em,
                              const std::vector<CVC4::Expr>& expressions,
                              const std::vector<unsigned>& operators) {
      if(Debug.isOn("prec") && operators.size() > 1) {
        for(unsigned i = 0; i < expressions.size(); ++i) {
          Debug("prec") << expressions[i];
          if(operators.size() > i) {
            Debug("prec") << ' ' << CvcParserTokenNames[operators[i]] << ' ';
          }
        }
        Debug("prec") << std::endl;
      }

      Expr e = createPrecedenceTree(parser, em, expressions, operators, 0, expressions.size() - 1);
      if(Debug.isOn("prec") && operators.size() > 1) {
        Expr::setlanguage::Scope ls(Debug("prec"), language::output::LANG_AST);
        Debug("prec") << "=> " << e << std::endl;
      }
      return e;
    }/* createPrecedenceTree() base variant */

    /** Add n NOTs to the front of e and return the result. */
    Expr addNots(ExprManager* em, size_t n, Expr e) {
      while(n-- > 0) {
        e = em->mkExpr(kind::NOT, e);
      }
      return e;
    }/* addNots() */



/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_parseExpr1602  */
static	ANTLR3_BITWORD FOLLOW_formula_in_parseExpr1602_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_parseExpr1602	= { FOLLOW_formula_in_parseExpr1602_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr1609  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr1609_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr1609	= { FOLLOW_EOF_in_parseExpr1609_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand1630  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand1630_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand1630	= { FOLLOW_command_in_parseCommand1630_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_parseCommand1638  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_parseCommand1638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_parseCommand1638	= { FOLLOW_LPAREN_in_parseCommand1638_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_parseCommand1640  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_parseCommand1640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_parseCommand1640	= { FOLLOW_IDENTIFIER_in_parseCommand1640_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand1652  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand1652_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand1652	= { FOLLOW_EOF_in_parseCommand1652_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_mainCommand_in_command1675  */
static	ANTLR3_BITWORD FOLLOW_mainCommand_in_command1675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000100000) };
static  ANTLR3_BITSET_LIST FOLLOW_mainCommand_in_command1675	= { FOLLOW_mainCommand_in_command1675_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1678  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1678_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1678	= { FOLLOW_SEMICOLON_in_command1678_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SEMICOLON_in_command1686  */
static	ANTLR3_BITWORD FOLLOW_SEMICOLON_in_command1686_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SEMICOLON_in_command1686	= { FOLLOW_SEMICOLON_in_command1686_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_command1694  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_command1694_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_command1694	= { FOLLOW_LET_TOK_in_command1694_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command1704  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command1704_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command1704	= { FOLLOW_typeOrVarLetDecl_in_command1704_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_command1709  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_command1709_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_command1709	= { FOLLOW_COMMA_in_command1709_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeOrVarLetDecl_in_command1711  */
static	ANTLR3_BITWORD FOLLOW_typeOrVarLetDecl_in_command1711_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeOrVarLetDecl_in_command1711	= { FOLLOW_typeOrVarLetDecl_in_command1711_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_command1723  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_command1723_bits[]	= { ANTLR3_UINT64_LIT(0x1F0E000000002C80), ANTLR3_UINT64_LIT(0x40200448F4203FE0), ANTLR3_UINT64_LIT(0x000018C400108FF8) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_command1723	= { FOLLOW_IN_TOK_in_command1723_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_command1727  */
static	ANTLR3_BITWORD FOLLOW_command_in_command1727_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_command1727	= { FOLLOW_command_in_command1727_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_typeOrVarLetDecl1772  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_typeOrVarLetDecl1772_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_typeOrVarLetDecl1772	= { FOLLOW_letDecl_in_typeOrVarLetDecl1772_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_typeOrVarLetDecl1776  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_typeOrVarLetDecl1776_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_typeOrVarLetDecl1776	= { FOLLOW_typeLetDecl_in_typeOrVarLetDecl1776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_mainCommand1802  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_mainCommand1802_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_mainCommand1802	= { FOLLOW_ASSERT_TOK_in_mainCommand1802_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand1804  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand1804_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand1804	= { FOLLOW_formula_in_mainCommand1804_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUERY_TOK_in_mainCommand1814  */
static	ANTLR3_BITWORD FOLLOW_QUERY_TOK_in_mainCommand1814_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_QUERY_TOK_in_mainCommand1814	= { FOLLOW_QUERY_TOK_in_mainCommand1814_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand1816  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand1816_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand1816	= { FOLLOW_formula_in_mainCommand1816_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECKSAT_TOK_in_mainCommand1825  */
static	ANTLR3_BITWORD FOLLOW_CHECKSAT_TOK_in_mainCommand1825_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88112), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECKSAT_TOK_in_mainCommand1825	= { FOLLOW_CHECKSAT_TOK_in_mainCommand1825_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand1827  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand1827_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand1827	= { FOLLOW_formula_in_mainCommand1827_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OPTION_TOK_in_mainCommand1844  */
static	ANTLR3_BITWORD FOLLOW_OPTION_TOK_in_mainCommand1844_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_OPTION_TOK_in_mainCommand1844	= { FOLLOW_OPTION_TOK_in_mainCommand1844_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand1852  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand1852_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000008002), ANTLR3_UINT64_LIT(0x0240106000800000), ANTLR3_UINT64_LIT(0x0000010100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand1852	= { FOLLOW_str_in_mainCommand1852_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand1857  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand1857_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000008002), ANTLR3_UINT64_LIT(0x0240106000800000), ANTLR3_UINT64_LIT(0x0000010100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand1857	= { FOLLOW_IDENTIFIER_in_mainCommand1857_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_mainCommand1869  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_mainCommand1869_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_mainCommand1869	= { FOLLOW_symbolicExpr_in_mainCommand1869_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_mainCommand1886  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_mainCommand1886_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_mainCommand1886	= { FOLLOW_TRUE_TOK_in_mainCommand1886_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_mainCommand1896  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_mainCommand1896_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_mainCommand1896	= { FOLLOW_FALSE_TOK_in_mainCommand1896_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_mainCommand1925  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_mainCommand1925_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_mainCommand1925	= { FOLLOW_PUSH_TOK_in_mainCommand1925_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand1931  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand1931_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand1931	= { FOLLOW_numeral_in_mainCommand1931_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_mainCommand1960  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_mainCommand1960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_mainCommand1960	= { FOLLOW_POP_TOK_in_mainCommand1960_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand1966  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand1966_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand1966	= { FOLLOW_numeral_in_mainCommand1966_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_TOK_in_mainCommand1994  */
static	ANTLR3_BITWORD FOLLOW_POPTO_TOK_in_mainCommand1994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_TOK_in_mainCommand1994	= { FOLLOW_POPTO_TOK_in_mainCommand1994_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand1998  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand1998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand1998	= { FOLLOW_numeral_in_mainCommand1998_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2018  */
static	ANTLR3_BITWORD FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2018	= { FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2018_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2022  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2022_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2022	= { FOLLOW_numeral_in_mainCommand2022_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_SCOPE_TOK_in_mainCommand2035  */
static	ANTLR3_BITWORD FOLLOW_POP_SCOPE_TOK_in_mainCommand2035_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_SCOPE_TOK_in_mainCommand2035	= { FOLLOW_POP_SCOPE_TOK_in_mainCommand2035_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2039  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2039_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2039	= { FOLLOW_numeral_in_mainCommand2039_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2052  */
static	ANTLR3_BITWORD FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2052_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2052	= { FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2052_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2056  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2056_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2056	= { FOLLOW_numeral_in_mainCommand2056_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESET_TOK_in_mainCommand2070  */
static	ANTLR3_BITWORD FOLLOW_RESET_TOK_in_mainCommand2070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESET_TOK_in_mainCommand2070	= { FOLLOW_RESET_TOK_in_mainCommand2070_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DATATYPE_TOK_in_mainCommand2098  */
static	ANTLR3_BITWORD FOLLOW_DATATYPE_TOK_in_mainCommand2098_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DATATYPE_TOK_in_mainCommand2098	= { FOLLOW_DATATYPE_TOK_in_mainCommand2098_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2110  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2110_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2110	= { FOLLOW_datatypeDef_in_mainCommand2110_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand2119  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand2119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand2119	= { FOLLOW_COMMA_in_mainCommand2119_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_mainCommand2121  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_mainCommand2121_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_mainCommand2121	= { FOLLOW_datatypeDef_in_mainCommand2121_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_END_TOK_in_mainCommand2131  */
static	ANTLR3_BITWORD FOLLOW_END_TOK_in_mainCommand2131_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_END_TOK_in_mainCommand2131	= { FOLLOW_END_TOK_in_mainCommand2131_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONTEXT_TOK_in_mainCommand2144  */
static	ANTLR3_BITWORD FOLLOW_CONTEXT_TOK_in_mainCommand2144_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CONTEXT_TOK_in_mainCommand2144	= { FOLLOW_CONTEXT_TOK_in_mainCommand2144_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2154  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2154	= { FOLLOW_str_in_mainCommand2154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2159  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2159_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2159	= { FOLLOW_IDENTIFIER_in_mainCommand2159_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORGET_TOK_in_mainCommand2192  */
static	ANTLR3_BITWORD FOLLOW_FORGET_TOK_in_mainCommand2192_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORGET_TOK_in_mainCommand2192	= { FOLLOW_FORGET_TOK_in_mainCommand2192_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2194  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2194_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2194	= { FOLLOW_identifier_in_mainCommand2194_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_TYPE_TOK_in_mainCommand2208  */
static	ANTLR3_BITWORD FOLLOW_GET_TYPE_TOK_in_mainCommand2208_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_TYPE_TOK_in_mainCommand2208	= { FOLLOW_GET_TYPE_TOK_in_mainCommand2208_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2210  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2210	= { FOLLOW_formula_in_mainCommand2210_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECK_TYPE_TOK_in_mainCommand2224  */
static	ANTLR3_BITWORD FOLLOW_CHECK_TYPE_TOK_in_mainCommand2224_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECK_TYPE_TOK_in_mainCommand2224	= { FOLLOW_CHECK_TYPE_TOK_in_mainCommand2224_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2226  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2226_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2226	= { FOLLOW_formula_in_mainCommand2226_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2229  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2229_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2229	= { FOLLOW_COLON_in_mainCommand2229_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2231  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2231_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2231	= { FOLLOW_type_in_mainCommand2231_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_CHILD_TOK_in_mainCommand2245  */
static	ANTLR3_BITWORD FOLLOW_GET_CHILD_TOK_in_mainCommand2245_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_CHILD_TOK_in_mainCommand2245	= { FOLLOW_GET_CHILD_TOK_in_mainCommand2245_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2247  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2247	= { FOLLOW_formula_in_mainCommand2247_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_mainCommand2252  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_mainCommand2252_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_mainCommand2252	= { FOLLOW_numeral_in_mainCommand2252_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OP_TOK_in_mainCommand2265  */
static	ANTLR3_BITWORD FOLLOW_GET_OP_TOK_in_mainCommand2265_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OP_TOK_in_mainCommand2265	= { FOLLOW_GET_OP_TOK_in_mainCommand2265_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2267  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2267_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2267	= { FOLLOW_formula_in_mainCommand2267_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_mainCommand2281  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_mainCommand2281_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_mainCommand2281	= { FOLLOW_GET_VALUE_TOK_in_mainCommand2281_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2283  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2283	= { FOLLOW_formula_in_mainCommand2283_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBSTITUTE_TOK_in_mainCommand2297  */
static	ANTLR3_BITWORD FOLLOW_SUBSTITUTE_TOK_in_mainCommand2297_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBSTITUTE_TOK_in_mainCommand2297	= { FOLLOW_SUBSTITUTE_TOK_in_mainCommand2297_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2299  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2299_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2299	= { FOLLOW_identifier_in_mainCommand2299_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_mainCommand2302  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_mainCommand2302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_mainCommand2302	= { FOLLOW_COLON_in_mainCommand2302_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2304  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2304_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2304	= { FOLLOW_type_in_mainCommand2304_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_mainCommand2307  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_mainCommand2307_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_mainCommand2307	= { FOLLOW_EQUAL_TOK_in_mainCommand2307_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2313  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2313_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2313	= { FOLLOW_formula_in_mainCommand2313_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_mainCommand2316  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_mainCommand2316_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_mainCommand2316	= { FOLLOW_LBRACKET_in_mainCommand2316_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2318  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2318_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2318	= { FOLLOW_identifier_in_mainCommand2318_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_mainCommand2321  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_mainCommand2321_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_mainCommand2321	= { FOLLOW_ASSIGN_TOK_in_mainCommand2321_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2323  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2323	= { FOLLOW_formula_in_mainCommand2323_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_mainCommand2326  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_mainCommand2326_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_mainCommand2326	= { FOLLOW_RBRACKET_in_mainCommand2326_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DBG_TOK_in_mainCommand2345  */
static	ANTLR3_BITWORD FOLLOW_DBG_TOK_in_mainCommand2345_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DBG_TOK_in_mainCommand2345	= { FOLLOW_DBG_TOK_in_mainCommand2345_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2355  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2355_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2355	= { FOLLOW_str_in_mainCommand2355_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2360  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2360	= { FOLLOW_IDENTIFIER_in_mainCommand2360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRACE_TOK_in_mainCommand2393  */
static	ANTLR3_BITWORD FOLLOW_TRACE_TOK_in_mainCommand2393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_TRACE_TOK_in_mainCommand2393	= { FOLLOW_TRACE_TOK_in_mainCommand2393_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2403  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2403	= { FOLLOW_str_in_mainCommand2403_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2408  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2408_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2408	= { FOLLOW_IDENTIFIER_in_mainCommand2408_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTRACE_TOK_in_mainCommand2440  */
static	ANTLR3_BITWORD FOLLOW_UNTRACE_TOK_in_mainCommand2440_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTRACE_TOK_in_mainCommand2440	= { FOLLOW_UNTRACE_TOK_in_mainCommand2440_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2450  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2450_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2450	= { FOLLOW_str_in_mainCommand2450_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2455  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2455_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2455	= { FOLLOW_IDENTIFIER_in_mainCommand2455_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HELP_TOK_in_mainCommand2488  */
static	ANTLR3_BITWORD FOLLOW_HELP_TOK_in_mainCommand2488_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_HELP_TOK_in_mainCommand2488	= { FOLLOW_HELP_TOK_in_mainCommand2488_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2498  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2498_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2498	= { FOLLOW_str_in_mainCommand2498_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2503  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2503	= { FOLLOW_IDENTIFIER_in_mainCommand2503_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRANSFORM_TOK_in_mainCommand2536  */
static	ANTLR3_BITWORD FOLLOW_TRANSFORM_TOK_in_mainCommand2536_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_TRANSFORM_TOK_in_mainCommand2536	= { FOLLOW_TRANSFORM_TOK_in_mainCommand2536_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2538  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2538	= { FOLLOW_formula_in_mainCommand2538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TOK_in_mainCommand2552  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TOK_in_mainCommand2552_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TOK_in_mainCommand2552	= { FOLLOW_PRINT_TOK_in_mainCommand2552_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2554  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2554_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2554	= { FOLLOW_formula_in_mainCommand2554_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PRINT_TYPE_TOK_in_mainCommand2567  */
static	ANTLR3_BITWORD FOLLOW_PRINT_TYPE_TOK_in_mainCommand2567_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_PRINT_TYPE_TOK_in_mainCommand2567	= { FOLLOW_PRINT_TYPE_TOK_in_mainCommand2567_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_mainCommand2569  */
static	ANTLR3_BITWORD FOLLOW_type_in_mainCommand2569_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_mainCommand2569	= { FOLLOW_type_in_mainCommand2569_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CALL_TOK_in_mainCommand2583  */
static	ANTLR3_BITWORD FOLLOW_CALL_TOK_in_mainCommand2583_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_CALL_TOK_in_mainCommand2583	= { FOLLOW_CALL_TOK_in_mainCommand2583_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_mainCommand2585  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_mainCommand2585_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_mainCommand2585	= { FOLLOW_identifier_in_mainCommand2585_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2588  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2588_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2588	= { FOLLOW_formula_in_mainCommand2588_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_mainCommand2602  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_mainCommand2602_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000008002), ANTLR3_UINT64_LIT(0x0200106000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_mainCommand2602	= { FOLLOW_ECHO_TOK_in_mainCommand2602_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_mainCommand2610  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_mainCommand2610_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_mainCommand2610	= { FOLLOW_simpleSymbolicExpr_in_mainCommand2610_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_mainCommand2640  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_mainCommand2640_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_mainCommand2640	= { FOLLOW_EXIT_TOK_in_mainCommand2640_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_mainCommand2653  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_mainCommand2653_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000004000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_mainCommand2653	= { FOLLOW_INCLUDE_TOK_in_mainCommand2653_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_mainCommand2663  */
static	ANTLR3_BITWORD FOLLOW_str_in_mainCommand2663_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_mainCommand2663	= { FOLLOW_str_in_mainCommand2663_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_mainCommand2668  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_mainCommand2668_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_mainCommand2668	= { FOLLOW_IDENTIFIER_in_mainCommand2668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DUMP_PROOF_TOK_in_mainCommand2701  */
static	ANTLR3_BITWORD FOLLOW_DUMP_PROOF_TOK_in_mainCommand2701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DUMP_PROOF_TOK_in_mainCommand2701	= { FOLLOW_DUMP_PROOF_TOK_in_mainCommand2701_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand2714  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand2714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand2714	= { FOLLOW_set_in_mainCommand2714_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_mainCommand2785  */
static	ANTLR3_BITWORD FOLLOW_set_in_mainCommand2785_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_mainCommand2785	= { FOLLOW_set_in_mainCommand2785_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand2810  */
static	ANTLR3_BITWORD FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand2810_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand2810	= { FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand2810_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COUNTERMODEL_TOK_in_mainCommand2822  */
static	ANTLR3_BITWORD FOLLOW_COUNTERMODEL_TOK_in_mainCommand2822_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COUNTERMODEL_TOK_in_mainCommand2822	= { FOLLOW_COUNTERMODEL_TOK_in_mainCommand2822_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand2835  */
static	ANTLR3_BITWORD FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand2835_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand2835	= { FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand2835_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_mainCommand2837  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_mainCommand2837_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_mainCommand2837	= { FOLLOW_LPAREN_in_mainCommand2837_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2839  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2839_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2839	= { FOLLOW_formula_in_mainCommand2839_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_mainCommand2844  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_mainCommand2844_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_mainCommand2844	= { FOLLOW_COMMA_in_mainCommand2844_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_mainCommand2846  */
static	ANTLR3_BITWORD FOLLOW_formula_in_mainCommand2846_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_mainCommand2846	= { FOLLOW_formula_in_mainCommand2846_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_mainCommand2852  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_mainCommand2852_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_mainCommand2852	= { FOLLOW_RPAREN_in_mainCommand2852_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_toplevelDeclaration_in_mainCommand2865  */
static	ANTLR3_BITWORD FOLLOW_toplevelDeclaration_in_mainCommand2865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_toplevelDeclaration_in_mainCommand2865	= { FOLLOW_toplevelDeclaration_in_mainCommand2865_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2885  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2885_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2885	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2885_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_simpleSymbolicExpr2897  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_simpleSymbolicExpr2897_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_simpleSymbolicExpr2897	= { FOLLOW_MINUS_TOK_in_simpleSymbolicExpr2897_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2899  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2899	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2899_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr2911  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr2911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr2911	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr2911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr2923  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr2923_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr2923	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr2923_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr2935  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr2935_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr2935	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr2935_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExpr2947  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExpr2947_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExpr2947	= { FOLLOW_str_in_simpleSymbolicExpr2947_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_simpleSymbolicExpr2960  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_simpleSymbolicExpr2960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_simpleSymbolicExpr2960	= { FOLLOW_IDENTIFIER_in_simpleSymbolicExpr2960_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr2985  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr2985_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr2985	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr2985_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_symbolicExpr2992  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_symbolicExpr2992_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000008000), ANTLR3_UINT64_LIT(0x0240106000000000), ANTLR3_UINT64_LIT(0x0000000100020000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_symbolicExpr2992	= { FOLLOW_LPAREN_in_symbolicExpr2992_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr2995  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr2995_bits[]	= { ANTLR3_UINT64_LIT(0x2000000000008000), ANTLR3_UINT64_LIT(0x0240106000000000), ANTLR3_UINT64_LIT(0x0000000100020000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr2995	= { FOLLOW_symbolicExpr_in_symbolicExpr2995_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_symbolicExpr3003  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_symbolicExpr3003_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_symbolicExpr3003	= { FOLLOW_RPAREN_in_symbolicExpr3003_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_toplevelDeclaration3030  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_toplevelDeclaration3030_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_toplevelDeclaration3030	= { FOLLOW_identifierList_in_toplevelDeclaration3030_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_toplevelDeclaration3033  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_toplevelDeclaration3033_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000020A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_toplevelDeclaration3033	= { FOLLOW_COLON_in_toplevelDeclaration3033_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_toplevelDeclaration3041  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_toplevelDeclaration3041_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_toplevelDeclaration3041	= { FOLLOW_declareVariables_in_toplevelDeclaration3041_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareTypes_in_toplevelDeclaration3050  */
static	ANTLR3_BITWORD FOLLOW_declareTypes_in_toplevelDeclaration3050_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareTypes_in_toplevelDeclaration3050	= { FOLLOW_declareTypes_in_toplevelDeclaration3050_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDecl3069  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDecl3069_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDecl3069	= { FOLLOW_identifierList_in_boundVarDecl3069_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDecl3072  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDecl3072_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDecl3072	= { FOLLOW_COLON_in_boundVarDecl3072_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_declareVariables_in_boundVarDecl3074  */
static	ANTLR3_BITWORD FOLLOW_declareVariables_in_boundVarDecl3074_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_declareVariables_in_boundVarDecl3074	= { FOLLOW_declareVariables_in_boundVarDecl3074_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3095  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3095_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3095	= { FOLLOW_boundVarDecl_in_boundVarDecls3095_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDecls3100  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDecls3100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDecls3100	= { FOLLOW_COMMA_in_boundVarDecls3100_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_boundVarDecls3102  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_boundVarDecls3102_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_boundVarDecls3102	= { FOLLOW_boundVarDecl_in_boundVarDecls3102_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3125  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3125_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3125	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3125_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_boundVarDeclsReturn3130  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_boundVarDeclsReturn3130_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_boundVarDeclsReturn3130	= { FOLLOW_COMMA_in_boundVarDeclsReturn3130_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3132  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3132_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3132	= { FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3132_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifierList_in_boundVarDeclReturn3155  */
static	ANTLR3_BITWORD FOLLOW_identifierList_in_boundVarDeclReturn3155_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifierList_in_boundVarDeclReturn3155	= { FOLLOW_identifierList_in_boundVarDeclReturn3155_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_boundVarDeclReturn3158  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_boundVarDeclReturn3158_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_boundVarDeclReturn3158	= { FOLLOW_COLON_in_boundVarDeclReturn3158_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_boundVarDeclReturn3160  */
static	ANTLR3_BITWORD FOLLOW_type_in_boundVarDeclReturn3160_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_boundVarDeclReturn3160	= { FOLLOW_type_in_boundVarDeclReturn3160_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3194  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3194_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3194	= { FOLLOW_TYPE_TOK_in_declareTypes3194_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_declareTypes3213  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_declareTypes3213_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_declareTypes3213	= { FOLLOW_TYPE_TOK_in_declareTypes3213_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareTypes3215  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareTypes3215_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareTypes3215	= { FOLLOW_EQUAL_TOK_in_declareTypes3215_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareTypes3217  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareTypes3217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareTypes3217	= { FOLLOW_type_in_declareTypes3217_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_declareVariables3251  */
static	ANTLR3_BITWORD FOLLOW_type_in_declareVariables3251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_declareVariables3251	= { FOLLOW_type_in_declareVariables3251_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_declareVariables3256  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_declareVariables3256_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_declareVariables3256	= { FOLLOW_EQUAL_TOK_in_declareVariables3256_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_declareVariables3258  */
static	ANTLR3_BITWORD FOLLOW_formula_in_declareVariables3258_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_declareVariables3258	= { FOLLOW_formula_in_declareVariables3258_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3289  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3289_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3289	= { FOLLOW_identifier_in_identifierList3289_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_identifierList3300  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_identifierList3300_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_identifierList3300	= { FOLLOW_COMMA_in_identifierList3300_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_identifierList3302  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_identifierList3302_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_identifierList3302	= { FOLLOW_identifier_in_identifierList3302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IDENTIFIER_in_identifier3324  */
static	ANTLR3_BITWORD FOLLOW_IDENTIFIER_in_identifier3324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IDENTIFIER_in_identifier3324	= { FOLLOW_IDENTIFIER_in_identifier3324_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3357  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3357_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000202) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3357	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3357_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARROW_TOK_in_type3372  */
static	ANTLR3_BITWORD FOLLOW_ARROW_TOK_in_type3372_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARROW_TOK_in_type3372	= { FOLLOW_ARROW_TOK_in_type3372_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3374  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3374	= { FOLLOW_type_in_type3374_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_type3399  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_type3399_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_type3399	= { FOLLOW_LET_TOK_in_type3399_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3407  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3407_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3407	= { FOLLOW_typeLetDecl_in_type3407_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_type3412  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_type3412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_type3412	= { FOLLOW_COMMA_in_type3412_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeLetDecl_in_type3414  */
static	ANTLR3_BITWORD FOLLOW_typeLetDecl_in_type3414_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_typeLetDecl_in_type3414	= { FOLLOW_typeLetDecl_in_type3414_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_type3420  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_type3420_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_type3420	= { FOLLOW_IN_TOK_in_type3420_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_type3422  */
static	ANTLR3_BITWORD FOLLOW_type_in_type3422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_type3422	= { FOLLOW_type_in_type3422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3458  */
static	ANTLR3_BITWORD FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3458_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3458	= { FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3458_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3492  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3492_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3492	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3492_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3499  */
static	ANTLR3_BITWORD FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3499_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3499	= { FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3499_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3520  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3520_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0044204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3520	= { FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3520_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3522  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3522_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3522	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3522_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3525  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3525_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0044204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3525	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3525_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3527  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3527_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3527	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3527_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3540  */
static	ANTLR3_BITWORD FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3540_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3540	= { FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3540_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3542  */
static	ANTLR3_BITWORD FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3542_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0044204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3542	= { FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3542_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3544  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3544_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3544	= { FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3544_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3564  */
static	ANTLR3_BITWORD FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3564_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3564	= { FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3564_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3566  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3566_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3566	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3566_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3584  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3584_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3584	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3584_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3589  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3589_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3589	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3589_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3591  */
static	ANTLR3_BITWORD FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3591_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3591	= { FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3591_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3597  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3597_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3597	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3597_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3616  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200100000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3616	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3616_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3620  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3620_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000010) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3620	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3620_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3622  */
static	ANTLR3_BITWORD FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3622_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0200100000000000), ANTLR3_UINT64_LIT(0x0000040000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3622	= { FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3622_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3626  */
static	ANTLR3_BITWORD FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3626_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3626	= { FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3626_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3628  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3628_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3628	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3628_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3647  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01206000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3647	= { FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3647_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3651  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3651_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3651	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3651_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3662  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3662_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3662	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3662_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3664  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3664_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3664	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3664_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3675  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3675	= { FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3675_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS3694  */
static	ANTLR3_BITWORD FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS3694_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004400000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS3694	= { FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS3694_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3698  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3698_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3698	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3698_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3701  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3701	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3701_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3703  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3703_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000400000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3703	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3703_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3714  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3714_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3714	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3714_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3716  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3716_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3716	= { FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3716_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3719  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3719_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3719	= { FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3719_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3721  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3721_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000400000000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3721	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3721_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS3732  */
static	ANTLR3_BITWORD FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS3732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS3732	= { FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS3732_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS3751  */
static	ANTLR3_BITWORD FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS3751_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS3751	= { FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS3751_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3753  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3753_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3753	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3753_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS3757  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS3757_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS3757	= { FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS3757_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3759  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3759_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3759	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS3778  */
static	ANTLR3_BITWORD FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS3778_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS3778	= { FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS3778_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS3793  */
static	ANTLR3_BITWORD FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS3793_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS3793	= { FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS3793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS3801  */
static	ANTLR3_BITWORD FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS3801_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS3801	= { FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS3801_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS3809  */
static	ANTLR3_BITWORD FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS3809_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS3809	= { FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS3809_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3824  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3824_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3824	= { FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3824_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3826  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3826_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3826	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3826_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3837  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3837	= { FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3837_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3839  */
static	ANTLR3_BITWORD FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3839_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3839	= { FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3839_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3847  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3847_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3847	= { FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3847_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_parameterization3872  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_parameterization3872_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0044204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_parameterization3872	= { FOLLOW_LBRACKET_in_parameterization3872_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization3874  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization3874_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization3874	= { FOLLOW_restrictedType_in_parameterization3874_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_parameterization3885  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_parameterization3885_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0044204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_parameterization3885	= { FOLLOW_COMMA_in_parameterization3885_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_parameterization3887  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_parameterization3887_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_parameterization3887	= { FOLLOW_restrictedType_in_parameterization3887_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_parameterization3895  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_parameterization3895_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_parameterization3895	= { FOLLOW_RBRACKET_in_parameterization3895_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNDERSCORE_in_bound3912  */
static	ANTLR3_BITWORD FOLLOW_UNDERSCORE_in_bound3912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_UNDERSCORE_in_bound3912	= { FOLLOW_UNDERSCORE_in_bound3912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_integer_in_bound3922  */
static	ANTLR3_BITWORD FOLLOW_integer_in_bound3922_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_integer_in_bound3922	= { FOLLOW_integer_in_bound3922_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_typeLetDecl3941  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_typeLetDecl3941_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_typeLetDecl3941	= { FOLLOW_identifier_in_typeLetDecl3941_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeLetDecl3945  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeLetDecl3945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000020000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeLetDecl3945	= { FOLLOW_COLON_in_typeLetDecl3945_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TYPE_TOK_in_typeLetDecl3947  */
static	ANTLR3_BITWORD FOLLOW_TYPE_TOK_in_typeLetDecl3947_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_TYPE_TOK_in_typeLetDecl3947	= { FOLLOW_TYPE_TOK_in_typeLetDecl3947_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_typeLetDecl3951  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_typeLetDecl3951_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0044204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_typeLetDecl3951	= { FOLLOW_EQUAL_TOK_in_typeLetDecl3951_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_restrictedType_in_typeLetDecl3953  */
static	ANTLR3_BITWORD FOLLOW_restrictedType_in_typeLetDecl3953_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_restrictedType_in_typeLetDecl3953	= { FOLLOW_restrictedType_in_typeLetDecl3953_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_formula3983  */
static	ANTLR3_BITWORD FOLLOW_nots_in_formula3983_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0263916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_formula3983	= { FOLLOW_nots_in_formula3983_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_formula3991  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_formula3991_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_formula3991	= { FOLLOW_prefixFormula_in_formula3991_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_formula4008  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_formula4008_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x8000028000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_formula4008	= { FOLLOW_comparison_in_formula4008_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_formula4025  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_formula4025_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_formula4025	= { FOLLOW_morecomparisons_in_formula4025_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_booleanBinop_in_morecomparisons4064  */
static	ANTLR3_BITWORD FOLLOW_booleanBinop_in_morecomparisons4064_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_booleanBinop_in_morecomparisons4064	= { FOLLOW_booleanBinop_in_morecomparisons4064_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nots_in_morecomparisons4075  */
static	ANTLR3_BITWORD FOLLOW_nots_in_morecomparisons4075_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0263916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_nots_in_morecomparisons4075	= { FOLLOW_nots_in_morecomparisons4075_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_prefixFormula_in_morecomparisons4083  */
static	ANTLR3_BITWORD FOLLOW_prefixFormula_in_morecomparisons4083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_prefixFormula_in_morecomparisons4083	= { FOLLOW_prefixFormula_in_morecomparisons4083_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparison_in_morecomparisons4100  */
static	ANTLR3_BITWORD FOLLOW_comparison_in_morecomparisons4100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000042), ANTLR3_UINT64_LIT(0x8000028000000000), ANTLR3_UINT64_LIT(0x0000800000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_comparison_in_morecomparisons4100	= { FOLLOW_comparison_in_morecomparisons4100_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_morecomparisons_in_morecomparisons4117  */
static	ANTLR3_BITWORD FOLLOW_morecomparisons_in_morecomparisons4117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_morecomparisons_in_morecomparisons4117	= { FOLLOW_morecomparisons_in_morecomparisons4117_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_nots4146  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_nots4146_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0800000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_nots4146	= { FOLLOW_NOT_TOK_in_nots4146_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_prefixFormula4178  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_prefixFormula4178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_prefixFormula4178	= { FOLLOW_FORALL_TOK_in_prefixFormula4178_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_prefixFormula4184  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_prefixFormula4184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_prefixFormula4184	= { FOLLOW_EXISTS_TOK_in_prefixFormula4184_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4196  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4196	= { FOLLOW_LPAREN_in_prefixFormula4196_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4202  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4202_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4202	= { FOLLOW_boundVarDecl_in_prefixFormula4202_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4217  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4217	= { FOLLOW_COMMA_in_prefixFormula4217_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4219  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4219_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4219	= { FOLLOW_boundVarDecl_in_prefixFormula4219_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4237  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4237_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4237	= { FOLLOW_RPAREN_in_prefixFormula4237_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4245  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4245_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0003) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4245	= { FOLLOW_COLON_in_prefixFormula4245_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_instantiationPatterns_in_prefixFormula4247  */
static	ANTLR3_BITWORD FOLLOW_instantiationPatterns_in_prefixFormula4247_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_instantiationPatterns_in_prefixFormula4247	= { FOLLOW_instantiationPatterns_in_prefixFormula4247_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4251  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4251_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4251	= { FOLLOW_formula_in_prefixFormula4251_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_prefixFormula4270  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_prefixFormula4270_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_prefixFormula4270	= { FOLLOW_LET_TOK_in_prefixFormula4270_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4278  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4278_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4278	= { FOLLOW_letDecl_in_prefixFormula4278_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_prefixFormula4282  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_prefixFormula4282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_prefixFormula4282	= { FOLLOW_COMMA_in_prefixFormula4282_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_prefixFormula4284  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_prefixFormula4284_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_prefixFormula4284	= { FOLLOW_letDecl_in_prefixFormula4284_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IN_TOK_in_prefixFormula4293  */
static	ANTLR3_BITWORD FOLLOW_IN_TOK_in_prefixFormula4293_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_IN_TOK_in_prefixFormula4293	= { FOLLOW_IN_TOK_in_prefixFormula4293_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4295  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4295_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4295	= { FOLLOW_formula_in_prefixFormula4295_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LAMBDA_in_prefixFormula4310  */
static	ANTLR3_BITWORD FOLLOW_LAMBDA_in_prefixFormula4310_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LAMBDA_in_prefixFormula4310	= { FOLLOW_LAMBDA_in_prefixFormula4310_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4314  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4314	= { FOLLOW_LPAREN_in_prefixFormula4314_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDeclsReturn_in_prefixFormula4320  */
static	ANTLR3_BITWORD FOLLOW_boundVarDeclsReturn_in_prefixFormula4320_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDeclsReturn_in_prefixFormula4320	= { FOLLOW_boundVarDeclsReturn_in_prefixFormula4320_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4327  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4327_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4327	= { FOLLOW_RPAREN_in_prefixFormula4327_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4329  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4329_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4329	= { FOLLOW_COLON_in_prefixFormula4329_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4331  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4331_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4331	= { FOLLOW_formula_in_prefixFormula4331_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ARRAY_TOK_in_prefixFormula4351  */
static	ANTLR3_BITWORD FOLLOW_ARRAY_TOK_in_prefixFormula4351_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ARRAY_TOK_in_prefixFormula4351	= { FOLLOW_ARRAY_TOK_in_prefixFormula4351_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_prefixFormula4355  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_prefixFormula4355_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_prefixFormula4355	= { FOLLOW_LPAREN_in_prefixFormula4355_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_boundVarDecl_in_prefixFormula4361  */
static	ANTLR3_BITWORD FOLLOW_boundVarDecl_in_prefixFormula4361_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_boundVarDecl_in_prefixFormula4361	= { FOLLOW_boundVarDecl_in_prefixFormula4361_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_prefixFormula4364  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_prefixFormula4364_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_prefixFormula4364	= { FOLLOW_RPAREN_in_prefixFormula4364_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_prefixFormula4366  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_prefixFormula4366_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_prefixFormula4366	= { FOLLOW_COLON_in_prefixFormula4366_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_prefixFormula4368  */
static	ANTLR3_BITWORD FOLLOW_formula_in_prefixFormula4368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_prefixFormula4368	= { FOLLOW_formula_in_prefixFormula4368_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PATTERN_TOK_in_instantiationPatterns4396  */
static	ANTLR3_BITWORD FOLLOW_PATTERN_TOK_in_instantiationPatterns4396_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PATTERN_TOK_in_instantiationPatterns4396	= { FOLLOW_PATTERN_TOK_in_instantiationPatterns4396_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_instantiationPatterns4398  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_instantiationPatterns4398_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_instantiationPatterns4398	= { FOLLOW_LPAREN_in_instantiationPatterns4398_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4400  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4400_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4400	= { FOLLOW_formula_in_instantiationPatterns4400_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_instantiationPatterns4406  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_instantiationPatterns4406_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_instantiationPatterns4406	= { FOLLOW_COMMA_in_instantiationPatterns4406_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_instantiationPatterns4408  */
static	ANTLR3_BITWORD FOLLOW_formula_in_instantiationPatterns4408_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_instantiationPatterns4408	= { FOLLOW_formula_in_instantiationPatterns4408_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_instantiationPatterns4416  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_instantiationPatterns4416_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_instantiationPatterns4416	= { FOLLOW_RPAREN_in_instantiationPatterns4416_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_instantiationPatterns4418  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_instantiationPatterns4418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_instantiationPatterns4418	= { FOLLOW_COLON_in_instantiationPatterns4418_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_letDecl4455  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_letDecl4455_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_letDecl4455	= { FOLLOW_identifier_in_letDecl4455_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_letDecl4458  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_letDecl4458_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_letDecl4458	= { FOLLOW_EQUAL_TOK_in_letDecl4458_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_letDecl4460  */
static	ANTLR3_BITWORD FOLLOW_formula_in_letDecl4460_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_letDecl4460	= { FOLLOW_formula_in_letDecl4460_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4529  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4529_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000002), ANTLR3_UINT64_LIT(0x0190000108040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4529	= { FOLLOW_term_in_comparison4529_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_comparisonBinop_in_comparison4540  */
static	ANTLR3_BITWORD FOLLOW_comparisonBinop_in_comparison4540_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0242916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_comparisonBinop_in_comparison4540	= { FOLLOW_comparisonBinop_in_comparison4540_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_comparison4543  */
static	ANTLR3_BITWORD FOLLOW_term_in_comparison4543_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000002), ANTLR3_UINT64_LIT(0x0190000108040000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_comparison4543	= { FOLLOW_term_in_comparison4543_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_storeTerm_in_term4635  */
static	ANTLR3_BITWORD FOLLOW_storeTerm_in_term4635_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0600080000400004), ANTLR3_UINT64_LIT(0x0000000010000004) };
static  ANTLR3_BITSET_LIST FOLLOW_storeTerm_in_term4635	= { FOLLOW_storeTerm_in_term4635_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arithmeticBinop_in_term4646  */
static	ANTLR3_BITWORD FOLLOW_arithmeticBinop_in_term4646_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0242916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_arithmeticBinop_in_term4646	= { FOLLOW_arithmeticBinop_in_term4646_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_storeTerm_in_term4649  */
static	ANTLR3_BITWORD FOLLOW_storeTerm_in_term4649_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0600080000400004), ANTLR3_UINT64_LIT(0x0000000010000004) };
static  ANTLR3_BITSET_LIST FOLLOW_storeTerm_in_term4649	= { FOLLOW_storeTerm_in_term4649_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_storeTerm4732  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_storeTerm4732_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000400000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_storeTerm4732	= { FOLLOW_uminusTerm_in_storeTerm4732_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_WITH_TOK_in_storeTerm4741  */
static	ANTLR3_BITWORD FOLLOW_WITH_TOK_in_storeTerm4741_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_WITH_TOK_in_storeTerm4741	= { FOLLOW_WITH_TOK_in_storeTerm4741_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_storeTerm4751  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_storeTerm4751_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_storeTerm4751	= { FOLLOW_arrayStore_in_storeTerm4751_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_storeTerm4756  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_storeTerm4756_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_storeTerm4756	= { FOLLOW_COMMA_in_storeTerm4756_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_arrayStore_in_storeTerm4758  */
static	ANTLR3_BITWORD FOLLOW_arrayStore_in_storeTerm4758_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_arrayStore_in_storeTerm4758	= { FOLLOW_arrayStore_in_storeTerm4758_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_storeTerm4772  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_storeTerm4772_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000104000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_storeTerm4772	= { FOLLOW_DOT_in_storeTerm4772_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_storeTerm4776  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_storeTerm4776_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_storeTerm4776	= { FOLLOW_tupleStore_in_storeTerm4776_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_storeTerm4781  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_storeTerm4781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_storeTerm4781	= { FOLLOW_COMMA_in_storeTerm4781_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_storeTerm4783  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_storeTerm4783_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_storeTerm4783	= { FOLLOW_DOT_in_storeTerm4783_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_tupleStore_in_storeTerm4785  */
static	ANTLR3_BITWORD FOLLOW_tupleStore_in_storeTerm4785_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_tupleStore_in_storeTerm4785	= { FOLLOW_tupleStore_in_storeTerm4785_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_storeTerm4805  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_storeTerm4805_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_storeTerm4805	= { FOLLOW_recordStore_in_storeTerm4805_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_storeTerm4810  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_storeTerm4810_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000008) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_storeTerm4810	= { FOLLOW_COMMA_in_storeTerm4810_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_storeTerm4812  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_storeTerm4812_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_storeTerm4812	= { FOLLOW_DOT_in_storeTerm4812_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordStore_in_storeTerm4814  */
static	ANTLR3_BITWORD FOLLOW_recordStore_in_storeTerm4814_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_recordStore_in_storeTerm4814	= { FOLLOW_recordStore_in_storeTerm4814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_arrayStore4859  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_arrayStore4859_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_arrayStore4859	= { FOLLOW_LBRACKET_in_arrayStore4859_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_arrayStore4861  */
static	ANTLR3_BITWORD FOLLOW_formula_in_arrayStore4861_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_arrayStore4861	= { FOLLOW_formula_in_arrayStore4861_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_arrayStore4866  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_arrayStore4866_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000), ANTLR3_UINT64_LIT(0x0004000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_arrayStore4866	= { FOLLOW_RBRACKET_in_arrayStore4866_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_arrayStore4875  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_arrayStore4875_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0242916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_arrayStore4875	= { FOLLOW_ASSIGN_TOK_in_arrayStore4875_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_arrayStore4877  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_arrayStore4877_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_arrayStore4877	= { FOLLOW_uminusTerm_in_arrayStore4877_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_tupleStore4907  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_tupleStore4907_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_tupleStore4907	= { FOLLOW_numeral_in_tupleStore4907_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_tupleStore4909  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_tupleStore4909_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0242916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_tupleStore4909	= { FOLLOW_ASSIGN_TOK_in_tupleStore4909_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_tupleStore4911  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_tupleStore4911_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_tupleStore4911	= { FOLLOW_uminusTerm_in_tupleStore4911_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordStore4939  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordStore4939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordStore4939	= { FOLLOW_identifier_in_recordStore4939_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordStore4942  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordStore4942_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0242916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordStore4942	= { FOLLOW_ASSIGN_TOK_in_recordStore4942_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_uminusTerm_in_recordStore4944  */
static	ANTLR3_BITWORD FOLLOW_uminusTerm_in_recordStore4944_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_uminusTerm_in_recordStore4944	= { FOLLOW_uminusTerm_in_recordStore4944_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_uminusTerm4979  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_uminusTerm4979_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0242916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_uminusTerm4979	= { FOLLOW_MINUS_TOK_in_uminusTerm4979_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm4985  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm4985_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm4985	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm4985_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinaryOpTerm_in_uminusTerm4998  */
static	ANTLR3_BITWORD FOLLOW_bvBinaryOpTerm_in_uminusTerm4998_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinaryOpTerm_in_uminusTerm4998	= { FOLLOW_bvBinaryOpTerm_in_uminusTerm4998_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5020  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5020_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5020	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5020_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvBinop_in_bvBinaryOpTerm5031  */
static	ANTLR3_BITWORD FOLLOW_bvBinop_in_bvBinaryOpTerm5031_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0042916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_bvBinop_in_bvBinaryOpTerm5031	= { FOLLOW_bvBinop_in_bvBinaryOpTerm5031_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvBinaryOpTerm5034  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvBinaryOpTerm5034_bits[]	= { ANTLR3_UINT64_LIT(0x0080000000044002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvBinaryOpTerm5034	= { FOLLOW_bvNegTerm_in_bvBinaryOpTerm5034_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNEG_TOK_in_bvNegTerm5097  */
static	ANTLR3_BITWORD FOLLOW_BVNEG_TOK_in_bvNegTerm5097_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88010), ANTLR3_UINT64_LIT(0x0042916001800003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNEG_TOK_in_bvNegTerm5097	= { FOLLOW_BVNEG_TOK_in_bvNegTerm5097_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvNegTerm_in_bvNegTerm5099  */
static	ANTLR3_BITWORD FOLLOW_bvNegTerm_in_bvNegTerm5099_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_bvNegTerm_in_bvNegTerm5099	= { FOLLOW_bvNegTerm_in_bvNegTerm5099_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_postfixTerm_in_bvNegTerm5112  */
static	ANTLR3_BITWORD FOLLOW_postfixTerm_in_bvNegTerm5112_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_postfixTerm_in_bvNegTerm5112	= { FOLLOW_postfixTerm_in_bvNegTerm5112_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_bvTerm_in_postfixTerm5136  */
static	ANTLR3_BITWORD FOLLOW_bvTerm_in_postfixTerm5136_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x004C000000000008), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_bvTerm_in_postfixTerm5136	= { FOLLOW_bvTerm_in_postfixTerm5136_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_postfixTerm5153  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_postfixTerm5153_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_postfixTerm5153	= { FOLLOW_LBRACKET_in_postfixTerm5153_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5165  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5165_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5165	= { FOLLOW_formula_in_postfixTerm5165_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5182  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5182_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5182	= { FOLLOW_numeral_in_postfixTerm5182_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_postfixTerm5184  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_postfixTerm5184_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_postfixTerm5184	= { FOLLOW_COLON_in_postfixTerm5184_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5188  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5188_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5188	= { FOLLOW_numeral_in_postfixTerm5188_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_postfixTerm5200  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_postfixTerm5200_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x004C000000000008), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_postfixTerm5200	= { FOLLOW_RBRACKET_in_postfixTerm5200_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5227  */
static	ANTLR3_BITWORD FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5227	= { FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5227_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5239  */
static	ANTLR3_BITWORD FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5239_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5239	= { FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5239_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5247  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5247_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x004C000000000008), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5247	= { FOLLOW_numeral_in_postfixTerm5247_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5272  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5272_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5272	= { FOLLOW_LPAREN_in_postfixTerm5272_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5282  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5282_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5282	= { FOLLOW_formula_in_postfixTerm5282_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm5295  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm5295_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm5295	= { FOLLOW_COMMA_in_postfixTerm5295_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5297  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5297_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5297	= { FOLLOW_formula_in_postfixTerm5297_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5305  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5305_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x004C000000000008), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5305	= { FOLLOW_RPAREN_in_postfixTerm5305_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DOT_in_postfixTerm5337  */
static	ANTLR3_BITWORD FOLLOW_DOT_in_postfixTerm5337_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000104000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DOT_in_postfixTerm5337	= { FOLLOW_DOT_in_postfixTerm5337_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_postfixTerm5347  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_postfixTerm5347_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x004C000000000008), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_postfixTerm5347	= { FOLLOW_identifier_in_postfixTerm5347_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5370  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5370_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002), ANTLR3_UINT64_LIT(0x004C000000000008), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5370	= { FOLLOW_numeral_in_postfixTerm5370_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FLOOR_TOK_in_postfixTerm5403  */
static	ANTLR3_BITWORD FOLLOW_FLOOR_TOK_in_postfixTerm5403_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_FLOOR_TOK_in_postfixTerm5403	= { FOLLOW_FLOOR_TOK_in_postfixTerm5403_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5405  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5405_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5405	= { FOLLOW_LPAREN_in_postfixTerm5405_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5407  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5407_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5407	= { FOLLOW_formula_in_postfixTerm5407_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5410  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5410_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5410	= { FOLLOW_RPAREN_in_postfixTerm5410_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_INTEGER_TOK_in_postfixTerm5426  */
static	ANTLR3_BITWORD FOLLOW_IS_INTEGER_TOK_in_postfixTerm5426_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_INTEGER_TOK_in_postfixTerm5426	= { FOLLOW_IS_INTEGER_TOK_in_postfixTerm5426_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5428  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5428_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5428	= { FOLLOW_LPAREN_in_postfixTerm5428_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5430  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5430	= { FOLLOW_formula_in_postfixTerm5430_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5433  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5433_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5433	= { FOLLOW_RPAREN_in_postfixTerm5433_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ABS_TOK_in_postfixTerm5449  */
static	ANTLR3_BITWORD FOLLOW_ABS_TOK_in_postfixTerm5449_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ABS_TOK_in_postfixTerm5449	= { FOLLOW_ABS_TOK_in_postfixTerm5449_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5451  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5451_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5451	= { FOLLOW_LPAREN_in_postfixTerm5451_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5453  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5453_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5453	= { FOLLOW_formula_in_postfixTerm5453_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5456  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5456_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5456	= { FOLLOW_RPAREN_in_postfixTerm5456_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_postfixTerm5472  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_postfixTerm5472_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_postfixTerm5472	= { FOLLOW_DIVISIBLE_TOK_in_postfixTerm5472_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5474  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5474_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5474	= { FOLLOW_LPAREN_in_postfixTerm5474_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5476  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5476_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5476	= { FOLLOW_formula_in_postfixTerm5476_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm5479  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm5479_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm5479	= { FOLLOW_COMMA_in_postfixTerm5479_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_postfixTerm5483  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_postfixTerm5483_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_postfixTerm5483	= { FOLLOW_numeral_in_postfixTerm5483_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5485  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5485_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5485	= { FOLLOW_RPAREN_in_postfixTerm5485_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_postfixTerm5501  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_postfixTerm5501_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_postfixTerm5501	= { FOLLOW_DISTINCT_TOK_in_postfixTerm5501_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_postfixTerm5503  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_postfixTerm5503_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_postfixTerm5503	= { FOLLOW_LPAREN_in_postfixTerm5503_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5511  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5511_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5511	= { FOLLOW_formula_in_postfixTerm5511_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_postfixTerm5524  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_postfixTerm5524_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_postfixTerm5524	= { FOLLOW_COMMA_in_postfixTerm5524_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_postfixTerm5526  */
static	ANTLR3_BITWORD FOLLOW_formula_in_postfixTerm5526_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_postfixTerm5526	= { FOLLOW_formula_in_postfixTerm5526_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_postfixTerm5534  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_postfixTerm5534_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_postfixTerm5534	= { FOLLOW_RPAREN_in_postfixTerm5534_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_typeAscription_in_postfixTerm5556  */
static	ANTLR3_BITWORD FOLLOW_typeAscription_in_postfixTerm5556_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_typeAscription_in_postfixTerm5556	= { FOLLOW_typeAscription_in_postfixTerm5556_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXOR_TOK_in_bvTerm5597  */
static	ANTLR3_BITWORD FOLLOW_BVXOR_TOK_in_bvTerm5597_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXOR_TOK_in_bvTerm5597	= { FOLLOW_BVXOR_TOK_in_bvTerm5597_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5599  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5599_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5599	= { FOLLOW_LPAREN_in_bvTerm5599_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5601  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5601_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5601	= { FOLLOW_formula_in_bvTerm5601_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5604  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5604_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5604	= { FOLLOW_COMMA_in_bvTerm5604_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5606  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5606_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5606	= { FOLLOW_formula_in_bvTerm5606_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5609  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5609_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5609	= { FOLLOW_RPAREN_in_bvTerm5609_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNAND_TOK_in_bvTerm5621  */
static	ANTLR3_BITWORD FOLLOW_BVNAND_TOK_in_bvTerm5621_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNAND_TOK_in_bvTerm5621	= { FOLLOW_BVNAND_TOK_in_bvTerm5621_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5623  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5623_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5623	= { FOLLOW_LPAREN_in_bvTerm5623_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5625  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5625_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5625	= { FOLLOW_formula_in_bvTerm5625_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5628  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5628_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5628	= { FOLLOW_COMMA_in_bvTerm5628_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5630  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5630_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5630	= { FOLLOW_formula_in_bvTerm5630_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5633  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5633	= { FOLLOW_RPAREN_in_bvTerm5633_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNOR_TOK_in_bvTerm5645  */
static	ANTLR3_BITWORD FOLLOW_BVNOR_TOK_in_bvTerm5645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNOR_TOK_in_bvTerm5645	= { FOLLOW_BVNOR_TOK_in_bvTerm5645_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5647  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5647_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5647	= { FOLLOW_LPAREN_in_bvTerm5647_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5649  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5649_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5649	= { FOLLOW_formula_in_bvTerm5649_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5652  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5652_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5652	= { FOLLOW_COMMA_in_bvTerm5652_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5654  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5654_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5654	= { FOLLOW_formula_in_bvTerm5654_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5657  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5657_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5657	= { FOLLOW_RPAREN_in_bvTerm5657_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVCOMP_TOK_in_bvTerm5669  */
static	ANTLR3_BITWORD FOLLOW_BVCOMP_TOK_in_bvTerm5669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVCOMP_TOK_in_bvTerm5669	= { FOLLOW_BVCOMP_TOK_in_bvTerm5669_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5671  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5671_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5671	= { FOLLOW_LPAREN_in_bvTerm5671_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5673  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5673_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5673	= { FOLLOW_formula_in_bvTerm5673_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5676  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5676_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5676	= { FOLLOW_COMMA_in_bvTerm5676_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5678  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5678_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5678	= { FOLLOW_formula_in_bvTerm5678_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5681  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5681_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5681	= { FOLLOW_RPAREN_in_bvTerm5681_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXNOR_TOK_in_bvTerm5693  */
static	ANTLR3_BITWORD FOLLOW_BVXNOR_TOK_in_bvTerm5693_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXNOR_TOK_in_bvTerm5693	= { FOLLOW_BVXNOR_TOK_in_bvTerm5693_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5695  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5695_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5695	= { FOLLOW_LPAREN_in_bvTerm5695_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5697  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5697_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5697	= { FOLLOW_formula_in_bvTerm5697_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5700  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5700_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5700	= { FOLLOW_COMMA_in_bvTerm5700_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5702  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5702_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5702	= { FOLLOW_formula_in_bvTerm5702_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5705  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5705_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5705	= { FOLLOW_RPAREN_in_bvTerm5705_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUMINUS_TOK_in_bvTerm5724  */
static	ANTLR3_BITWORD FOLLOW_BVUMINUS_TOK_in_bvTerm5724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUMINUS_TOK_in_bvTerm5724	= { FOLLOW_BVUMINUS_TOK_in_bvTerm5724_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5726  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5726_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5726	= { FOLLOW_LPAREN_in_bvTerm5726_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5728  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5728_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5728	= { FOLLOW_formula_in_bvTerm5728_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5731  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5731_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5731	= { FOLLOW_RPAREN_in_bvTerm5731_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVPLUS_TOK_in_bvTerm5749  */
static	ANTLR3_BITWORD FOLLOW_BVPLUS_TOK_in_bvTerm5749_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVPLUS_TOK_in_bvTerm5749	= { FOLLOW_BVPLUS_TOK_in_bvTerm5749_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5751  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5751_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5751	= { FOLLOW_LPAREN_in_bvTerm5751_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm5755  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm5755_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm5755	= { FOLLOW_numeral_in_bvTerm5755_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5757  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5757_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5757	= { FOLLOW_COMMA_in_bvTerm5757_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5759  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5759_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5759	= { FOLLOW_formula_in_bvTerm5759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5770  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5770_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5770	= { FOLLOW_COMMA_in_bvTerm5770_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5772  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5772_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5772	= { FOLLOW_formula_in_bvTerm5772_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5780  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5780_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5780	= { FOLLOW_RPAREN_in_bvTerm5780_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSUB_TOK_in_bvTerm5798  */
static	ANTLR3_BITWORD FOLLOW_BVSUB_TOK_in_bvTerm5798_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSUB_TOK_in_bvTerm5798	= { FOLLOW_BVSUB_TOK_in_bvTerm5798_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5800  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5800_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5800	= { FOLLOW_LPAREN_in_bvTerm5800_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm5804  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm5804_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm5804	= { FOLLOW_numeral_in_bvTerm5804_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5806  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5806_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5806	= { FOLLOW_COMMA_in_bvTerm5806_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5808  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5808_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5808	= { FOLLOW_formula_in_bvTerm5808_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5811  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5811_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5811	= { FOLLOW_COMMA_in_bvTerm5811_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5813  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5813	= { FOLLOW_formula_in_bvTerm5813_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5816  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5816_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5816	= { FOLLOW_RPAREN_in_bvTerm5816_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVMULT_TOK_in_bvTerm5834  */
static	ANTLR3_BITWORD FOLLOW_BVMULT_TOK_in_bvTerm5834_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVMULT_TOK_in_bvTerm5834	= { FOLLOW_BVMULT_TOK_in_bvTerm5834_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5836  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5836_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5836	= { FOLLOW_LPAREN_in_bvTerm5836_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm5840  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm5840_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm5840	= { FOLLOW_numeral_in_bvTerm5840_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5842  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5842_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5842	= { FOLLOW_COMMA_in_bvTerm5842_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5844  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5844_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5844	= { FOLLOW_formula_in_bvTerm5844_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5847  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5847_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5847	= { FOLLOW_COMMA_in_bvTerm5847_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5849  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5849	= { FOLLOW_formula_in_bvTerm5849_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5852  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5852_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5852	= { FOLLOW_RPAREN_in_bvTerm5852_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUDIV_TOK_in_bvTerm5870  */
static	ANTLR3_BITWORD FOLLOW_BVUDIV_TOK_in_bvTerm5870_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUDIV_TOK_in_bvTerm5870	= { FOLLOW_BVUDIV_TOK_in_bvTerm5870_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5872  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5872_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5872	= { FOLLOW_LPAREN_in_bvTerm5872_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5874  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5874_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5874	= { FOLLOW_formula_in_bvTerm5874_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5877  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5877_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5877	= { FOLLOW_COMMA_in_bvTerm5877_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5879  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5879_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5879	= { FOLLOW_formula_in_bvTerm5879_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5882  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5882_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5882	= { FOLLOW_RPAREN_in_bvTerm5882_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSDIV_TOK_in_bvTerm5900  */
static	ANTLR3_BITWORD FOLLOW_BVSDIV_TOK_in_bvTerm5900_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSDIV_TOK_in_bvTerm5900	= { FOLLOW_BVSDIV_TOK_in_bvTerm5900_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5902  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5902_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5902	= { FOLLOW_LPAREN_in_bvTerm5902_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5904  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5904_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5904	= { FOLLOW_formula_in_bvTerm5904_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5907  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5907_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5907	= { FOLLOW_COMMA_in_bvTerm5907_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5909  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5909_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5909	= { FOLLOW_formula_in_bvTerm5909_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5912  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5912	= { FOLLOW_RPAREN_in_bvTerm5912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUREM_TOK_in_bvTerm5930  */
static	ANTLR3_BITWORD FOLLOW_BVUREM_TOK_in_bvTerm5930_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUREM_TOK_in_bvTerm5930	= { FOLLOW_BVUREM_TOK_in_bvTerm5930_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5932  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5932_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5932	= { FOLLOW_LPAREN_in_bvTerm5932_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5934  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5934_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5934	= { FOLLOW_formula_in_bvTerm5934_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5937  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5937_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5937	= { FOLLOW_COMMA_in_bvTerm5937_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5939  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5939_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5939	= { FOLLOW_formula_in_bvTerm5939_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5942  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5942_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5942	= { FOLLOW_RPAREN_in_bvTerm5942_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSREM_TOK_in_bvTerm5960  */
static	ANTLR3_BITWORD FOLLOW_BVSREM_TOK_in_bvTerm5960_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSREM_TOK_in_bvTerm5960	= { FOLLOW_BVSREM_TOK_in_bvTerm5960_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5962  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5962_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5962	= { FOLLOW_LPAREN_in_bvTerm5962_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5964  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5964_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5964	= { FOLLOW_formula_in_bvTerm5964_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5967  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5967_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5967	= { FOLLOW_COMMA_in_bvTerm5967_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5969  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5969	= { FOLLOW_formula_in_bvTerm5969_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm5972  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm5972_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm5972	= { FOLLOW_RPAREN_in_bvTerm5972_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSMOD_TOK_in_bvTerm5990  */
static	ANTLR3_BITWORD FOLLOW_BVSMOD_TOK_in_bvTerm5990_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSMOD_TOK_in_bvTerm5990	= { FOLLOW_BVSMOD_TOK_in_bvTerm5990_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm5992  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm5992_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm5992	= { FOLLOW_LPAREN_in_bvTerm5992_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5994  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5994_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5994	= { FOLLOW_formula_in_bvTerm5994_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm5997  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm5997_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm5997	= { FOLLOW_COMMA_in_bvTerm5997_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm5999  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm5999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm5999	= { FOLLOW_formula_in_bvTerm5999_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6002  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6002_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6002	= { FOLLOW_RPAREN_in_bvTerm6002_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSHL_TOK_in_bvTerm6020  */
static	ANTLR3_BITWORD FOLLOW_BVSHL_TOK_in_bvTerm6020_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSHL_TOK_in_bvTerm6020	= { FOLLOW_BVSHL_TOK_in_bvTerm6020_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6022  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6022_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6022	= { FOLLOW_LPAREN_in_bvTerm6022_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6024  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6024_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6024	= { FOLLOW_formula_in_bvTerm6024_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6027  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6027_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6027	= { FOLLOW_COMMA_in_bvTerm6027_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6029  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6029	= { FOLLOW_formula_in_bvTerm6029_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6032  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6032_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6032	= { FOLLOW_RPAREN_in_bvTerm6032_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVASHR_TOK_in_bvTerm6050  */
static	ANTLR3_BITWORD FOLLOW_BVASHR_TOK_in_bvTerm6050_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVASHR_TOK_in_bvTerm6050	= { FOLLOW_BVASHR_TOK_in_bvTerm6050_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6052  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6052_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6052	= { FOLLOW_LPAREN_in_bvTerm6052_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6054  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6054_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6054	= { FOLLOW_formula_in_bvTerm6054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6057  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6057_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6057	= { FOLLOW_COMMA_in_bvTerm6057_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6059  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6059_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6059	= { FOLLOW_formula_in_bvTerm6059_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6062  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6062_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6062	= { FOLLOW_RPAREN_in_bvTerm6062_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLSHR_TOK_in_bvTerm6080  */
static	ANTLR3_BITWORD FOLLOW_BVLSHR_TOK_in_bvTerm6080_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLSHR_TOK_in_bvTerm6080	= { FOLLOW_BVLSHR_TOK_in_bvTerm6080_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6082  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6082_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6082	= { FOLLOW_LPAREN_in_bvTerm6082_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6084  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6084_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6084	= { FOLLOW_formula_in_bvTerm6084_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6087  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6087_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6087	= { FOLLOW_COMMA_in_bvTerm6087_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6089  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6089_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6089	= { FOLLOW_formula_in_bvTerm6089_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6092  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6092_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6092	= { FOLLOW_RPAREN_in_bvTerm6092_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SX_TOK_in_bvTerm6110  */
static	ANTLR3_BITWORD FOLLOW_SX_TOK_in_bvTerm6110_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SX_TOK_in_bvTerm6110	= { FOLLOW_SX_TOK_in_bvTerm6110_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6112  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6112_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6112	= { FOLLOW_LPAREN_in_bvTerm6112_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6114  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6114_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6114	= { FOLLOW_formula_in_bvTerm6114_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6117  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6117_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6117	= { FOLLOW_COMMA_in_bvTerm6117_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6121  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6121	= { FOLLOW_numeral_in_bvTerm6121_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6123  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6123_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6123	= { FOLLOW_RPAREN_in_bvTerm6123_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6141  */
static	ANTLR3_BITWORD FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6141_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6141	= { FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6141_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6143  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6143_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6143	= { FOLLOW_LPAREN_in_bvTerm6143_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6145  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6145_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6145	= { FOLLOW_formula_in_bvTerm6145_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6148  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6148	= { FOLLOW_COMMA_in_bvTerm6148_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6152  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6152_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6152	= { FOLLOW_numeral_in_bvTerm6152_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6154  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6154	= { FOLLOW_RPAREN_in_bvTerm6154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVREPEAT_TOK_in_bvTerm6172  */
static	ANTLR3_BITWORD FOLLOW_BVREPEAT_TOK_in_bvTerm6172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVREPEAT_TOK_in_bvTerm6172	= { FOLLOW_BVREPEAT_TOK_in_bvTerm6172_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6174  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6174_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6174	= { FOLLOW_LPAREN_in_bvTerm6174_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6176  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6176_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6176	= { FOLLOW_formula_in_bvTerm6176_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6179  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6179_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6179	= { FOLLOW_COMMA_in_bvTerm6179_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6183  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6183_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6183	= { FOLLOW_numeral_in_bvTerm6183_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6185  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6185_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6185	= { FOLLOW_RPAREN_in_bvTerm6185_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTR_TOK_in_bvTerm6203  */
static	ANTLR3_BITWORD FOLLOW_BVROTR_TOK_in_bvTerm6203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTR_TOK_in_bvTerm6203	= { FOLLOW_BVROTR_TOK_in_bvTerm6203_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6205  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6205_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6205	= { FOLLOW_LPAREN_in_bvTerm6205_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6207  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6207_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6207	= { FOLLOW_formula_in_bvTerm6207_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6210  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6210	= { FOLLOW_COMMA_in_bvTerm6210_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6214  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6214_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6214	= { FOLLOW_numeral_in_bvTerm6214_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6216  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6216_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6216	= { FOLLOW_RPAREN_in_bvTerm6216_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVROTL_TOK_in_bvTerm6234  */
static	ANTLR3_BITWORD FOLLOW_BVROTL_TOK_in_bvTerm6234_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVROTL_TOK_in_bvTerm6234	= { FOLLOW_BVROTL_TOK_in_bvTerm6234_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6236  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6236_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6236	= { FOLLOW_LPAREN_in_bvTerm6236_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6238  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6238_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6238	= { FOLLOW_formula_in_bvTerm6238_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6241  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6241_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6241	= { FOLLOW_COMMA_in_bvTerm6241_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_numeral_in_bvTerm6245  */
static	ANTLR3_BITWORD FOLLOW_numeral_in_bvTerm6245_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_numeral_in_bvTerm6245	= { FOLLOW_numeral_in_bvTerm6245_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6247  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6247	= { FOLLOW_RPAREN_in_bvTerm6247_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLT_TOK_in_bvTerm6266  */
static	ANTLR3_BITWORD FOLLOW_BVLT_TOK_in_bvTerm6266_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLT_TOK_in_bvTerm6266	= { FOLLOW_BVLT_TOK_in_bvTerm6266_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6268  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6268_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6268	= { FOLLOW_LPAREN_in_bvTerm6268_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6270  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6270_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6270	= { FOLLOW_formula_in_bvTerm6270_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6273  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6273_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6273	= { FOLLOW_COMMA_in_bvTerm6273_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6275  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6275	= { FOLLOW_formula_in_bvTerm6275_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6278  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6278_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6278	= { FOLLOW_RPAREN_in_bvTerm6278_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLE_TOK_in_bvTerm6290  */
static	ANTLR3_BITWORD FOLLOW_BVLE_TOK_in_bvTerm6290_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLE_TOK_in_bvTerm6290	= { FOLLOW_BVLE_TOK_in_bvTerm6290_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6292  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6292_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6292	= { FOLLOW_LPAREN_in_bvTerm6292_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6294  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6294_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6294	= { FOLLOW_formula_in_bvTerm6294_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6297  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6297_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6297	= { FOLLOW_COMMA_in_bvTerm6297_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6299  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6299_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6299	= { FOLLOW_formula_in_bvTerm6299_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6302  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6302	= { FOLLOW_RPAREN_in_bvTerm6302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGT_TOK_in_bvTerm6314  */
static	ANTLR3_BITWORD FOLLOW_BVGT_TOK_in_bvTerm6314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGT_TOK_in_bvTerm6314	= { FOLLOW_BVGT_TOK_in_bvTerm6314_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6316  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6316_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6316	= { FOLLOW_LPAREN_in_bvTerm6316_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6318  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6318_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6318	= { FOLLOW_formula_in_bvTerm6318_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6321  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6321_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6321	= { FOLLOW_COMMA_in_bvTerm6321_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6323  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6323_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6323	= { FOLLOW_formula_in_bvTerm6323_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6326  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6326_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6326	= { FOLLOW_RPAREN_in_bvTerm6326_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVGE_TOK_in_bvTerm6338  */
static	ANTLR3_BITWORD FOLLOW_BVGE_TOK_in_bvTerm6338_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVGE_TOK_in_bvTerm6338	= { FOLLOW_BVGE_TOK_in_bvTerm6338_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6340  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6340_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6340	= { FOLLOW_LPAREN_in_bvTerm6340_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6342  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6342_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6342	= { FOLLOW_formula_in_bvTerm6342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6345  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6345_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6345	= { FOLLOW_COMMA_in_bvTerm6345_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6347  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6347_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6347	= { FOLLOW_formula_in_bvTerm6347_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6350  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6350_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6350	= { FOLLOW_RPAREN_in_bvTerm6350_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLT_TOK_in_bvTerm6362  */
static	ANTLR3_BITWORD FOLLOW_BVSLT_TOK_in_bvTerm6362_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLT_TOK_in_bvTerm6362	= { FOLLOW_BVSLT_TOK_in_bvTerm6362_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6364  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6364_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6364	= { FOLLOW_LPAREN_in_bvTerm6364_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6366  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6366_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6366	= { FOLLOW_formula_in_bvTerm6366_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6369  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6369_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6369	= { FOLLOW_COMMA_in_bvTerm6369_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6371  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6371_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6371	= { FOLLOW_formula_in_bvTerm6371_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6374  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6374	= { FOLLOW_RPAREN_in_bvTerm6374_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLE_TOK_in_bvTerm6386  */
static	ANTLR3_BITWORD FOLLOW_BVSLE_TOK_in_bvTerm6386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLE_TOK_in_bvTerm6386	= { FOLLOW_BVSLE_TOK_in_bvTerm6386_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6388  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6388_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6388	= { FOLLOW_LPAREN_in_bvTerm6388_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6390  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6390_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6390	= { FOLLOW_formula_in_bvTerm6390_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6393  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6393_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6393	= { FOLLOW_COMMA_in_bvTerm6393_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6395  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6395	= { FOLLOW_formula_in_bvTerm6395_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6398  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6398	= { FOLLOW_RPAREN_in_bvTerm6398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGT_TOK_in_bvTerm6410  */
static	ANTLR3_BITWORD FOLLOW_BVSGT_TOK_in_bvTerm6410_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGT_TOK_in_bvTerm6410	= { FOLLOW_BVSGT_TOK_in_bvTerm6410_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6412  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6412_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6412	= { FOLLOW_LPAREN_in_bvTerm6412_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6414  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6414_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6414	= { FOLLOW_formula_in_bvTerm6414_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6417  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6417_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6417	= { FOLLOW_COMMA_in_bvTerm6417_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6419  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6419_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6419	= { FOLLOW_formula_in_bvTerm6419_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6422  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6422_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6422	= { FOLLOW_RPAREN_in_bvTerm6422_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGE_TOK_in_bvTerm6434  */
static	ANTLR3_BITWORD FOLLOW_BVSGE_TOK_in_bvTerm6434_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGE_TOK_in_bvTerm6434	= { FOLLOW_BVSGE_TOK_in_bvTerm6434_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_bvTerm6436  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_bvTerm6436_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_bvTerm6436	= { FOLLOW_LPAREN_in_bvTerm6436_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6438  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6438_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6438	= { FOLLOW_formula_in_bvTerm6438_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_bvTerm6441  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_bvTerm6441_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_bvTerm6441	= { FOLLOW_COMMA_in_bvTerm6441_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_bvTerm6443  */
static	ANTLR3_BITWORD FOLLOW_formula_in_bvTerm6443_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_bvTerm6443	= { FOLLOW_formula_in_bvTerm6443_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_bvTerm6446  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_bvTerm6446_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_bvTerm6446	= { FOLLOW_RPAREN_in_bvTerm6446_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_stringTerm_in_bvTerm6459  */
static	ANTLR3_BITWORD FOLLOW_stringTerm_in_bvTerm6459_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_stringTerm_in_bvTerm6459	= { FOLLOW_stringTerm_in_bvTerm6459_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SCONCAT_TOK_in_stringTerm6485  */
static	ANTLR3_BITWORD FOLLOW_SCONCAT_TOK_in_stringTerm6485_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SCONCAT_TOK_in_stringTerm6485	= { FOLLOW_SCONCAT_TOK_in_stringTerm6485_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6487  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6487_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6487	= { FOLLOW_LPAREN_in_stringTerm6487_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6489  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6489_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6489	= { FOLLOW_formula_in_stringTerm6489_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6500  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6500_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6500	= { FOLLOW_COMMA_in_stringTerm6500_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6502  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6502_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6502	= { FOLLOW_formula_in_stringTerm6502_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6510  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6510_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6510	= { FOLLOW_RPAREN_in_stringTerm6510_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SCONTAINS_TOK_in_stringTerm6522  */
static	ANTLR3_BITWORD FOLLOW_SCONTAINS_TOK_in_stringTerm6522_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SCONTAINS_TOK_in_stringTerm6522	= { FOLLOW_SCONTAINS_TOK_in_stringTerm6522_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6524  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6524_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6524	= { FOLLOW_LPAREN_in_stringTerm6524_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6526  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6526_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6526	= { FOLLOW_formula_in_stringTerm6526_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6529  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6529_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6529	= { FOLLOW_COMMA_in_stringTerm6529_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6531  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6531_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6531	= { FOLLOW_formula_in_stringTerm6531_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6534  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6534_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6534	= { FOLLOW_RPAREN_in_stringTerm6534_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SSUBSTR_TOK_in_stringTerm6546  */
static	ANTLR3_BITWORD FOLLOW_SSUBSTR_TOK_in_stringTerm6546_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SSUBSTR_TOK_in_stringTerm6546	= { FOLLOW_SSUBSTR_TOK_in_stringTerm6546_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6548  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6548_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6548	= { FOLLOW_LPAREN_in_stringTerm6548_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6550  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6550_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6550	= { FOLLOW_formula_in_stringTerm6550_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6553  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6553_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6553	= { FOLLOW_COMMA_in_stringTerm6553_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6555  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6555_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6555	= { FOLLOW_formula_in_stringTerm6555_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6558  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6558_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6558	= { FOLLOW_COMMA_in_stringTerm6558_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6560  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6560_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6560	= { FOLLOW_formula_in_stringTerm6560_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6563  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6563_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6563	= { FOLLOW_RPAREN_in_stringTerm6563_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SINDEXOF_TOK_in_stringTerm6575  */
static	ANTLR3_BITWORD FOLLOW_SINDEXOF_TOK_in_stringTerm6575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SINDEXOF_TOK_in_stringTerm6575	= { FOLLOW_SINDEXOF_TOK_in_stringTerm6575_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6577  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6577_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6577	= { FOLLOW_LPAREN_in_stringTerm6577_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6579  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6579_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6579	= { FOLLOW_formula_in_stringTerm6579_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6582  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6582_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6582	= { FOLLOW_COMMA_in_stringTerm6582_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6584  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6584_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6584	= { FOLLOW_formula_in_stringTerm6584_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6587  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6587_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6587	= { FOLLOW_COMMA_in_stringTerm6587_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6589  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6589_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6589	= { FOLLOW_formula_in_stringTerm6589_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6592  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6592	= { FOLLOW_RPAREN_in_stringTerm6592_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SREPLACE_TOK_in_stringTerm6604  */
static	ANTLR3_BITWORD FOLLOW_SREPLACE_TOK_in_stringTerm6604_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SREPLACE_TOK_in_stringTerm6604	= { FOLLOW_SREPLACE_TOK_in_stringTerm6604_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6606  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6606_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6606	= { FOLLOW_LPAREN_in_stringTerm6606_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6608  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6608_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6608	= { FOLLOW_formula_in_stringTerm6608_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6611  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6611_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6611	= { FOLLOW_COMMA_in_stringTerm6611_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6613  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6613_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6613	= { FOLLOW_formula_in_stringTerm6613_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6616  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6616_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6616	= { FOLLOW_COMMA_in_stringTerm6616_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6618  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6618_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6618	= { FOLLOW_formula_in_stringTerm6618_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6621  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6621_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6621	= { FOLLOW_RPAREN_in_stringTerm6621_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SPREFIXOF_TOK_in_stringTerm6633  */
static	ANTLR3_BITWORD FOLLOW_SPREFIXOF_TOK_in_stringTerm6633_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SPREFIXOF_TOK_in_stringTerm6633	= { FOLLOW_SPREFIXOF_TOK_in_stringTerm6633_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6635  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6635_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6635	= { FOLLOW_LPAREN_in_stringTerm6635_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6637  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6637_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6637	= { FOLLOW_formula_in_stringTerm6637_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6640  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6640_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6640	= { FOLLOW_COMMA_in_stringTerm6640_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6642  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6642	= { FOLLOW_formula_in_stringTerm6642_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6645  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6645_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6645	= { FOLLOW_RPAREN_in_stringTerm6645_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SSUFFIXOF_TOK_in_stringTerm6657  */
static	ANTLR3_BITWORD FOLLOW_SSUFFIXOF_TOK_in_stringTerm6657_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SSUFFIXOF_TOK_in_stringTerm6657	= { FOLLOW_SSUFFIXOF_TOK_in_stringTerm6657_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6659  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6659_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6659	= { FOLLOW_LPAREN_in_stringTerm6659_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6661  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6661_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6661	= { FOLLOW_formula_in_stringTerm6661_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_stringTerm6664  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_stringTerm6664_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_stringTerm6664	= { FOLLOW_COMMA_in_stringTerm6664_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6666  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6666_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6666	= { FOLLOW_formula_in_stringTerm6666_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6669  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6669_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6669	= { FOLLOW_RPAREN_in_stringTerm6669_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STOINTEGER_TOK_in_stringTerm6681  */
static	ANTLR3_BITWORD FOLLOW_STOINTEGER_TOK_in_stringTerm6681_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STOINTEGER_TOK_in_stringTerm6681	= { FOLLOW_STOINTEGER_TOK_in_stringTerm6681_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6683  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6683_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6683	= { FOLLOW_LPAREN_in_stringTerm6683_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6685  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6685_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6685	= { FOLLOW_formula_in_stringTerm6685_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6688  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6688_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6688	= { FOLLOW_RPAREN_in_stringTerm6688_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STOSTRING_TOK_in_stringTerm6700  */
static	ANTLR3_BITWORD FOLLOW_STOSTRING_TOK_in_stringTerm6700_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STOSTRING_TOK_in_stringTerm6700	= { FOLLOW_STOSTRING_TOK_in_stringTerm6700_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6702  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6702_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6702	= { FOLLOW_LPAREN_in_stringTerm6702_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6704  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6704	= { FOLLOW_formula_in_stringTerm6704_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6707  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6707_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6707	= { FOLLOW_RPAREN_in_stringTerm6707_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STORE_TOK_in_stringTerm6719  */
static	ANTLR3_BITWORD FOLLOW_STORE_TOK_in_stringTerm6719_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_STORE_TOK_in_stringTerm6719	= { FOLLOW_STORE_TOK_in_stringTerm6719_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_stringTerm6721  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_stringTerm6721_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_stringTerm6721	= { FOLLOW_LPAREN_in_stringTerm6721_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_stringTerm6723  */
static	ANTLR3_BITWORD FOLLOW_formula_in_stringTerm6723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_stringTerm6723	= { FOLLOW_formula_in_stringTerm6723_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_stringTerm6726  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_stringTerm6726_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_stringTerm6726	= { FOLLOW_RPAREN_in_stringTerm6726_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_stringTerm6745  */
static	ANTLR3_BITWORD FOLLOW_str_in_stringTerm6745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_stringTerm6745	= { FOLLOW_str_in_stringTerm6745_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleTerm_in_stringTerm6759  */
static	ANTLR3_BITWORD FOLLOW_simpleTerm_in_stringTerm6759_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleTerm_in_stringTerm6759	= { FOLLOW_simpleTerm_in_stringTerm6759_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteTerm_in_simpleTerm6787  */
static	ANTLR3_BITWORD FOLLOW_iteTerm_in_simpleTerm6787_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteTerm_in_simpleTerm6787	= { FOLLOW_iteTerm_in_simpleTerm6787_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm6801  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm6801_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm6801	= { FOLLOW_LPAREN_in_simpleTerm6801_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm6803  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm6803_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm6803	= { FOLLOW_formula_in_simpleTerm6803_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm6814  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm6814_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm6814	= { FOLLOW_COMMA_in_simpleTerm6814_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm6816  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm6816_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm6816	= { FOLLOW_formula_in_simpleTerm6816_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm6824  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm6824_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm6824	= { FOLLOW_RPAREN_in_simpleTerm6824_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_simpleTerm6843  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_simpleTerm6843_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_simpleTerm6843	= { FOLLOW_LPAREN_in_simpleTerm6843_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_simpleTerm6845  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_simpleTerm6845_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_simpleTerm6845	= { FOLLOW_RPAREN_in_simpleTerm6845_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm6863  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm6863_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm6863	= { FOLLOW_PARENHASH_in_simpleTerm6863_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm6865  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm6865_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm6865	= { FOLLOW_HASHPAREN_in_simpleTerm6865_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm6885  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm6885_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm6885	= { FOLLOW_LBRACE_in_simpleTerm6885_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm6887  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm6887_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm6887	= { FOLLOW_RBRACE_in_simpleTerm6887_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACE_in_simpleTerm6906  */
static	ANTLR3_BITWORD FOLLOW_LBRACE_in_simpleTerm6906_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACE_in_simpleTerm6906	= { FOLLOW_LBRACE_in_simpleTerm6906_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm6908  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm6908_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm6908	= { FOLLOW_formula_in_simpleTerm6908_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm6919  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm6919_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm6919	= { FOLLOW_COMMA_in_simpleTerm6919_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_simpleTerm6921  */
static	ANTLR3_BITWORD FOLLOW_formula_in_simpleTerm6921_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_simpleTerm6921	= { FOLLOW_formula_in_simpleTerm6921_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACE_in_simpleTerm6929  */
static	ANTLR3_BITWORD FOLLOW_RBRACE_in_simpleTerm6929_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACE_in_simpleTerm6929	= { FOLLOW_RBRACE_in_simpleTerm6929_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TRUE_TOK_in_simpleTerm6948  */
static	ANTLR3_BITWORD FOLLOW_TRUE_TOK_in_simpleTerm6948_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TRUE_TOK_in_simpleTerm6948	= { FOLLOW_TRUE_TOK_in_simpleTerm6948_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FALSE_TOK_in_simpleTerm6957  */
static	ANTLR3_BITWORD FOLLOW_FALSE_TOK_in_simpleTerm6957_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FALSE_TOK_in_simpleTerm6957	= { FOLLOW_FALSE_TOK_in_simpleTerm6957_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleTerm6977  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleTerm6977_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleTerm6977	= { FOLLOW_DECIMAL_LITERAL_in_simpleTerm6977_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleTerm6985  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleTerm6985_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleTerm6985	= { FOLLOW_INTEGER_LITERAL_in_simpleTerm6985_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleTerm6999  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleTerm6999_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleTerm6999	= { FOLLOW_HEX_LITERAL_in_simpleTerm6999_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleTerm7011  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleTerm7011_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleTerm7011	= { FOLLOW_BINARY_LITERAL_in_simpleTerm7011_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PARENHASH_in_simpleTerm7029  */
static	ANTLR3_BITWORD FOLLOW_PARENHASH_in_simpleTerm7029_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PARENHASH_in_simpleTerm7029	= { FOLLOW_PARENHASH_in_simpleTerm7029_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm7031  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm7031_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm7031	= { FOLLOW_recordEntry_in_simpleTerm7031_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_simpleTerm7042  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_simpleTerm7042_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_simpleTerm7042	= { FOLLOW_COMMA_in_simpleTerm7042_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_recordEntry_in_simpleTerm7044  */
static	ANTLR3_BITWORD FOLLOW_recordEntry_in_simpleTerm7044_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_recordEntry_in_simpleTerm7044	= { FOLLOW_recordEntry_in_simpleTerm7044_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HASHPAREN_in_simpleTerm7052  */
static	ANTLR3_BITWORD FOLLOW_HASHPAREN_in_simpleTerm7052_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HASHPAREN_in_simpleTerm7052	= { FOLLOW_HASHPAREN_in_simpleTerm7052_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_simpleTerm7071  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_simpleTerm7071_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_simpleTerm7071	= { FOLLOW_identifier_in_simpleTerm7071_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription7111  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription7111_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription7111	= { FOLLOW_COLON_in_typeAscription7111_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_typeAscription7113  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_typeAscription7113_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_typeAscription7113	= { FOLLOW_COLON_in_typeAscription7113_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_typeAscription7115  */
static	ANTLR3_BITWORD FOLLOW_type_in_typeAscription7115_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_typeAscription7115	= { FOLLOW_type_in_typeAscription7115_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_recordEntry7132  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_recordEntry7132_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_recordEntry7132	= { FOLLOW_identifier_in_recordEntry7132_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSIGN_TOK_in_recordEntry7135  */
static	ANTLR3_BITWORD FOLLOW_ASSIGN_TOK_in_recordEntry7135_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSIGN_TOK_in_recordEntry7135	= { FOLLOW_ASSIGN_TOK_in_recordEntry7135_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_recordEntry7137  */
static	ANTLR3_BITWORD FOLLOW_formula_in_recordEntry7137_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_recordEntry7137	= { FOLLOW_formula_in_recordEntry7137_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IF_TOK_in_iteTerm7159  */
static	ANTLR3_BITWORD FOLLOW_IF_TOK_in_iteTerm7159_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_IF_TOK_in_iteTerm7159	= { FOLLOW_IF_TOK_in_iteTerm7159_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm7161  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm7161_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm7161	= { FOLLOW_formula_in_iteTerm7161_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteTerm7170  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteTerm7170_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteTerm7170	= { FOLLOW_THEN_TOK_in_iteTerm7170_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteTerm7172  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteTerm7172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x000000000000C000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteTerm7172	= { FOLLOW_formula_in_iteTerm7172_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteTerm7181  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteTerm7181_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000010000) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteTerm7181	= { FOLLOW_iteElseTerm_in_iteTerm7181_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ENDIF_TOK_in_iteTerm7190  */
static	ANTLR3_BITWORD FOLLOW_ENDIF_TOK_in_iteTerm7190_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ENDIF_TOK_in_iteTerm7190	= { FOLLOW_ENDIF_TOK_in_iteTerm7190_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSE_TOK_in_iteElseTerm7217  */
static	ANTLR3_BITWORD FOLLOW_ELSE_TOK_in_iteElseTerm7217_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSE_TOK_in_iteElseTerm7217	= { FOLLOW_ELSE_TOK_in_iteElseTerm7217_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm7219  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm7219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm7219	= { FOLLOW_formula_in_iteElseTerm7219_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ELSEIF_TOK_in_iteElseTerm7226  */
static	ANTLR3_BITWORD FOLLOW_ELSEIF_TOK_in_iteElseTerm7226_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_ELSEIF_TOK_in_iteElseTerm7226	= { FOLLOW_ELSEIF_TOK_in_iteElseTerm7226_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm7232  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm7232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000002000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm7232	= { FOLLOW_formula_in_iteElseTerm7232_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_THEN_TOK_in_iteElseTerm7241  */
static	ANTLR3_BITWORD FOLLOW_THEN_TOK_in_iteElseTerm7241_bits[]	= { ANTLR3_UINT64_LIT(0x2001FFFFFFF88110), ANTLR3_UINT64_LIT(0x0A63916003900003), ANTLR3_UINT64_LIT(0x00000111EECC0001) };
static  ANTLR3_BITSET_LIST FOLLOW_THEN_TOK_in_iteElseTerm7241	= { FOLLOW_THEN_TOK_in_iteElseTerm7241_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_formula_in_iteElseTerm7247  */
static	ANTLR3_BITWORD FOLLOW_formula_in_iteElseTerm7247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x000000000000C000) };
static  ANTLR3_BITSET_LIST FOLLOW_formula_in_iteElseTerm7247	= { FOLLOW_formula_in_iteElseTerm7247_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_iteElseTerm_in_iteElseTerm7260  */
static	ANTLR3_BITWORD FOLLOW_iteElseTerm_in_iteElseTerm7260_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_iteElseTerm_in_iteElseTerm7260	= { FOLLOW_iteElseTerm_in_iteElseTerm7260_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef7296  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef7296_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0004000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef7296	= { FOLLOW_identifier_in_datatypeDef7296_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LBRACKET_in_datatypeDef7307  */
static	ANTLR3_BITWORD FOLLOW_LBRACKET_in_datatypeDef7307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LBRACKET_in_datatypeDef7307	= { FOLLOW_LBRACKET_in_datatypeDef7307_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef7309  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef7309_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef7309	= { FOLLOW_identifier_in_datatypeDef7309_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_datatypeDef7322  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_datatypeDef7322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_datatypeDef7322	= { FOLLOW_COMMA_in_datatypeDef7322_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_datatypeDef7324  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_datatypeDef7324_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_datatypeDef7324	= { FOLLOW_identifier_in_datatypeDef7324_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RBRACKET_in_datatypeDef7338  */
static	ANTLR3_BITWORD FOLLOW_RBRACKET_in_datatypeDef7338_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000040000) };
static  ANTLR3_BITSET_LIST FOLLOW_RBRACKET_in_datatypeDef7338	= { FOLLOW_RBRACKET_in_datatypeDef7338_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_datatypeDef7357  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_datatypeDef7357_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_datatypeDef7357	= { FOLLOW_EQUAL_TOK_in_datatypeDef7357_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef7359  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef7359_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef7359	= { FOLLOW_constructorDef_in_datatypeDef7359_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BAR_in_datatypeDef7368  */
static	ANTLR3_BITWORD FOLLOW_BAR_in_datatypeDef7368_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_BAR_in_datatypeDef7368	= { FOLLOW_BAR_in_datatypeDef7368_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef7370  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef7370_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000004002) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef7370	= { FOLLOW_constructorDef_in_datatypeDef7370_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_constructorDef7401  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_constructorDef7401_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0040000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_constructorDef7401	= { FOLLOW_identifier_in_constructorDef7401_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_in_constructorDef7416  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_in_constructorDef7416_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_in_constructorDef7416	= { FOLLOW_LPAREN_in_constructorDef7416_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef7424  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef7424_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef7424	= { FOLLOW_selector_in_constructorDef7424_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COMMA_in_constructorDef7435  */
static	ANTLR3_BITWORD FOLLOW_COMMA_in_constructorDef7435_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000004000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_COMMA_in_constructorDef7435	= { FOLLOW_COMMA_in_constructorDef7435_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef7437  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef7437_bits[]	= { ANTLR3_UINT64_LIT(0x0020000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000020000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef7437	= { FOLLOW_selector_in_constructorDef7437_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_in_constructorDef7449  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_in_constructorDef7449_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_in_constructorDef7449	= { FOLLOW_RPAREN_in_constructorDef7449_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_identifier_in_selector7481  */
static	ANTLR3_BITWORD FOLLOW_identifier_in_selector7481_bits[]	= { ANTLR3_UINT64_LIT(0x0010000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_identifier_in_selector7481	= { FOLLOW_identifier_in_selector7481_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_COLON_in_selector7484  */
static	ANTLR3_BITWORD FOLLOW_COLON_in_selector7484_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000030100), ANTLR3_UINT64_LIT(0x0064204000000000), ANTLR3_UINT64_LIT(0x0000000A01204000) };
static  ANTLR3_BITSET_LIST FOLLOW_COLON_in_selector7484	= { FOLLOW_COLON_in_selector7484_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_type_in_selector7486  */
static	ANTLR3_BITWORD FOLLOW_type_in_selector7486_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_type_in_selector7486	= { FOLLOW_type_in_selector7486_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_numeral7561  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_numeral7561_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_numeral7561	= { FOLLOW_INTEGER_LITERAL_in_numeral7561_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer7586  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer7586_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer7586	= { FOLLOW_INTEGER_LITERAL_in_integer7586_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_integer7598  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_integer7598_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000100000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_integer7598	= { FOLLOW_MINUS_TOK_in_integer7598_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_integer7600  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_integer7600_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_integer7600	= { FOLLOW_INTEGER_LITERAL_in_integer7600_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_in_str7622  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_in_str7622_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_in_str7622	= { FOLLOW_STRING_LITERAL_in_str7622_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_letDecl_in_synpred1_Cvc1772  */
static	ANTLR3_BITWORD FOLLOW_letDecl_in_synpred1_Cvc1772_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_letDecl_in_synpred1_Cvc1772	= { FOLLOW_letDecl_in_synpred1_Cvc1772_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:595:1: parseExpr returns [CVC4::Expr expr = CVC4::Expr()] : ( formula[expr] | EOF );
 */
static CVC4::Expr
parseExpr(pCvcParser ctx)
{
    CVC4::Expr expr;


    /* Initialize rule variables
     */
    expr =  CVC4::Expr();


    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:596:3: ( formula[expr] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case ABS_TOK:
            case ARRAY_TOK:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case EXISTS_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case FORALL_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LAMBDA:
            case LBRACE:
            case LET_TOK:
            case LPAREN:
            case MINUS_TOK:
            case NOT_TOK:
            case PARENHASH:
            case SCONCAT_TOK:
            case SCONTAINS_TOK:
            case SINDEXOF_TOK:
            case SPREFIXOF_TOK:
            case SREPLACE_TOK:
            case SSUBSTR_TOK:
            case SSUFFIXOF_TOK:
            case STOINTEGER_TOK:
            case STORE_TOK:
            case STOSTRING_TOK:
            case STRING_LITERAL:
            case SX_TOK:
            case TRUE_TOK:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return expr;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:596:5: formula[expr]
        	    {
        	        FOLLOWPUSH(FOLLOW_formula_in_parseExpr1602);
        	        formula(ctx, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:597:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr1609);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:604:1: parseCommand returns [CVC4::Command* cmd = NULL] : (c= command | LPAREN IDENTIFIER | EOF );
 */
static CVC4::Command*
parseCommand(pCvcParser ctx)
{
    CVC4::Command* cmd;


    pANTLR3_COMMON_TOKEN    IDENTIFIER1;
    CVC4::Command* c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c CVC4::Command*

    /* Initialize rule variables
     */
    cmd =  NULL;


    IDENTIFIER1       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:605:3: (c= command | LPAREN IDENTIFIER | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case ARITH_VAR_ORDER_TOK:
            case ASSERTIONS_TOK:
            case ASSERT_TOK:
            case ASSUMPTIONS_TOK:
            case CALL_TOK:
            case CHECKSAT_TOK:
            case CHECK_TYPE_TOK:
            case CONTEXT_TOK:
            case COUNTEREXAMPLE_TOK:
            case COUNTERMODEL_TOK:
            case DATATYPE_TOK:
            case DBG_TOK:
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_PROOF_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case FORGET_TOK:
            case GET_CHILD_TOK:
            case GET_OP_TOK:
            case GET_TYPE_TOK:
            case GET_VALUE_TOK:
            case HELP_TOK:
            case IDENTIFIER:
            case INCLUDE_TOK:
            case LET_TOK:
            case OPTION_TOK:
            case POPTO_SCOPE_TOK:
            case POPTO_TOK:
            case POP_SCOPE_TOK:
            case POP_TOK:
            case PRINT_TOK:
            case PRINT_TYPE_TOK:
            case PUSH_SCOPE_TOK:
            case PUSH_TOK:
            case QUERY_TOK:
            case RESET_TOK:
            case SEMICOLON:
            case SUBSTITUTE_TOK:
            case TRACE_TOK:
            case TRANSFORM_TOK:
            case UNTRACE_TOK:
            case WHERE_TOK:
            	{
            		alt2=1;
            	}
                break;
            case LPAREN:
            	{
            		alt2=2;
            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return cmd;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:605:5: c= command
        	    {
        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand1630);
        	        c=command(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= c;
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:606:5: LPAREN IDENTIFIER
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_parseCommand1638);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        IDENTIFIER1 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_parseCommand1640);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::string s = AntlrInput::tokenText(IDENTIFIER1);
        	                  if(s == "benchmark") {
        	                    PARSER_STATE->parseError("In CVC4 presentation language mode, but SMT-LIBv1 format detected.  Use --lang smt1 for SMT-LIBv1 support.");
        	                  } else if(s == "set" || s == "get" || s == "declare" ||
        	                            s == "define" || s == "assert") {
        	                    PARSER_STATE->parseError("In CVC4 presentation language mode, but SMT-LIB format detected.  Use --lang smt for SMT-LIB support.");
        	                  } else {
        	                    PARSER_STATE->parseError("A CVC4 presentation language command cannot begin with a parenthesis; expected command name.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:617:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand1652);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= NULL;
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return cmd;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start command
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:624:1: command returns [CVC4::Command* cmd = NULL] : ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK c= command ) ;
 */
static CVC4::Command*
command(pCvcParser ctx)
{
    CVC4::Command* cmd;


    CVC4::Command* c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c CVC4::Command*

    /* Initialize rule variables
     */
    cmd =  NULL;


    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:625:3: ( ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK c= command ) )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:625:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK c= command )
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:625:5: ( mainCommand[cmd] SEMICOLON | SEMICOLON | LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK c= command )
            {
                int alt4=3;
                switch ( LA(1) )
                {
                case ARITH_VAR_ORDER_TOK:
                case ASSERTIONS_TOK:
                case ASSERT_TOK:
                case ASSUMPTIONS_TOK:
                case CALL_TOK:
                case CHECKSAT_TOK:
                case CHECK_TYPE_TOK:
                case CONTEXT_TOK:
                case COUNTEREXAMPLE_TOK:
                case COUNTERMODEL_TOK:
                case DATATYPE_TOK:
                case DBG_TOK:
                case DUMP_ASSUMPTIONS_TOK:
                case DUMP_CLOSURE_PROOF_TOK:
                case DUMP_CLOSURE_TOK:
                case DUMP_PROOF_TOK:
                case DUMP_SIG_TOK:
                case DUMP_TCC_ASSUMPTIONS_TOK:
                case DUMP_TCC_PROOF_TOK:
                case DUMP_TCC_TOK:
                case ECHO_TOK:
                case EXIT_TOK:
                case FORGET_TOK:
                case GET_CHILD_TOK:
                case GET_OP_TOK:
                case GET_TYPE_TOK:
                case GET_VALUE_TOK:
                case HELP_TOK:
                case IDENTIFIER:
                case INCLUDE_TOK:
                case OPTION_TOK:
                case POPTO_SCOPE_TOK:
                case POPTO_TOK:
                case POP_SCOPE_TOK:
                case POP_TOK:
                case PRINT_TOK:
                case PRINT_TYPE_TOK:
                case PUSH_SCOPE_TOK:
                case PUSH_TOK:
                case QUERY_TOK:
                case RESET_TOK:
                case SUBSTITUTE_TOK:
                case TRACE_TOK:
                case TRANSFORM_TOK:
                case UNTRACE_TOK:
                case WHERE_TOK:
                	{
                		alt4=1;
                	}
                    break;
                case SEMICOLON:
                	{
                		alt4=2;
                	}
                    break;
                case LET_TOK:
                	{
                		alt4=3;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return cmd;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 4;
                    EXCEPTION->state        = 0;


                    goto rulecommandEx;

                }

                switch (alt4)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:625:7: mainCommand[cmd] SEMICOLON
            	    {
            	        FOLLOWPUSH(FOLLOW_mainCommand_in_command1675);
            	        mainCommand(ctx, cmd);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1678);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:626:7: SEMICOLON
            	    {
            	         MATCHT(SEMICOLON, &FOLLOW_SEMICOLON_in_command1686);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	    }
            	    break;
            	case 3:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:627:7: LET_TOK typeOrVarLetDecl[CHECK_DECLARED] ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )* IN_TOK c= command
            	    {
            	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_command1694);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             PARSER_STATE->pushScope(); 
            	        }


            	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command1704);
            	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:628:40: ( COMMA typeOrVarLetDecl[CHECK_DECLARED] )*

            	        for (;;)
            	        {
            	            int alt3=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt3=1;
            	            	}
            	                break;

            	            }

            	            switch (alt3)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:628:42: COMMA typeOrVarLetDecl[CHECK_DECLARED]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_command1709);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulecommandEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return cmd;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_typeOrVarLetDecl_in_command1711);
            	        	        typeOrVarLetDecl(ctx, CHECK_DECLARED);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulecommandEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return cmd;
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop3;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop3: ; /* Jump out to here if this rule does not match */


            	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_command1723);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	        FOLLOWPUSH(FOLLOW_command_in_command1727);
            	        c=command(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return cmd;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             cmd= c;

            	                    PARSER_STATE->popScope();
            	                  
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 if(cmd
                 == NULL) {
                        cmd = new EmptyCommand();
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return cmd;
}
/* $ANTLR end command */

/**
 * $ANTLR start typeOrVarLetDecl
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:640:1: typeOrVarLetDecl[CVC4::parser::DeclarationCheck check] options {backtrack=true; } : ( letDecl | typeLetDecl[check] );
 */
static void
typeOrVarLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:642:3: ( letDecl | typeLetDecl[check] )

            ANTLR3_UINT32 alt5;

            alt5=2;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				switch ( LA(3) )
            				{
            				case ABS_TOK:
            				case BINARY_LITERAL:
            				case BVASHR_TOK:
            				case BVCOMP_TOK:
            				case BVGE_TOK:
            				case BVGT_TOK:
            				case BVLE_TOK:
            				case BVLSHR_TOK:
            				case BVLT_TOK:
            				case BVMULT_TOK:
            				case BVNAND_TOK:
            				case BVNEG_TOK:
            				case BVNOR_TOK:
            				case BVPLUS_TOK:
            				case BVREPEAT_TOK:
            				case BVROTL_TOK:
            				case BVROTR_TOK:
            				case BVSDIV_TOK:
            				case BVSGE_TOK:
            				case BVSGT_TOK:
            				case BVSHL_TOK:
            				case BVSLE_TOK:
            				case BVSLT_TOK:
            				case BVSMOD_TOK:
            				case BVSREM_TOK:
            				case BVSUB_TOK:
            				case BVUDIV_TOK:
            				case BVUMINUS_TOK:
            				case BVUREM_TOK:
            				case BVXNOR_TOK:
            				case BVXOR_TOK:
            				case BVZEROEXTEND_TOK:
            				case DECIMAL_LITERAL:
            				case DISTINCT_TOK:
            				case DIVISIBLE_TOK:
            				case EXISTS_TOK:
            				case FALSE_TOK:
            				case FLOOR_TOK:
            				case FORALL_TOK:
            				case HEX_LITERAL:
            				case IF_TOK:
            				case INTEGER_LITERAL:
            				case IS_INTEGER_TOK:
            				case LAMBDA:
            				case LBRACE:
            				case LET_TOK:
            				case MINUS_TOK:
            				case NOT_TOK:
            				case PARENHASH:
            				case SCONCAT_TOK:
            				case SCONTAINS_TOK:
            				case SINDEXOF_TOK:
            				case SPREFIXOF_TOK:
            				case SREPLACE_TOK:
            				case SSUBSTR_TOK:
            				case SSUFFIXOF_TOK:
            				case STOINTEGER_TOK:
            				case STORE_TOK:
            				case STOSTRING_TOK:
            				case STRING_LITERAL:
            				case SX_TOK:
            				case TRUE_TOK:
            					{
            						alt5=1;
            					}
            				    break;
            				case ARRAY_TOK:
            					{
            						{
            						    int LA5_9 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt5=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt5=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 5;
            						        EXCEPTION->state        = 9;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case LPAREN:
            					{
            						{
            						    int LA5_54 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt5=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt5=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 5;
            						        EXCEPTION->state        = 54;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case IDENTIFIER:
            					{
            						{
            						    int LA5_63 = LA(4);
            						    if ( (synpred1_Cvc(ctx)))
            						    {
            						        alt5=1;
            						    }
            						    else if ( (ANTLR3_TRUE))
            						    {
            						        alt5=2;
            						    }
            						    else
            						    {
            						        if (BACKTRACKING>0)
            						        {
            						            FAILEDFLAG = ANTLR3_TRUE;
            						            return ;
            						        }


            						        CONSTRUCTEX();
            						        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            						        EXCEPTION->message      = (void *)"";
            						        EXCEPTION->decisionNum  = 5;
            						        EXCEPTION->state        = 63;


            						        goto ruletypeOrVarLetDeclEx;

            						    }
            						}
            					}
            				    break;
            				case BITVECTOR_TOK:
            				case BOOLEAN_TOK:
            				case INT_TOK:
            				case LBRACKET:
            				case REAL_TOK:
            				case SET_TOK:
            				case SQHASH:
            				case STRING_TOK:
            				case SUBTYPE_TOK:
            					{
            						alt5=2;
            					}
            				    break;

            				default:
            				    if (BACKTRACKING>0)
            				    {
            				        FAILEDFLAG = ANTLR3_TRUE;
            				        return ;
            				    }

            				    CONSTRUCTEX();
            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            				    EXCEPTION->message      = (void *)"";
            				    EXCEPTION->decisionNum  = 5;
            				    EXCEPTION->state        = 2;


            				    goto ruletypeOrVarLetDeclEx;

            				}

            			}
            		    break;
            		case COLON:
            			{
            				alt5=2;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 5;
            		    EXCEPTION->state        = 1;


            		    goto ruletypeOrVarLetDeclEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 5;
                EXCEPTION->state        = 0;


                goto ruletypeOrVarLetDeclEx;

            }

            switch (alt5)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:642:5: letDecl
        	    {
        	        FOLLOWPUSH(FOLLOW_letDecl_in_typeOrVarLetDecl1772);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:642:15: typeLetDecl[check]
        	    {
        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_typeOrVarLetDecl1776);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeOrVarLetDeclEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeOrVarLetDeclEx; /* Prevent compiler warnings */
    ruletypeOrVarLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeOrVarLetDecl */

/**
 * $ANTLR start mainCommand
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:645:1: mainCommand[CVC4::Command*& cmd] : ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | toplevelDeclaration[cmd] );
 */
static void
mainCommand(pCvcParser ctx, CVC4::Command*& cmd)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER2;
    pANTLR3_COMMON_TOKEN    IDENTIFIER3;
    pANTLR3_COMMON_TOKEN    IDENTIFIER4;
    pANTLR3_COMMON_TOKEN    IDENTIFIER5;
    pANTLR3_COMMON_TOKEN    IDENTIFIER6;
    pANTLR3_COMMON_TOKEN    IDENTIFIER7;
    pANTLR3_COMMON_TOKEN    IDENTIFIER8;
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f;
      SExpr sexpr;
      std::string id;
      Type t;
      std::vector<CVC4::Datatype> dts;
      Debug("parser-extra") << "command: " << AntlrInput::tokenText(LT(1)) << std::endl;
      std::string s;

    IDENTIFIER2       = NULL;
    IDENTIFIER3       = NULL;
    IDENTIFIER4       = NULL;
    IDENTIFIER5       = NULL;
    IDENTIFIER6       = NULL;
    IDENTIFIER7       = NULL;
    IDENTIFIER8       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:656:3: ( ASSERT_TOK formula[f] | QUERY_TOK formula[f] | CHECKSAT_TOK ( formula[f] )? | OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |) | PUSH_TOK (k= numeral |) | POP_TOK (k= numeral |) | POPTO_TOK (k= numeral )? | PUSH_SCOPE_TOK (k= numeral )? | POP_SCOPE_TOK (k= numeral )? | POPTO_SCOPE_TOK (k= numeral )? | RESET_TOK | DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK | CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |) | FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] | GET_TYPE_TOK formula[f] | CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED] | GET_CHILD_TOK formula[f] k= numeral | GET_OP_TOK formula[f] | GET_VALUE_TOK formula[f] | SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET | DBG_TOK ( ( str[s] | IDENTIFIER ) |) | TRACE_TOK ( ( str[s] | IDENTIFIER ) |) | UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |) | HELP_TOK ( ( str[s] | IDENTIFIER ) |) | TRANSFORM_TOK formula[f] | PRINT_TOK formula[f] | PRINT_TYPE_TOK type[t,CHECK_DECLARED] | CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f] | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | EXIT_TOK | INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |) | DUMP_PROOF_TOK | ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK ) | ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK ) | COUNTEREXAMPLE_TOK | COUNTERMODEL_TOK | ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN | toplevelDeclaration[cmd] )

            ANTLR3_UINT32 alt30;

            alt30=38;

            switch ( LA(1) )
            {
            case ASSERT_TOK:
            	{
            		alt30=1;
            	}
                break;
            case QUERY_TOK:
            	{
            		alt30=2;
            	}
                break;
            case CHECKSAT_TOK:
            	{
            		alt30=3;
            	}
                break;
            case OPTION_TOK:
            	{
            		alt30=4;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt30=5;
            	}
                break;
            case POP_TOK:
            	{
            		alt30=6;
            	}
                break;
            case POPTO_TOK:
            	{
            		alt30=7;
            	}
                break;
            case PUSH_SCOPE_TOK:
            	{
            		alt30=8;
            	}
                break;
            case POP_SCOPE_TOK:
            	{
            		alt30=9;
            	}
                break;
            case POPTO_SCOPE_TOK:
            	{
            		alt30=10;
            	}
                break;
            case RESET_TOK:
            	{
            		alt30=11;
            	}
                break;
            case DATATYPE_TOK:
            	{
            		alt30=12;
            	}
                break;
            case CONTEXT_TOK:
            	{
            		alt30=13;
            	}
                break;
            case FORGET_TOK:
            	{
            		alt30=14;
            	}
                break;
            case GET_TYPE_TOK:
            	{
            		alt30=15;
            	}
                break;
            case CHECK_TYPE_TOK:
            	{
            		alt30=16;
            	}
                break;
            case GET_CHILD_TOK:
            	{
            		alt30=17;
            	}
                break;
            case GET_OP_TOK:
            	{
            		alt30=18;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt30=19;
            	}
                break;
            case SUBSTITUTE_TOK:
            	{
            		alt30=20;
            	}
                break;
            case DBG_TOK:
            	{
            		alt30=21;
            	}
                break;
            case TRACE_TOK:
            	{
            		alt30=22;
            	}
                break;
            case UNTRACE_TOK:
            	{
            		alt30=23;
            	}
                break;
            case HELP_TOK:
            	{
            		alt30=24;
            	}
                break;
            case TRANSFORM_TOK:
            	{
            		alt30=25;
            	}
                break;
            case PRINT_TOK:
            	{
            		alt30=26;
            	}
                break;
            case PRINT_TYPE_TOK:
            	{
            		alt30=27;
            	}
                break;
            case CALL_TOK:
            	{
            		alt30=28;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt30=29;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt30=30;
            	}
                break;
            case INCLUDE_TOK:
            	{
            		alt30=31;
            	}
                break;
            case DUMP_PROOF_TOK:
            	{
            		alt30=32;
            	}
                break;
            case DUMP_ASSUMPTIONS_TOK:
            case DUMP_CLOSURE_PROOF_TOK:
            case DUMP_CLOSURE_TOK:
            case DUMP_SIG_TOK:
            case DUMP_TCC_ASSUMPTIONS_TOK:
            case DUMP_TCC_PROOF_TOK:
            case DUMP_TCC_TOK:
            	{
            		alt30=33;
            	}
                break;
            case ASSERTIONS_TOK:
            case ASSUMPTIONS_TOK:
            case WHERE_TOK:
            	{
            		alt30=34;
            	}
                break;
            case COUNTEREXAMPLE_TOK:
            	{
            		alt30=35;
            	}
                break;
            case COUNTERMODEL_TOK:
            	{
            		alt30=36;
            	}
                break;
            case ARITH_VAR_ORDER_TOK:
            	{
            		alt30=37;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt30=38;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 30;
                EXCEPTION->state        = 0;


                goto rulemainCommandEx;

            }

            switch (alt30)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:656:5: ASSERT_TOK formula[f]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_mainCommand1802);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand1804);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new AssertCommand(f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:658:5: QUERY_TOK formula[f]
        	    {
        	         MATCHT(QUERY_TOK, &FOLLOW_QUERY_TOK_in_mainCommand1814);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand1816);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new QueryCommand(f); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:659:5: CHECKSAT_TOK ( formula[f] )?
        	    {
        	         MATCHT(CHECKSAT_TOK, &FOLLOW_CHECKSAT_TOK_in_mainCommand1825);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:659:18: ( formula[f] )?
        	        {
        	            int alt6=2;
        	            switch ( LA(1) )
        	            {
        	                case ABS_TOK:
        	                case ARRAY_TOK:
        	                case BINARY_LITERAL:
        	                case BVASHR_TOK:
        	                case BVCOMP_TOK:
        	                case BVGE_TOK:
        	                case BVGT_TOK:
        	                case BVLE_TOK:
        	                case BVLSHR_TOK:
        	                case BVLT_TOK:
        	                case BVMULT_TOK:
        	                case BVNAND_TOK:
        	                case BVNEG_TOK:
        	                case BVNOR_TOK:
        	                case BVPLUS_TOK:
        	                case BVREPEAT_TOK:
        	                case BVROTL_TOK:
        	                case BVROTR_TOK:
        	                case BVSDIV_TOK:
        	                case BVSGE_TOK:
        	                case BVSGT_TOK:
        	                case BVSHL_TOK:
        	                case BVSLE_TOK:
        	                case BVSLT_TOK:
        	                case BVSMOD_TOK:
        	                case BVSREM_TOK:
        	                case BVSUB_TOK:
        	                case BVUDIV_TOK:
        	                case BVUMINUS_TOK:
        	                case BVUREM_TOK:
        	                case BVXNOR_TOK:
        	                case BVXOR_TOK:
        	                case BVZEROEXTEND_TOK:
        	                case DECIMAL_LITERAL:
        	                case DISTINCT_TOK:
        	                case DIVISIBLE_TOK:
        	                case EXISTS_TOK:
        	                case FALSE_TOK:
        	                case FLOOR_TOK:
        	                case FORALL_TOK:
        	                case HEX_LITERAL:
        	                case IDENTIFIER:
        	                case IF_TOK:
        	                case INTEGER_LITERAL:
        	                case IS_INTEGER_TOK:
        	                case LAMBDA:
        	                case LBRACE:
        	                case LET_TOK:
        	                case LPAREN:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case PARENHASH:
        	                case SCONCAT_TOK:
        	                case SCONTAINS_TOK:
        	                case SINDEXOF_TOK:
        	                case SPREFIXOF_TOK:
        	                case SREPLACE_TOK:
        	                case SSUBSTR_TOK:
        	                case SSUFFIXOF_TOK:
        	                case STOINTEGER_TOK:
        	                case STORE_TOK:
        	                case STOSTRING_TOK:
        	                case STRING_LITERAL:
        	                case SX_TOK:
        	                case TRUE_TOK:
        	                	{
        	                		alt6=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt6)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:659:18: formula[f]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand1827);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = f.isNull() ? new CheckSatCommand() : new CheckSatCommand(f); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:662:5: OPTION_TOK ( str[s] | IDENTIFIER ) ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	    {
        	         MATCHT(OPTION_TOK, &FOLLOW_OPTION_TOK_in_mainCommand1844);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:663:5: ( str[s] | IDENTIFIER )
        	        {
        	            int alt7=2;
        	            switch ( LA(1) )
        	            {
        	            case STRING_LITERAL:
        	            	{
        	            		alt7=1;
        	            	}
        	                break;
        	            case IDENTIFIER:
        	            	{
        	            		alt7=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 7;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt7)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:663:7: str[s]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand1852);
        	        	        str(ctx, s);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:663:16: IDENTIFIER
        	        	    {
        	        	        IDENTIFIER2 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand1857);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             s = AntlrInput::tokenText(IDENTIFIER2); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:664:5: ( symbolicExpr[sexpr] | TRUE_TOK | FALSE_TOK |)
        	        {
        	            int alt8=4;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case TRUE_TOK:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;
        	            case FALSE_TOK:
        	            	{
        	            		alt8=3;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt8=4;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:664:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_mainCommand1869);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(s == "logic") {
        	        	                      cmd = new SetBenchmarkLogicCommand(sexpr.getValue());
        	        	                    } else {
        	        	                      cmd = new SetOptionCommand(s, sexpr);
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:671:7: TRUE_TOK
        	        	    {
        	        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_mainCommand1886);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new SetOptionCommand(s, SExpr("true")); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 3:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:672:7: FALSE_TOK
        	        	    {
        	        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_mainCommand1896);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new SetOptionCommand(s, SExpr("false")); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 4:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:673:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new SetOptionCommand(s, SExpr("true")); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:677:5: PUSH_TOK (k= numeral |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_mainCommand1925);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:677:14: (k= numeral |)
        	        {
        	            int alt9=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt9=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt9=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 9;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt9)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:677:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand1931);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = REPEAT_COMMAND(k, PushCommand()); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:678:18: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new PushCommand(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:679:5: POP_TOK (k= numeral |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_mainCommand1960);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:679:13: (k= numeral |)
        	        {
        	            int alt10=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt10=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt10=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 10;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt10)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:679:15: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand1966);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = REPEAT_COMMAND(k, PopCommand()); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:680:17: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new PopCommand(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:681:5: POPTO_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_TOK, &FOLLOW_POPTO_TOK_in_mainCommand1994);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:681:16: (k= numeral )?
        	        {
        	            int alt11=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt11=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt11)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:681:16: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand1998);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO command"); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:685:5: PUSH_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(PUSH_SCOPE_TOK, &FOLLOW_PUSH_SCOPE_TOK_in_mainCommand2018);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:685:21: (k= numeral )?
        	        {
        	            int alt12=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt12=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt12)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:685:21: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2022);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PUSH_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:687:5: POP_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POP_SCOPE_TOK, &FOLLOW_POP_SCOPE_TOK_in_mainCommand2035);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:687:20: (k= numeral )?
        	        {
        	            int alt13=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt13=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt13)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:687:20: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2039);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POP_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:689:5: POPTO_SCOPE_TOK (k= numeral )?
        	    {
        	         MATCHT(POPTO_SCOPE_TOK, &FOLLOW_POPTO_SCOPE_TOK_in_mainCommand2052);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:689:22: (k= numeral )?
        	        {
        	            int alt14=2;
        	            switch ( LA(1) )
        	            {
        	                case INTEGER_LITERAL:
        	                	{
        	                		alt14=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt14)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:689:22: k= numeral
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2056);
        	        	        k=numeral(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("POPTO_SCOPE command"); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:692:5: RESET_TOK
        	    {
        	         MATCHT(RESET_TOK, &FOLLOW_RESET_TOK_in_mainCommand2070);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("RESET command"); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:698:5: DATATYPE_TOK datatypeDef[dts] ( COMMA datatypeDef[dts] )* END_TOK
        	    {
        	         MATCHT(DATATYPE_TOK, &FOLLOW_DATATYPE_TOK_in_mainCommand2098);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* open a scope to keep the UnresolvedTypes contained */
        	                  PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2110);
        	        datatypeDef(ctx, dts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:702:5: ( COMMA datatypeDef[dts] )*

        	        for (;;)
        	        {
        	            int alt15=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt15=1;
        	            	}
        	                break;

        	            }

        	            switch (alt15)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:702:7: COMMA datatypeDef[dts]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand2119);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_datatypeDef_in_mainCommand2121);
        	        	        datatypeDef(ctx, dts);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop15;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop15: ; /* Jump out to here if this rule does not match */


        	         MATCHT(END_TOK, &FOLLOW_END_TOK_in_mainCommand2131);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  cmd = new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts)); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:707:5: CONTEXT_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(CONTEXT_TOK, &FOLLOW_CONTEXT_TOK_in_mainCommand2144);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:708:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt17=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt17=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt17=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 17;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt17)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:708:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:708:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt16=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt16=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt16=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 16;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt16)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:708:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2154);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:708:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER3 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2159);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER3); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:710:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("CONTEXT command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 14:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:713:5: FORGET_TOK identifier[id,CHECK_NONE,SYM_VARIABLE]
        	    {
        	         MATCHT(FORGET_TOK, &FOLLOW_FORGET_TOK_in_mainCommand2192);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2194);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("FORGET command"); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:716:5: GET_TYPE_TOK formula[f]
        	    {
        	         MATCHT(GET_TYPE_TOK, &FOLLOW_GET_TYPE_TOK_in_mainCommand2208);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2210);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:719:5: CHECK_TYPE_TOK formula[f] COLON type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(CHECK_TYPE_TOK, &FOLLOW_CHECK_TYPE_TOK_in_mainCommand2224);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2226);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2229);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2231);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CHECK_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:722:5: GET_CHILD_TOK formula[f] k= numeral
        	    {
        	         MATCHT(GET_CHILD_TOK, &FOLLOW_GET_CHILD_TOK_in_mainCommand2245);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2247);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_mainCommand2252);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_CHILD command"); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:725:5: GET_OP_TOK formula[f]
        	    {
        	         MATCHT(GET_OP_TOK, &FOLLOW_GET_OP_TOK_in_mainCommand2265);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2267);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("GET_OP command"); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:728:5: GET_VALUE_TOK formula[f]
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_mainCommand2281);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2283);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetValueCommand(f); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:731:5: SUBSTITUTE_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] EQUAL_TOK formula[f] LBRACKET identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[f] RBRACKET
        	    {
        	         MATCHT(SUBSTITUTE_TOK, &FOLLOW_SUBSTITUTE_TOK_in_mainCommand2297);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2299);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_mainCommand2302);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2304);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_mainCommand2307);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2313);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_mainCommand2316);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2318);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_mainCommand2321);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2323);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_mainCommand2326);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("SUBSTITUTE command"); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:737:5: DBG_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(DBG_TOK, &FOLLOW_DBG_TOK_in_mainCommand2345);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:738:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt19=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt19=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt19=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 19;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt19)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:738:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:738:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt18=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt18=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt18=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 18;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt18)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:738:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2355);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:738:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER4 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2360);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER4); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Debug.on(s); Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:740:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify what to debug." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 22:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:743:5: TRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(TRACE_TOK, &FOLLOW_TRACE_TOK_in_mainCommand2393);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:744:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt21=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt21=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt21=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 21;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt21)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:744:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:744:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt20=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt20=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt20=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 20;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt20)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:744:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2403);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:744:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER5 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2408);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER5); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.on(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:746:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to trace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 23:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:748:5: UNTRACE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(UNTRACE_TOK, &FOLLOW_UNTRACE_TOK_in_mainCommand2440);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:749:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt23=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt23=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt23=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 23;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt23)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:749:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:749:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt22=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt22=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt22=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 22;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt22)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:749:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2450);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:749:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER6 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2455);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER6); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Trace.off(s); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:751:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please specify something to untrace." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 24:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:754:5: HELP_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(HELP_TOK, &FOLLOW_HELP_TOK_in_mainCommand2488);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:755:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt25=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt25=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt25=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 25;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt25)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:755:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:755:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt24=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt24=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt24=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 24;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt24)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:755:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2498);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:755:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER7 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2503);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER7); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "No help available for `" << s << "'." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:757:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Message() << "Please use --help at the command line for help." << std::endl; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 25:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:760:5: TRANSFORM_TOK formula[f]
        	    {
        	         MATCHT(TRANSFORM_TOK, &FOLLOW_TRANSFORM_TOK_in_mainCommand2536);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2538);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new SimplifyCommand(f); 
        	        }


        	    }
        	    break;
        	case 26:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:763:5: PRINT_TOK formula[f]
        	    {
        	         MATCHT(PRINT_TOK, &FOLLOW_PRINT_TOK_in_mainCommand2552);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2554);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT command"); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:765:5: PRINT_TYPE_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(PRINT_TYPE_TOK, &FOLLOW_PRINT_TYPE_TOK_in_mainCommand2567);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_mainCommand2569);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("PRINT_TYPE command"); 
        	        }


        	    }
        	    break;
        	case 28:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:768:5: CALL_TOK identifier[id,CHECK_NONE,SYM_VARIABLE] formula[f]
        	    {
        	         MATCHT(CALL_TOK, &FOLLOW_CALL_TOK_in_mainCommand2583);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_identifier_in_mainCommand2585);
        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2588);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("CALL command"); 
        	        }


        	    }
        	    break;
        	case 29:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:771:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_mainCommand2602);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:772:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt26=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt26=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt26=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 26;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt26)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:772:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_mainCommand2610);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new EchoCommand(sexpr.getValue()); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:774:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new EchoCommand(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 30:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:777:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_mainCommand2640);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new QuitCommand(); 
        	        }


        	    }
        	    break;
        	case 31:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:780:5: INCLUDE_TOK ( ( str[s] | IDENTIFIER ) |)
        	    {
        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_mainCommand2653);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:781:5: ( ( str[s] | IDENTIFIER ) |)
        	        {
        	            int alt28=2;
        	            switch ( LA(1) )
        	            {
        	            case IDENTIFIER:
        	            case STRING_LITERAL:
        	            	{
        	            		alt28=1;
        	            	}
        	                break;
        	            case SEMICOLON:
        	            	{
        	            		alt28=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 28;
        	                EXCEPTION->state        = 0;


        	                goto rulemainCommandEx;

        	            }

        	            switch (alt28)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:781:7: ( str[s] | IDENTIFIER )
        	        	    {
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:781:7: ( str[s] | IDENTIFIER )
        	        	        {
        	        	            int alt27=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case STRING_LITERAL:
        	        	            	{
        	        	            		alt27=1;
        	        	            	}
        	        	                break;
        	        	            case IDENTIFIER:
        	        	            	{
        	        	            		alt27=2;
        	        	            	}
        	        	                break;

        	        	            default:
        	        	                if (BACKTRACKING>0)
        	        	                {
        	        	                    FAILEDFLAG = ANTLR3_TRUE;
        	        	                    return ;
        	        	                }

        	        	                CONSTRUCTEX();
        	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	        	                EXCEPTION->message      = (void *)"";
        	        	                EXCEPTION->decisionNum  = 27;
        	        	                EXCEPTION->state        = 0;


        	        	                goto rulemainCommandEx;

        	        	            }

        	        	            switch (alt27)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:781:9: str[s]
        	        	        	    {
        	        	        	        FOLLOWPUSH(FOLLOW_str_in_mainCommand2663);
        	        	        	        str(ctx, s);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	    }
        	        	        	    break;
        	        	        	case 2:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:781:18: IDENTIFIER
        	        	        	    {
        	        	        	        IDENTIFIER8 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_mainCommand2668);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulemainCommandEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             s = AntlrInput::tokenText(IDENTIFIER8); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	            }
        	        	        }

        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             UNSUPPORTED("INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:783:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->parseError("No filename given to INCLUDE command"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 32:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:786:5: DUMP_PROOF_TOK
        	    {
        	         MATCHT(DUMP_PROOF_TOK, &FOLLOW_DUMP_PROOF_TOK_in_mainCommand2701);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetProofCommand(); 
        	        }


        	    }
        	    break;
        	case 33:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:789:5: ( DUMP_ASSUMPTIONS_TOK | DUMP_SIG_TOK | DUMP_TCC_TOK | DUMP_TCC_ASSUMPTIONS_TOK | DUMP_TCC_PROOF_TOK | DUMP_CLOSURE_TOK | DUMP_CLOSURE_PROOF_TOK )
        	    {
        	        if ( ((LA(1) >= DUMP_ASSUMPTIONS_TOK) && (LA(1) <= DUMP_CLOSURE_TOK)) || ((LA(1) >= DUMP_SIG_TOK) && (LA(1) <= DUMP_TCC_TOK)) )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("DUMP* command"); 
        	        }


        	    }
        	    break;
        	case 34:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:799:5: ( WHERE_TOK | ASSERTIONS_TOK | ASSUMPTIONS_TOK )
        	    {
        	        if ( LA(1) == ASSERTIONS_TOK || LA(1) == ASSUMPTIONS_TOK || LA(1) == WHERE_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulemainCommandEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetAssertionsCommand(); 
        	        }


        	    }
        	    break;
        	case 35:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:802:5: COUNTEREXAMPLE_TOK
        	    {
        	         MATCHT(COUNTEREXAMPLE_TOK, &FOLLOW_COUNTEREXAMPLE_TOK_in_mainCommand2810);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetModelCommand; 
        	        }


        	    }
        	    break;
        	case 36:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:804:5: COUNTERMODEL_TOK
        	    {
        	         MATCHT(COUNTERMODEL_TOK, &FOLLOW_COUNTERMODEL_TOK_in_mainCommand2822);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetModelCommand; 
        	        }


        	    }
        	    break;
        	case 37:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:807:5: ARITH_VAR_ORDER_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN
        	    {
        	         MATCHT(ARITH_VAR_ORDER_TOK, &FOLLOW_ARITH_VAR_ORDER_TOK_in_mainCommand2835);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_mainCommand2837);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2839);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:807:43: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt29=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt29=1;
        	            	}
        	                break;

        	            }

        	            switch (alt29)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:807:45: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_mainCommand2844);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_mainCommand2846);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulemainCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop29;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop29: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_mainCommand2852);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             UNSUPPORTED("ARITH_VAR_ORDER command"); 
        	        }


        	    }
        	    break;
        	case 38:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:810:5: toplevelDeclaration[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_toplevelDeclaration_in_mainCommand2865);
        	        toplevelDeclaration(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulemainCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulemainCommandEx; /* Prevent compiler warnings */
    rulemainCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end mainCommand */

/**
 * $ANTLR start simpleSymbolicExpr
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:813:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER );
 */
static void
simpleSymbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::string s;
      CVC4::Rational r;

    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL9;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL10;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL11;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL12;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL13;
    pANTLR3_COMMON_TOKEN    IDENTIFIER14;

    /* Initialize rule variables
     */

    INTEGER_LITERAL9       = NULL;
    INTEGER_LITERAL10       = NULL;
    DECIMAL_LITERAL11       = NULL;
    HEX_LITERAL12       = NULL;
    BINARY_LITERAL13       = NULL;
    IDENTIFIER14       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:818:3: ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s] | IDENTIFIER )

            ANTLR3_UINT32 alt31;

            alt31=7;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt31=1;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt31=2;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt31=3;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt31=4;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt31=5;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt31=6;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt31=7;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 31;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt31)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:818:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL9 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2885);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL9))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:820:5: MINUS_TOK INTEGER_LITERAL
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_simpleSymbolicExpr2897);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        INTEGER_LITERAL10 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExpr2899);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(-Integer(AntlrInput::tokenText(INTEGER_LITERAL10))); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:822:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExpr2911);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL11)); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:824:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL12 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExpr2923);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(HEX_LITERAL12)); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:826:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL13 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExpr2935);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(BINARY_LITERAL13)); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:828:5: str[s]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExpr2947);
        	        str(ctx, s);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:830:5: IDENTIFIER
        	    {
        	        IDENTIFIER14 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_simpleSymbolicExpr2960);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(IDENTIFIER14)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:834:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN );
 */
static void
symbolicExpr(pCvcParser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:838:3: ( simpleSymbolicExpr[sexpr] | LPAREN ( symbolicExpr[sexpr] )* RPAREN )

            ANTLR3_UINT32 alt33;

            alt33=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case HEX_LITERAL:
            case IDENTIFIER:
            case INTEGER_LITERAL:
            case MINUS_TOK:
            case STRING_LITERAL:
            	{
            		alt33=1;
            	}
                break;
            case LPAREN:
            	{
            		alt33=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 33;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt33)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:838:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr2985);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:839:5: LPAREN ( symbolicExpr[sexpr] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_symbolicExpr2992);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:839:12: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt32=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case HEX_LITERAL:
        	            case IDENTIFIER:
        	            case INTEGER_LITERAL:
        	            case LPAREN:
        	            case MINUS_TOK:
        	            case STRING_LITERAL:
        	            	{
        	            		alt32=1;
        	            	}
        	                break;

        	            }

        	            switch (alt32)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:839:13: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr2995);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop32;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop32: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_symbolicExpr3003);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start toplevelDeclaration
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:846:1: toplevelDeclaration[CVC4::Command*& cmd] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) ;
 */
static void
toplevelDeclaration(pCvcParser ctx, CVC4::Command*& cmd)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      Debug("parser-extra") << "declaration: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:852:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] ) )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:852:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_toplevelDeclaration3030);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_toplevelDeclaration3033);
            if  (HASEXCEPTION())
            {
                goto ruletoplevelDeclarationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:853:5: ( declareVariables[cmd,t,ids,true] | declareTypes[cmd,ids] )
            {
                int alt34=2;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case BITVECTOR_TOK:
                case BOOLEAN_TOK:
                case IDENTIFIER:
                case INT_TOK:
                case LBRACKET:
                case LET_TOK:
                case LPAREN:
                case REAL_TOK:
                case SET_TOK:
                case SQHASH:
                case STRING_TOK:
                case SUBTYPE_TOK:
                	{
                		alt34=1;
                	}
                    break;
                case TYPE_TOK:
                	{
                		alt34=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 34;
                    EXCEPTION->state        = 0;


                    goto ruletoplevelDeclarationEx;

                }

                switch (alt34)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:853:7: declareVariables[cmd,t,ids,true]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareVariables_in_toplevelDeclaration3041);
            	        declareVariables(ctx, cmd, t, ids, true);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:854:7: declareTypes[cmd,ids]
            	    {
            	        FOLLOWPUSH(FOLLOW_declareTypes_in_toplevelDeclaration3050);
            	        declareTypes(ctx, cmd, ids);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletoplevelDeclarationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletoplevelDeclarationEx; /* Prevent compiler warnings */
    ruletoplevelDeclarationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end toplevelDeclaration */

/**
 * $ANTLR start boundVarDecl
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:860:1: boundVarDecl[std::vector<std::string>& ids, CVC4::Type& t] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[*(Command**)NULL,t,ids,false] ;
 */
static void
boundVarDecl(pCvcParser ctx, std::vector<std::string>& ids, CVC4::Type& t)
{
    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:861:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[*(Command**)NULL,t,ids,false] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:861:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON declareVariables[*(Command**)NULL,t,ids,false]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDecl3069);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDecl3072);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_declareVariables_in_boundVarDecl3074);
            declareVariables(ctx, *(Command**)NULL, t, ids, false);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclEx; /* Prevent compiler warnings */
    ruleboundVarDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecl */

/**
 * $ANTLR start boundVarDecls
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:867:1: boundVarDecls : boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* ;
 */
static void
boundVarDecls(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:872:3: ( boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:872:5: boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3095);
            boundVarDecl(ctx, ids, t);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:872:25: ( COMMA boundVarDecl[ids,t] )*

            for (;;)
            {
                int alt35=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt35=1;
                	}
                    break;

                }

                switch (alt35)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:872:27: COMMA boundVarDecl[ids,t]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDecls3100);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_boundVarDecls3102);
            	        boundVarDecl(ctx, ids, t);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop35;	/* break out of the loop */
            	    break;
                }
            }
            loop35: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsEx; /* Prevent compiler warnings */
    ruleboundVarDeclsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDecls */

/**
 * $ANTLR start boundVarDeclsReturn
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:875:1: boundVarDeclsReturn[std::vector<CVC4::Expr>& terms,\n std::vector<CVC4::Type>& types] : boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* ;
 */
static void
boundVarDeclsReturn(pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      terms.clear();
      types.clear();

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:883:3: ( boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:883:5: boundVarDeclReturn[terms,types] ( COMMA boundVarDeclReturn[terms,types] )*
        {
            FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3125);
            boundVarDeclReturn(ctx, terms, types);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclsReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:883:37: ( COMMA boundVarDeclReturn[terms,types] )*

            for (;;)
            {
                int alt36=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt36=1;
                	}
                    break;

                }

                switch (alt36)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:883:39: COMMA boundVarDeclReturn[terms,types]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_boundVarDeclsReturn3130);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_boundVarDeclReturn_in_boundVarDeclsReturn3132);
            	        boundVarDeclReturn(ctx, terms, types);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleboundVarDeclsReturnEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop36;	/* break out of the loop */
            	    break;
                }
            }
            loop36: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclsReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclsReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclsReturn */

/**
 * $ANTLR start boundVarDeclReturn
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:886:1: boundVarDeclReturn[std::vector<CVC4::Expr>& terms,\n std::vector<CVC4::Type>& types] : identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] ;
 */
static void
boundVarDeclReturn(pCvcParser ctx, std::vector<CVC4::Expr>& terms, std::vector<CVC4::Type>& types)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      Type t;
      // NOTE: do not clear the vectors here!

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:893:3: ( identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:893:5: identifierList[ids,CHECK_NONE,SYM_VARIABLE] COLON type[t,CHECK_DECLARED]
        {
            FOLLOWPUSH(FOLLOW_identifierList_in_boundVarDeclReturn3155);
            identifierList(ctx, ids, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_boundVarDeclReturn3158);
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_boundVarDeclReturn3160);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleboundVarDeclReturnEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 const std::vector<Expr>& vars = PARSER_STATE->mkBoundVars(ids, t);
                      terms.insert(terms.end(), vars.begin(), vars.end());
                      for(unsigned i = 0; i < vars.size(); ++i) {
                        types.push_back(t);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleboundVarDeclReturnEx; /* Prevent compiler warnings */
    ruleboundVarDeclReturnEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end boundVarDeclReturn */

/**
 * $ANTLR start declareTypes
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:909:1: declareTypes[CVC4::Command*& cmd, const std::vector<std::string>& idList] : ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] );
 */
static void
declareTypes(pCvcParser ctx, CVC4::Command*& cmd, const std::vector<std::string>& idList)
{
    /* Initialize rule variables
     */


      Type t;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:914:3: ( TYPE_TOK | TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED] )

            ANTLR3_UINT32 alt37;

            alt37=2;

            switch ( LA(1) )
            {
            case TYPE_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case EQUAL_TOK:
            			{
            				alt37=2;
            			}
            		    break;
            		case SEMICOLON:
            			{
            				alt37=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 37;
            		    EXCEPTION->state        = 1;


            		    goto ruledeclareTypesEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 37;
                EXCEPTION->state        = 0;


                goto ruledeclareTypesEx;

            }

            switch (alt37)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:914:5: TYPE_TOK
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3194);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             DeclarationSequence* seq = new DeclarationSequence();
        	                  for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end();
        	                      ++i) {
        	                    // Don't allow a type variable to clash with a previously
        	                    // declared type variable, however a type variable and a
        	                    // non-type variable can clash unambiguously.  Break from CVC3
        	                    // behavior here.
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    Type sort = PARSER_STATE->mkSort(*i);
        	                    Command* decl = new DeclareTypeCommand(*i, 0, sort);
        	                    seq->addCommand(decl);
        	                  }
        	                  cmd = seq;
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:932:5: TYPE_TOK EQUAL_TOK type[t,CHECK_DECLARED]
        	    {
        	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_declareTypes3213);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareTypes3215);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_declareTypes3217);
        	        type(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruledeclareTypesEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = idList.begin();
        	                      i != idList.end();
        	                      ++i) {
        	                    PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_SORT);
        	                    PARSER_STATE->defineType(*i, t);
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruledeclareTypesEx; /* Prevent compiler warnings */
    ruledeclareTypesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareTypes */

/**
 * $ANTLR start declareVariables
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:951:1: declareVariables[CVC4::Command*& cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel] : type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? ;
 */
static void
declareVariables(pCvcParser ctx, CVC4::Command*& cmd, CVC4::Type& t, const std::vector<std::string>& idList, bool topLevel)
{
    /* Initialize rule variables
     */


      Expr f;
      Debug("parser-extra") << "declType: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:957:3: ( type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )? )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:957:5: type[t,CHECK_DECLARED] ( EQUAL_TOK formula[f] )?
        {
            FOLLOWPUSH(FOLLOW_type_in_declareVariables3251);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledeclareVariablesEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:957:28: ( EQUAL_TOK formula[f] )?
            {
                int alt38=2;
                switch ( LA(1) )
                {
                    case EQUAL_TOK:
                    	{
                    		alt38=1;
                    	}
                        break;
                }

                switch (alt38)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:957:30: EQUAL_TOK formula[f]
            	    {
            	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_declareVariables3256);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_declareVariables3258);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledeclareVariablesEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 DeclarationSequence* seq = NULL;
                      if(topLevel) {
                        cmd = seq = new DeclarationSequence();
                      }
                      if(f.isNull()) {
                        Debug("parser") << "working on " << idList.front() << " : " << t << std::endl;
                        // CVC language allows redeclaration of variables if types are the same
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          if(PARSER_STATE->isDeclared(*i, SYM_VARIABLE)) {
                            Type oldType = PARSER_STATE->getType(*i);
                            Debug("parser") << "  " << *i << " was declared previously "
                                            << "with type " << oldType << std::endl;
                            if(oldType != t) {
                              std::stringstream ss;
                              ss << Expr::setlanguage(language::output::LANG_CVC4)
                                 << "incompatible type for `" << *i << "':" << std::endl
                                 << "  old type: " << oldType << std::endl
                                 << "  new type: " << t << std::endl;
                              PARSER_STATE->parseError(ss.str());
                            } else {
                              Debug("parser") << "  types " << t << " and " << oldType
                                              << " are compatible" << std::endl;
                            }
                          } else {
                            Debug("parser") << "  " << *i << " not declared" << std::endl;
                            if(topLevel) {
                              Expr func = PARSER_STATE->mkVar(*i, t, ExprManager::VAR_FLAG_GLOBAL);
                              Command* decl = new DeclareFunctionCommand(*i, func, t);
                              seq->addCommand(decl);
                            } else {
                              PARSER_STATE->mkBoundVar(*i, t);
                            }
                          }
                        }
                      } else {
                        // f is not null-- meaning this is a definition not a declaration
                        if(!topLevel) {
                          // must be top-level; doesn't make sense to write something
                          // like e.g. FORALL(x:INT = 4): [...]
                          PARSER_STATE->parseError("cannot construct a definition here; maybe you want a LET");
                        }
                        assert(!idList.empty());
                        for(std::vector<std::string>::const_iterator i = idList.begin(),
                              i_end = idList.end();
                            i != i_end;
                            ++i) {
                          Debug("parser") << "making " << *i << " : " << t << " = " << f << std::endl;
                          PARSER_STATE->checkDeclaration(*i, CHECK_UNDECLARED, SYM_VARIABLE);
                          Expr func = EXPR_MANAGER->mkVar(*i, t, ExprManager::VAR_FLAG_GLOBAL | ExprManager::VAR_FLAG_DEFINED);
                          PARSER_STATE->defineFunction(*i, f);
                          Command* decl = new DefineFunctionCommand(*i, func, f);
                          seq->addCommand(decl);
                        }
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledeclareVariablesEx; /* Prevent compiler warnings */
    ruledeclareVariablesEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end declareVariables */

/**
 * $ANTLR start identifierList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1024:1: identifierList[std::vector<std::string>& idList,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : identifier[id,check,type] ( COMMA identifier[id,check,type] )* ;
 */
static void
identifierList(pCvcParser ctx, std::vector<std::string>& idList, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    /* Initialize rule variables
     */


      std::string id;
      idList.clear();

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1031:3: ( identifier[id,check,type] ( COMMA identifier[id,check,type] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1031:5: identifier[id,check,type] ( COMMA identifier[id,check,type] )*
        {
            FOLLOWPUSH(FOLLOW_identifier_in_identifierList3289);
            identifier(ctx, id, check, type);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleidentifierListEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 idList.push_back(id); 
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1032:5: ( COMMA identifier[id,check,type] )*

            for (;;)
            {
                int alt39=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt39=1;
                	}
                    break;

                }

                switch (alt39)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1032:7: COMMA identifier[id,check,type]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_identifierList3300);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_identifier_in_identifierList3302);
            	        identifier(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleidentifierListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             idList.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop39;	/* break out of the loop */
            	    break;
                }
            }
            loop39: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierListEx; /* Prevent compiler warnings */
    ruleidentifierListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifierList */

/**
 * $ANTLR start identifier
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1038:1: identifier[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : IDENTIFIER ;
 */
static void
identifier(pCvcParser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    IDENTIFIER15;

    /* Initialize rule variables
     */

    IDENTIFIER15       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1041:3: ( IDENTIFIER )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1041:5: IDENTIFIER
        {
            IDENTIFIER15 = (pANTLR3_COMMON_TOKEN) MATCHT(IDENTIFIER, &FOLLOW_IDENTIFIER_in_identifier3324);
            if  (HASEXCEPTION())
            {
                goto ruleidentifierEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 id = AntlrInput::tokenText(IDENTIFIER15);
                      PARSER_STATE->checkDeclaration(id, check, type); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleidentifierEx; /* Prevent compiler warnings */
    ruleidentifierEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end identifier */

/**
 * $ANTLR start type
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1058:1: type[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check] : ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] );
 */
static void
type(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      Type t2;
      bool lhs;
      std::vector<Type> args;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1066:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )? | LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check] )

            ANTLR3_UINT32 alt42;

            alt42=2;

            switch ( LA(1) )
            {
            case ARRAY_TOK:
            case BITVECTOR_TOK:
            case BOOLEAN_TOK:
            case IDENTIFIER:
            case INT_TOK:
            case LBRACKET:
            case LPAREN:
            case REAL_TOK:
            case SET_TOK:
            case SQHASH:
            case STRING_TOK:
            case SUBTYPE_TOK:
            	{
            		alt42=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt42=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 42;
                EXCEPTION->state        = 0;


                goto ruletypeEx;

            }

            switch (alt42)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1066:5: restrictedTypePossiblyFunctionLHS[t,check,lhs] ( ARROW_TOK type[t2,check] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_type3357);
        	        restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) {
        	                    assert(t.isTuple());
        	                    args = TupleType(t).getTypes();
        	                  } else {
        	                    args.push_back(t);
        	                  }
        	                
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1074:5: ( ARROW_TOK type[t2,check] )?
        	        {
        	            int alt40=2;
        	            switch ( LA(1) )
        	            {
        	                case ARROW_TOK:
        	                	{
        	                		alt40=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt40)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1074:7: ARROW_TOK type[t2,check]
        	        	    {
        	        	         MATCHT(ARROW_TOK, &FOLLOW_ARROW_TOK_in_type3372);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_type3374);
        	        	        type(ctx, t2, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(t2); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             if(t2.isNull()) {
        	                    if(lhs) {
        	                      PARSER_STATE->parseError("improperly-placed type list; expected `->' after to define a function; or else maybe these parentheses were meant to be square brackets, to define a tuple type?");
        	                    }
        	                  } else {
        	                    t = EXPR_MANAGER->mkFunctionType(args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1087:5: LET_TOK typeLetDecl[check] ( COMMA typeLetDecl[check] )* IN_TOK type[t,check]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_type3399);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3407);
        	        typeLetDecl(ctx, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1088:24: ( COMMA typeLetDecl[check] )*

        	        for (;;)
        	        {
        	            int alt41=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt41=1;
        	            	}
        	                break;

        	            }

        	            switch (alt41)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1088:26: COMMA typeLetDecl[check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_type3412);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_typeLetDecl_in_type3414);
        	        	        typeLetDecl(ctx, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruletypeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop41;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop41: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_type3420);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_type3422);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletypeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletypeEx; /* Prevent compiler warnings */
    ruletypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end type */

/**
 * $ANTLR start restrictedType
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1102:1: restrictedType[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check] : restrictedTypePossiblyFunctionLHS[t,check,lhs] ;
 */
static void
restrictedType(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      bool lhs;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1107:3: ( restrictedTypePossiblyFunctionLHS[t,check,lhs] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1107:5: restrictedTypePossiblyFunctionLHS[t,check,lhs]
        {
            FOLLOWPUSH(FOLLOW_restrictedTypePossiblyFunctionLHS_in_restrictedType3458);
            restrictedTypePossiblyFunctionLHS(ctx, t, check, lhs);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerestrictedTypeEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 if(lhs) { PARSER_STATE->parseError("improperly-placed type list; maybe these parentheses were meant to be square brackets, to define a tuple type?"); } 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypeEx; /* Prevent compiler warnings */
    rulerestrictedTypeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedType */

/**
 * $ANTLR start restrictedTypePossiblyFunctionLHS
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1115:1: restrictedTypePossiblyFunctionLHS[CVC4::Type& t,\n CVC4::parser::DeclarationCheck check,\n bool& lhs] : ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET k1= bound DOTDOT k2= bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN );
 */
static void
restrictedTypePossiblyFunctionLHS(pCvcParser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check, bool& lhs)
{
    CVC4::parser::cvc::mySubrangeBound k1;
    #undef	RETURN_TYPE_k1
    #define	RETURN_TYPE_k1 CVC4::parser::cvc::mySubrangeBound

    CVC4::parser::cvc::mySubrangeBound k2;
    #undef	RETURN_TYPE_k2
    #define	RETURN_TYPE_k2 CVC4::parser::cvc::mySubrangeBound

    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Type t2;
      Expr f, f2;
      std::string id;
      std::vector<Type> types;
      std::vector< std::pair<std::string, Type> > typeIds;
      //SymbolTable* symtab;
      Parser* parser;
      lhs = false;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1129:3: ( identifier[id,check,SYM_SORT] ( parameterization[check,types] )? | ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check] | SET_TOK OF_TOK restrictedType[t,check] | SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN | LBRACKET k1= bound DOTDOT k2= bound RBRACKET | LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET | SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ | BITVECTOR_TOK LPAREN k= numeral RPAREN | STRING_TOK | BOOLEAN_TOK | REAL_TOK | INT_TOK | LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN )

            ANTLR3_UINT32 alt50;

            alt50=13;

            switch ( LA(1) )
            {
            case IDENTIFIER:
            	{
            		alt50=1;
            	}
                break;
            case ARRAY_TOK:
            	{
            		alt50=2;
            	}
                break;
            case SET_TOK:
            	{
            		alt50=3;
            	}
                break;
            case SUBTYPE_TOK:
            	{
            		alt50=4;
            	}
                break;
            case LBRACKET:
            	{
            		switch ( LA(2) )
            		{
            		case INTEGER_LITERAL:
            		case MINUS_TOK:
            		case UNDERSCORE:
            			{
            				alt50=5;
            			}
            		    break;
            		case ARRAY_TOK:
            		case BITVECTOR_TOK:
            		case BOOLEAN_TOK:
            		case IDENTIFIER:
            		case INT_TOK:
            		case LBRACKET:
            		case LET_TOK:
            		case LPAREN:
            		case RBRACKET:
            		case REAL_TOK:
            		case SET_TOK:
            		case SQHASH:
            		case STRING_TOK:
            		case SUBTYPE_TOK:
            			{
            				alt50=6;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 50;
            		    EXCEPTION->state        = 5;


            		    goto rulerestrictedTypePossiblyFunctionLHSEx;

            		}

            	}
                break;
            case SQHASH:
            	{
            		alt50=7;
            	}
                break;
            case BITVECTOR_TOK:
            	{
            		alt50=8;
            	}
                break;
            case STRING_TOK:
            	{
            		alt50=9;
            	}
                break;
            case BOOLEAN_TOK:
            	{
            		alt50=10;
            	}
                break;
            case REAL_TOK:
            	{
            		alt50=11;
            	}
                break;
            case INT_TOK:
            	{
            		alt50=12;
            	}
                break;
            case LPAREN:
            	{
            		alt50=13;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 50;
                EXCEPTION->state        = 0;


                goto rulerestrictedTypePossiblyFunctionLHSEx;

            }

            switch (alt50)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1129:5: identifier[id,check,SYM_SORT] ( parameterization[check,types] )?
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3492);
        	        identifier(ctx, id, check, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1130:5: ( parameterization[check,types] )?
        	        {
        	            int alt43=2;
        	            switch ( LA(1) )
        	            {
        	                case LBRACKET:
        	                	{
        	                		switch ( LA(2) )
        	                		{
        	                		    case IDENTIFIER:
        	                		    	{
        	                		    		switch ( LA(3) )
        	                		    		{
        	                		    		    case COMMA:
        	                		    		    case LBRACKET:
        	                		    		    case RBRACKET:
        	                		    		    	{
        	                		    		    		alt43=1;
        	                		    		    	}
        	                		    		        break;
        	                		    		}

        	                		    	}
        	                		        break;
        	                		    case ARRAY_TOK:
        	                		    case BITVECTOR_TOK:
        	                		    case BOOLEAN_TOK:
        	                		    case INT_TOK:
        	                		    case LBRACKET:
        	                		    case LPAREN:
        	                		    case REAL_TOK:
        	                		    case SET_TOK:
        	                		    case SQHASH:
        	                		    case STRING_TOK:
        	                		    case SUBTYPE_TOK:
        	                		    	{
        	                		    		alt43=1;
        	                		    	}
        	                		        break;
        	                		}

        	                	}
        	                    break;
        	            }

        	            switch (alt43)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1130:5: parameterization[check,types]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_parameterization_in_restrictedTypePossiblyFunctionLHS3499);
        	        	        parameterization(ctx, check, types);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(check == CHECK_DECLARED ||
        	                     PARSER_STATE->isDeclared(id, SYM_SORT)) {
        	                    Debug("parser-param") << "param: getSort " << id << " " << types.size() << " " << PARSER_STATE->getArity( id )
        	                                          << " " << PARSER_STATE->isDeclared(id, SYM_SORT) << std::endl;
        	                    if(types.size() != PARSER_STATE->getArity(id)) {
        	                      std::stringstream ss;
        	                      ss << "incorrect arity for symbol `" << id << "': expected "
        	                         << PARSER_STATE->getArity( id ) << " type arguments, got "
        	                         << types.size();
        	                      PARSER_STATE->parseError(ss.str());
        	                    }
        	                    if(types.size() > 0) {
        	                      t = PARSER_STATE->getSort(id, types);
        	                    }else{
        	                      t = PARSER_STATE->getSort(id);
        	                    }
        	                  } else {
        	                    if(types.empty()) {
        	                      t = PARSER_STATE->mkUnresolvedType(id);
        	                      Debug("parser-param") << "param: make unres type " << id << std::endl;
        	                    }else{
        	                      t = PARSER_STATE->mkUnresolvedTypeConstructor(id,types);
        	                      t = SortConstructorType(t).instantiate( types );
        	                      Debug("parser-param") << "param: make unres param type " << id << " " << types.size() << " "
        	                                            << PARSER_STATE->getArity( id ) << std::endl;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1162:5: ARRAY_TOK restrictedType[t,check] OF_TOK restrictedType[t2,check]
        	    {
        	         MATCHT(ARRAY_TOK, &FOLLOW_ARRAY_TOK_in_restrictedTypePossiblyFunctionLHS3520);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3522);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3525);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3527);
        	        restrictedType(ctx, t2, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkArrayType(t, t2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1164:5: SET_TOK OF_TOK restrictedType[t,check]
        	    {
        	         MATCHT(SET_TOK, &FOLLOW_SET_TOK_in_restrictedTypePossiblyFunctionLHS3540);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(OF_TOK, &FOLLOW_OF_TOK_in_restrictedTypePossiblyFunctionLHS3542);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_restrictedType_in_restrictedTypePossiblyFunctionLHS3544);
        	        restrictedType(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkSetType(t); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1168:5: SUBTYPE_TOK LPAREN formula[f] ( COMMA formula[f2] )? RPAREN
        	    {
        	         MATCHT(SUBTYPE_TOK, &FOLLOW_SUBTYPE_TOK_in_restrictedTypePossiblyFunctionLHS3564);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3566);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /*symtab = PARSER_STATE->getSymbolTable();
        	                  PARSER_STATE->useDeclarationsFrom(new SymbolTable());*/ 
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3584);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1175:16: ( COMMA formula[f2] )?
        	        {
        	            int alt44=2;
        	            switch ( LA(1) )
        	            {
        	                case COMMA:
        	                	{
        	                		alt44=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt44)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1175:18: COMMA formula[f2]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3589);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_restrictedTypePossiblyFunctionLHS3591);
        	        	        formula(ctx, f2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3597);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /*SymbolTable* old = PARSER_STATE->getSymbolTable();
        	                  PARSER_STATE->useDeclarationsFrom(symtab);
        	                  delete old;*/
        	                  PARSER_STATE->unimplementedFeature("predicate subtyping not supported in this release");
        	                  /*t = f2.isNull() ?
        	                    EXPR_MANAGER->mkPredicateSubtype(f) :
        	                    EXPR_MANAGER->mkPredicateSubtype(f, f2);
        	                  */
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1187:5: LBRACKET k1= bound DOTDOT k2= bound RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3616);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3620);
        	        k1=bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(DOTDOT, &FOLLOW_DOTDOT_in_restrictedTypePossiblyFunctionLHS3622);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bound_in_restrictedTypePossiblyFunctionLHS3626);
        	        k2=bound(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3628);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(k1.hasBound() && k2.hasBound() &&
        	                     k1.getBound() > k2.getBound()) {
        	                    std::stringstream ss;
        	                    ss << "Subrange [" << k1.getBound() << ".." << k2.getBound()
        	                       << "] inappropriate: range must be nonempty!";
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  t = EXPR_MANAGER->mkSubrangeType(SubrangeBounds(k1, k2));
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1199:5: LBRACKET ( type[t,check] ( COMMA type[t,check] )* )? RBRACKET
        	    {
        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_restrictedTypePossiblyFunctionLHS3647);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1199:14: ( type[t,check] ( COMMA type[t,check] )* )?
        	        {
        	            int alt46=2;
        	            switch ( LA(1) )
        	            {
        	                case ARRAY_TOK:
        	                case BITVECTOR_TOK:
        	                case BOOLEAN_TOK:
        	                case IDENTIFIER:
        	                case INT_TOK:
        	                case LBRACKET:
        	                case LET_TOK:
        	                case LPAREN:
        	                case REAL_TOK:
        	                case SET_TOK:
        	                case SQHASH:
        	                case STRING_TOK:
        	                case SUBTYPE_TOK:
        	                	{
        	                		alt46=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt46)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1199:16: type[t,check] ( COMMA type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3651);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             types.push_back(t); 
        	        	        }


        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1200:5: ( COMMA type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt45=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt45=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt45)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1200:7: COMMA type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3662);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3664);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             types.push_back(t); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop45;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop45: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_restrictedTypePossiblyFunctionLHS3675);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(types.size() == 1 && types.front().isFunction()) {
        	                    // old style function syntax [ T -> U ]
        	                    PARSER_STATE->parseError("old-style function type syntax not supported anymore; please use the new syntax");
        	                  } else {
        	                    // tuple type [ T, U, V... ]
        	                    t = EXPR_MANAGER->mkTupleType(types);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1211:5: SQHASH ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )? HASHSQ
        	    {
        	         MATCHT(SQHASH, &FOLLOW_SQHASH_in_restrictedTypePossiblyFunctionLHS3694);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1211:12: ( identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )* )?
        	        {
        	            int alt48=2;
        	            switch ( LA(1) )
        	            {
        	                case IDENTIFIER:
        	                	{
        	                		alt48=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt48)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1211:14: identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3698);
        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3701);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3703);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        }


        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1212:5: ( COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check] )*

        	        	        for (;;)
        	        	        {
        	        	            int alt47=2;
        	        	            switch ( LA(1) )
        	        	            {
        	        	            case COMMA:
        	        	            	{
        	        	            		alt47=1;
        	        	            	}
        	        	                break;

        	        	            }

        	        	            switch (alt47)
        	        	            {
        	        	        	case 1:
        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1212:7: COMMA identifier[id,CHECK_NONE,SYM_SORT] COLON type[t,check]
        	        	        	    {
        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3714);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_identifier_in_restrictedTypePossiblyFunctionLHS3716);
        	        	        	        identifier(ctx, id, CHECK_NONE, SYM_SORT);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	         MATCHT(COLON, &FOLLOW_COLON_in_restrictedTypePossiblyFunctionLHS3719);
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3721);
        	        	        	        type(ctx, t, check);

        	        	        	        FOLLOWPOP();
        	        	        	        if  (HASEXCEPTION())
        	        	        	        {
        	        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        	        }
        	        	        	        if (HASFAILED())
        	        	        	        {
        	        	        	            return ;
        	        	        	        }


        	        	        	        if ( BACKTRACKING==0 )
        	        	        	        {
        	        	        	             typeIds.push_back(std::make_pair(id, t)); 
        	        	        	        }


        	        	        	    }
        	        	        	    break;

        	        	        	default:
        	        	        	    goto loop47;	/* break out of the loop */
        	        	        	    break;
        	        	            }
        	        	        }
        	        	        loop47: ; /* Jump out to here if this rule does not match */


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(HASHSQ, &FOLLOW_HASHSQ_in_restrictedTypePossiblyFunctionLHS3732);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->mkRecordType(typeIds); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1216:5: BITVECTOR_TOK LPAREN k= numeral RPAREN
        	    {
        	         MATCHT(BITVECTOR_TOK, &FOLLOW_BITVECTOR_TOK_in_restrictedTypePossiblyFunctionLHS3751);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3753);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_restrictedTypePossiblyFunctionLHS3757);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3759);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(k == 0) {
        	                    PARSER_STATE->parseError("Illegal bitvector size: 0");
        	                  }
        	                  t = EXPR_MANAGER->mkBitVectorType(k);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1224:5: STRING_TOK
        	    {
        	         MATCHT(STRING_TOK, &FOLLOW_STRING_TOK_in_restrictedTypePossiblyFunctionLHS3778);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->stringType(); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1227:5: BOOLEAN_TOK
        	    {
        	         MATCHT(BOOLEAN_TOK, &FOLLOW_BOOLEAN_TOK_in_restrictedTypePossiblyFunctionLHS3793);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->booleanType(); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1228:5: REAL_TOK
        	    {
        	         MATCHT(REAL_TOK, &FOLLOW_REAL_TOK_in_restrictedTypePossiblyFunctionLHS3801);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->realType(); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1229:5: INT_TOK
        	    {
        	         MATCHT(INT_TOK, &FOLLOW_INT_TOK_in_restrictedTypePossiblyFunctionLHS3809);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             t = EXPR_MANAGER->integerType(); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1234:5: LPAREN type[t,check] ( COMMA type[t,check] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_restrictedTypePossiblyFunctionLHS3824);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3826);
        	        type(ctx, t, check);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             types.push_back(t); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1235:5: ( COMMA type[t,check] )*

        	        for (;;)
        	        {
        	            int alt49=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt49=1;
        	            	}
        	                break;

        	            }

        	            switch (alt49)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1235:7: COMMA type[t,check]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_restrictedTypePossiblyFunctionLHS3837);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_type_in_restrictedTypePossiblyFunctionLHS3839);
        	        	        type(ctx, t, check);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             lhs = true; types.push_back(t); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop49;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop49: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_restrictedTypePossiblyFunctionLHS3847);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerestrictedTypePossiblyFunctionLHSEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(lhs) { t = EXPR_MANAGER->mkTupleType(types); }
        	                  // if !lhs, t is already set up correctly, nothing to do..
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerestrictedTypePossiblyFunctionLHSEx; /* Prevent compiler warnings */
    rulerestrictedTypePossiblyFunctionLHSEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end restrictedTypePossiblyFunctionLHS */

/**
 * $ANTLR start parameterization
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1241:1: parameterization[CVC4::parser::DeclarationCheck check,\n std::vector<CVC4::Type>& params] : LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET ;
 */
static void
parameterization(pCvcParser ctx, CVC4::parser::DeclarationCheck check, std::vector<CVC4::Type>& params)
{
    /* Initialize rule variables
     */


      Type t;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1246:3: ( LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1246:5: LBRACKET restrictedType[t,check] ( COMMA restrictedType[t,check] )* RBRACKET
        {
             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_parameterization3872);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization3874);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1247:5: ( COMMA restrictedType[t,check] )*

            for (;;)
            {
                int alt51=2;
                switch ( LA(1) )
                {
                case COMMA:
                	{
                		alt51=1;
                	}
                    break;

                }

                switch (alt51)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1247:7: COMMA restrictedType[t,check]
            	    {
            	         MATCHT(COMMA, &FOLLOW_COMMA_in_parameterization3885);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_restrictedType_in_parameterization3887);
            	        restrictedType(ctx, t, check);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleparameterizationEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             Debug("parser-param") << "t = " << t << std::endl; params.push_back( t ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop51;	/* break out of the loop */
            	    break;
                }
            }
            loop51: ; /* Jump out to here if this rule does not match */


             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_parameterization3895);
            if  (HASEXCEPTION())
            {
                goto ruleparameterizationEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleparameterizationEx; /* Prevent compiler warnings */
    ruleparameterizationEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end parameterization */

/**
 * $ANTLR start bound
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1250:1: bound returns [CVC4::parser::cvc::mySubrangeBound bound] : ( UNDERSCORE |k= integer );
 */
static CVC4::parser::cvc::mySubrangeBound
bound(pCvcParser ctx)
{
    CVC4::parser::cvc::mySubrangeBound bound;


    CVC4::Rational k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k CVC4::Rational

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1251:3: ( UNDERSCORE |k= integer )

            ANTLR3_UINT32 alt52;

            alt52=2;

            switch ( LA(1) )
            {
            case UNDERSCORE:
            	{
            		alt52=1;
            	}
                break;
            case INTEGER_LITERAL:
            case MINUS_TOK:
            	{
            		alt52=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return bound;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 52;
                EXCEPTION->state        = 0;


                goto ruleboundEx;

            }

            switch (alt52)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1251:5: UNDERSCORE
        	    {
        	         MATCHT(UNDERSCORE, &FOLLOW_UNDERSCORE_in_bound3912);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return bound;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             bound= SubrangeBound();
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1252:5: k= integer
        	    {
        	        FOLLOWPUSH(FOLLOW_integer_in_bound3922);
        	        k=integer(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleboundEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return bound;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             bound= SubrangeBound(k.getNumerator());
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleboundEx; /* Prevent compiler warnings */
    ruleboundEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return bound;
}
/* $ANTLR end bound */

/**
 * $ANTLR start typeLetDecl
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1255:1: typeLetDecl[CVC4::parser::DeclarationCheck check] : identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] ;
 */
static void
typeLetDecl(pCvcParser ctx, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */


      Type t;
      std::string id;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1260:3: ( identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1260:5: identifier[id,CHECK_NONE,SYM_SORT] ( COLON TYPE_TOK )? EQUAL_TOK restrictedType[t,check]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_typeLetDecl3941);
            identifier(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1260:40: ( COLON TYPE_TOK )?
            {
                int alt53=2;
                switch ( LA(1) )
                {
                    case COLON:
                    	{
                    		alt53=1;
                    	}
                        break;
                }

                switch (alt53)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1260:41: COLON TYPE_TOK
            	    {
            	         MATCHT(COLON, &FOLLOW_COLON_in_typeLetDecl3945);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(TYPE_TOK, &FOLLOW_TYPE_TOK_in_typeLetDecl3947);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletypeLetDeclEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_typeLetDecl3951);
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_restrictedType_in_typeLetDecl3953);
            restrictedType(ctx, t, check);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeLetDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->defineType(id, t); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletypeLetDeclEx; /* Prevent compiler warnings */
    ruletypeLetDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeLetDecl */

/**
 * $ANTLR start formula
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1271:1: formula[CVC4::Expr& f] : n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static void
formula(pCvcParser ctx, CVC4::Expr& f)
{
    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */


      Debug("parser-extra") << "formula: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Expr f2;
      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1279:3: (n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1279:5: n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_nots_in_formula3983);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleformulaEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1280:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt55=2;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA:
                case LET_TOK:
                	{
                		alt55=1;
                	}
                    break;
                case ABS_TOK:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case SCONCAT_TOK:
                case SCONTAINS_TOK:
                case SINDEXOF_TOK:
                case SPREFIXOF_TOK:
                case SREPLACE_TOK:
                case SSUBSTR_TOK:
                case SSUFFIXOF_TOK:
                case STOINTEGER_TOK:
                case STORE_TOK:
                case STOSTRING_TOK:
                case STRING_LITERAL:
                case SX_TOK:
                case TRUE_TOK:
                	{
                		alt55=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 55;
                    EXCEPTION->state        = 0;


                    goto ruleformulaEx;

                }

                switch (alt55)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1280:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_formula3991);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1282:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_formula4008);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleformulaEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1286:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt54=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case OR_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt54=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt54)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1286:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_formula4025);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleformulaEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	        if ( BACKTRACKING==0 )
            	        {
            	             f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruleformulaEx; /* Prevent compiler warnings */
    ruleformulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end formula */

/**
 * $ANTLR start morecomparisons
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1291:1: morecomparisons[std::vector<CVC4::Expr>& expressions,\n std::vector<unsigned>& operators] returns [size_t i = 0] : booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) ;
 */
static size_t
morecomparisons(pCvcParser ctx, std::vector<CVC4::Expr>& expressions, std::vector<unsigned>& operators)
{
    size_t i;


    size_t n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n size_t

    /* Initialize rule variables
     */
    i =  0;



      unsigned op;
      Expr f;
      i= expressions.size();


    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1298:3: ( booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? ) )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1298:5: booleanBinop[op] n= nots ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
        {
            FOLLOWPUSH(FOLLOW_booleanBinop_in_morecomparisons4064);
            booleanBinop(ctx, op);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            if ( BACKTRACKING==0 )
            {
                 operators.push_back(op); 
            }


            FOLLOWPUSH(FOLLOW_nots_in_morecomparisons4075);
            n=nots(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulemorecomparisonsEx;
            }
            if (HASFAILED())
            {
                return i;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1300:5: ( prefixFormula[f] | comparison[f] ( morecomparisons[expressions,operators] )? )
            {
                int alt57=2;
                switch ( LA(1) )
                {
                case ARRAY_TOK:
                case EXISTS_TOK:
                case FORALL_TOK:
                case LAMBDA:
                case LET_TOK:
                	{
                		alt57=1;
                	}
                    break;
                case ABS_TOK:
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNEG_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case DISTINCT_TOK:
                case DIVISIBLE_TOK:
                case FALSE_TOK:
                case FLOOR_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IF_TOK:
                case INTEGER_LITERAL:
                case IS_INTEGER_TOK:
                case LBRACE:
                case LPAREN:
                case MINUS_TOK:
                case PARENHASH:
                case SCONCAT_TOK:
                case SCONTAINS_TOK:
                case SINDEXOF_TOK:
                case SPREFIXOF_TOK:
                case SREPLACE_TOK:
                case SSUBSTR_TOK:
                case SSUFFIXOF_TOK:
                case STOINTEGER_TOK:
                case STORE_TOK:
                case STOSTRING_TOK:
                case STRING_LITERAL:
                case SX_TOK:
                case TRUE_TOK:
                	{
                		alt57=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return i;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 57;
                    EXCEPTION->state        = 0;


                    goto rulemorecomparisonsEx;

                }

                switch (alt57)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1300:7: prefixFormula[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_prefixFormula_in_morecomparisons4083);
            	        prefixFormula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             expressions.push_back(addNots(EXPR_MANAGER, n, f)); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1302:7: comparison[f] ( morecomparisons[expressions,operators] )?
            	    {
            	        FOLLOWPUSH(FOLLOW_comparison_in_morecomparisons4100);
            	        comparison(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulemorecomparisonsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return i;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = addNots(EXPR_MANAGER, n, f);
            	                    expressions.push_back(f);
            	                  
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1306:7: ( morecomparisons[expressions,operators] )?
            	        {
            	            int alt56=2;
            	            switch ( LA(1) )
            	            {
            	                case AND_TOK:
            	                case IFF_TOK:
            	                case IMPLIES_TOK:
            	                case OR_TOK:
            	                case XOR_TOK:
            	                	{
            	                		alt56=1;
            	                	}
            	                    break;
            	            }

            	            switch (alt56)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1306:7: morecomparisons[expressions,operators]
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_morecomparisons_in_morecomparisons4117);
            	        	        morecomparisons(ctx, expressions, operators);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulemorecomparisonsEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return i;
            	        	        }


            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulemorecomparisonsEx; /* Prevent compiler warnings */
    rulemorecomparisonsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return i;
}
/* $ANTLR end morecomparisons */

/**
 * $ANTLR start nots
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1311:1: nots returns [size_t n = 0] : ( NOT_TOK )* ;
 */
static size_t
nots(pCvcParser ctx)
{
    size_t n;


    /* Initialize rule variables
     */
    n =  0;


    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1312:3: ( ( NOT_TOK )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1312:5: ( NOT_TOK )*
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1312:5: ( NOT_TOK )*

            for (;;)
            {
                int alt58=2;
                switch ( LA(1) )
                {
                case NOT_TOK:
                	{
                		alt58=1;
                	}
                    break;

                }

                switch (alt58)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1312:7: NOT_TOK
            	    {
            	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_nots4146);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulenotsEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return n;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             ++n
            	            ; 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop58;	/* break out of the loop */
            	    break;
                }
            }
            loop58: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulenotsEx; /* Prevent compiler warnings */
    rulenotsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return n;
}
/* $ANTLR end nots */

/**
 * $ANTLR start prefixFormula
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1315:1: prefixFormula[CVC4::Expr& f] : ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] | ARRAY_TOK LPAREN boundVarDecl[ids,t] RPAREN COLON formula[f] );
 */
static void
prefixFormula(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<std::string> ids;
      std::vector<Expr> terms;
      std::vector<Type> types;
      std::vector<Expr> bvs;
      Type t;
      Kind k;
      Expr ipl;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1326:3: ( ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f] | LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f] | LAMBDA LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f] | ARRAY_TOK LPAREN boundVarDecl[ids,t] RPAREN COLON formula[f] )

            ANTLR3_UINT32 alt63;

            alt63=4;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            case FORALL_TOK:
            	{
            		alt63=1;
            	}
                break;
            case LET_TOK:
            	{
            		alt63=2;
            	}
                break;
            case LAMBDA:
            	{
            		alt63=3;
            	}
                break;
            case ARRAY_TOK:
            	{
            		alt63=4;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 63;
                EXCEPTION->state        = 0;


                goto ruleprefixFormulaEx;

            }

            switch (alt63)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1326:5: ( FORALL_TOK | EXISTS_TOK ) LPAREN boundVarDecl[ids,t] ( COMMA boundVarDecl[ids,t] )* RPAREN COLON ( instantiationPatterns[ipl] )? formula[f]
        	    {
        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1326:5: ( FORALL_TOK | EXISTS_TOK )
        	        {
        	            int alt59=2;
        	            switch ( LA(1) )
        	            {
        	            case FORALL_TOK:
        	            	{
        	            		alt59=1;
        	            	}
        	                break;
        	            case EXISTS_TOK:
        	            	{
        	            		alt59=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 59;
        	                EXCEPTION->state        = 0;


        	                goto ruleprefixFormulaEx;

        	            }

        	            switch (alt59)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1326:7: FORALL_TOK
        	        	    {
        	        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_prefixFormula4178);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = kind::FORALL; 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1326:42: EXISTS_TOK
        	        	    {
        	        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_prefixFormula4184);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             k = kind::EXISTS; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4196);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4202);
        	        boundVarDecl(ctx, ids, t);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	                    bvs.push_back(PARSER_STATE->mkBoundVar(*i, t));
        	                  }
        	                  ids.clear();
        	                
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1334:5: ( COMMA boundVarDecl[ids,t] )*

        	        for (;;)
        	        {
        	            int alt60=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt60=1;
        	            	}
        	                break;

        	            }

        	            switch (alt60)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1334:7: COMMA boundVarDecl[ids,t]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4217);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4219);
        	        	        boundVarDecl(ctx, ids, t);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {

        	        	                    for(std::vector<std::string>::const_iterator i = ids.begin(); i != ids.end(); ++i) {
        	        	                      bvs.push_back(PARSER_STATE->mkBoundVar(*i, t));
        	        	                    }
        	        	                    ids.clear();
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop60;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop60: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4237);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  terms.push_back( EXPR_MANAGER->mkExpr( kind::BOUND_VAR_LIST, bvs ) ); 
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4245);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1343:11: ( instantiationPatterns[ipl] )?
        	        {
        	            int alt61=2;
        	            switch ( LA(1) )
        	            {
        	                case PATTERN_TOK:
        	                	{
        	                		alt61=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt61)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1343:11: instantiationPatterns[ipl]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_instantiationPatterns_in_prefixFormula4247);
        	        	        instantiationPatterns(ctx, ipl);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4251);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  terms.push_back(f);
        	                  if(! ipl.isNull()) {
        	                    terms.push_back(ipl);
        	                  }
        	                  f = MK_EXPR(k, terms);
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1355:5: LET_TOK letDecl ( COMMA letDecl )* IN_TOK formula[f]
        	    {
        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_prefixFormula4270);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4278);
        	        letDecl(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1356:13: ( COMMA letDecl )*

        	        for (;;)
        	        {
        	            int alt62=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt62=1;
        	            	}
        	                break;

        	            }

        	            switch (alt62)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1356:15: COMMA letDecl
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_prefixFormula4282);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_letDecl_in_prefixFormula4284);
        	        	        letDecl(ctx);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleprefixFormulaEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop62;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop62: ; /* Jump out to here if this rule does not match */


        	         MATCHT(IN_TOK, &FOLLOW_IN_TOK_in_prefixFormula4293);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4295);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1360:5: LAMBDA LPAREN boundVarDeclsReturn[terms,types] RPAREN COLON formula[f]
        	    {
        	         MATCHT(LAMBDA, &FOLLOW_LAMBDA_in_prefixFormula4310);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4314);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDeclsReturn_in_prefixFormula4320);
        	        boundVarDeclsReturn(ctx, terms, types);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4327);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4329);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4331);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  Type t = EXPR_MANAGER->mkFunctionType(types, f.getType());
        	                  std::string name = "lambda";
        	                  Expr func = PARSER_STATE->mkAnonymousFunction(name, t, ExprManager::VAR_FLAG_DEFINED);
        	                  Command* cmd = new DefineFunctionCommand(name, func, terms, f);
        	                  PARSER_STATE->preemptCommand(cmd);
        	                  f = func;
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1373:5: ARRAY_TOK LPAREN boundVarDecl[ids,t] RPAREN COLON formula[f]
        	    {
        	         MATCHT(ARRAY_TOK, &FOLLOW_ARRAY_TOK_in_prefixFormula4351);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(); 
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_prefixFormula4355);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_boundVarDecl_in_prefixFormula4361);
        	        boundVarDecl(ctx, ids, t);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_prefixFormula4364);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COLON, &FOLLOW_COLON_in_prefixFormula4366);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_prefixFormula4368);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleprefixFormulaEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  UNSUPPORTED("array literals not supported yet");
        	                  f = EXPR_MANAGER->mkVar(EXPR_MANAGER->mkArrayType(t, f.getType()), ExprManager::VAR_FLAG_GLOBAL);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleprefixFormulaEx; /* Prevent compiler warnings */
    ruleprefixFormulaEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end prefixFormula */

/**
 * $ANTLR start instantiationPatterns
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1381:1: instantiationPatterns[ CVC4::Expr& expr ] : ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ ;
 */
static void
instantiationPatterns(pCvcParser ctx, CVC4::Expr& expr)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Expr f;
      std::vector<Expr> patterns;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1387:3: ( ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+ )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1387:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1387:5: ( PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON )+
            {
                int cnt65=0;

                for (;;)
                {
                    int alt65=2;
            	switch ( LA(1) )
            	{
            	case PATTERN_TOK:
            		{
            			alt65=1;
            		}
            	    break;

            	}

            	switch (alt65)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1387:7: PATTERN_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN COLON
            	        {
            	             MATCHT(PATTERN_TOK, &FOLLOW_PATTERN_TOK_in_instantiationPatterns4396);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(LPAREN, &FOLLOW_LPAREN_in_instantiationPatterns4398);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4400);
            	            formula(ctx, f);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 args.push_back( f ); 
            	            }


            	            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1387:62: ( COMMA formula[f] )*

            	            for (;;)
            	            {
            	                int alt64=2;
            	                switch ( LA(1) )
            	                {
            	                case COMMA:
            	                	{
            	                		alt64=1;
            	                	}
            	                    break;

            	                }

            	                switch (alt64)
            	                {
            	            	case 1:
            	            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1387:63: COMMA formula[f]
            	            	    {
            	            	         MATCHT(COMMA, &FOLLOW_COMMA_in_instantiationPatterns4406);
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        FOLLOWPUSH(FOLLOW_formula_in_instantiationPatterns4408);
            	            	        formula(ctx, f);

            	            	        FOLLOWPOP();
            	            	        if  (HASEXCEPTION())
            	            	        {
            	            	            goto ruleinstantiationPatternsEx;
            	            	        }
            	            	        if (HASFAILED())
            	            	        {
            	            	            return ;
            	            	        }


            	            	        if ( BACKTRACKING==0 )
            	            	        {
            	            	             args.push_back( f ); 
            	            	        }


            	            	    }
            	            	    break;

            	            	default:
            	            	    goto loop64;	/* break out of the loop */
            	            	    break;
            	                }
            	            }
            	            loop64: ; /* Jump out to here if this rule does not match */


            	             MATCHT(RPAREN, &FOLLOW_RPAREN_in_instantiationPatterns4416);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(COLON, &FOLLOW_COLON_in_instantiationPatterns4418);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruleinstantiationPatternsEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 patterns.push_back( EXPR_MANAGER->mkExpr( kind::INST_PATTERN, args ) );
            	                        args.clear();
            	                      
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt65 >= 1 )
            		{
            		    goto loop65;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruleinstantiationPatternsEx;
            	}
            	cnt65++;
                }
                loop65: ;	/* Jump to here if this rule does not match */
            }

            if ( BACKTRACKING==0 )
            {
                 if(! patterns.empty()) {
                       expr = EXPR_MANAGER->mkExpr( kind::INST_PATTERN_LIST, patterns );
                       }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleinstantiationPatternsEx; /* Prevent compiler warnings */
    ruleinstantiationPatternsEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end instantiationPatterns */

/**
 * $ANTLR start letDecl
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1400:1: letDecl : identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] ;
 */
static void
letDecl(pCvcParser ctx)
{
    /* Initialize rule variables
     */


      Expr e;
      std::string name;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1405:3: ( identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1405:5: identifier[name,CHECK_NONE,SYM_VARIABLE] EQUAL_TOK formula[e]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_letDecl4455);
            identifier(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_letDecl4458);
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_letDecl4460);
            formula(ctx, e);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleletDeclEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 Debug("parser") << Expr::setlanguage(language::output::LANG_CVC4) << e.getType() << std::endl;
                      PARSER_STATE->defineVar(name, e);
                      Debug("parser") << "LET[" << PARSER_STATE->scopeLevel() << "]: "
                                      << name << std::endl
                                      << " ==>" << " " << e << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleletDeclEx; /* Prevent compiler warnings */
    ruleletDeclEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end letDecl */

/**
 * $ANTLR start booleanBinop
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1414:1: booleanBinop[unsigned& op] : ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK );
 */
static void
booleanBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1418:3: ( IFF_TOK | IMPLIES_TOK | OR_TOK | XOR_TOK | AND_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == AND_TOK || LA(1) == IFF_TOK || LA(1) == IMPLIES_TOK || LA(1) == OR_TOK || LA(1) == XOR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebooleanBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebooleanBinopEx; /* Prevent compiler warnings */
    rulebooleanBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end booleanBinop */

/**
 * $ANTLR start comparison
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1425:1: comparison[CVC4::Expr& f] : term[f] ( comparisonBinop[op] term[f] )* ;
 */
static void
comparison(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1431:3: ( term[f] ( comparisonBinop[op] term[f] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1431:5: term[f] ( comparisonBinop[op] term[f] )*
        {
            FOLLOWPUSH(FOLLOW_term_in_comparison4529);
            term(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulecomparisonEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1432:5: ( comparisonBinop[op] term[f] )*

            for (;;)
            {
                int alt66=2;
                switch ( LA(1) )
                {
                case DISEQUAL_TOK:
                case EQUAL_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case LEQ_TOK:
                case LT_TOK:
                case MEMBER_TOK:
                	{
                		alt66=1;
                	}
                    break;

                }

                switch (alt66)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1432:7: comparisonBinop[op] term[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_comparisonBinop_in_comparison4540);
            	        comparisonBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_term_in_comparison4543);
            	        term(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulecomparisonEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop66;	/* break out of the loop */
            	    break;
                }
            }
            loop66: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonEx; /* Prevent compiler warnings */
    rulecomparisonEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparison */

/**
 * $ANTLR start comparisonBinop
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1437:1: comparisonBinop[unsigned& op] : ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK );
 */
static void
comparisonBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1441:3: ( EQUAL_TOK | DISEQUAL_TOK | GT_TOK | GEQ_TOK | LT_TOK | LEQ_TOK | MEMBER_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DISEQUAL_TOK || LA(1) == EQUAL_TOK || LA(1) == GEQ_TOK || LA(1) == GT_TOK || LA(1) == LEQ_TOK || ((LA(1) >= LT_TOK) && (LA(1) <= MEMBER_TOK)) )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulecomparisonBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulecomparisonBinopEx; /* Prevent compiler warnings */
    rulecomparisonBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end comparisonBinop */

/**
 * $ANTLR start term
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1450:1: term[CVC4::Expr& f] : storeTerm[f] ( arithmeticBinop[op] storeTerm[f] )* ;
 */
static void
term(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;
      Type t;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1457:3: ( storeTerm[f] ( arithmeticBinop[op] storeTerm[f] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1457:5: storeTerm[f] ( arithmeticBinop[op] storeTerm[f] )*
        {
            FOLLOWPUSH(FOLLOW_storeTerm_in_term4635);
            storeTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1458:5: ( arithmeticBinop[op] storeTerm[f] )*

            for (;;)
            {
                int alt67=2;
                switch ( LA(1) )
                {
                case DIV_TOK:
                case EXP_TOK:
                case INTDIV_TOK:
                case MINUS_TOK:
                case MOD_TOK:
                case PLUS_TOK:
                case STAR_TOK:
                	{
                		alt67=1;
                	}
                    break;

                }

                switch (alt67)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1458:7: arithmeticBinop[op] storeTerm[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_arithmeticBinop_in_term4646);
            	        arithmeticBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_storeTerm_in_term4649);
            	        storeTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruletermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop67;	/* break out of the loop */
            	    break;
                }
            }
            loop67: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start arithmeticBinop
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1462:1: arithmeticBinop[unsigned& op] : ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK );
 */
static void
arithmeticBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1466:3: ( PLUS_TOK | MINUS_TOK | STAR_TOK | INTDIV_TOK | MOD_TOK | DIV_TOK | EXP_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == DIV_TOK || LA(1) == EXP_TOK || LA(1) == INTDIV_TOK || ((LA(1) >= MINUS_TOK) && (LA(1) <= MOD_TOK)) || LA(1) == PLUS_TOK || LA(1) == STAR_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulearithmeticBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearithmeticBinopEx; /* Prevent compiler warnings */
    rulearithmeticBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arithmeticBinop */

/**
 * $ANTLR start storeTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1476:1: storeTerm[CVC4::Expr& f] : uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) |) ;
 */
static void
storeTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1477:3: ( uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) |) )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1477:5: uminusTerm[f] ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) |)
        {
            FOLLOWPUSH(FOLLOW_uminusTerm_in_storeTerm4732);
            uminusTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulestoreTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1478:5: ( WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) ) |)
            {
                int alt73=2;
                switch ( LA(1) )
                {
                case WITH_TOK:
                	{
                		alt73=1;
                	}
                    break;
                case EOF:
                case AND_TOK:
                case COLON:
                case COMMA:
                case DISEQUAL_TOK:
                case DIV_TOK:
                case ELSEIF_TOK:
                case ELSE_TOK:
                case ENDIF_TOK:
                case EQUAL_TOK:
                case EXP_TOK:
                case GEQ_TOK:
                case GT_TOK:
                case HASHPAREN:
                case IFF_TOK:
                case IMPLIES_TOK:
                case INTDIV_TOK:
                case INTEGER_LITERAL:
                case IN_TOK:
                case LBRACKET:
                case LEQ_TOK:
                case LT_TOK:
                case MEMBER_TOK:
                case MINUS_TOK:
                case MOD_TOK:
                case OR_TOK:
                case PLUS_TOK:
                case RBRACE:
                case RBRACKET:
                case RPAREN:
                case SEMICOLON:
                case STAR_TOK:
                case THEN_TOK:
                case XOR_TOK:
                	{
                		alt73=2;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 73;
                    EXCEPTION->state        = 0;


                    goto rulestoreTermEx;

                }

                switch (alt73)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1478:7: WITH_TOK ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	    {
            	         MATCHT(WITH_TOK, &FOLLOW_WITH_TOK_in_storeTerm4741);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulestoreTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1479:7: ( arrayStore[f] ( COMMA arrayStore[f] )* | DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* ) )
            	        {
            	            int alt72=2;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		alt72=1;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt72=2;
            	            	}
            	                break;

            	            default:
            	                if (BACKTRACKING>0)
            	                {
            	                    FAILEDFLAG = ANTLR3_TRUE;
            	                    return ;
            	                }

            	                CONSTRUCTEX();
            	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	                EXCEPTION->message      = (void *)"";
            	                EXCEPTION->decisionNum  = 72;
            	                EXCEPTION->state        = 0;


            	                goto rulestoreTermEx;

            	            }

            	            switch (alt72)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1479:9: arrayStore[f] ( COMMA arrayStore[f] )*
            	        	    {
            	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_storeTerm4751);
            	        	        arrayStore(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulestoreTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1479:23: ( COMMA arrayStore[f] )*

            	        	        for (;;)
            	        	        {
            	        	            int alt68=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case COMMA:
            	        	            	{
            	        	            		switch ( LA(2) )
            	        	            		{
            	        	            		case LBRACKET:
            	        	            			{
            	        	            				alt68=1;
            	        	            			}
            	        	            		    break;

            	        	            		}

            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt68)
            	        	            {
            	        	        	case 1:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1479:25: COMMA arrayStore[f]
            	        	        	    {
            	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_storeTerm4756);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulestoreTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_arrayStore_in_storeTerm4758);
            	        	        	        arrayStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulestoreTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop68;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop68: ; /* Jump out to here if this rule does not match */


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1480:9: DOT ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_storeTerm4772);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulestoreTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1480:13: ( tupleStore[f] ( COMMA DOT tupleStore[f] )* | recordStore[f] ( COMMA DOT recordStore[f] )* )
            	        	        {
            	        	            int alt71=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt71=1;
            	        	            	}
            	        	                break;
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt71=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 71;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulestoreTermEx;

            	        	            }

            	        	            switch (alt71)
            	        	            {
            	        	        	case 1:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1480:15: tupleStore[f] ( COMMA DOT tupleStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_storeTerm4776);
            	        	        	        tupleStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulestoreTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1480:29: ( COMMA DOT tupleStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt69=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		switch ( LA(2) )
            	        	        	            		{
            	        	        	            		case DOT:
            	        	        	            			{
            	        	        	            				alt69=1;
            	        	        	            			}
            	        	        	            		    break;

            	        	        	            		}

            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt69)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1480:31: COMMA DOT tupleStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_storeTerm4781);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto rulestoreTermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_storeTerm4783);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto rulestoreTermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_tupleStore_in_storeTerm4785);
            	        	        	        	        tupleStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto rulestoreTermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop69;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop69: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1481:15: recordStore[f] ( COMMA DOT recordStore[f] )*
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_storeTerm4805);
            	        	        	        recordStore(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulestoreTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1481:30: ( COMMA DOT recordStore[f] )*

            	        	        	        for (;;)
            	        	        	        {
            	        	        	            int alt70=2;
            	        	        	            switch ( LA(1) )
            	        	        	            {
            	        	        	            case COMMA:
            	        	        	            	{
            	        	        	            		switch ( LA(2) )
            	        	        	            		{
            	        	        	            		case DOT:
            	        	        	            			{
            	        	        	            				alt70=1;
            	        	        	            			}
            	        	        	            		    break;

            	        	        	            		}

            	        	        	            	}
            	        	        	                break;

            	        	        	            }

            	        	        	            switch (alt70)
            	        	        	            {
            	        	        	        	case 1:
            	        	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1481:32: COMMA DOT recordStore[f]
            	        	        	        	    {
            	        	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_storeTerm4810);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto rulestoreTermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	         MATCHT(DOT, &FOLLOW_DOT_in_storeTerm4812);
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto rulestoreTermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	        FOLLOWPUSH(FOLLOW_recordStore_in_storeTerm4814);
            	        	        	        	        recordStore(ctx, f);

            	        	        	        	        FOLLOWPOP();
            	        	        	        	        if  (HASEXCEPTION())
            	        	        	        	        {
            	        	        	        	            goto rulestoreTermEx;
            	        	        	        	        }
            	        	        	        	        if (HASFAILED())
            	        	        	        	        {
            	        	        	        	            return ;
            	        	        	        	        }


            	        	        	        	    }
            	        	        	        	    break;

            	        	        	        	default:
            	        	        	        	    goto loop70;	/* break out of the loop */
            	        	        	        	    break;
            	        	        	            }
            	        	        	        }
            	        	        	        loop70: ; /* Jump out to here if this rule does not match */


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	            }
            	        }

            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1483:5: 
            	    {
            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulestoreTermEx; /* Prevent compiler warnings */
    rulestoreTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end storeTerm */

/**
 * $ANTLR start arrayStore
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1490:1: arrayStore[CVC4::Expr& f] : ( LBRACKET formula[f2] RBRACKET )+ ASSIGN_TOK uminusTerm[f3] ;
 */
static void
arrayStore(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      Expr f2, f3;
      std::vector<Expr> dims;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1495:3: ( ( LBRACKET formula[f2] RBRACKET )+ ASSIGN_TOK uminusTerm[f3] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1495:5: ( LBRACKET formula[f2] RBRACKET )+ ASSIGN_TOK uminusTerm[f3]
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1495:5: ( LBRACKET formula[f2] RBRACKET )+
            {
                int cnt74=0;

                for (;;)
                {
                    int alt74=2;
            	switch ( LA(1) )
            	{
            	case LBRACKET:
            		{
            			alt74=1;
            		}
            	    break;

            	}

            	switch (alt74)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1495:7: LBRACKET formula[f2] RBRACKET
            	        {
            	             MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_arrayStore4859);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulearrayStoreEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_formula_in_arrayStore4861);
            	            formula(ctx, f2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulearrayStoreEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 dims.push_back(f2); 
            	            }


            	             MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_arrayStore4866);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulearrayStoreEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt74 >= 1 )
            		{
            		    goto loop74;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulearrayStoreEx;
            	}
            	cnt74++;
                }
                loop74: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_arrayStore4875);
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_uminusTerm_in_arrayStore4877);
            uminusTerm(ctx, f3);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulearrayStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 assert(dims.size() >= 1);
                      // these loops are a bit complicated; they're only used for the
                      // multidimensional ...WITH [a][b] :=... syntax
                      for(unsigned i = 0; i < dims.size() - 1; ++i) {
                        f = MK_EXPR(CVC4::kind::SELECT, f, dims[i]);
                      }
                      // a[i][j][k] := v  turns into
                      // store(a, i, store(a[i], j, store(a[i][j], k, v)))
                      for(unsigned i = dims.size() - 1; i > 0; --i) {
                        f3 = MK_EXPR(CVC4::kind::STORE, f, dims[i], f3);
                        // strip off one layer of the select
                        f = f[0];
                      }

                      // outermost wrapping
                      f = MK_EXPR(CVC4::kind::STORE, f, dims[0], f3);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulearrayStoreEx; /* Prevent compiler warnings */
    rulearrayStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end arrayStore */

/**
 * $ANTLR start tupleStore
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1520:1: tupleStore[CVC4::Expr& f] : k= numeral ASSIGN_TOK uminusTerm[f2] ;
 */
static void
tupleStore(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f2;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1524:3: (k= numeral ASSIGN_TOK uminusTerm[f2] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1524:5: k= numeral ASSIGN_TOK uminusTerm[f2]
        {
            FOLLOWPUSH(FOLLOW_numeral_in_tupleStore4907);
            k=numeral(ctx);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletupleStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_tupleStore4909);
            if  (HASEXCEPTION())
            {
                goto ruletupleStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_uminusTerm_in_tupleStore4911);
            uminusTerm(ctx, f2);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletupleStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {

                      Type t = f.getType();
                      if(! t.isTuple()) {
                        PARSER_STATE->parseError("tuple-update applied to non-tuple");
                      }
                      size_t length = TupleType(t).getLength();
                      if(k >= length) {
                        std::stringstream ss;
                        ss << "tuple is of length " << length << "; cannot update index " << k;
                        PARSER_STATE->parseError(ss.str());
                      }
                      f = MK_EXPR(MK_CONST(TupleUpdate(k)), f, f2);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletupleStoreEx; /* Prevent compiler warnings */
    ruletupleStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end tupleStore */

/**
 * $ANTLR start recordStore
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1544:1: recordStore[CVC4::Expr& f] : identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK uminusTerm[f2] ;
 */
static void
recordStore(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::string id;
      Expr f2;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1549:3: ( identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK uminusTerm[f2] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1549:5: identifier[id,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK uminusTerm[f2]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_recordStore4939);
            identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_recordStore4942);
            if  (HASEXCEPTION())
            {
                goto rulerecordStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_uminusTerm_in_recordStore4944);
            uminusTerm(ctx, f2);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordStoreEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {

                      Type t = f.getType();
                      if(! t.isRecord()) {
                        PARSER_STATE->parseError("record-update applied to non-record");
                      }
                      const Record& rec = RecordType(t).getRecord();
                      Record::const_iterator fld = rec.find(id);
                      if(fld == rec.end()) {
                        PARSER_STATE->parseError(std::string("no such field `") + id + "' in record");
                      }
                      f = MK_EXPR(MK_CONST(RecordUpdate(id)), f, f2);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerecordStoreEx; /* Prevent compiler warnings */
    rulerecordStoreEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end recordStore */

/**
 * $ANTLR start uminusTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1565:1: uminusTerm[CVC4::Expr& f] : ( ( MINUS_TOK )+ bvBinaryOpTerm[f] | bvBinaryOpTerm[f] );
 */
static void
uminusTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      unsigned minusCount = 0;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1570:3: ( ( MINUS_TOK )+ bvBinaryOpTerm[f] | bvBinaryOpTerm[f] )

            ANTLR3_UINT32 alt76;

            alt76=2;

            switch ( LA(1) )
            {
            case MINUS_TOK:
            	{
            		alt76=1;
            	}
                break;
            case ABS_TOK:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SCONCAT_TOK:
            case SCONTAINS_TOK:
            case SINDEXOF_TOK:
            case SPREFIXOF_TOK:
            case SREPLACE_TOK:
            case SSUBSTR_TOK:
            case SSUFFIXOF_TOK:
            case STOINTEGER_TOK:
            case STORE_TOK:
            case STOSTRING_TOK:
            case STRING_LITERAL:
            case SX_TOK:
            case TRUE_TOK:
            	{
            		alt76=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 76;
                EXCEPTION->state        = 0;


                goto ruleuminusTermEx;

            }

            switch (alt76)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1570:5: ( MINUS_TOK )+ bvBinaryOpTerm[f]
        	    {
        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1570:5: ( MINUS_TOK )+
        	        {
        	            int cnt75=0;

        	            for (;;)
        	            {
        	                int alt75=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case MINUS_TOK:
        	        		{
        	        			alt75=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt75)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1570:6: MINUS_TOK
        	        	        {
        	        	             MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_uminusTerm4979);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleuminusTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 ++minusCount; 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt75 >= 1 )
        	        		{
        	        		    goto loop75;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleuminusTermEx;
        	        	}
        	        	cnt75++;
        	            }
        	            loop75: ;	/* Jump to here if this rule does not match */
        	        }

        	        FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm4985);
        	        bvBinaryOpTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleuminusTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             while(minusCount > 0) { --minusCount; f = MK_EXPR(CVC4::kind::UMINUS, f); } 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1572:5: bvBinaryOpTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_bvBinaryOpTerm_in_uminusTerm4998);
        	        bvBinaryOpTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleuminusTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleuminusTermEx; /* Prevent compiler warnings */
    ruleuminusTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end uminusTerm */

/**
 * $ANTLR start bvBinaryOpTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1576:1: bvBinaryOpTerm[CVC4::Expr& f] : bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* ;
 */
static void
bvBinaryOpTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<CVC4::Expr> expressions;
      std::vector<unsigned> operators;
      unsigned op;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1582:3: ( bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1582:5: bvNegTerm[f] ( bvBinop[op] bvNegTerm[f] )*
        {
            FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5020);
            bvNegTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulebvBinaryOpTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 expressions.push_back(f); 
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1583:5: ( bvBinop[op] bvNegTerm[f] )*

            for (;;)
            {
                int alt77=2;
                switch ( LA(1) )
                {
                case BAR:
                case BVAND_TOK:
                case CONCAT_TOK:
                	{
                		alt77=1;
                	}
                    break;

                }

                switch (alt77)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1583:7: bvBinop[op] bvNegTerm[f]
            	    {
            	        FOLLOWPUSH(FOLLOW_bvBinop_in_bvBinaryOpTerm5031);
            	        bvBinop(ctx, op);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvBinaryOpTerm5034);
            	        bvNegTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulebvBinaryOpTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             operators.push_back(op); expressions.push_back(f); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop77;	/* break out of the loop */
            	    break;
                }
            }
            loop77: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 f = createPrecedenceTree(PARSER_STATE, EXPR_MANAGER, expressions, operators); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinaryOpTermEx; /* Prevent compiler warnings */
    rulebvBinaryOpTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinaryOpTerm */

/**
 * $ANTLR start bvBinop
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1586:1: bvBinop[unsigned& op] : ( CONCAT_TOK | BAR | BVAND_TOK );
 */
static void
bvBinop(pCvcParser ctx, unsigned& op)
{
    /* Initialize rule variables
     */


      op = LT(1)->getType(LT(1));

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1590:3: ( CONCAT_TOK | BAR | BVAND_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:
        {
            if ( LA(1) == BAR || LA(1) == BVAND_TOK || LA(1) == CONCAT_TOK )
            {
                CONSUME();
                PERRORRECOVERY=ANTLR3_FALSE;
                FAILEDFLAG=ANTLR3_FALSE;

            }
            else
            {
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
                EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
                EXCEPTION->expectingSet = NULL;

                goto rulebvBinopEx;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebvBinopEx; /* Prevent compiler warnings */
    rulebvBinopEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvBinop */

/**
 * $ANTLR start bvNegTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1595:1: bvNegTerm[CVC4::Expr& f] : ( BVNEG_TOK bvNegTerm[f] | postfixTerm[f] );
 */
static void
bvNegTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1597:3: ( BVNEG_TOK bvNegTerm[f] | postfixTerm[f] )

            ANTLR3_UINT32 alt78;

            alt78=2;

            switch ( LA(1) )
            {
            case BVNEG_TOK:
            	{
            		alt78=1;
            	}
                break;
            case ABS_TOK:
            case BINARY_LITERAL:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVGE_TOK:
            case BVGT_TOK:
            case BVLE_TOK:
            case BVLSHR_TOK:
            case BVLT_TOK:
            case BVMULT_TOK:
            case BVNAND_TOK:
            case BVNOR_TOK:
            case BVPLUS_TOK:
            case BVREPEAT_TOK:
            case BVROTL_TOK:
            case BVROTR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUMINUS_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case BVZEROEXTEND_TOK:
            case DECIMAL_LITERAL:
            case DISTINCT_TOK:
            case DIVISIBLE_TOK:
            case FALSE_TOK:
            case FLOOR_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case IS_INTEGER_TOK:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SCONCAT_TOK:
            case SCONTAINS_TOK:
            case SINDEXOF_TOK:
            case SPREFIXOF_TOK:
            case SREPLACE_TOK:
            case SSUBSTR_TOK:
            case SSUFFIXOF_TOK:
            case STOINTEGER_TOK:
            case STORE_TOK:
            case STOSTRING_TOK:
            case STRING_LITERAL:
            case SX_TOK:
            case TRUE_TOK:
            	{
            		alt78=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 78;
                EXCEPTION->state        = 0;


                goto rulebvNegTermEx;

            }

            switch (alt78)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1597:5: BVNEG_TOK bvNegTerm[f]
        	    {
        	         MATCHT(BVNEG_TOK, &FOLLOW_BVNEG_TOK_in_bvNegTerm5097);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_bvNegTerm_in_bvNegTerm5099);
        	        bvNegTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NOT, f); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1599:5: postfixTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_postfixTerm_in_bvNegTerm5112);
        	        postfixTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvNegTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebvNegTermEx; /* Prevent compiler warnings */
    rulebvNegTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvNegTerm */

/**
 * $ANTLR start postfixTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1611:1: postfixTerm[CVC4::Expr& f] : ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? ;
 */
static void
postfixTerm(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k1;
    #undef	RETURN_TYPE_k1
    #define	RETURN_TYPE_k1 unsigned

    unsigned k2;
    #undef	RETURN_TYPE_k2
    #define	RETURN_TYPE_k2 unsigned

    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    unsigned n;
    #undef	RETURN_TYPE_n
    #define	RETURN_TYPE_n unsigned

    /* Initialize rule variables
     */


      Expr f2;
      bool extract = false, left = false;
      std::vector<Expr> args;
      std::string id;
      Type t;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1619:3: ( ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )? )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1619:5: ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN ) ( typeAscription[f, t] )?
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1619:5: ( bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )* | FLOOR_TOK LPAREN formula[f] RPAREN | IS_INTEGER_TOK LPAREN formula[f] RPAREN | ABS_TOK LPAREN formula[f] RPAREN | DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN | DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN )
            {
                int alt85=6;
                switch ( LA(1) )
                {
                case BINARY_LITERAL:
                case BVASHR_TOK:
                case BVCOMP_TOK:
                case BVGE_TOK:
                case BVGT_TOK:
                case BVLE_TOK:
                case BVLSHR_TOK:
                case BVLT_TOK:
                case BVMULT_TOK:
                case BVNAND_TOK:
                case BVNOR_TOK:
                case BVPLUS_TOK:
                case BVREPEAT_TOK:
                case BVROTL_TOK:
                case BVROTR_TOK:
                case BVSDIV_TOK:
                case BVSGE_TOK:
                case BVSGT_TOK:
                case BVSHL_TOK:
                case BVSLE_TOK:
                case BVSLT_TOK:
                case BVSMOD_TOK:
                case BVSREM_TOK:
                case BVSUB_TOK:
                case BVUDIV_TOK:
                case BVUMINUS_TOK:
                case BVUREM_TOK:
                case BVXNOR_TOK:
                case BVXOR_TOK:
                case BVZEROEXTEND_TOK:
                case DECIMAL_LITERAL:
                case FALSE_TOK:
                case HEX_LITERAL:
                case IDENTIFIER:
                case IF_TOK:
                case INTEGER_LITERAL:
                case LBRACE:
                case LPAREN:
                case PARENHASH:
                case SCONCAT_TOK:
                case SCONTAINS_TOK:
                case SINDEXOF_TOK:
                case SPREFIXOF_TOK:
                case SREPLACE_TOK:
                case SSUBSTR_TOK:
                case SSUFFIXOF_TOK:
                case STOINTEGER_TOK:
                case STORE_TOK:
                case STOSTRING_TOK:
                case STRING_LITERAL:
                case SX_TOK:
                case TRUE_TOK:
                	{
                		alt85=1;
                	}
                    break;
                case FLOOR_TOK:
                	{
                		alt85=2;
                	}
                    break;
                case IS_INTEGER_TOK:
                	{
                		alt85=3;
                	}
                    break;
                case ABS_TOK:
                	{
                		alt85=4;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt85=5;
                	}
                    break;
                case DISTINCT_TOK:
                	{
                		alt85=6;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 85;
                    EXCEPTION->state        = 0;


                    goto rulepostfixTermEx;

                }

                switch (alt85)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1619:7: bvTerm[f] ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*
            	    {
            	        FOLLOWPUSH(FOLLOW_bvTerm_in_postfixTerm5136);
            	        bvTerm(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1620:5: ( LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET | ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral ) )*

            	        for (;;)
            	        {
            	            int alt83=5;
            	            switch ( LA(1) )
            	            {
            	            case LBRACKET:
            	            	{
            	            		switch ( LA(2) )
            	            		{
            	            		case IDENTIFIER:
            	            			{
            	            				switch ( LA(3) )
            	            				{
            	            				case AND_TOK:
            	            				case BAR:
            	            				case BVAND_TOK:
            	            				case COLON:
            	            				case CONCAT_TOK:
            	            				case DISEQUAL_TOK:
            	            				case DIV_TOK:
            	            				case DOT:
            	            				case EQUAL_TOK:
            	            				case EXP_TOK:
            	            				case GEQ_TOK:
            	            				case GT_TOK:
            	            				case IFF_TOK:
            	            				case IMPLIES_TOK:
            	            				case INTDIV_TOK:
            	            				case LBRACKET:
            	            				case LEFTSHIFT_TOK:
            	            				case LEQ_TOK:
            	            				case LPAREN:
            	            				case LT_TOK:
            	            				case MEMBER_TOK:
            	            				case MINUS_TOK:
            	            				case MOD_TOK:
            	            				case OR_TOK:
            	            				case PLUS_TOK:
            	            				case RBRACKET:
            	            				case RIGHTSHIFT_TOK:
            	            				case STAR_TOK:
            	            				case WITH_TOK:
            	            				case XOR_TOK:
            	            					{
            	            						alt83=1;
            	            					}
            	            				    break;

            	            				}

            	            			}
            	            		    break;
            	            		case ABS_TOK:
            	            		case ARRAY_TOK:
            	            		case BINARY_LITERAL:
            	            		case BVASHR_TOK:
            	            		case BVCOMP_TOK:
            	            		case BVGE_TOK:
            	            		case BVGT_TOK:
            	            		case BVLE_TOK:
            	            		case BVLSHR_TOK:
            	            		case BVLT_TOK:
            	            		case BVMULT_TOK:
            	            		case BVNAND_TOK:
            	            		case BVNEG_TOK:
            	            		case BVNOR_TOK:
            	            		case BVPLUS_TOK:
            	            		case BVREPEAT_TOK:
            	            		case BVROTL_TOK:
            	            		case BVROTR_TOK:
            	            		case BVSDIV_TOK:
            	            		case BVSGE_TOK:
            	            		case BVSGT_TOK:
            	            		case BVSHL_TOK:
            	            		case BVSLE_TOK:
            	            		case BVSLT_TOK:
            	            		case BVSMOD_TOK:
            	            		case BVSREM_TOK:
            	            		case BVSUB_TOK:
            	            		case BVUDIV_TOK:
            	            		case BVUMINUS_TOK:
            	            		case BVUREM_TOK:
            	            		case BVXNOR_TOK:
            	            		case BVXOR_TOK:
            	            		case BVZEROEXTEND_TOK:
            	            		case DECIMAL_LITERAL:
            	            		case DISTINCT_TOK:
            	            		case DIVISIBLE_TOK:
            	            		case EXISTS_TOK:
            	            		case FALSE_TOK:
            	            		case FLOOR_TOK:
            	            		case FORALL_TOK:
            	            		case HEX_LITERAL:
            	            		case IF_TOK:
            	            		case INTEGER_LITERAL:
            	            		case IS_INTEGER_TOK:
            	            		case LAMBDA:
            	            		case LBRACE:
            	            		case LET_TOK:
            	            		case LPAREN:
            	            		case MINUS_TOK:
            	            		case NOT_TOK:
            	            		case PARENHASH:
            	            		case SCONCAT_TOK:
            	            		case SCONTAINS_TOK:
            	            		case SINDEXOF_TOK:
            	            		case SPREFIXOF_TOK:
            	            		case SREPLACE_TOK:
            	            		case SSUBSTR_TOK:
            	            		case SSUFFIXOF_TOK:
            	            		case STOINTEGER_TOK:
            	            		case STORE_TOK:
            	            		case STOSTRING_TOK:
            	            		case STRING_LITERAL:
            	            		case SX_TOK:
            	            		case TRUE_TOK:
            	            			{
            	            				alt83=1;
            	            			}
            	            		    break;

            	            		}

            	            	}
            	                break;
            	            case LEFTSHIFT_TOK:
            	            case RIGHTSHIFT_TOK:
            	            	{
            	            		alt83=2;
            	            	}
            	                break;
            	            case LPAREN:
            	            	{
            	            		alt83=3;
            	            	}
            	                break;
            	            case DOT:
            	            	{
            	            		alt83=4;
            	            	}
            	                break;

            	            }

            	            switch (alt83)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1621:7: LBRACKET ( formula[f2] |k1= numeral COLON k2= numeral ) RBRACKET
            	        	    {
            	        	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_postfixTerm5153);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1622:9: ( formula[f2] |k1= numeral COLON k2= numeral )
            	        	        {
            	        	            int alt79=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case ABS_TOK:
            	        	            case ARRAY_TOK:
            	        	            case BINARY_LITERAL:
            	        	            case BVASHR_TOK:
            	        	            case BVCOMP_TOK:
            	        	            case BVGE_TOK:
            	        	            case BVGT_TOK:
            	        	            case BVLE_TOK:
            	        	            case BVLSHR_TOK:
            	        	            case BVLT_TOK:
            	        	            case BVMULT_TOK:
            	        	            case BVNAND_TOK:
            	        	            case BVNEG_TOK:
            	        	            case BVNOR_TOK:
            	        	            case BVPLUS_TOK:
            	        	            case BVREPEAT_TOK:
            	        	            case BVROTL_TOK:
            	        	            case BVROTR_TOK:
            	        	            case BVSDIV_TOK:
            	        	            case BVSGE_TOK:
            	        	            case BVSGT_TOK:
            	        	            case BVSHL_TOK:
            	        	            case BVSLE_TOK:
            	        	            case BVSLT_TOK:
            	        	            case BVSMOD_TOK:
            	        	            case BVSREM_TOK:
            	        	            case BVSUB_TOK:
            	        	            case BVUDIV_TOK:
            	        	            case BVUMINUS_TOK:
            	        	            case BVUREM_TOK:
            	        	            case BVXNOR_TOK:
            	        	            case BVXOR_TOK:
            	        	            case BVZEROEXTEND_TOK:
            	        	            case DECIMAL_LITERAL:
            	        	            case DISTINCT_TOK:
            	        	            case DIVISIBLE_TOK:
            	        	            case EXISTS_TOK:
            	        	            case FALSE_TOK:
            	        	            case FLOOR_TOK:
            	        	            case FORALL_TOK:
            	        	            case HEX_LITERAL:
            	        	            case IDENTIFIER:
            	        	            case IF_TOK:
            	        	            case IS_INTEGER_TOK:
            	        	            case LAMBDA:
            	        	            case LBRACE:
            	        	            case LET_TOK:
            	        	            case LPAREN:
            	        	            case MINUS_TOK:
            	        	            case NOT_TOK:
            	        	            case PARENHASH:
            	        	            case SCONCAT_TOK:
            	        	            case SCONTAINS_TOK:
            	        	            case SINDEXOF_TOK:
            	        	            case SPREFIXOF_TOK:
            	        	            case SREPLACE_TOK:
            	        	            case SSUBSTR_TOK:
            	        	            case SSUFFIXOF_TOK:
            	        	            case STOINTEGER_TOK:
            	        	            case STORE_TOK:
            	        	            case STOSTRING_TOK:
            	        	            case STRING_LITERAL:
            	        	            case SX_TOK:
            	        	            case TRUE_TOK:
            	        	            	{
            	        	            		alt79=1;
            	        	            	}
            	        	                break;
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		switch ( LA(2) )
            	        	            		{
            	        	            		case AND_TOK:
            	        	            		case BAR:
            	        	            		case BVAND_TOK:
            	        	            		case CONCAT_TOK:
            	        	            		case DISEQUAL_TOK:
            	        	            		case DIV_TOK:
            	        	            		case DOT:
            	        	            		case EQUAL_TOK:
            	        	            		case EXP_TOK:
            	        	            		case GEQ_TOK:
            	        	            		case GT_TOK:
            	        	            		case IFF_TOK:
            	        	            		case IMPLIES_TOK:
            	        	            		case INTDIV_TOK:
            	        	            		case LBRACKET:
            	        	            		case LEFTSHIFT_TOK:
            	        	            		case LEQ_TOK:
            	        	            		case LPAREN:
            	        	            		case LT_TOK:
            	        	            		case MEMBER_TOK:
            	        	            		case MINUS_TOK:
            	        	            		case MOD_TOK:
            	        	            		case OR_TOK:
            	        	            		case PLUS_TOK:
            	        	            		case RBRACKET:
            	        	            		case RIGHTSHIFT_TOK:
            	        	            		case STAR_TOK:
            	        	            		case WITH_TOK:
            	        	            		case XOR_TOK:
            	        	            			{
            	        	            				alt79=1;
            	        	            			}
            	        	            		    break;
            	        	            		case COLON:
            	        	            			{
            	        	            				switch ( LA(3) )
            	        	            				{
            	        	            				case COLON:
            	        	            					{
            	        	            						alt79=1;
            	        	            					}
            	        	            				    break;
            	        	            				case INTEGER_LITERAL:
            	        	            					{
            	        	            						alt79=2;
            	        	            					}
            	        	            				    break;

            	        	            				default:
            	        	            				    if (BACKTRACKING>0)
            	        	            				    {
            	        	            				        FAILEDFLAG = ANTLR3_TRUE;
            	        	            				        return ;
            	        	            				    }

            	        	            				    CONSTRUCTEX();
            	        	            				    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	            				    EXCEPTION->message      = (void *)"";
            	        	            				    EXCEPTION->decisionNum  = 79;
            	        	            				    EXCEPTION->state        = 71;


            	        	            				    goto rulepostfixTermEx;

            	        	            				}

            	        	            			}
            	        	            		    break;

            	        	            		default:
            	        	            		    if (BACKTRACKING>0)
            	        	            		    {
            	        	            		        FAILEDFLAG = ANTLR3_TRUE;
            	        	            		        return ;
            	        	            		    }

            	        	            		    CONSTRUCTEX();
            	        	            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	            		    EXCEPTION->message      = (void *)"";
            	        	            		    EXCEPTION->decisionNum  = 79;
            	        	            		    EXCEPTION->state        = 57;


            	        	            		    goto rulepostfixTermEx;

            	        	            		}

            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 79;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulepostfixTermEx;

            	        	            }

            	        	            switch (alt79)
            	        	            {
            	        	        	case 1:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1622:11: formula[f2]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5165);
            	        	        	        formula(ctx, f2);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             extract = false; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1623:11: k1= numeral COLON k2= numeral
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5182);
            	        	        	        k1=numeral(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	         MATCHT(COLON, &FOLLOW_COLON_in_postfixTerm5184);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5188);
            	        	        	        k2=numeral(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             extract = true; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_postfixTerm5200);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             if(extract) {
            	        	                      /* bitvector extract */
            	        	                      f = MK_EXPR(MK_CONST(BitVectorExtract(k1, k2)), f);
            	        	                    } else {
            	        	                      /* array select */
            	        	                      f = MK_EXPR(CVC4::kind::SELECT, f, f2);
            	        	                    }
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 2:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1635:7: ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK ) k= numeral
            	        	    {
            	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1635:7: ( LEFTSHIFT_TOK | RIGHTSHIFT_TOK )
            	        	        {
            	        	            int alt80=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case LEFTSHIFT_TOK:
            	        	            	{
            	        	            		alt80=1;
            	        	            	}
            	        	                break;
            	        	            case RIGHTSHIFT_TOK:
            	        	            	{
            	        	            		alt80=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 80;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulepostfixTermEx;

            	        	            }

            	        	            switch (alt80)
            	        	            {
            	        	        	case 1:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1635:9: LEFTSHIFT_TOK
            	        	        	    {
            	        	        	         MATCHT(LEFTSHIFT_TOK, &FOLLOW_LEFTSHIFT_TOK_in_postfixTerm5227);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             left = true; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1636:9: RIGHTSHIFT_TOK
            	        	        	    {
            	        	        	         MATCHT(RIGHTSHIFT_TOK, &FOLLOW_RIGHTSHIFT_TOK_in_postfixTerm5239);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             left = false; 
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5247);
            	        	        k=numeral(ctx);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             // Defined in:
            	        	                    // http://www.cs.nyu.edu/acsys/cvc3/doc/user_doc.html#user_doc_pres_lang_expr_bit
            	        	                    if(left) {
            	        	                      f = MK_EXPR(kind::BITVECTOR_CONCAT, f, MK_CONST(BitVector(k)));
            	        	                    } else {
            	        	                      unsigned n = BitVectorType(f.getType()).getSize();
            	        	                      f = MK_EXPR(kind::BITVECTOR_CONCAT, MK_CONST(BitVector(k)),
            	        	                                  MK_EXPR(MK_CONST(BitVectorExtract(n - 1, k)), f));
            	        	                    }
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 3:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1649:7: LPAREN formula[f] ( COMMA formula[f] )* RPAREN
            	        	    {
            	        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5272);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             args.push_back(f); 
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5282);
            	        	        formula(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             args.push_back(f); 
            	        	        }


            	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1651:7: ( COMMA formula[f] )*

            	        	        for (;;)
            	        	        {
            	        	            int alt81=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case COMMA:
            	        	            	{
            	        	            		alt81=1;
            	        	            	}
            	        	                break;

            	        	            }

            	        	            switch (alt81)
            	        	            {
            	        	        	case 1:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1651:9: COMMA formula[f]
            	        	        	    {
            	        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_postfixTerm5295);
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5297);
            	        	        	        formula(ctx, f);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             args.push_back(f); 
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	        	default:
            	        	        	    goto loop81;	/* break out of the loop */
            	        	        	    break;
            	        	            }
            	        	        }
            	        	        loop81: ; /* Jump out to here if this rule does not match */


            	        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5305);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             Type t = args.front().getType();
            	        	                    Debug("parser") << "type is " << t << std::endl;
            	        	                    Debug("parser") << "expr is " << args.front() << std::endl;
            	        	                    if(PARSER_STATE->isDefinedFunction(args.front())) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY, args);
            	        	                    } else if(t.isFunction()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_UF, args);
            	        	                    } else if(t.isConstructor()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, args);
            	        	                    } else if(t.isSelector()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_SELECTOR, args);
            	        	                    } else if(t.isTester()) {
            	        	                      f = MK_EXPR(CVC4::kind::APPLY_TESTER, args);
            	        	                    } else {
            	        	                      PARSER_STATE->parseError("internal error: unhandled function application kind");
            	        	                    }
            	        	                  
            	        	        }


            	        	    }
            	        	    break;
            	        	case 4:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1672:7: DOT ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral )
            	        	    {
            	        	         MATCHT(DOT, &FOLLOW_DOT_in_postfixTerm5337);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1673:7: ( identifier[id,CHECK_NONE,SYM_VARIABLE] |k= numeral )
            	        	        {
            	        	            int alt82=2;
            	        	            switch ( LA(1) )
            	        	            {
            	        	            case IDENTIFIER:
            	        	            	{
            	        	            		alt82=1;
            	        	            	}
            	        	                break;
            	        	            case INTEGER_LITERAL:
            	        	            	{
            	        	            		alt82=2;
            	        	            	}
            	        	                break;

            	        	            default:
            	        	                if (BACKTRACKING>0)
            	        	                {
            	        	                    FAILEDFLAG = ANTLR3_TRUE;
            	        	                    return ;
            	        	                }

            	        	                CONSTRUCTEX();
            	        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            	        	                EXCEPTION->message      = (void *)"";
            	        	                EXCEPTION->decisionNum  = 82;
            	        	                EXCEPTION->state        = 0;


            	        	                goto rulepostfixTermEx;

            	        	            }

            	        	            switch (alt82)
            	        	            {
            	        	        	case 1:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1673:9: identifier[id,CHECK_NONE,SYM_VARIABLE]
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_identifier_in_postfixTerm5347);
            	        	        	        identifier(ctx, id, CHECK_NONE, SYM_VARIABLE);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             Type t = f.getType();
            	        	        	                      if(! t.isRecord()) {
            	        	        	                        PARSER_STATE->parseError("record-select applied to non-record");
            	        	        	                      }
            	        	        	                      const Record& rec = RecordType(t).getRecord();
            	        	        	                      Record::const_iterator fld = rec.find(id);
            	        	        	                      if(fld == rec.end()) {
            	        	        	                        PARSER_STATE->parseError(std::string("no such field `") + id + "' in record");
            	        	        	                      }
            	        	        	                      f = MK_EXPR(MK_CONST(RecordSelect(id)), f);
            	        	        	                    
            	        	        	        }


            	        	        	    }
            	        	        	    break;
            	        	        	case 2:
            	        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1685:9: k= numeral
            	        	        	    {
            	        	        	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5370);
            	        	        	        k=numeral(ctx);

            	        	        	        FOLLOWPOP();
            	        	        	        if  (HASEXCEPTION())
            	        	        	        {
            	        	        	            goto rulepostfixTermEx;
            	        	        	        }
            	        	        	        if (HASFAILED())
            	        	        	        {
            	        	        	            return ;
            	        	        	        }


            	        	        	        if ( BACKTRACKING==0 )
            	        	        	        {
            	        	        	             Type t = f.getType();
            	        	        	                      if(! t.isTuple()) {
            	        	        	                        PARSER_STATE->parseError("tuple-select applied to non-tuple");
            	        	        	                      }
            	        	        	                      size_t length = TupleType(t).getLength();
            	        	        	                      if(k >= length) {
            	        	        	                        std::stringstream ss;
            	        	        	                        ss << "tuple is of length " << length << "; cannot access index " << k;
            	        	        	                        PARSER_STATE->parseError(ss.str());
            	        	        	                      }
            	        	        	                      f = MK_EXPR(MK_CONST(TupleSelect(k)), f);
            	        	        	                    
            	        	        	        }


            	        	        	    }
            	        	        	    break;

            	        	            }
            	        	        }

            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop83;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop83: ; /* Jump out to here if this rule does not match */


            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1700:7: FLOOR_TOK LPAREN formula[f] RPAREN
            	    {
            	         MATCHT(FLOOR_TOK, &FOLLOW_FLOOR_TOK_in_postfixTerm5403);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5405);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5407);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5410);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::TO_INTEGER, f); 
            	        }


            	    }
            	    break;
            	case 3:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1702:7: IS_INTEGER_TOK LPAREN formula[f] RPAREN
            	    {
            	         MATCHT(IS_INTEGER_TOK, &FOLLOW_IS_INTEGER_TOK_in_postfixTerm5426);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5428);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5430);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5433);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::IS_INTEGER, f); 
            	        }


            	    }
            	    break;
            	case 4:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1704:7: ABS_TOK LPAREN formula[f] RPAREN
            	    {
            	         MATCHT(ABS_TOK, &FOLLOW_ABS_TOK_in_postfixTerm5449);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5451);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5453);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5456);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::ABS, f); 
            	        }


            	    }
            	    break;
            	case 5:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1706:7: DIVISIBLE_TOK LPAREN formula[f] COMMA n= numeral RPAREN
            	    {
            	         MATCHT(DIVISIBLE_TOK, &FOLLOW_DIVISIBLE_TOK_in_postfixTerm5472);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5474);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5476);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(COMMA, &FOLLOW_COMMA_in_postfixTerm5479);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_numeral_in_postfixTerm5483);
            	        n=numeral(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5485);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = MK_EXPR(CVC4::kind::DIVISIBLE, MK_CONST(CVC4::Divisible(n)), f); 
            	        }


            	    }
            	    break;
            	case 6:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1708:7: DISTINCT_TOK LPAREN formula[f] ( COMMA formula[f] )* RPAREN
            	    {
            	         MATCHT(DISTINCT_TOK, &FOLLOW_DISTINCT_TOK_in_postfixTerm5501);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_postfixTerm5503);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5511);
            	        formula(ctx, f);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             args.push_back(f); 
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1710:7: ( COMMA formula[f] )*

            	        for (;;)
            	        {
            	            int alt84=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt84=1;
            	            	}
            	                break;

            	            }

            	            switch (alt84)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1710:9: COMMA formula[f]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_postfixTerm5524);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_formula_in_postfixTerm5526);
            	        	        formula(ctx, f);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto rulepostfixTermEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {
            	        	             args.push_back(f); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop84;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop84: ; /* Jump out to here if this rule does not match */


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_postfixTerm5534);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             f = (args.size() == 1) ? MK_CONST(bool(true)) : MK_EXPR(CVC4::kind::DISTINCT, args); 
            	        }


            	    }
            	    break;

                }
            }

            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1713:5: ( typeAscription[f, t] )?
            {
                int alt86=2;
                switch ( LA(1) )
                {
                    case COLON:
                    	{
                    		switch ( LA(2) )
                    		{
                    		    case COLON:
                    		    	{
                    		    		alt86=1;
                    		    	}
                    		        break;
                    		}

                    	}
                        break;
                }

                switch (alt86)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1713:7: typeAscription[f, t]
            	    {
            	        FOLLOWPUSH(FOLLOW_typeAscription_in_postfixTerm5556);
            	        typeAscription(ctx, f, t);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulepostfixTermEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             if(f.getKind() == CVC4::kind::APPLY_CONSTRUCTOR && t.isDatatype()) {
            	                      std::vector<CVC4::Expr> v;
            	                      Expr e = f.getOperator();
            	                      const DatatypeConstructor& dtc = Datatype::datatypeOf(e)[Datatype::indexOf(e)];
            	                      v.push_back(MK_EXPR( CVC4::kind::APPLY_TYPE_ASCRIPTION,
            	                                           MK_CONST(AscriptionType(dtc.getSpecializedConstructorType(t))), f.getOperator() ));
            	                      v.insert(v.end(), f.begin(), f.end());
            	                      f = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, v);
            	                    } else if(f.getKind() == CVC4::kind::EMPTYSET && t.isSet()) {
            	                      f = MK_CONST(CVC4::EmptySet(t));
            	                    } else {
            	                      if(f.getType() != t) {
            	                        PARSER_STATE->parseError("Type ascription not satisfied.");
            	                      }
            	                    }
            	                  
            	        }


            	    }
            	    break;

                }
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulepostfixTermEx; /* Prevent compiler warnings */
    rulepostfixTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end postfixTerm */

/**
 * $ANTLR start bvTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1733:1: bvTerm[CVC4::Expr& f] : ( BVXOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNAND_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVCOMP_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVXNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUMINUS_TOK LPAREN formula[f] RPAREN | BVPLUS_TOK LPAREN k= numeral COMMA formula[f] ( COMMA formula[f2] )+ RPAREN | BVSUB_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVMULT_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVUDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSMOD_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSHL_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVASHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLSHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SX_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVZEROEXTEND_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVREPEAT_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTR_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTL_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | stringTerm[f] );
 */
static void
bvTerm(pCvcParser ctx, CVC4::Expr& f)
{
    unsigned k;
    #undef	RETURN_TYPE_k
    #define	RETURN_TYPE_k unsigned

    /* Initialize rule variables
     */


      Expr f2;
      std::vector<Expr> args;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1739:3: ( BVXOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNAND_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVCOMP_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVXNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUMINUS_TOK LPAREN formula[f] RPAREN | BVPLUS_TOK LPAREN k= numeral COMMA formula[f] ( COMMA formula[f2] )+ RPAREN | BVSUB_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVMULT_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN | BVUDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVUREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSMOD_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSHL_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVASHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLSHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SX_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVZEROEXTEND_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVREPEAT_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTR_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVROTL_TOK LPAREN formula[f] COMMA k= numeral RPAREN | BVLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | BVSGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | stringTerm[f] )

            ANTLR3_UINT32 alt88;

            alt88=31;

            switch ( LA(1) )
            {
            case BVXOR_TOK:
            	{
            		alt88=1;
            	}
                break;
            case BVNAND_TOK:
            	{
            		alt88=2;
            	}
                break;
            case BVNOR_TOK:
            	{
            		alt88=3;
            	}
                break;
            case BVCOMP_TOK:
            	{
            		alt88=4;
            	}
                break;
            case BVXNOR_TOK:
            	{
            		alt88=5;
            	}
                break;
            case BVUMINUS_TOK:
            	{
            		alt88=6;
            	}
                break;
            case BVPLUS_TOK:
            	{
            		alt88=7;
            	}
                break;
            case BVSUB_TOK:
            	{
            		alt88=8;
            	}
                break;
            case BVMULT_TOK:
            	{
            		alt88=9;
            	}
                break;
            case BVUDIV_TOK:
            	{
            		alt88=10;
            	}
                break;
            case BVSDIV_TOK:
            	{
            		alt88=11;
            	}
                break;
            case BVUREM_TOK:
            	{
            		alt88=12;
            	}
                break;
            case BVSREM_TOK:
            	{
            		alt88=13;
            	}
                break;
            case BVSMOD_TOK:
            	{
            		alt88=14;
            	}
                break;
            case BVSHL_TOK:
            	{
            		alt88=15;
            	}
                break;
            case BVASHR_TOK:
            	{
            		alt88=16;
            	}
                break;
            case BVLSHR_TOK:
            	{
            		alt88=17;
            	}
                break;
            case SX_TOK:
            	{
            		alt88=18;
            	}
                break;
            case BVZEROEXTEND_TOK:
            	{
            		alt88=19;
            	}
                break;
            case BVREPEAT_TOK:
            	{
            		alt88=20;
            	}
                break;
            case BVROTR_TOK:
            	{
            		alt88=21;
            	}
                break;
            case BVROTL_TOK:
            	{
            		alt88=22;
            	}
                break;
            case BVLT_TOK:
            	{
            		alt88=23;
            	}
                break;
            case BVLE_TOK:
            	{
            		alt88=24;
            	}
                break;
            case BVGT_TOK:
            	{
            		alt88=25;
            	}
                break;
            case BVGE_TOK:
            	{
            		alt88=26;
            	}
                break;
            case BVSLT_TOK:
            	{
            		alt88=27;
            	}
                break;
            case BVSLE_TOK:
            	{
            		alt88=28;
            	}
                break;
            case BVSGT_TOK:
            	{
            		alt88=29;
            	}
                break;
            case BVSGE_TOK:
            	{
            		alt88=30;
            	}
                break;
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case FALSE_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case SCONCAT_TOK:
            case SCONTAINS_TOK:
            case SINDEXOF_TOK:
            case SPREFIXOF_TOK:
            case SREPLACE_TOK:
            case SSUBSTR_TOK:
            case SSUFFIXOF_TOK:
            case STOINTEGER_TOK:
            case STORE_TOK:
            case STOSTRING_TOK:
            case STRING_LITERAL:
            case TRUE_TOK:
            	{
            		alt88=31;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 88;
                EXCEPTION->state        = 0;


                goto rulebvTermEx;

            }

            switch (alt88)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1739:5: BVXOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVXOR_TOK, &FOLLOW_BVXOR_TOK_in_bvTerm5597);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5599);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5601);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5604);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5606);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5609);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_XOR, f, f2); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1741:5: BVNAND_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVNAND_TOK, &FOLLOW_BVNAND_TOK_in_bvTerm5621);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5623);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5625);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5628);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5630);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5633);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NAND, f, f2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1743:5: BVNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVNOR_TOK, &FOLLOW_BVNOR_TOK_in_bvTerm5645);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5647);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5649);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5652);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5654);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5657);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NOR, f, f2); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1745:5: BVCOMP_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVCOMP_TOK, &FOLLOW_BVCOMP_TOK_in_bvTerm5669);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5671);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5673);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5676);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5678);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5681);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_COMP, f, f2); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1747:5: BVXNOR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVXNOR_TOK, &FOLLOW_BVXNOR_TOK_in_bvTerm5693);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5695);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5697);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5700);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5702);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5705);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_XNOR, f, f2); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1751:5: BVUMINUS_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(BVUMINUS_TOK, &FOLLOW_BVUMINUS_TOK_in_bvTerm5724);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5726);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5728);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5731);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_NEG, f); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1754:5: BVPLUS_TOK LPAREN k= numeral COMMA formula[f] ( COMMA formula[f2] )+ RPAREN
        	    {
        	         MATCHT(BVPLUS_TOK, &FOLLOW_BVPLUS_TOK_in_bvTerm5749);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5751);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm5755);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5757);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5759);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1755:5: ( COMMA formula[f2] )+
        	        {
        	            int cnt87=0;

        	            for (;;)
        	            {
        	                int alt87=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case COMMA:
        	        		{
        	        			alt87=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt87)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1755:7: COMMA formula[f2]
        	        	        {
        	        	             MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5770);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulebvTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_formula_in_bvTerm5772);
        	        	            formula(ctx, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulebvTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 args.push_back(f2); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt87 >= 1 )
        	        		{
        	        		    goto loop87;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulebvTermEx;
        	        	}
        	        	cnt87++;
        	            }
        	            loop87: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5780);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if (k <= 0) {
        	                    PARSER_STATE->parseError("BVPLUS(k,_,_) must have k > 0");
        	                  }
        	                  for (unsigned i = 0; i < args.size(); ++ i) {
        	                    ENSURE_BV_SIZE(k, args[i]);
        	                  }
        	                  f = MK_EXPR(CVC4::kind::BITVECTOR_PLUS, args);
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1766:5: BVSUB_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSUB_TOK, &FOLLOW_BVSUB_TOK_in_bvTerm5798);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5800);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm5804);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5806);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5808);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5811);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5813);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5816);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if (k <= 0) {
        	                    PARSER_STATE->parseError("BVSUB(k,_,_) must have k > 0");
        	                  }
        	                  ENSURE_BV_SIZE(k, f);
        	                  ENSURE_BV_SIZE(k, f2);
        	                  f = MK_EXPR(CVC4::kind::BITVECTOR_SUB, f, f2);
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1776:5: BVMULT_TOK LPAREN k= numeral COMMA formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVMULT_TOK, &FOLLOW_BVMULT_TOK_in_bvTerm5834);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5836);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm5840);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5842);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5844);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5847);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5849);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5852);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if (k <= 0) {
        	                    PARSER_STATE->parseError("BVMULT(k,_,_) must have k > 0");
        	                  }
        	                  ENSURE_BV_SIZE(k, f);
        	                  ENSURE_BV_SIZE(k, f2);
        	                  f = MK_EXPR(CVC4::kind::BITVECTOR_MULT, f, f2);
        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1786:5: BVUDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVUDIV_TOK, &FOLLOW_BVUDIV_TOK_in_bvTerm5870);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5872);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5874);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5877);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5879);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5882);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UDIV, f, f2); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1789:5: BVSDIV_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSDIV_TOK, &FOLLOW_BVSDIV_TOK_in_bvTerm5900);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5902);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5904);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5907);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5909);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5912);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SDIV, f, f2); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1792:5: BVUREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVUREM_TOK, &FOLLOW_BVUREM_TOK_in_bvTerm5930);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5932);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5934);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5937);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5939);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5942);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UREM, f, f2); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1795:5: BVSREM_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSREM_TOK, &FOLLOW_BVSREM_TOK_in_bvTerm5960);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5962);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5964);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5967);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5969);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm5972);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SREM, f, f2); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1798:5: BVSMOD_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSMOD_TOK, &FOLLOW_BVSMOD_TOK_in_bvTerm5990);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm5992);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5994);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm5997);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm5999);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6002);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SMOD, f, f2); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1801:5: BVSHL_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSHL_TOK, &FOLLOW_BVSHL_TOK_in_bvTerm6020);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6022);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6024);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6027);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6029);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6032);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SHL, f, f2); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1804:5: BVASHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVASHR_TOK, &FOLLOW_BVASHR_TOK_in_bvTerm6050);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6052);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6054);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6057);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6059);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6062);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_ASHR, f, f2); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1807:5: BVLSHR_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVLSHR_TOK, &FOLLOW_BVLSHR_TOK_in_bvTerm6080);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6082);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6084);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6087);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6089);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6092);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_LSHR, f, f2); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1810:5: SX_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(SX_TOK, &FOLLOW_SX_TOK_in_bvTerm6110);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6112);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6114);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6117);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6121);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6123);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             unsigned n = BitVectorType(f.getType()).getSize();
        	                  // Sign extension in TheoryBitVector is defined as in SMT-LIB
        	                  // which is different than in the CVC language
        	                  // SX(BITVECTOR(k), n) in CVC language extends to n bits
        	                  // In SMT-LIB, such a thing expands to k + n bits
        	                  f = MK_EXPR(MK_CONST(BitVectorSignExtend(k - n)), f); 
        	        }


        	    }
        	    break;
        	case 19:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1818:5: BVZEROEXTEND_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVZEROEXTEND_TOK, &FOLLOW_BVZEROEXTEND_TOK_in_bvTerm6141);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6143);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6145);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6148);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6152);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6154);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             unsigned n = BitVectorType(f.getType()).getSize();
        	                  // Zero extension in TheoryBitVector is defined as in SMT-LIB
        	                  // which is the same as in CVC3, but different than SX!
        	                  // SX(BITVECTOR(k), n) in CVC language extends to n bits
        	                  // BVZEROEXTEND(BITVECTOR(k), n) in CVC language extends to k + n bits
        	                  f = MK_EXPR(MK_CONST(BitVectorZeroExtend(k)), f); 
        	        }


        	    }
        	    break;
        	case 20:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1826:5: BVREPEAT_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVREPEAT_TOK, &FOLLOW_BVREPEAT_TOK_in_bvTerm6172);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6174);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6176);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6179);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6183);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6185);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(MK_CONST(BitVectorRepeat(k)), f); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1829:5: BVROTR_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVROTR_TOK, &FOLLOW_BVROTR_TOK_in_bvTerm6203);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6205);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6207);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6210);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6214);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6216);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(MK_CONST(BitVectorSignExtend(k)), f); 
        	        }


        	    }
        	    break;
        	case 22:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1832:5: BVROTL_TOK LPAREN formula[f] COMMA k= numeral RPAREN
        	    {
        	         MATCHT(BVROTL_TOK, &FOLLOW_BVROTL_TOK_in_bvTerm6234);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6236);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6238);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6241);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_numeral_in_bvTerm6245);
        	        k=numeral(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6247);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(MK_CONST(BitVectorRotateLeft(k)), f); 
        	        }


        	    }
        	    break;
        	case 23:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1836:5: BVLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVLT_TOK, &FOLLOW_BVLT_TOK_in_bvTerm6266);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6268);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6270);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6273);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6275);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6278);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_ULT, f, f2); 
        	        }


        	    }
        	    break;
        	case 24:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1838:5: BVLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVLE_TOK, &FOLLOW_BVLE_TOK_in_bvTerm6290);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6292);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6294);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6297);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6299);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6302);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_ULE, f, f2); 
        	        }


        	    }
        	    break;
        	case 25:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1840:5: BVGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVGT_TOK, &FOLLOW_BVGT_TOK_in_bvTerm6314);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6316);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6318);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6321);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6323);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6326);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UGT, f, f2); 
        	        }


        	    }
        	    break;
        	case 26:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1842:5: BVGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVGE_TOK, &FOLLOW_BVGE_TOK_in_bvTerm6338);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6340);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6342);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6345);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6347);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6350);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_UGE, f, f2); 
        	        }


        	    }
        	    break;
        	case 27:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1844:5: BVSLT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSLT_TOK, &FOLLOW_BVSLT_TOK_in_bvTerm6362);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6364);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6366);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6369);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6371);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6374);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SLT, f, f2); 
        	        }


        	    }
        	    break;
        	case 28:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1846:5: BVSLE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSLE_TOK, &FOLLOW_BVSLE_TOK_in_bvTerm6386);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6388);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6390);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6393);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6395);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6398);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SLE, f, f2); 
        	        }


        	    }
        	    break;
        	case 29:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1848:5: BVSGT_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSGT_TOK, &FOLLOW_BVSGT_TOK_in_bvTerm6410);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6412);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6414);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6417);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6419);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6422);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SGT, f, f2); 
        	        }


        	    }
        	    break;
        	case 30:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1850:5: BVSGE_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(BVSGE_TOK, &FOLLOW_BVSGE_TOK_in_bvTerm6434);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_bvTerm6436);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6438);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_bvTerm6441);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_bvTerm6443);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_bvTerm6446);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::BITVECTOR_SGE, f, f2); 
        	        }


        	    }
        	    break;
        	case 31:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1853:5: stringTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_stringTerm_in_bvTerm6459);
        	        stringTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebvTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebvTermEx; /* Prevent compiler warnings */
    rulebvTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end bvTerm */

/**
 * $ANTLR start stringTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1856:1: stringTerm[CVC4::Expr& f] : ( SCONCAT_TOK LPAREN formula[f] ( COMMA formula[f2] )+ RPAREN | SCONTAINS_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SSUBSTR_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | SINDEXOF_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | SREPLACE_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | SPREFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SSUFFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STOINTEGER_TOK LPAREN formula[f] RPAREN | STOSTRING_TOK LPAREN formula[f] RPAREN | STORE_TOK LPAREN formula[f] RPAREN | str[s] | simpleTerm[f] );
 */
static void
stringTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      Expr f2;
      Expr f3;
      std::string s;
      std::vector<Expr> args;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1864:3: ( SCONCAT_TOK LPAREN formula[f] ( COMMA formula[f2] )+ RPAREN | SCONTAINS_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SSUBSTR_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | SINDEXOF_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | SREPLACE_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN | SPREFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | SSUFFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN | STOINTEGER_TOK LPAREN formula[f] RPAREN | STOSTRING_TOK LPAREN formula[f] RPAREN | STORE_TOK LPAREN formula[f] RPAREN | str[s] | simpleTerm[f] )

            ANTLR3_UINT32 alt90;

            alt90=12;

            switch ( LA(1) )
            {
            case SCONCAT_TOK:
            	{
            		alt90=1;
            	}
                break;
            case SCONTAINS_TOK:
            	{
            		alt90=2;
            	}
                break;
            case SSUBSTR_TOK:
            	{
            		alt90=3;
            	}
                break;
            case SINDEXOF_TOK:
            	{
            		alt90=4;
            	}
                break;
            case SREPLACE_TOK:
            	{
            		alt90=5;
            	}
                break;
            case SPREFIXOF_TOK:
            	{
            		alt90=6;
            	}
                break;
            case SSUFFIXOF_TOK:
            	{
            		alt90=7;
            	}
                break;
            case STOINTEGER_TOK:
            	{
            		alt90=8;
            	}
                break;
            case STOSTRING_TOK:
            	{
            		alt90=9;
            	}
                break;
            case STORE_TOK:
            	{
            		alt90=10;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt90=11;
            	}
                break;
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case FALSE_TOK:
            case HEX_LITERAL:
            case IDENTIFIER:
            case IF_TOK:
            case INTEGER_LITERAL:
            case LBRACE:
            case LPAREN:
            case PARENHASH:
            case TRUE_TOK:
            	{
            		alt90=12;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 90;
                EXCEPTION->state        = 0;


                goto rulestringTermEx;

            }

            switch (alt90)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1864:5: SCONCAT_TOK LPAREN formula[f] ( COMMA formula[f2] )+ RPAREN
        	    {
        	         MATCHT(SCONCAT_TOK, &FOLLOW_SCONCAT_TOK_in_stringTerm6485);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6487);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6489);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1865:5: ( COMMA formula[f2] )+
        	        {
        	            int cnt89=0;

        	            for (;;)
        	            {
        	                int alt89=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case COMMA:
        	        		{
        	        			alt89=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt89)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1865:7: COMMA formula[f2]
        	        	        {
        	        	             MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6500);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulestringTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_formula_in_stringTerm6502);
        	        	            formula(ctx, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto rulestringTermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 args.push_back(f2); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt89 >= 1 )
        	        		{
        	        		    goto loop89;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto rulestringTermEx;
        	        	}
        	        	cnt89++;
        	            }
        	            loop89: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6510);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_CONCAT, args); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1867:5: SCONTAINS_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(SCONTAINS_TOK, &FOLLOW_SCONTAINS_TOK_in_stringTerm6522);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6524);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6526);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6529);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6531);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6534);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STRCTN, f, f2); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1869:5: SSUBSTR_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN
        	    {
        	         MATCHT(SSUBSTR_TOK, &FOLLOW_SSUBSTR_TOK_in_stringTerm6546);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6548);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6550);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6553);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6555);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6558);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6560);
        	        formula(ctx, f3);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6563);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_SUBSTR, f, f2, f3); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1871:5: SINDEXOF_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN
        	    {
        	         MATCHT(SINDEXOF_TOK, &FOLLOW_SINDEXOF_TOK_in_stringTerm6575);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6577);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6579);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6582);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6584);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6587);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6589);
        	        formula(ctx, f3);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6592);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STRIDOF, f, f2, f3); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1873:5: SREPLACE_TOK LPAREN formula[f] COMMA formula[f2] COMMA formula[f3] RPAREN
        	    {
        	         MATCHT(SREPLACE_TOK, &FOLLOW_SREPLACE_TOK_in_stringTerm6604);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6606);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6608);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6611);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6613);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6616);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6618);
        	        formula(ctx, f3);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6621);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STRREPL, f, f2, f3); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1875:5: SPREFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(SPREFIXOF_TOK, &FOLLOW_SPREFIXOF_TOK_in_stringTerm6633);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6635);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6637);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6640);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6642);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6645);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_PREFIX, f, f2); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1877:5: SSUFFIXOF_TOK LPAREN formula[f] COMMA formula[f2] RPAREN
        	    {
        	         MATCHT(SSUFFIXOF_TOK, &FOLLOW_SSUFFIXOF_TOK_in_stringTerm6657);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6659);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6661);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(COMMA, &FOLLOW_COMMA_in_stringTerm6664);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6666);
        	        formula(ctx, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6669);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_SUFFIX, f, f2); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1879:5: STOINTEGER_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STOINTEGER_TOK, &FOLLOW_STOINTEGER_TOK_in_stringTerm6681);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6683);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6685);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6688);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_STOI, f); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1881:5: STOSTRING_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STOSTRING_TOK, &FOLLOW_STOSTRING_TOK_in_stringTerm6700);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6702);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6704);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6707);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_ITOS, f); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1883:5: STORE_TOK LPAREN formula[f] RPAREN
        	    {
        	         MATCHT(STORE_TOK, &FOLLOW_STORE_TOK_in_stringTerm6719);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_stringTerm6721);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_stringTerm6723);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_stringTerm6726);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::STRING_TO_REGEXP, f); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1887:5: str[s]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_stringTerm6745);
        	        str(ctx, s);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(CVC4::String(s)); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1890:5: simpleTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleTerm_in_stringTerm6759);
        	        simpleTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulestringTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulestringTermEx; /* Prevent compiler warnings */
    rulestringTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end stringTerm */

/**
 * $ANTLR start simpleTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1894:1: simpleTerm[CVC4::Expr& f] : ( iteTerm[f] | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | LPAREN RPAREN | PARENHASH HASHPAREN | LBRACE RBRACE | LBRACE formula[f] ( COMMA formula[f] )* RBRACE | TRUE_TOK | FALSE_TOK | DECIMAL_LITERAL | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | PARENHASH recordEntry[name,e] ( COMMA recordEntry[name,e] )* HASHPAREN | identifier[name,CHECK_DECLARED,SYM_VARIABLE] );
 */
static void
simpleTerm(pCvcParser ctx, CVC4::Expr& f)
{
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL16;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL17;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL18;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL19;

    /* Initialize rule variables
     */


      std::string name;
      std::vector<Expr> args;
      std::vector<std::string> names;
      Expr e;
      Debug("parser-extra") << "term: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Type t;

    DECIMAL_LITERAL16       = NULL;
    INTEGER_LITERAL17       = NULL;
    HEX_LITERAL18       = NULL;
    BINARY_LITERAL19       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1904:3: ( iteTerm[f] | LPAREN formula[f] ( COMMA formula[f] )* RPAREN | LPAREN RPAREN | PARENHASH HASHPAREN | LBRACE RBRACE | LBRACE formula[f] ( COMMA formula[f] )* RBRACE | TRUE_TOK | FALSE_TOK | DECIMAL_LITERAL | INTEGER_LITERAL | HEX_LITERAL | BINARY_LITERAL | PARENHASH recordEntry[name,e] ( COMMA recordEntry[name,e] )* HASHPAREN | identifier[name,CHECK_DECLARED,SYM_VARIABLE] )

            ANTLR3_UINT32 alt94;

            alt94=14;

            switch ( LA(1) )
            {
            case IF_TOK:
            	{
            		alt94=1;
            	}
                break;
            case LPAREN:
            	{
            		switch ( LA(2) )
            		{
            		case RPAREN:
            			{
            				alt94=3;
            			}
            		    break;
            		case ABS_TOK:
            		case ARRAY_TOK:
            		case BINARY_LITERAL:
            		case BVASHR_TOK:
            		case BVCOMP_TOK:
            		case BVGE_TOK:
            		case BVGT_TOK:
            		case BVLE_TOK:
            		case BVLSHR_TOK:
            		case BVLT_TOK:
            		case BVMULT_TOK:
            		case BVNAND_TOK:
            		case BVNEG_TOK:
            		case BVNOR_TOK:
            		case BVPLUS_TOK:
            		case BVREPEAT_TOK:
            		case BVROTL_TOK:
            		case BVROTR_TOK:
            		case BVSDIV_TOK:
            		case BVSGE_TOK:
            		case BVSGT_TOK:
            		case BVSHL_TOK:
            		case BVSLE_TOK:
            		case BVSLT_TOK:
            		case BVSMOD_TOK:
            		case BVSREM_TOK:
            		case BVSUB_TOK:
            		case BVUDIV_TOK:
            		case BVUMINUS_TOK:
            		case BVUREM_TOK:
            		case BVXNOR_TOK:
            		case BVXOR_TOK:
            		case BVZEROEXTEND_TOK:
            		case DECIMAL_LITERAL:
            		case DISTINCT_TOK:
            		case DIVISIBLE_TOK:
            		case EXISTS_TOK:
            		case FALSE_TOK:
            		case FLOOR_TOK:
            		case FORALL_TOK:
            		case HEX_LITERAL:
            		case IDENTIFIER:
            		case IF_TOK:
            		case INTEGER_LITERAL:
            		case IS_INTEGER_TOK:
            		case LAMBDA:
            		case LBRACE:
            		case LET_TOK:
            		case LPAREN:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case PARENHASH:
            		case SCONCAT_TOK:
            		case SCONTAINS_TOK:
            		case SINDEXOF_TOK:
            		case SPREFIXOF_TOK:
            		case SREPLACE_TOK:
            		case SSUBSTR_TOK:
            		case SSUFFIXOF_TOK:
            		case STOINTEGER_TOK:
            		case STORE_TOK:
            		case STOSTRING_TOK:
            		case STRING_LITERAL:
            		case SX_TOK:
            		case TRUE_TOK:
            			{
            				alt94=2;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 94;
            		    EXCEPTION->state        = 2;


            		    goto rulesimpleTermEx;

            		}

            	}
                break;
            case PARENHASH:
            	{
            		switch ( LA(2) )
            		{
            		case HASHPAREN:
            			{
            				alt94=4;
            			}
            		    break;
            		case IDENTIFIER:
            			{
            				alt94=13;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 94;
            		    EXCEPTION->state        = 3;


            		    goto rulesimpleTermEx;

            		}

            	}
                break;
            case LBRACE:
            	{
            		switch ( LA(2) )
            		{
            		case RBRACE:
            			{
            				alt94=5;
            			}
            		    break;
            		case ABS_TOK:
            		case ARRAY_TOK:
            		case BINARY_LITERAL:
            		case BVASHR_TOK:
            		case BVCOMP_TOK:
            		case BVGE_TOK:
            		case BVGT_TOK:
            		case BVLE_TOK:
            		case BVLSHR_TOK:
            		case BVLT_TOK:
            		case BVMULT_TOK:
            		case BVNAND_TOK:
            		case BVNEG_TOK:
            		case BVNOR_TOK:
            		case BVPLUS_TOK:
            		case BVREPEAT_TOK:
            		case BVROTL_TOK:
            		case BVROTR_TOK:
            		case BVSDIV_TOK:
            		case BVSGE_TOK:
            		case BVSGT_TOK:
            		case BVSHL_TOK:
            		case BVSLE_TOK:
            		case BVSLT_TOK:
            		case BVSMOD_TOK:
            		case BVSREM_TOK:
            		case BVSUB_TOK:
            		case BVUDIV_TOK:
            		case BVUMINUS_TOK:
            		case BVUREM_TOK:
            		case BVXNOR_TOK:
            		case BVXOR_TOK:
            		case BVZEROEXTEND_TOK:
            		case DECIMAL_LITERAL:
            		case DISTINCT_TOK:
            		case DIVISIBLE_TOK:
            		case EXISTS_TOK:
            		case FALSE_TOK:
            		case FLOOR_TOK:
            		case FORALL_TOK:
            		case HEX_LITERAL:
            		case IDENTIFIER:
            		case IF_TOK:
            		case INTEGER_LITERAL:
            		case IS_INTEGER_TOK:
            		case LAMBDA:
            		case LBRACE:
            		case LET_TOK:
            		case LPAREN:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case PARENHASH:
            		case SCONCAT_TOK:
            		case SCONTAINS_TOK:
            		case SINDEXOF_TOK:
            		case SPREFIXOF_TOK:
            		case SREPLACE_TOK:
            		case SSUBSTR_TOK:
            		case SSUFFIXOF_TOK:
            		case STOINTEGER_TOK:
            		case STORE_TOK:
            		case STOSTRING_TOK:
            		case STRING_LITERAL:
            		case SX_TOK:
            		case TRUE_TOK:
            			{
            				alt94=6;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 94;
            		    EXCEPTION->state        = 4;


            		    goto rulesimpleTermEx;

            		}

            	}
                break;
            case TRUE_TOK:
            	{
            		alt94=7;
            	}
                break;
            case FALSE_TOK:
            	{
            		alt94=8;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt94=9;
            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt94=10;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt94=11;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt94=12;
            	}
                break;
            case IDENTIFIER:
            	{
            		alt94=14;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 94;
                EXCEPTION->state        = 0;


                goto rulesimpleTermEx;

            }

            switch (alt94)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1904:5: iteTerm[f]
        	    {
        	        FOLLOWPUSH(FOLLOW_iteTerm_in_simpleTerm6787);
        	        iteTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1907:5: LPAREN formula[f] ( COMMA formula[f] )* RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_simpleTerm6801);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm6803);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1908:5: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt91=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt91=1;
        	            	}
        	                break;

        	            }

        	            switch (alt91)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1908:7: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_simpleTerm6814);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm6816);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(f); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop91;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop91: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_simpleTerm6824);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(args.size() > 1) {
        	                    /* If args has elements, we must be a tuple literal.
        	                     * Otherwise, f is already the sub-formula, and
        	                     * there's nothing to do */
        	                    std::vector<Type> types;
        	                    for(std::vector<Expr>::const_iterator i = args.begin(); i != args.end(); ++i) {
        	                      types.push_back((*i).getType());
        	                    }
        	                    TupleType t = EXPR_MANAGER->mkTupleType(types);
        	                    f = MK_EXPR(kind::TUPLE, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1923:5: LPAREN RPAREN
        	    {
        	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_simpleTerm6843);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_simpleTerm6845);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(kind::TUPLE, std::vector<Expr>()); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1926:5: PARENHASH HASHPAREN
        	    {
        	         MATCHT(PARENHASH, &FOLLOW_PARENHASH_in_simpleTerm6863);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(HASHPAREN, &FOLLOW_HASHPAREN_in_simpleTerm6865);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             RecordType t = EXPR_MANAGER->mkRecordType(std::vector< std::pair<std::string, Type> >());
        	                  f = MK_EXPR(kind::RECORD, MK_CONST(t.getRecord()), std::vector<Expr>());
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1933:5: LBRACE RBRACE
        	    {
        	         MATCHT(LBRACE, &FOLLOW_LBRACE_in_simpleTerm6885);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RBRACE, &FOLLOW_RBRACE_in_simpleTerm6887);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(EmptySet(Type())); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1937:5: LBRACE formula[f] ( COMMA formula[f] )* RBRACE
        	    {
        	         MATCHT(LBRACE, &FOLLOW_LBRACE_in_simpleTerm6906);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm6908);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1938:5: ( COMMA formula[f] )*

        	        for (;;)
        	        {
        	            int alt92=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt92=1;
        	            	}
        	                break;

        	            }

        	            switch (alt92)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1938:7: COMMA formula[f]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_simpleTerm6919);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_formula_in_simpleTerm6921);
        	        	        formula(ctx, f);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             args.push_back(f); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop92;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop92: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RBRACE, &FOLLOW_RBRACE_in_simpleTerm6929);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(kind::SINGLETON, args[0]);
        	                  for(size_t i = 1; i < args.size(); ++i) {
        	                    f = MK_EXPR(kind::UNION, f, MK_EXPR(kind::SINGLETON, args[i]));
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1946:5: TRUE_TOK
        	    {
        	         MATCHT(TRUE_TOK, &FOLLOW_TRUE_TOK_in_simpleTerm6948);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(bool(true)); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1947:5: FALSE_TOK
        	    {
        	         MATCHT(FALSE_TOK, &FOLLOW_FALSE_TOK_in_simpleTerm6957);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(bool(false)); 
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1952:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL16 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleTerm6977);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(AntlrInput::tokenToRational(DECIMAL_LITERAL16)); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1953:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL17 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleTerm6985);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_CONST(AntlrInput::tokenToInteger(INTEGER_LITERAL17)); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1955:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL18 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleTerm6999);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL18).find("0hex") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL18, 4);
        	                  f = MK_CONST( BitVector(hexString, 16) ); 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1959:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL19 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleTerm7011);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL19).find("0bin") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL19, 4);
        	                  f = MK_CONST( BitVector(binString, 2) ); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1964:5: PARENHASH recordEntry[name,e] ( COMMA recordEntry[name,e] )* HASHPAREN
        	    {
        	         MATCHT(PARENHASH, &FOLLOW_PARENHASH_in_simpleTerm7029);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_recordEntry_in_simpleTerm7031);
        	        recordEntry(ctx, name, e);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             names.push_back(name); args.push_back(e); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1965:5: ( COMMA recordEntry[name,e] )*

        	        for (;;)
        	        {
        	            int alt93=2;
        	            switch ( LA(1) )
        	            {
        	            case COMMA:
        	            	{
        	            		alt93=1;
        	            	}
        	                break;

        	            }

        	            switch (alt93)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1965:7: COMMA recordEntry[name,e]
        	        	    {
        	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_simpleTerm7042);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_recordEntry_in_simpleTerm7044);
        	        	        recordEntry(ctx, name, e);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesimpleTermEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             names.push_back(name); args.push_back(e); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop93;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop93: ; /* Jump out to here if this rule does not match */


        	         MATCHT(HASHPAREN, &FOLLOW_HASHPAREN_in_simpleTerm7052);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector< std::pair<std::string, Type> > typeIds;
        	                  assert(names.size() == args.size());
        	                  for(unsigned i = 0; i < names.size(); ++i) {
        	                    typeIds.push_back(std::make_pair(names[i], args[i].getType()));
        	                  }
        	                  RecordType t = EXPR_MANAGER->mkRecordType(typeIds);
        	                  f = MK_EXPR(kind::RECORD, MK_CONST(t.getRecord()), args);
        	                
        	        }


        	    }
        	    break;
        	case 14:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1976:5: identifier[name,CHECK_DECLARED,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_identifier_in_simpleTerm7071);
        	        identifier(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = PARSER_STATE->getVariable(name); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             // datatypes: zero-ary constructors
        	                  Type t2 = PARSER_STATE->getType(name);
        	                  if(t2.isConstructor() && ConstructorType(t2).getArity() == 0) {
        	                    // don't require parentheses, immediately turn it into an apply
        	                    f = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, f);
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleTermEx; /* Prevent compiler warnings */
    rulesimpleTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleTerm */

/**
 * $ANTLR start typeAscription
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1992:1: typeAscription[const CVC4::Expr& f, CVC4::Type& t] : COLON COLON type[t,CHECK_DECLARED] ;
 */
static void
typeAscription(pCvcParser ctx, const CVC4::Expr& f, CVC4::Type& t)
{
    /* Initialize rule variables
     */



    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1995:3: ( COLON COLON type[t,CHECK_DECLARED] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:1995:5: COLON COLON type[t,CHECK_DECLARED]
        {
             MATCHT(COLON, &FOLLOW_COLON_in_typeAscription7111);
            if  (HASEXCEPTION())
            {
                goto ruletypeAscriptionEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_typeAscription7113);
            if  (HASEXCEPTION())
            {
                goto ruletypeAscriptionEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_typeAscription7115);
            type(ctx, t, CHECK_DECLARED);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruletypeAscriptionEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruletypeAscriptionEx; /* Prevent compiler warnings */
    ruletypeAscriptionEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end typeAscription */

/**
 * $ANTLR start recordEntry
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2001:1: recordEntry[std::string& name, CVC4::Expr& ex] : identifier[name,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[ex] ;
 */
static void
recordEntry(pCvcParser ctx, std::string& name, CVC4::Expr& ex)
{
    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2002:3: ( identifier[name,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[ex] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2002:5: identifier[name,CHECK_NONE,SYM_VARIABLE] ASSIGN_TOK formula[ex]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_recordEntry7132);
            identifier(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordEntryEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(ASSIGN_TOK, &FOLLOW_ASSIGN_TOK_in_recordEntry7135);
            if  (HASEXCEPTION())
            {
                goto rulerecordEntryEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_recordEntry7137);
            formula(ctx, ex);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulerecordEntryEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulerecordEntryEx; /* Prevent compiler warnings */
    rulerecordEntryEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end recordEntry */

/**
 * $ANTLR start iteTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2008:1: iteTerm[CVC4::Expr& f] : IF_TOK formula[f] THEN_TOK formula[f] iteElseTerm[f] ENDIF_TOK ;
 */
static void
iteTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Debug("parser-extra") << "ite: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2013:3: ( IF_TOK formula[f] THEN_TOK formula[f] iteElseTerm[f] ENDIF_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2013:5: IF_TOK formula[f] THEN_TOK formula[f] iteElseTerm[f] ENDIF_TOK
        {
             MATCHT(IF_TOK, &FOLLOW_IF_TOK_in_iteTerm7159);
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_iteTerm7161);
            formula(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 args.push_back(f); 
            }


             MATCHT(THEN_TOK, &FOLLOW_THEN_TOK_in_iteTerm7170);
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_formula_in_iteTerm7172);
            formula(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 args.push_back(f); 
            }


            FOLLOWPUSH(FOLLOW_iteElseTerm_in_iteTerm7181);
            iteElseTerm(ctx, f);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 args.push_back(f); 
            }


             MATCHT(ENDIF_TOK, &FOLLOW_ENDIF_TOK_in_iteTerm7190);
            if  (HASEXCEPTION())
            {
                goto ruleiteTermEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 f = MK_EXPR(CVC4::kind::ITE, args); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleiteTermEx; /* Prevent compiler warnings */
    ruleiteTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end iteTerm */

/**
 * $ANTLR start iteElseTerm
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2023:1: iteElseTerm[CVC4::Expr& f] : ( ELSE_TOK formula[f] | ELSEIF_TOK iteCondition= formula[f] THEN_TOK iteThen= formula[f] iteElse= iteElseTerm[f] );
 */
static void
iteElseTerm(pCvcParser ctx, CVC4::Expr& f)
{
    /* Initialize rule variables
     */


      std::vector<Expr> args;
      Debug("parser-extra") << "else: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2028:3: ( ELSE_TOK formula[f] | ELSEIF_TOK iteCondition= formula[f] THEN_TOK iteThen= formula[f] iteElse= iteElseTerm[f] )

            ANTLR3_UINT32 alt95;

            alt95=2;

            switch ( LA(1) )
            {
            case ELSE_TOK:
            	{
            		alt95=1;
            	}
                break;
            case ELSEIF_TOK:
            	{
            		alt95=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 95;
                EXCEPTION->state        = 0;


                goto ruleiteElseTermEx;

            }

            switch (alt95)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2028:5: ELSE_TOK formula[f]
        	    {
        	         MATCHT(ELSE_TOK, &FOLLOW_ELSE_TOK_in_iteElseTerm7217);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_iteElseTerm7219);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2029:5: ELSEIF_TOK iteCondition= formula[f] THEN_TOK iteThen= formula[f] iteElse= iteElseTerm[f]
        	    {
        	         MATCHT(ELSEIF_TOK, &FOLLOW_ELSEIF_TOK_in_iteElseTerm7226);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_iteElseTerm7232);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	         MATCHT(THEN_TOK, &FOLLOW_THEN_TOK_in_iteElseTerm7241);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_formula_in_iteElseTerm7247);
        	        formula(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        FOLLOWPUSH(FOLLOW_iteElseTerm_in_iteElseTerm7260);
        	        iteElseTerm(ctx, f);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleiteElseTermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             args.push_back(f); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             f = MK_EXPR(CVC4::kind::ITE, args); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleiteElseTermEx; /* Prevent compiler warnings */
    ruleiteElseTermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end iteElseTerm */

/**
 * $ANTLR start datatypeDef
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2038:1: datatypeDef[std::vector<CVC4::Datatype>& datatypes] : identifier[id,CHECK_NONE,SYM_SORT] ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )? EQUAL_TOK constructorDef[datatypes.back()] ( BAR constructorDef[datatypes.back()] )* ;
 */
static void
datatypeDef(pCvcParser ctx, std::vector<CVC4::Datatype>& datatypes)
{
    /* Initialize rule variables
     */


      std::string id, id2;
      Type t;
      std::vector< Type > params;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2048:3: ( identifier[id,CHECK_NONE,SYM_SORT] ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )? EQUAL_TOK constructorDef[datatypes.back()] ( BAR constructorDef[datatypes.back()] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2048:5: identifier[id,CHECK_NONE,SYM_SORT] ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )? EQUAL_TOK constructorDef[datatypes.back()] ( BAR constructorDef[datatypes.back()] )*
        {
            FOLLOWPUSH(FOLLOW_identifier_in_datatypeDef7296);
            identifier(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->pushScope(); 
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2049:5: ( LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET )?
            {
                int alt97=2;
                switch ( LA(1) )
                {
                    case LBRACKET:
                    	{
                    		alt97=1;
                    	}
                        break;
                }

                switch (alt97)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2049:7: LBRACKET identifier[id2,CHECK_UNDECLARED,SYM_SORT] ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )* RBRACKET
            	    {
            	         MATCHT(LBRACKET, &FOLLOW_LBRACKET_in_datatypeDef7307);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_identifier_in_datatypeDef7309);
            	        identifier(ctx, id2, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {

            	                    t = PARSER_STATE->mkSort(id2, ExprManager::SORT_FLAG_PLACEHOLDER);
            	                    params.push_back( t );
            	                  
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2053:7: ( COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT] )*

            	        for (;;)
            	        {
            	            int alt96=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt96=1;
            	            	}
            	                break;

            	            }

            	            switch (alt96)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2053:9: COMMA identifier[id2,CHECK_UNDECLARED,SYM_SORT]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_datatypeDef7322);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruledatatypeDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_identifier_in_datatypeDef7324);
            	        	        identifier(ctx, id2, CHECK_UNDECLARED, SYM_SORT);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruledatatypeDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        if ( BACKTRACKING==0 )
            	        	        {

            	        	                    t = PARSER_STATE->mkSort(id2, ExprManager::SORT_FLAG_PLACEHOLDER);
            	        	                    params.push_back( t ); 
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop96;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop96: ; /* Jump out to here if this rule does not match */


            	         MATCHT(RBRACKET, &FOLLOW_RBRACKET_in_datatypeDef7338);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 datatypes.push_back(Datatype(id, params, false));
                      if(!PARSER_STATE->isUnresolvedType(id)) {
                        // if not unresolved, must be undeclared
                        PARSER_STATE->checkDeclaration(id, CHECK_UNDECLARED, SYM_SORT);
                      }
                    
            }


             MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_datatypeDef7357);
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef7359);
            constructorDef(ctx, datatypes.back());

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2065:5: ( BAR constructorDef[datatypes.back()] )*

            for (;;)
            {
                int alt98=2;
                switch ( LA(1) )
                {
                case BAR:
                	{
                		alt98=1;
                	}
                    break;

                }

                switch (alt98)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2065:7: BAR constructorDef[datatypes.back()]
            	    {
            	         MATCHT(BAR, &FOLLOW_BAR_in_datatypeDef7368);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef7370);
            	        constructorDef(ctx, datatypes.back());

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypeDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop98;	/* break out of the loop */
            	    break;
                }
            }
            loop98: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->popScope(); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefEx; /* Prevent compiler warnings */
    ruledatatypeDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDef */

/**
 * $ANTLR start constructorDef
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2072:1: constructorDef[CVC4::Datatype& type] : identifier[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN selector[*ctor] ( COMMA selector[*ctor] )* RPAREN )? ;
 */
static void
constructorDef(pCvcParser ctx, CVC4::Datatype& type)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::DatatypeConstructor* ctor = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2077:3: ( identifier[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN selector[*ctor] ( COMMA selector[*ctor] )* RPAREN )? )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2077:5: identifier[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN selector[*ctor] ( COMMA selector[*ctor] )* RPAREN )?
        {
            FOLLOWPUSH(FOLLOW_identifier_in_constructorDef7401);
            identifier(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconstructorDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 // make the tester
                      std::string testerId("is_");
                      testerId.append(id);
                      PARSER_STATE->checkDeclaration(testerId, CHECK_UNDECLARED, SYM_SORT);
                      ctor = new CVC4::DatatypeConstructor(id, testerId);
                    
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2084:5: ( LPAREN selector[*ctor] ( COMMA selector[*ctor] )* RPAREN )?
            {
                int alt100=2;
                switch ( LA(1) )
                {
                    case LPAREN:
                    	{
                    		alt100=1;
                    	}
                        break;
                }

                switch (alt100)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2084:7: LPAREN selector[*ctor] ( COMMA selector[*ctor] )* RPAREN
            	    {
            	         MATCHT(LPAREN, &FOLLOW_LPAREN_in_constructorDef7416);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef7424);
            	        selector(ctx, *ctor);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2086:7: ( COMMA selector[*ctor] )*

            	        for (;;)
            	        {
            	            int alt99=2;
            	            switch ( LA(1) )
            	            {
            	            case COMMA:
            	            	{
            	            		alt99=1;
            	            	}
            	                break;

            	            }

            	            switch (alt99)
            	            {
            	        	case 1:
            	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2086:9: COMMA selector[*ctor]
            	        	    {
            	        	         MATCHT(COMMA, &FOLLOW_COMMA_in_constructorDef7435);
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconstructorDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef7437);
            	        	        selector(ctx, *ctor);

            	        	        FOLLOWPOP();
            	        	        if  (HASEXCEPTION())
            	        	        {
            	        	            goto ruleconstructorDefEx;
            	        	        }
            	        	        if (HASFAILED())
            	        	        {
            	        	            return ;
            	        	        }


            	        	    }
            	        	    break;

            	        	default:
            	        	    goto loop99;	/* break out of the loop */
            	        	    break;
            	            }
            	        }
            	        loop99: ; /* Jump out to here if this rule does not match */


            	         MATCHT(RPAREN, &FOLLOW_RPAREN_in_constructorDef7449);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

            if ( BACKTRACKING==0 )
            {
                 // make the constructor
                      type.addConstructor(*ctor);
                      Debug("parser-idt") << "constructor: " << id.c_str() << std::endl;
                      delete ctor;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconstructorDefEx; /* Prevent compiler warnings */
    ruleconstructorDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end constructorDef */

/**
 * $ANTLR start selector
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2096:1: selector[CVC4::DatatypeConstructor& ctor] : identifier[id,CHECK_UNDECLARED,SYM_SORT] COLON type[t,CHECK_NONE] ;
 */
static void
selector(pCvcParser ctx, CVC4::DatatypeConstructor& ctor)
{
    /* Initialize rule variables
     */


      std::string id;
      Type t, t2;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2101:3: ( identifier[id,CHECK_UNDECLARED,SYM_SORT] COLON type[t,CHECK_NONE] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2101:5: identifier[id,CHECK_UNDECLARED,SYM_SORT] COLON type[t,CHECK_NONE]
        {
            FOLLOWPUSH(FOLLOW_identifier_in_selector7481);
            identifier(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(COLON, &FOLLOW_COLON_in_selector7484);
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_type_in_selector7486);
            type(ctx, t, CHECK_NONE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 ctor.addArg(id, t);
                      Debug("parser-idt") << "selector: " << id.c_str() << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleselectorEx; /* Prevent compiler warnings */
    ruleselectorEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end selector */

/**
 * $ANTLR start numeral
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2119:1: numeral returns [unsigned k = 0] : INTEGER_LITERAL ;
 */
static unsigned
numeral(pCvcParser ctx)
{
    unsigned k;


    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL20;

    /* Initialize rule variables
     */
    k =  0;


    INTEGER_LITERAL20       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2120:3: ( INTEGER_LITERAL )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2120:5: INTEGER_LITERAL
        {
            INTEGER_LITERAL20 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_numeral7561);
            if  (HASEXCEPTION())
            {
                goto rulenumeralEx;
            }
            if (HASFAILED())
            {
                return k;
            }


            if ( BACKTRACKING==0 )
            {
                 k= AntlrInput::tokenToUnsigned(INTEGER_LITERAL20);
                 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulenumeralEx; /* Prevent compiler warnings */
    rulenumeralEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return k;
}
/* $ANTLR end numeral */

/**
 * $ANTLR start integer
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2127:1: integer returns [CVC4::Rational k = 0] : ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL );
 */
static CVC4::Rational
integer(pCvcParser ctx)
{
    CVC4::Rational k;


    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL21;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL22;

    /* Initialize rule variables
     */
    k =  0;


    INTEGER_LITERAL21       = NULL;
    INTEGER_LITERAL22       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2128:3: ( INTEGER_LITERAL | MINUS_TOK INTEGER_LITERAL )

            ANTLR3_UINT32 alt101;

            alt101=2;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt101=1;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt101=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return k;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 101;
                EXCEPTION->state        = 0;


                goto ruleintegerEx;

            }

            switch (alt101)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2128:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL21 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_integer7586);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintegerEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return k;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             k= AntlrInput::tokenToInteger(INTEGER_LITERAL21);
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2130:5: MINUS_TOK INTEGER_LITERAL
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_integer7598);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintegerEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return k;
        	        }


        	        INTEGER_LITERAL22 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_integer7600);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleintegerEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return k;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             k= -AntlrInput::tokenToInteger(INTEGER_LITERAL22);
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleintegerEx; /* Prevent compiler warnings */
    ruleintegerEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return k;
}
/* $ANTLR end integer */

/**
 * $ANTLR start str
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2137:1: str[std::string& s] : STRING_LITERAL ;
 */
static void
str(pCvcParser ctx, std::string& s)
{
    pANTLR3_COMMON_TOKEN    STRING_LITERAL23;

    /* Initialize rule variables
     */

    STRING_LITERAL23       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2138:3: ( STRING_LITERAL )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:2138:5: STRING_LITERAL
        {
            STRING_LITERAL23 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL, &FOLLOW_STRING_LITERAL_in_str7622);
            if  (HASEXCEPTION())
            {
                goto rulestrEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 s = AntlrInput::tokenText(STRING_LITERAL23);
                      /* strip off the quotes */
                      s = s.substr(1, s.size() - 2);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulestrEx; /* Prevent compiler warnings */
    rulestrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end str */

// $ANTLR start synpred1_Cvc
static void synpred1_Cvc_fragment(pCvcParser ctx )
{
    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:642:5: ( letDecl )
    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/cvc/Cvc.g:642:5: letDecl
    {
        FOLLOWPUSH(FOLLOW_letDecl_in_synpred1_Cvc1772);
        letDecl(ctx);

        FOLLOWPOP();
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_CvcEx;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

// This is where rules clean up and exit
//
goto rulesynpred1_CvcEx; /* Prevent compiler warnings */
rulesynpred1_CvcEx: ;

}
// $ANTLR end synpred1_Cvc
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
static ANTLR3_BOOLEAN synpred1_Cvc(pCvcParser ctx)
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred1_Cvc_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}

/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
