/** \file
 *  This C source file was generated by $ANTLR version 3.4
 *
 *     -  From the grammar source file : /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g
 *     -                            On : 2014-07-13 13:48:59
 *     -                for the parser : Smt2ParserParser
 *
 * Editing it, at least manually, is not wise.
 *
 * C language generator and runtime by Jim Idle, jimi|hereisanat|idle|dotgoeshere|ws.
 *
 *
*/
// [The "BSD license"]
// Copyright (c) 2005-2009 Jim Idle, Temporal Wave LLC
// http://www.temporal-wave.com
// http://www.linkedin.com/in/jimidle
//
// All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
// 3. The name of the author may not be used to endorse or promote products
//    derived from this software without specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


/* =============================================================================
 * This is what the grammar programmer asked us to put at the top of every file.
 */

/**
 ** This file is part of CVC4.
 ** Copyright (c) 2009-2014  New York University and The University of Iowa
 ** See the file COPYING in the top-level source directory for licensing
 ** information.
 **/

/* End of Header action.
 * =============================================================================
 */

/* -----------------------------------------
 * Include the ANTLR3 generated header file.
 */
#include    "Smt2Parser.h"


#include "expr/expr.h"
#include "expr/kind.h"
#include "expr/type.h"
#include "parser/antlr_input.h"
#include "parser/parser.h"
#include "parser/smt2/smt2.h"
#include "util/integer.h"
#include "util/output.h"
#include "util/rational.h"
#include "util/hash.h"
#include <vector>
#include <set>
#include <string>
#include <sstream>

using namespace CVC4;
using namespace CVC4::parser;

/* These need to be macros so they can refer to the PARSER macro, which
 * will be defined by ANTLR *after* this section. (If they were functions,
 * PARSER would be undefined.) */
#undef PARSER_STATE
#define PARSER_STATE ((Smt2*)PARSER->super)
#undef EXPR_MANAGER
#define EXPR_MANAGER PARSER_STATE->getExprManager()
#undef MK_EXPR
#define MK_EXPR EXPR_MANAGER->mkExpr
#undef MK_CONST
#define MK_CONST EXPR_MANAGER->mkConst
#define UNSUPPORTED PARSER_STATE->unimplementedFeature

static bool isClosed(Expr e, std::set<Expr>& free, std::hash_set<Expr, ExprHashFunction>& closedCache) {
  if(closedCache.find(e) != closedCache.end()) {
    return true;
  }

  if(e.getKind() == kind::FORALL || e.getKind() == kind::EXISTS || e.getKind() == kind::LAMBDA) {
    isClosed(e[1], free, closedCache);
    for(Expr::const_iterator i = e[0].begin(); i != e[0].end(); ++i) {
      free.erase(*i);
    }
  } else if(e.getKind() == kind::BOUND_VARIABLE) {
    free.insert(e);
    return false;
  } else {
    if(e.hasOperator()) {
      isClosed(e.getOperator(), free, closedCache);
    }
    for(Expr::const_iterator i = e.begin(); i != e.end(); ++i) {
      isClosed(*i, free, closedCache);
    }
  }

  if(free.empty()) {
    closedCache.insert(e);
    return true;
  } else {
    return false;
  }
}

static inline bool isClosed(Expr e, std::set<Expr>& free) {
  std::hash_set<Expr, ExprHashFunction> cache;
  return isClosed(e, free, cache);
}


/* ----------------------------------------- */





/* MACROS that hide the C interface implementations from the
 * generated code, which makes it a little more understandable to the human eye.
 * I am very much against using C pre-processor macros for function calls and bits
 * of code as you cannot see what is happening when single stepping in debuggers
 * and so on. The exception (in my book at least) is for generated code, where you are
 * not maintaining it, but may wish to read and understand it. If you single step it, you know that input()
 * hides some indirect calls, but is always referring to the input stream. This is
 * probably more readable than ctx->input->istream->input(snarfle0->blarg) and allows me to rejig
 * the runtime interfaces without changing the generated code too often, without
 * confusing the reader of the generated output, who may not wish to know the gory
 * details of the interface inheritance.
 */

#define		CTX	ctx

/* Aids in accessing scopes for grammar programmers
 */
#undef	SCOPE_TYPE
#undef	SCOPE_STACK
#undef	SCOPE_TOP
#define	SCOPE_TYPE(scope)   pSmt2Parser_##scope##_SCOPE
#define SCOPE_STACK(scope)  pSmt2Parser_##scope##Stack
#define	SCOPE_TOP(scope)    ctx->pSmt2Parser_##scope##Top
#define	SCOPE_SIZE(scope)		ctx->pSmt2Parser_##scope##Stack_limit
#define SCOPE_INSTANCE(scope, i)	(ctx->SCOPE_STACK(scope)->get(ctx->SCOPE_STACK(scope),i))

/* Macros for accessing things in the parser
 */

#undef	    PARSER
#undef	    RECOGNIZER
#undef	    HAVEPARSEDRULE
#undef		MEMOIZE
#undef	    INPUT
#undef	    STRSTREAM
#undef	    HASEXCEPTION
#undef	    EXCEPTION
#undef	    MATCHT
#undef	    MATCHANYT
#undef	    FOLLOWSTACK
#undef	    FOLLOWPUSH
#undef	    FOLLOWPOP
#undef	    PRECOVER
#undef	    PREPORTERROR
#undef	    LA
#undef	    LT
#undef	    CONSTRUCTEX
#undef	    CONSUME
#undef	    MARK
#undef	    REWIND
#undef	    REWINDLAST
#undef	    PERRORRECOVERY
#undef	    HASFAILED
#undef	    FAILEDFLAG
#undef	    RECOVERFROMMISMATCHEDSET
#undef	    RECOVERFROMMISMATCHEDELEMENT
#undef		INDEX
#undef      ADAPTOR
#undef		SEEK
#undef	    RULEMEMO
#undef		DBG

#define	    PARSER				ctx->pParser
#define	    RECOGNIZER				PARSER->rec
#define	    PSRSTATE				RECOGNIZER->state
#define	    HAVEPARSEDRULE(r)			RECOGNIZER->alreadyParsedRule(RECOGNIZER, r)
#define	    MEMOIZE(ri,si)			RECOGNIZER->memoize(RECOGNIZER, ri, si)
#define	    INPUT				PARSER->tstream
#define	    STRSTREAM				INPUT
#define	    ISTREAM				INPUT->istream
#define	    INDEX()				ISTREAM->index(INPUT->istream)
#define	    HASEXCEPTION()			(PSRSTATE->error == ANTLR3_TRUE)
#define	    EXCEPTION				PSRSTATE->exception
#define	    MATCHT(t, fs)			RECOGNIZER->match(RECOGNIZER, t, fs)
#define	    MATCHANYT()				RECOGNIZER->matchAny(RECOGNIZER)
#define	    FOLLOWSTACK				PSRSTATE->following
#ifdef  SKIP_FOLLOW_SETS
#define	    FOLLOWPUSH(x)
#define	    FOLLOWPOP()
#else
#define	    FOLLOWPUSH(x)			FOLLOWSTACK->push(FOLLOWSTACK, ((void *)(&(x))), NULL)
#define	    FOLLOWPOP()				FOLLOWSTACK->pop(FOLLOWSTACK)
#endif
#define	    PRECOVER()				RECOGNIZER->recover(RECOGNIZER)
#define	    PREPORTERROR()			RECOGNIZER->reportError(RECOGNIZER)
#define	    LA(n)				INPUT->istream->_LA(ISTREAM, n)
#define	    LT(n)				INPUT->_LT(INPUT, n)
#define	    CONSTRUCTEX()			RECOGNIZER->exConstruct(RECOGNIZER)
#define	    CONSUME()				ISTREAM->consume(ISTREAM)
#define	    MARK()				ISTREAM->mark(ISTREAM)
#define	    REWIND(m)				ISTREAM->rewind(ISTREAM, m)
#define	    REWINDLAST()			ISTREAM->rewindLast(ISTREAM)
#define	    SEEK(n)				ISTREAM->seek(ISTREAM, n)
#define	    PERRORRECOVERY			PSRSTATE->errorRecovery
#define	    FAILEDFLAG				PSRSTATE->failed
#define	    HASFAILED()				(FAILEDFLAG == ANTLR3_TRUE)
#define	    BACKTRACKING			PSRSTATE->backtracking
#define	    RECOVERFROMMISMATCHEDSET(s)		RECOGNIZER->recoverFromMismatchedSet(RECOGNIZER, s)
#define	    RECOVERFROMMISMATCHEDELEMENT(e)	RECOGNIZER->recoverFromMismatchedElement(RECOGNIZER, s)
#define     ADAPTOR                         ctx->adaptor
#define		RULEMEMO						PSRSTATE->ruleMemo
#define		DBG								RECOGNIZER->debugger


#define		TOKTEXT(tok, txt)				tok, (pANTLR3_UINT8)txt

/* The 4 tokens defined below may well clash with your own #defines or token types. If so
 * then for the present you must use different names for your defines as these are hard coded
 * in the code generator. It would be better not to use such names internally, and maybe
 * we can change this in a forthcoming release. I deliberately do not #undef these
 * here as this will at least give you a redefined error somewhere if they clash.
 */
#define	    UP	    ANTLR3_TOKEN_UP
#define	    DOWN    ANTLR3_TOKEN_DOWN
#define	    EOR	    ANTLR3_TOKEN_EOR
#define	    INVALID ANTLR3_TOKEN_INVALID


/* =============================================================================
 * Functions to create and destroy scopes. First come the rule scopes, followed
 * by the global declared scopes.
 */



/* ============================================================================= */

/* =============================================================================
 * Start of recognizer
 */


/** \brief Table of all token names in symbolic order, mainly used for
 *         error reporting.
 */
pANTLR3_UINT8   Smt2ParserTokenNames[157+4]
     = {
        (pANTLR3_UINT8) "<invalid>",       /* String to print to indicate an invalid token */
        (pANTLR3_UINT8) "<EOR>",
        (pANTLR3_UINT8) "<DOWN>",
        (pANTLR3_UINT8) "<UP>",
        (pANTLR3_UINT8) "ABS_TOK",
        (pANTLR3_UINT8) "ALPHA",
        (pANTLR3_UINT8) "AMPERSAND_TOK",
        (pANTLR3_UINT8) "AND_TOK",
        (pANTLR3_UINT8) "ASSERT_TOK",
        (pANTLR3_UINT8) "AS_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_NAMED_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_NO_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_PATTERN_TOK",
        (pANTLR3_UINT8) "ATTRIBUTE_TOK",
        (pANTLR3_UINT8) "AT_TOK",
        (pANTLR3_UINT8) "BINARY_LITERAL",
        (pANTLR3_UINT8) "BV2NAT_TOK",
        (pANTLR3_UINT8) "BVADD_TOK",
        (pANTLR3_UINT8) "BVAND_TOK",
        (pANTLR3_UINT8) "BVASHR_TOK",
        (pANTLR3_UINT8) "BVCOMP_TOK",
        (pANTLR3_UINT8) "BVLSHR_TOK",
        (pANTLR3_UINT8) "BVMUL_TOK",
        (pANTLR3_UINT8) "BVNAND_TOK",
        (pANTLR3_UINT8) "BVNEG_TOK",
        (pANTLR3_UINT8) "BVNOR_TOK",
        (pANTLR3_UINT8) "BVNOT_TOK",
        (pANTLR3_UINT8) "BVOR_TOK",
        (pANTLR3_UINT8) "BVSDIV_TOK",
        (pANTLR3_UINT8) "BVSGE_TOK",
        (pANTLR3_UINT8) "BVSGT_TOK",
        (pANTLR3_UINT8) "BVSHL_TOK",
        (pANTLR3_UINT8) "BVSLE_TOK",
        (pANTLR3_UINT8) "BVSLT_TOK",
        (pANTLR3_UINT8) "BVSMOD_TOK",
        (pANTLR3_UINT8) "BVSREM_TOK",
        (pANTLR3_UINT8) "BVSUB_TOK",
        (pANTLR3_UINT8) "BVUDIV_TOK",
        (pANTLR3_UINT8) "BVUGE_TOK",
        (pANTLR3_UINT8) "BVUGT_TOK",
        (pANTLR3_UINT8) "BVULE_TOK",
        (pANTLR3_UINT8) "BVULT_TOK",
        (pANTLR3_UINT8) "BVUREM_TOK",
        (pANTLR3_UINT8) "BVXNOR_TOK",
        (pANTLR3_UINT8) "BVXOR_TOK",
        (pANTLR3_UINT8) "CHECKSAT_TOK",
        (pANTLR3_UINT8) "COMMENT",
        (pANTLR3_UINT8) "CONCAT_TOK",
        (pANTLR3_UINT8) "DECIMAL_LITERAL",
        (pANTLR3_UINT8) "DECLARE_CODATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_CONST_TOK",
        (pANTLR3_UINT8) "DECLARE_DATATYPES_TOK",
        (pANTLR3_UINT8) "DECLARE_FUNS_TOK",
        (pANTLR3_UINT8) "DECLARE_FUN_TOK",
        (pANTLR3_UINT8) "DECLARE_PREDS_TOK",
        (pANTLR3_UINT8) "DECLARE_SORTS_TOK",
        (pANTLR3_UINT8) "DECLARE_SORT_TOK",
        (pANTLR3_UINT8) "DEFINE_CONST_TOK",
        (pANTLR3_UINT8) "DEFINE_FUN_TOK",
        (pANTLR3_UINT8) "DEFINE_SORT_TOK",
        (pANTLR3_UINT8) "DEFINE_TOK",
        (pANTLR3_UINT8) "DIGIT",
        (pANTLR3_UINT8) "DISTINCT_TOK",
        (pANTLR3_UINT8) "DIVISIBLE_TOK",
        (pANTLR3_UINT8) "DIV_TOK",
        (pANTLR3_UINT8) "ECHO_TOK",
        (pANTLR3_UINT8) "EMPTYSET_TOK",
        (pANTLR3_UINT8) "EQUAL_TOK",
        (pANTLR3_UINT8) "EXISTS_TOK",
        (pANTLR3_UINT8) "EXIT_TOK",
        (pANTLR3_UINT8) "FMFCARD_TOK",
        (pANTLR3_UINT8) "FORALL_TOK",
        (pANTLR3_UINT8) "GET_ASSERTIONS_TOK",
        (pANTLR3_UINT8) "GET_ASSIGNMENT_TOK",
        (pANTLR3_UINT8) "GET_INFO_TOK",
        (pANTLR3_UINT8) "GET_MODEL_TOK",
        (pANTLR3_UINT8) "GET_OPTION_TOK",
        (pANTLR3_UINT8) "GET_PROOF_TOK",
        (pANTLR3_UINT8) "GET_UNSAT_CORE_TOK",
        (pANTLR3_UINT8) "GET_VALUE_TOK",
        (pANTLR3_UINT8) "GREATER_THAN_EQUAL_TOK",
        (pANTLR3_UINT8) "GREATER_THAN_TOK",
        (pANTLR3_UINT8) "HEX_DIGIT",
        (pANTLR3_UINT8) "HEX_LITERAL",
        (pANTLR3_UINT8) "IMPLIES_TOK",
        (pANTLR3_UINT8) "INCLUDE_TOK",
        (pANTLR3_UINT8) "INDEX_TOK",
        (pANTLR3_UINT8) "INT2BV_TOK",
        (pANTLR3_UINT8) "INTEGER_LITERAL",
        (pANTLR3_UINT8) "INTS_DIV_TOK",
        (pANTLR3_UINT8) "INTS_MOD_TOK",
        (pANTLR3_UINT8) "IS_INT_TOK",
        (pANTLR3_UINT8) "ITE_TOK",
        (pANTLR3_UINT8) "KEYWORD",
        (pANTLR3_UINT8) "LESS_THAN_EQUAL_TOK",
        (pANTLR3_UINT8) "LESS_THAN_TOK",
        (pANTLR3_UINT8) "LET_TOK",
        (pANTLR3_UINT8) "LPAREN_TOK",
        (pANTLR3_UINT8) "MINUS_TOK",
        (pANTLR3_UINT8) "NOT_TOK",
        (pANTLR3_UINT8) "NUMERAL",
        (pANTLR3_UINT8) "OR_TOK",
        (pANTLR3_UINT8) "PLUS_TOK",
        (pANTLR3_UINT8) "POP_TOK",
        (pANTLR3_UINT8) "POUND_TOK",
        (pANTLR3_UINT8) "PROPAGATION_RULE_TOK",
        (pANTLR3_UINT8) "PUSH_TOK",
        (pANTLR3_UINT8) "QUOTED_SYMBOL",
        (pANTLR3_UINT8) "REALLCHAR_TOK",
        (pANTLR3_UINT8) "RECON_TOK",
        (pANTLR3_UINT8) "REDUCTION_RULE_TOK",
        (pANTLR3_UINT8) "REINTER_TOK",
        (pANTLR3_UINT8) "RELOOP_TOK",
        (pANTLR3_UINT8) "RENOSTR_TOK",
        (pANTLR3_UINT8) "REOPT_TOK",
        (pANTLR3_UINT8) "REPLUS_TOK",
        (pANTLR3_UINT8) "RERANGE_TOK",
        (pANTLR3_UINT8) "RESTAR_TOK",
        (pANTLR3_UINT8) "REUNION_TOK",
        (pANTLR3_UINT8) "REWRITE_RULE_TOK",
        (pANTLR3_UINT8) "RPAREN_TOK",
        (pANTLR3_UINT8) "SELECT_TOK",
        (pANTLR3_UINT8) "SET_INFO_TOK",
        (pANTLR3_UINT8) "SET_LOGIC_TOK",
        (pANTLR3_UINT8) "SET_OPTION_TOK",
        (pANTLR3_UINT8) "SIMPLE_SYMBOL",
        (pANTLR3_UINT8) "SIMPLIFY_TOK",
        (pANTLR3_UINT8) "STAR_TOK",
        (pANTLR3_UINT8) "STORE_TOK",
        (pANTLR3_UINT8) "STRCAT_TOK",
        (pANTLR3_UINT8) "STRCON_TOK",
        (pANTLR3_UINT8) "STRCTN_TOK",
        (pANTLR3_UINT8) "STRIDOF_TOK",
        (pANTLR3_UINT8) "STRING_LITERAL",
        (pANTLR3_UINT8) "STRINRE_TOK",
        (pANTLR3_UINT8) "STRITOS_TOK",
        (pANTLR3_UINT8) "STRLEN_TOK",
        (pANTLR3_UINT8) "STRPREF_TOK",
        (pANTLR3_UINT8) "STRREPL_TOK",
        (pANTLR3_UINT8) "STRSTOI_TOK",
        (pANTLR3_UINT8) "STRSTOU16_TOK",
        (pANTLR3_UINT8) "STRSTOU32_TOK",
        (pANTLR3_UINT8) "STRSUB_TOK",
        (pANTLR3_UINT8) "STRSUFF_TOK",
        (pANTLR3_UINT8) "STRTORE_TOK",
        (pANTLR3_UINT8) "STRU16TOS_TOK",
        (pANTLR3_UINT8) "STRU32TOS_TOK",
        (pANTLR3_UINT8) "SYMBOL_CHAR",
        (pANTLR3_UINT8) "SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE",
        (pANTLR3_UINT8) "TO_INT_TOK",
        (pANTLR3_UINT8) "TO_REAL_TOK",
        (pANTLR3_UINT8) "UNTERMINATED_QUOTED_SYMBOL",
        (pANTLR3_UINT8) "WHITESPACE",
        (pANTLR3_UINT8) "XOR_TOK",
        (pANTLR3_UINT8) "'\\\\'",
        (pANTLR3_UINT8) "'extract'",
        (pANTLR3_UINT8) "'repeat'",
        (pANTLR3_UINT8) "'rotate_left'",
        (pANTLR3_UINT8) "'rotate_right'",
        (pANTLR3_UINT8) "'sign_extend'",
        (pANTLR3_UINT8) "'zero_extend'"
       };



// Forward declare the locally static matching functions we have generated.
//
static 
 CVC4::parser::smt2::myExpr
	parseExpr    (pSmt2Parser ctx);
static 
 CVC4::Command*
	parseCommand    (pSmt2Parser ctx);
static 
 CVC4::Command*
	command    (pSmt2Parser ctx);
static 
 void
	extendedCommand    (pSmt2Parser ctx, CVC4::Command*& cmd);
static 
 void
	datatypesDefCommand    (pSmt2Parser ctx, bool isCo, CVC4::Command*& cmd);
static 
 void
	rewriterulesCommand    (pSmt2Parser ctx, CVC4::Command*& cmd);
static 
 void
	rewritePropaKind    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	pattern    (pSmt2Parser ctx, CVC4::Expr& expr);
static 
 void
	simpleSymbolicExprNoKeyword    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	keyword    (pSmt2Parser ctx, std::string& s);
static 
 void
	simpleSymbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	symbolicExpr    (pSmt2Parser ctx, CVC4::SExpr& sexpr);
static 
 void
	term    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2);
static 
 void
	attribute    (pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr);
static 
 void
	indexedFunctionName    (pSmt2Parser ctx, CVC4::Expr& op);
static 
 void
	badIndexedFunctionName    (pSmt2Parser ctx);
static 
 void
	termList    (pSmt2Parser ctx, std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr);
static 
 void
	str    (pSmt2Parser ctx, std::string& s, bool fsmtlib);
static 
 void
	builtinOp    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	quantOp    (pSmt2Parser ctx, CVC4::Kind& kind);
static 
 void
	functionName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortList    (pSmt2Parser ctx, std::vector<CVC4::Type>& sorts);
static 
 void
	nonemptySortList    (pSmt2Parser ctx, std::vector<CVC4::Type>& sorts);
static 
 void
	sortedVarList    (pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::Type> >& sortedVars);
static 
 void
	sortName    (pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check);
static 
 void
	sortSymbol    (pSmt2Parser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check);
static 
 void
	symbolList    (pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	symbol    (pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type);
static 
 void
	nonemptyNumeralList    (pSmt2Parser ctx, std::vector<uint64_t>& numerals);
static 
 void
	datatypeDef    (pSmt2Parser ctx, bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params);
static 
 void
	constructorDef    (pSmt2Parser ctx, CVC4::Datatype& type);
static 
 void
	selector    (pSmt2Parser ctx, CVC4::DatatypeConstructor& ctor);
static 
 ANTLR3_BOOLEAN
	synpred1_Smt2    (pSmt2Parser ctx);
static void	Smt2ParserFree(pSmt2Parser ctx);
static void     Smt2ParserReset (pSmt2Parser ctx);

/* For use in tree output where we are accumulating rule labels via label += ruleRef
 * we need a function that knows how to free a return scope when the list is destroyed.
 * We cannot just use ANTLR3_FREE because in debug tracking mode, this is a macro.
 */
static	void ANTLR3_CDECL freeScope(void * scope)
{
    ANTLR3_FREE(scope);
}

/** \brief Name of the grammar file that generated this code
 */
static const char fileName[] = "/home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g";

/** \brief Return the name of the grammar file that generated this code.
 */
static const char * getGrammarFileName()
{
	return fileName;
}
/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNew   (pANTLR3_COMMON_TOKEN_STREAM instream)
{
	// See if we can create a new parser with the standard constructor
	//
	return Smt2ParserNewSSD(instream, NULL);
}

/** \brief Create a new Smt2Parser parser and return a context for it.
 *
 * \param[in] instream Pointer to an input stream interface.
 *
 * \return Pointer to new parser context upon success.
 */
ANTLR3_API pSmt2Parser
Smt2ParserNewSSD   (pANTLR3_COMMON_TOKEN_STREAM instream, pANTLR3_RECOGNIZER_SHARED_STATE state)
{
    pSmt2Parser ctx;	    /* Context structure we will build and return   */

    ctx	= (pSmt2Parser) ANTLR3_CALLOC(1, sizeof(Smt2Parser));

    if	(ctx == NULL)
    {
		// Failed to allocate memory for parser context
		//
        return  NULL;
    }

    /* -------------------------------------------------------------------
     * Memory for basic structure is allocated, now to fill in
     * the base ANTLR3 structures. We initialize the function pointers
     * for the standard ANTLR3 parser function set, but upon return
     * from here, the programmer may set the pointers to provide custom
     * implementations of each function.
     *
     * We don't use the macros defined in Smt2Parser.h here, in order that you can get a sense
     * of what goes where.
     */

    /* Create a base parser/recognizer, using the supplied token stream
     */
    ctx->pParser	    = antlr3ParserNewStream(ANTLR3_SIZE_HINT, instream->tstream, state);
    /* Install the implementation of our Smt2Parser interface
     */
    ctx->parseExpr	= parseExpr;
    ctx->parseCommand	= parseCommand;
    ctx->command	= command;
    ctx->extendedCommand	= extendedCommand;
    ctx->datatypesDefCommand	= datatypesDefCommand;
    ctx->rewriterulesCommand	= rewriterulesCommand;
    ctx->rewritePropaKind	= rewritePropaKind;
    ctx->pattern	= pattern;
    ctx->simpleSymbolicExprNoKeyword	= simpleSymbolicExprNoKeyword;
    ctx->keyword	= keyword;
    ctx->simpleSymbolicExpr	= simpleSymbolicExpr;
    ctx->symbolicExpr	= symbolicExpr;
    ctx->term	= term;
    ctx->attribute	= attribute;
    ctx->indexedFunctionName	= indexedFunctionName;
    ctx->badIndexedFunctionName	= badIndexedFunctionName;
    ctx->termList	= termList;
    ctx->str	= str;
    ctx->builtinOp	= builtinOp;
    ctx->quantOp	= quantOp;
    ctx->functionName	= functionName;
    ctx->sortList	= sortList;
    ctx->nonemptySortList	= nonemptySortList;
    ctx->sortedVarList	= sortedVarList;
    ctx->sortName	= sortName;
    ctx->sortSymbol	= sortSymbol;
    ctx->symbolList	= symbolList;
    ctx->symbol	= symbol;
    ctx->nonemptyNumeralList	= nonemptyNumeralList;
    ctx->datatypeDef	= datatypeDef;
    ctx->constructorDef	= constructorDef;
    ctx->selector	= selector;
    ctx->synpred1_Smt2	= synpred1_Smt2;
    ctx->free			= Smt2ParserFree;
    ctx->reset			= Smt2ParserReset;
    ctx->getGrammarFileName	= getGrammarFileName;

    /* Install the scope pushing methods.
     */

    /* Install the token table
     */
    PSRSTATE->tokenNames   = Smt2ParserTokenNames;


    /* Return the newly built parser to the caller
     */
    return  ctx;
}

static void
Smt2ParserReset (pSmt2Parser ctx)
{
    RECOGNIZER->reset(RECOGNIZER);
}

/** Free the parser resources
 */
 static void
 Smt2ParserFree(pSmt2Parser ctx)
 {
    /* Free any scope memory
     */

	// Free this parser
	//
    ctx->pParser->free(ctx->pParser);


    ANTLR3_FREE(ctx);

    /* Everything is released, so we can return
     */
    return;
 }

/** Return token names used by this 
parser

 *
 * The returned pointer is used as an index into the token names table (using the token
 * number as the index).
 *
 * \return Pointer to first char * in the table.
 */
static pANTLR3_UINT8    *getTokenNames()
{
        return Smt2ParserTokenNames;
}


/* Declare the bitsets
 */
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_parseExpr119  */
static	ANTLR3_BITWORD FOLLOW_term_in_parseExpr119_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_parseExpr119	= { FOLLOW_term_in_parseExpr119_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseExpr126  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseExpr126_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseExpr126	= { FOLLOW_EOF_in_parseExpr126_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand150  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand150_bits[]	= { ANTLR3_UINT64_LIT(0x1FFE200000000100), ANTLR3_UINT64_LIT(0x7C8046800000FF22) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand150	= { FOLLOW_LPAREN_TOK_in_parseCommand150_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_command_in_parseCommand156  */
static	ANTLR3_BITWORD FOLLOW_command_in_parseCommand156_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_command_in_parseCommand156	= { FOLLOW_command_in_parseCommand156_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand158  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand158_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand158	= { FOLLOW_RPAREN_TOK_in_parseCommand158_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_parseCommand173  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_parseCommand173_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000200000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_parseCommand173	= { FOLLOW_LPAREN_TOK_in_parseCommand173_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INCLUDE_TOK_in_parseCommand175  */
static	ANTLR3_BITWORD FOLLOW_INCLUDE_TOK_in_parseCommand175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000020) };
static  ANTLR3_BITSET_LIST FOLLOW_INCLUDE_TOK_in_parseCommand175	= { FOLLOW_INCLUDE_TOK_in_parseCommand175_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_parseCommand177  */
static	ANTLR3_BITWORD FOLLOW_str_in_parseCommand177_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_parseCommand177	= { FOLLOW_str_in_parseCommand177_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_parseCommand180  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_parseCommand180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_parseCommand180	= { FOLLOW_RPAREN_TOK_in_parseCommand180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_parseCommand193  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_parseCommand193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_parseCommand193	= { FOLLOW_EOF_in_parseCommand193_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_LOGIC_TOK_in_command225  */
static	ANTLR3_BITWORD FOLLOW_SET_LOGIC_TOK_in_command225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_LOGIC_TOK_in_command225	= { FOLLOW_SET_LOGIC_TOK_in_command225_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command227  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command227	= { FOLLOW_symbol_in_command227_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_INFO_TOK_in_command240  */
static	ANTLR3_BITWORD FOLLOW_SET_INFO_TOK_in_command240_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_INFO_TOK_in_command240	= { FOLLOW_SET_INFO_TOK_in_command240_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command242  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command242_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8190), ANTLR3_UINT64_LIT(0xFEFDEEEEFF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command242	= { FOLLOW_KEYWORD_in_command242_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_command244  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_command244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_command244	= { FOLLOW_symbolicExpr_in_command244_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_INFO_TOK_in_command263  */
static	ANTLR3_BITWORD FOLLOW_GET_INFO_TOK_in_command263_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_INFO_TOK_in_command263	= { FOLLOW_GET_INFO_TOK_in_command263_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command265  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command265	= { FOLLOW_KEYWORD_in_command265_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SET_OPTION_TOK_in_command283  */
static	ANTLR3_BITWORD FOLLOW_SET_OPTION_TOK_in_command283_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SET_OPTION_TOK_in_command283	= { FOLLOW_SET_OPTION_TOK_in_command283_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_keyword_in_command285  */
static	ANTLR3_BITWORD FOLLOW_keyword_in_command285_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8190), ANTLR3_UINT64_LIT(0xFEFDEEEEFF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_keyword_in_command285	= { FOLLOW_keyword_in_command285_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_command288  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_command288_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_command288	= { FOLLOW_symbolicExpr_in_command288_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_OPTION_TOK_in_command307  */
static	ANTLR3_BITWORD FOLLOW_GET_OPTION_TOK_in_command307_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_OPTION_TOK_in_command307	= { FOLLOW_GET_OPTION_TOK_in_command307_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_command309  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_command309_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_command309	= { FOLLOW_KEYWORD_in_command309_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORT_TOK_in_command327  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORT_TOK_in_command327_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORT_TOK_in_command327	= { FOLLOW_DECLARE_SORT_TOK_in_command327_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command341  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command341_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command341	= { FOLLOW_symbol_in_command341_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command356  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command356_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command356	= { FOLLOW_INTEGER_LITERAL_in_command356_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_SORT_TOK_in_command374  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_SORT_TOK_in_command374_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_SORT_TOK_in_command374	= { FOLLOW_DEFINE_SORT_TOK_in_command374_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command382  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command382	= { FOLLOW_symbol_in_command382_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command395  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command395_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command395	= { FOLLOW_LPAREN_TOK_in_command395_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolList_in_command397  */
static	ANTLR3_BITWORD FOLLOW_symbolList_in_command397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolList_in_command397	= { FOLLOW_symbolList_in_command397_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command400  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command400_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command400	= { FOLLOW_RPAREN_TOK_in_command400_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command412  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command412_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command412	= { FOLLOW_sortSymbol_in_command412_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUN_TOK_in_command431  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUN_TOK_in_command431_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUN_TOK_in_command431	= { FOLLOW_DECLARE_FUN_TOK_in_command431_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command439  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command439_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command439	= { FOLLOW_symbol_in_command439_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command452  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command452_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command452	= { FOLLOW_LPAREN_TOK_in_command452_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_command454  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_command454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_command454	= { FOLLOW_sortList_in_command454_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command457  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command457	= { FOLLOW_RPAREN_TOK_in_command457_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command463  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command463_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command463	= { FOLLOW_sortSymbol_in_command463_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_FUN_TOK_in_command482  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_FUN_TOK_in_command482_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_FUN_TOK_in_command482	= { FOLLOW_DEFINE_FUN_TOK_in_command482_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command490  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command490	= { FOLLOW_symbol_in_command490_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command503  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command503_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command503	= { FOLLOW_LPAREN_TOK_in_command503_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_command505  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_command505_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_command505	= { FOLLOW_sortedVarList_in_command505_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command508  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command508_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command508	= { FOLLOW_RPAREN_TOK_in_command508_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command514  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command514_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command514	= { FOLLOW_sortSymbol_in_command514_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command527  */
static	ANTLR3_BITWORD FOLLOW_term_in_command527_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command527	= { FOLLOW_term_in_command527_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_CONST_TOK_in_command540  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_CONST_TOK_in_command540_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_CONST_TOK_in_command540	= { FOLLOW_DEFINE_CONST_TOK_in_command540_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_command548  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_command548_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_command548	= { FOLLOW_symbol_in_command548_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_command561  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_command561_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_command561	= { FOLLOW_sortSymbol_in_command561_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command574  */
static	ANTLR3_BITWORD FOLLOW_term_in_command574_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command574	= { FOLLOW_term_in_command574_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_VALUE_TOK_in_command593  */
static	ANTLR3_BITWORD FOLLOW_GET_VALUE_TOK_in_command593_bits[]	= { ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFF0), ANTLR3_UINT64_LIT(0xFFFFFFFFFFFFFFFF), ANTLR3_UINT64_LIT(0x00000001FFFFFFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_VALUE_TOK_in_command593	= { FOLLOW_GET_VALUE_TOK_in_command593_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_command603  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_command603_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_command603	= { FOLLOW_LPAREN_TOK_in_command603_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_command605  */
static	ANTLR3_BITWORD FOLLOW_termList_in_command605_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_command605	= { FOLLOW_termList_in_command605_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_command608  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_command608_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_command608	= { FOLLOW_RPAREN_TOK_in_command608_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_command624  */
static	ANTLR3_BITWORD FOLLOW_set_in_command624_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_command624	= { FOLLOW_set_in_command624_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSIGNMENT_TOK_in_command647  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSIGNMENT_TOK_in_command647_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSIGNMENT_TOK_in_command647	= { FOLLOW_GET_ASSIGNMENT_TOK_in_command647_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ASSERT_TOK_in_command667  */
static	ANTLR3_BITWORD FOLLOW_ASSERT_TOK_in_command667_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_ASSERT_TOK_in_command667	= { FOLLOW_ASSERT_TOK_in_command667_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command675  */
static	ANTLR3_BITWORD FOLLOW_term_in_command675_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command675	= { FOLLOW_term_in_command675_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CHECKSAT_TOK_in_command694  */
static	ANTLR3_BITWORD FOLLOW_CHECKSAT_TOK_in_command694_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008002), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_CHECKSAT_TOK_in_command694	= { FOLLOW_CHECKSAT_TOK_in_command694_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_command704  */
static	ANTLR3_BITWORD FOLLOW_term_in_command704_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_command704	= { FOLLOW_term_in_command704_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_ASSERTIONS_TOK_in_command741  */
static	ANTLR3_BITWORD FOLLOW_GET_ASSERTIONS_TOK_in_command741_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_ASSERTIONS_TOK_in_command741	= { FOLLOW_GET_ASSERTIONS_TOK_in_command741_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_PROOF_TOK_in_command761  */
static	ANTLR3_BITWORD FOLLOW_GET_PROOF_TOK_in_command761_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_PROOF_TOK_in_command761	= { FOLLOW_GET_PROOF_TOK_in_command761_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_UNSAT_CORE_TOK_in_command781  */
static	ANTLR3_BITWORD FOLLOW_GET_UNSAT_CORE_TOK_in_command781_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_UNSAT_CORE_TOK_in_command781	= { FOLLOW_GET_UNSAT_CORE_TOK_in_command781_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PUSH_TOK_in_command801  */
static	ANTLR3_BITWORD FOLLOW_PUSH_TOK_in_command801_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_PUSH_TOK_in_command801	= { FOLLOW_PUSH_TOK_in_command801_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command813  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command813	= { FOLLOW_INTEGER_LITERAL_in_command813_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_POP_TOK_in_command837  */
static	ANTLR3_BITWORD FOLLOW_POP_TOK_in_command837_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_POP_TOK_in_command837	= { FOLLOW_POP_TOK_in_command837_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_command849  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_command849_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_command849	= { FOLLOW_INTEGER_LITERAL_in_command849_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXIT_TOK_in_command873  */
static	ANTLR3_BITWORD FOLLOW_EXIT_TOK_in_command873_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXIT_TOK_in_command873	= { FOLLOW_EXIT_TOK_in_command873_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_extendedCommand_in_command892  */
static	ANTLR3_BITWORD FOLLOW_extendedCommand_in_command892_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_extendedCommand_in_command892	= { FOLLOW_extendedCommand_in_command892_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_command912  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_command912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_command912	= { FOLLOW_SIMPLE_SYMBOL_in_command912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand943  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand943_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand943	= { FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand943_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand945  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand945_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand945	= { FOLLOW_datatypesDefCommand_in_extendedCommand945_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand952  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand952_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand952	= { FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand952_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypesDefCommand_in_extendedCommand954  */
static	ANTLR3_BITWORD FOLLOW_datatypesDefCommand_in_extendedCommand954_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypesDefCommand_in_extendedCommand954	= { FOLLOW_datatypesDefCommand_in_extendedCommand954_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GET_MODEL_TOK_in_extendedCommand967  */
static	ANTLR3_BITWORD FOLLOW_GET_MODEL_TOK_in_extendedCommand967_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GET_MODEL_TOK_in_extendedCommand967	= { FOLLOW_GET_MODEL_TOK_in_extendedCommand967_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ECHO_TOK_in_extendedCommand981  */
static	ANTLR3_BITWORD FOLLOW_ECHO_TOK_in_extendedCommand981_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8192), ANTLR3_UINT64_LIT(0xFEFDEEECFF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_ECHO_TOK_in_extendedCommand981	= { FOLLOW_ECHO_TOK_in_extendedCommand981_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_extendedCommand989  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_extendedCommand989_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_extendedCommand989	= { FOLLOW_simpleSymbolicExpr_in_extendedCommand989_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rewriterulesCommand_in_extendedCommand1018  */
static	ANTLR3_BITWORD FOLLOW_rewriterulesCommand_in_extendedCommand1018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_rewriterulesCommand_in_extendedCommand1018	= { FOLLOW_rewriterulesCommand_in_extendedCommand1018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_CONST_TOK_in_extendedCommand1033  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_CONST_TOK_in_extendedCommand1033_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_CONST_TOK_in_extendedCommand1033	= { FOLLOW_DECLARE_CONST_TOK_in_extendedCommand1033_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand1041  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand1041_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand1041	= { FOLLOW_symbol_in_extendedCommand1041_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_extendedCommand1054  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_extendedCommand1054_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_extendedCommand1054	= { FOLLOW_sortSymbol_in_extendedCommand1054_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand1074  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand1074_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand1074	= { FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand1074_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand1094  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand1094_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand1094	= { FOLLOW_LPAREN_TOK_in_extendedCommand1094_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand1102  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand1102_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand1102	= { FOLLOW_symbol_in_extendedCommand1102_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand1124  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand1124_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand1124	= { FOLLOW_RPAREN_TOK_in_extendedCommand1124_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand1131  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand1131_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand1131	= { FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand1131_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand1145  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand1145_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand1145	= { FOLLOW_LPAREN_TOK_in_extendedCommand1145_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand1153  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand1153_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand1153	= { FOLLOW_LPAREN_TOK_in_extendedCommand1153_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand1155  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand1155_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand1155	= { FOLLOW_symbol_in_extendedCommand1155_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptySortList_in_extendedCommand1172  */
static	ANTLR3_BITWORD FOLLOW_nonemptySortList_in_extendedCommand1172_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptySortList_in_extendedCommand1172	= { FOLLOW_nonemptySortList_in_extendedCommand1172_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand1175  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand1175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand1175	= { FOLLOW_RPAREN_TOK_in_extendedCommand1175_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand1196  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand1196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand1196	= { FOLLOW_RPAREN_TOK_in_extendedCommand1196_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand1203  */
static	ANTLR3_BITWORD FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand1203_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand1203	= { FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand1203_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand1217  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand1217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand1217	= { FOLLOW_LPAREN_TOK_in_extendedCommand1217_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand1225  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand1225_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand1225	= { FOLLOW_LPAREN_TOK_in_extendedCommand1225_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand1227  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand1227_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand1227	= { FOLLOW_symbol_in_extendedCommand1227_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_extendedCommand1244  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_extendedCommand1244_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_extendedCommand1244	= { FOLLOW_sortList_in_extendedCommand1244_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand1247  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand1247_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand1247	= { FOLLOW_RPAREN_TOK_in_extendedCommand1247_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand1268  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand1268_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand1268	= { FOLLOW_RPAREN_TOK_in_extendedCommand1268_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DEFINE_TOK_in_extendedCommand1275  */
static	ANTLR3_BITWORD FOLLOW_DEFINE_TOK_in_extendedCommand1275_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_DEFINE_TOK_in_extendedCommand1275	= { FOLLOW_DEFINE_TOK_in_extendedCommand1275_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand1285  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand1285_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand1285	= { FOLLOW_symbol_in_extendedCommand1285_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand1302  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand1302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand1302	= { FOLLOW_term_in_extendedCommand1302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_extendedCommand1319  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_extendedCommand1319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_extendedCommand1319	= { FOLLOW_LPAREN_TOK_in_extendedCommand1319_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_extendedCommand1327  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_extendedCommand1327_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_extendedCommand1327	= { FOLLOW_symbol_in_extendedCommand1327_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_extendedCommand1344  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_extendedCommand1344_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_extendedCommand1344	= { FOLLOW_sortedVarList_in_extendedCommand1344_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_extendedCommand1347  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_extendedCommand1347_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_extendedCommand1347	= { FOLLOW_RPAREN_TOK_in_extendedCommand1347_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand1363  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand1363_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand1363	= { FOLLOW_term_in_extendedCommand1363_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLIFY_TOK_in_extendedCommand1385  */
static	ANTLR3_BITWORD FOLLOW_SIMPLIFY_TOK_in_extendedCommand1385_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLIFY_TOK_in_extendedCommand1385	= { FOLLOW_SIMPLIFY_TOK_in_extendedCommand1385_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_extendedCommand1393  */
static	ANTLR3_BITWORD FOLLOW_term_in_extendedCommand1393_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_extendedCommand1393	= { FOLLOW_term_in_extendedCommand1393_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand1424  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand1424_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand1424	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand1424_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypesDefCommand1432  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypesDefCommand1432_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypesDefCommand1432	= { FOLLOW_symbol_in_datatypesDefCommand1432_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand1444  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand1444_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand1444	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand1444_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand1448  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand1448_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand1448	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand1448_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypesDefCommand1452  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypesDefCommand1452_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypesDefCommand1452	= { FOLLOW_LPAREN_TOK_in_datatypesDefCommand1452_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_datatypeDef_in_datatypesDefCommand1454  */
static	ANTLR3_BITWORD FOLLOW_datatypeDef_in_datatypesDefCommand1454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_datatypeDef_in_datatypesDefCommand1454	= { FOLLOW_datatypeDef_in_datatypesDefCommand1454_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand1457  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand1457_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand1457	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand1457_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypesDefCommand1462  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypesDefCommand1462_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypesDefCommand1462	= { FOLLOW_RPAREN_TOK_in_datatypesDefCommand1462_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand1491  */
static	ANTLR3_BITWORD FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand1491_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand1491	= { FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand1491_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1497  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1497_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1497	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1497_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_rewriterulesCommand1499  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_rewriterulesCommand1499_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_rewriterulesCommand1499	= { FOLLOW_sortedVarList_in_rewriterulesCommand1499_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1502  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1502	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1502_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1514  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1514	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1514_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_rewriterulesCommand1518  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_rewriterulesCommand1518_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_rewriterulesCommand1518	= { FOLLOW_pattern_in_rewriterulesCommand1518_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1526  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1526_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1526	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1526_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1532  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1532_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2102180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1532	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1532_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand1535  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand1535_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand1535	= { FOLLOW_termList_in_rewriterulesCommand1535_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1540  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1540_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1540	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1540_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand1546  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand1546_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand1546	= { FOLLOW_term_in_rewriterulesCommand1546_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand1549  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand1549_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand1549	= { FOLLOW_term_in_rewriterulesCommand1549_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_rewritePropaKind_in_rewriterulesCommand1568  */
static	ANTLR3_BITWORD FOLLOW_rewritePropaKind_in_rewriterulesCommand1568_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_rewritePropaKind_in_rewriterulesCommand1568	= { FOLLOW_rewritePropaKind_in_rewriterulesCommand1568_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1575  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1575	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1575_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_rewriterulesCommand1577  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_rewriterulesCommand1577_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_rewriterulesCommand1577	= { FOLLOW_sortedVarList_in_rewriterulesCommand1577_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1580  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1580_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1580	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1580_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1592  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1592_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1592	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1592_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_pattern_in_rewriterulesCommand1596  */
static	ANTLR3_BITWORD FOLLOW_pattern_in_rewriterulesCommand1596_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_pattern_in_rewriterulesCommand1596	= { FOLLOW_pattern_in_rewriterulesCommand1596_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1604  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1604_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1604	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1604_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1610  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1610_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2102180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1610	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1610_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand1613  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand1613_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand1613	= { FOLLOW_termList_in_rewriterulesCommand1613_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1618  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1618_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1618	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1618_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_rewriterulesCommand1624  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_rewriterulesCommand1624_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2102180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_rewriterulesCommand1624	= { FOLLOW_LPAREN_TOK_in_rewriterulesCommand1624_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_rewriterulesCommand1627  */
static	ANTLR3_BITWORD FOLLOW_termList_in_rewriterulesCommand1627_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_rewriterulesCommand1627	= { FOLLOW_termList_in_rewriterulesCommand1627_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_rewriterulesCommand1632  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_rewriterulesCommand1632_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_rewriterulesCommand1632	= { FOLLOW_RPAREN_TOK_in_rewriterulesCommand1632_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_rewriterulesCommand1638  */
static	ANTLR3_BITWORD FOLLOW_term_in_rewriterulesCommand1638_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_rewriterulesCommand1638	= { FOLLOW_term_in_rewriterulesCommand1638_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind1661  */
static	ANTLR3_BITWORD FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind1661_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind1661	= { FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind1661_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind1672  */
static	ANTLR3_BITWORD FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind1672_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind1672	= { FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind1672_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_pattern1694  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_pattern1694_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_pattern1694	= { FOLLOW_LPAREN_TOK_in_pattern1694_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_pattern1696  */
static	ANTLR3_BITWORD FOLLOW_termList_in_pattern1696_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_pattern1696	= { FOLLOW_termList_in_pattern1696_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_pattern1699  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_pattern1699_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_pattern1699	= { FOLLOW_RPAREN_TOK_in_pattern1699_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword1724  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword1724_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword1724	= { FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword1724_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword1736  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword1736_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword1736	= { FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword1736_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword1748  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword1748_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword1748	= { FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword1748_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword1760  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword1760_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword1760	= { FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword1760_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_simpleSymbolicExprNoKeyword1772  */
static	ANTLR3_BITWORD FOLLOW_str_in_simpleSymbolicExprNoKeyword1772_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_simpleSymbolicExprNoKeyword1772	= { FOLLOW_str_in_simpleSymbolicExprNoKeyword1772_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_simpleSymbolicExprNoKeyword1792  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_simpleSymbolicExprNoKeyword1792_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_simpleSymbolicExprNoKeyword1792	= { FOLLOW_symbol_in_simpleSymbolicExprNoKeyword1792_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_set_in_simpleSymbolicExprNoKeyword1807  */
static	ANTLR3_BITWORD FOLLOW_set_in_simpleSymbolicExprNoKeyword1807_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_set_in_simpleSymbolicExprNoKeyword1807	= { FOLLOW_set_in_simpleSymbolicExprNoKeyword1807_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword1921  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword1921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword1921	= { FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword1921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_keyword1942  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_keyword1942_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_keyword1942	= { FOLLOW_KEYWORD_in_keyword1942_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr1962  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr1962_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr1962	= { FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr1962_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_simpleSymbolicExpr1969  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_simpleSymbolicExpr1969_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_simpleSymbolicExpr1969	= { FOLLOW_KEYWORD_in_simpleSymbolicExpr1969_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExpr_in_symbolicExpr1994  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExpr_in_symbolicExpr1994_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExpr_in_symbolicExpr1994	= { FOLLOW_simpleSymbolicExpr_in_symbolicExpr1994_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_symbolicExpr2001  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_symbolicExpr2001_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8190), ANTLR3_UINT64_LIT(0xFFFDEEEEFF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_symbolicExpr2001	= { FOLLOW_LPAREN_TOK_in_symbolicExpr2001_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_symbolicExpr2009  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_symbolicExpr2009_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8190), ANTLR3_UINT64_LIT(0xFFFDEEEEFF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_symbolicExpr2009	= { FOLLOW_symbolicExpr_in_symbolicExpr2009_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_symbolicExpr2017  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_symbolicExpr2017_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_symbolicExpr2017	= { FOLLOW_RPAREN_TOK_in_symbolicExpr2017_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2050  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2050_bits[]	= { ANTLR3_UINT64_LIT(0x40009FFFFFFF0090), ANTLR3_UINT64_LIT(0x827DA06CDE130049), ANTLR3_UINT64_LIT(0x000000000267FFDF) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2050	= { FOLLOW_LPAREN_TOK_in_term2050_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_builtinOp_in_term2052  */
static	ANTLR3_BITWORD FOLLOW_builtinOp_in_term2052_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_builtinOp_in_term2052	= { FOLLOW_builtinOp_in_term2052_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_term2055  */
static	ANTLR3_BITWORD FOLLOW_termList_in_term2055_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_term2055	= { FOLLOW_termList_in_term2055_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2058  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2058_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2058	= { FOLLOW_RPAREN_TOK_in_term2058_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2070  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2070_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000200) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2070	= { FOLLOW_LPAREN_TOK_in_term2070_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AS_TOK_in_term2072  */
static	ANTLR3_BITWORD FOLLOW_AS_TOK_in_term2072_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_AS_TOK_in_term2072	= { FOLLOW_AS_TOK_in_term2072_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term2074  */
static	ANTLR3_BITWORD FOLLOW_term_in_term2074_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term2074	= { FOLLOW_term_in_term2074_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_term2077  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_term2077_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_term2077	= { FOLLOW_sortSymbol_in_term2077_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2080  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2080_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2080	= { FOLLOW_RPAREN_TOK_in_term2080_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2092  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2092_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000090) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2092	= { FOLLOW_LPAREN_TOK_in_term2092_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_quantOp_in_term2094  */
static	ANTLR3_BITWORD FOLLOW_quantOp_in_term2094_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_quantOp_in_term2094	= { FOLLOW_quantOp_in_term2094_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2101  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2101_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2101	= { FOLLOW_LPAREN_TOK_in_term2101_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortedVarList_in_term2103  */
static	ANTLR3_BITWORD FOLLOW_sortedVarList_in_term2103_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortedVarList_in_term2103	= { FOLLOW_sortedVarList_in_term2103_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2106  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2106_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2106	= { FOLLOW_RPAREN_TOK_in_term2106_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term2118  */
static	ANTLR3_BITWORD FOLLOW_term_in_term2118_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term2118	= { FOLLOW_term_in_term2118_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2121  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2121_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2121	= { FOLLOW_RPAREN_TOK_in_term2121_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2133  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2133_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2133	= { FOLLOW_LPAREN_TOK_in_term2133_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_functionName_in_term2135  */
static	ANTLR3_BITWORD FOLLOW_functionName_in_term2135_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_functionName_in_term2135	= { FOLLOW_functionName_in_term2135_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_term2148  */
static	ANTLR3_BITWORD FOLLOW_termList_in_term2148_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_term2148	= { FOLLOW_termList_in_term2148_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2151  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2151_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2151	= { FOLLOW_RPAREN_TOK_in_term2151_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2170  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2170_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2170	= { FOLLOW_LPAREN_TOK_in_term2170_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_indexedFunctionName_in_term2172  */
static	ANTLR3_BITWORD FOLLOW_indexedFunctionName_in_term2172_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_indexedFunctionName_in_term2172	= { FOLLOW_indexedFunctionName_in_term2172_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_termList_in_term2175  */
static	ANTLR3_BITWORD FOLLOW_termList_in_term2175_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_termList_in_term2175	= { FOLLOW_termList_in_term2175_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2178  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2178_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2178	= { FOLLOW_RPAREN_TOK_in_term2178_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2196  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2196_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000100000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2196	= { FOLLOW_LPAREN_TOK_in_term2196_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LET_TOK_in_term2198  */
static	ANTLR3_BITWORD FOLLOW_LET_TOK_in_term2198_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LET_TOK_in_term2198	= { FOLLOW_LET_TOK_in_term2198_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2200  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2200	= { FOLLOW_LPAREN_TOK_in_term2200_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2214  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2214_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2214	= { FOLLOW_LPAREN_TOK_in_term2214_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term2216  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term2216_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term2216	= { FOLLOW_symbol_in_term2216_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term2219  */
static	ANTLR3_BITWORD FOLLOW_term_in_term2219_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term2219	= { FOLLOW_term_in_term2219_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2222  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2222_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2222	= { FOLLOW_RPAREN_TOK_in_term2222_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2259  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2259_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2259	= { FOLLOW_RPAREN_TOK_in_term2259_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term2265  */
static	ANTLR3_BITWORD FOLLOW_term_in_term2265_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term2265	= { FOLLOW_term_in_term2265_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2272  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2272	= { FOLLOW_RPAREN_TOK_in_term2272_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_term2291  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_term2291_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_term2291	= { FOLLOW_symbol_in_term2291_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2311  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2311_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000002000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2311	= { FOLLOW_LPAREN_TOK_in_term2311_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_TOK_in_term2313  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_TOK_in_term2313_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_TOK_in_term2313	= { FOLLOW_ATTRIBUTE_TOK_in_term2313_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_term2315  */
static	ANTLR3_BITWORD FOLLOW_term_in_term2315_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001C00), ANTLR3_UINT64_LIT(0x0000000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_term2315	= { FOLLOW_term_in_term2315_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_attribute_in_term2324  */
static	ANTLR3_BITWORD FOLLOW_attribute_in_term2324_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000001C00), ANTLR3_UINT64_LIT(0x0100000020000000) };
static  ANTLR3_BITSET_LIST FOLLOW_attribute_in_term2324	= { FOLLOW_attribute_in_term2324_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2342  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2342_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2342	= { FOLLOW_RPAREN_TOK_in_term2342_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term2360  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term2360_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term2360	= { FOLLOW_INTEGER_LITERAL_in_term2360_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DECIMAL_LITERAL_in_term2373  */
static	ANTLR3_BITWORD FOLLOW_DECIMAL_LITERAL_in_term2373_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DECIMAL_LITERAL_in_term2373	= { FOLLOW_DECIMAL_LITERAL_in_term2373_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_term2386  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_term2386_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_term2386	= { FOLLOW_LPAREN_TOK_in_term2386_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_term2388  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_term2388_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_term2388	= { FOLLOW_INDEX_TOK_in_term2388_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_term2392  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_term2392_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_term2392	= { FOLLOW_SIMPLE_SYMBOL_in_term2392_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_term2396  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_term2396_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_term2396	= { FOLLOW_INTEGER_LITERAL_in_term2396_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_term2398  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_term2398_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_term2398	= { FOLLOW_RPAREN_TOK_in_term2398_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_HEX_LITERAL_in_term2411  */
static	ANTLR3_BITWORD FOLLOW_HEX_LITERAL_in_term2411_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_HEX_LITERAL_in_term2411	= { FOLLOW_HEX_LITERAL_in_term2411_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BINARY_LITERAL_in_term2424  */
static	ANTLR3_BITWORD FOLLOW_BINARY_LITERAL_in_term2424_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BINARY_LITERAL_in_term2424	= { FOLLOW_BINARY_LITERAL_in_term2424_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_str_in_term2437  */
static	ANTLR3_BITWORD FOLLOW_str_in_term2437_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_str_in_term2437	= { FOLLOW_str_in_term2437_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RENOSTR_TOK_in_term2451  */
static	ANTLR3_BITWORD FOLLOW_RENOSTR_TOK_in_term2451_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RENOSTR_TOK_in_term2451	= { FOLLOW_RENOSTR_TOK_in_term2451_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REALLCHAR_TOK_in_term2464  */
static	ANTLR3_BITWORD FOLLOW_REALLCHAR_TOK_in_term2464_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REALLCHAR_TOK_in_term2464	= { FOLLOW_REALLCHAR_TOK_in_term2464_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EMPTYSET_TOK_in_term2477  */
static	ANTLR3_BITWORD FOLLOW_EMPTYSET_TOK_in_term2477_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EMPTYSET_TOK_in_term2477	= { FOLLOW_EMPTYSET_TOK_in_term2477_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_KEYWORD_in_attribute2510  */
static	ANTLR3_BITWORD FOLLOW_KEYWORD_in_attribute2510_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8192), ANTLR3_UINT64_LIT(0xFEFDEEECDF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_KEYWORD_in_attribute2510	= { FOLLOW_KEYWORD_in_attribute2510_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_simpleSymbolicExprNoKeyword_in_attribute2514  */
static	ANTLR3_BITWORD FOLLOW_simpleSymbolicExprNoKeyword_in_attribute2514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_simpleSymbolicExprNoKeyword_in_attribute2514	= { FOLLOW_simpleSymbolicExprNoKeyword_in_attribute2514_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute2530  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute2530_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute2530	= { FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute2530_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_attribute2532  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_attribute2532_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_attribute2532	= { FOLLOW_LPAREN_TOK_in_attribute2532_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute2536  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute2536_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2102180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute2536	= { FOLLOW_term_in_attribute2536_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_attribute2545  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_attribute2545_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_attribute2545	= { FOLLOW_RPAREN_TOK_in_attribute2545_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute2557  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute2557_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute2557	= { FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute2557_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_attribute2559  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_attribute2559_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_attribute2559	= { FOLLOW_LPAREN_TOK_in_attribute2559_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_attribute2561  */
static	ANTLR3_BITWORD FOLLOW_term_in_attribute2561_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008000), ANTLR3_UINT64_LIT(0x2102180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_attribute2561	= { FOLLOW_term_in_attribute2561_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_attribute2565  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_attribute2565_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_attribute2565	= { FOLLOW_RPAREN_TOK_in_attribute2565_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute2577  */
static	ANTLR3_BITWORD FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute2577_bits[]	= { ANTLR3_UINT64_LIT(0x4D29BFFFFFFF8190), ANTLR3_UINT64_LIT(0xFEFDEEEEFF1BFF6B), ANTLR3_UINT64_LIT(0x0000000012E7FFFF) };
static  ANTLR3_BITSET_LIST FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute2577	= { FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute2577_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbolicExpr_in_attribute2579  */
static	ANTLR3_BITWORD FOLLOW_symbolicExpr_in_attribute2579_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbolicExpr_in_attribute2579	= { FOLLOW_symbolicExpr_in_attribute2579_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_indexedFunctionName2602  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_indexedFunctionName2602_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_indexedFunctionName2602	= { FOLLOW_LPAREN_TOK_in_indexedFunctionName2602_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_indexedFunctionName2604  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_indexedFunctionName2604_bits[]	= { ANTLR3_UINT64_LIT(0x8000000000000000), ANTLR3_UINT64_LIT(0x2000080000800000), ANTLR3_UINT64_LIT(0x00000001F8800000) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_indexedFunctionName2604	= { FOLLOW_INDEX_TOK_in_indexedFunctionName2604_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_155_in_indexedFunctionName2612  */
static	ANTLR3_BITWORD FOLLOW_155_in_indexedFunctionName2612_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_155_in_indexedFunctionName2612	= { FOLLOW_155_in_indexedFunctionName2612_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2616  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2616_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2616	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2616_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2620  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2620_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2620	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2620_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_156_in_indexedFunctionName2642  */
static	ANTLR3_BITWORD FOLLOW_156_in_indexedFunctionName2642_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_156_in_indexedFunctionName2642	= { FOLLOW_156_in_indexedFunctionName2642_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2646  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2646	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2646_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_160_in_indexedFunctionName2662  */
static	ANTLR3_BITWORD FOLLOW_160_in_indexedFunctionName2662_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_160_in_indexedFunctionName2662	= { FOLLOW_160_in_indexedFunctionName2662_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2666  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2666_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2666	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2666_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_159_in_indexedFunctionName2682  */
static	ANTLR3_BITWORD FOLLOW_159_in_indexedFunctionName2682_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_159_in_indexedFunctionName2682	= { FOLLOW_159_in_indexedFunctionName2682_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2686  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2686_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2686	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2686_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_157_in_indexedFunctionName2702  */
static	ANTLR3_BITWORD FOLLOW_157_in_indexedFunctionName2702_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_157_in_indexedFunctionName2702	= { FOLLOW_157_in_indexedFunctionName2702_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2706  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2706_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2706	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2706_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_158_in_indexedFunctionName2722  */
static	ANTLR3_BITWORD FOLLOW_158_in_indexedFunctionName2722_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_158_in_indexedFunctionName2722	= { FOLLOW_158_in_indexedFunctionName2722_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2726  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2726_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2726	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2726_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName2742  */
static	ANTLR3_BITWORD FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName2742_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName2742	= { FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName2742_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2746  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2746_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2746	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2746_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INT2BV_TOK_in_indexedFunctionName2762  */
static	ANTLR3_BITWORD FOLLOW_INT2BV_TOK_in_indexedFunctionName2762_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INT2BV_TOK_in_indexedFunctionName2762	= { FOLLOW_INT2BV_TOK_in_indexedFunctionName2762_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2766  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2766_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2766	= { FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2766_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_badIndexedFunctionName_in_indexedFunctionName2782  */
static	ANTLR3_BITWORD FOLLOW_badIndexedFunctionName_in_indexedFunctionName2782_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_badIndexedFunctionName_in_indexedFunctionName2782	= { FOLLOW_badIndexedFunctionName_in_indexedFunctionName2782_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_indexedFunctionName2793  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_indexedFunctionName2793_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_indexedFunctionName2793	= { FOLLOW_RPAREN_TOK_in_indexedFunctionName2793_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_badIndexedFunctionName2813  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_badIndexedFunctionName2813_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_badIndexedFunctionName2813	= { FOLLOW_symbol_in_badIndexedFunctionName2813_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_badIndexedFunctionName2816  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_badIndexedFunctionName2816_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_badIndexedFunctionName2816	= { FOLLOW_INTEGER_LITERAL_in_badIndexedFunctionName2816_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_term_in_termList2850  */
static	ANTLR3_BITWORD FOLLOW_term_in_termList2850_bits[]	= { ANTLR3_UINT64_LIT(0x0001000000008002), ANTLR3_UINT64_LIT(0x2002180201080004), ANTLR3_UINT64_LIT(0x0000000010800020) };
static  ANTLR3_BITSET_LIST FOLLOW_term_in_termList2850	= { FOLLOW_term_in_termList2850_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRING_LITERAL_in_str2872  */
static	ANTLR3_BITWORD FOLLOW_STRING_LITERAL_in_str2872_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRING_LITERAL_in_str2872	= { FOLLOW_STRING_LITERAL_in_str2872_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_NOT_TOK_in_builtinOp2899  */
static	ANTLR3_BITWORD FOLLOW_NOT_TOK_in_builtinOp2899_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_NOT_TOK_in_builtinOp2899	= { FOLLOW_NOT_TOK_in_builtinOp2899_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IMPLIES_TOK_in_builtinOp2912  */
static	ANTLR3_BITWORD FOLLOW_IMPLIES_TOK_in_builtinOp2912_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IMPLIES_TOK_in_builtinOp2912	= { FOLLOW_IMPLIES_TOK_in_builtinOp2912_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_AND_TOK_in_builtinOp2921  */
static	ANTLR3_BITWORD FOLLOW_AND_TOK_in_builtinOp2921_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_AND_TOK_in_builtinOp2921	= { FOLLOW_AND_TOK_in_builtinOp2921_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_OR_TOK_in_builtinOp2934  */
static	ANTLR3_BITWORD FOLLOW_OR_TOK_in_builtinOp2934_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_OR_TOK_in_builtinOp2934	= { FOLLOW_OR_TOK_in_builtinOp2934_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_XOR_TOK_in_builtinOp2948  */
static	ANTLR3_BITWORD FOLLOW_XOR_TOK_in_builtinOp2948_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_XOR_TOK_in_builtinOp2948	= { FOLLOW_XOR_TOK_in_builtinOp2948_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EQUAL_TOK_in_builtinOp2961  */
static	ANTLR3_BITWORD FOLLOW_EQUAL_TOK_in_builtinOp2961_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EQUAL_TOK_in_builtinOp2961	= { FOLLOW_EQUAL_TOK_in_builtinOp2961_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DISTINCT_TOK_in_builtinOp2972  */
static	ANTLR3_BITWORD FOLLOW_DISTINCT_TOK_in_builtinOp2972_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DISTINCT_TOK_in_builtinOp2972	= { FOLLOW_DISTINCT_TOK_in_builtinOp2972_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ITE_TOK_in_builtinOp2980  */
static	ANTLR3_BITWORD FOLLOW_ITE_TOK_in_builtinOp2980_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ITE_TOK_in_builtinOp2980	= { FOLLOW_ITE_TOK_in_builtinOp2980_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_THAN_TOK_in_builtinOp2993  */
static	ANTLR3_BITWORD FOLLOW_GREATER_THAN_TOK_in_builtinOp2993_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_THAN_TOK_in_builtinOp2993	= { FOLLOW_GREATER_THAN_TOK_in_builtinOp2993_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp3018  */
static	ANTLR3_BITWORD FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp3018_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp3018	= { FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp3018_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp3043  */
static	ANTLR3_BITWORD FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp3043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp3043	= { FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp3043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LESS_THAN_TOK_in_builtinOp3068  */
static	ANTLR3_BITWORD FOLLOW_LESS_THAN_TOK_in_builtinOp3068_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_LESS_THAN_TOK_in_builtinOp3068	= { FOLLOW_LESS_THAN_TOK_in_builtinOp3068_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_PLUS_TOK_in_builtinOp3093  */
static	ANTLR3_BITWORD FOLLOW_PLUS_TOK_in_builtinOp3093_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_PLUS_TOK_in_builtinOp3093	= { FOLLOW_PLUS_TOK_in_builtinOp3093_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_MINUS_TOK_in_builtinOp3105  */
static	ANTLR3_BITWORD FOLLOW_MINUS_TOK_in_builtinOp3105_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_MINUS_TOK_in_builtinOp3105	= { FOLLOW_MINUS_TOK_in_builtinOp3105_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STAR_TOK_in_builtinOp3116  */
static	ANTLR3_BITWORD FOLLOW_STAR_TOK_in_builtinOp3116_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STAR_TOK_in_builtinOp3116	= { FOLLOW_STAR_TOK_in_builtinOp3116_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_DIV_TOK_in_builtinOp3128  */
static	ANTLR3_BITWORD FOLLOW_DIV_TOK_in_builtinOp3128_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_DIV_TOK_in_builtinOp3128	= { FOLLOW_DIV_TOK_in_builtinOp3128_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTS_DIV_TOK_in_builtinOp3141  */
static	ANTLR3_BITWORD FOLLOW_INTS_DIV_TOK_in_builtinOp3141_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTS_DIV_TOK_in_builtinOp3141	= { FOLLOW_INTS_DIV_TOK_in_builtinOp3141_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTS_MOD_TOK_in_builtinOp3154  */
static	ANTLR3_BITWORD FOLLOW_INTS_MOD_TOK_in_builtinOp3154_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTS_MOD_TOK_in_builtinOp3154	= { FOLLOW_INTS_MOD_TOK_in_builtinOp3154_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_ABS_TOK_in_builtinOp3167  */
static	ANTLR3_BITWORD FOLLOW_ABS_TOK_in_builtinOp3167_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_ABS_TOK_in_builtinOp3167	= { FOLLOW_ABS_TOK_in_builtinOp3167_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_IS_INT_TOK_in_builtinOp3180  */
static	ANTLR3_BITWORD FOLLOW_IS_INT_TOK_in_builtinOp3180_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_IS_INT_TOK_in_builtinOp3180	= { FOLLOW_IS_INT_TOK_in_builtinOp3180_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TO_INT_TOK_in_builtinOp3190  */
static	ANTLR3_BITWORD FOLLOW_TO_INT_TOK_in_builtinOp3190_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TO_INT_TOK_in_builtinOp3190	= { FOLLOW_TO_INT_TOK_in_builtinOp3190_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_TO_REAL_TOK_in_builtinOp3200  */
static	ANTLR3_BITWORD FOLLOW_TO_REAL_TOK_in_builtinOp3200_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_TO_REAL_TOK_in_builtinOp3200	= { FOLLOW_TO_REAL_TOK_in_builtinOp3200_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SELECT_TOK_in_builtinOp3210  */
static	ANTLR3_BITWORD FOLLOW_SELECT_TOK_in_builtinOp3210_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SELECT_TOK_in_builtinOp3210	= { FOLLOW_SELECT_TOK_in_builtinOp3210_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STORE_TOK_in_builtinOp3220  */
static	ANTLR3_BITWORD FOLLOW_STORE_TOK_in_builtinOp3220_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STORE_TOK_in_builtinOp3220	= { FOLLOW_STORE_TOK_in_builtinOp3220_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_CONCAT_TOK_in_builtinOp3232  */
static	ANTLR3_BITWORD FOLLOW_CONCAT_TOK_in_builtinOp3232_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_CONCAT_TOK_in_builtinOp3232	= { FOLLOW_CONCAT_TOK_in_builtinOp3232_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNOT_TOK_in_builtinOp3242  */
static	ANTLR3_BITWORD FOLLOW_BVNOT_TOK_in_builtinOp3242_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNOT_TOK_in_builtinOp3242	= { FOLLOW_BVNOT_TOK_in_builtinOp3242_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVAND_TOK_in_builtinOp3252  */
static	ANTLR3_BITWORD FOLLOW_BVAND_TOK_in_builtinOp3252_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVAND_TOK_in_builtinOp3252	= { FOLLOW_BVAND_TOK_in_builtinOp3252_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVOR_TOK_in_builtinOp3262  */
static	ANTLR3_BITWORD FOLLOW_BVOR_TOK_in_builtinOp3262_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVOR_TOK_in_builtinOp3262	= { FOLLOW_BVOR_TOK_in_builtinOp3262_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNEG_TOK_in_builtinOp3272  */
static	ANTLR3_BITWORD FOLLOW_BVNEG_TOK_in_builtinOp3272_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNEG_TOK_in_builtinOp3272	= { FOLLOW_BVNEG_TOK_in_builtinOp3272_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVADD_TOK_in_builtinOp3282  */
static	ANTLR3_BITWORD FOLLOW_BVADD_TOK_in_builtinOp3282_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVADD_TOK_in_builtinOp3282	= { FOLLOW_BVADD_TOK_in_builtinOp3282_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVMUL_TOK_in_builtinOp3292  */
static	ANTLR3_BITWORD FOLLOW_BVMUL_TOK_in_builtinOp3292_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVMUL_TOK_in_builtinOp3292	= { FOLLOW_BVMUL_TOK_in_builtinOp3292_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUDIV_TOK_in_builtinOp3302  */
static	ANTLR3_BITWORD FOLLOW_BVUDIV_TOK_in_builtinOp3302_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUDIV_TOK_in_builtinOp3302	= { FOLLOW_BVUDIV_TOK_in_builtinOp3302_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUREM_TOK_in_builtinOp3312  */
static	ANTLR3_BITWORD FOLLOW_BVUREM_TOK_in_builtinOp3312_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUREM_TOK_in_builtinOp3312	= { FOLLOW_BVUREM_TOK_in_builtinOp3312_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSHL_TOK_in_builtinOp3322  */
static	ANTLR3_BITWORD FOLLOW_BVSHL_TOK_in_builtinOp3322_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSHL_TOK_in_builtinOp3322	= { FOLLOW_BVSHL_TOK_in_builtinOp3322_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVLSHR_TOK_in_builtinOp3334  */
static	ANTLR3_BITWORD FOLLOW_BVLSHR_TOK_in_builtinOp3334_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVLSHR_TOK_in_builtinOp3334	= { FOLLOW_BVLSHR_TOK_in_builtinOp3334_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVULT_TOK_in_builtinOp3346  */
static	ANTLR3_BITWORD FOLLOW_BVULT_TOK_in_builtinOp3346_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVULT_TOK_in_builtinOp3346	= { FOLLOW_BVULT_TOK_in_builtinOp3346_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNAND_TOK_in_builtinOp3358  */
static	ANTLR3_BITWORD FOLLOW_BVNAND_TOK_in_builtinOp3358_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNAND_TOK_in_builtinOp3358	= { FOLLOW_BVNAND_TOK_in_builtinOp3358_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVNOR_TOK_in_builtinOp3370  */
static	ANTLR3_BITWORD FOLLOW_BVNOR_TOK_in_builtinOp3370_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVNOR_TOK_in_builtinOp3370	= { FOLLOW_BVNOR_TOK_in_builtinOp3370_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXOR_TOK_in_builtinOp3382  */
static	ANTLR3_BITWORD FOLLOW_BVXOR_TOK_in_builtinOp3382_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXOR_TOK_in_builtinOp3382	= { FOLLOW_BVXOR_TOK_in_builtinOp3382_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVXNOR_TOK_in_builtinOp3394  */
static	ANTLR3_BITWORD FOLLOW_BVXNOR_TOK_in_builtinOp3394_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVXNOR_TOK_in_builtinOp3394	= { FOLLOW_BVXNOR_TOK_in_builtinOp3394_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVCOMP_TOK_in_builtinOp3406  */
static	ANTLR3_BITWORD FOLLOW_BVCOMP_TOK_in_builtinOp3406_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVCOMP_TOK_in_builtinOp3406	= { FOLLOW_BVCOMP_TOK_in_builtinOp3406_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSUB_TOK_in_builtinOp3418  */
static	ANTLR3_BITWORD FOLLOW_BVSUB_TOK_in_builtinOp3418_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSUB_TOK_in_builtinOp3418	= { FOLLOW_BVSUB_TOK_in_builtinOp3418_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSDIV_TOK_in_builtinOp3430  */
static	ANTLR3_BITWORD FOLLOW_BVSDIV_TOK_in_builtinOp3430_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSDIV_TOK_in_builtinOp3430	= { FOLLOW_BVSDIV_TOK_in_builtinOp3430_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSREM_TOK_in_builtinOp3442  */
static	ANTLR3_BITWORD FOLLOW_BVSREM_TOK_in_builtinOp3442_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSREM_TOK_in_builtinOp3442	= { FOLLOW_BVSREM_TOK_in_builtinOp3442_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSMOD_TOK_in_builtinOp3454  */
static	ANTLR3_BITWORD FOLLOW_BVSMOD_TOK_in_builtinOp3454_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSMOD_TOK_in_builtinOp3454	= { FOLLOW_BVSMOD_TOK_in_builtinOp3454_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVASHR_TOK_in_builtinOp3466  */
static	ANTLR3_BITWORD FOLLOW_BVASHR_TOK_in_builtinOp3466_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVASHR_TOK_in_builtinOp3466	= { FOLLOW_BVASHR_TOK_in_builtinOp3466_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVULE_TOK_in_builtinOp3478  */
static	ANTLR3_BITWORD FOLLOW_BVULE_TOK_in_builtinOp3478_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVULE_TOK_in_builtinOp3478	= { FOLLOW_BVULE_TOK_in_builtinOp3478_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUGT_TOK_in_builtinOp3490  */
static	ANTLR3_BITWORD FOLLOW_BVUGT_TOK_in_builtinOp3490_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUGT_TOK_in_builtinOp3490	= { FOLLOW_BVUGT_TOK_in_builtinOp3490_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVUGE_TOK_in_builtinOp3502  */
static	ANTLR3_BITWORD FOLLOW_BVUGE_TOK_in_builtinOp3502_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVUGE_TOK_in_builtinOp3502	= { FOLLOW_BVUGE_TOK_in_builtinOp3502_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLT_TOK_in_builtinOp3514  */
static	ANTLR3_BITWORD FOLLOW_BVSLT_TOK_in_builtinOp3514_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLT_TOK_in_builtinOp3514	= { FOLLOW_BVSLT_TOK_in_builtinOp3514_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSLE_TOK_in_builtinOp3526  */
static	ANTLR3_BITWORD FOLLOW_BVSLE_TOK_in_builtinOp3526_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSLE_TOK_in_builtinOp3526	= { FOLLOW_BVSLE_TOK_in_builtinOp3526_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGT_TOK_in_builtinOp3538  */
static	ANTLR3_BITWORD FOLLOW_BVSGT_TOK_in_builtinOp3538_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGT_TOK_in_builtinOp3538	= { FOLLOW_BVSGT_TOK_in_builtinOp3538_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BVSGE_TOK_in_builtinOp3550  */
static	ANTLR3_BITWORD FOLLOW_BVSGE_TOK_in_builtinOp3550_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BVSGE_TOK_in_builtinOp3550	= { FOLLOW_BVSGE_TOK_in_builtinOp3550_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_BV2NAT_TOK_in_builtinOp3563  */
static	ANTLR3_BITWORD FOLLOW_BV2NAT_TOK_in_builtinOp3563_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_BV2NAT_TOK_in_builtinOp3563	= { FOLLOW_BV2NAT_TOK_in_builtinOp3563_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRCON_TOK_in_builtinOp3575  */
static	ANTLR3_BITWORD FOLLOW_STRCON_TOK_in_builtinOp3575_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRCON_TOK_in_builtinOp3575	= { FOLLOW_STRCON_TOK_in_builtinOp3575_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRLEN_TOK_in_builtinOp3587  */
static	ANTLR3_BITWORD FOLLOW_STRLEN_TOK_in_builtinOp3587_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRLEN_TOK_in_builtinOp3587	= { FOLLOW_STRLEN_TOK_in_builtinOp3587_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRSUB_TOK_in_builtinOp3599  */
static	ANTLR3_BITWORD FOLLOW_STRSUB_TOK_in_builtinOp3599_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRSUB_TOK_in_builtinOp3599	= { FOLLOW_STRSUB_TOK_in_builtinOp3599_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRCTN_TOK_in_builtinOp3611  */
static	ANTLR3_BITWORD FOLLOW_STRCTN_TOK_in_builtinOp3611_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRCTN_TOK_in_builtinOp3611	= { FOLLOW_STRCTN_TOK_in_builtinOp3611_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRCAT_TOK_in_builtinOp3623  */
static	ANTLR3_BITWORD FOLLOW_STRCAT_TOK_in_builtinOp3623_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRCAT_TOK_in_builtinOp3623	= { FOLLOW_STRCAT_TOK_in_builtinOp3623_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRIDOF_TOK_in_builtinOp3635  */
static	ANTLR3_BITWORD FOLLOW_STRIDOF_TOK_in_builtinOp3635_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRIDOF_TOK_in_builtinOp3635	= { FOLLOW_STRIDOF_TOK_in_builtinOp3635_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRREPL_TOK_in_builtinOp3646  */
static	ANTLR3_BITWORD FOLLOW_STRREPL_TOK_in_builtinOp3646_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRREPL_TOK_in_builtinOp3646	= { FOLLOW_STRREPL_TOK_in_builtinOp3646_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRPREF_TOK_in_builtinOp3657  */
static	ANTLR3_BITWORD FOLLOW_STRPREF_TOK_in_builtinOp3657_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRPREF_TOK_in_builtinOp3657	= { FOLLOW_STRPREF_TOK_in_builtinOp3657_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRSUFF_TOK_in_builtinOp3668  */
static	ANTLR3_BITWORD FOLLOW_STRSUFF_TOK_in_builtinOp3668_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRSUFF_TOK_in_builtinOp3668	= { FOLLOW_STRSUFF_TOK_in_builtinOp3668_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRITOS_TOK_in_builtinOp3679  */
static	ANTLR3_BITWORD FOLLOW_STRITOS_TOK_in_builtinOp3679_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRITOS_TOK_in_builtinOp3679	= { FOLLOW_STRITOS_TOK_in_builtinOp3679_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRSTOI_TOK_in_builtinOp3690  */
static	ANTLR3_BITWORD FOLLOW_STRSTOI_TOK_in_builtinOp3690_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRSTOI_TOK_in_builtinOp3690	= { FOLLOW_STRSTOI_TOK_in_builtinOp3690_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRU16TOS_TOK_in_builtinOp3701  */
static	ANTLR3_BITWORD FOLLOW_STRU16TOS_TOK_in_builtinOp3701_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRU16TOS_TOK_in_builtinOp3701	= { FOLLOW_STRU16TOS_TOK_in_builtinOp3701_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRSTOU16_TOK_in_builtinOp3712  */
static	ANTLR3_BITWORD FOLLOW_STRSTOU16_TOK_in_builtinOp3712_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRSTOU16_TOK_in_builtinOp3712	= { FOLLOW_STRSTOU16_TOK_in_builtinOp3712_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRU32TOS_TOK_in_builtinOp3723  */
static	ANTLR3_BITWORD FOLLOW_STRU32TOS_TOK_in_builtinOp3723_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRU32TOS_TOK_in_builtinOp3723	= { FOLLOW_STRU32TOS_TOK_in_builtinOp3723_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRSTOU32_TOK_in_builtinOp3734  */
static	ANTLR3_BITWORD FOLLOW_STRSTOU32_TOK_in_builtinOp3734_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRSTOU32_TOK_in_builtinOp3734	= { FOLLOW_STRSTOU32_TOK_in_builtinOp3734_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRINRE_TOK_in_builtinOp3745  */
static	ANTLR3_BITWORD FOLLOW_STRINRE_TOK_in_builtinOp3745_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRINRE_TOK_in_builtinOp3745	= { FOLLOW_STRINRE_TOK_in_builtinOp3745_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_STRTORE_TOK_in_builtinOp3756  */
static	ANTLR3_BITWORD FOLLOW_STRTORE_TOK_in_builtinOp3756_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_STRTORE_TOK_in_builtinOp3756	= { FOLLOW_STRTORE_TOK_in_builtinOp3756_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RECON_TOK_in_builtinOp3767  */
static	ANTLR3_BITWORD FOLLOW_RECON_TOK_in_builtinOp3767_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RECON_TOK_in_builtinOp3767	= { FOLLOW_RECON_TOK_in_builtinOp3767_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REUNION_TOK_in_builtinOp3780  */
static	ANTLR3_BITWORD FOLLOW_REUNION_TOK_in_builtinOp3780_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REUNION_TOK_in_builtinOp3780	= { FOLLOW_REUNION_TOK_in_builtinOp3780_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REINTER_TOK_in_builtinOp3791  */
static	ANTLR3_BITWORD FOLLOW_REINTER_TOK_in_builtinOp3791_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REINTER_TOK_in_builtinOp3791	= { FOLLOW_REINTER_TOK_in_builtinOp3791_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RESTAR_TOK_in_builtinOp3802  */
static	ANTLR3_BITWORD FOLLOW_RESTAR_TOK_in_builtinOp3802_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RESTAR_TOK_in_builtinOp3802	= { FOLLOW_RESTAR_TOK_in_builtinOp3802_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REPLUS_TOK_in_builtinOp3814  */
static	ANTLR3_BITWORD FOLLOW_REPLUS_TOK_in_builtinOp3814_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REPLUS_TOK_in_builtinOp3814	= { FOLLOW_REPLUS_TOK_in_builtinOp3814_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_REOPT_TOK_in_builtinOp3826  */
static	ANTLR3_BITWORD FOLLOW_REOPT_TOK_in_builtinOp3826_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_REOPT_TOK_in_builtinOp3826	= { FOLLOW_REOPT_TOK_in_builtinOp3826_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RERANGE_TOK_in_builtinOp3839  */
static	ANTLR3_BITWORD FOLLOW_RERANGE_TOK_in_builtinOp3839_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RERANGE_TOK_in_builtinOp3839	= { FOLLOW_RERANGE_TOK_in_builtinOp3839_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RELOOP_TOK_in_builtinOp3850  */
static	ANTLR3_BITWORD FOLLOW_RELOOP_TOK_in_builtinOp3850_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RELOOP_TOK_in_builtinOp3850	= { FOLLOW_RELOOP_TOK_in_builtinOp3850_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FMFCARD_TOK_in_builtinOp3864  */
static	ANTLR3_BITWORD FOLLOW_FMFCARD_TOK_in_builtinOp3864_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FMFCARD_TOK_in_builtinOp3864	= { FOLLOW_FMFCARD_TOK_in_builtinOp3864_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EXISTS_TOK_in_quantOp3892  */
static	ANTLR3_BITWORD FOLLOW_EXISTS_TOK_in_quantOp3892_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EXISTS_TOK_in_quantOp3892	= { FOLLOW_EXISTS_TOK_in_quantOp3892_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_FORALL_TOK_in_quantOp3903  */
static	ANTLR3_BITWORD FOLLOW_FORALL_TOK_in_quantOp3903_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_FORALL_TOK_in_quantOp3903	= { FOLLOW_FORALL_TOK_in_quantOp3903_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_functionName3924  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_functionName3924_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_functionName3924	= { FOLLOW_symbol_in_functionName3924_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortList3948  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortList3948_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortList3948	= { FOLLOW_sortSymbol_in_sortList3948_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_nonemptySortList3975  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_nonemptySortList3975_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_nonemptySortList3975	= { FOLLOW_sortSymbol_in_nonemptySortList3975_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortedVarList4004  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortedVarList4004_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortedVarList4004	= { FOLLOW_LPAREN_TOK_in_sortedVarList4004_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortedVarList4006  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortedVarList4006_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortedVarList4006	= { FOLLOW_symbol_in_sortedVarList4006_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_sortedVarList4009  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_sortedVarList4009_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_sortedVarList4009	= { FOLLOW_sortSymbol_in_sortedVarList4009_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortedVarList4012  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortedVarList4012_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortedVarList4012	= { FOLLOW_RPAREN_TOK_in_sortedVarList4012_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortName4043  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortName4043_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortName4043	= { FOLLOW_symbol_in_sortName4043_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortName_in_sortSymbol4063  */
static	ANTLR3_BITWORD FOLLOW_sortName_in_sortSymbol4063_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortName_in_sortSymbol4063	= { FOLLOW_sortName_in_sortSymbol4063_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol4076  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol4076_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000400000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol4076	= { FOLLOW_LPAREN_TOK_in_sortSymbol4076_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INDEX_TOK_in_sortSymbol4078  */
static	ANTLR3_BITWORD FOLLOW_INDEX_TOK_in_sortSymbol4078_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_INDEX_TOK_in_sortSymbol4078	= { FOLLOW_INDEX_TOK_in_sortSymbol4078_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortSymbol4080  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortSymbol4080_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortSymbol4080	= { FOLLOW_symbol_in_sortSymbol4080_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_nonemptyNumeralList_in_sortSymbol4083  */
static	ANTLR3_BITWORD FOLLOW_nonemptyNumeralList_in_sortSymbol4083_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_nonemptyNumeralList_in_sortSymbol4083	= { FOLLOW_nonemptyNumeralList_in_sortSymbol4083_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol4086  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol4086_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol4086	= { FOLLOW_RPAREN_TOK_in_sortSymbol4086_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_sortSymbol4098  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_sortSymbol4098_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_sortSymbol4098	= { FOLLOW_LPAREN_TOK_in_sortSymbol4098_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_sortSymbol4100  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_sortSymbol4100_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2100080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_sortSymbol4100	= { FOLLOW_symbol_in_sortSymbol4100_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortList_in_sortSymbol4103  */
static	ANTLR3_BITWORD FOLLOW_sortList_in_sortSymbol4103_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_sortList_in_sortSymbol4103	= { FOLLOW_sortList_in_sortSymbol4103_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_sortSymbol4106  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_sortSymbol4106_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_sortSymbol4106	= { FOLLOW_RPAREN_TOK_in_sortSymbol4106_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_symbolList4135  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_symbolList4135_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_symbolList4135	= { FOLLOW_symbol_in_symbolList4135_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_SIMPLE_SYMBOL_in_symbol4157  */
static	ANTLR3_BITWORD FOLLOW_SIMPLE_SYMBOL_in_symbol4157_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_SIMPLE_SYMBOL_in_symbol4157	= { FOLLOW_SIMPLE_SYMBOL_in_symbol4157_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_156_in_symbol4169  */
static	ANTLR3_BITWORD FOLLOW_156_in_symbol4169_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_156_in_symbol4169	= { FOLLOW_156_in_symbol4169_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_QUOTED_SYMBOL_in_symbol4181  */
static	ANTLR3_BITWORD FOLLOW_QUOTED_SYMBOL_in_symbol4181_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_QUOTED_SYMBOL_in_symbol4181	= { FOLLOW_QUOTED_SYMBOL_in_symbol4181_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol4193  */
static	ANTLR3_BITWORD FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol4193_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000004000000) };
static  ANTLR3_BITSET_LIST FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol4193	= { FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol4193_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_EOF_in_symbol4201  */
static	ANTLR3_BITWORD FOLLOW_EOF_in_symbol4201_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_EOF_in_symbol4201	= { FOLLOW_EOF_in_symbol4201_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_154_in_symbol4217  */
static	ANTLR3_BITWORD FOLLOW_154_in_symbol4217_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_154_in_symbol4217	= { FOLLOW_154_in_symbol4217_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList4249  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList4249_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList4249	= { FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList4249_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_datatypeDef4291  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_datatypeDef4291_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_datatypeDef4291	= { FOLLOW_symbol_in_datatypeDef4291_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_datatypeDef4314  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_datatypeDef4314_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_datatypeDef4314	= { FOLLOW_LPAREN_TOK_in_datatypeDef4314_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_constructorDef_in_datatypeDef4316  */
static	ANTLR3_BITWORD FOLLOW_constructorDef_in_datatypeDef4316_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_constructorDef_in_datatypeDef4316	= { FOLLOW_constructorDef_in_datatypeDef4316_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_datatypeDef4319  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_datatypeDef4319_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_datatypeDef4319	= { FOLLOW_RPAREN_TOK_in_datatypeDef4319_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_constructorDef4349  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_constructorDef4349_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_constructorDef4349	= { FOLLOW_symbol_in_constructorDef4349_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_LPAREN_TOK_in_constructorDef4364  */
static	ANTLR3_BITWORD FOLLOW_LPAREN_TOK_in_constructorDef4364_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080000000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_LPAREN_TOK_in_constructorDef4364	= { FOLLOW_LPAREN_TOK_in_constructorDef4364_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_selector_in_constructorDef4366  */
static	ANTLR3_BITWORD FOLLOW_selector_in_constructorDef4366_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0100000000000000) };
static  ANTLR3_BITSET_LIST FOLLOW_selector_in_constructorDef4366	= { FOLLOW_selector_in_constructorDef4366_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_RPAREN_TOK_in_constructorDef4369  */
static	ANTLR3_BITWORD FOLLOW_RPAREN_TOK_in_constructorDef4369_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002), ANTLR3_UINT64_LIT(0x0000000200000000) };
static  ANTLR3_BITSET_LIST FOLLOW_RPAREN_TOK_in_constructorDef4369	= { FOLLOW_RPAREN_TOK_in_constructorDef4369_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_symbol_in_selector4397  */
static	ANTLR3_BITWORD FOLLOW_symbol_in_selector4397_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x2000080200000000), ANTLR3_UINT64_LIT(0x0000000010800000) };
static  ANTLR3_BITSET_LIST FOLLOW_symbol_in_selector4397	= { FOLLOW_symbol_in_selector4397_bits, 3	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_sortSymbol_in_selector4400  */
static	ANTLR3_BITWORD FOLLOW_sortSymbol_in_selector4400_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_sortSymbol_in_selector4400	= { FOLLOW_sortSymbol_in_selector4400_bits, 1	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_156_in_synpred1_Smt22637  */
static	ANTLR3_BITWORD FOLLOW_156_in_synpred1_Smt22637_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000000), ANTLR3_UINT64_LIT(0x0000000001000000) };
static  ANTLR3_BITSET_LIST FOLLOW_156_in_synpred1_Smt22637	= { FOLLOW_156_in_synpred1_Smt22637_bits, 2	};
/** Bitset defining follow set for error recovery in rule state: FOLLOW_INTEGER_LITERAL_in_synpred1_Smt22639  */
static	ANTLR3_BITWORD FOLLOW_INTEGER_LITERAL_in_synpred1_Smt22639_bits[]	= { ANTLR3_UINT64_LIT(0x0000000000000002) };
static  ANTLR3_BITSET_LIST FOLLOW_INTEGER_LITERAL_in_synpred1_Smt22639	= { FOLLOW_INTEGER_LITERAL_in_synpred1_Smt22639_bits, 1	};


/* ==============================================
 * Parsing rules
 */
/**
 * $ANTLR start parseExpr
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:178:1: parseExpr returns [CVC4::parser::smt2::myExpr expr] : ( term[expr, expr2] | EOF );
 */
static CVC4::parser::smt2::myExpr
parseExpr(pSmt2Parser ctx)
{
    CVC4::parser::smt2::myExpr expr;



      Expr expr2;

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:182:3: ( term[expr, expr2] | EOF )

            ANTLR3_UINT32 alt1;

            alt1=2;

            switch ( LA(1) )
            {
            case BINARY_LITERAL:
            case DECIMAL_LITERAL:
            case EMPTYSET_TOK:
            case HEX_LITERAL:
            case INTEGER_LITERAL:
            case LPAREN_TOK:
            case QUOTED_SYMBOL:
            case REALLCHAR_TOK:
            case RENOSTR_TOK:
            case SIMPLE_SYMBOL:
            case STRING_LITERAL:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 156:
            	{
            		alt1=1;
            	}
                break;
            case EOF:
            	{
            		alt1=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return expr;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 1;
                EXCEPTION->state        = 0;


                goto ruleparseExprEx;

            }

            switch (alt1)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:182:5: term[expr, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_term_in_parseExpr119);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:183:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseExpr126);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return expr;
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseExprEx; /* Prevent compiler warnings */
    ruleparseExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return expr;
}
/* $ANTLR end parseExpr */

/**
 * $ANTLR start parseCommand
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:190:1: parseCommand returns [CVC4::Command* cmd = NULL] : ( LPAREN_TOK c= command RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF );
 */
static CVC4::Command*
parseCommand(pSmt2Parser ctx)
{
    CVC4::Command* cmd;



      std::string name;

    CVC4::Command* c;
    #undef	RETURN_TYPE_c
    #define	RETURN_TYPE_c CVC4::Command*

    /* Initialize rule variables
     */
    cmd =  NULL;


    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:194:3: ( LPAREN_TOK c= command RPAREN_TOK | LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK | EOF )

            ANTLR3_UINT32 alt2;

            alt2=3;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INCLUDE_TOK:
            			{
            				alt2=2;
            			}
            		    break;
            		case ASSERT_TOK:
            		case CHECKSAT_TOK:
            		case DECLARE_CODATATYPES_TOK:
            		case DECLARE_CONST_TOK:
            		case DECLARE_DATATYPES_TOK:
            		case DECLARE_FUNS_TOK:
            		case DECLARE_FUN_TOK:
            		case DECLARE_PREDS_TOK:
            		case DECLARE_SORTS_TOK:
            		case DECLARE_SORT_TOK:
            		case DEFINE_CONST_TOK:
            		case DEFINE_FUN_TOK:
            		case DEFINE_SORT_TOK:
            		case DEFINE_TOK:
            		case ECHO_TOK:
            		case EXIT_TOK:
            		case GET_ASSERTIONS_TOK:
            		case GET_ASSIGNMENT_TOK:
            		case GET_INFO_TOK:
            		case GET_MODEL_TOK:
            		case GET_OPTION_TOK:
            		case GET_PROOF_TOK:
            		case GET_UNSAT_CORE_TOK:
            		case GET_VALUE_TOK:
            		case POP_TOK:
            		case PROPAGATION_RULE_TOK:
            		case PUSH_TOK:
            		case REDUCTION_RULE_TOK:
            		case REWRITE_RULE_TOK:
            		case SET_INFO_TOK:
            		case SET_LOGIC_TOK:
            		case SET_OPTION_TOK:
            		case SIMPLE_SYMBOL:
            		case SIMPLIFY_TOK:
            			{
            				alt2=1;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return cmd;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 2;
            		    EXCEPTION->state        = 1;


            		    goto ruleparseCommandEx;

            		}

            	}
                break;
            case EOF:
            	{
            		alt2=3;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return cmd;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 2;
                EXCEPTION->state        = 0;


                goto ruleparseCommandEx;

            }

            switch (alt2)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:194:5: LPAREN_TOK c= command RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand150);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_command_in_parseCommand156);
        	        c=command(ctx);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand158);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= c;
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:199:5: LPAREN_TOK INCLUDE_TOK str[name,true] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_parseCommand173);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	         MATCHT(INCLUDE_TOK, &FOLLOW_INCLUDE_TOK_in_parseCommand175);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_str_in_parseCommand177);
        	        str(ctx, name, true);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_parseCommand180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(!PARSER_STATE->canIncludeFile()) {
        	                    PARSER_STATE->parseError("include-file feature was disabled for this run.");
        	                  }
        	                  if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("Extended commands are not permitted while operating in strict compliance mode.");
        	                  }
        	                  PARSER_STATE->includeFile(name);
        	                  // The command of the included file will be produced at the next parseCommand() call
        	                  cmd = new EmptyCommand("include::" + name);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:211:5: EOF
        	    {
        	         MATCHT(EOF, &FOLLOW_EOF_in_parseCommand193);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleparseCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= 0;
        	             
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleparseCommandEx; /* Prevent compiler warnings */
    ruleparseCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return cmd;
}
/* $ANTLR end parseCommand */

/**
 * $ANTLR start command
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:218:1: command returns [CVC4::Command* cmd = NULL] : ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK KEYWORD symbolicExpr[sexpr] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK keyword[name] symbolicExpr[sexpr] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECKSAT_TOK ( term[expr, expr2] |) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | extendedCommand[cmd] | SIMPLE_SYMBOL );
 */
static CVC4::Command*
command(pSmt2Parser ctx)
{
    CVC4::Command* cmd;



      std::string name;
      std::vector<std::string> names;
      Expr expr, expr2;
      Type t;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<std::pair<std::string, Type> > sortedVarNames;
      SExpr sexpr;

    pANTLR3_COMMON_TOKEN    n;
    pANTLR3_COMMON_TOKEN    k;
    pANTLR3_COMMON_TOKEN    KEYWORD1;
    pANTLR3_COMMON_TOKEN    KEYWORD2;
    pANTLR3_COMMON_TOKEN    KEYWORD3;
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL4;

    /* Initialize rule variables
     */
    cmd =  NULL;


    n       = NULL;
    k       = NULL;
    KEYWORD1       = NULL;
    KEYWORD2       = NULL;
    KEYWORD3       = NULL;
    SIMPLE_SYMBOL4       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:229:3: ( SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT] | SET_INFO_TOK KEYWORD symbolicExpr[sexpr] | GET_INFO_TOK KEYWORD | SET_OPTION_TOK keyword[name] symbolicExpr[sexpr] | GET_OPTION_TOK KEYWORD | DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL | DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DECLARE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] | DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[expr, expr2] | GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK ) | GET_ASSIGNMENT_TOK | ASSERT_TOK term[expr, expr2] | CHECKSAT_TOK ( term[expr, expr2] |) | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | PUSH_TOK (k= INTEGER_LITERAL |) | POP_TOK (k= INTEGER_LITERAL |) | EXIT_TOK | extendedCommand[cmd] | SIMPLE_SYMBOL )

            ANTLR3_UINT32 alt7;

            alt7=22;

            switch ( LA(1) )
            {
            case SET_LOGIC_TOK:
            	{
            		alt7=1;
            	}
                break;
            case SET_INFO_TOK:
            	{
            		alt7=2;
            	}
                break;
            case GET_INFO_TOK:
            	{
            		alt7=3;
            	}
                break;
            case SET_OPTION_TOK:
            	{
            		alt7=4;
            	}
                break;
            case GET_OPTION_TOK:
            	{
            		alt7=5;
            	}
                break;
            case DECLARE_SORT_TOK:
            	{
            		alt7=6;
            	}
                break;
            case DEFINE_SORT_TOK:
            	{
            		alt7=7;
            	}
                break;
            case DECLARE_FUN_TOK:
            	{
            		alt7=8;
            	}
                break;
            case DEFINE_FUN_TOK:
            	{
            		alt7=9;
            	}
                break;
            case DEFINE_CONST_TOK:
            	{
            		alt7=10;
            	}
                break;
            case GET_VALUE_TOK:
            	{
            		alt7=11;
            	}
                break;
            case GET_ASSIGNMENT_TOK:
            	{
            		alt7=12;
            	}
                break;
            case ASSERT_TOK:
            	{
            		alt7=13;
            	}
                break;
            case CHECKSAT_TOK:
            	{
            		alt7=14;
            	}
                break;
            case GET_ASSERTIONS_TOK:
            	{
            		alt7=15;
            	}
                break;
            case GET_PROOF_TOK:
            	{
            		alt7=16;
            	}
                break;
            case GET_UNSAT_CORE_TOK:
            	{
            		alt7=17;
            	}
                break;
            case PUSH_TOK:
            	{
            		alt7=18;
            	}
                break;
            case POP_TOK:
            	{
            		alt7=19;
            	}
                break;
            case EXIT_TOK:
            	{
            		alt7=20;
            	}
                break;
            case DECLARE_CODATATYPES_TOK:
            case DECLARE_CONST_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUNS_TOK:
            case DECLARE_PREDS_TOK:
            case DECLARE_SORTS_TOK:
            case DEFINE_TOK:
            case ECHO_TOK:
            case GET_MODEL_TOK:
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt7=21;
            	}
                break;
            case SIMPLE_SYMBOL:
            	{
            		alt7=22;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return cmd;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 7;
                EXCEPTION->state        = 0;


                goto rulecommandEx;

            }

            switch (alt7)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:230:5: SET_LOGIC_TOK symbol[name,CHECK_NONE,SYM_SORT]
        	    {
        	         MATCHT(SET_LOGIC_TOK, &FOLLOW_SET_LOGIC_TOK_in_command225);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command227);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             Debug("parser") << "set logic: '" << name << "'" << std::endl;
        	                  if( PARSER_STATE->logicIsSet() ) {
        	                    PARSER_STATE->parseError("Only one set-logic is allowed.");
        	                  }
        	                  PARSER_STATE->setLogic(name);
        	                  cmd= new SetBenchmarkLogicCommand(name);
        	             
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:237:5: SET_INFO_TOK KEYWORD symbolicExpr[sexpr]
        	    {
        	         MATCHT(SET_INFO_TOK, &FOLLOW_SET_INFO_TOK_in_command240);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        KEYWORD1 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command242);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_command244);
        	        symbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             name = AntlrInput::tokenText(KEYWORD1);
        	                  if(name == ":cvc4-logic" || name == ":cvc4_logic") {
        	                    PARSER_STATE->setLogic(sexpr.getValue());
        	                  }
        	                  PARSER_STATE->setInfo(name.c_str() + 1, sexpr);
        	                  cmd = new SetInfoCommand(name.c_str() + 1, sexpr); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:245:5: GET_INFO_TOK KEYWORD
        	    {
        	         MATCHT(GET_INFO_TOK, &FOLLOW_GET_INFO_TOK_in_command263);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        KEYWORD2 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command265);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetInfoCommand(AntlrInput::tokenText(KEYWORD2).c_str() + 1); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:248:5: SET_OPTION_TOK keyword[name] symbolicExpr[sexpr]
        	    {
        	         MATCHT(SET_OPTION_TOK, &FOLLOW_SET_OPTION_TOK_in_command283);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_keyword_in_command285);
        	        keyword(ctx, name);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_command288);
        	        symbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->setOption(name.c_str() + 1, sexpr);
        	                  cmd = new SetOptionCommand(name.c_str() + 1, sexpr); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:252:5: GET_OPTION_TOK KEYWORD
        	    {
        	         MATCHT(GET_OPTION_TOK, &FOLLOW_GET_OPTION_TOK_in_command307);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        KEYWORD3 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_command309);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetOptionCommand(AntlrInput::tokenText(KEYWORD3).c_str() + 1); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:255:5: DECLARE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] n= INTEGER_LITERAL
        	    {
        	         MATCHT(DECLARE_SORT_TOK, &FOLLOW_DECLARE_SORT_TOK_in_command327);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_DATATYPES) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS)) {
        	                    PARSER_STATE->parseError(std::string("Free sort symbols not allowed in ") + PARSER_STATE->getLogic().getLogicString());
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command341);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command356);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             Debug("parser") << "declare sort: '" << name
        	                                  << "' arity=" << n << std::endl;
        	                  unsigned arity = AntlrInput::tokenToUnsigned(n);
        	                  if(arity == 0) {
        	                    Type type = PARSER_STATE->mkSort(name);
        	                    cmd= new DeclareTypeCommand(name, 0, type);

        	                  } else {
        	                    Type type = PARSER_STATE->mkSortConstructor(name, arity);
        	                    cmd= new DeclareTypeCommand(name, arity, type);

        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:278:5: DEFINE_SORT_TOK symbol[name,CHECK_UNDECLARED,SYM_SORT] LPAREN_TOK symbolList[names,CHECK_NONE,SYM_SORT] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DEFINE_SORT_TOK, &FOLLOW_DEFINE_SORT_TOK_in_command374);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command382);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command395);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolList_in_command397);
        	        symbolList(ctx, names, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command400);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::string>::const_iterator i = names.begin(),
        	                        iend = names.end();
        	                      i != iend;
        	                      ++i) {
        	                    sorts.push_back(PARSER_STATE->mkSort(*i));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command412);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  // Do NOT call mkSort, since that creates a new sort!
        	                  // This name is not its own distinct sort, it's an alias.
        	                  PARSER_STATE->defineParameterizedType(name, sorts, t);
        	                  cmd= new DefineTypeCommand(name, sorts, t);

        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:298:5: DECLARE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortList[sorts] RPAREN_TOK sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_FUN_TOK, &FOLLOW_DECLARE_FUN_TOK_in_command431);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command439);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command452);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_command454);
        	        sortList(ctx, sorts);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command457);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command463);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             Debug("parser") << "declare fun: '" << name << "'" << std::endl;
        	                  if( sorts.size() > 0 ) {
        	                    if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	                      PARSER_STATE->parseError(std::string("Functions (of non-zero arity) cannot be declared in logic ") + PARSER_STATE->getLogic().getLogicString());
        	                    }
        	                    t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	                  }
        	                  Expr func = PARSER_STATE->mkVar(name, t);
        	                  cmd= new DeclareFunctionCommand(name, func, t);
        	             
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:313:5: DEFINE_FUN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_FUN_TOK, &FOLLOW_DEFINE_FUN_TOK_in_command482);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command490);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command503);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_command505);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command508);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command514);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	                  if( sortedVarNames.size() > 0 ) {
        	                    std::vector<CVC4::Type> sorts;
        	                    sorts.reserve(sortedVarNames.size());
        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                          sortedVarNames.begin(), iend = sortedVarNames.end();
        	                        i != iend;
        	                        ++i) {
        	                      sorts.push_back((*i).second);
        	                    }
        	                    t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	                  }
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command527);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  Expr func = PARSER_STATE->mkFunction(name, t, ExprManager::VAR_FLAG_DEFINED);
        	                  cmd= new DefineFunctionCommand(name, func, terms, expr);

        	                
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:347:5: DEFINE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] term[expr, expr2]
        	    {
        	         MATCHT(DEFINE_CONST_TOK, &FOLLOW_DEFINE_CONST_TOK_in_command540);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_command548);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_command561);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             /* add variables to parser state before parsing term */
        	                  Debug("parser") << "define const: '" << name << "'" << std::endl;
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command574);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope();
        	                  // declare the name down here (while parsing term, signature
        	                  // must not be extended with the name itself; no recursion
        	                  // permitted)
        	                  Expr func = PARSER_STATE->mkFunction(name, t, ExprManager::VAR_FLAG_DEFINED);
        	                  cmd= new DefineFunctionCommand(name, func, terms, expr);

        	                
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:370:5: GET_VALUE_TOK ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	    {
        	         MATCHT(GET_VALUE_TOK, &FOLLOW_GET_VALUE_TOK_in_command593);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:371:5: ( LPAREN_TOK termList[terms,expr] RPAREN_TOK |~ LPAREN_TOK )
        	        {
        	            int alt3=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt3=1;
        	            	}
        	                break;
        	            case ABS_TOK:
        	            case ALPHA:
        	            case AMPERSAND_TOK:
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case AS_TOK:
        	            case ATTRIBUTE_NAMED_TOK:
        	            case ATTRIBUTE_NO_PATTERN_TOK:
        	            case ATTRIBUTE_PATTERN_TOK:
        	            case ATTRIBUTE_TOK:
        	            case AT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case BVADD_TOK:
        	            case BVAND_TOK:
        	            case BVASHR_TOK:
        	            case BVCOMP_TOK:
        	            case BVLSHR_TOK:
        	            case BVMUL_TOK:
        	            case BVNAND_TOK:
        	            case BVNEG_TOK:
        	            case BVNOR_TOK:
        	            case BVNOT_TOK:
        	            case BVOR_TOK:
        	            case BVSDIV_TOK:
        	            case BVSGE_TOK:
        	            case BVSGT_TOK:
        	            case BVSHL_TOK:
        	            case BVSLE_TOK:
        	            case BVSLT_TOK:
        	            case BVSMOD_TOK:
        	            case BVSREM_TOK:
        	            case BVSUB_TOK:
        	            case BVUDIV_TOK:
        	            case BVUGE_TOK:
        	            case BVUGT_TOK:
        	            case BVULE_TOK:
        	            case BVULT_TOK:
        	            case BVUREM_TOK:
        	            case BVXNOR_TOK:
        	            case BVXOR_TOK:
        	            case CHECKSAT_TOK:
        	            case COMMENT:
        	            case CONCAT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_CODATATYPES_TOK:
        	            case DECLARE_CONST_TOK:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUNS_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_PREDS_TOK:
        	            case DECLARE_SORTS_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DEFINE_CONST_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DEFINE_TOK:
        	            case DIGIT:
        	            case DISTINCT_TOK:
        	            case DIVISIBLE_TOK:
        	            case DIV_TOK:
        	            case ECHO_TOK:
        	            case EMPTYSET_TOK:
        	            case EQUAL_TOK:
        	            case EXISTS_TOK:
        	            case EXIT_TOK:
        	            case FMFCARD_TOK:
        	            case FORALL_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_DIGIT:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INCLUDE_TOK:
        	            case INDEX_TOK:
        	            case INT2BV_TOK:
        	            case INTEGER_LITERAL:
        	            case INTS_DIV_TOK:
        	            case INTS_MOD_TOK:
        	            case IS_INT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LET_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case NUMERAL:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case POUND_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case RECON_TOK:
        	            case REDUCTION_RULE_TOK:
        	            case REINTER_TOK:
        	            case RELOOP_TOK:
        	            case RENOSTR_TOK:
        	            case REOPT_TOK:
        	            case REPLUS_TOK:
        	            case RERANGE_TOK:
        	            case RESTAR_TOK:
        	            case REUNION_TOK:
        	            case REWRITE_RULE_TOK:
        	            case RPAREN_TOK:
        	            case SELECT_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STORE_TOK:
        	            case STRCAT_TOK:
        	            case STRCON_TOK:
        	            case STRCTN_TOK:
        	            case STRIDOF_TOK:
        	            case STRING_LITERAL:
        	            case STRINRE_TOK:
        	            case STRITOS_TOK:
        	            case STRLEN_TOK:
        	            case STRPREF_TOK:
        	            case STRREPL_TOK:
        	            case STRSTOI_TOK:
        	            case STRSTOU16_TOK:
        	            case STRSTOU32_TOK:
        	            case STRSUB_TOK:
        	            case STRSUFF_TOK:
        	            case STRTORE_TOK:
        	            case STRU16TOS_TOK:
        	            case STRU32TOS_TOK:
        	            case SYMBOL_CHAR:
        	            case SYMBOL_CHAR_NOUNDERSCORE_NOATTRIBUTE:
        	            case TO_INT_TOK:
        	            case TO_REAL_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case WHITESPACE:
        	            case XOR_TOK:
        	            case 154:
        	            case 155:
        	            case 156:
        	            case 157:
        	            case 158:
        	            case 159:
        	            case 160:
        	            	{
        	            		alt3=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return cmd;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 3;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt3)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:371:7: LPAREN_TOK termList[terms,expr] RPAREN_TOK
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_command603);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return cmd;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_termList_in_command605);
        	        	        termList(ctx, terms, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return cmd;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_command608);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return cmd;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd= new GetValueCommand(terms);
        	        	             
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:373:7: ~ LPAREN_TOK
        	        	    {
        	        	        if ( ((LA(1) >= ABS_TOK) && (LA(1) <= LET_TOK)) || ((LA(1) >= MINUS_TOK) && (LA(1) <= 160)) )
        	        	        {
        	        	            CONSUME();
        	        	            PERRORRECOVERY=ANTLR3_FALSE;
        	        	            FAILEDFLAG=ANTLR3_FALSE;

        	        	        }
        	        	        else
        	        	        {
        	        	            if (BACKTRACKING>0)
        	        	            {
        	        	                FAILEDFLAG = ANTLR3_TRUE;
        	        	                return cmd;
        	        	            }

        	        	            CONSTRUCTEX();
        	        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	        	            EXCEPTION->expectingSet = NULL;

        	        	            goto rulecommandEx;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->parseError("The get-value command expects a list of terms.  Perhaps you forgot a pair of parentheses?"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:376:5: GET_ASSIGNMENT_TOK
        	    {
        	         MATCHT(GET_ASSIGNMENT_TOK, &FOLLOW_GET_ASSIGNMENT_TOK_in_command647);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetAssignmentCommand(); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:379:5: ASSERT_TOK term[expr, expr2]
        	    {
        	         MATCHT(ASSERT_TOK, &FOLLOW_ASSERT_TOK_in_command667);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_command675);
        	        term(ctx, expr, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new AssertCommand(expr); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:383:5: CHECKSAT_TOK ( term[expr, expr2] |)
        	    {
        	         MATCHT(CHECKSAT_TOK, &FOLLOW_CHECKSAT_TOK_in_command694);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:384:5: ( term[expr, expr2] |)
        	        {
        	            int alt4=2;
        	            switch ( LA(1) )
        	            {
        	            case BINARY_LITERAL:
        	            case DECIMAL_LITERAL:
        	            case EMPTYSET_TOK:
        	            case HEX_LITERAL:
        	            case INTEGER_LITERAL:
        	            case LPAREN_TOK:
        	            case QUOTED_SYMBOL:
        	            case REALLCHAR_TOK:
        	            case RENOSTR_TOK:
        	            case SIMPLE_SYMBOL:
        	            case STRING_LITERAL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 156:
        	            	{
        	            		alt4=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt4=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return cmd;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 4;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt4)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:384:7: term[expr, expr2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_term_in_command704);
        	        	        term(ctx, expr, expr2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return cmd;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError("Extended commands (such as check-sat with an argument) are not permitted while operating in strict compliance mode.");
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:389:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             expr = MK_CONST(bool(true)); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new CheckSatCommand(expr); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:392:5: GET_ASSERTIONS_TOK
        	    {
        	         MATCHT(GET_ASSERTIONS_TOK, &FOLLOW_GET_ASSERTIONS_TOK_in_command741);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetAssertionsCommand(); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:395:5: GET_PROOF_TOK
        	    {
        	         MATCHT(GET_PROOF_TOK, &FOLLOW_GET_PROOF_TOK_in_command761);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetProofCommand(); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:398:5: GET_UNSAT_CORE_TOK
        	    {
        	         MATCHT(GET_UNSAT_CORE_TOK, &FOLLOW_GET_UNSAT_CORE_TOK_in_command781);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetUnsatCoreCommand(); 
        	        }


        	    }
        	    break;
        	case 18:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:401:5: PUSH_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(PUSH_TOK, &FOLLOW_PUSH_TOK_in_command801);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:402:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt5=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt5=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt5=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return cmd;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 5;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt5)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:402:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command813);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return cmd;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             unsigned n = AntlrInput::tokenToUnsigned(k);
        	        	                    if(n == 0) {
        	        	                      cmd = new EmptyCommand();
        	        	                    } else if(n == 1) {
        	        	                      PARSER_STATE->pushScope();
        	        	                      cmd = new PushCommand();
        	        	                    } else {
        	        	                      CommandSequence* seq = new CommandSequence();
        	        	                      do {
        	        	                        PARSER_STATE->pushScope();
        	        	                        Command* c = new PushCommand();
        	        	                        c->setMuted(n > 1);
        	        	                        seq->addCommand(c);
        	        	                      } while(--n > 0);
        	        	                      cmd = seq;
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:420:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError("Strict compliance mode demands an integer to be provided to PUSH.  Maybe you want (push 1)?");
        	        	                    } else {
        	        	                      cmd = new PushCommand();
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 19:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:426:5: POP_TOK (k= INTEGER_LITERAL |)
        	    {
        	         MATCHT(POP_TOK, &FOLLOW_POP_TOK_in_command837);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:427:5: (k= INTEGER_LITERAL |)
        	        {
        	            int alt6=2;
        	            switch ( LA(1) )
        	            {
        	            case INTEGER_LITERAL:
        	            	{
        	            		alt6=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt6=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return cmd;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 6;
        	                EXCEPTION->state        = 0;


        	                goto rulecommandEx;

        	            }

        	            switch (alt6)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:427:7: k= INTEGER_LITERAL
        	        	    {
        	        	        k = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_command849);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulecommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return cmd;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             unsigned n = AntlrInput::tokenToUnsigned(k);
        	        	                    if(n > PARSER_STATE->scopeLevel()) {
        	        	                      PARSER_STATE->parseError("Attempted to pop above the top stack frame.");
        	        	                    }
        	        	                    if(n == 0) {
        	        	                      cmd = new EmptyCommand();
        	        	                    } else if(n == 1) {
        	        	                      PARSER_STATE->popScope();
        	        	                      cmd = new PopCommand();
        	        	                    } else {
        	        	                      CommandSequence* seq = new CommandSequence();
        	        	                      do {
        	        	                        PARSER_STATE->popScope();
        	        	                        Command* c = new PopCommand();
        	        	                        c->setMuted(n > 1);
        	        	                        seq->addCommand(c);
        	        	                      } while(--n > 0);
        	        	                      cmd = seq;
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:448:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             if(PARSER_STATE->strictModeEnabled()) {
        	        	                      PARSER_STATE->parseError("Strict compliance mode demands an integer to be provided to POP.  Maybe you want (pop 1)?");
        	        	                    } else {
        	        	                      cmd = new PopCommand();
        	        	                    }
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 20:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:454:5: EXIT_TOK
        	    {
        	         MATCHT(EXIT_TOK, &FOLLOW_EXIT_TOK_in_command873);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new QuitCommand(); 
        	        }


        	    }
        	    break;
        	case 21:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:458:5: extendedCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_extendedCommand_in_command892);
        	        extendedCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(PARSER_STATE->strictModeEnabled()) {
        	                    PARSER_STATE->parseError("Extended commands are not permitted while operating in strict compliance mode.");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 22:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:465:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL4 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_command912);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulecommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return cmd;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::string id = AntlrInput::tokenText(SIMPLE_SYMBOL4);
        	                  if(id == "benchmark") {
        	                    PARSER_STATE->parseError("In SMT-LIBv2 mode, but got something that looks like SMT-LIBv1.  Use --lang smt1 for SMT-LIBv1.");
        	                  } else {
        	                    PARSER_STATE->parseError("expected SMT-LIBv2 command, got `" + id + "'.");
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulecommandEx; /* Prevent compiler warnings */
    rulecommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return cmd;
}
/* $ANTLR end command */

/**
 * $ANTLR start extendedCommand
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:475:1: extendedCommand[CVC4::Command*& cmd] : ( DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | rewriterulesCommand[cmd] | DECLARE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | SIMPLIFY_TOK term[e,e2] );
 */
static void
extendedCommand(pSmt2Parser ctx, CVC4::Command*& cmd)
{

      std::vector<CVC4::Datatype> dts;
      Type t;
      Expr e, e2;
      SExpr sexpr;
      std::string name;
      std::vector<std::string> names;
      std::vector<Expr> terms;
      std::vector<Type> sorts;
      std::vector<std::pair<std::string, Type> > sortedVarNames;

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:489:3: ( DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd] | DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd] | GET_MODEL_TOK | ECHO_TOK ( simpleSymbolicExpr[sexpr] |) | rewriterulesCommand[cmd] | DECLARE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] | DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK | DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK | DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] ) | SIMPLIFY_TOK term[e,e2] )

            ANTLR3_UINT32 alt13;

            alt13=11;

            switch ( LA(1) )
            {
            case DECLARE_DATATYPES_TOK:
            	{
            		alt13=1;
            	}
                break;
            case DECLARE_CODATATYPES_TOK:
            	{
            		alt13=2;
            	}
                break;
            case GET_MODEL_TOK:
            	{
            		alt13=3;
            	}
                break;
            case ECHO_TOK:
            	{
            		alt13=4;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            	{
            		alt13=5;
            	}
                break;
            case DECLARE_CONST_TOK:
            	{
            		alt13=6;
            	}
                break;
            case DECLARE_SORTS_TOK:
            	{
            		alt13=7;
            	}
                break;
            case DECLARE_FUNS_TOK:
            	{
            		alt13=8;
            	}
                break;
            case DECLARE_PREDS_TOK:
            	{
            		alt13=9;
            	}
                break;
            case DEFINE_TOK:
            	{
            		alt13=10;
            	}
                break;
            case SIMPLIFY_TOK:
            	{
            		alt13=11;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 13;
                EXCEPTION->state        = 0;


                goto ruleextendedCommandEx;

            }

            switch (alt13)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:489:5: DECLARE_DATATYPES_TOK datatypesDefCommand[false, cmd]
        	    {
        	         MATCHT(DECLARE_DATATYPES_TOK, &FOLLOW_DECLARE_DATATYPES_TOK_in_extendedCommand943);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand945);
        	        datatypesDefCommand(ctx, false, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:490:5: DECLARE_CODATATYPES_TOK datatypesDefCommand[true, cmd]
        	    {
        	         MATCHT(DECLARE_CODATATYPES_TOK, &FOLLOW_DECLARE_CODATATYPES_TOK_in_extendedCommand952);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_datatypesDefCommand_in_extendedCommand954);
        	        datatypesDefCommand(ctx, true, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:492:5: GET_MODEL_TOK
        	    {
        	         MATCHT(GET_MODEL_TOK, &FOLLOW_GET_MODEL_TOK_in_extendedCommand967);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new GetModelCommand(); 
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:494:5: ECHO_TOK ( simpleSymbolicExpr[sexpr] |)
        	    {
        	         MATCHT(ECHO_TOK, &FOLLOW_ECHO_TOK_in_extendedCommand981);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:495:5: ( simpleSymbolicExpr[sexpr] |)
        	        {
        	            int alt8=2;
        	            switch ( LA(1) )
        	            {
        	            case ABS_TOK:
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case BVADD_TOK:
        	            case BVAND_TOK:
        	            case BVASHR_TOK:
        	            case BVCOMP_TOK:
        	            case BVLSHR_TOK:
        	            case BVMUL_TOK:
        	            case BVNAND_TOK:
        	            case BVNEG_TOK:
        	            case BVNOR_TOK:
        	            case BVNOT_TOK:
        	            case BVOR_TOK:
        	            case BVSDIV_TOK:
        	            case BVSGE_TOK:
        	            case BVSGT_TOK:
        	            case BVSHL_TOK:
        	            case BVSLE_TOK:
        	            case BVSLT_TOK:
        	            case BVSMOD_TOK:
        	            case BVSREM_TOK:
        	            case BVSUB_TOK:
        	            case BVUDIV_TOK:
        	            case BVUGE_TOK:
        	            case BVUGT_TOK:
        	            case BVULE_TOK:
        	            case BVULT_TOK:
        	            case BVUREM_TOK:
        	            case BVXNOR_TOK:
        	            case BVXOR_TOK:
        	            case CHECKSAT_TOK:
        	            case CONCAT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case ECHO_TOK:
        	            case EQUAL_TOK:
        	            case EXIT_TOK:
        	            case FMFCARD_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INTEGER_LITERAL:
        	            case INTS_DIV_TOK:
        	            case INTS_MOD_TOK:
        	            case IS_INT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RECON_TOK:
        	            case REDUCTION_RULE_TOK:
        	            case REINTER_TOK:
        	            case RELOOP_TOK:
        	            case REOPT_TOK:
        	            case REPLUS_TOK:
        	            case RERANGE_TOK:
        	            case RESTAR_TOK:
        	            case REUNION_TOK:
        	            case REWRITE_RULE_TOK:
        	            case SELECT_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STORE_TOK:
        	            case STRCAT_TOK:
        	            case STRCON_TOK:
        	            case STRCTN_TOK:
        	            case STRIDOF_TOK:
        	            case STRING_LITERAL:
        	            case STRINRE_TOK:
        	            case STRITOS_TOK:
        	            case STRLEN_TOK:
        	            case STRPREF_TOK:
        	            case STRREPL_TOK:
        	            case STRSTOI_TOK:
        	            case STRSTOU16_TOK:
        	            case STRSTOU32_TOK:
        	            case STRSUB_TOK:
        	            case STRSUFF_TOK:
        	            case STRTORE_TOK:
        	            case STRU16TOS_TOK:
        	            case STRU32TOS_TOK:
        	            case TO_INT_TOK:
        	            case TO_REAL_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case XOR_TOK:
        	            case 156:
        	            	{
        	            		alt8=1;
        	            	}
        	                break;
        	            case RPAREN_TOK:
        	            	{
        	            		alt8=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 8;
        	                EXCEPTION->state        = 0;


        	                goto ruleextendedCommandEx;

        	            }

        	            switch (alt8)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:495:7: simpleSymbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_extendedCommand989);
        	        	        simpleSymbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             std::stringstream ss;
        	        	                    ss << sexpr;
        	        	                    cmd = new EchoCommand(ss.str());
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:500:7: 
        	        	    {
        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             cmd = new EchoCommand(); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:502:5: rewriterulesCommand[cmd]
        	    {
        	        FOLLOWPUSH(FOLLOW_rewriterulesCommand_in_extendedCommand1018);
        	        rewriterulesCommand(ctx, cmd);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:506:5: DECLARE_CONST_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED]
        	    {
        	         MATCHT(DECLARE_CONST_TOK, &FOLLOW_DECLARE_CONST_TOK_in_extendedCommand1033);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand1041);
        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkUserSymbol(name); 
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_extendedCommand1054);
        	        sortSymbol(ctx, t, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             Expr c = PARSER_STATE->mkVar(name, t);
        	                  cmd= new DeclareFunctionCommand(name, c, t); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:513:5: DECLARE_SORTS_TOK LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_SORTS_TOK, &FOLLOW_DECLARE_SORTS_TOK_in_extendedCommand1074);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_DATATYPES) &&
        	                     !PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS)) {
        	                    PARSER_STATE->parseError(std::string("Free sort symbols not allowed in ") + PARSER_STATE->getLogic().getLogicString());
        	                  }
        	                
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= new CommandSequence(); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand1094);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:523:5: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )+
        	        {
        	            int cnt9=0;

        	            for (;;)
        	            {
        	                int alt9=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case QUOTED_SYMBOL:
        	        	case SIMPLE_SYMBOL:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 156:
        	        		{
        	        			alt9=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt9)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:523:7: symbol[name,CHECK_UNDECLARED,SYM_SORT]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand1102);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name);
        	        	                        Type type = PARSER_STATE->mkSort(name);
        	        	                        static_cast<CommandSequence*>(cmd)->addCommand(new DeclareTypeCommand(name, 0, type));
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt9 >= 1 )
        	        		{
        	        		    goto loop9;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt9++;
        	            }
        	            loop9: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand1124);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:531:5: DECLARE_FUNS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_FUNS_TOK, &FOLLOW_DECLARE_FUNS_TOK_in_extendedCommand1131);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= new CommandSequence(); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand1145);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:534:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt10=0;

        	            for (;;)
        	            {
        	                int alt10=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt10=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt10)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:534:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] nonemptySortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand1153);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand1155);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_nonemptySortList_in_extendedCommand1172);
        	        	            nonemptySortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand1175);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 Type t;
        	        	                        if(sorts.size() > 1) {
        	        	                          if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	        	                            PARSER_STATE->parseError(std::string("Functions (of non-zero arity) cannot be declared in logic ") + PARSER_STATE->getLogic().getLogicString());
        	        	                          }
        	        	                          t = EXPR_MANAGER->mkFunctionType(sorts);
        	        	                        } else {
        	        	                          t = sorts[0];
        	        	                        }
        	        	                        Expr func = PARSER_STATE->mkVar(name, t);
        	        	                        static_cast<CommandSequence*>(cmd)->addCommand(new DeclareFunctionCommand(name, func, t));
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt10 >= 1 )
        	        		{
        	        		    goto loop10;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt10++;
        	            }
        	            loop10: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand1196);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:552:5: DECLARE_PREDS_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+ RPAREN_TOK
        	    {
        	         MATCHT(DECLARE_PREDS_TOK, &FOLLOW_DECLARE_PREDS_TOK_in_extendedCommand1203);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd= new CommandSequence(); 
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand1217);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:555:5: ( LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK )+
        	        {
        	            int cnt11=0;

        	            for (;;)
        	            {
        	                int alt11=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt11=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt11)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:555:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortList[sorts] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand1225);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand1227);
        	        	            symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 PARSER_STATE->checkUserSymbol(name); 
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_sortList_in_extendedCommand1244);
        	        	            sortList(ctx, sorts);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand1247);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleextendedCommandEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 Type t = EXPR_MANAGER->booleanType();
        	        	                        if(sorts.size() > 0) {
        	        	                          if(!PARSER_STATE->isTheoryEnabled(Smt2::THEORY_UF)) {
        	        	                            PARSER_STATE->parseError(std::string("Predicates (of non-zero arity) cannot be declared in logic ") + PARSER_STATE->getLogic().getLogicString());
        	        	                          }
        	        	                          t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                        }
        	        	                        Expr func = PARSER_STATE->mkVar(name, t);
        	        	                        static_cast<CommandSequence*>(cmd)->addCommand(new DeclareFunctionCommand(name, func, t));
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt11 >= 1 )
        	        		{
        	        		    goto loop11;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleextendedCommandEx;
        	        	}
        	        	cnt11++;
        	            }
        	            loop11: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand1268);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:571:5: DEFINE_TOK ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	    {
        	         MATCHT(DEFINE_TOK, &FOLLOW_DEFINE_TOK_in_extendedCommand1275);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:572:5: ( symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2] | LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2] )
        	        {
        	            int alt12=2;
        	            switch ( LA(1) )
        	            {
        	            case QUOTED_SYMBOL:
        	            case SIMPLE_SYMBOL:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case 156:
        	            	{
        	            		alt12=1;
        	            	}
        	                break;
        	            case LPAREN_TOK:
        	            	{
        	            		alt12=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 12;
        	                EXCEPTION->state        = 0;


        	                goto ruleextendedCommandEx;

        	            }

        	            switch (alt12)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:572:7: symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] term[e,e2]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand1285);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand1302);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             Expr func = PARSER_STATE->mkFunction(name, e.getType(), ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd= new DefineFunctionCommand(name, func, e);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:578:7: LPAREN_TOK symbol[name,CHECK_UNDECLARED,SYM_VARIABLE] sortedVarList[sortedVarNames] RPAREN_TOK term[e,e2]
        	        	    {
        	        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_extendedCommand1319);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_symbol_in_extendedCommand1327);
        	        	        symbol(ctx, name, CHECK_UNDECLARED, SYM_VARIABLE);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->checkUserSymbol(name); 
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_extendedCommand1344);
        	        	        sortedVarList(ctx, sortedVarNames);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_extendedCommand1347);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             /* add variables to parser state before parsing term */
        	        	                    Debug("parser") << "define fun: '" << name << "'" << std::endl;
        	        	                    PARSER_STATE->pushScope(true);
        	        	                    for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	        	                          sortedVarNames.begin(), iend = sortedVarNames.end();
        	        	                        i != iend;
        	        	                        ++i) {
        	        	                      terms.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	        	                    }
        	        	                  
        	        	        }


        	        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand1363);
        	        	        term(ctx, e, e2);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleextendedCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->popScope();
        	        	                    // declare the name down here (while parsing term, signature
        	        	                    // must not be extended with the name itself; no recursion
        	        	                    // permitted)
        	        	                    Type t = e.getType();
        	        	                    if( sortedVarNames.size() > 0 ) {
        	        	                      std::vector<CVC4::Type> sorts;
        	        	                      sorts.reserve(sortedVarNames.size());
        	        	                      for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	        	                            sortedVarNames.begin(), iend = sortedVarNames.end();
        	        	                          i != iend;
        	        	                          ++i) {
        	        	                        sorts.push_back((*i).second);
        	        	                      }
        	        	                      t = EXPR_MANAGER->mkFunctionType(sorts, t);
        	        	                    }
        	        	                    Expr func = PARSER_STATE->mkFunction(name, t, ExprManager::VAR_FLAG_DEFINED);
        	        	                    cmd= new DefineFunctionCommand(name, func, terms, e);
        	        	                  
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:614:5: SIMPLIFY_TOK term[e,e2]
        	    {
        	         MATCHT(SIMPLIFY_TOK, &FOLLOW_SIMPLIFY_TOK_in_extendedCommand1385);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->checkThatLogicIsSet(); 
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_extendedCommand1393);
        	        term(ctx, e, e2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleextendedCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             cmd = new SimplifyCommand(e); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleextendedCommandEx; /* Prevent compiler warnings */
    ruleextendedCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end extendedCommand */

/**
 * $ANTLR start datatypesDefCommand
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:620:1: datatypesDefCommand[bool isCo, CVC4::Command*& cmd] : LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK ;
 */
static void
datatypesDefCommand(pSmt2Parser ctx, bool isCo, CVC4::Command*& cmd)
{

      std::vector<CVC4::Datatype> dts;
      std::string name;
      std::vector<Type> sorts;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:626:3: ( LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:626:5: LPAREN_TOK ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )* RPAREN_TOK LPAREN_TOK ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+ RPAREN_TOK
        {
            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->checkThatLogicIsSet(); 
                    /* open a scope to keep the UnresolvedTypes contained */
                    PARSER_STATE->pushScope(true); 
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand1424);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:630:3: ( symbol[name,CHECK_UNDECLARED,SYM_SORT] )*

            for (;;)
            {
                int alt14=2;
                switch ( LA(1) )
                {
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 156:
                	{
                		alt14=1;
                	}
                    break;

                }

                switch (alt14)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:630:5: symbol[name,CHECK_UNDECLARED,SYM_SORT]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_datatypesDefCommand1432);
            	        symbol(ctx, name, CHECK_UNDECLARED, SYM_SORT);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruledatatypesDefCommandEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {

            	                sorts.push_back( PARSER_STATE->mkSort(name) ); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop14;	/* break out of the loop */
            	    break;
                }
            }
            loop14: ; /* Jump out to here if this rule does not match */


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand1444);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand1448);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:634:14: ( LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK )+
            {
                int cnt15=0;

                for (;;)
                {
                    int alt15=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt15=1;
            		}
            	    break;

            	}

            	switch (alt15)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:634:16: LPAREN_TOK datatypeDef[isCo, dts, sorts] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypesDefCommand1452);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefCommandEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_datatypeDef_in_datatypesDefCommand1454);
            	            datatypeDef(ctx, isCo, dts, sorts);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefCommandEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand1457);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypesDefCommandEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt15 >= 1 )
            		{
            		    goto loop15;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypesDefCommandEx;
            	}
            	cnt15++;
                }
                loop15: ;	/* Jump to here if this rule does not match */
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypesDefCommand1462);
            if  (HASEXCEPTION())
            {
                goto ruledatatypesDefCommandEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->popScope();
                  cmd = new DatatypeDeclarationCommand(PARSER_STATE->mkMutualDatatypeTypes(dts)); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypesDefCommandEx; /* Prevent compiler warnings */
    ruledatatypesDefCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypesDefCommand */

/**
 * $ANTLR start rewriterulesCommand
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:639:1: rewriterulesCommand[CVC4::Command*& cmd] : ( REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2] | rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2] );
 */
static void
rewriterulesCommand(pSmt2Parser ctx, CVC4::Command*& cmd)
{

      std::vector<std::pair<std::string, Type> > sortedVarNames;
      std::vector<Expr> args, guards, heads, triggers;
      Expr head, body, expr, expr2, bvl;
      Kind kind;

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:646:3: ( REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2] | rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2] )

            ANTLR3_UINT32 alt21;

            alt21=2;

            switch ( LA(1) )
            {
            case REWRITE_RULE_TOK:
            	{
            		alt21=1;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            case REDUCTION_RULE_TOK:
            	{
            		alt21=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 21;
                EXCEPTION->state        = 0;


                goto rulerewriterulesCommandEx;

            }

            switch (alt21)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:647:5: REWRITE_RULE_TOK LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK term[head, expr2] term[body, expr2]
        	    {
        	         MATCHT(REWRITE_RULE_TOK, &FOLLOW_REWRITE_RULE_TOK_in_rewriterulesCommand1491);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1497);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_rewriterulesCommand1499);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1502);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  kind = CVC4::kind::RR_REWRITE;
        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1514);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:660:16: ( pattern[expr] )*

        	        for (;;)
        	        {
        	            int alt16=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt16=1;
        	            	}
        	                break;

        	            }

        	            switch (alt16)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:660:18: pattern[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_pattern_in_rewriterulesCommand1518);
        	        	        pattern(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             triggers.push_back( expr ); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop16;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop16: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1526);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1532);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:661:16: ( termList[guards,expr] )?
        	        {
        	            int alt17=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case DECIMAL_LITERAL:
        	                case EMPTYSET_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case LPAREN_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case RENOSTR_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 156:
        	                	{
        	                		alt17=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt17)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:661:17: termList[guards,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand1535);
        	        	        termList(ctx, guards, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1540);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand1546);
        	        term(ctx, head, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand1549);
        	        term(ctx, body, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  args.clear();
        	                  args.push_back(head);
        	                  args.push_back(body);
        	                  /* triggers */
        	                  if( !triggers.empty() ){
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, triggers);
        	                    args.push_back(expr2);
        	                  };
        	                  expr = MK_EXPR(kind, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                  /* guards */
        	                  switch( guards.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(guards[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, guards);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(expr);
        	                  expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                  cmd = new AssertCommand(expr); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:689:5: rewritePropaKind[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK LPAREN_TOK ( pattern[expr] )* RPAREN_TOK LPAREN_TOK ( termList[guards,expr] )? RPAREN_TOK LPAREN_TOK ( termList[heads,expr] )? RPAREN_TOK term[body, expr2]
        	    {
        	        FOLLOWPUSH(FOLLOW_rewritePropaKind_in_rewriterulesCommand1568);
        	        rewritePropaKind(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1575);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_rewriterulesCommand1577);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1580);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1592);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:701:16: ( pattern[expr] )*

        	        for (;;)
        	        {
        	            int alt18=2;
        	            switch ( LA(1) )
        	            {
        	            case LPAREN_TOK:
        	            	{
        	            		alt18=1;
        	            	}
        	                break;

        	            }

        	            switch (alt18)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:701:18: pattern[expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_pattern_in_rewriterulesCommand1596);
        	        	        pattern(ctx, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             triggers.push_back( expr ); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop18;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop18: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1604);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1610);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:702:16: ( termList[guards,expr] )?
        	        {
        	            int alt19=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case DECIMAL_LITERAL:
        	                case EMPTYSET_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case LPAREN_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case RENOSTR_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 156:
        	                	{
        	                		alt19=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt19)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:702:17: termList[guards,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand1613);
        	        	        termList(ctx, guards, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1618);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_rewriterulesCommand1624);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:703:16: ( termList[heads,expr] )?
        	        {
        	            int alt20=2;
        	            switch ( LA(1) )
        	            {
        	                case BINARY_LITERAL:
        	                case DECIMAL_LITERAL:
        	                case EMPTYSET_TOK:
        	                case HEX_LITERAL:
        	                case INTEGER_LITERAL:
        	                case LPAREN_TOK:
        	                case QUOTED_SYMBOL:
        	                case REALLCHAR_TOK:
        	                case RENOSTR_TOK:
        	                case SIMPLE_SYMBOL:
        	                case STRING_LITERAL:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case 156:
        	                	{
        	                		alt20=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt20)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:703:17: termList[heads,expr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_termList_in_rewriterulesCommand1627);
        	        	        termList(ctx, heads, expr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulerewriterulesCommandEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_rewriterulesCommand1632);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_rewriterulesCommand1638);
        	        term(ctx, body, expr2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewriterulesCommandEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  args.clear();
        	                  /* heads */
        	                  switch( heads.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(heads[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, heads);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(body);
        	                  /* triggers */
        	                  if( !triggers.empty() ){
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, triggers);
        	                    args.push_back(expr2);
        	                  };
        	                  expr = MK_EXPR(kind, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                  /* guards */
        	                  switch( guards.size() ){
        	                  case 0:
        	                    args.push_back(MK_CONST(bool(true))); break;
        	                  case 1:
        	                    args.push_back(guards[0]); break;
        	                  default:
        	                    expr2 = MK_EXPR(kind::AND, guards);
        	                    args.push_back(expr2); break;
        	                  };
        	                  args.push_back(expr);
        	                  expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                  cmd = new AssertCommand(expr); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerewriterulesCommandEx; /* Prevent compiler warnings */
    rulerewriterulesCommandEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end rewriterulesCommand */

/**
 * $ANTLR start rewritePropaKind
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:741:1: rewritePropaKind[CVC4::Kind& kind] : ( REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK );
 */
static void
rewritePropaKind(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:742:3: ( REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK )

            ANTLR3_UINT32 alt22;

            alt22=2;

            switch ( LA(1) )
            {
            case REDUCTION_RULE_TOK:
            	{
            		alt22=1;
            	}
                break;
            case PROPAGATION_RULE_TOK:
            	{
            		alt22=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 22;
                EXCEPTION->state        = 0;


                goto rulerewritePropaKindEx;

            }

            switch (alt22)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:743:3: REDUCTION_RULE_TOK
        	    {
        	         MATCHT(REDUCTION_RULE_TOK, &FOLLOW_REDUCTION_RULE_TOK_in_rewritePropaKind1661);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewritePropaKindEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::RR_REDUCTION; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:744:5: PROPAGATION_RULE_TOK
        	    {
        	         MATCHT(PROPAGATION_RULE_TOK, &FOLLOW_PROPAGATION_RULE_TOK_in_rewritePropaKind1672);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulerewritePropaKindEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::RR_DEDUCTION; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulerewritePropaKindEx; /* Prevent compiler warnings */
    rulerewritePropaKindEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end rewritePropaKind */

/**
 * $ANTLR start pattern
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:747:1: pattern[CVC4::Expr& expr] : LPAREN_TOK termList[patexpr,expr] RPAREN_TOK ;
 */
static void
pattern(pSmt2Parser ctx, CVC4::Expr& expr)
{

      std::vector<Expr> patexpr;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:751:3: ( LPAREN_TOK termList[patexpr,expr] RPAREN_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:751:5: LPAREN_TOK termList[patexpr,expr] RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_pattern1694);
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_termList_in_pattern1696);
            termList(ctx, patexpr, expr);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_pattern1699);
            if  (HASEXCEPTION())
            {
                goto rulepatternEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {

                      expr = MK_EXPR(kind::INST_PATTERN, patexpr);
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulepatternEx; /* Prevent compiler warnings */
    rulepatternEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end pattern */

/**
 * $ANTLR start simpleSymbolicExprNoKeyword
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:757:1: simpleSymbolicExprNoKeyword[CVC4::SExpr& sexpr] : ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECKSAT_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK ) | builtinOp[k] );
 */
static void
simpleSymbolicExprNoKeyword(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      CVC4::Kind k;
      std::string s;
      std::vector<unsigned int> s_vec;

    pANTLR3_COMMON_TOKEN    tok;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL5;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL6;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL7;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL8;

    /* Initialize rule variables
     */

    tok       = NULL;
    INTEGER_LITERAL5       = NULL;
    DECIMAL_LITERAL6       = NULL;
    HEX_LITERAL7       = NULL;
    BINARY_LITERAL8       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:763:3: ( INTEGER_LITERAL | DECIMAL_LITERAL | HEX_LITERAL | BINARY_LITERAL | str[s,false] | symbol[s,CHECK_NONE,SYM_SORT] |tok= ( ASSERT_TOK | CHECKSAT_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK ) | builtinOp[k] )

            ANTLR3_UINT32 alt23;

            alt23=8;

            switch ( LA(1) )
            {
            case INTEGER_LITERAL:
            	{
            		alt23=1;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt23=2;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt23=3;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt23=4;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt23=5;
            	}
                break;
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 156:
            	{
            		alt23=6;
            	}
                break;
            case ASSERT_TOK:
            case CHECKSAT_TOK:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case ECHO_TOK:
            case EXIT_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case REDUCTION_RULE_TOK:
            case REWRITE_RULE_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLIFY_TOK:
            	{
            		alt23=7;
            	}
                break;
            case ABS_TOK:
            case AND_TOK:
            case BV2NAT_TOK:
            case BVADD_TOK:
            case BVAND_TOK:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVLSHR_TOK:
            case BVMUL_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVNOT_TOK:
            case BVOR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUGE_TOK:
            case BVUGT_TOK:
            case BVULE_TOK:
            case BVULT_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case CONCAT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case EQUAL_TOK:
            case FMFCARD_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case IMPLIES_TOK:
            case INTS_DIV_TOK:
            case INTS_MOD_TOK:
            case IS_INT_TOK:
            case ITE_TOK:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case RECON_TOK:
            case REINTER_TOK:
            case RELOOP_TOK:
            case REOPT_TOK:
            case REPLUS_TOK:
            case RERANGE_TOK:
            case RESTAR_TOK:
            case REUNION_TOK:
            case SELECT_TOK:
            case STAR_TOK:
            case STORE_TOK:
            case STRCAT_TOK:
            case STRCON_TOK:
            case STRCTN_TOK:
            case STRIDOF_TOK:
            case STRINRE_TOK:
            case STRITOS_TOK:
            case STRLEN_TOK:
            case STRPREF_TOK:
            case STRREPL_TOK:
            case STRSTOI_TOK:
            case STRSTOU16_TOK:
            case STRSTOU32_TOK:
            case STRSUB_TOK:
            case STRSUFF_TOK:
            case STRTORE_TOK:
            case STRU16TOS_TOK:
            case STRU32TOS_TOK:
            case TO_INT_TOK:
            case TO_REAL_TOK:
            case XOR_TOK:
            	{
            		alt23=8;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 23;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprNoKeywordEx;

            }

            switch (alt23)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:763:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL5 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_simpleSymbolicExprNoKeyword1724);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(Integer(AntlrInput::tokenText(INTEGER_LITERAL5))); 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:765:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL6 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_simpleSymbolicExprNoKeyword1736);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenToRational(DECIMAL_LITERAL6)); 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:767:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL7 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_simpleSymbolicExprNoKeyword1748);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL7).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL7, 2);
        	                  sexpr = Integer(hexString, 16);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:772:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL8 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_simpleSymbolicExprNoKeyword1760);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL8).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL8, 2);
        	                  sexpr = Integer(binString, 2);
        	                
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:777:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_simpleSymbolicExprNoKeyword1772);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(s); 
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:786:5: symbol[s,CHECK_NONE,SYM_SORT]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_simpleSymbolicExprNoKeyword1792);
        	        symbol(ctx, s, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(SExpr::Keyword(s)); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:788:5: tok= ( ASSERT_TOK | CHECKSAT_TOK | DECLARE_FUN_TOK | DECLARE_SORT_TOK | DEFINE_FUN_TOK | DEFINE_SORT_TOK | GET_VALUE_TOK | GET_ASSIGNMENT_TOK | GET_ASSERTIONS_TOK | GET_PROOF_TOK | GET_UNSAT_CORE_TOK | EXIT_TOK | SET_LOGIC_TOK | SET_INFO_TOK | GET_INFO_TOK | SET_OPTION_TOK | GET_OPTION_TOK | PUSH_TOK | POP_TOK | DECLARE_DATATYPES_TOK | GET_MODEL_TOK | ECHO_TOK | REWRITE_RULE_TOK | REDUCTION_RULE_TOK | PROPAGATION_RULE_TOK | SIMPLIFY_TOK )
        	    {
        	        tok=(pANTLR3_COMMON_TOKEN)LT(1);

        	        if ( LA(1) == ASSERT_TOK || LA(1) == CHECKSAT_TOK || LA(1) == DECLARE_DATATYPES_TOK || LA(1) == DECLARE_FUN_TOK || LA(1) == DECLARE_SORT_TOK || ((LA(1) >= DEFINE_FUN_TOK) && (LA(1) <= DEFINE_SORT_TOK)) || LA(1) == ECHO_TOK || LA(1) == EXIT_TOK || ((LA(1) >= GET_ASSERTIONS_TOK) && (LA(1) <= GET_VALUE_TOK)) || LA(1) == POP_TOK || ((LA(1) >= PROPAGATION_RULE_TOK) && (LA(1) <= PUSH_TOK)) || LA(1) == REDUCTION_RULE_TOK || LA(1) == REWRITE_RULE_TOK || ((LA(1) >= SET_INFO_TOK) && (LA(1) <= SET_OPTION_TOK)) || LA(1) == SIMPLIFY_TOK )
        	        {
        	            CONSUME();
        	            PERRORRECOVERY=ANTLR3_FALSE;
        	            FAILEDFLAG=ANTLR3_FALSE;

        	        }
        	        else
        	        {
        	            if (BACKTRACKING>0)
        	            {
        	                FAILEDFLAG = ANTLR3_TRUE;
        	                return ;
        	            }

        	            CONSTRUCTEX();
        	            EXCEPTION->type         = ANTLR3_MISMATCHED_SET_EXCEPTION;
        	            EXCEPTION->name         = (void *)ANTLR3_MISMATCHED_SET_NAME;
        	            EXCEPTION->expectingSet = NULL;

        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(SExpr::Keyword(AntlrInput::tokenText(tok))); 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:790:5: builtinOp[k]
        	    {
        	        FOLLOWPUSH(FOLLOW_builtinOp_in_simpleSymbolicExprNoKeyword1921);
        	        builtinOp(ctx, k);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprNoKeywordEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::stringstream ss;
        	                  ss << Expr::setlanguage(CVC4::language::output::LANG_SMTLIB_V2) << EXPR_MANAGER->mkConst(k);
        	                  sexpr = SExpr(ss.str());
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprNoKeywordEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprNoKeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExprNoKeyword */

/**
 * $ANTLR start keyword
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:797:1: keyword[std::string& s] : KEYWORD ;
 */
static void
keyword(pSmt2Parser ctx, std::string& s)
{
    pANTLR3_COMMON_TOKEN    KEYWORD9;

    /* Initialize rule variables
     */

    KEYWORD9       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:798:3: ( KEYWORD )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:798:5: KEYWORD
        {
            KEYWORD9 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_keyword1942);
            if  (HASEXCEPTION())
            {
                goto rulekeywordEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 s = AntlrInput::tokenText(KEYWORD9); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulekeywordEx; /* Prevent compiler warnings */
    rulekeywordEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end keyword */

/**
 * $ANTLR start simpleSymbolicExpr
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:802:1: simpleSymbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD );
 */
static void
simpleSymbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{
    pANTLR3_COMMON_TOKEN    KEYWORD10;

    /* Initialize rule variables
     */

    KEYWORD10       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:803:3: ( simpleSymbolicExprNoKeyword[sexpr] | KEYWORD )

            ANTLR3_UINT32 alt24;

            alt24=2;

            switch ( LA(1) )
            {
            case ABS_TOK:
            case AND_TOK:
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case BV2NAT_TOK:
            case BVADD_TOK:
            case BVAND_TOK:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVLSHR_TOK:
            case BVMUL_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVNOT_TOK:
            case BVOR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUGE_TOK:
            case BVUGT_TOK:
            case BVULE_TOK:
            case BVULT_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case CHECKSAT_TOK:
            case CONCAT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case ECHO_TOK:
            case EQUAL_TOK:
            case EXIT_TOK:
            case FMFCARD_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case HEX_LITERAL:
            case IMPLIES_TOK:
            case INTEGER_LITERAL:
            case INTS_DIV_TOK:
            case INTS_MOD_TOK:
            case IS_INT_TOK:
            case ITE_TOK:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case RECON_TOK:
            case REDUCTION_RULE_TOK:
            case REINTER_TOK:
            case RELOOP_TOK:
            case REOPT_TOK:
            case REPLUS_TOK:
            case RERANGE_TOK:
            case RESTAR_TOK:
            case REUNION_TOK:
            case REWRITE_RULE_TOK:
            case SELECT_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STAR_TOK:
            case STORE_TOK:
            case STRCAT_TOK:
            case STRCON_TOK:
            case STRCTN_TOK:
            case STRIDOF_TOK:
            case STRING_LITERAL:
            case STRINRE_TOK:
            case STRITOS_TOK:
            case STRLEN_TOK:
            case STRPREF_TOK:
            case STRREPL_TOK:
            case STRSTOI_TOK:
            case STRSTOU16_TOK:
            case STRSTOU32_TOK:
            case STRSUB_TOK:
            case STRSUFF_TOK:
            case STRTORE_TOK:
            case STRU16TOS_TOK:
            case STRU32TOS_TOK:
            case TO_INT_TOK:
            case TO_REAL_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case XOR_TOK:
            case 156:
            	{
            		alt24=1;
            	}
                break;
            case KEYWORD:
            	{
            		alt24=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 24;
                EXCEPTION->state        = 0;


                goto rulesimpleSymbolicExprEx;

            }

            switch (alt24)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:803:5: simpleSymbolicExprNoKeyword[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_simpleSymbolicExpr1962);
        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:804:5: KEYWORD
        	    {
        	        KEYWORD10 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_simpleSymbolicExpr1969);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesimpleSymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(AntlrInput::tokenText(KEYWORD10)); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesimpleSymbolicExprEx; /* Prevent compiler warnings */
    rulesimpleSymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end simpleSymbolicExpr */

/**
 * $ANTLR start symbolicExpr
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:808:1: symbolicExpr[CVC4::SExpr& sexpr] : ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK );
 */
static void
symbolicExpr(pSmt2Parser ctx, CVC4::SExpr& sexpr)
{

      std::vector<SExpr> children;

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:812:3: ( simpleSymbolicExpr[sexpr] | LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK )

            ANTLR3_UINT32 alt26;

            alt26=2;

            switch ( LA(1) )
            {
            case ABS_TOK:
            case AND_TOK:
            case ASSERT_TOK:
            case BINARY_LITERAL:
            case BV2NAT_TOK:
            case BVADD_TOK:
            case BVAND_TOK:
            case BVASHR_TOK:
            case BVCOMP_TOK:
            case BVLSHR_TOK:
            case BVMUL_TOK:
            case BVNAND_TOK:
            case BVNEG_TOK:
            case BVNOR_TOK:
            case BVNOT_TOK:
            case BVOR_TOK:
            case BVSDIV_TOK:
            case BVSGE_TOK:
            case BVSGT_TOK:
            case BVSHL_TOK:
            case BVSLE_TOK:
            case BVSLT_TOK:
            case BVSMOD_TOK:
            case BVSREM_TOK:
            case BVSUB_TOK:
            case BVUDIV_TOK:
            case BVUGE_TOK:
            case BVUGT_TOK:
            case BVULE_TOK:
            case BVULT_TOK:
            case BVUREM_TOK:
            case BVXNOR_TOK:
            case BVXOR_TOK:
            case CHECKSAT_TOK:
            case CONCAT_TOK:
            case DECIMAL_LITERAL:
            case DECLARE_DATATYPES_TOK:
            case DECLARE_FUN_TOK:
            case DECLARE_SORT_TOK:
            case DEFINE_FUN_TOK:
            case DEFINE_SORT_TOK:
            case DISTINCT_TOK:
            case DIV_TOK:
            case ECHO_TOK:
            case EQUAL_TOK:
            case EXIT_TOK:
            case FMFCARD_TOK:
            case GET_ASSERTIONS_TOK:
            case GET_ASSIGNMENT_TOK:
            case GET_INFO_TOK:
            case GET_MODEL_TOK:
            case GET_OPTION_TOK:
            case GET_PROOF_TOK:
            case GET_UNSAT_CORE_TOK:
            case GET_VALUE_TOK:
            case GREATER_THAN_EQUAL_TOK:
            case GREATER_THAN_TOK:
            case HEX_LITERAL:
            case IMPLIES_TOK:
            case INTEGER_LITERAL:
            case INTS_DIV_TOK:
            case INTS_MOD_TOK:
            case IS_INT_TOK:
            case ITE_TOK:
            case KEYWORD:
            case LESS_THAN_EQUAL_TOK:
            case LESS_THAN_TOK:
            case MINUS_TOK:
            case NOT_TOK:
            case OR_TOK:
            case PLUS_TOK:
            case POP_TOK:
            case PROPAGATION_RULE_TOK:
            case PUSH_TOK:
            case QUOTED_SYMBOL:
            case RECON_TOK:
            case REDUCTION_RULE_TOK:
            case REINTER_TOK:
            case RELOOP_TOK:
            case REOPT_TOK:
            case REPLUS_TOK:
            case RERANGE_TOK:
            case RESTAR_TOK:
            case REUNION_TOK:
            case REWRITE_RULE_TOK:
            case SELECT_TOK:
            case SET_INFO_TOK:
            case SET_LOGIC_TOK:
            case SET_OPTION_TOK:
            case SIMPLE_SYMBOL:
            case SIMPLIFY_TOK:
            case STAR_TOK:
            case STORE_TOK:
            case STRCAT_TOK:
            case STRCON_TOK:
            case STRCTN_TOK:
            case STRIDOF_TOK:
            case STRING_LITERAL:
            case STRINRE_TOK:
            case STRITOS_TOK:
            case STRLEN_TOK:
            case STRPREF_TOK:
            case STRREPL_TOK:
            case STRSTOI_TOK:
            case STRSTOU16_TOK:
            case STRSTOU32_TOK:
            case STRSUB_TOK:
            case STRSUFF_TOK:
            case STRTORE_TOK:
            case STRU16TOS_TOK:
            case STRU32TOS_TOK:
            case TO_INT_TOK:
            case TO_REAL_TOK:
            case UNTERMINATED_QUOTED_SYMBOL:
            case XOR_TOK:
            case 156:
            	{
            		alt26=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		alt26=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 26;
                EXCEPTION->state        = 0;


                goto rulesymbolicExprEx;

            }

            switch (alt26)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:812:5: simpleSymbolicExpr[sexpr]
        	    {
        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExpr_in_symbolicExpr1994);
        	        simpleSymbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:813:5: LPAREN_TOK ( symbolicExpr[sexpr] )* RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_symbolicExpr2001);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:814:5: ( symbolicExpr[sexpr] )*

        	        for (;;)
        	        {
        	            int alt25=2;
        	            switch ( LA(1) )
        	            {
        	            case ABS_TOK:
        	            case AND_TOK:
        	            case ASSERT_TOK:
        	            case BINARY_LITERAL:
        	            case BV2NAT_TOK:
        	            case BVADD_TOK:
        	            case BVAND_TOK:
        	            case BVASHR_TOK:
        	            case BVCOMP_TOK:
        	            case BVLSHR_TOK:
        	            case BVMUL_TOK:
        	            case BVNAND_TOK:
        	            case BVNEG_TOK:
        	            case BVNOR_TOK:
        	            case BVNOT_TOK:
        	            case BVOR_TOK:
        	            case BVSDIV_TOK:
        	            case BVSGE_TOK:
        	            case BVSGT_TOK:
        	            case BVSHL_TOK:
        	            case BVSLE_TOK:
        	            case BVSLT_TOK:
        	            case BVSMOD_TOK:
        	            case BVSREM_TOK:
        	            case BVSUB_TOK:
        	            case BVUDIV_TOK:
        	            case BVUGE_TOK:
        	            case BVUGT_TOK:
        	            case BVULE_TOK:
        	            case BVULT_TOK:
        	            case BVUREM_TOK:
        	            case BVXNOR_TOK:
        	            case BVXOR_TOK:
        	            case CHECKSAT_TOK:
        	            case CONCAT_TOK:
        	            case DECIMAL_LITERAL:
        	            case DECLARE_DATATYPES_TOK:
        	            case DECLARE_FUN_TOK:
        	            case DECLARE_SORT_TOK:
        	            case DEFINE_FUN_TOK:
        	            case DEFINE_SORT_TOK:
        	            case DISTINCT_TOK:
        	            case DIV_TOK:
        	            case ECHO_TOK:
        	            case EQUAL_TOK:
        	            case EXIT_TOK:
        	            case FMFCARD_TOK:
        	            case GET_ASSERTIONS_TOK:
        	            case GET_ASSIGNMENT_TOK:
        	            case GET_INFO_TOK:
        	            case GET_MODEL_TOK:
        	            case GET_OPTION_TOK:
        	            case GET_PROOF_TOK:
        	            case GET_UNSAT_CORE_TOK:
        	            case GET_VALUE_TOK:
        	            case GREATER_THAN_EQUAL_TOK:
        	            case GREATER_THAN_TOK:
        	            case HEX_LITERAL:
        	            case IMPLIES_TOK:
        	            case INTEGER_LITERAL:
        	            case INTS_DIV_TOK:
        	            case INTS_MOD_TOK:
        	            case IS_INT_TOK:
        	            case ITE_TOK:
        	            case KEYWORD:
        	            case LESS_THAN_EQUAL_TOK:
        	            case LESS_THAN_TOK:
        	            case LPAREN_TOK:
        	            case MINUS_TOK:
        	            case NOT_TOK:
        	            case OR_TOK:
        	            case PLUS_TOK:
        	            case POP_TOK:
        	            case PROPAGATION_RULE_TOK:
        	            case PUSH_TOK:
        	            case QUOTED_SYMBOL:
        	            case RECON_TOK:
        	            case REDUCTION_RULE_TOK:
        	            case REINTER_TOK:
        	            case RELOOP_TOK:
        	            case REOPT_TOK:
        	            case REPLUS_TOK:
        	            case RERANGE_TOK:
        	            case RESTAR_TOK:
        	            case REUNION_TOK:
        	            case REWRITE_RULE_TOK:
        	            case SELECT_TOK:
        	            case SET_INFO_TOK:
        	            case SET_LOGIC_TOK:
        	            case SET_OPTION_TOK:
        	            case SIMPLE_SYMBOL:
        	            case SIMPLIFY_TOK:
        	            case STAR_TOK:
        	            case STORE_TOK:
        	            case STRCAT_TOK:
        	            case STRCON_TOK:
        	            case STRCTN_TOK:
        	            case STRIDOF_TOK:
        	            case STRING_LITERAL:
        	            case STRINRE_TOK:
        	            case STRITOS_TOK:
        	            case STRLEN_TOK:
        	            case STRPREF_TOK:
        	            case STRREPL_TOK:
        	            case STRSTOI_TOK:
        	            case STRSTOU16_TOK:
        	            case STRSTOU32_TOK:
        	            case STRSUB_TOK:
        	            case STRSUFF_TOK:
        	            case STRTORE_TOK:
        	            case STRU16TOS_TOK:
        	            case STRU32TOS_TOK:
        	            case TO_INT_TOK:
        	            case TO_REAL_TOK:
        	            case UNTERMINATED_QUOTED_SYMBOL:
        	            case XOR_TOK:
        	            case 156:
        	            	{
        	            		alt25=1;
        	            	}
        	                break;

        	            }

        	            switch (alt25)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:814:7: symbolicExpr[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_symbolicExpr2009);
        	        	        symbolicExpr(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolicExprEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             children.push_back(sexpr); 
        	        	        }


        	        	    }
        	        	    break;

        	        	default:
        	        	    goto loop25;	/* break out of the loop */
        	        	    break;
        	            }
        	        }
        	        loop25: ; /* Jump out to here if this rule does not match */


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_symbolicExpr2017);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolicExprEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             sexpr = SExpr(children); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolicExprEx; /* Prevent compiler warnings */
    rulesymbolicExprEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolicExpr */

/**
 * $ANTLR start term
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:822:1: term[CVC4::Expr& expr, CVC4::Expr& expr2] : ( LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK term[f, f2] sortSymbol[type, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK | LPAREN_TOK indexedFunctionName[op] termList[args,expr] RPAREN_TOK | LPAREN_TOK LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ RPAREN_TOK term[expr, f2] RPAREN_TOK | symbol[name,CHECK_DECLARED,SYM_VARIABLE] | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr,attr] )+ RPAREN_TOK | INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | RENOSTR_TOK | REALLCHAR_TOK | EMPTYSET_TOK );
 */
static void
term(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& expr2)
{
    pANTLR3_COMMON_TOKEN    bvLit;
    pANTLR3_COMMON_TOKEN    size;
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL11;
    pANTLR3_COMMON_TOKEN    DECIMAL_LITERAL12;
    pANTLR3_COMMON_TOKEN    HEX_LITERAL13;
    pANTLR3_COMMON_TOKEN    BINARY_LITERAL14;

    /* Initialize rule variables
     */


      Debug("parser") << "term: " << AntlrInput::tokenText(LT(1)) << std::endl;
      Kind kind = kind::NULL_EXPR;
      Expr op;
      std::string name;
      std::vector<Expr> args;
      SExpr sexpr;
      std::vector< std::pair<std::string, Type> > sortedVarNames;
      Expr f, f2;
      std::string attr;
      Expr attexpr;
      std::vector<Expr> patexprs;
      std::hash_set<std::string, StringHashFunction> names;
      std::vector< std::pair<std::string, Expr> > binders;
      Type type;
      std::string s;
      bool isBuiltinOperator = false;

    bvLit       = NULL;
    size       = NULL;
    INTEGER_LITERAL11       = NULL;
    DECIMAL_LITERAL12       = NULL;
    HEX_LITERAL13       = NULL;
    BINARY_LITERAL14       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:841:3: ( LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK | LPAREN_TOK AS_TOK term[f, f2] sortSymbol[type, CHECK_DECLARED] RPAREN_TOK | LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK | LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK | LPAREN_TOK indexedFunctionName[op] termList[args,expr] RPAREN_TOK | LPAREN_TOK LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ RPAREN_TOK term[expr, f2] RPAREN_TOK | symbol[name,CHECK_DECLARED,SYM_VARIABLE] | LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr,attr] )+ RPAREN_TOK | INTEGER_LITERAL | DECIMAL_LITERAL | LPAREN_TOK INDEX_TOK bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL RPAREN_TOK | HEX_LITERAL | BINARY_LITERAL | str[s,false] | RENOSTR_TOK | REALLCHAR_TOK | EMPTYSET_TOK )

            ANTLR3_UINT32 alt29;

            alt29=17;

            switch ( LA(1) )
            {
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case AS_TOK:
            			{
            				alt29=2;
            			}
            		    break;
            		case LET_TOK:
            			{
            				alt29=6;
            			}
            		    break;
            		case ATTRIBUTE_TOK:
            			{
            				alt29=8;
            			}
            		    break;
            		case INDEX_TOK:
            			{
            				alt29=11;
            			}
            		    break;
            		case ABS_TOK:
            		case AND_TOK:
            		case BV2NAT_TOK:
            		case BVADD_TOK:
            		case BVAND_TOK:
            		case BVASHR_TOK:
            		case BVCOMP_TOK:
            		case BVLSHR_TOK:
            		case BVMUL_TOK:
            		case BVNAND_TOK:
            		case BVNEG_TOK:
            		case BVNOR_TOK:
            		case BVNOT_TOK:
            		case BVOR_TOK:
            		case BVSDIV_TOK:
            		case BVSGE_TOK:
            		case BVSGT_TOK:
            		case BVSHL_TOK:
            		case BVSLE_TOK:
            		case BVSLT_TOK:
            		case BVSMOD_TOK:
            		case BVSREM_TOK:
            		case BVSUB_TOK:
            		case BVUDIV_TOK:
            		case BVUGE_TOK:
            		case BVUGT_TOK:
            		case BVULE_TOK:
            		case BVULT_TOK:
            		case BVUREM_TOK:
            		case BVXNOR_TOK:
            		case BVXOR_TOK:
            		case CONCAT_TOK:
            		case DISTINCT_TOK:
            		case DIV_TOK:
            		case EQUAL_TOK:
            		case FMFCARD_TOK:
            		case GREATER_THAN_EQUAL_TOK:
            		case GREATER_THAN_TOK:
            		case IMPLIES_TOK:
            		case INTS_DIV_TOK:
            		case INTS_MOD_TOK:
            		case IS_INT_TOK:
            		case ITE_TOK:
            		case LESS_THAN_EQUAL_TOK:
            		case LESS_THAN_TOK:
            		case MINUS_TOK:
            		case NOT_TOK:
            		case OR_TOK:
            		case PLUS_TOK:
            		case RECON_TOK:
            		case REINTER_TOK:
            		case RELOOP_TOK:
            		case REOPT_TOK:
            		case REPLUS_TOK:
            		case RERANGE_TOK:
            		case RESTAR_TOK:
            		case REUNION_TOK:
            		case SELECT_TOK:
            		case STAR_TOK:
            		case STORE_TOK:
            		case STRCAT_TOK:
            		case STRCON_TOK:
            		case STRCTN_TOK:
            		case STRIDOF_TOK:
            		case STRINRE_TOK:
            		case STRITOS_TOK:
            		case STRLEN_TOK:
            		case STRPREF_TOK:
            		case STRREPL_TOK:
            		case STRSTOI_TOK:
            		case STRSTOU16_TOK:
            		case STRSTOU32_TOK:
            		case STRSUB_TOK:
            		case STRSUFF_TOK:
            		case STRTORE_TOK:
            		case STRU16TOS_TOK:
            		case STRU32TOS_TOK:
            		case TO_INT_TOK:
            		case TO_REAL_TOK:
            		case XOR_TOK:
            			{
            				alt29=1;
            			}
            		    break;
            		case EXISTS_TOK:
            		case FORALL_TOK:
            			{
            				alt29=3;
            			}
            		    break;
            		case QUOTED_SYMBOL:
            		case SIMPLE_SYMBOL:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 156:
            			{
            				alt29=4;
            			}
            		    break;
            		case LPAREN_TOK:
            			{
            				alt29=5;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 29;
            		    EXCEPTION->state        = 1;


            		    goto ruletermEx;

            		}

            	}
                break;
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 156:
            	{
            		alt29=7;
            	}
                break;
            case INTEGER_LITERAL:
            	{
            		alt29=9;
            	}
                break;
            case DECIMAL_LITERAL:
            	{
            		alt29=10;
            	}
                break;
            case HEX_LITERAL:
            	{
            		alt29=12;
            	}
                break;
            case BINARY_LITERAL:
            	{
            		alt29=13;
            	}
                break;
            case STRING_LITERAL:
            	{
            		alt29=14;
            	}
                break;
            case RENOSTR_TOK:
            	{
            		alt29=15;
            	}
                break;
            case REALLCHAR_TOK:
            	{
            		alt29=16;
            	}
                break;
            case EMPTYSET_TOK:
            	{
            		alt29=17;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 29;
                EXCEPTION->state        = 0;


                goto ruletermEx;

            }

            switch (alt29)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:842:5: LPAREN_TOK builtinOp[kind] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2050);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_builtinOp_in_term2052);
        	        builtinOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_term2055);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2058);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if( kind == CVC4::kind::EQUAL &&
        	                      args.size() > 0 &&
        	                      args[0].getType() == EXPR_MANAGER->booleanType() ) {
        	                    /* Use IFF for boolean equalities. */
        	                    kind = CVC4::kind::IFF;
        	                  }

        	                  if( !PARSER_STATE->strictModeEnabled() &&
        	                      (kind == CVC4::kind::AND || kind == CVC4::kind::OR) &&
        	                      args.size() == 1) {
        	                    /* Unary AND/OR can be replaced with the argument.
        	                     * It just so happens expr should already be the only argument. */
        	                    assert( expr == args[0] );
        	                  } else if( CVC4::kind::isAssociative(kind) &&
        	                             args.size() > EXPR_MANAGER->maxArity(kind) ) {
        	                    /* Special treatment for associative operators with lots of children */
        	                    expr = EXPR_MANAGER->mkAssociative(kind, args);
        	                  } else if( kind == CVC4::kind::MINUS && args.size() == 1 ) {
        	                    expr = MK_EXPR(CVC4::kind::UMINUS, args[0]);
        	                  } else if( ( kind == CVC4::kind::XOR || kind == CVC4::kind::MINUS ) &&
        	                             args.size() > 2 ) {
        	                    /* left-associative, but CVC4 internally only supports 2 args */
        	                    expr = args[0];
        	                    for(size_t i = 1; i < args.size(); ++i) {
        	                      expr = MK_EXPR(kind, expr, args[i]);
        	                    }
        	                  } else if( kind == CVC4::kind::IMPLIES && args.size() > 2 ) {
        	                    /* right-associative, but CVC4 internally only supports 2 args */
        	                    expr = args[args.size() - 1];
        	                    for(size_t i = args.size() - 1; i > 0;) {
        	                      expr = MK_EXPR(kind, args[--i], expr);
        	                    }
        	                  } else if( ( kind == CVC4::kind::IFF || kind == CVC4::kind::EQUAL ||
        	                               kind == CVC4::kind::LT || kind == CVC4::kind::GT ||
        	                               kind == CVC4::kind::LEQ || kind == CVC4::kind::GEQ ) &&
        	                             args.size() > 2 ) {
        	                    /* "chainable", but CVC4 internally only supports 2 args */
        	                    expr = MK_EXPR(MK_CONST(Chain(kind)), args);
        	                  } else if( PARSER_STATE->strictModeEnabled() && kind == CVC4::kind::ABS &&
        	                             args.size() == 1 && !args[0].getType().isInteger() ) {
        	                    /* first, check that ABS is even defined in this logic */
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                    PARSER_STATE->parseError("abs can only be applied to Int, not Real, while in strict SMT-LIB compliance mode");
        	                  } else {
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:892:5: LPAREN_TOK AS_TOK term[f, f2] sortSymbol[type, CHECK_DECLARED] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2070);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(AS_TOK, &FOLLOW_AS_TOK_in_term2072);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term2074);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortSymbol_in_term2077);
        	        sortSymbol(ctx, type, CHECK_DECLARED);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2080);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(f.getKind() == CVC4::kind::APPLY_CONSTRUCTOR && type.isDatatype()) {
        	                    std::vector<CVC4::Expr> v;
        	                    Expr e = f.getOperator();
        	                    const DatatypeConstructor& dtc = Datatype::datatypeOf(e)[Datatype::indexOf(e)];
        	                    v.push_back(MK_EXPR( CVC4::kind::APPLY_TYPE_ASCRIPTION,
        	                                         MK_CONST(AscriptionType(dtc.getSpecializedConstructorType(type))), f.getOperator() ));
        	                    v.insert(v.end(), f.begin(), f.end());
        	                    expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, v);
        	                  } else if(f.getKind() == CVC4::kind::EMPTYSET) {
        	                    Debug("parser") << "Empty set encountered: " << f << " "
        	                                      << f2 << " " << type <<  std::endl;
        	                    expr = MK_CONST( ::CVC4::EmptySet(type) );
        	                  } else {
        	                    if(f.getType() != type) {
        	                      PARSER_STATE->parseError("Type ascription not satisfied.");
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:912:5: LPAREN_TOK quantOp[kind] LPAREN_TOK sortedVarList[sortedVarNames] RPAREN_TOK term[f, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2092);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_quantOp_in_term2094);
        	        quantOp(ctx, kind);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2101);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortedVarList_in_term2103);
        	        sortedVarList(ctx, sortedVarNames);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2106);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  PARSER_STATE->pushScope(true);
        	                  for(std::vector<std::pair<std::string, CVC4::Type> >::const_iterator i =
        	                        sortedVarNames.begin(), iend = sortedVarNames.end();
        	                      i != iend;
        	                      ++i) {
        	                    args.push_back(PARSER_STATE->mkBoundVar((*i).first, (*i).second));
        	                  }
        	                  Expr bvl = MK_EXPR(kind::BOUND_VAR_LIST, args);
        	                  args.clear();
        	                  args.push_back(bvl);
        	                
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term2118);
        	        term(ctx, f, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2121);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  PARSER_STATE->popScope();
        	                  switch(f.getKind()) {
        	                  case CVC4::kind::RR_REWRITE:
        	                  case CVC4::kind::RR_REDUCTION:
        	                  case CVC4::kind::RR_DEDUCTION:
        	                    if(kind == CVC4::kind::EXISTS) {
        	                      PARSER_STATE->parseError("Use Exists instead of Forall for a rewrite rule.");
        	                    }
        	                    args.push_back(f2); // guards
        	                    args.push_back(f); // rule
        	                    expr = MK_EXPR(CVC4::kind::REWRITE_RULE, args);
        	                    break;
        	                  default:
        	                    args.push_back(f);
        	                    if(! f2.isNull()){
        	                      args.push_back(f2);
        	                    }
        	                    expr = MK_EXPR(kind, args);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:948:5: LPAREN_TOK functionName[name, CHECK_NONE] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2133);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_functionName_in_term2135);
        	        functionName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             isBuiltinOperator = PARSER_STATE->isOperatorEnabled(name);
        	                  if(isBuiltinOperator) {
        	                    /* A built-in operator not already handled by the lexer */
        	                    kind = PARSER_STATE->getOperatorKind(name);
        	                  } else {
        	                    /* A non-built-in function application */
        	                    PARSER_STATE->checkDeclaration(name, CHECK_DECLARED, SYM_VARIABLE);
        	                    PARSER_STATE->checkFunctionLike(name);
        	                    const bool isDefinedFunction =
        	                      PARSER_STATE->isDefinedFunction(name);
        	                    if(isDefinedFunction) {
        	                      expr = PARSER_STATE->getFunction(name);
        	                      kind = CVC4::kind::APPLY;
        	                    } else {
        	                      expr = PARSER_STATE->getVariable(name);
        	                      Type t = expr.getType();
        	                      if(t.isConstructor()) {
        	                        kind = CVC4::kind::APPLY_CONSTRUCTOR;
        	                      } else if(t.isSelector()) {
        	                        kind = CVC4::kind::APPLY_SELECTOR;
        	                      } else if(t.isTester()) {
        	                        kind = CVC4::kind::APPLY_TESTER;
        	                      } else {
        	                        kind = CVC4::kind::APPLY_UF;
        	                      }
        	                    }
        	                    args.push_back(expr);
        	                  }
        	                    
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_term2148);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2151);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             Debug("parser") << "args has size " << args.size() << std::endl << "expr is " << expr << std::endl;
        	                  for(std::vector<Expr>::iterator i = args.begin(); i != args.end(); ++i) {
        	                    Debug("parser") << "++ " << *i << std::endl;
        	                  }
        	                  if(isBuiltinOperator) {
        	                    PARSER_STATE->checkOperator(kind, args.size());
        	                  }
        	                  expr = MK_EXPR(kind, args); 
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:989:5: LPAREN_TOK indexedFunctionName[op] termList[args,expr] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2170);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_indexedFunctionName_in_term2172);
        	        indexedFunctionName(ctx, op);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_termList_in_term2175);
        	        termList(ctx, args, expr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2178);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             expr = MK_EXPR(op, args);
        	                  PARSER_STATE->checkOperator(expr.getKind(), args.size());
        	                
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:994:5: LPAREN_TOK LET_TOK LPAREN_TOK ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+ RPAREN_TOK term[expr, f2] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2196);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LET_TOK, &FOLLOW_LET_TOK_in_term2198);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2200);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->pushScope(true); 
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:996:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK )+
        	        {
        	            int cnt27=0;

        	            for (;;)
        	            {
        	                int alt27=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case LPAREN_TOK:
        	        		{
        	        			alt27=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt27)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:996:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] term[expr, f2] RPAREN_TOK
        	        	        {
        	        	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2214);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_symbol_in_term2216);
        	        	            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            FOLLOWPUSH(FOLLOW_term_in_term2219);
        	        	            term(ctx, expr, f2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2222);
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 if(names.count(name) == 1) {
        	        	                          std::stringstream ss;
        	        	                          ss << "warning: symbol `" << name << "' bound multiple times by let; the last binding will be used, shadowing earlier ones";
        	        	                          PARSER_STATE->warning(ss.str());
        	        	                        } else {
        	        	                          names.insert(name);
        	        	                        }
        	        	                        binders.push_back(std::make_pair(name, expr)); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt27 >= 1 )
        	        		{
        	        		    goto loop27;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermEx;
        	        	}
        	        	cnt27++;
        	            }
        	            loop27: ;	/* Jump to here if this rule does not match */
        	        }

        	        if ( BACKTRACKING==0 )
        	        {
        	             // now implement these bindings
        	                  for(std::vector< std::pair<std::string, Expr> >::iterator i = binders.begin(); i != binders.end(); ++i) {
        	                    PARSER_STATE->defineVar((*i).first, (*i).second);
        	                  }
        	                
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2259);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term2265);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2272);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             PARSER_STATE->popScope(); 
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1018:5: symbol[name,CHECK_DECLARED,SYM_VARIABLE]
        	    {
        	        FOLLOWPUSH(FOLLOW_symbol_in_term2291);
        	        symbol(ctx, name, CHECK_DECLARED, SYM_VARIABLE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             const bool isDefinedFunction =
        	                    PARSER_STATE->isDefinedFunction(name);
        	                  if(PARSER_STATE->isAbstractValue(name)) {
        	                    expr = PARSER_STATE->mkAbstractValue(name);
        	                  } else if(isDefinedFunction) {
        	                    expr = MK_EXPR(CVC4::kind::APPLY,
        	                                   PARSER_STATE->getFunction(name));
        	                  } else {
        	                    expr = PARSER_STATE->getVariable(name);
        	                    Type t = PARSER_STATE->getType(name);
        	                    if(t.isConstructor() && ConstructorType(t).getArity() == 0) {
        	                      // don't require parentheses, immediately turn it into an apply
        	                      expr = MK_EXPR(CVC4::kind::APPLY_CONSTRUCTOR, expr);
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1037:5: LPAREN_TOK ATTRIBUTE_TOK term[expr, f2] ( attribute[expr, attexpr,attr] )+ RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2311);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(ATTRIBUTE_TOK, &FOLLOW_ATTRIBUTE_TOK_in_term2313);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_term_in_term2315);
        	        term(ctx, expr, f2);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1038:5: ( attribute[expr, attexpr,attr] )+
        	        {
        	            int cnt28=0;

        	            for (;;)
        	            {
        	                int alt28=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case ATTRIBUTE_NAMED_TOK:
        	        	case ATTRIBUTE_NO_PATTERN_TOK:
        	        	case ATTRIBUTE_PATTERN_TOK:
        	        	case KEYWORD:
        	        		{
        	        			alt28=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt28)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1038:7: attribute[expr, attexpr,attr]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_attribute_in_term2324);
        	        	            attribute(ctx, expr, attexpr, attr);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruletermEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 if( attr == ":pattern" && ! attexpr.isNull()) {
        	        	                          patexprs.push_back( attexpr );
        	        	                        }
        	        	                      
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt28 >= 1 )
        	        		{
        	        		    goto loop28;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruletermEx;
        	        	}
        	        	cnt28++;
        	            }
        	            loop28: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2342);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(attr == ":rewrite-rule") {
        	                    Expr guard;
        	                    Expr body;
        	                    if(expr[1].getKind() == kind::IMPLIES ||
        	                       expr[1].getKind() == kind::IFF ||
        	                       expr[1].getKind() == kind::EQUAL) {
        	                      guard = expr[0];
        	                      body = expr[1];
        	                    } else {
        	                      guard = MK_CONST(bool(true));
        	                      body = expr;
        	                    }
        	                    expr2 = guard;
        	                    args.push_back(body[0]);
        	                    args.push_back(body[1]);
        	                    if(!f2.isNull()) {
        	                      args.push_back(f2);
        	                    }

        	                    if     ( body.getKind()==kind::IMPLIES )    kind = kind::RR_DEDUCTION;
        	                    else if( body.getKind()==kind::IFF )        kind = kind::RR_REDUCTION;
        	                    else if( body.getKind()==kind::EQUAL )      kind = kind::RR_REWRITE;
        	                    else PARSER_STATE->parseError("Error parsing rewrite rule.");

        	                    expr = MK_EXPR( kind, args );
        	                  } else if(! patexprs.empty()) {
        	                    if( !f2.isNull() && f2.getKind()==kind::INST_PATTERN_LIST ){
        	                      for( size_t i=0; i<f2.getNumChildren(); i++ ){
        	                        patexprs.push_back( f2[i] );
        	                      }
        	                    }
        	                    expr2 = MK_EXPR(kind::INST_PATTERN_LIST, patexprs);
        	                  }else{
        	                    expr2 = f2;
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1082:5: INTEGER_LITERAL
        	    {
        	        INTEGER_LITERAL11 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term2360);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             expr = MK_CONST( AntlrInput::tokenToInteger(INTEGER_LITERAL11) ); 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1085:5: DECIMAL_LITERAL
        	    {
        	        DECIMAL_LITERAL12 = (pANTLR3_COMMON_TOKEN) MATCHT(DECIMAL_LITERAL, &FOLLOW_DECIMAL_LITERAL_in_term2373);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             // FIXME: This doesn't work because an SMT rational is not a
        	                  // valid GMP rational string
        	                  expr = MK_CONST( AntlrInput::tokenToRational(DECIMAL_LITERAL12) ); 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1090:5: LPAREN_TOK INDEX_TOK bvLit= SIMPLE_SYMBOL size= INTEGER_LITERAL RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_term2386);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_term2388);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        bvLit = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_term2392);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        size = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_term2396);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_term2398);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             if(AntlrInput::tokenText(bvLit).find("bv") == 0) {
        	                    expr = MK_CONST( AntlrInput::tokenToBitvector(bvLit, size) );
        	                  } else {
        	                    PARSER_STATE->parseError("Unexpected symbol `" + AntlrInput::tokenText(bvLit) + "'");
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1098:5: HEX_LITERAL
        	    {
        	        HEX_LITERAL13 = (pANTLR3_COMMON_TOKEN) MATCHT(HEX_LITERAL, &FOLLOW_HEX_LITERAL_in_term2411);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(HEX_LITERAL13).find("#x") == 0 );
        	                  std::string hexString = AntlrInput::tokenTextSubstr(HEX_LITERAL13, 2);
        	                  expr = MK_CONST( BitVector(hexString, 16) ); 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1103:5: BINARY_LITERAL
        	    {
        	        BINARY_LITERAL14 = (pANTLR3_COMMON_TOKEN) MATCHT(BINARY_LITERAL, &FOLLOW_BINARY_LITERAL_in_term2424);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             assert( AntlrInput::tokenText(BINARY_LITERAL14).find("#b") == 0 );
        	                  std::string binString = AntlrInput::tokenTextSubstr(BINARY_LITERAL14, 2);
        	                  expr = MK_CONST( BitVector(binString, 2) ); 
        	        }


        	    }
        	    break;
        	case 14:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1108:5: str[s,false]
        	    {
        	        FOLLOWPUSH(FOLLOW_str_in_term2437);
        	        str(ctx, s, false);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             expr = MK_CONST( ::CVC4::String(s) ); 
        	        }


        	    }
        	    break;
        	case 15:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1111:5: RENOSTR_TOK
        	    {
        	         MATCHT(RENOSTR_TOK, &FOLLOW_RENOSTR_TOK_in_term2451);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector< Expr > nvec; expr = MK_EXPR( CVC4::kind::REGEXP_EMPTY, nvec ); 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1114:5: REALLCHAR_TOK
        	    {
        	         MATCHT(REALLCHAR_TOK, &FOLLOW_REALLCHAR_TOK_in_term2464);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             std::vector< Expr > nvec; expr = MK_EXPR( CVC4::kind::REGEXP_SIGMA, nvec ); 
        	        }


        	    }
        	    break;
        	case 17:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1117:5: EMPTYSET_TOK
        	    {
        	         MATCHT(EMPTYSET_TOK, &FOLLOW_EMPTYSET_TOK_in_term2477);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruletermEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             expr = MK_CONST( ::CVC4::EmptySet(Type())); 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruletermEx; /* Prevent compiler warnings */
    ruletermEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end term */

/**
 * $ANTLR start attribute
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1126:1: attribute[CVC4::Expr& expr,CVC4::Expr& retExpr, std::string& attr] : ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] );
 */
static void
attribute(pSmt2Parser ctx, CVC4::Expr& expr, CVC4::Expr& retExpr, std::string& attr)
{
    pANTLR3_COMMON_TOKEN    KEYWORD15;

    /* Initialize rule variables
     */


      SExpr sexpr;
      Expr patexpr;
      std::vector<Expr> patexprs;
      Expr e2;
      bool hasValue = false;

    KEYWORD15       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1134:3: ( KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )? | ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NO_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK | ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr] )

            ANTLR3_UINT32 alt33;

            alt33=4;

            switch ( LA(1) )
            {
            case KEYWORD:
            	{
            		alt33=1;
            	}
                break;
            case ATTRIBUTE_PATTERN_TOK:
            	{
            		alt33=2;
            	}
                break;
            case ATTRIBUTE_NO_PATTERN_TOK:
            	{
            		alt33=3;
            	}
                break;
            case ATTRIBUTE_NAMED_TOK:
            	{
            		alt33=4;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 33;
                EXCEPTION->state        = 0;


                goto ruleattributeEx;

            }

            switch (alt33)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1134:5: KEYWORD ( simpleSymbolicExprNoKeyword[sexpr] )?
        	    {
        	        KEYWORD15 = (pANTLR3_COMMON_TOKEN) MATCHT(KEYWORD, &FOLLOW_KEYWORD_in_attribute2510);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1134:13: ( simpleSymbolicExprNoKeyword[sexpr] )?
        	        {
        	            int alt30=2;
        	            switch ( LA(1) )
        	            {
        	                case ABS_TOK:
        	                case AND_TOK:
        	                case ASSERT_TOK:
        	                case BINARY_LITERAL:
        	                case BV2NAT_TOK:
        	                case BVADD_TOK:
        	                case BVAND_TOK:
        	                case BVASHR_TOK:
        	                case BVCOMP_TOK:
        	                case BVLSHR_TOK:
        	                case BVMUL_TOK:
        	                case BVNAND_TOK:
        	                case BVNEG_TOK:
        	                case BVNOR_TOK:
        	                case BVNOT_TOK:
        	                case BVOR_TOK:
        	                case BVSDIV_TOK:
        	                case BVSGE_TOK:
        	                case BVSGT_TOK:
        	                case BVSHL_TOK:
        	                case BVSLE_TOK:
        	                case BVSLT_TOK:
        	                case BVSMOD_TOK:
        	                case BVSREM_TOK:
        	                case BVSUB_TOK:
        	                case BVUDIV_TOK:
        	                case BVUGE_TOK:
        	                case BVUGT_TOK:
        	                case BVULE_TOK:
        	                case BVULT_TOK:
        	                case BVUREM_TOK:
        	                case BVXNOR_TOK:
        	                case BVXOR_TOK:
        	                case CHECKSAT_TOK:
        	                case CONCAT_TOK:
        	                case DECIMAL_LITERAL:
        	                case DECLARE_DATATYPES_TOK:
        	                case DECLARE_FUN_TOK:
        	                case DECLARE_SORT_TOK:
        	                case DEFINE_FUN_TOK:
        	                case DEFINE_SORT_TOK:
        	                case DISTINCT_TOK:
        	                case DIV_TOK:
        	                case ECHO_TOK:
        	                case EQUAL_TOK:
        	                case EXIT_TOK:
        	                case FMFCARD_TOK:
        	                case GET_ASSERTIONS_TOK:
        	                case GET_ASSIGNMENT_TOK:
        	                case GET_INFO_TOK:
        	                case GET_MODEL_TOK:
        	                case GET_OPTION_TOK:
        	                case GET_PROOF_TOK:
        	                case GET_UNSAT_CORE_TOK:
        	                case GET_VALUE_TOK:
        	                case GREATER_THAN_EQUAL_TOK:
        	                case GREATER_THAN_TOK:
        	                case HEX_LITERAL:
        	                case IMPLIES_TOK:
        	                case INTEGER_LITERAL:
        	                case INTS_DIV_TOK:
        	                case INTS_MOD_TOK:
        	                case IS_INT_TOK:
        	                case ITE_TOK:
        	                case LESS_THAN_EQUAL_TOK:
        	                case LESS_THAN_TOK:
        	                case MINUS_TOK:
        	                case NOT_TOK:
        	                case OR_TOK:
        	                case PLUS_TOK:
        	                case POP_TOK:
        	                case PROPAGATION_RULE_TOK:
        	                case PUSH_TOK:
        	                case QUOTED_SYMBOL:
        	                case RECON_TOK:
        	                case REDUCTION_RULE_TOK:
        	                case REINTER_TOK:
        	                case RELOOP_TOK:
        	                case REOPT_TOK:
        	                case REPLUS_TOK:
        	                case RERANGE_TOK:
        	                case RESTAR_TOK:
        	                case REUNION_TOK:
        	                case REWRITE_RULE_TOK:
        	                case SELECT_TOK:
        	                case SET_INFO_TOK:
        	                case SET_LOGIC_TOK:
        	                case SET_OPTION_TOK:
        	                case SIMPLE_SYMBOL:
        	                case SIMPLIFY_TOK:
        	                case STAR_TOK:
        	                case STORE_TOK:
        	                case STRCAT_TOK:
        	                case STRCON_TOK:
        	                case STRCTN_TOK:
        	                case STRIDOF_TOK:
        	                case STRING_LITERAL:
        	                case STRINRE_TOK:
        	                case STRITOS_TOK:
        	                case STRLEN_TOK:
        	                case STRPREF_TOK:
        	                case STRREPL_TOK:
        	                case STRSTOI_TOK:
        	                case STRSTOU16_TOK:
        	                case STRSTOU32_TOK:
        	                case STRSUB_TOK:
        	                case STRSUFF_TOK:
        	                case STRTORE_TOK:
        	                case STRU16TOS_TOK:
        	                case STRU32TOS_TOK:
        	                case TO_INT_TOK:
        	                case TO_REAL_TOK:
        	                case UNTERMINATED_QUOTED_SYMBOL:
        	                case XOR_TOK:
        	                case 156:
        	                	{
        	                		alt30=1;
        	                	}
        	                    break;
        	            }

        	            switch (alt30)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1134:15: simpleSymbolicExprNoKeyword[sexpr]
        	        	    {
        	        	        FOLLOWPUSH(FOLLOW_simpleSymbolicExprNoKeyword_in_attribute2514);
        	        	        simpleSymbolicExprNoKeyword(ctx, sexpr);

        	        	        FOLLOWPOP();
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto ruleattributeEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             hasValue = true; 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	        if ( BACKTRACKING==0 )
        	        {

        	                attr = AntlrInput::tokenText(KEYWORD15);
        	                // EXPR_MANAGER->setNamedAttribute( expr, attr );
        	                if(attr == ":rewrite-rule") {
        	                  if(hasValue) {
        	                    std::stringstream ss;
        	                    ss << "warning: Attribute " << attr << " does not take a value (ignoring)";
        	                    PARSER_STATE->warning(ss.str());
        	                  }
        	                  // do nothing
        	                } else if(attr == ":axiom" || attr == ":conjecture") {
        	                  if(hasValue) {
        	                    std::stringstream ss;
        	                    ss << "warning: Attribute " << attr << " does not take a value (ignoring)";
        	                    PARSER_STATE->warning(ss.str());
        	                  }
        	                  std::string attr_name = attr;
        	                  attr_name.erase( attr_name.begin() );
        	                  Command* c = new SetUserAttributeCommand( attr_name, expr );
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                } else {
        	                  PARSER_STATE->attributeNotSupported(attr);
        	                }
        	              
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1160:5: ATTRIBUTE_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK
        	    {
        	         MATCHT(ATTRIBUTE_PATTERN_TOK, &FOLLOW_ATTRIBUTE_PATTERN_TOK_in_attribute2530);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_attribute2532);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1160:38: ( term[patexpr, e2] )+
        	        {
        	            int cnt31=0;

        	            for (;;)
        	            {
        	                int alt31=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case DECIMAL_LITERAL:
        	        	case EMPTYSET_TOK:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case LPAREN_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case REALLCHAR_TOK:
        	        	case RENOSTR_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 156:
        	        		{
        	        			alt31=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt31)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1160:40: term[patexpr, e2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_attribute2536);
        	        	            term(ctx, patexpr, e2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleattributeEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	            if ( BACKTRACKING==0 )
        	        	            {
        	        	                 patexprs.push_back( patexpr ); 
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt31 >= 1 )
        	        		{
        	        		    goto loop31;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleattributeEx;
        	        	}
        	        	cnt31++;
        	            }
        	            loop31: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_attribute2545);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  attr = std::string(":pattern");
        	                  retExpr = MK_EXPR(kind::INST_PATTERN, patexprs);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1165:5: ATTRIBUTE_NO_PATTERN_TOK LPAREN_TOK ( term[patexpr, e2] )+ RPAREN_TOK
        	    {
        	         MATCHT(ATTRIBUTE_NO_PATTERN_TOK, &FOLLOW_ATTRIBUTE_NO_PATTERN_TOK_in_attribute2557);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_attribute2559);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1165:41: ( term[patexpr, e2] )+
        	        {
        	            int cnt32=0;

        	            for (;;)
        	            {
        	                int alt32=2;
        	        	switch ( LA(1) )
        	        	{
        	        	case BINARY_LITERAL:
        	        	case DECIMAL_LITERAL:
        	        	case EMPTYSET_TOK:
        	        	case HEX_LITERAL:
        	        	case INTEGER_LITERAL:
        	        	case LPAREN_TOK:
        	        	case QUOTED_SYMBOL:
        	        	case REALLCHAR_TOK:
        	        	case RENOSTR_TOK:
        	        	case SIMPLE_SYMBOL:
        	        	case STRING_LITERAL:
        	        	case UNTERMINATED_QUOTED_SYMBOL:
        	        	case 156:
        	        		{
        	        			alt32=1;
        	        		}
        	        	    break;

        	        	}

        	        	switch (alt32)
        	        	{
        	        	    case 1:
        	        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1165:41: term[patexpr, e2]
        	        	        {
        	        	            FOLLOWPUSH(FOLLOW_term_in_attribute2561);
        	        	            term(ctx, patexpr, e2);

        	        	            FOLLOWPOP();
        	        	            if  (HASEXCEPTION())
        	        	            {
        	        	                goto ruleattributeEx;
        	        	            }
        	        	            if (HASFAILED())
        	        	            {
        	        	                return ;
        	        	            }


        	        	        }
        	        	        break;

        	        	    default:

        	        		if ( cnt32 >= 1 )
        	        		{
        	        		    goto loop32;
        	        		}
        	        		if (BACKTRACKING>0)
        	        		{
        	        		    FAILEDFLAG = ANTLR3_TRUE;
        	        		    return ;
        	        		}

        	        		/* mismatchedSetEx()
        	        		 */
        	        		CONSTRUCTEX();
        	        		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
        	        		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


        	        		goto ruleattributeEx;
        	        	}
        	        	cnt32++;
        	            }
        	            loop32: ;	/* Jump to here if this rule does not match */
        	        }

        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_attribute2565);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  attr = std::string(":no-pattern");
        	                  PARSER_STATE->attributeNotSupported(attr);
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1170:5: ATTRIBUTE_NAMED_TOK symbolicExpr[sexpr]
        	    {
        	         MATCHT(ATTRIBUTE_NAMED_TOK, &FOLLOW_ATTRIBUTE_NAMED_TOK_in_attribute2577);
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbolicExpr_in_attribute2579);
        	        symbolicExpr(ctx, sexpr);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto ruleattributeEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  attr = std::string(":named");
        	                  if(!sexpr.isKeyword()) {
        	                    PARSER_STATE->parseError("improperly formed :named annotation");
        	                  }
        	                  std::string name = sexpr.getValue();
        	                  PARSER_STATE->checkUserSymbol(name);
        	                  // ensure expr is a closed subterm
        	                  std::set<Expr> freeVars;
        	                  if(!isClosed(expr, freeVars)) {
        	                    assert(!freeVars.empty());
        	                    std::stringstream ss;
        	                    ss << ":named annotations can only name terms that are closed; this one contains free variables:";
        	                    for(std::set<Expr>::const_iterator i = freeVars.begin(); i != freeVars.end(); ++i) {
        	                      ss << " " << *i;
        	                    }
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                  // check that sexpr is a fresh function symbol, and reserve it
        	                  PARSER_STATE->reserveSymbolAtAssertionLevel(name);
        	                  // define it
        	                  Expr func = PARSER_STATE->mkFunction(name, expr.getType());
        	                  // bind name to expr with define-fun
        	                  Command* c =
        	                    new DefineNamedFunctionCommand(name, func, std::vector<Expr>(), expr);
        	                  c->setMuted(true);
        	                  PARSER_STATE->preemptCommand(c);
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto ruleattributeEx; /* Prevent compiler warnings */
    ruleattributeEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end attribute */

/**
 * $ANTLR start indexedFunctionName
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1204:1: indexedFunctionName[CVC4::Expr& op] : LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | ( 'repeat' INTEGER_LITERAL )=> 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | badIndexedFunctionName ) RPAREN_TOK ;
 */
static void
indexedFunctionName(pSmt2Parser ctx, CVC4::Expr& op)
{
    pANTLR3_COMMON_TOKEN    n1;
    pANTLR3_COMMON_TOKEN    n2;
    pANTLR3_COMMON_TOKEN    n;

    /* Initialize rule variables
     */

    n1       = NULL;
    n2       = NULL;
    n       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1205:3: ( LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | ( 'repeat' INTEGER_LITERAL )=> 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | badIndexedFunctionName ) RPAREN_TOK )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1205:5: LPAREN_TOK INDEX_TOK ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | ( 'repeat' INTEGER_LITERAL )=> 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | badIndexedFunctionName ) RPAREN_TOK
        {
             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_indexedFunctionName2602);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }
            if (HASFAILED())
            {
                return ;
            }


             MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_indexedFunctionName2604);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1206:5: ( 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL | ( 'repeat' INTEGER_LITERAL )=> 'repeat' n= INTEGER_LITERAL | 'zero_extend' n= INTEGER_LITERAL | 'sign_extend' n= INTEGER_LITERAL | 'rotate_left' n= INTEGER_LITERAL | 'rotate_right' n= INTEGER_LITERAL | DIVISIBLE_TOK n= INTEGER_LITERAL | INT2BV_TOK n= INTEGER_LITERAL | badIndexedFunctionName )
            {
                int alt34=9;
                switch ( LA(1) )
                {
                case 155:
                	{
                		alt34=1;
                	}
                    break;
                case 156:
                	{
                		switch ( LA(2) )
                		{
                		case INTEGER_LITERAL:
                			{
                				{
                				    int LA34_12 = LA(3);
                				    if ( (synpred1_Smt2(ctx)))
                				    {
                				        alt34=2;
                				    }
                				    else if ( (ANTLR3_TRUE))
                				    {
                				        alt34=9;
                				    }
                				    else
                				    {
                				        if (BACKTRACKING>0)
                				        {
                				            FAILEDFLAG = ANTLR3_TRUE;
                				            return ;
                				        }


                				        CONSTRUCTEX();
                				        EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                				        EXCEPTION->message      = (void *)"";
                				        EXCEPTION->decisionNum  = 34;
                				        EXCEPTION->state        = 12;


                				        goto ruleindexedFunctionNameEx;

                				    }
                				}
                			}
                		    break;

                		default:
                		    if (BACKTRACKING>0)
                		    {
                		        FAILEDFLAG = ANTLR3_TRUE;
                		        return ;
                		    }

                		    CONSTRUCTEX();
                		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                		    EXCEPTION->message      = (void *)"";
                		    EXCEPTION->decisionNum  = 34;
                		    EXCEPTION->state        = 2;


                		    goto ruleindexedFunctionNameEx;

                		}

                	}
                    break;
                case 160:
                	{
                		alt34=3;
                	}
                    break;
                case 159:
                	{
                		alt34=4;
                	}
                    break;
                case 157:
                	{
                		alt34=5;
                	}
                    break;
                case 158:
                	{
                		alt34=6;
                	}
                    break;
                case DIVISIBLE_TOK:
                	{
                		alt34=7;
                	}
                    break;
                case INT2BV_TOK:
                	{
                		alt34=8;
                	}
                    break;
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                	{
                		alt34=9;
                	}
                    break;

                default:
                    if (BACKTRACKING>0)
                    {
                        FAILEDFLAG = ANTLR3_TRUE;
                        return ;
                    }

                    CONSTRUCTEX();
                    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                    EXCEPTION->message      = (void *)"";
                    EXCEPTION->decisionNum  = 34;
                    EXCEPTION->state        = 0;


                    goto ruleindexedFunctionNameEx;

                }

                switch (alt34)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1206:7: 'extract' n1= INTEGER_LITERAL n2= INTEGER_LITERAL
            	    {
            	         MATCHT(155, &FOLLOW_155_in_indexedFunctionName2612);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n1 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2616);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n2 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2620);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(BitVectorExtract(AntlrInput::tokenToUnsigned(n1),
            	                                                   AntlrInput::tokenToUnsigned(n2))); 
            	        }


            	    }
            	    break;
            	case 2:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1209:7: ( 'repeat' INTEGER_LITERAL )=> 'repeat' n= INTEGER_LITERAL
            	    {
            	         MATCHT(156, &FOLLOW_156_in_indexedFunctionName2642);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2646);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(BitVectorRepeat(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 3:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1211:7: 'zero_extend' n= INTEGER_LITERAL
            	    {
            	         MATCHT(160, &FOLLOW_160_in_indexedFunctionName2662);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2666);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(BitVectorZeroExtend(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 4:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1213:7: 'sign_extend' n= INTEGER_LITERAL
            	    {
            	         MATCHT(159, &FOLLOW_159_in_indexedFunctionName2682);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2686);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(BitVectorSignExtend(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 5:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1215:7: 'rotate_left' n= INTEGER_LITERAL
            	    {
            	         MATCHT(157, &FOLLOW_157_in_indexedFunctionName2702);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2706);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(BitVectorRotateLeft(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 6:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1217:7: 'rotate_right' n= INTEGER_LITERAL
            	    {
            	         MATCHT(158, &FOLLOW_158_in_indexedFunctionName2722);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2726);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(BitVectorRotateRight(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 7:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1219:7: DIVISIBLE_TOK n= INTEGER_LITERAL
            	    {
            	         MATCHT(DIVISIBLE_TOK, &FOLLOW_DIVISIBLE_TOK_in_indexedFunctionName2742);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2746);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(Divisible(AntlrInput::tokenToUnsigned(n))); 
            	        }


            	    }
            	    break;
            	case 8:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1221:7: INT2BV_TOK n= INTEGER_LITERAL
            	    {
            	         MATCHT(INT2BV_TOK, &FOLLOW_INT2BV_TOK_in_indexedFunctionName2762);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        n = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_indexedFunctionName2766);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             op = MK_CONST(IntToBitVector(AntlrInput::tokenToUnsigned(n)));
            	                    if(PARSER_STATE->strictModeEnabled()) {
            	                      PARSER_STATE->parseError("bv2nat and int2bv are not part of SMT-LIB, and aren't available in SMT-LIB strict compliance mode");
            	                    } 
            	        }


            	    }
            	    break;
            	case 9:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1226:7: badIndexedFunctionName
            	    {
            	        FOLLOWPUSH(FOLLOW_badIndexedFunctionName_in_indexedFunctionName2782);
            	        badIndexedFunctionName(ctx);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleindexedFunctionNameEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

                }
            }

             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_indexedFunctionName2793);
            if  (HASEXCEPTION())
            {
                goto ruleindexedFunctionNameEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleindexedFunctionNameEx; /* Prevent compiler warnings */
    ruleindexedFunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end indexedFunctionName */

/**
 * $ANTLR start badIndexedFunctionName
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1235:1: badIndexedFunctionName : symbol[name,CHECK_NONE,SYM_VARIABLE] ( INTEGER_LITERAL )+ ;
 */
static void
badIndexedFunctionName(pSmt2Parser ctx)
{

      std::string name;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1239:3: ( symbol[name,CHECK_NONE,SYM_VARIABLE] ( INTEGER_LITERAL )+ )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1239:5: symbol[name,CHECK_NONE,SYM_VARIABLE] ( INTEGER_LITERAL )+
        {
            FOLLOWPUSH(FOLLOW_symbol_in_badIndexedFunctionName2813);
            symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulebadIndexedFunctionNameEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1239:42: ( INTEGER_LITERAL )+
            {
                int cnt35=0;

                for (;;)
                {
                    int alt35=2;
            	switch ( LA(1) )
            	{
            	case INTEGER_LITERAL:
            		{
            			alt35=1;
            		}
            	    break;

            	}

            	switch (alt35)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1239:42: INTEGER_LITERAL
            	        {
            	             MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_badIndexedFunctionName2816);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulebadIndexedFunctionNameEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt35 >= 1 )
            		{
            		    goto loop35;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulebadIndexedFunctionNameEx;
            	}
            	cnt35++;
                }
                loop35: ;	/* Jump to here if this rule does not match */
            }

            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->parseError(std::string("Unknown indexed function `") + name + "'"); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulebadIndexedFunctionNameEx; /* Prevent compiler warnings */
    rulebadIndexedFunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end badIndexedFunctionName */

/**
 * $ANTLR start termList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1251:1: termList[std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr] : ( term[expr, expr2] )+ ;
 */
static void
termList(pSmt2Parser ctx, std::vector<CVC4::Expr>& formulas, CVC4::Expr& expr)
{

      Expr expr2;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1255:3: ( ( term[expr, expr2] )+ )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1255:5: ( term[expr, expr2] )+
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1255:5: ( term[expr, expr2] )+
            {
                int cnt36=0;

                for (;;)
                {
                    int alt36=2;
            	switch ( LA(1) )
            	{
            	case BINARY_LITERAL:
            	case DECIMAL_LITERAL:
            	case EMPTYSET_TOK:
            	case HEX_LITERAL:
            	case INTEGER_LITERAL:
            	case LPAREN_TOK:
            	case QUOTED_SYMBOL:
            	case REALLCHAR_TOK:
            	case RENOSTR_TOK:
            	case SIMPLE_SYMBOL:
            	case STRING_LITERAL:
            	case UNTERMINATED_QUOTED_SYMBOL:
            	case 156:
            		{
            			alt36=1;
            		}
            	    break;

            	}

            	switch (alt36)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1255:7: term[expr, expr2]
            	        {
            	            FOLLOWPUSH(FOLLOW_term_in_termList2850);
            	            term(ctx, expr, expr2);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruletermListEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 formulas.push_back(expr); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt36 >= 1 )
            		{
            		    goto loop36;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruletermListEx;
            	}
            	cnt36++;
                }
                loop36: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto ruletermListEx; /* Prevent compiler warnings */
    ruletermListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end termList */

/**
 * $ANTLR start str
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1261:1: str[std::string& s, bool fsmtlib] : STRING_LITERAL ;
 */
static void
str(pSmt2Parser ctx, std::string& s, bool fsmtlib)
{
    pANTLR3_COMMON_TOKEN    STRING_LITERAL16;

    /* Initialize rule variables
     */

    STRING_LITERAL16       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1262:3: ( STRING_LITERAL )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1262:5: STRING_LITERAL
        {
            STRING_LITERAL16 = (pANTLR3_COMMON_TOKEN) MATCHT(STRING_LITERAL, &FOLLOW_STRING_LITERAL_in_str2872);
            if  (HASEXCEPTION())
            {
                goto rulestrEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 s = AntlrInput::tokenText(STRING_LITERAL16);
                      /* strip off the quotes */
                      s = s.substr(1, s.size() - 2);
                	  for(size_t i=0; i<s.size(); i++) {
                		if((unsigned)s[i] > 127) {
                			PARSER_STATE->parseError("Extended characters are not part of SMT-LIB, and they must be encoded as esacped sequences");
                		}
                	  }
                      if(fsmtlib) {
                        /* handle SMT-LIB standard escapes '\\' and '\"' */
                        char* p_orig = strdup(s.c_str());
                        char *p = p_orig, *q = p_orig;
                        while(*q != '\0') {
                          if(*q == '\\') {
                            ++q;
                            if(*q == '\\' || *q == '"') {
                              *p++ = *q++;
                            } else {
                              assert(*q != '\0');
                              *p++ = '\\';
                              *p++ = *q++;
                            }
                          } else {
                            *p++ = *q++;
                          }
                        }
                        *p = '\0';
                        s = p_orig;
                        free(p_orig);
                      }
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulestrEx; /* Prevent compiler warnings */
    rulestrEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end str */

/**
 * $ANTLR start builtinOp
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1299:1: builtinOp[CVC4::Kind& kind] : ( NOT_TOK | IMPLIES_TOK | AND_TOK | OR_TOK | XOR_TOK | EQUAL_TOK | DISTINCT_TOK | ITE_TOK | GREATER_THAN_TOK | GREATER_THAN_EQUAL_TOK | LESS_THAN_EQUAL_TOK | LESS_THAN_TOK | PLUS_TOK | MINUS_TOK | STAR_TOK | DIV_TOK | INTS_DIV_TOK | INTS_MOD_TOK | ABS_TOK | IS_INT_TOK | TO_INT_TOK | TO_REAL_TOK | SELECT_TOK | STORE_TOK | CONCAT_TOK | BVNOT_TOK | BVAND_TOK | BVOR_TOK | BVNEG_TOK | BVADD_TOK | BVMUL_TOK | BVUDIV_TOK | BVUREM_TOK | BVSHL_TOK | BVLSHR_TOK | BVULT_TOK | BVNAND_TOK | BVNOR_TOK | BVXOR_TOK | BVXNOR_TOK | BVCOMP_TOK | BVSUB_TOK | BVSDIV_TOK | BVSREM_TOK | BVSMOD_TOK | BVASHR_TOK | BVULE_TOK | BVUGT_TOK | BVUGE_TOK | BVSLT_TOK | BVSLE_TOK | BVSGT_TOK | BVSGE_TOK | BV2NAT_TOK | STRCON_TOK | STRLEN_TOK | STRSUB_TOK | STRCTN_TOK | STRCAT_TOK | STRIDOF_TOK | STRREPL_TOK | STRPREF_TOK | STRSUFF_TOK | STRITOS_TOK | STRSTOI_TOK | STRU16TOS_TOK | STRSTOU16_TOK | STRU32TOS_TOK | STRSTOU32_TOK | STRINRE_TOK | STRTORE_TOK | RECON_TOK | REUNION_TOK | REINTER_TOK | RESTAR_TOK | REPLUS_TOK | REOPT_TOK | RERANGE_TOK | RELOOP_TOK | FMFCARD_TOK );
 */
static void
builtinOp(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "builtin: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1303:3: ( NOT_TOK | IMPLIES_TOK | AND_TOK | OR_TOK | XOR_TOK | EQUAL_TOK | DISTINCT_TOK | ITE_TOK | GREATER_THAN_TOK | GREATER_THAN_EQUAL_TOK | LESS_THAN_EQUAL_TOK | LESS_THAN_TOK | PLUS_TOK | MINUS_TOK | STAR_TOK | DIV_TOK | INTS_DIV_TOK | INTS_MOD_TOK | ABS_TOK | IS_INT_TOK | TO_INT_TOK | TO_REAL_TOK | SELECT_TOK | STORE_TOK | CONCAT_TOK | BVNOT_TOK | BVAND_TOK | BVOR_TOK | BVNEG_TOK | BVADD_TOK | BVMUL_TOK | BVUDIV_TOK | BVUREM_TOK | BVSHL_TOK | BVLSHR_TOK | BVULT_TOK | BVNAND_TOK | BVNOR_TOK | BVXOR_TOK | BVXNOR_TOK | BVCOMP_TOK | BVSUB_TOK | BVSDIV_TOK | BVSREM_TOK | BVSMOD_TOK | BVASHR_TOK | BVULE_TOK | BVUGT_TOK | BVUGE_TOK | BVSLT_TOK | BVSLE_TOK | BVSGT_TOK | BVSGE_TOK | BV2NAT_TOK | STRCON_TOK | STRLEN_TOK | STRSUB_TOK | STRCTN_TOK | STRCAT_TOK | STRIDOF_TOK | STRREPL_TOK | STRPREF_TOK | STRSUFF_TOK | STRITOS_TOK | STRSTOI_TOK | STRU16TOS_TOK | STRSTOU16_TOK | STRU32TOS_TOK | STRSTOU32_TOK | STRINRE_TOK | STRTORE_TOK | RECON_TOK | REUNION_TOK | REINTER_TOK | RESTAR_TOK | REPLUS_TOK | REOPT_TOK | RERANGE_TOK | RELOOP_TOK | FMFCARD_TOK )

            ANTLR3_UINT32 alt37;

            alt37=80;

            switch ( LA(1) )
            {
            case NOT_TOK:
            	{
            		alt37=1;
            	}
                break;
            case IMPLIES_TOK:
            	{
            		alt37=2;
            	}
                break;
            case AND_TOK:
            	{
            		alt37=3;
            	}
                break;
            case OR_TOK:
            	{
            		alt37=4;
            	}
                break;
            case XOR_TOK:
            	{
            		alt37=5;
            	}
                break;
            case EQUAL_TOK:
            	{
            		alt37=6;
            	}
                break;
            case DISTINCT_TOK:
            	{
            		alt37=7;
            	}
                break;
            case ITE_TOK:
            	{
            		alt37=8;
            	}
                break;
            case GREATER_THAN_TOK:
            	{
            		alt37=9;
            	}
                break;
            case GREATER_THAN_EQUAL_TOK:
            	{
            		alt37=10;
            	}
                break;
            case LESS_THAN_EQUAL_TOK:
            	{
            		alt37=11;
            	}
                break;
            case LESS_THAN_TOK:
            	{
            		alt37=12;
            	}
                break;
            case PLUS_TOK:
            	{
            		alt37=13;
            	}
                break;
            case MINUS_TOK:
            	{
            		alt37=14;
            	}
                break;
            case STAR_TOK:
            	{
            		alt37=15;
            	}
                break;
            case DIV_TOK:
            	{
            		alt37=16;
            	}
                break;
            case INTS_DIV_TOK:
            	{
            		alt37=17;
            	}
                break;
            case INTS_MOD_TOK:
            	{
            		alt37=18;
            	}
                break;
            case ABS_TOK:
            	{
            		alt37=19;
            	}
                break;
            case IS_INT_TOK:
            	{
            		alt37=20;
            	}
                break;
            case TO_INT_TOK:
            	{
            		alt37=21;
            	}
                break;
            case TO_REAL_TOK:
            	{
            		alt37=22;
            	}
                break;
            case SELECT_TOK:
            	{
            		alt37=23;
            	}
                break;
            case STORE_TOK:
            	{
            		alt37=24;
            	}
                break;
            case CONCAT_TOK:
            	{
            		alt37=25;
            	}
                break;
            case BVNOT_TOK:
            	{
            		alt37=26;
            	}
                break;
            case BVAND_TOK:
            	{
            		alt37=27;
            	}
                break;
            case BVOR_TOK:
            	{
            		alt37=28;
            	}
                break;
            case BVNEG_TOK:
            	{
            		alt37=29;
            	}
                break;
            case BVADD_TOK:
            	{
            		alt37=30;
            	}
                break;
            case BVMUL_TOK:
            	{
            		alt37=31;
            	}
                break;
            case BVUDIV_TOK:
            	{
            		alt37=32;
            	}
                break;
            case BVUREM_TOK:
            	{
            		alt37=33;
            	}
                break;
            case BVSHL_TOK:
            	{
            		alt37=34;
            	}
                break;
            case BVLSHR_TOK:
            	{
            		alt37=35;
            	}
                break;
            case BVULT_TOK:
            	{
            		alt37=36;
            	}
                break;
            case BVNAND_TOK:
            	{
            		alt37=37;
            	}
                break;
            case BVNOR_TOK:
            	{
            		alt37=38;
            	}
                break;
            case BVXOR_TOK:
            	{
            		alt37=39;
            	}
                break;
            case BVXNOR_TOK:
            	{
            		alt37=40;
            	}
                break;
            case BVCOMP_TOK:
            	{
            		alt37=41;
            	}
                break;
            case BVSUB_TOK:
            	{
            		alt37=42;
            	}
                break;
            case BVSDIV_TOK:
            	{
            		alt37=43;
            	}
                break;
            case BVSREM_TOK:
            	{
            		alt37=44;
            	}
                break;
            case BVSMOD_TOK:
            	{
            		alt37=45;
            	}
                break;
            case BVASHR_TOK:
            	{
            		alt37=46;
            	}
                break;
            case BVULE_TOK:
            	{
            		alt37=47;
            	}
                break;
            case BVUGT_TOK:
            	{
            		alt37=48;
            	}
                break;
            case BVUGE_TOK:
            	{
            		alt37=49;
            	}
                break;
            case BVSLT_TOK:
            	{
            		alt37=50;
            	}
                break;
            case BVSLE_TOK:
            	{
            		alt37=51;
            	}
                break;
            case BVSGT_TOK:
            	{
            		alt37=52;
            	}
                break;
            case BVSGE_TOK:
            	{
            		alt37=53;
            	}
                break;
            case BV2NAT_TOK:
            	{
            		alt37=54;
            	}
                break;
            case STRCON_TOK:
            	{
            		alt37=55;
            	}
                break;
            case STRLEN_TOK:
            	{
            		alt37=56;
            	}
                break;
            case STRSUB_TOK:
            	{
            		alt37=57;
            	}
                break;
            case STRCTN_TOK:
            	{
            		alt37=58;
            	}
                break;
            case STRCAT_TOK:
            	{
            		alt37=59;
            	}
                break;
            case STRIDOF_TOK:
            	{
            		alt37=60;
            	}
                break;
            case STRREPL_TOK:
            	{
            		alt37=61;
            	}
                break;
            case STRPREF_TOK:
            	{
            		alt37=62;
            	}
                break;
            case STRSUFF_TOK:
            	{
            		alt37=63;
            	}
                break;
            case STRITOS_TOK:
            	{
            		alt37=64;
            	}
                break;
            case STRSTOI_TOK:
            	{
            		alt37=65;
            	}
                break;
            case STRU16TOS_TOK:
            	{
            		alt37=66;
            	}
                break;
            case STRSTOU16_TOK:
            	{
            		alt37=67;
            	}
                break;
            case STRU32TOS_TOK:
            	{
            		alt37=68;
            	}
                break;
            case STRSTOU32_TOK:
            	{
            		alt37=69;
            	}
                break;
            case STRINRE_TOK:
            	{
            		alt37=70;
            	}
                break;
            case STRTORE_TOK:
            	{
            		alt37=71;
            	}
                break;
            case RECON_TOK:
            	{
            		alt37=72;
            	}
                break;
            case REUNION_TOK:
            	{
            		alt37=73;
            	}
                break;
            case REINTER_TOK:
            	{
            		alt37=74;
            	}
                break;
            case RESTAR_TOK:
            	{
            		alt37=75;
            	}
                break;
            case REPLUS_TOK:
            	{
            		alt37=76;
            	}
                break;
            case REOPT_TOK:
            	{
            		alt37=77;
            	}
                break;
            case RERANGE_TOK:
            	{
            		alt37=78;
            	}
                break;
            case RELOOP_TOK:
            	{
            		alt37=79;
            	}
                break;
            case FMFCARD_TOK:
            	{
            		alt37=80;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 37;
                EXCEPTION->state        = 0;


                goto rulebuiltinOpEx;

            }

            switch (alt37)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1303:5: NOT_TOK
        	    {
        	         MATCHT(NOT_TOK, &FOLLOW_NOT_TOK_in_builtinOp2899);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::NOT;     
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1304:5: IMPLIES_TOK
        	    {
        	         MATCHT(IMPLIES_TOK, &FOLLOW_IMPLIES_TOK_in_builtinOp2912);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::IMPLIES; 
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1305:5: AND_TOK
        	    {
        	         MATCHT(AND_TOK, &FOLLOW_AND_TOK_in_builtinOp2921);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::AND;     
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1306:5: OR_TOK
        	    {
        	         MATCHT(OR_TOK, &FOLLOW_OR_TOK_in_builtinOp2934);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::OR;      
        	        }


        	    }
        	    break;
        	case 5:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1307:5: XOR_TOK
        	    {
        	         MATCHT(XOR_TOK, &FOLLOW_XOR_TOK_in_builtinOp2948);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::XOR;     
        	        }


        	    }
        	    break;
        	case 6:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1308:5: EQUAL_TOK
        	    {
        	         MATCHT(EQUAL_TOK, &FOLLOW_EQUAL_TOK_in_builtinOp2961);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::EQUAL;   
        	        }


        	    }
        	    break;
        	case 7:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1309:5: DISTINCT_TOK
        	    {
        	         MATCHT(DISTINCT_TOK, &FOLLOW_DISTINCT_TOK_in_builtinOp2972);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::DISTINCT; 
        	        }


        	    }
        	    break;
        	case 8:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1310:5: ITE_TOK
        	    {
        	         MATCHT(ITE_TOK, &FOLLOW_ITE_TOK_in_builtinOp2980);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::ITE; 
        	        }


        	    }
        	    break;
        	case 9:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1311:5: GREATER_THAN_TOK
        	    {
        	         MATCHT(GREATER_THAN_TOK, &FOLLOW_GREATER_THAN_TOK_in_builtinOp2993);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::GT; 
        	        }


        	    }
        	    break;
        	case 10:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1313:5: GREATER_THAN_EQUAL_TOK
        	    {
        	         MATCHT(GREATER_THAN_EQUAL_TOK, &FOLLOW_GREATER_THAN_EQUAL_TOK_in_builtinOp3018);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::GEQ; 
        	        }


        	    }
        	    break;
        	case 11:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1315:5: LESS_THAN_EQUAL_TOK
        	    {
        	         MATCHT(LESS_THAN_EQUAL_TOK, &FOLLOW_LESS_THAN_EQUAL_TOK_in_builtinOp3043);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::LEQ; 
        	        }


        	    }
        	    break;
        	case 12:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1317:5: LESS_THAN_TOK
        	    {
        	         MATCHT(LESS_THAN_TOK, &FOLLOW_LESS_THAN_TOK_in_builtinOp3068);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::LT; 
        	        }


        	    }
        	    break;
        	case 13:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1319:5: PLUS_TOK
        	    {
        	         MATCHT(PLUS_TOK, &FOLLOW_PLUS_TOK_in_builtinOp3093);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::PLUS; 
        	        }


        	    }
        	    break;
        	case 14:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1320:5: MINUS_TOK
        	    {
        	         MATCHT(MINUS_TOK, &FOLLOW_MINUS_TOK_in_builtinOp3105);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::MINUS; 
        	        }


        	    }
        	    break;
        	case 15:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1321:5: STAR_TOK
        	    {
        	         MATCHT(STAR_TOK, &FOLLOW_STAR_TOK_in_builtinOp3116);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::MULT; 
        	        }


        	    }
        	    break;
        	case 16:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1322:5: DIV_TOK
        	    {
        	         MATCHT(DIV_TOK, &FOLLOW_DIV_TOK_in_builtinOp3128);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::DIVISION; 
        	        }


        	    }
        	    break;
        	case 17:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1323:5: INTS_DIV_TOK
        	    {
        	         MATCHT(INTS_DIV_TOK, &FOLLOW_INTS_DIV_TOK_in_builtinOp3141);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::INTS_DIVISION; 
        	        }


        	    }
        	    break;
        	case 18:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1324:5: INTS_MOD_TOK
        	    {
        	         MATCHT(INTS_MOD_TOK, &FOLLOW_INTS_MOD_TOK_in_builtinOp3154);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::INTS_MODULUS; 
        	        }


        	    }
        	    break;
        	case 19:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1325:5: ABS_TOK
        	    {
        	         MATCHT(ABS_TOK, &FOLLOW_ABS_TOK_in_builtinOp3167);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::ABS; 
        	        }


        	    }
        	    break;
        	case 20:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1326:5: IS_INT_TOK
        	    {
        	         MATCHT(IS_INT_TOK, &FOLLOW_IS_INT_TOK_in_builtinOp3180);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::IS_INTEGER; 
        	        }


        	    }
        	    break;
        	case 21:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1327:5: TO_INT_TOK
        	    {
        	         MATCHT(TO_INT_TOK, &FOLLOW_TO_INT_TOK_in_builtinOp3190);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::TO_INTEGER; 
        	        }


        	    }
        	    break;
        	case 22:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1328:5: TO_REAL_TOK
        	    {
        	         MATCHT(TO_REAL_TOK, &FOLLOW_TO_REAL_TOK_in_builtinOp3200);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::TO_REAL; 
        	        }


        	    }
        	    break;
        	case 23:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1330:5: SELECT_TOK
        	    {
        	         MATCHT(SELECT_TOK, &FOLLOW_SELECT_TOK_in_builtinOp3210);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::SELECT; 
        	        }


        	    }
        	    break;
        	case 24:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1331:5: STORE_TOK
        	    {
        	         MATCHT(STORE_TOK, &FOLLOW_STORE_TOK_in_builtinOp3220);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STORE; 
        	        }


        	    }
        	    break;
        	case 25:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1333:5: CONCAT_TOK
        	    {
        	         MATCHT(CONCAT_TOK, &FOLLOW_CONCAT_TOK_in_builtinOp3232);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_CONCAT; 
        	        }


        	    }
        	    break;
        	case 26:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1334:5: BVNOT_TOK
        	    {
        	         MATCHT(BVNOT_TOK, &FOLLOW_BVNOT_TOK_in_builtinOp3242);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_NOT; 
        	        }


        	    }
        	    break;
        	case 27:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1335:5: BVAND_TOK
        	    {
        	         MATCHT(BVAND_TOK, &FOLLOW_BVAND_TOK_in_builtinOp3252);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_AND; 
        	        }


        	    }
        	    break;
        	case 28:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1336:5: BVOR_TOK
        	    {
        	         MATCHT(BVOR_TOK, &FOLLOW_BVOR_TOK_in_builtinOp3262);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_OR; 
        	        }


        	    }
        	    break;
        	case 29:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1337:5: BVNEG_TOK
        	    {
        	         MATCHT(BVNEG_TOK, &FOLLOW_BVNEG_TOK_in_builtinOp3272);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_NEG; 
        	        }


        	    }
        	    break;
        	case 30:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1338:5: BVADD_TOK
        	    {
        	         MATCHT(BVADD_TOK, &FOLLOW_BVADD_TOK_in_builtinOp3282);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_PLUS; 
        	        }


        	    }
        	    break;
        	case 31:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1339:5: BVMUL_TOK
        	    {
        	         MATCHT(BVMUL_TOK, &FOLLOW_BVMUL_TOK_in_builtinOp3292);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_MULT; 
        	        }


        	    }
        	    break;
        	case 32:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1340:5: BVUDIV_TOK
        	    {
        	         MATCHT(BVUDIV_TOK, &FOLLOW_BVUDIV_TOK_in_builtinOp3302);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_UDIV; 
        	        }


        	    }
        	    break;
        	case 33:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1341:5: BVUREM_TOK
        	    {
        	         MATCHT(BVUREM_TOK, &FOLLOW_BVUREM_TOK_in_builtinOp3312);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_UREM; 
        	        }


        	    }
        	    break;
        	case 34:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1342:5: BVSHL_TOK
        	    {
        	         MATCHT(BVSHL_TOK, &FOLLOW_BVSHL_TOK_in_builtinOp3322);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SHL; 
        	        }


        	    }
        	    break;
        	case 35:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1343:5: BVLSHR_TOK
        	    {
        	         MATCHT(BVLSHR_TOK, &FOLLOW_BVLSHR_TOK_in_builtinOp3334);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_LSHR; 
        	        }


        	    }
        	    break;
        	case 36:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1344:5: BVULT_TOK
        	    {
        	         MATCHT(BVULT_TOK, &FOLLOW_BVULT_TOK_in_builtinOp3346);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_ULT; 
        	        }


        	    }
        	    break;
        	case 37:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1345:5: BVNAND_TOK
        	    {
        	         MATCHT(BVNAND_TOK, &FOLLOW_BVNAND_TOK_in_builtinOp3358);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_NAND; 
        	        }


        	    }
        	    break;
        	case 38:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1346:5: BVNOR_TOK
        	    {
        	         MATCHT(BVNOR_TOK, &FOLLOW_BVNOR_TOK_in_builtinOp3370);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_NOR; 
        	        }


        	    }
        	    break;
        	case 39:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1347:5: BVXOR_TOK
        	    {
        	         MATCHT(BVXOR_TOK, &FOLLOW_BVXOR_TOK_in_builtinOp3382);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_XOR; 
        	        }


        	    }
        	    break;
        	case 40:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1348:5: BVXNOR_TOK
        	    {
        	         MATCHT(BVXNOR_TOK, &FOLLOW_BVXNOR_TOK_in_builtinOp3394);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_XNOR; 
        	        }


        	    }
        	    break;
        	case 41:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1349:5: BVCOMP_TOK
        	    {
        	         MATCHT(BVCOMP_TOK, &FOLLOW_BVCOMP_TOK_in_builtinOp3406);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_COMP; 
        	        }


        	    }
        	    break;
        	case 42:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1350:5: BVSUB_TOK
        	    {
        	         MATCHT(BVSUB_TOK, &FOLLOW_BVSUB_TOK_in_builtinOp3418);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SUB; 
        	        }


        	    }
        	    break;
        	case 43:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1351:5: BVSDIV_TOK
        	    {
        	         MATCHT(BVSDIV_TOK, &FOLLOW_BVSDIV_TOK_in_builtinOp3430);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SDIV; 
        	        }


        	    }
        	    break;
        	case 44:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1352:5: BVSREM_TOK
        	    {
        	         MATCHT(BVSREM_TOK, &FOLLOW_BVSREM_TOK_in_builtinOp3442);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SREM; 
        	        }


        	    }
        	    break;
        	case 45:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1353:5: BVSMOD_TOK
        	    {
        	         MATCHT(BVSMOD_TOK, &FOLLOW_BVSMOD_TOK_in_builtinOp3454);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SMOD; 
        	        }


        	    }
        	    break;
        	case 46:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1354:5: BVASHR_TOK
        	    {
        	         MATCHT(BVASHR_TOK, &FOLLOW_BVASHR_TOK_in_builtinOp3466);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_ASHR; 
        	        }


        	    }
        	    break;
        	case 47:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1355:5: BVULE_TOK
        	    {
        	         MATCHT(BVULE_TOK, &FOLLOW_BVULE_TOK_in_builtinOp3478);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_ULE; 
        	        }


        	    }
        	    break;
        	case 48:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1356:5: BVUGT_TOK
        	    {
        	         MATCHT(BVUGT_TOK, &FOLLOW_BVUGT_TOK_in_builtinOp3490);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_UGT; 
        	        }


        	    }
        	    break;
        	case 49:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1357:5: BVUGE_TOK
        	    {
        	         MATCHT(BVUGE_TOK, &FOLLOW_BVUGE_TOK_in_builtinOp3502);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_UGE; 
        	        }


        	    }
        	    break;
        	case 50:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1358:5: BVSLT_TOK
        	    {
        	         MATCHT(BVSLT_TOK, &FOLLOW_BVSLT_TOK_in_builtinOp3514);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SLT; 
        	        }


        	    }
        	    break;
        	case 51:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1359:5: BVSLE_TOK
        	    {
        	         MATCHT(BVSLE_TOK, &FOLLOW_BVSLE_TOK_in_builtinOp3526);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SLE; 
        	        }


        	    }
        	    break;
        	case 52:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1360:5: BVSGT_TOK
        	    {
        	         MATCHT(BVSGT_TOK, &FOLLOW_BVSGT_TOK_in_builtinOp3538);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SGT; 
        	        }


        	    }
        	    break;
        	case 53:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1361:5: BVSGE_TOK
        	    {
        	         MATCHT(BVSGE_TOK, &FOLLOW_BVSGE_TOK_in_builtinOp3550);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_SGE; 
        	        }


        	    }
        	    break;
        	case 54:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1363:5: BV2NAT_TOK
        	    {
        	         MATCHT(BV2NAT_TOK, &FOLLOW_BV2NAT_TOK_in_builtinOp3563);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::BITVECTOR_TO_NAT;
        	                                 if(PARSER_STATE->strictModeEnabled()) {
        	                                   PARSER_STATE->parseError("bv2nat and int2bv are not part of SMT-LIB, and aren't available in SMT-LIB strict compliance mode");
        	                                 } 
        	        }


        	    }
        	    break;
        	case 55:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1367:5: STRCON_TOK
        	    {
        	         MATCHT(STRCON_TOK, &FOLLOW_STRCON_TOK_in_builtinOp3575);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_CONCAT; 
        	        }


        	    }
        	    break;
        	case 56:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1368:5: STRLEN_TOK
        	    {
        	         MATCHT(STRLEN_TOK, &FOLLOW_STRLEN_TOK_in_builtinOp3587);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_LENGTH; 
        	        }


        	    }
        	    break;
        	case 57:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1369:5: STRSUB_TOK
        	    {
        	         MATCHT(STRSUB_TOK, &FOLLOW_STRSUB_TOK_in_builtinOp3599);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_SUBSTR; 
        	        }


        	    }
        	    break;
        	case 58:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1370:5: STRCTN_TOK
        	    {
        	         MATCHT(STRCTN_TOK, &FOLLOW_STRCTN_TOK_in_builtinOp3611);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_STRCTN; 
        	        }


        	    }
        	    break;
        	case 59:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1371:5: STRCAT_TOK
        	    {
        	         MATCHT(STRCAT_TOK, &FOLLOW_STRCAT_TOK_in_builtinOp3623);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_CHARAT; 
        	        }


        	    }
        	    break;
        	case 60:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1372:5: STRIDOF_TOK
        	    {
        	         MATCHT(STRIDOF_TOK, &FOLLOW_STRIDOF_TOK_in_builtinOp3635);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_STRIDOF; 
        	        }


        	    }
        	    break;
        	case 61:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1373:5: STRREPL_TOK
        	    {
        	         MATCHT(STRREPL_TOK, &FOLLOW_STRREPL_TOK_in_builtinOp3646);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_STRREPL; 
        	        }


        	    }
        	    break;
        	case 62:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1374:5: STRPREF_TOK
        	    {
        	         MATCHT(STRPREF_TOK, &FOLLOW_STRPREF_TOK_in_builtinOp3657);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_PREFIX; 
        	        }


        	    }
        	    break;
        	case 63:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1375:5: STRSUFF_TOK
        	    {
        	         MATCHT(STRSUFF_TOK, &FOLLOW_STRSUFF_TOK_in_builtinOp3668);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_SUFFIX; 
        	        }


        	    }
        	    break;
        	case 64:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1376:5: STRITOS_TOK
        	    {
        	         MATCHT(STRITOS_TOK, &FOLLOW_STRITOS_TOK_in_builtinOp3679);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_ITOS; 
        	        }


        	    }
        	    break;
        	case 65:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1377:5: STRSTOI_TOK
        	    {
        	         MATCHT(STRSTOI_TOK, &FOLLOW_STRSTOI_TOK_in_builtinOp3690);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_STOI; 
        	        }


        	    }
        	    break;
        	case 66:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1378:5: STRU16TOS_TOK
        	    {
        	         MATCHT(STRU16TOS_TOK, &FOLLOW_STRU16TOS_TOK_in_builtinOp3701);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_U16TOS; 
        	        }


        	    }
        	    break;
        	case 67:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1379:5: STRSTOU16_TOK
        	    {
        	         MATCHT(STRSTOU16_TOK, &FOLLOW_STRSTOU16_TOK_in_builtinOp3712);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_STOU16; 
        	        }


        	    }
        	    break;
        	case 68:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1380:5: STRU32TOS_TOK
        	    {
        	         MATCHT(STRU32TOS_TOK, &FOLLOW_STRU32TOS_TOK_in_builtinOp3723);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_U32TOS; 
        	        }


        	    }
        	    break;
        	case 69:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1381:5: STRSTOU32_TOK
        	    {
        	         MATCHT(STRSTOU32_TOK, &FOLLOW_STRSTOU32_TOK_in_builtinOp3734);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_STOU32; 
        	        }


        	    }
        	    break;
        	case 70:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1382:5: STRINRE_TOK
        	    {
        	         MATCHT(STRINRE_TOK, &FOLLOW_STRINRE_TOK_in_builtinOp3745);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_IN_REGEXP; 
        	        }


        	    }
        	    break;
        	case 71:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1383:5: STRTORE_TOK
        	    {
        	         MATCHT(STRTORE_TOK, &FOLLOW_STRTORE_TOK_in_builtinOp3756);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::STRING_TO_REGEXP; 
        	        }


        	    }
        	    break;
        	case 72:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1384:5: RECON_TOK
        	    {
        	         MATCHT(RECON_TOK, &FOLLOW_RECON_TOK_in_builtinOp3767);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_CONCAT; 
        	        }


        	    }
        	    break;
        	case 73:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1385:5: REUNION_TOK
        	    {
        	         MATCHT(REUNION_TOK, &FOLLOW_REUNION_TOK_in_builtinOp3780);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_UNION; 
        	        }


        	    }
        	    break;
        	case 74:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1386:5: REINTER_TOK
        	    {
        	         MATCHT(REINTER_TOK, &FOLLOW_REINTER_TOK_in_builtinOp3791);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_INTER; 
        	        }


        	    }
        	    break;
        	case 75:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1387:5: RESTAR_TOK
        	    {
        	         MATCHT(RESTAR_TOK, &FOLLOW_RESTAR_TOK_in_builtinOp3802);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_STAR; 
        	        }


        	    }
        	    break;
        	case 76:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1388:5: REPLUS_TOK
        	    {
        	         MATCHT(REPLUS_TOK, &FOLLOW_REPLUS_TOK_in_builtinOp3814);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_PLUS; 
        	        }


        	    }
        	    break;
        	case 77:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1389:5: REOPT_TOK
        	    {
        	         MATCHT(REOPT_TOK, &FOLLOW_REOPT_TOK_in_builtinOp3826);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_OPT; 
        	        }


        	    }
        	    break;
        	case 78:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1390:5: RERANGE_TOK
        	    {
        	         MATCHT(RERANGE_TOK, &FOLLOW_RERANGE_TOK_in_builtinOp3839);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_RANGE; 
        	        }


        	    }
        	    break;
        	case 79:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1391:5: RELOOP_TOK
        	    {
        	         MATCHT(RELOOP_TOK, &FOLLOW_RELOOP_TOK_in_builtinOp3850);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::REGEXP_LOOP; 
        	        }


        	    }
        	    break;
        	case 80:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1393:5: FMFCARD_TOK
        	    {
        	         MATCHT(FMFCARD_TOK, &FOLLOW_FMFCARD_TOK_in_builtinOp3864);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulebuiltinOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::CARDINALITY_CONSTRAINT; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulebuiltinOpEx; /* Prevent compiler warnings */
    rulebuiltinOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end builtinOp */

/**
 * $ANTLR start quantOp
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1398:1: quantOp[CVC4::Kind& kind] : ( EXISTS_TOK | FORALL_TOK );
 */
static void
quantOp(pSmt2Parser ctx, CVC4::Kind& kind)
{
    /* Initialize rule variables
     */


      Debug("parser") << "quant: " << AntlrInput::tokenText(LT(1)) << std::endl;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1402:3: ( EXISTS_TOK | FORALL_TOK )

            ANTLR3_UINT32 alt38;

            alt38=2;

            switch ( LA(1) )
            {
            case EXISTS_TOK:
            	{
            		alt38=1;
            	}
                break;
            case FORALL_TOK:
            	{
            		alt38=2;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 38;
                EXCEPTION->state        = 0;


                goto rulequantOpEx;

            }

            switch (alt38)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1402:5: EXISTS_TOK
        	    {
        	         MATCHT(EXISTS_TOK, &FOLLOW_EXISTS_TOK_in_quantOp3892);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::EXISTS; 
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1403:5: FORALL_TOK
        	    {
        	         MATCHT(FORALL_TOK, &FOLLOW_FORALL_TOK_in_quantOp3903);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulequantOpEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             kind= CVC4::kind::FORALL; 
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulequantOpEx; /* Prevent compiler warnings */
    rulequantOpEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end quantOp */

/**
 * $ANTLR start functionName
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1410:1: functionName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_VARIABLE] ;
 */
static void
functionName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1411:3: ( symbol[name,check,SYM_VARIABLE] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1411:5: symbol[name,check,SYM_VARIABLE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_functionName3924);
            symbol(ctx, name, check, SYM_VARIABLE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulefunctionNameEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulefunctionNameEx; /* Prevent compiler warnings */
    rulefunctionNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end functionName */

/**
 * $ANTLR start sortList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1418:1: sortList[std::vector<CVC4::Type>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )* ;
 */
static void
sortList(pSmt2Parser ctx, std::vector<CVC4::Type>& sorts)
{

      Type t;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1422:3: ( ( sortSymbol[t,CHECK_DECLARED] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1422:5: ( sortSymbol[t,CHECK_DECLARED] )*
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1422:5: ( sortSymbol[t,CHECK_DECLARED] )*

            for (;;)
            {
                int alt39=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 156:
                	{
                		alt39=1;
                	}
                    break;

                }

                switch (alt39)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1422:7: sortSymbol[t,CHECK_DECLARED]
            	    {
            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortList3948);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             sorts.push_back(t); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop39;	/* break out of the loop */
            	    break;
                }
            }
            loop39: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortListEx; /* Prevent compiler warnings */
    rulesortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortList */

/**
 * $ANTLR start nonemptySortList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1425:1: nonemptySortList[std::vector<CVC4::Type>& sorts] : ( sortSymbol[t,CHECK_DECLARED] )+ ;
 */
static void
nonemptySortList(pSmt2Parser ctx, std::vector<CVC4::Type>& sorts)
{

      Type t;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1429:3: ( ( sortSymbol[t,CHECK_DECLARED] )+ )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1429:5: ( sortSymbol[t,CHECK_DECLARED] )+
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1429:5: ( sortSymbol[t,CHECK_DECLARED] )+
            {
                int cnt40=0;

                for (;;)
                {
                    int alt40=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            	case QUOTED_SYMBOL:
            	case SIMPLE_SYMBOL:
            	case UNTERMINATED_QUOTED_SYMBOL:
            	case 156:
            		{
            			alt40=1;
            		}
            	    break;

            	}

            	switch (alt40)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1429:7: sortSymbol[t,CHECK_DECLARED]
            	        {
            	            FOLLOWPUSH(FOLLOW_sortSymbol_in_nonemptySortList3975);
            	            sortSymbol(ctx, t, CHECK_DECLARED);

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptySortListEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 sorts.push_back(t); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt40 >= 1 )
            		{
            		    goto loop40;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptySortListEx;
            	}
            	cnt40++;
                }
                loop40: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptySortListEx; /* Prevent compiler warnings */
    rulenonemptySortListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptySortList */

/**
 * $ANTLR start sortedVarList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1436:1: sortedVarList[std::vector<std::pair<std::string, CVC4::Type> >& sortedVars] : ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* ;
 */
static void
sortedVarList(pSmt2Parser ctx, std::vector<std::pair<std::string, CVC4::Type> >& sortedVars)
{

      std::string name;
      Type t;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1441:3: ( ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1441:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1441:5: ( LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK )*

            for (;;)
            {
                int alt41=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt41=1;
                	}
                    break;

                }

                switch (alt41)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1441:7: LPAREN_TOK symbol[name,CHECK_NONE,SYM_VARIABLE] sortSymbol[t,CHECK_DECLARED] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortedVarList4004);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_symbol_in_sortedVarList4006);
            	        symbol(ctx, name, CHECK_NONE, SYM_VARIABLE);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_sortSymbol_in_sortedVarList4009);
            	        sortSymbol(ctx, t, CHECK_DECLARED);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortedVarList4012);
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesortedVarListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             sortedVars.push_back(make_pair(name, t)); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop41;	/* break out of the loop */
            	    break;
                }
            }
            loop41: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortedVarListEx; /* Prevent compiler warnings */
    rulesortedVarListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortedVarList */

/**
 * $ANTLR start sortName
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1450:1: sortName[std::string& name, CVC4::parser::DeclarationCheck check] : symbol[name,check,SYM_SORT] ;
 */
static void
sortName(pSmt2Parser ctx, std::string& name, CVC4::parser::DeclarationCheck check)
{
    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1451:3: ( symbol[name,check,SYM_SORT] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1451:5: symbol[name,check,SYM_SORT]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_sortName4043);
            symbol(ctx, name, check, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto rulesortNameEx;
            }
            if (HASFAILED())
            {
                return ;
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesortNameEx; /* Prevent compiler warnings */
    rulesortNameEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortName */

/**
 * $ANTLR start sortSymbol
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1454:1: sortSymbol[CVC4::Type& t, CVC4::parser::DeclarationCheck check] : ( sortName[name,CHECK_NONE] | LPAREN_TOK INDEX_TOK symbol[name,CHECK_NONE,SYM_SORT] nonemptyNumeralList[numerals] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_NONE,SYM_SORT] sortList[args] RPAREN_TOK );
 */
static void
sortSymbol(pSmt2Parser ctx, CVC4::Type& t, CVC4::parser::DeclarationCheck check)
{

      std::string name;
      std::vector<CVC4::Type> args;
      std::vector<uint64_t> numerals;

    /* Initialize rule variables
     */

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1460:3: ( sortName[name,CHECK_NONE] | LPAREN_TOK INDEX_TOK symbol[name,CHECK_NONE,SYM_SORT] nonemptyNumeralList[numerals] RPAREN_TOK | LPAREN_TOK symbol[name,CHECK_NONE,SYM_SORT] sortList[args] RPAREN_TOK )

            ANTLR3_UINT32 alt42;

            alt42=3;

            switch ( LA(1) )
            {
            case QUOTED_SYMBOL:
            case SIMPLE_SYMBOL:
            case UNTERMINATED_QUOTED_SYMBOL:
            case 156:
            	{
            		alt42=1;
            	}
                break;
            case LPAREN_TOK:
            	{
            		switch ( LA(2) )
            		{
            		case INDEX_TOK:
            			{
            				alt42=2;
            			}
            		    break;
            		case QUOTED_SYMBOL:
            		case SIMPLE_SYMBOL:
            		case UNTERMINATED_QUOTED_SYMBOL:
            		case 156:
            			{
            				alt42=3;
            			}
            		    break;

            		default:
            		    if (BACKTRACKING>0)
            		    {
            		        FAILEDFLAG = ANTLR3_TRUE;
            		        return ;
            		    }

            		    CONSTRUCTEX();
            		    EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
            		    EXCEPTION->message      = (void *)"";
            		    EXCEPTION->decisionNum  = 42;
            		    EXCEPTION->state        = 5;


            		    goto rulesortSymbolEx;

            		}

            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 42;
                EXCEPTION->state        = 0;


                goto rulesortSymbolEx;

            }

            switch (alt42)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1460:5: sortName[name,CHECK_NONE]
        	    {
        	        FOLLOWPUSH(FOLLOW_sortName_in_sortSymbol4063);
        	        sortName(ctx, name, CHECK_NONE);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if( check == CHECK_DECLARED || PARSER_STATE->isDeclared(name, SYM_SORT) ) {
        	                    t = PARSER_STATE->getSort(name);
        	                  } else {
        	                    t = PARSER_STATE->mkUnresolvedType(name);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1468:5: LPAREN_TOK INDEX_TOK symbol[name,CHECK_NONE,SYM_SORT] nonemptyNumeralList[numerals] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol4076);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(INDEX_TOK, &FOLLOW_INDEX_TOK_in_sortSymbol4078);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sortSymbol4080);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_nonemptyNumeralList_in_sortSymbol4083);
        	        nonemptyNumeralList(ctx, numerals);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol4086);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if( name == "BitVec" ) {
        	                    if( numerals.size() != 1 ) {
        	                      PARSER_STATE->parseError("Illegal bitvector type.");
        	                    }
        	                    if(numerals.front() == 0) {
        	                      PARSER_STATE->parseError("Illegal bitvector size: 0");
        	                    }
        	                    t = EXPR_MANAGER->mkBitVectorType(numerals.front());
        	                  } else {
        	                    std::stringstream ss;
        	                    ss << "unknown indexed symbol `" << name << "'";
        	                    PARSER_STATE->parseError(ss.str());
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1484:5: LPAREN_TOK symbol[name,CHECK_NONE,SYM_SORT] sortList[args] RPAREN_TOK
        	    {
        	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_sortSymbol4098);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_symbol_in_sortSymbol4100);
        	        symbol(ctx, name, CHECK_NONE, SYM_SORT);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        FOLLOWPUSH(FOLLOW_sortList_in_sortSymbol4103);
        	        sortList(ctx, args);

        	        FOLLOWPOP();
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_sortSymbol4106);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesortSymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {

        	                  if(args.empty()) {
        	                    PARSER_STATE->parseError("Extra parentheses around sort name not permitted in SMT-LIB");
        	                  } else if(name == "Array" &&
        	                     PARSER_STATE->isTheoryEnabled(Smt2::THEORY_ARRAYS) ) {
        	                    if(args.size() != 2) {
        	                      PARSER_STATE->parseError("Illegal array type.");
        	                    }
        	                    t = EXPR_MANAGER->mkArrayType( args[0], args[1] );
        	                  } else if(name == "Set" &&
        	                            PARSER_STATE->isTheoryEnabled(Smt2::THEORY_SETS) ) {
        	                    if(args.size() != 1) {
        	                      PARSER_STATE->parseError("Illegal set type.");
        	                    }
        	                    t = EXPR_MANAGER->mkSetType( args[0] );
        	                  } else if(check == CHECK_DECLARED ||
        	                            PARSER_STATE->isDeclared(name, SYM_SORT)) {
        	                    t = PARSER_STATE->getSort(name, args);
        	                  } else {
        	                    // make unresolved type
        	                    if(args.empty()) {
        	                      t = PARSER_STATE->mkUnresolvedType(name);
        	                      Debug("parser-param") << "param: make unres type " << name << std::endl;
        	                    } else {
        	                      t = PARSER_STATE->mkUnresolvedTypeConstructor(name,args);
        	                      t = SortConstructorType(t).instantiate( args );
        	                      Debug("parser-param") << "param: make unres param type " << name << " " << args.size() << " "
        	                                            << PARSER_STATE->getArity( name ) << std::endl;
        	                    }
        	                  }
        	                
        	        }


        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesortSymbolEx; /* Prevent compiler warnings */
    rulesortSymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end sortSymbol */

/**
 * $ANTLR start symbolList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1522:1: symbolList[std::vector<std::string>& names,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( symbol[id,check,type] )* ;
 */
static void
symbolList(pSmt2Parser ctx, std::vector<std::string>& names, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{

      std::string id;

    /* Initialize rule variables
     */

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1528:3: ( ( symbol[id,check,type] )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1528:5: ( symbol[id,check,type] )*
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1528:5: ( symbol[id,check,type] )*

            for (;;)
            {
                int alt43=2;
                switch ( LA(1) )
                {
                case QUOTED_SYMBOL:
                case SIMPLE_SYMBOL:
                case UNTERMINATED_QUOTED_SYMBOL:
                case 156:
                	{
                		alt43=1;
                	}
                    break;

                }

                switch (alt43)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1528:7: symbol[id,check,type]
            	    {
            	        FOLLOWPUSH(FOLLOW_symbol_in_symbolList4135);
            	        symbol(ctx, id, check, type);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto rulesymbolListEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        if ( BACKTRACKING==0 )
            	        {
            	             names.push_back(id); 
            	        }


            	    }
            	    break;

            	default:
            	    goto loop43;	/* break out of the loop */
            	    break;
                }
            }
            loop43: ; /* Jump out to here if this rule does not match */


        }

    }

    // This is where rules clean up and exit
    //
    goto rulesymbolListEx; /* Prevent compiler warnings */
    rulesymbolListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbolList */

/**
 * $ANTLR start symbol
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1537:1: symbol[std::string& id,\n CVC4::parser::DeclarationCheck check,\n CVC4::parser::SymbolType type] : ( SIMPLE_SYMBOL | 'repeat' | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) );
 */
static void
symbol(pSmt2Parser ctx, std::string& id, CVC4::parser::DeclarationCheck check, CVC4::parser::SymbolType type)
{
    pANTLR3_COMMON_TOKEN    SIMPLE_SYMBOL17;
    pANTLR3_COMMON_TOKEN    QUOTED_SYMBOL18;

    /* Initialize rule variables
     */

    SIMPLE_SYMBOL17       = NULL;
    QUOTED_SYMBOL18       = NULL;

    {
        {
            //  /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1540:3: ( SIMPLE_SYMBOL | 'repeat' | QUOTED_SYMBOL | UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' ) )

            ANTLR3_UINT32 alt45;

            alt45=4;

            switch ( LA(1) )
            {
            case SIMPLE_SYMBOL:
            	{
            		alt45=1;
            	}
                break;
            case 156:
            	{
            		alt45=2;
            	}
                break;
            case QUOTED_SYMBOL:
            	{
            		alt45=3;
            	}
                break;
            case UNTERMINATED_QUOTED_SYMBOL:
            	{
            		alt45=4;
            	}
                break;

            default:
                if (BACKTRACKING>0)
                {
                    FAILEDFLAG = ANTLR3_TRUE;
                    return ;
                }

                CONSTRUCTEX();
                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
                EXCEPTION->message      = (void *)"";
                EXCEPTION->decisionNum  = 45;
                EXCEPTION->state        = 0;


                goto rulesymbolEx;

            }

            switch (alt45)
            {
        	case 1:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1540:5: SIMPLE_SYMBOL
        	    {
        	        SIMPLE_SYMBOL17 = (pANTLR3_COMMON_TOKEN) MATCHT(SIMPLE_SYMBOL, &FOLLOW_SIMPLE_SYMBOL_in_symbol4157);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             id = AntlrInput::tokenText(SIMPLE_SYMBOL17);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 2:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1547:5: 'repeat'
        	    {
        	         MATCHT(156, &FOLLOW_156_in_symbol4169);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             id = "repeat";
        	                  PARSER_STATE->checkDeclaration(id, check, type);
        	                
        	        }


        	    }
        	    break;
        	case 3:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1551:5: QUOTED_SYMBOL
        	    {
        	        QUOTED_SYMBOL18 = (pANTLR3_COMMON_TOKEN) MATCHT(QUOTED_SYMBOL, &FOLLOW_QUOTED_SYMBOL_in_symbol4181);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        if ( BACKTRACKING==0 )
        	        {
        	             id = AntlrInput::tokenText(QUOTED_SYMBOL18);
        	                  /* strip off the quotes */
        	                  id = id.substr(1, id.size() - 2);
        	                  if(!PARSER_STATE->isAbstractValue(id)) {
        	                    // if an abstract value, SmtEngine handles declaration
        	                    PARSER_STATE->checkDeclaration(id, check, type);
        	                  }
        	                
        	        }


        	    }
        	    break;
        	case 4:
        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1560:5: UNTERMINATED_QUOTED_SYMBOL ( EOF | '\\\\' )
        	    {
        	         MATCHT(UNTERMINATED_QUOTED_SYMBOL, &FOLLOW_UNTERMINATED_QUOTED_SYMBOL_in_symbol4193);
        	        if  (HASEXCEPTION())
        	        {
        	            goto rulesymbolEx;
        	        }
        	        if (HASFAILED())
        	        {
        	            return ;
        	        }


        	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1561:5: ( EOF | '\\\\' )
        	        {
        	            int alt44=2;
        	            switch ( LA(1) )
        	            {
        	            case EOF:
        	            	{
        	            		alt44=1;
        	            	}
        	                break;
        	            case 154:
        	            	{
        	            		alt44=2;
        	            	}
        	                break;

        	            default:
        	                if (BACKTRACKING>0)
        	                {
        	                    FAILEDFLAG = ANTLR3_TRUE;
        	                    return ;
        	                }

        	                CONSTRUCTEX();
        	                EXCEPTION->type         = ANTLR3_NO_VIABLE_ALT_EXCEPTION;
        	                EXCEPTION->message      = (void *)"";
        	                EXCEPTION->decisionNum  = 44;
        	                EXCEPTION->state        = 0;


        	                goto rulesymbolEx;

        	            }

        	            switch (alt44)
        	            {
        	        	case 1:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1561:7: EOF
        	        	    {
        	        	         MATCHT(EOF, &FOLLOW_EOF_in_symbol4201);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("unterminated |quoted| symbol"); 
        	        	        }


        	        	    }
        	        	    break;
        	        	case 2:
        	        	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1563:7: '\\\\'
        	        	    {
        	        	         MATCHT(154, &FOLLOW_154_in_symbol4217);
        	        	        if  (HASEXCEPTION())
        	        	        {
        	        	            goto rulesymbolEx;
        	        	        }
        	        	        if (HASFAILED())
        	        	        {
        	        	            return ;
        	        	        }


        	        	        if ( BACKTRACKING==0 )
        	        	        {
        	        	             PARSER_STATE->unexpectedEOF("backslash not permitted in |quoted| symbol"); 
        	        	        }


        	        	    }
        	        	    break;

        	            }
        	        }

        	    }
        	    break;

            }
        }
    }

    // This is where rules clean up and exit
    //
    goto rulesymbolEx; /* Prevent compiler warnings */
    rulesymbolEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end symbol */

/**
 * $ANTLR start nonemptyNumeralList
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1572:1: nonemptyNumeralList[std::vector<uint64_t>& numerals] : ( INTEGER_LITERAL )+ ;
 */
static void
nonemptyNumeralList(pSmt2Parser ctx, std::vector<uint64_t>& numerals)
{
    pANTLR3_COMMON_TOKEN    INTEGER_LITERAL19;

    /* Initialize rule variables
     */

    INTEGER_LITERAL19       = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1573:3: ( ( INTEGER_LITERAL )+ )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1573:5: ( INTEGER_LITERAL )+
        {
            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1573:5: ( INTEGER_LITERAL )+
            {
                int cnt46=0;

                for (;;)
                {
                    int alt46=2;
            	switch ( LA(1) )
            	{
            	case INTEGER_LITERAL:
            		{
            			alt46=1;
            		}
            	    break;

            	}

            	switch (alt46)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1573:7: INTEGER_LITERAL
            	        {
            	            INTEGER_LITERAL19 = (pANTLR3_COMMON_TOKEN) MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_nonemptyNumeralList4249);
            	            if  (HASEXCEPTION())
            	            {
            	                goto rulenonemptyNumeralListEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            if ( BACKTRACKING==0 )
            	            {
            	                 numerals.push_back(AntlrInput::tokenToUnsigned(INTEGER_LITERAL19)); 
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt46 >= 1 )
            		{
            		    goto loop46;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto rulenonemptyNumeralListEx;
            	}
            	cnt46++;
                }
                loop46: ;	/* Jump to here if this rule does not match */
            }

        }

    }

    // This is where rules clean up and exit
    //
    goto rulenonemptyNumeralListEx; /* Prevent compiler warnings */
    rulenonemptyNumeralListEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end nonemptyNumeralList */

/**
 * $ANTLR start datatypeDef
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1581:1: datatypeDef[bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params] : symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ ;
 */
static void
datatypeDef(pSmt2Parser ctx, bool isCo, std::vector<CVC4::Datatype>& datatypes, std::vector< CVC4::Type >& params)
{
    /* Initialize rule variables
     */


      std::string id;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1589:3: ( symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+ )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1589:5: symbol[id,CHECK_NONE,SYM_SORT] ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
        {
            FOLLOWPUSH(FOLLOW_symbol_in_datatypeDef4291);
            symbol(ctx, id, CHECK_NONE, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruledatatypeDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->pushScope(true); 
            }


            if ( BACKTRACKING==0 )
            {
                 datatypes.push_back(Datatype(id,params,isCo));
                      if(!PARSER_STATE->isUnresolvedType(id)) {
                        // if not unresolved, must be undeclared
                        PARSER_STATE->checkDeclaration(id, CHECK_UNDECLARED, SYM_SORT);
                      }
                    
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1605:5: ( LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK )+
            {
                int cnt47=0;

                for (;;)
                {
                    int alt47=2;
            	switch ( LA(1) )
            	{
            	case LPAREN_TOK:
            		{
            			alt47=1;
            		}
            	    break;

            	}

            	switch (alt47)
            	{
            	    case 1:
            	        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1605:7: LPAREN_TOK constructorDef[datatypes.back()] RPAREN_TOK
            	        {
            	             MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_datatypeDef4314);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	            FOLLOWPUSH(FOLLOW_constructorDef_in_datatypeDef4316);
            	            constructorDef(ctx, datatypes.back());

            	            FOLLOWPOP();
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	             MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_datatypeDef4319);
            	            if  (HASEXCEPTION())
            	            {
            	                goto ruledatatypeDefEx;
            	            }
            	            if (HASFAILED())
            	            {
            	                return ;
            	            }


            	        }
            	        break;

            	    default:

            		if ( cnt47 >= 1 )
            		{
            		    goto loop47;
            		}
            		if (BACKTRACKING>0)
            		{
            		    FAILEDFLAG = ANTLR3_TRUE;
            		    return ;
            		}

            		/* mismatchedSetEx()
            		 */
            		CONSTRUCTEX();
            		EXCEPTION->type = ANTLR3_EARLY_EXIT_EXCEPTION;
            		EXCEPTION->name = (void *)ANTLR3_EARLY_EXIT_NAME;


            		goto ruledatatypeDefEx;
            	}
            	cnt47++;
                }
                loop47: ;	/* Jump to here if this rule does not match */
            }

            if ( BACKTRACKING==0 )
            {
                 PARSER_STATE->popScope(); 
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruledatatypeDefEx; /* Prevent compiler warnings */
    ruledatatypeDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end datatypeDef */

/**
 * $ANTLR start constructorDef
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1612:1: constructorDef[CVC4::Datatype& type] : symbol[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* ;
 */
static void
constructorDef(pSmt2Parser ctx, CVC4::Datatype& type)
{
    /* Initialize rule variables
     */


      std::string id;
      CVC4::DatatypeConstructor* ctor = NULL;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1617:3: ( symbol[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )* )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1617:5: symbol[id,CHECK_UNDECLARED,SYM_SORT] ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*
        {
            FOLLOWPUSH(FOLLOW_symbol_in_constructorDef4349);
            symbol(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleconstructorDefEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 // make the tester
                      std::string testerId("is-");
                      testerId.append(id);
                      PARSER_STATE->checkDeclaration(testerId, CHECK_UNDECLARED, SYM_SORT);
                      ctor = new CVC4::DatatypeConstructor(id, testerId);
                    
            }


            // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1624:5: ( LPAREN_TOK selector[*ctor] RPAREN_TOK )*

            for (;;)
            {
                int alt48=2;
                switch ( LA(1) )
                {
                case LPAREN_TOK:
                	{
                		alt48=1;
                	}
                    break;

                }

                switch (alt48)
                {
            	case 1:
            	    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1624:7: LPAREN_TOK selector[*ctor] RPAREN_TOK
            	    {
            	         MATCHT(LPAREN_TOK, &FOLLOW_LPAREN_TOK_in_constructorDef4364);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	        FOLLOWPUSH(FOLLOW_selector_in_constructorDef4366);
            	        selector(ctx, *ctor);

            	        FOLLOWPOP();
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	         MATCHT(RPAREN_TOK, &FOLLOW_RPAREN_TOK_in_constructorDef4369);
            	        if  (HASEXCEPTION())
            	        {
            	            goto ruleconstructorDefEx;
            	        }
            	        if (HASFAILED())
            	        {
            	            return ;
            	        }


            	    }
            	    break;

            	default:
            	    goto loop48;	/* break out of the loop */
            	    break;
                }
            }
            loop48: ; /* Jump out to here if this rule does not match */


            if ( BACKTRACKING==0 )
            {
                 // make the constructor
                      type.addConstructor(*ctor);
                      Debug("parser-idt") << "constructor: " << id.c_str() << std::endl;
                      delete ctor;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleconstructorDefEx; /* Prevent compiler warnings */
    ruleconstructorDefEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end constructorDef */

/**
 * $ANTLR start selector
 * /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1632:1: selector[CVC4::DatatypeConstructor& ctor] : symbol[id,CHECK_UNDECLARED,SYM_SORT] sortSymbol[t,CHECK_NONE] ;
 */
static void
selector(pSmt2Parser ctx, CVC4::DatatypeConstructor& ctor)
{
    /* Initialize rule variables
     */


      std::string id;
      Type t, t2;

    {
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1637:3: ( symbol[id,CHECK_UNDECLARED,SYM_SORT] sortSymbol[t,CHECK_NONE] )
        // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1637:5: symbol[id,CHECK_UNDECLARED,SYM_SORT] sortSymbol[t,CHECK_NONE]
        {
            FOLLOWPUSH(FOLLOW_symbol_in_selector4397);
            symbol(ctx, id, CHECK_UNDECLARED, SYM_SORT);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            FOLLOWPUSH(FOLLOW_sortSymbol_in_selector4400);
            sortSymbol(ctx, t, CHECK_NONE);

            FOLLOWPOP();
            if  (HASEXCEPTION())
            {
                goto ruleselectorEx;
            }
            if (HASFAILED())
            {
                return ;
            }


            if ( BACKTRACKING==0 )
            {
                 ctor.addArg(id, t);
                      Debug("parser-idt") << "selector: " << id.c_str()
                                          << " of type " << t << std::endl;
                    
            }


        }

    }

    // This is where rules clean up and exit
    //
    goto ruleselectorEx; /* Prevent compiler warnings */
    ruleselectorEx: ;

            if (HASEXCEPTION())
            {
                PREPORTERROR();
                PRECOVER();
            }
    return ;
}
/* $ANTLR end selector */

// $ANTLR start synpred1_Smt2
static void synpred1_Smt2_fragment(pSmt2Parser ctx )
{
    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1209:7: ( 'repeat' INTEGER_LITERAL )
    // /home/mdeters/cvc4/builds/x86_64-unknown-linux-gnu/production/../../../src/parser/smt2/Smt2.g:1209:8: 'repeat' INTEGER_LITERAL
    {
         MATCHT(156, &FOLLOW_156_in_synpred1_Smt22637);
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_Smt2Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


         MATCHT(INTEGER_LITERAL, &FOLLOW_INTEGER_LITERAL_in_synpred1_Smt22639);
        if  (HASEXCEPTION())
        {
            goto rulesynpred1_Smt2Ex;
        }
        if (HASFAILED())
        {
            return ;
        }


    }

// This is where rules clean up and exit
//
goto rulesynpred1_Smt2Ex; /* Prevent compiler warnings */
rulesynpred1_Smt2Ex: ;

}
// $ANTLR end synpred1_Smt2
/* End of parsing rules
 * ==============================================
 */

/* ==============================================
 * Syntactic predicates
 */
static ANTLR3_BOOLEAN synpred1_Smt2(pSmt2Parser ctx)
{
    ANTLR3_MARKER   start;
    ANTLR3_BOOLEAN  success;

    BACKTRACKING++;
    start	= MARK();
    synpred1_Smt2_fragment(ctx);	    // can never throw exception
    success	= !(FAILEDFLAG);
    REWIND(start);
    BACKTRACKING--;
    FAILEDFLAG	= ANTLR3_FALSE;
    return success;
}

/* End of syntactic predicates
 * ==============================================
 */






/* End of code
 * =============================================================================
 */
