#! /bin/sh

# This script does all the setup necessary to run Why3, and gives a shell where 'why3' can be run.
# It should leave no permanent changes, but of course comes without any guarantee.

if [ -e "$HOME/.why3.conf" ]; then
	echo You already seem to have a configured Why3 setup -- aborting.
	exit 1
fi

set -e

BASE=$(realpath -s "$0")
BASE="${BASE%/*}"

export PATH="$BASE/bin:$PATH"
export LD_LIBRARY_PATH="$BASE/lib:$LD_LIBRARY_PATH"

why3 config --detect
cat >> "$HOME/.why3.conf" <<EOF
[prover]
alternative = "noBV"
command = "cvc4 --tlimit-per=%t000 --lang=smt2 %f"
driver = "cvc4"
editor = ""
in_place = false
interactive = false
name = "CVC4"
version = "1.6"
EOF

echo You can now use 'why3'; type 'exit' to leave this environment.
$SHELL
rm "$HOME/.why3.conf"
