# This base image is not officially supported by Docker it
# is generated by running
# ```
# ./update.sh xenial
# ```
# from git@github.com:daald/docker-brew-ubuntu-core-32bit.git
# at commit 34ea593b40b423755b7d46b6c8c89fc8162ea74b
#
# We could actually store the image generated by this Dockerfile
# rather than just the bare image. However given we have a TravisCI
# cache I'm not sure if it faster to use the TravisCI cache or to
# download from DockerHub everytime.
FROM z3prover/ubuntu32:16.04

RUN apt-get update && \
    apt-get -y --no-install-recommends install \
        binutils \
        clang \
        clang-3.9 \
        cmake \
        doxygen \
        default-jdk \
        gcc \
        gcc-5 \
        git \
        graphviz \
        g++ \
        g++ \
        libgmp-dev \
        libgomp1 \
        libomp5 \
        libomp-dev \
        llvm-3.9 \
        make \
        mono-devel \
        ninja-build \
        python3 \
        python3-setuptools \
        python2.7 \
        python-setuptools \
        sudo

# Create `user` user for container with password `user`.  and give it
# password-less sudo access
RUN useradd -m user && \
    echo user:user | chpasswd && \
    cp /etc/sudoers /etc/sudoers.bak && \
    echo 'user  ALL=(root) NOPASSWD: ALL' >> /etc/sudoers
USER user
WORKDIR /home/user
ENV ASAN_SYMBOLIZER_PATH=/usr/lib/llvm-3.9/bin/llvm-symbolizer
