/*++
Copyright (c) 2013 Microsoft Corporation

Module Name:

    tab_context.h

Abstract:

    Tabulation/subsumption/cyclic proof context.

Author:

    Nikolaj Bjorner (nbjorner) 2013-01-15

Revision History:

--*/
#ifndef TAB_CONTEXT_H_
#define TAB_CONTEXT_H_

#include "ast/ast.h"
#include "util/lbool.h"
#include "util/statistics.h"
#include "muz/base/dl_engine_base.h"

namespace datalog {
    class context;

    class tab : public engine_base {
        class imp;
        imp* m_imp;
    public:
        tab(context& ctx);
        ~tab();
        virtual lbool query(expr* query);
        virtual void cleanup();
        virtual void reset_statistics();
        virtual void collect_statistics(statistics& st) const;
        virtual void display_certificate(std::ostream& out) const;        
        virtual expr_ref get_answer();
    };
};

#endif
