/*
 * Decompiled with CFR 0.152.
 */
package sos.smartcards.firewallhost;

import java.util.Iterator;
import java.util.Vector;
import javax.smartcardio.Card;
import javax.smartcardio.CardChannel;
import javax.smartcardio.CommandAPDU;
import javax.smartcardio.ResponseAPDU;
import sos.smartcards.firewallhost.FirewallHost;
import sos.smartcards.firewallhost.OneTest;

public class TestSuite {
    Vector<OneTest> tests = new Vector();

    TestSuite() {
        this.tests.add(new OneTest(1, false, false, new String[]{"Global array install cannot be stored in an instance field.", "Global array install cannot be stored in a static field.", "APDU object cannot be stored in an instance field.", "APDU object cannot be stored in a static field.", "APDU buffer (global) cannot be stored in an instance field.", "APDU buffer (global) cannot be stored in a static field.", "System owned exception cannot be stored in an instance field.", "System owned exception cannot be stored in a static field."}));
        this.tests.add(new OneTest(2, false, false, new String[]{"Withing one context JCSystem.getAID returns applet's AID (1).", "Withing one context JCSystem.getAID returns applet's AID (1).", "Context does not change between applets in the same package.", "Outside of the context JCSystem.getAID returns server's AID.", "JCSystem.getPreviousContextAID returns context before the context switch.", "JCSystem.getPreviousContextAID returns context before the context switch.", "Context information has a stack structure.", "AID is null before register is called (install method)."}));
        this.tests.add(new OneTest(3, false, false, new String[]{"CLEAR_ON_RESET array can be created within the same context.", "CLEAR_ON_RESET array can be accessed within the same context.", "CLEAR_ON_DESELECT array can be created within the same context.", "CLEAR_ON_DESELECT array can be accessed within the same context."}));
        this.tests.add(new OneTest(4, true, false, new String[]{"Persistent array can be created if the context is not the one currently selected.", "CLEAR_ON_RESET array can be created if the context is not the one currently selected.", "CLEAR_ON_DESELECT array cannot be created if the context is not the one currently selected.", "Persistent array can be accessed if the context is not the one currently selected.", "CLEAR_ON_RESET array can be accessed if the context is not the one currently selected.", "CLEAR_ON_DESELECT array cannot be accessed if the context is not the one currently selected."}));
        this.tests.add(new OneTest(5, false, false, new String[]{"Public static method calls do not cause context switch.", "Public static fields are accessible accross contexts."}));
        this.tests.add(new OneTest(6, false, false, new String[]{"Static access in applet package (methods and fields)."}));
        this.tests.add(new OneTest(7, false, false, new String[]{"Methods of APDU can be accessed from any context.", "Global array (APDU buffer) can be accessed from any context.", "Applet owned AID methods cannot be accessed from another context.", "System owned AID methods can be accessed from any context."}));
        this.tests.add(new OneTest(8, false, false, new String[]{"AID.equals checks for access rules to parameters.", "AID.getBytes checks for access rules to parameters.", "AID.getPartialBytes checks for access rules to parameters.", "AID.partialEquals checks for access rules to parameters.", "AID constructor checks for access rules to parameters.", "AID.equals checks for access rules to parameters (arbitrary applet owned object).", "AID.equals checks for access rules to parameters (applet owned AID).", "AID.RIDEquals checks for access rules to parameters (applet owned AID).", "AID.equals checks for access rules to parameters (system owned AID).", "AID.RIDEquals checks for access rules to parameters (system owned AID)."}));
        this.tests.add(new OneTest(9, false, false, new String[]{"JCRE cannot read CLEAR_ON_DESELECT arrays if the current context is not the selected one (AID.equals).", "JCRE cannot read CLEAR_ON_DESELECT arrays if the current context is not the selected one (AID.getBytes).", "JCRE cannot read CLEAR_ON_DESELECT arrays if the current context is not the selected one (AID.getPartialBytes).", "JCRE cannot read CLEAR_ON_DESELECT arrays if the current context is not the selected one (AID.partialEquals).", "JCRE cannot read CLEAR_ON_DESELECT arrays if the current context is not the selected one (AID constructor).", "JCRE can read CLEAR_ON_RESET arrays if the current context is not the selected one (AID.equals).", "JCRE can read CLEAR_ON_RESET arrays if the current context is not the selected one (AID.getBytes).", "JCRE can read CLEAR_ON_RESET arrays if the current context is not the selected one (AID.getPartialBytes).", "JCRE can read CLEAR_ON_RESET arrays if the current context is not the selected one (AID.partialEquals).", "JCRE can read CLEAR_ON_RESET arrays if the current context is not the selected one (AID constructor)."}));
        this.tests.add(new OneTest(10, false, false, new String[]{"JCRE can read CLEAR_ON_DESELECT arrays if the current context is the selected one (AID.equals).", "JCRE can read CLEAR_ON_DESELECT arrays if the current context is the selected one (AID.getBytes).", "JCRE can read CLEAR_ON_DESELECT arrays if the current context is the selected one (AID.getPartialBytes).", "JCRE can read CLEAR_ON_DESELECT arrays if the current context is the selected one (AID.partialEquals).", "JCRE can read CLEAR_ON_DESELECT arrays if the current context is the selected one (AID constructor)."}));
        this.tests.add(new OneTest(11, false, false, new String[]{"Static array belongs to the package (can be accessed within the same context)."}));
        this.tests.add(new OneTest(12, false, false, new String[]{"Fields of object belonging to another context cannot be read.", "Fields of object belonging to another context cannot be written.", "Methods of object belonging to another context cannot be called.", "Fields of shareable object belonging to another context cannot be read.", "Fields of shareable object belonging to another context cannot be written.", "Undeclared methods of shareable object belonging to another context cannot be called.", "Declared methods of shareable object belonging to another context cannot be called without shareable cast.", "Declared methods of shareable object belonging to another context can be called with shareable cast.", "Fields of object belonging to current context can be read.", "Fields of object belonging to current context can be written.", "Methods of object belonging to current context can be called.", "Fields of shareable object belonging to current context can be read.", "Fields of shareable object belonging to current context can be written.", "Undeclared methods of shareable object belonging to current context can be called."}));
        this.tests.add(new OneTest(13, false, false, new String[]{"Context owned object can be cast to an interface type.", "Context owned object can be cast to a class type.", "Instance of context owned object can be checked against a class type.", "Instance of context owned object can be checked against the Shareable interface.", "Object owned by another context cannot be cast to a class type.", "Instance of an object owned by another context cannot be checked against a class type.", "Instance of an object owned by another context cannot be checked against the Shareable interface.", "Context owned shareable object can be cast to an interface type.", "Context owned shareable object can be cast to a class type.", "Context owned shareable object can be cast to a shareable interface.", "Instance of context owned shareable object can be checked against a class type.", "Instance of context owned shareable object can be checked against the Shareable interface.", "Instance of context owned shareable object can be checked against a shareable interface.", "Shareable Object owned by another context cannot be cast to a non-shareable interface.", "Shareable Object owned by another context cannot be cast to a class type.", "Shareable Object owned by another context can be cast to a shareable interface.", "Instance of a shareable object owned by another context cannot be checked against a class type.", "Instance of a shareable object owned by another context can be checked against the Shareable interface.", "Instance of a shareable object owned by another context can be checked against a shareable interface.", "Instance of a system owned object (AID) can be checked against the Shareable interface.", "Instance of a system owned object (AID) can be checked against a class type.", "Instance of a system owned exception can be checked against a class type.", "Instance of a system owned exception can be checked against the Shareable interface."}));
        this.tests.add(new OneTest(14, false, false, new String[]{"An array cannot be read by another context.", "An array cannot be written by another context.", "Array field length cannot be read by another context."}));
        this.tests.add(new OneTest(15, false, false, new String[]{"Context owned exceptions cannot be thrown by another context.", "System owned exception can be thrown by another context.", "Context is restored on exceptions occuring in another context (1).", "Context is restored on exceptions occuring in another context (2)."}));
        this.tests.add(new OneTest(16, false, true, new String[]{"Shareable interface cannot be accessed if the server is selected on another channel."}));
        this.tests.add(new OneTest(20, true, false, new String[]{"Shareable interface can be accessed if the multiselectable server is selected on another channel."}));
        this.tests.add(new OneTest(17, false, true, new String[]{"Shareable interface cannot be acquired if the server is selected on another channel. Expected to fail (JC 2.2.2 only requirement)."}));
        this.tests.add(new OneTest(21, true, false, new String[]{"Shareable interface can be acquired if the multiselectable server is selected on another channel."}));
        this.tests.add(new OneTest(18, false, false, new String[]{"Stack overflow restores the context properly."}));
        this.tests.add(new OneTest(19, false, false, new String[]{"Non-external ciphers should not be usable externally.", "External ciphers can be used externally."}));
    }

    public void runTests(Card card, CardChannel cardChannel, byte[] byArray, byte[] byArray2, boolean bl) {
        Iterator<OneTest> iterator = this.tests.iterator();
        OneTest oneTest = null;
        byte[] byArray3 = new byte[5];
        byte[] byArray4 = null;
        while (iterator.hasNext()) {
            try {
                CardChannel cardChannel2;
                oneTest = iterator.next();
                if (bl && oneTest.serverActive | oneTest.serverMultiselectableActive) continue;
                byArray3[1] = oneTest.testNum;
                if (bl | !oneTest.serverActive) {
                    byArray4 = cardChannel.transmit(new CommandAPDU(byArray3)).getBytes();
                    this.analyzeResult(byArray4, oneTest.testNum, oneTest.messages, "");
                }
                if (oneTest.serverMultiselectableActive) {
                    cardChannel2 = card.openLogicalChannel();
                    FirewallHost.selectAID(cardChannel2, byArray2);
                    byArray4 = cardChannel.transmit(new CommandAPDU(byArray3)).getBytes();
                    cardChannel2.close();
                    this.analyzeResult(byArray4, oneTest.testNum, oneTest.messages, " Multiselectable server active.");
                }
                if (!oneTest.serverActive) continue;
                cardChannel2 = card.openLogicalChannel();
                FirewallHost.selectAID(cardChannel2, byArray);
                byArray4 = cardChannel.transmit(new CommandAPDU(byArray3)).getBytes();
                cardChannel2.close();
                this.analyzeResult(byArray4, oneTest.testNum, oneTest.messages, "");
            }
            catch (Exception exception) {
                System.out.println("Test " + oneTest.testNum + " failed: " + exception);
            }
        }
    }

    void analyzeResult(byte[] byArray, byte by, String[] stringArray, String string) {
        byte[] byArray2 = new ResponseAPDU(byArray).getData();
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == 1) continue;
            String string2 = Integer.toHexString(by);
            if (string2.length() == 1) {
                string2 = "0" + string2;
            }
            System.out.println("Test failed: " + stringArray[i] + string + (byArray2[i] != 0 ? " Exception: " + this.decodeException(byArray2[i]) : "") + " INS: 0x" + string2 + " Test#: " + i);
        }
    }

    String decodeException(byte by) {
        switch (by) {
            case 33: {
                return "ArithmeticException";
            }
            case 34: {
                return "ArrayStoreException";
            }
            case 35: {
                return "ClassCastException";
            }
            case 36: {
                return "ArrayIndexOutOfBoundsException";
            }
            case 37: {
                return "IndexOutOfBoundsException";
            }
            case 38: {
                return "NegativeArraySizeException";
            }
            case 39: {
                return "NullPointerException";
            }
            case 40: {
                return "SecurityException";
            }
            case 49: {
                return "RemoteException";
            }
            case 65: {
                return "UserException";
            }
            case 81: {
                return "APDUException";
            }
            case 82: {
                return "CryptoException";
            }
            case 83: {
                return "ISOException";
            }
            case 84: {
                return "PINException";
            }
            case 85: {
                return "ServiceException";
            }
            case 86: {
                return "SystemException";
            }
            case 87: {
                return "TransactionException";
            }
            case -86: {
                return "Unknown";
            }
        }
        return "Unknown";
    }
}

