// This file is part of the Java Card Firewall Tester program.
// 
// Authors: 
// 
// Wojciech Mostowski, woj@cs.ru.nl
// Erik Poll, erikpoll@cs.ru.nl
// Radboud University Nijmegen
// The Netherlands
// 
// Copyright (c) Wojciech Mostowski, Erik Poll,
// Radboud University Nijmegen (RU),
// Stichting Technische Wetenschappen (STW)
// 
// The Java Card Firewall Tester has been developed for the PinPas Java
// Card project, see http://www.win.tue.nl/pinpasjc/. The program is
// distributed under the licence terms that can be found in the LICENCE
// file in the main installation directory. Please refer to the LICENCE &
// README files for further information.

package firewallclients;

import javacard.framework.*;
import firewallinterface.*;

public class ClientApplet2 extends Applet {

    private static final byte RESET = (byte)0xaa;

    static ClientApplet2 instance;

    static final byte[] staticArray = new byte[TestInterface1.SIZE];

    public static void install(byte[] bArray, short bOffset, byte bLength) {
        new ClientApplet2().register(bArray, (short) (bOffset + 1), bArray[bOffset]);
    }

    private ClientApplet2() {
        instance = this;
    }

    public void process(APDU apdu) {
        if (selectingApplet()) {
            return;
        }
        byte[] buf = apdu.getBuffer();
        apdu.setIncomingAndReceive();
        switch (buf[ISO7816.OFFSET_INS]) {
        case RESET:
            ShareableObject.resetReferences();
            return;
        default:
            ISOException.throwIt(ISO7816.SW_INS_NOT_SUPPORTED);
        }
    }

    /**
      * @description Part of test2
      */
    boolean equalsAID(byte[] aid) {
        return JCSystem.getAID().equals(aid, TestInterface1.ZERO, (byte)aid.length);
    }

    /**
      * @description Part of test2
      */
    boolean checkPreviousAID() {
        return (JCSystem.getPreviousContextAID() == null);
    }

    byte[] createArray(short size, byte type) {
        return JCSystem.makeTransientByteArray(size, type);
    }

    void readWriteArray(byte[] a) {
        byte b = a[0];
        a[1] = 0x01;
    }
}

