// This file is part of the Java Card Firewall Tester program.
// 
// Authors: 
// 
// Wojciech Mostowski, woj@cs.ru.nl
// Erik Poll, erikpoll@cs.ru.nl
// Radboud University Nijmegen
// The Netherlands
// 
// Copyright (c) Wojciech Mostowski, Erik Poll,
// Radboud University Nijmegen (RU),
// Stichting Technische Wetenschappen (STW)
// 
// The Java Card Firewall Tester has been developed for the PinPas Java
// Card project, see http://www.win.tue.nl/pinpasjc/. The program is
// distributed under the licence terms that can be found in the LICENCE
// file in the main installation directory. Please refer to the LICENCE &
// README files for further information.

package firewallinterface;

import javacard.framework.*;
import javacardx.crypto.*;

public interface TestInterface1 extends Shareable {
    public static final byte TESTAIDLEN = 16;
    public static final short AIDBYTEMETHODS = 5;

    public static final short ZERO = 0;
    public static final short SIZE = 16;

    public byte[] getArray(byte type);
    public byte[] getArray(byte type, byte value);

    public boolean checkAID(byte[] aid, byte length);
    public boolean checkPreviousAID(byte[] aid, byte length);

    public void createArray(short size, byte type);
    public void readWriteArray(byte type);

    public void accessAPDU(APDU apdu);
    public void accessGlobalArray(byte[] array);
    public void accessAID(AID aid);

    public void parameterCheckAID(byte[] array, short mnum);
    public boolean parameterCheckAID2(Object o);
    public boolean parameterCheckAID3(AID o);


    public byte checkArray1(byte[] array);
    public void checkArray2(byte[] array);
    public short checkArray3(byte[] array);

    public void throwException1(NullPointerException e);
    public void throwException2(ISOException e) throws ISOException;
    public void throwException3();

    public void callRecursive();
    public void accessCipher(byte[] bufffer, boolean ext);
}

