;;***********************************************************************
;;
;; OPS5-programma op p. 392 omgezet naar CLIPS
;;
;;***********************************************************************

(deftemplate person 
   (slot name)
   (slot mother)
   (slot father))
  
(deftemplate kept
   (slot name))

(defrule query
   ?init <- (initial-fact)
   =>
   (retract ?init)
   (printout t "Enter name of Person: ")
   (bind ?name (read))
   (assert (kept (name ?name))))

(defrule ancestors
   ?wme <- (kept (name ?x&:(neq ?x nil)))
   (person (name ?x) (mother ?mother-name)
                     (father ?father-name))
  =>
  (retract ?wme)
  (printout t  ?mother-name " and " ?father-name
               " are parents of " ?x crlf)
  (assert (kept (name ?mother-name)))
  (assert (kept (name ?father-name))))

(deffacts people "initial database"
  (person (name Zeus)
          (mother Rhea) (father Cronus))
  (person (name Cronus)
          (mother Gaea) (father Uranus))
  (person (name Rhea) 
          (mother Gaea) (father Uranus))
  (person (name Gaea)
          (father Chaos))
  (person (name Hera)
          (mother Rhea) (father Cronus))
  (person (name Hephaestus)
          (mother Hera) (father Zeus))
  (person (name Leto)
          (mother Phoebe) (father Coeus))
  (person (name Apollo)
          (mother Leto) (father Zeus)))
