;;
;; Example circuit with only one component
;;

(defclass COMPONENT 
  (is-a USER)
  (role concrete)
  (pattern-match reactive))

(defclass CONNECTOR
  (is-a COMPONENT)
  (slot from (create-accessor read-write))
  (slot to-port (create-accessor read-write))
  (slot of-component (create-accessor read-write)))

(defclass INPUT
  (is-a USER)
  (role concrete)
  (pattern-match reactive)
  (slot out (create-accessor read-write)))

(defclass ANDGATE
  (is-a COMPONENT)
  (slot in1 (create-accessor read-write))
  (slot in2 (create-accessor read-write))
  (slot out (create-accessor read-write)))

(defmessage-handler ANDGATE fill-in-value (?slot-name ?value)
  (dynamic-put ?slot-name ?value))

(defclass WIRE
  (is-a CONNECTOR))

(defrule propagate-andgate-1
  "propagation rule 1 for AND gates"
  ?gate <- (object (is-a ANDGATE) (in1 ?x&:(neq ?x nil)) (in2 ?x))
  =>
  (send ?gate put-out ?x))

(defrule propagate-andgate-2
  "propagation rule 2 for AND gates"
  ?gate <- (object (is-a ANDGATE) 
                   (in1 ?x&:(neq ?x nil)) 
                   (in2 ?y&:(and (neq ?y nil) (neq ?x ?y))))
  =>
  (send ?gate put-out 0))

(defrule propagate-to-port
  "propagation rule to propagate input to port"
  (object (is-a WIRE)
          (from ?f) (to-port ?p) (of-component ?inst))
  =>
  (bind ?v (send ?f get-out))
  (send ?inst fill-in-value ?p ?v))

(definstances circuit 
  "structure of circuit"
  (i1 of INPUT (out 1))
  (i2 of INPUT (out 1))
  (A of ANDGATE)
  (W1 of WIRE (from [i1]) (to-port in1) (of-component [A]))
  (W2 of WIRE (from [i2]) (to-port in2) (of-component [A])))
