;;; Declaraties

(deftemplate person
   (slot name)
   (slot has-motive)
   (slot is-trustworthy))

(deftemplate innocent-person
   (slot name))

(deftemplate guilty-person
   (slot name))

(deftemplate suspected-person
   (slot name))

(deftemplate alibi
   (slot of)
   (slot confirmed-by))

;;; Produktieregels

(defrule suspect-rule
   (person (name ?x) (has-motive yes))
   (not (innocent-person (name ?x)))
   =>
   (assert (suspected-person (name ?x))))

(defrule innocent-rule
   (alibi (of ?x) (confirmed-by ?y))
   (person (name ?y) (is-trustworthy yes))
   =>
   (assert (innocent-person (name ?x))))

(defrule guilty-rule
   (suspected-person (name ?x))
   =>
   (assert (guilty-person (name ?x))))
