import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 * 
 * @author Sjaak Smetsers & Renske Smetsers-Weeda
 * @version 2.0 -- 08-08-2015
 */
public class Egg extends Actor
{
    private int     myValue;
    private boolean iAmHatched;
    
    public Egg( int value ) {
        myValue = value;
        iAmHatched = false;
    }
    
    public int getValue() {
        return myValue;
    }

    public boolean isHatched(){
        return iAmHatched;
    }
    
    public void setHatched(){
        if ( ! iAmHatched ) {            
            iAmHatched = true;
            GreenfootImage hatched_egg = new GreenfootImage("egg_hatched.png");
            setImage(hatched_egg);
        } else {
            showError( "egg already hatched" );
        }
    }
    
    public void push( int direction ) {
        if ( direction == Dodo.NORTH ) {
            setLocation( getX(), getY() - 1 );
        } else if ( direction == Dodo.EAST ) {
             setLocation(getX() + 1, getY() );
        } else if ( direction == Dodo.SOUTH ) {
            setLocation( getX(), getY() + 1 );
        } else { // ( direction == WEST )
            setLocation( getX() - 1, getY() );
        }
    }

    public boolean canBePushed( int direction ) {
        return (getNeighbour( direction, Fence.class ) == null &&
                getNeighbour( direction, Egg.class ) == null);
    }

    private <E extends Actor> E getNeighbour( int direction, Class<E> cls ){
        if ( direction == Dodo.NORTH ) {
            return (E) getOneObjectAtOffset(0,-1, cls);
        } else if ( direction == Dodo.EAST ) {
            return (E) getOneObjectAtOffset(1, 0, cls);
        } else if ( direction == Dodo.SOUTH ) {
            return (E) getOneObjectAtOffset(0, 1, cls);
        } else { // ( direction == WEST )
            return (E) getOneObjectAtOffset(-1,0, cls);
        }
    }

    private void showError ( String err_msg ) {
        if ( ! Message.messageActive( getWorld() ) ) {
            World my_world = getWorld();
            my_world.addObject (new Alert (err_msg),my_world.getWidth()/2, my_world.getHeight()/2);
        }
    }


}
