import greenfoot.*;  // (World, Actor, GreenfootImage, Greenfoot and MouseInfo)

/**
 *
 * @author Sjaak Smetsers & Renske Smetsers-Weeda
 * @version 2.0 -- 08-08-2015
 */
public class MyDodo extends Dodo
{
    private int myNrOfEggsHatched;

    public MyDodo() {
        this ( EAST );
    }

    public MyDodo( int init_direction ) {
        super ( init_direction );
        myNrOfEggsHatched = 0;
    }

    /**
     * If possible, take a step forward
     * Otherwise, walk around the fence
     * If egg is found, show a dialog with a compliment
     */
    public void act() {
        if ( canMove() ){
            move();
        }else{
            walkAroundFence();
        }

        if( foundEgg() ){
            showCompliment("Good job, egg found");
            Greenfoot.stop();
        }
    }

    /**
     * Walk around the fence
     */
    public void walkAroundFence() {
        turnLeft();
        move();
        turnRight();
        move();
        move();
        turnRight();
        move();
        turnLeft();

    }

    /**
     *
     */
    public void hatchEgg () {
        if ( foundEgg() ) {
            removeActor( getEgg() );
            myNrOfEggsHatched++;
        } else {
            showError( "There was no egg in this cell" );
        }
    }

    public int getNrOfEggsHatched() {
        return myNrOfEggsHatched;
    }

    /**
     * Move one cell forward in the current direction.
     */
    public void move() {
        if ( canMove() ) {
            step();
        } else {
            showError( "I'm stuck!" );
        }
    }

     /**
     * Test if we can move forward. Return true if we can, false otherwise.
     */
    public boolean canMove() {
        if ( ! borderAhead() && !fenceAhead() ){
            return true;
        } else {
            return false;
        }
    }

     /**
     * Walk to the end of the world in the direction currently facing.
     * Will not work if there is an obstruction (such as a fence) in the way.
     */
    public void walkToEdgeOfWorld(){
       while (! borderAhead() ){
           if( canMove() ){
               move();
            }
        }

    }


}
