import java.awt.Color;
import java.awt.Dimension;

import java.util.List;
import java.util.Arrays;

/**
 * Class DrawDemo - provides some short demonstrations showing how to use the 
 * Pen class to create various drawings.
 *
 * @author Michael Kölling and David J. Barnes
 * @version 2011.07.31
 */

public class DrawDemo
{
    private Canvas myCanvas;
    
    private static int CANVAS_WIDTH  = 500;
    private static int CANVAS_HEIGHT = 400;

    /**
     * Prepare the drawing demo. Create a fresh canvas and make it visible.
     */
    public DrawDemo() {
        myCanvas = new Canvas("Drawing Demo", CANVAS_WIDTH, CANVAS_HEIGHT);
    }

    /**
     * Draw a square on the screen.
     */
    public void drawSquare() {
        Pen pen = new Pen(320, 260, 0, myCanvas);
        pen.setColor(Color.BLUE);

        square(pen);
    }

    /**
     * Draw a wheel made of many squares.
     */
    public void drawWheel() {
        Dimension size = myCanvas.getSize();
        Pen pen = new Pen(size.width / 2, size.height / 2, 0, myCanvas);
        pen.setColor(Color.RED);

        int i = 0;
        while ( i < 36 ) {
            square(pen);
            pen.turn(10);
            i++;
        }
    }

    /**
     * Draw a square in the pen's color at the pen's location.
     */
    private void square(Pen pen) {
        int i = 0;
        while ( i < 4 ) {
            pen.move(100);
            pen.turn(90);
            i++;
        }
    }

    
    /**
     * Clear the screen.
     */
    public void clear() {
        myCanvas.erase();
    }

}
