/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.AriTokenData;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenQueue;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;

public class AriParser {
    private ParsingStatus _status;
    private TreeSet<String> _sorts;

    private AriParser(ParsingStatus status) {
        this._status = status;
    }

    private void readUntilCloseBracket() {
        int open = 1;
        while (open > 0) {
            Token next = this._status.nextToken();
            if (next.getName().equals(AriTokenData.BRACKETCLOSE)) {
                --open;
                continue;
            }
            if (next.getName().equals(AriTokenData.BRACKETOPEN)) {
                ++open;
                continue;
            }
            if (!next.isEof()) continue;
            return;
        }
    }

    private Type readType() {
        Token base = this._status.readNextIf(AriTokenData.IDENTIFIER);
        if (base != null) {
            String name = base.getText();
            if (!this._sorts.contains(name)) {
                this._status.storeError(base, "Undeclared sort: " + name);
            }
            return TypeFactory.createSort(name);
        }
        Token open = this._status.expect(AriTokenData.BRACKETOPEN, "sort name or opening bracket");
        if (open == null) {
            return null;
        }
        this._status.expect(AriTokenData.ARROW, "-> (arrow)");
        ArrayList<Type> parts = new ArrayList<Type>();
        do {
            Type arg;
            if ((arg = this.readType()) == null) {
                this.readUntilCloseBracket();
                return null;
            }
            parts.add(arg);
        } while (this._status.readNextIf(AriTokenData.BRACKETCLOSE) == null);
        if (parts.size() == 0) {
            this._status.storeError(open, "Empty type");
            return null;
        }
        Type ret = (Type)parts.get(parts.size() - 1);
        for (int i = parts.size() - 2; i >= 0; --i) {
            ret = TypeFactory.createArrow((Type)parts.get(i), ret);
        }
        return ret;
    }

    private void reallyExpectClosingBracket() {
        if (this._status.expect(AriTokenData.BRACKETCLOSE, "closing bracket") == null) {
            this.readUntilCloseBracket();
        }
    }

    private Parser.ParserTerm readTerm() {
        Token id = this._status.readNextIf(AriTokenData.IDENTIFIER);
        if (id != null) {
            return new Parser.Identifier(id, id.getText());
        }
        if (this._status.expect(AriTokenData.BRACKETOPEN, "opening bracket") == null) {
            return null;
        }
        Token main = this._status.readNextIf(AriTokenData.IDENTIFIER);
        if (main != null) {
            FixedList<Parser.ParserTerm> args;
            FixedList.Builder<Parser.ParserTerm> builder = new FixedList.Builder<Parser.ParserTerm>();
            while (this._status.readNextIf(AriTokenData.BRACKETCLOSE) == null) {
                Parser.ParserTerm arg = this.readTerm();
                if (arg == null) {
                    this.readUntilCloseBracket();
                    break;
                }
                builder.add(arg);
            }
            if ((args = builder.build()).size() == 0) {
                this._status.storeError(main, "Identifier without arguments should not be in brackets.");
            }
            Parser.Identifier head = new Parser.Identifier(main, main.getText());
            return new Parser.Application(main, head, args);
        }
        Token lambda = this._status.expect(AriTokenData.LAMBDA, "identifier or lambda");
        if (lambda == null) {
            return null;
        }
        ArrayList<Parser.ParserDeclaration> vars = this.readLambdaVariables();
        Parser.ParserTerm term = this.readTerm();
        this.reallyExpectClosingBracket();
        if (term == null) {
            return null;
        }
        if (vars.size() == 0) {
            this._status.storeError(lambda, "Lambda should have at least one variable.");
            return term;
        }
        for (int i = vars.size() - 1; i >= 0; --i) {
            term = new Parser.Lambda(vars.get(i).token(), vars.get(i).name(), vars.get(i).type(), term);
        }
        return term;
    }

    private ArrayList<Parser.ParserDeclaration> readLambdaVariables() {
        ArrayList<Parser.ParserDeclaration> ret = new ArrayList<Parser.ParserDeclaration>();
        if (this._status.expect(AriTokenData.BRACKETOPEN, "opening bracket (for variable declarations)") == null) {
            return ret;
        }
        while (this._status.readNextIf(AriTokenData.BRACKETCLOSE) == null) {
            Token open = this._status.expect(AriTokenData.BRACKETOPEN, "opening bracket");
            Token id = this._status.expect(AriTokenData.IDENTIFIER, "identifier (variable name)");
            Type type = this.readType();
            if (open != null) {
                this.reallyExpectClosingBracket();
            }
            if (id == null && type == null) {
                this.reallyExpectClosingBracket();
                return ret;
            }
            if (id == null || type == null) continue;
            ret.add(new Parser.ParserDeclaration(open, id.getText(), type));
        }
        return ret;
    }

    private TrsFormat readFormat() {
        this._status.expect(AriTokenData.BRACKETOPEN, "opening bracket");
        this._status.expect(AriTokenData.FORMAT, "\"format\"");
        Token tmp = this._status.expect(AriTokenData.IDENTIFIER, "identifier describing the format");
        this._status.expect(AriTokenData.BRACKETCLOSE, "closing bracket");
        if (tmp == null) {
            return null;
        }
        if (tmp.getText().equals("higher-order")) {
            return TrsFormat.HigherOrder;
        }
        this._status.storeError(tmp, "Format is not currently supported: " + tmp.getText());
        return null;
    }

    private void readSorts() {
        Token open;
        while ((open = this._status.readNextIf(AriTokenData.BRACKETOPEN)) != null) {
            if (this._status.readNextIf(AriTokenData.SORT) == null) {
                this._status.pushBack(open);
                return;
            }
            Token name = this._status.expect(AriTokenData.IDENTIFIER, "identifier (sort name)");
            this._status.expect(AriTokenData.BRACKETCLOSE, "closing bracket");
            if (name == null) continue;
            this._sorts.add(name.getText());
        }
        return;
    }

    private void readDeclarations(LookupMap.Builder<Parser.ParserDeclaration> symbols) {
        Token open;
        while ((open = this._status.readNextIf(AriTokenData.BRACKETOPEN)) != null) {
            if (this._status.readNextIf(AriTokenData.FUN) == null) {
                this._status.pushBack(open);
                return;
            }
            Token name = this._status.expect(AriTokenData.IDENTIFIER, "identifier (symbol name)");
            Type type = name == null ? null : this.readType();
            this._status.expect(AriTokenData.BRACKETCLOSE, "closing bracket");
            if (name == null || type == null) continue;
            String n = name.getText();
            if (symbols.containsKey(n)) {
                this._status.storeError(name, "Duplicate definition of function symbol " + n);
                continue;
            }
            symbols.put(n, new Parser.ParserDeclaration(name, n, type));
        }
        return;
    }

    private void readRules(FixedList.Builder<Parser.ParserRule> rules) {
        Token open;
        while ((open = this._status.readNextIf(AriTokenData.BRACKETOPEN)) != null) {
            Token ruletok = this._status.readNextIf(AriTokenData.RULE);
            if (ruletok == null) {
                this._status.pushBack(open);
                return;
            }
            Parser.ParserTerm left = this.readTerm();
            Parser.ParserTerm right = this.readTerm();
            this._status.expect(AriTokenData.BRACKETCLOSE, "closing bracket");
            LookupMap.Builder builder = new LookupMap.Builder();
            Parser.ParserRule rule = new Parser.ParserRule(ruletok, builder.build(), left, right);
            rules.add(rule);
        }
        return;
    }

    private Parser.ParserProgram readTRS() {
        LookupMap.Builder<Parser.ParserDeclaration> symbols = new LookupMap.Builder<Parser.ParserDeclaration>();
        FixedList.Builder<Parser.ParserRule> rules = new FixedList.Builder<Parser.ParserRule>();
        TrsFormat format = this.readFormat();
        if (format == null) {
            return null;
        }
        this._sorts = new TreeSet();
        this.readSorts();
        this.readDeclarations(symbols);
        this.readRules(rules);
        return new Parser.ParserProgram(symbols.build(), rules.build());
    }

    private static Parser.ParserProgram readProgram(TokenQueue queue, ErrorCollector collector) {
        ParsingStatus status = new ParsingStatus(queue, collector == null ? new ErrorCollector() : collector);
        AriParser parser = new AriParser(status);
        Parser.ParserProgram program = parser.readTRS();
        if (program != null) {
            status.expect(Token.EOF, "end of input");
        }
        if (collector == null || program == null) {
            status.throwCollectedErrors();
        }
        return program;
    }

    public static Parser.ParserProgram readProgramFromString(String str, ErrorCollector collector) {
        return AriParser.readProgram(AriTokenData.getStringLexer(str), collector);
    }

    public static Parser.ParserProgram readProgramFromString(String str) {
        return AriParser.readProgramFromString(str, null);
    }

    public static Parser.ParserProgram readProgramFromFile(String filename, ErrorCollector coll) throws IOException {
        return AriParser.readProgram(AriTokenData.getFileLexer(filename), coll);
    }

    private static enum TrsFormat {
        HigherOrder;

    }
}

