/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerFactory;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenQueue;
import java.io.IOException;

public class AriTokenData {
    public static String FORMAT = "FORMAT";
    public static String SORT = "SORT";
    public static String FUN = "FUN";
    public static String RULE = "RULE";
    public static String LAMBDA = "LAMBDA";
    public static String IDENTIFIER = "IDENTIFIER";
    public static String BRACKETOPEN = "BRACKETOPEN";
    public static String BRACKETCLOSE = "BRACKETCLOSE";
    public static String ARROW = "ARROW";
    private static String _letter = "[a-z]|[A-Z]";
    private static String _legalchar = "~|!|@|\\$|%|\\^|&|\\*|_|-|\\+|=|<|>|\\.|\\?|\\/";
    private static String _digit = "[0-9]";
    private static String[] tokens = new String[]{"format", FORMAT, "sort", SORT, "fun", FUN, "rule", RULE, "lambda", LAMBDA, "\\|", "BAR", "->", ARROW, "(" + _letter + "|" + _legalchar + ")(" + _letter + "|" + _legalchar + "|" + _digit + ")*", IDENTIFIER, "\\(", BRACKETOPEN, "\\)", BRACKETCLOSE, "\\s", Token.SKIP, ";.*$", Token.SKIP};

    private static TokenQueue updateLexer(ChangeableLexer mylexer) {
        Lexer lexer = LexerFactory.createLongTokenLexer(mylexer, "BAR", "[^|\\\\]", "\\|", IDENTIFIER);
        lexer = LexerFactory.createErrorLexer(lexer, Token.CATCHALL, "Unexpected symbol: @TEXT@. This symbol is not permitted in an ARI input file.");
        return LexerFactory.createPushbackLexer(lexer);
    }

    public static TokenQueue getStringLexer(String str) {
        return AriTokenData.updateLexer(LexerFactory.createStringLexer(tokens, str));
    }

    public static TokenQueue getFileLexer(String filename) throws IOException {
        return AriTokenData.updateLexer(LexerFactory.createFileLexer(tokens, filename));
    }
}

