/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.CoraTokenData;
import charlie.parser.InfixManager;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenQueue;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.util.ArrayList;

public class CoraParser {
    public static final String PLUS = "+";
    public static final String MINUS = "-";
    public static final String TIMES = "*";
    public static final String DIV = "/";
    public static final String MOD = "%";
    public static final String GREATER = ">";
    public static final String SMALLER = "<";
    public static final String GEQ = "\u2265";
    public static final String LEQ = "\u2264";
    public static final String EQUALS = "=";
    public static final String EQUALSINT = "=_i";
    public static final String EQUALSSTRING = "=_s";
    public static final String EQUALSBOOL = "\u21d4";
    public static final String NEQ = "\u2260";
    public static final String NEQINT = "\u2260_i";
    public static final String NEQSTRING = "\u2260_s";
    public static final String NEQBOOL = "XOR";
    public static final String AND = "\u2227";
    public static final String OR = "\u2228";
    public static final String NOT = "\u00ac";
    private ParsingStatus _status;
    private InfixManager _manager;

    private CoraParser(ParsingStatus status) {
        this._status = status;
        this._manager = new InfixManager();
        this._manager.addGroup(2, 1, EQUALSBOOL);
        this._manager.addGroup(2, 1, NEQBOOL);
        this._manager.addGroup(1, 1, AND);
        this._manager.addGroup(1, 1, OR);
        this._manager.addGroup(3, 2, EQUALS, EQUALSINT, EQUALSSTRING, NEQ, NEQINT, NEQSTRING, GREATER, SMALLER, GEQ, LEQ);
        this._manager.addGroup(1, 3, PLUS, MINUS);
        this._manager.addGroup(1, 4, TIMES, DIV, MOD);
    }

    private String tryReadIdentifier() {
        Token next = this._status.readNextIf("IDENTIFIER");
        if (next != null) {
            return next.getText();
        }
        return null;
    }

    private Type readType() {
        Type start = this.readBasicType();
        if (this._status.readNextIf("ARROW") == null) {
            return start;
        }
        Type end = this.readType();
        if (start != null && end != null) {
            return TypeFactory.createArrow(start, end);
        }
        if (start == null) {
            return end;
        }
        return start;
    }

    private Type readBasicType() {
        if (this._status.readNextIf("INTTYPE") != null) {
            return TypeFactory.intSort;
        }
        if (this._status.readNextIf("BOOLTYPE") != null) {
            return TypeFactory.boolSort;
        }
        if (this._status.readNextIf("STRINGTYPE") != null) {
            return TypeFactory.stringSort;
        }
        String name = this.tryReadIdentifier();
        if (name != null) {
            return TypeFactory.createSort(name);
        }
        if (this._status.nextTokenIs("TUPLEOPEN")) {
            return this.readProductType();
        }
        Token bracket = this._status.expect("BRACKETOPEN", "a type (started by a sort identifier or bracket)");
        if (bracket == null) {
            return null;
        }
        Type ret = this.readType();
        this._status.expect("BRACKETCLOSE", "closing bracket");
        return ret;
    }

    private Type readProductType() {
        this._status.expect("TUPLEOPEN", "tuple opening bracket");
        ArrayList<Type> components = new ArrayList<Type>();
        Type arg = this.readType();
        while (this._status.readNextIf("COMMA") != null) {
            if (arg != null) {
                components.add(arg);
            }
            arg = this.readType();
        }
        if (arg != null) {
            components.add(arg);
        }
        if (this._status.expect("TUPLECLOSE", "tuple closing bracket") == null) {
            this._status.readNextIf("BRACKETCLOSE");
        }
        if (components.size() == 0) {
            return null;
        }
        if (components.size() == 1) {
            return components.get(0);
        }
        return TypeFactory.createProduct(components);
    }

    private Parser.ParserTerm readSingleSymbol() {
        if (this._status.nextTokenIs("STRING") || this._status.nextTokenIs("INTEGER") || this._status.nextTokenIs("TRUE") || this._status.nextTokenIs("FALSE")) {
            return this.readValue();
        }
        InfixManager.OperatorData data = this.tryReadInfixSymbol();
        if (data != null) {
            return new Parser.CalcSymbol(data.token(), data.name());
        }
        Token token = this._status.readNextIf("NOT");
        if (token != null) {
            return new Parser.CalcSymbol(token, NOT);
        }
        if (this._status.readNextIf("METAOPEN") != null) {
            token = this._status.peekNext();
            data = this.tryReadInfixSymbol();
            if (data == null && this._status.readNextIf("NOT") != null) {
                data = new InfixManager.OperatorData(token, NOT);
            }
            if (data == null) {
                this._status.storeError(token, "Expected infix symbol but got " + token.getName() + " (" + token.getText() + ")");
                Parser.PErr ret = new Parser.PErr(new Parser.Identifier(token, token.getText()));
                this._status.nextToken();
                return ret;
            }
            this._status.expect("METACLOSE", "infix closing bracket ]");
            return new Parser.CalcSymbol(data.token(), data.name());
        }
        token = this._status.expect("IDENTIFIER", "function symbol (or variable) name");
        if (token == null) {
            return new Parser.PErr(new Parser.Identifier(this._status.nextToken(), "UNKNOWN"));
        }
        return new Parser.Identifier(token, token.getText());
    }

    private Parser.ParserTerm readTerm() {
        if (this._status.nextTokenIs("LAMBDA")) {
            return this.readAbstraction();
        }
        Parser.ParserTerm ret = this.readMainTerm();
        if (ret == null) {
            return null;
        }
        InfixManager.OperatorData operator = this.tryReadInfixSymbol();
        if (operator == null) {
            return ret;
        }
        ArrayList<Parser.ParserTerm> parts = new ArrayList<Parser.ParserTerm>();
        ArrayList<InfixManager.OperatorData> ops = new ArrayList<InfixManager.OperatorData>();
        parts.add(ret);
        boolean errored = false;
        while (operator != null) {
            ops.add(operator);
            Parser.ParserTerm pt = this.readMainTerm();
            if (pt == null) {
                errored = true;
                ops.remove(ops.size() - 1);
                break;
            }
            parts.add(pt);
            operator = this.tryReadInfixSymbol();
        }
        ret = this._manager.convertChain(parts, ops, this._status);
        if (errored) {
            ret = new Parser.PErr(ret);
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Parser.ParserTerm readMainTerm() {
        FixedList<Parser.ParserTerm> args;
        Object ret;
        block22: {
            FixedList<Parser.ParserTerm> args2;
            Token token;
            block26: {
                block25: {
                    block24: {
                        block23: {
                            ret = null;
                            token = this._status.readNextIf("NOT");
                            if (token != null) {
                                Parser.ParserTerm child = this.readMainTerm();
                                if (child == null) {
                                    return new Parser.CalcSymbol(token, NOT);
                                }
                                return new Parser.Application(token, new Parser.CalcSymbol(token, NOT), FixedList.of(child));
                            }
                            token = this._status.readNextIf("MINUS");
                            if (token != null) {
                                Parser.ParserTerm child = this.readMainTerm();
                                if (child == null) {
                                    return new Parser.CalcSymbol(token, MINUS);
                                }
                                if (!(child instanceof Parser.IntVal)) {
                                    return new Parser.Application(token, new Parser.CalcSymbol(token, MINUS), FixedList.of(child));
                                }
                                Parser.IntVal intVal = (Parser.IntVal)child;
                                try {
                                    int n;
                                    Token token2;
                                    Token t = token2 = intVal.token();
                                    int v = n = intVal.value();
                                    return new Parser.IntVal(token, -v);
                                }
                                catch (Throwable throwable) {
                                    throw new MatchException(throwable.toString(), throwable);
                                }
                            }
                            if (!this._status.nextTokenIs("STRING") && !this._status.nextTokenIs("INTEGER") && !this._status.nextTokenIs("TRUE") && !this._status.nextTokenIs("FALSE")) break block23;
                            ret = this.readValue();
                            break block22;
                        }
                        if (this._status.readNextIf("BRACKETOPEN") == null) break block24;
                        ret = this.readTerm();
                        if (ret == null) {
                            this._status.readNextIf("BRACKETCLOSE");
                            return null;
                        }
                        if (this._status.expect("BRACKETCLOSE", "a closing bracket") == null) {
                            return new Parser.PErr((Parser.ParserTerm)ret);
                        }
                        break block22;
                    }
                    if (this._status.readNextIf("METAOPEN") == null) break block25;
                    token = this._status.peekNext();
                    InfixManager.OperatorData data = this.tryReadInfixSymbol();
                    if (data == null && this._status.readNextIf("NOT") != null) {
                        data = new InfixManager.OperatorData(token, NOT);
                    }
                    if (data == null) {
                        this._status.storeError(token, "Expected infix symbol but got " + token.getName() + " (" + token.getText() + ")");
                        ret = new Parser.PErr(new Parser.Identifier(token, token.getText()));
                        this._status.nextToken();
                    } else {
                        ret = new Parser.CalcSymbol(data.token(), data.name());
                    }
                    Token end = this._status.expect("METACLOSE", "infix closing bracket ]");
                    if (end == null) {
                        return new Parser.PErr((Parser.ParserTerm)ret);
                    }
                    break block22;
                }
                token = this._status.readNextIf("TUPLEOPEN");
                if (token == null) break block26;
                args = this.readTermList("TUPLECLOSE", "tuple closing bracket |)");
                if (args == null || args.size() == 0) {
                    ret = new Parser.PErr(new Parser.Identifier(token, "(| |)"));
                    if (args != null) {
                        this._status.storeError(token, "Empty tuples are not allowed.");
                    }
                    break block22;
                } else if (args.size() == 1) {
                    this._status.storeError(token, "Tuples of length 1 are not allowed.");
                    ret = args.get(0);
                    break block22;
                } else {
                    ret = new Parser.Tup(token, args);
                }
                break block22;
            }
            token = this._status.expect("IDENTIFIER", "term, started by an identifier, LAMBDA, string or (,");
            if (token == null) {
                return null;
            }
            Token next = this._status.readNextIf("METAOPEN");
            ret = next != null ? ((args2 = this.readTermList("METACLOSE", "meta-closing bracket " + (next.getText().equals("\u27e8") ? "\u27e9" : "]"))) == null ? new Parser.PErr(new Parser.Meta(token, token.getText(), FixedList.of())) : new Parser.Meta(token, token.getText(), args2)) : new Parser.Identifier(token, token.getText());
        }
        while (this._status.readNextIf("BRACKETOPEN") != null) {
            args = this.readTermList("BRACKETCLOSE", "closing bracket )");
            if (args == null) {
                ret = new Parser.PErr((Parser.ParserTerm)ret);
                continue;
            }
            ret = new Parser.Application(ret.token(), (Parser.ParserTerm)ret, args);
        }
        return ret;
    }

    private Parser.ParserTerm readAbstraction() {
        Parser.ParserTerm ret;
        ArrayList<Type> types;
        ArrayList<String> variables;
        ArrayList<Token> tokens;
        boolean errored;
        block9: {
            if (this._status.expect("LAMBDA", "a LAMBDA") == null) {
                return null;
            }
            errored = false;
            tokens = new ArrayList<Token>();
            variables = new ArrayList<String>();
            types = new ArrayList<Type>();
            do {
                String name = null;
                Type type = null;
                Token token = this._status.expect("IDENTIFIER", "an identifier (variable name)");
                if (token != null) {
                    name = token.getText();
                }
                if (this._status.readNextIf("DECLARE") != null && (type = this.readType()) == null) {
                    errored = true;
                }
                if (name != null) {
                    tokens.add(token);
                    variables.add(name);
                    types.add(type);
                } else {
                    errored = true;
                }
                if (this._status.readNextIf("DOT") != null) break block9;
            } while (this._status.expect("COMMA", "a comma or dot") != null || this._status.nextTokenIs("IDENTIFIER"));
            errored = true;
        }
        if ((ret = this.readTerm()) == null) {
            return null;
        }
        for (int i = variables.size() - 1; i >= 0; --i) {
            ret = new Parser.Lambda((Token)tokens.get(i), (String)variables.get(i), (Type)types.get(i), ret);
        }
        if (errored) {
            ret = new Parser.PErr(ret);
        }
        return ret;
    }

    private Parser.ParserTerm readValue() {
        Token next;
        Token token = this._status.nextToken();
        if (token.getName().equals("TRUE")) {
            return new Parser.BoolVal(token, true);
        }
        if (token.getName().equals("FALSE")) {
            return new Parser.BoolVal(token, false);
        }
        if (token.getName().equals("INTEGER")) {
            try {
                int number = Integer.parseInt(token.getText());
                return new Parser.IntVal(token, number);
            }
            catch (NumberFormatException e) {
                this._status.storeError(token, "Cannot parse integer constant: " + token.getText());
                return new Parser.Identifier(token, token.getText());
            }
        }
        if (!token.getName().equals("STRING")) {
            throw new RuntimeException("Calling readValue when it shouldn't be.");
        }
        StringBuilder text = new StringBuilder(token.getText().substring(0, token.getText().length() - 1));
        while ((next = this._status.readNextIf("STRING")) != null) {
            text.append(next.getText().substring(1, next.getText().length() - 1));
        }
        text.append("\"");
        return new Parser.StringVal(token, text.toString());
    }

    private FixedList<Parser.ParserTerm> readTermList(String followName, String followDescription) {
        if (this._status.readNextIf(followName) != null) {
            return FixedList.of();
        }
        ArrayList<Parser.ParserTerm> ret = new ArrayList<Parser.ParserTerm>();
        boolean errored = false;
        while (true) {
            Parser.ParserTerm arg;
            Token token;
            if ((token = this._status.readNextIf("COMMA")) != null) {
                this._status.storeError(token, "Unexpected comma; expected term or " + followDescription);
                errored = true;
                while (this._status.readNextIf("COMMA") != null) {
                }
            }
            if ((arg = this.readTerm()) == null) {
                errored = true;
            } else {
                if (errored) {
                    arg = new Parser.PErr(arg);
                    errored = false;
                }
                ret.add(arg);
            }
            if (this._status.readNextIf(followName) != null) break;
            if (this._status.expect("COMMA", "a comma or " + followDescription) != null) continue;
            errored = true;
            if (!this.nextMayBeTerm()) break;
        }
        if (errored) {
            if (ret.size() == 0) {
                return null;
            }
            ret.set(ret.size() - 1, new Parser.PErr((Parser.ParserTerm)ret.get(ret.size() - 1)));
        }
        return FixedList.copy(ret);
    }

    private InfixManager.OperatorData tryReadInfixSymbol() {
        Token token = this._status.peekNext();
        if (this._status.readNextIf("PLUS") != null) {
            return new InfixManager.OperatorData(token, PLUS);
        }
        if (this._status.readNextIf("MINUS") != null) {
            return new InfixManager.OperatorData(token, MINUS);
        }
        if (this._status.readNextIf("TIMES") != null) {
            return new InfixManager.OperatorData(token, TIMES);
        }
        if (this._status.readNextIf("DIV") != null) {
            return new InfixManager.OperatorData(token, DIV);
        }
        if (this._status.readNextIf("MOD") != null) {
            return new InfixManager.OperatorData(token, MOD);
        }
        if (this._status.readNextIf("AND") != null) {
            return new InfixManager.OperatorData(token, AND);
        }
        if (this._status.readNextIf("OR") != null) {
            return new InfixManager.OperatorData(token, OR);
        }
        if (this._status.readNextIf("GREATER") != null) {
            return new InfixManager.OperatorData(token, GREATER);
        }
        if (this._status.readNextIf("SMALLER") != null) {
            return new InfixManager.OperatorData(token, SMALLER);
        }
        if (this._status.readNextIf("GEQ") != null) {
            return new InfixManager.OperatorData(token, GEQ);
        }
        if (this._status.readNextIf("LEQ") != null) {
            return new InfixManager.OperatorData(token, LEQ);
        }
        if (this._status.readNextIf("EQUAL") != null) {
            return new InfixManager.OperatorData(token, EQUALS);
        }
        if (this._status.readNextIf("UNEQUAL") != null) {
            return new InfixManager.OperatorData(token, NEQ);
        }
        if (this._status.readNextIf("EQUALINT") != null) {
            return new InfixManager.OperatorData(token, EQUALSINT);
        }
        if (this._status.readNextIf("EQUALSTRING") != null) {
            return new InfixManager.OperatorData(token, EQUALSSTRING);
        }
        if (this._status.readNextIf("EQUALBOOL") != null) {
            return new InfixManager.OperatorData(token, EQUALSBOOL);
        }
        if (this._status.readNextIf("UNEQUALINT") != null) {
            return new InfixManager.OperatorData(token, NEQINT);
        }
        if (this._status.readNextIf("UNEQUALSTRING") != null) {
            return new InfixManager.OperatorData(token, NEQSTRING);
        }
        if (this._status.readNextIf("UNEQUALBOOL") != null) {
            return new InfixManager.OperatorData(token, NEQBOOL);
        }
        return null;
    }

    private boolean nextMayBeTerm() {
        return this._status.nextTokenIs("LAMBDA") || this._status.nextTokenIs("STRING") || this._status.nextTokenIs("INTEGER") || this._status.nextTokenIs("TRUE") || this._status.nextTokenIs("FALSE") || this._status.nextTokenIs("BRACKETOPEN") || this._status.nextTokenIs("METAOPEN") || this._status.nextTokenIs("IDENTIFIER");
    }

    private LookupMap<Parser.ParserDeclaration> readEnvironment() {
        LookupMap.Builder<Parser.ParserDeclaration> ret = new LookupMap.Builder<Parser.ParserDeclaration>();
        if (this._status.expect("BRACEOPEN", "environment opening brace {") == null) {
            return ret.build();
        }
        if (this._status.readNextIf("BRACECLOSE") != null) {
            return ret.build();
        }
        do {
            Parser.ParserDeclaration decl;
            if ((decl = this.readMetaVariableDeclaration()) != null) {
                String name = decl.name();
                if (ret.containsKey(name)) {
                    String kind = decl.extra() == 0 ? "variable" : "meta-variable";
                    this._status.storeError(decl.token(), "Redeclaration of " + (decl.extra() == 0 ? "variable " : "meta-variable ") + name + " in the same environment.");
                } else {
                    ret.put(decl.name(), decl);
                }
            }
            if (this._status.readNextIf("BRACECLOSE") == null) continue;
            return ret.build();
        } while (this._status.expect("COMMA", "comma or }") != null || this.readRecoverEnvironment().getName().equals("COMMA"));
        return ret.build();
    }

    private Parser.ParserDeclaration readMetaVariableDeclaration() {
        Type type;
        Token token = this._status.expect("IDENTIFIER", "a variable or meta-variable name");
        Token decl = this._status.expect("DECLARE", "declare symbol (::)");
        if (token == null && decl == null) {
            return null;
        }
        ArrayList<Type> args = new ArrayList<Type>();
        if (this._status.readNextIf("METAOPEN") != null) {
            block8: {
                if (this._status.readNextIf("METACLOSE") == null) {
                    do {
                        if ((type = this.readType()) != null) {
                            args.add(type);
                        }
                        if (this._status.readNextIf("METACLOSE") != null) break block8;
                    } while (this._status.expect("COMMA", "comma or ] or \u27e9") != null || type != null);
                    return null;
                }
            }
            this._status.expect("ARROW", "arrow operator ->");
        } else {
            this._status.readNextIf("ARROW");
        }
        type = this.readType();
        if (type == null) {
            return null;
        }
        for (int i = args.size() - 1; i >= 0; --i) {
            type = TypeFactory.createArrow((Type)args.get(i), type);
        }
        return new Parser.ParserDeclaration(token, token.getText(), type, args.size());
    }

    private Token readRecoverEnvironment() {
        Token next = this._status.nextToken();
        while (!(next.isEof() || next.getName().equals("COMMA") || next.getName().equals("BRACEOPEN") || next.getName().equals("BRACECLOSE"))) {
            next = this._status.nextToken();
        }
        if (!next.getName().equals("COMMA") && !next.getName().equals("BRACECLOSE")) {
            this._status.pushBack(next);
        }
        return next;
    }

    private Parser.ParserRule readRule() {
        Token start = this._status.peekNext();
        LookupMap<Parser.ParserDeclaration> vars = null;
        vars = this._status.nextTokenIs("BRACEOPEN") ? this.readEnvironment() : LookupMap.empty();
        if (this._status.nextTokenIs("BRACEOPEN")) {
            return null;
        }
        Parser.ParserTerm left = this.readTerm();
        boolean ok = this._status.expect("ARROW", "an arrow (\u2192 or ->)") != null;
        Parser.ParserTerm right = ok ? this.readTerm() : null;
        Parser.ParserTerm constraint = null;
        if (this._status.readNextIf("MID") != null) {
            constraint = this.readTerm();
        }
        if (left != null && right != null) {
            return new Parser.ParserRule(start, vars, left, right, constraint);
        }
        if (right == null || right.hasErrors() || constraint != null && constraint.hasErrors()) {
            this.recoverState();
        }
        return null;
    }

    private void recoverState() {
        Token prev = null;
        Token curr = null;
        boolean intype = true;
        while (true) {
            Parser.ParserTerm term;
            prev = curr;
            curr = this._status.nextToken();
            if (curr.isEof()) {
                return;
            }
            if (curr.getName().equals("BRACEOPEN")) {
                this._status.pushBack(curr);
                return;
            }
            if (curr.getName().equals("BRACECLOSE")) {
                this._status.pushBack(curr);
                return;
            }
            if (curr.getName().equals("PUBLIC") || curr.getName().equals("PRIVATE")) {
                this._status.pushBack(curr);
                return;
            }
            if (curr.getName().equals("MID") && (term = this.readTerm()) != null && !term.hasErrors()) {
                return;
            }
            if (curr.getName().equals("DECLARE") && prev != null && prev.getName().equals("IDENTIFIER")) {
                this._status.pushBack(curr);
                this._status.pushBack(prev);
                return;
            }
            if (curr.getName().equals("DECLARE")) {
                intype = true;
            }
            if ((curr.getName().equals("BRACKETOPEN") || curr.getName().equals("METAOPEN")) && prev != null && prev.getName().equals("IDENTIFIER")) {
                intype = false;
            }
            if (curr.getName().equals("DOT")) {
                intype = false;
            }
            if (!curr.getName().equals("ARROW") || intype) continue;
            Parser.ParserTerm t = this.readTerm();
            if (t != null && this._status.readNextIf("MID") != null) {
                t = this.readTerm();
            }
            if (t != null && !t.hasErrors()) break;
        }
    }

    private Parser.ParserDeclaration tryReadDeclaration() {
        Token constant;
        Token priv;
        Token publ = this._status.readNextIf("PUBLIC");
        Token token = priv = publ != null ? null : this._status.readNextIf("PRIVATE");
        if (publ != null || priv != null) {
            constant = this._status.expect("IDENTIFIER", "an identifier (for a function symbol name to be declared)");
            Token declaresymb = this._status.expect("DECLARE", "::");
            if (constant == null || declaresymb == null) {
                this.recoverState();
                return new Parser.ParserDeclaration(publ == null ? priv : publ, "public/private", null);
            }
        } else {
            constant = this._status.readNextIf("IDENTIFIER");
            if (constant == null) {
                return null;
            }
            if (this._status.readNextIf("DECLARE") == null) {
                this._status.pushBack(constant);
                return null;
            }
        }
        Type type = this.readType();
        String name = constant.getText();
        if (this._status.nextTokenIs("BRACECLOSE")) {
            if (publ != null || priv != null) {
                this._status.storeError(this._status.peekNext(), "Function symbol declartion cannot be followed by }!");
            }
            return new Parser.ParserDeclaration(constant, name, null);
        }
        if (this._status.nextTokenIs("COMMA") || this._status.nextTokenIs("DOT") || type == null) {
            if (publ != null || priv != null) {
                Token tok = this._status.peekNext();
                this._status.storeError(this._status.peekNext(), "Function symbol declartion cannot be followed by " + (tok.getName().equals("COMMA") ? "comma" : "dot") + "!");
            }
            this.recoverState();
            return new Parser.ParserDeclaration(constant, name, null);
        }
        return new Parser.ParserDeclaration(constant, name, type, priv == null ? 0 : 1);
    }

    private Parser.ParserProgram readTRS() {
        LookupMap.Builder<Parser.ParserDeclaration> symbols = new LookupMap.Builder<Parser.ParserDeclaration>();
        FixedList.Builder<Parser.ParserRule> rules = new FixedList.Builder<Parser.ParserRule>();
        while (!this._status.peekNext().isEof()) {
            Parser.ParserDeclaration decl = this.tryReadDeclaration();
            if (decl == null) {
                Parser.ParserRule rule = this.readRule();
                if (rule == null) continue;
                rules.add(rule);
                continue;
            }
            if (decl.type() == null) continue;
            if (symbols.containsKey(decl.name())) {
                this._status.storeError(decl.token(), "Redeclaration of previously declared function symbol " + decl.name() + ".");
                continue;
            }
            symbols.put(decl.name(), decl);
        }
        return new Parser.ParserProgram(symbols.build(), rules.build());
    }

    private static ParsingStatus makeStatus(String str, boolean constrained, ErrorCollector collector) {
        if (collector == null) {
            collector = new ErrorCollector();
        }
        TokenQueue queue = constrained ? CoraTokenData.getConstrainedStringLexer(str) : CoraTokenData.getUnconstrainedStringLexer(str);
        return new ParsingStatus(queue, collector);
    }

    private static void finish(ParsingStatus status, boolean throwErrors) {
        status.expect(Token.EOF, "end of input");
        if (throwErrors) {
            status.throwCollectedErrors();
        }
    }

    public static Type readType(String str, boolean constrainedTRS, ErrorCollector collector) {
        ParsingStatus status = CoraParser.makeStatus(str, constrainedTRS, collector);
        CoraParser parser = new CoraParser(status);
        Type ret = parser.readType();
        CoraParser.finish(status, collector == null || ret == null);
        return ret;
    }

    public static Type readType(String str) {
        return CoraParser.readType(str, true, null);
    }

    public static Type readType(ParsingStatus status) {
        CoraParser parser = new CoraParser(status);
        return parser.readType();
    }

    public static Parser.ParserTerm readTerm(String str, boolean constrainedTRS, ErrorCollector collector) {
        ParsingStatus status = CoraParser.makeStatus(str, constrainedTRS, collector);
        CoraParser parser = new CoraParser(status);
        Parser.ParserTerm ret = parser.readTerm();
        CoraParser.finish(status, collector == null || ret == null);
        return ret;
    }

    public static Parser.ParserTerm readTerm(ParsingStatus status) {
        CoraParser parser = new CoraParser(status);
        return parser.readTerm();
    }

    public static Parser.ParserTerm readSingleSymbol(ParsingStatus status) {
        CoraParser parser = new CoraParser(status);
        return parser.readSingleSymbol();
    }

    public static LookupMap<Parser.ParserDeclaration> readEnvironment(ParsingStatus status) {
        CoraParser parser = new CoraParser(status);
        return parser.readEnvironment();
    }

    public static Parser.ParserRule readRule(String str, boolean constrained, ErrorCollector collector) {
        ParsingStatus status = CoraParser.makeStatus(str, constrained, collector);
        CoraParser parser = new CoraParser(status);
        Parser.ParserRule rule = parser.readRule();
        CoraParser.finish(status, collector == null || rule == null);
        return rule;
    }

    public static Parser.ParserRule readRule(String str) {
        return CoraParser.readRule(str, true, null);
    }

    public static Parser.ParserDeclaration readDeclaration(String str, boolean constrained, ErrorCollector collector) {
        ParsingStatus status = CoraParser.makeStatus(str, constrained, collector);
        CoraParser parser = new CoraParser(status);
        Parser.ParserDeclaration decl = parser.tryReadDeclaration();
        status.expect(Token.EOF, "end of input");
        return decl;
    }

    public static Parser.ParserProgram readProgramFromString(String str, boolean constrained, ErrorCollector collector) {
        ParsingStatus status = CoraParser.makeStatus(str, constrained, collector);
        CoraParser parser = new CoraParser(status);
        Parser.ParserProgram program = parser.readTRS();
        CoraParser.finish(status, collector == null || program == null);
        return program;
    }

    public static Parser.ParserProgram readProgramFromString(String str) {
        return CoraParser.readProgramFromString(str, true, null);
    }

    public static Parser.ParserProgram readProgramFromFile(String filename, boolean constrained, ErrorCollector collector) throws IOException {
        TokenQueue queue = constrained ? CoraTokenData.getConstrainedFileLexer(filename) : CoraTokenData.getUnconstrainedFileLexer(filename);
        ParsingStatus status = new ParsingStatus(queue, collector == null ? new ErrorCollector() : collector);
        CoraParser parser = new CoraParser(status);
        Parser.ParserProgram program = parser.readTRS();
        CoraParser.finish(status, collector == null || program == null);
        return program;
    }
}

