/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.LexerFactory;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenEditLexer;
import charlie.parser.lib.TokenQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.function.Function;

public class CoraTokenData {
    public static final String IDENTIFIER = "IDENTIFIER";
    public static final String BRACKETOPEN = "BRACKETOPEN";
    public static final String BRACKETCLOSE = "BRACKETCLOSE";
    public static final String BRACEOPEN = "BRACEOPEN";
    public static final String BRACECLOSE = "BRACECLOSE";
    public static final String METAOPEN = "METAOPEN";
    public static final String METACLOSE = "METACLOSE";
    public static final String TUPLEOPEN = "TUPLEOPEN";
    public static final String TUPLECLOSE = "TUPLECLOSE";
    public static final String COMMA = "COMMA";
    public static final String DECLARE = "DECLARE";
    public static final String LAMBDA = "LAMBDA";
    public static final String DOT = "DOT";
    public static final String ARROW = "ARROW";
    public static final String PUBLIC = "PUBLIC";
    public static final String PRIVATE = "PRIVATE";
    public static final String INTEGER = "INTEGER";
    public static final String TRUE = "TRUE";
    public static final String FALSE = "FALSE";
    public static final String STRING = "STRING";
    public static final String PLUS = "PLUS";
    public static final String MINUS = "MINUS";
    public static final String TIMES = "TIMES";
    public static final String MID = "MID";
    public static final String DIV = "DIV";
    public static final String MOD = "MOD";
    public static final String GEQ = "GEQ";
    public static final String GREATER = "GREATER";
    public static final String LEQ = "LEQ";
    public static final String SMALLER = "SMALLER";
    public static final String EQUAL = "EQUAL";
    public static final String EQUALINT = "EQUALINT";
    public static final String EQUALSTRING = "EQUALSTRING";
    public static final String EQUALBOOL = "EQUALBOOL";
    public static final String UNEQUAL = "UNEQUAL";
    public static final String UNEQUALINT = "UNEQUALINT";
    public static final String UNEQUALSTRING = "UNEQUALSTRING";
    public static final String UNEQUALBOOL = "UNEQUALBOOL";
    public static final String AND = "AND";
    public static final String OR = "OR";
    public static final String NOT = "NOT";
    public static final String INTTYPE = "INTTYPE";
    public static final String BOOLTYPE = "BOOLTYPE";
    public static final String STRINGTYPE = "STRINGTYPE";
    public static final String COLON = "COLON";
    private static String[] utokens = new String[]{"([^\\s()\\[\\]\u27e8\u27e9\\{\\}\u2987\u2988\"',:\u03bb\u00d7\\.\\*\\\\\\.\u2192/-]|(:(?!:))|(-(?!>))|(/(?!\\*))|(\\*(?!/)))+", "IDENTIFIER", "\"([^\"\\\\]|(\\\\.))*\"", "ILLEGALSTRING"};
    private static String[] ctokens = new String[]{"0|([1-9][0-9]*)", "INTEGER", "0[0-9]+", "BADINT", "true", "TRUE", "false", "FALSE", "\"([^\"\\\\]|(\\\\.))*\"", "STRING", "\\+", "PLUS", "-", "MINUS", "\\*", "TIMES", "\\|", "MID", ":", "COLON", "/", "DIV", "%", "MOD", ">", "GREATER", "<", "SMALLER", "\u2265|(>=)", "GEQ", "\u2264|(<=)", "LEQ", "=", "EQUAL", "=_Int", "EQUALINT", "=_String", "EQUALSTRING", "=_Bool", "EQUALBOOL", "=_Bool", "EQUALBOOL", "\u21d4|<=>", "EQUALBOOL", "\u2260", "UNEQUAL", "\u2260_Int", "UNEQUALINT", "\u2260_String", "UNEQUALSTRING", "!=", "UNEQUAL", "!=_Int", "UNEQUALINT", "!=_String", "UNEQUALSTRING", "!=_Bool", "UNEQUALBOOL", "\u22bb", "UNEQUALBOOL", "\u2227|(/\\\\)", "AND", "\u2228|(\\\\/)", "OR", "(not)|\u00ac", "NOT", "Int", "INTTYPE", "Bool", "BOOLTYPE", "String", "STRINGTYPE", "([^\\s()\\[\\]\u27e8\u27e9\\{\\}\u2987\u2988\"',:\u03bb%\\.\\|\\*\\+\\\\\\.><=!\u2260\u2265\u2264\u2192\u2227\u2228\u00ac\u21d4\u22bb/-]|)+", "IDENTIFIER"};
    private static String[] shared = new String[]{"\"([^\"\\\\]|(\\\\.))*$", "PARTIALSTRING", "\"([^\"\\\\]|(\\\\.))*\\\\$", "PARTIALSTRING", "\\(", "BRACKETOPEN", "\\)", "BRACKETCLOSE", "\u2987", "TUPLEOPEN", "\u2988", "TUPLECLOSE", "\\(\\|", "TUPLEOPEN", "\\|\\)", "TUPLECLOSE", "\\{", "BRACEOPEN", "\\}", "BRACECLOSE", "\u27e8", "METAOPEN", "\u27e9", "METACLOSE", "\\[", "METAOPEN", "\\]", "METACLOSE", ",", "COMMA", "::", "DECLARE", "\u03bb", "LAMBDA", "\\\\", "LAMBDA", "\\.", "DOT", "->", "ARROW", "\u2192", "ARROW", "private", "PRIVATE", "public", "PUBLIC", "/\\*", "COMMENTOPEN", "\\*/", "COMMENTCLOSE", "\\s", Token.SKIP};
    private static String[] unconstrainedTokens = null;
    private static String[] constrainedTokens = null;

    private static String[] getUnconstrainedTokens() {
        if (unconstrainedTokens == null) {
            ArrayList tmp = new ArrayList();
            Collections.addAll(tmp, shared);
            Collections.addAll(tmp, utokens);
            unconstrainedTokens = tmp.toArray(new String[tmp.size()]);
        }
        return unconstrainedTokens;
    }

    private static String[] getConstrainedTokens() {
        if (constrainedTokens == null) {
            ArrayList tmp = new ArrayList();
            Collections.addAll(tmp, shared);
            Collections.addAll(tmp, ctokens);
            constrainedTokens = tmp.toArray(new String[tmp.size()]);
        }
        return constrainedTokens;
    }

    private static TokenQueue setupLexer(Lexer base, boolean constrained) {
        Lexer lexer = base;
        lexer = LexerFactory.createNestedCommentRemoverLexer(lexer, "COMMENTOPEN", "COMMENTCLOSE");
        lexer = constrained ? new BadIntWarner(lexer) : new IllegalStringWarner(lexer);
        lexer = new PartialStringWarner(lexer);
        return LexerFactory.createPushbackLexer(lexer);
    }

    public static TokenQueue getUnconstrainedFileLexer(String filename) throws IOException {
        return CoraTokenData.setupLexer(LexerFactory.createFileLexer(CoraTokenData.getUnconstrainedTokens(), filename), false);
    }

    public static TokenQueue getConstrainedFileLexer(String filename) throws IOException {
        return CoraTokenData.setupLexer(LexerFactory.createFileLexer(CoraTokenData.getConstrainedTokens(), filename), true);
    }

    public static TokenQueue getUnconstrainedStringLexer(String text) {
        return CoraTokenData.setupLexer(LexerFactory.createStringLexer(CoraTokenData.getUnconstrainedTokens(), text), false);
    }

    public static TokenQueue getConstrainedStringLexer(String text) {
        return CoraTokenData.setupLexer(LexerFactory.createStringLexer(CoraTokenData.getConstrainedTokens(), text), true);
    }

    public static TokenQueue getUpdatedConstrainedStringLexer(String text, Function<Lexer, Lexer> lexerChanger, String ... extraTokens) {
        ArrayList tmp = new ArrayList();
        Collections.addAll(tmp, extraTokens);
        Collections.addAll(tmp, shared);
        Collections.addAll(tmp, ctokens);
        String[] toks = tmp.toArray(new String[tmp.size()]);
        ChangeableLexer lexer = LexerFactory.createStringLexer(toks, text);
        return CoraTokenData.setupLexer(lexerChanger.apply(lexer), true);
    }

    private static class BadIntWarner
    extends TokenEditLexer {
        BadIntWarner(Lexer lexer) {
            super(lexer, "BADINT");
        }

        @Override
        protected void modifyToken(Token token) throws LexerException {
            int i;
            String txt = token.getText();
            for (i = 0; i < txt.length() && txt.charAt(i) == '0'; ++i) {
            }
            txt = i < txt.length() ? txt.substring(i) : "0";
            this.storeToken(token, 0, CoraTokenData.INTEGER, txt);
            throw new LexerException(token, "Illegal integer constant: " + token.getText() + ".");
        }
    }

    private static class IllegalStringWarner
    extends TokenEditLexer {
        IllegalStringWarner(Lexer lexer) {
            super(lexer, "ILLEGALSTRING");
        }

        @Override
        protected void modifyToken(Token token) throws LexerException {
            this.storeToken(token, 0, CoraTokenData.STRING, token.getText());
            throw new LexerException(token, "String constants are only allowed in constrained systems.");
        }
    }

    private static class PartialStringWarner
    extends TokenEditLexer {
        PartialStringWarner(Lexer lexer) {
            super(lexer, "PARTIALSTRING");
        }

        @Override
        protected void modifyToken(Token token) throws LexerException {
            this.storeToken(token, 0, CoraTokenData.STRING, token.getText() + "\"");
            throw new LexerException(token, "Incomplete string constant (ended by end of line).");
        }
    }
}

