/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.Parser;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.util.ArrayList;

abstract class FirstOrderParser
implements Parser {
    private String IDENTIFIER;
    private String BRACKETOPEN;
    private String BRACKETCLOSE;
    private String COMMA;
    private String ARROW;
    private String RULESDECSTART;
    private String VARSDECSTART;
    private String COMMENTSTART;
    protected final ParsingStatus _status;

    protected FirstOrderParser(ParsingStatus status, String ident, String bopen, String bclose, String comma, String arrow, String rulesstart, String varsstart, String comstart) {
        this._status = status;
        this.IDENTIFIER = ident;
        this.BRACKETOPEN = bopen;
        this.BRACKETCLOSE = bclose;
        this.COMMA = comma;
        this.ARROW = arrow;
        this.RULESDECSTART = rulesstart;
        this.VARSDECSTART = varsstart;
        this.COMMENTSTART = comstart;
    }

    protected abstract boolean isSectionStart(Token var1);

    protected abstract Parser.ParserTerm readTerm();

    protected Parser.ParserTerm readFirstOrderTerm() {
        Token start = this._status.expect(this.IDENTIFIER, "an identifier (variable or function name)");
        if (start == null) {
            return null;
        }
        Parser.Identifier head = new Parser.Identifier(start, start.getText());
        if (this._status.readNextIf(this.BRACKETOPEN) == null) {
            return head;
        }
        if (this._status.readNextIf(this.BRACKETCLOSE) != null) {
            return new Parser.Application(start, head, FixedList.of());
        }
        FixedList.Builder<Parser.ParserTerm> builder = new FixedList.Builder<Parser.ParserTerm>();
        ArrayList args = new ArrayList();
        boolean errored = false;
        while (true) {
            Parser.ParserTerm child;
            if ((child = this.readTerm()) == null) {
                errored = true;
            } else {
                builder.add(child);
            }
            if (this._status.readNextIf(this.BRACKETCLOSE) != null) break;
            if (this._status.expect(this.COMMA, "a comma or closing bracket") != null) continue;
            errored = true;
            if (!this._status.nextTokenIs(this.IDENTIFIER)) break;
        }
        Parser.Application ret = new Parser.Application(start, head, builder.build());
        if (errored) {
            return new Parser.PErr(ret);
        }
        return ret;
    }

    protected abstract Parser.ParserRule readRule(LookupMap<Parser.ParserDeclaration> var1);

    protected FixedList<Parser.ParserRule> readRules(LookupMap<Parser.ParserDeclaration> declaredVars) {
        FixedList.Builder<Parser.ParserRule> ret = new FixedList.Builder<Parser.ParserRule>();
        if (this._status.expect(this.RULESDECSTART, "rules declaration") == null) {
            return ret.build();
        }
        while (this._status.readNextIf(this.BRACKETCLOSE) == null) {
            Parser.ParserRule r = this.readRule(declaredVars);
            if (r == null) continue;
            ret.add(r);
        }
        return ret.build();
    }

    protected LookupMap<Parser.ParserDeclaration> readVarList() {
        Token start = this._status.readNextIf(this.VARSDECSTART);
        if (start == null) {
            return null;
        }
        LookupMap.Builder<Parser.ParserDeclaration> ret = new LookupMap.Builder<Parser.ParserDeclaration>();
        Token next;
        while (!(next = this._status.nextToken()).getName().equals(this.BRACKETCLOSE)) {
            if (next.getName().equals(this.IDENTIFIER)) {
                String name = next.getText();
                if (ret.containsKey(name)) {
                    this._status.storeError(next, "Double declaration of variable " + name);
                    continue;
                }
                ret.put(name, new Parser.ParserDeclaration(next, name, TypeFactory.defaultSort));
                continue;
            }
            if (next.isEof()) {
                this._status.storeError(start, "Encountered end of input while reading varlist; no closing bracket given.");
                return ret.build();
            }
            if (this.isSectionStart(next)) {
                this._status.storeError(next, "Unexpected " + next.getText() + " while reading varlist; did you forget a closing bracket?");
                this._status.pushBack(next);
                return ret.build();
            }
            this._status.abort(next, "Unexpected token: " + next.getText() + " (" + next.getName() + "); expected a variable name");
        }
        return ret.build();
    }

    protected boolean readComment() {
        Token start = this._status.readNextIf(this.COMMENTSTART);
        if (start == null) {
            return false;
        }
        Token token = this._status.nextToken();
        Token lastFollow = null;
        while (!token.isEof()) {
            if (token.getName().equals(this.BRACKETCLOSE) && (lastFollow = this._status.nextToken()).isEof()) {
                return true;
            }
            token = this._status.nextToken();
        }
        if (lastFollow == null) {
            this._status.storeError(start, "Unclosed comment.");
        } else {
            this._status.storeError(lastFollow, "Unexpected token: " + lastFollow.getText() + "; expected end of input following comment.");
        }
        return true;
    }
}

