/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.FirstOrderParser;
import charlie.parser.ITrsTokenData;
import charlie.parser.InfixManager;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.util.ArrayList;

public class ITrsParser
extends FirstOrderParser
implements Parser {
    public static String PLUS = "+";
    public static String MINUS = "-";
    public static String TIMES = "*";
    public static String DIV = "/";
    public static String MOD = "%";
    public static String GREATER = ">";
    public static String SMALLER = "<";
    public static String GEQ = "\u2265";
    public static String LEQ = "\u2264";
    public static String EQUALS = "=";
    public static String NEQ = "\u2260";
    public static String AND = "\u2227";
    public static String OR = "\u2228";
    public static String NOT = "not";
    private InfixManager _manager = new InfixManager();

    private ITrsParser(ParsingStatus status) {
        super(status, ITrsTokenData.IDENTIFIER, ITrsTokenData.BRACKETOPEN, ITrsTokenData.BRACKETCLOSE, ITrsTokenData.COMMA, ITrsTokenData.ARROW, ITrsTokenData.RULESDECSTART, ITrsTokenData.VARSDECSTART, ITrsTokenData.COMMENTSTART);
        this._manager.addGroup(1, 1, AND);
        this._manager.addGroup(1, 1, OR);
        this._manager.addGroup(3, 2, EQUALS, NEQ, GREATER, SMALLER, GEQ, LEQ);
        this._manager.addGroup(1, 3, PLUS, MINUS);
        this._manager.addGroup(1, 4, TIMES, DIV, MOD);
    }

    @Override
    protected boolean isSectionStart(Token token) {
        return token.getName().equals(ITrsTokenData.VARSDECSTART) || token.getName().equals(ITrsTokenData.RULESDECSTART) || token.getName().equals(ITrsTokenData.COMMENTSTART);
    }

    @Override
    protected Parser.ParserTerm readTerm() {
        Parser.ParserTerm ret = this.readMainTerm();
        if (ret == null) {
            return null;
        }
        InfixManager.OperatorData operator = this.tryReadOperator();
        if (operator == null) {
            return ret;
        }
        ArrayList<Parser.ParserTerm> parts = new ArrayList<Parser.ParserTerm>();
        ArrayList<InfixManager.OperatorData> ops = new ArrayList<InfixManager.OperatorData>();
        parts.add(ret);
        boolean errored = false;
        while (operator != null) {
            ops.add(operator);
            Parser.ParserTerm pt = this.readMainTerm();
            if (pt == null) {
                errored = true;
                ops.remove(ops.size() - 1);
                break;
            }
            parts.add(pt);
            operator = this.tryReadOperator();
        }
        ret = this._manager.convertChain(parts, ops, this._status);
        if (errored) {
            ret = new Parser.PErr(ret);
        }
        return ret;
    }

    private Parser.ParserTerm readMainTerm() {
        Parser.ParserTerm ret = this.tryReadValue();
        if (ret != null) {
            return ret;
        }
        ret = this.tryReadPrefix();
        if (ret != null) {
            return ret;
        }
        ret = this.tryReadBracketedTerm();
        if (ret != null) {
            return ret;
        }
        return this.readFirstOrderTerm();
    }

    private Parser.ParserTerm tryReadValue() {
        Token token = this._status.readNextIf(ITrsTokenData.TRUTH);
        if (token != null) {
            return new Parser.BoolVal(token, true);
        }
        token = this._status.readNextIf(ITrsTokenData.FALSEHOOD);
        if (token != null) {
            return new Parser.BoolVal(token, false);
        }
        token = this._status.readNextIf(ITrsTokenData.INTEGER);
        if (token == null) {
            return null;
        }
        int x = 0;
        try {
            x = Integer.parseInt(token.getText());
        }
        catch (NumberFormatException ex) {
            this._status.storeError(token, "Illegal integer: " + token.getText());
        }
        return new Parser.IntVal(token, x);
    }

    private Parser.ParserTerm tryReadPrefix() {
        Parser.CalcSymbol head = null;
        Token token = this._status.readNextIf(ITrsTokenData.MINUS);
        if (token != null) {
            head = new Parser.CalcSymbol(token, MINUS);
        } else {
            token = this._status.readNextIf(ITrsTokenData.NOT);
            if (token != null) {
                head = new Parser.CalcSymbol(token, NOT);
            }
        }
        if (head == null) {
            return null;
        }
        Parser.ParserTerm ret = this.readMainTerm();
        if (ret == null) {
            return null;
        }
        return new Parser.Application(token, head, FixedList.of(ret));
    }

    private Parser.ParserTerm tryReadBracketedTerm() {
        Token token = this._status.readNextIf(ITrsTokenData.BRACKETOPEN);
        if (token == null) {
            return null;
        }
        Parser.ParserTerm ret = this.readTerm();
        this._status.expect(ITrsTokenData.BRACKETCLOSE, "closing bracket ')'");
        return ret;
    }

    private InfixManager.OperatorData tryReadOperator() {
        Token token = this._status.readNextIf(ITrsTokenData.PLUS);
        if (token != null) {
            return new InfixManager.OperatorData(token, PLUS);
        }
        token = this._status.readNextIf(ITrsTokenData.MINUS);
        if (token != null) {
            return new InfixManager.OperatorData(token, MINUS);
        }
        token = this._status.readNextIf(ITrsTokenData.TIMES);
        if (token != null) {
            return new InfixManager.OperatorData(token, TIMES);
        }
        token = this._status.readNextIf(ITrsTokenData.DIV);
        if (token != null) {
            return new InfixManager.OperatorData(token, DIV);
        }
        token = this._status.readNextIf(ITrsTokenData.MOD);
        if (token != null) {
            return new InfixManager.OperatorData(token, MOD);
        }
        token = this._status.readNextIf(ITrsTokenData.EQUAL);
        if (token != null) {
            return new InfixManager.OperatorData(token, EQUALS);
        }
        token = this._status.readNextIf(ITrsTokenData.UNEQUAL);
        if (token != null) {
            return new InfixManager.OperatorData(token, NEQ);
        }
        token = this._status.readNextIf(ITrsTokenData.GREATER);
        if (token != null) {
            return new InfixManager.OperatorData(token, GREATER);
        }
        token = this._status.readNextIf(ITrsTokenData.SMALLER);
        if (token != null) {
            return new InfixManager.OperatorData(token, SMALLER);
        }
        token = this._status.readNextIf(ITrsTokenData.GEQ);
        if (token != null) {
            return new InfixManager.OperatorData(token, GEQ);
        }
        token = this._status.readNextIf(ITrsTokenData.LEQ);
        if (token != null) {
            return new InfixManager.OperatorData(token, LEQ);
        }
        token = this._status.readNextIf(ITrsTokenData.AND);
        if (token != null) {
            return new InfixManager.OperatorData(token, AND);
        }
        token = this._status.readNextIf(ITrsTokenData.OR);
        if (token != null) {
            return new InfixManager.OperatorData(token, OR);
        }
        return null;
    }

    @Override
    protected Parser.ParserRule readRule(LookupMap<Parser.ParserDeclaration> vars) {
        Parser.ParserTerm left = this.readTerm();
        Token tok = this._status.peekNext();
        if (this._status.expect(ITrsTokenData.ARROW, "ARROW (->)") == null) {
            this._status.throwCollectedErrors();
        }
        Parser.ParserTerm right = this.readTerm();
        Parser.ParserTerm constraint = null;
        if (this._status.readNextIf(ITrsTokenData.MID) != null) {
            constraint = this.readTerm();
        }
        if (left == null || right == null) {
            return null;
        }
        return new Parser.ParserRule(tok, vars, left, right, constraint);
    }

    private Parser.ParserProgram readTRS() {
        LookupMap<Parser.ParserDeclaration> vars = this.readVarList();
        if (vars == null) {
            vars = LookupMap.empty();
        }
        FixedList<Parser.ParserRule> rules = this.readRules(vars);
        if (!this.readComment()) {
            this._status.expect(Token.EOF, "end of input");
        }
        return new Parser.ParserProgram(LookupMap.empty(), rules);
    }

    private static ParsingStatus makeStatus(String str, ErrorCollector collector) {
        if (collector == null) {
            collector = new ErrorCollector();
        }
        return new ParsingStatus(ITrsTokenData.getStringLexer(str), collector);
    }

    private static void completeParsing(ParsingStatus status, boolean throwErrors) {
        status.expect(Token.EOF, "end of input");
        if (throwErrors) {
            status.throwCollectedErrors();
        }
    }

    public static Parser.ParserTerm readTerm(String str, ErrorCollector collector) {
        ParsingStatus status = ITrsParser.makeStatus(str, collector);
        ITrsParser parser = new ITrsParser(status);
        Parser.ParserTerm ret = parser.readTerm();
        ITrsParser.completeParsing(status, collector == null || ret == null);
        return ret;
    }

    public static Parser.ParserTerm readTerm(String str) {
        return ITrsParser.readTerm(str, null);
    }

    public static Parser.ParserRule readRule(String str, ErrorCollector collector) {
        ParsingStatus status = ITrsParser.makeStatus(str, collector);
        ITrsParser parser = new ITrsParser(status);
        Parser.ParserRule rule = parser.readRule(LookupMap.empty());
        ITrsParser.completeParsing(status, collector == null || rule == null);
        return rule;
    }

    public static Parser.ParserRule readRule(String str) {
        return ITrsParser.readRule(str, null);
    }

    public static LookupMap<Parser.ParserDeclaration> readDeclarations(String str, ErrorCollector collect) {
        ParsingStatus status = ITrsParser.makeStatus(str, collect);
        ITrsParser parser = new ITrsParser(status);
        LookupMap<Parser.ParserDeclaration> decl = parser.readVarList();
        ITrsParser.completeParsing(status, collect == null || decl == null);
        return decl;
    }

    public static LookupMap<Parser.ParserDeclaration> readDeclarations(String str) {
        return ITrsParser.readDeclarations(str, null);
    }

    public static Parser.ParserProgram readProgramFromString(String str, ErrorCollector collector) {
        ParsingStatus status = ITrsParser.makeStatus(str, collector);
        ITrsParser parser = new ITrsParser(status);
        Parser.ParserProgram program = parser.readTRS();
        if (collector == null || program == null) {
            status.throwCollectedErrors();
        }
        return program;
    }

    public static Parser.ParserProgram readProgramFromString(String str) {
        return ITrsParser.readProgramFromString(str, null);
    }

    public static Parser.ParserProgram readProgramFromFile(String filename, ErrorCollector collector) throws IOException {
        boolean dothrow;
        boolean bl = dothrow = collector == null;
        if (collector == null) {
            collector = new ErrorCollector();
        }
        ParsingStatus status = new ParsingStatus(ITrsTokenData.getFileLexer(filename), collector);
        ITrsParser parser = new ITrsParser(status);
        Parser.ParserProgram program = parser.readTRS();
        if (dothrow || program == null) {
            status.throwCollectedErrors();
        }
        return program;
    }

    public static Parser.ParserProgram readProgramFromFile(String filename) throws IOException {
        return ITrsParser.readProgramFromFile(filename, null);
    }
}

