/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerFactory;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenQueue;
import java.io.IOException;

class ITrsTokenData {
    public static String IDENTIFIER = "IDENTIFIER";
    public static String BRACKETOPEN = "BRACKETOPEN";
    public static String BRACKETCLOSE = "BRACKETCLOSE";
    public static String ARROW = "ARROW";
    public static String COMMA = "COMMA";
    public static String MID = "MID";
    public static String VARSDECSTART = "VARSDECSTART";
    public static String RULESDECSTART = "RULESDECSTART";
    public static String COMMENTSTART = "COMMENTSTART";
    public static String INTEGER = "INTEGER";
    public static String TRUTH = "TRUTH";
    public static String FALSEHOOD = "FALSEHOOD";
    public static String PLUS = "PLUS";
    public static String MINUS = "MINUS";
    public static String TIMES = "TIMES";
    public static String DIV = "DIV";
    public static String MOD = "MOD";
    public static String EQUAL = "EQUAL";
    public static String GREATER = "GREATER";
    public static String SMALLER = "SMALLER";
    public static String GEQ = "GEQ";
    public static String LEQ = "LEQ";
    public static String UNEQUAL = "UNEQUAL";
    public static String NOT = "NOT";
    public static String AND = "AND";
    public static String OR = "OR";
    public static String[] tokens = new String[]{"TRUE", TRUTH, "FALSE", FALSEHOOD, "[0-9]+", INTEGER, "@z", Token.SKIP, "[^\\s()\",|\\-\\+\\*/%><=!&#:\\\\]+", IDENTIFIER, "\\+", PLUS, "-", MINUS, "\\*", TIMES, ":\\|:", MID, "/", DIV, "%", MOD, "=", EQUAL, ">", GREATER, "<", SMALLER, "!", NOT, ">=", GEQ, "<=", LEQ, "!=", UNEQUAL, "&&", AND, "\\|\\|", OR, "\\(", BRACKETOPEN, "\\)", BRACKETCLOSE, "->", ARROW, ",", COMMA, "&", "ILLEGAL", "\\|", "ILLEGAL", ":", "ILLEGAL", "\\(VAR", VARSDECSTART, "\\(RULES", RULESDECSTART, "\\(COMMENT", COMMENTSTART, "\\s", Token.SKIP, "#.*$", Token.SKIP};

    ITrsTokenData() {
    }

    public static TokenQueue getFileLexer(String filename) throws IOException {
        Lexer lexer = LexerFactory.createFileLexer(tokens, filename);
        lexer = LexerFactory.createErrorLexer(lexer, "ILLEGAL", "Illegal token: @TEXT@.");
        return LexerFactory.createPushbackLexer(lexer);
    }

    public static TokenQueue getStringLexer(String text) {
        Lexer lexer = LexerFactory.createStringLexer(tokens, text);
        lexer = LexerFactory.createErrorLexer(lexer, "ILLEGAL", "Illegal token: @TEXT@.");
        return LexerFactory.createPushbackLexer(lexer);
    }
}

