/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.Parser;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.util.FixedList;
import java.util.ArrayList;
import java.util.Stack;
import java.util.TreeMap;

class InfixManager {
    private ArrayList<GroupInfo> _groups = new ArrayList();
    private TreeMap<String, Integer> _symbols = new TreeMap();
    static final int ASSOC_LEFT = 1;
    static final int ASSOC_RIGHT = 2;
    static final int ASSOC_NONE = 3;

    InfixManager() {
    }

    void addGroup(int associativity, int priority, String ... operators) {
        int index = this._groups.size();
        this._groups.add(new GroupInfo(associativity, priority));
        for (String o : operators) {
            this._symbols.put(o, index);
        }
    }

    Parser.ParserTerm convertChain(ArrayList<Parser.ParserTerm> terms, ArrayList<OperatorData> operators, ParsingStatus status) {
        if (terms.size() != operators.size() + 1) {
            throw new IllegalArgumentException("InfixManager: list of terms in convertChain has length " + terms.size() + " while list of operators has size " + operators.size());
        }
        for (int i = 0; i < operators.size(); ++i) {
            if (this._symbols.containsKey(operators.get((int)i).name)) continue;
            throw new IllegalArgumentException("InfixManager: unexpected operator in convertChain: " + operators.get((int)i).token.getText());
        }
        Stack<Parser.ParserTerm> tstack = new Stack<Parser.ParserTerm>();
        Stack<OperatorData> ostack = new Stack<OperatorData>();
        tstack.add(terms.get(0));
        for (int i = 0; i < operators.size(); ++i) {
            OperatorData oi = operators.get(i);
            while (ostack.size() > 0) {
                OperatorData last = ostack.peek();
                int mygroup = this._symbols.get(oi.name());
                int lastgroup = this._symbols.get(last.name());
                boolean err = false;
                if (this._groups.get(mygroup).priority() > this._groups.get((int)lastgroup).priority) break;
                if (this._groups.get(mygroup).priority() == this._groups.get((int)lastgroup).priority) {
                    if (mygroup == lastgroup) {
                        if (this._groups.get(mygroup).associativity() == 2) break;
                        if (this._groups.get(mygroup).associativity() == 3) {
                            err = true;
                            status.storeError(oi.token(), "Illegal infix sequence: operator " + oi.token.getText() + " is not associative, so cannot be used after " + last.token.getText() + " (at position " + last.token.getPosition() + ").");
                        }
                    } else {
                        err = true;
                        status.storeError(oi.token(), "Ambiguous infix sequence: operators " + last.token.getText() + " (at position " + last.token.getPosition() + ") and " + oi.token.getText() + " have the same precedence, but are not in the same group.  Please use brackets to disambiguate.");
                    }
                }
                this.applyTop(tstack, ostack);
                if (!err) continue;
                tstack.push(new Parser.PErr(tstack.pop()));
            }
            tstack.push(terms.get(i + 1));
            ostack.push(oi);
        }
        while (!ostack.isEmpty()) {
            this.applyTop(tstack, ostack);
        }
        return (Parser.ParserTerm)tstack.pop();
    }

    private void applyTop(Stack<Parser.ParserTerm> tstack, Stack<OperatorData> ostack) {
        OperatorData o = ostack.pop();
        Parser.ParserTerm b = tstack.pop();
        Parser.ParserTerm a = tstack.pop();
        Parser.CalcSymbol head = new Parser.CalcSymbol(o.token(), o.name());
        Parser.Application result = new Parser.Application(a.token(), head, FixedList.of(a, b));
        tstack.push(result);
    }

    record GroupInfo(int associativity, int priority) {
    }

    public record OperatorData(Token token, String name) {
    }
}

