/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.FirstOrderParser;
import charlie.parser.OCocoTokenData;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingStatus;
import charlie.parser.lib.Token;
import charlie.types.Base;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.util.ArrayList;

public class OCocoParser
extends FirstOrderParser
implements Parser {
    private OCocoParser(ParsingStatus status) {
        super(status, OCocoTokenData.IDENTIFIER, OCocoTokenData.BRACKETOPEN, OCocoTokenData.BRACKETCLOSE, OCocoTokenData.COMMA, OCocoTokenData.ARROW, OCocoTokenData.RULESDECSTART, OCocoTokenData.VARSDECSTART, OCocoTokenData.COMMENTSTART);
    }

    @Override
    protected boolean isSectionStart(Token token) {
        return token.getName().equals(OCocoTokenData.VARSDECSTART) || token.getName().equals(OCocoTokenData.SIGSTART) || token.getName().equals(OCocoTokenData.RULESDECSTART) || token.getName().equals(OCocoTokenData.COMMENTSTART);
    }

    @Override
    protected Parser.ParserTerm readTerm() {
        return this.readFirstOrderTerm();
    }

    private Type readSortDeclaration() {
        Base output;
        Token next;
        ArrayList<Base> inputs = new ArrayList<Base>();
        while ((next = this._status.readNextIf(OCocoTokenData.IDENTIFIER)) != null) {
            inputs.add(TypeFactory.createSort(next.getText()));
        }
        this._status.expect(OCocoTokenData.ARROW, "IDENTIFIER (a sort) or the sort declaration arrow (->)");
        next = this._status.expect(OCocoTokenData.IDENTIFIER, "output sort");
        if (next != null) {
            output = TypeFactory.createSort(next.getText());
        } else if (inputs.isEmpty()) {
            output = TypeFactory.defaultSort;
        } else {
            output = inputs.get(inputs.size() - 1);
            inputs.remove(inputs.size() - 1);
        }
        return TypeFactory.createSortDeclaration(inputs, output);
    }

    private Type readIntAsType() {
        Token token = this._status.nextToken();
        String text = token.getText();
        try {
            int k = Integer.parseInt(text);
            if (k < 0) {
                this._status.storeError(token, "Cannot set arity below 0.");
                k = 0;
            }
            return TypeFactory.createDefaultArrow(k);
        }
        catch (NumberFormatException e) {
            this._status.storeError(token, "Unexpected identifier: " + text + ".  Expected an integer (for the extended TRS format) or a sort declaration (for the MSTRS format).  Did you forget ->?");
            return TypeFactory.createSort(text);
        }
    }

    private Parser.ParserDeclaration readFunctionDeclaration() {
        boolean endwithbracket = this._status.expect(OCocoTokenData.BRACKETOPEN, "an integer or sort declaration in brackets") != null;
        Token nametok = this._status.expect(OCocoTokenData.IDENTIFIER, "a function name");
        if (nametok == null) {
            this._status.throwCollectedErrors();
        }
        String name = nametok.getText();
        if (!this._status.nextTokenIs(OCocoTokenData.IDENTIFIER) && !this._status.nextTokenIs(OCocoTokenData.ARROW)) {
            this._status.abort(this._status.peekNext(), "Unexpected token: expected either an integer (for the extended TRS format), or a sort declaration (for the MSTRS format)");
        }
        Token next = this._status.peekNext();
        Type type = this._status.nextTokensAre(new String[]{OCocoTokenData.IDENTIFIER, OCocoTokenData.BRACKETCLOSE}) ? this.readIntAsType() : this.readSortDeclaration();
        if (endwithbracket) {
            this._status.expect(OCocoTokenData.BRACKETCLOSE, "closing bracket");
        }
        return new Parser.ParserDeclaration(nametok, name, type);
    }

    private LookupMap<Parser.ParserDeclaration> readSignature() {
        Token start = this._status.readNextIf(OCocoTokenData.SIGSTART);
        if (start == null) {
            return null;
        }
        LookupMap.Builder<Parser.ParserDeclaration> map = new LookupMap.Builder<Parser.ParserDeclaration>();
        while (this._status.readNextIf(OCocoTokenData.BRACKETCLOSE) == null) {
            if (this._status.peekNext().isEof()) {
                this._status.storeError(this._status.peekNext(), "Unexpected end of input while reading (SIG.");
                return map.build();
            }
            if (this.isSectionStart(this._status.peekNext())) {
                this._status.storeError(this._status.peekNext(), "Unexpected " + this._status.peekNext().getText() + "; did you forget ) to close (SIG?");
                return map.build();
            }
            Parser.ParserDeclaration decl = this.readFunctionDeclaration();
            if (map.containsKey(decl.name())) {
                this._status.storeError(decl.token(), "Redeclaration of function symbol " + decl.name() + ".");
                continue;
            }
            map.put(decl.name(), decl);
        }
        return map.build();
    }

    @Override
    protected Parser.ParserRule readRule(LookupMap<Parser.ParserDeclaration> vars) {
        Parser.ParserTerm left = this.readTerm();
        Token tok = this._status.peekNext();
        if (this._status.expect(OCocoTokenData.ARROW, "ARROW (->)") == null) {
            this._status.throwCollectedErrors();
        }
        Parser.ParserTerm right = this.readTerm();
        if (left == null || right == null) {
            return null;
        }
        return new Parser.ParserRule(tok, vars, left, right);
    }

    private Parser.ParserProgram readTRS() {
        LookupMap<Parser.ParserDeclaration> funs;
        LookupMap<Parser.ParserDeclaration> vars = this.readVarList();
        if (vars == null) {
            vars = LookupMap.empty();
        }
        if ((funs = this.readSignature()) == null) {
            funs = LookupMap.empty();
        }
        FixedList<Parser.ParserRule> rules = this.readRules(vars);
        if (!this.readComment()) {
            this._status.expect(Token.EOF, "end of input");
        }
        return new Parser.ParserProgram(funs, rules);
    }

    private static ParsingStatus makeStatus(String str, ErrorCollector collector) {
        if (collector == null) {
            collector = new ErrorCollector();
        }
        return new ParsingStatus(OCocoTokenData.getStringLexer(str), collector);
    }

    public static Parser.ParserTerm readTerm(String str, ErrorCollector collector) {
        ParsingStatus status = OCocoParser.makeStatus(str, collector);
        OCocoParser parser = new OCocoParser(status);
        Parser.ParserTerm ret = parser.readTerm();
        status.expect(Token.EOF, "end of input");
        if (collector == null || ret == null) {
            status.throwCollectedErrors();
        }
        return ret;
    }

    public static Parser.ParserTerm readTerm(String str) {
        return OCocoParser.readTerm(str, null);
    }

    public static Parser.ParserRule readRule(String str, ErrorCollector collector) {
        ParsingStatus status = OCocoParser.makeStatus(str, collector);
        OCocoParser parser = new OCocoParser(status);
        Parser.ParserRule rule = parser.readRule(LookupMap.empty());
        status.expect(Token.EOF, "end of input");
        if (collector == null || rule == null) {
            status.throwCollectedErrors();
        }
        return rule;
    }

    public static Parser.ParserRule readRule(String str) {
        return OCocoParser.readRule(str, null);
    }

    public static LookupMap<Parser.ParserDeclaration> readDeclarations(String str, ErrorCollector collect) {
        ParsingStatus status = OCocoParser.makeStatus(str, collect);
        OCocoParser parser = new OCocoParser(status);
        LookupMap<Parser.ParserDeclaration> decl = parser.readSignature();
        if (decl == null) {
            decl = parser.readVarList();
        }
        status.expect(Token.EOF, "end of input");
        if (collect == null || decl == null) {
            status.throwCollectedErrors();
        }
        return decl;
    }

    public static LookupMap<Parser.ParserDeclaration> readDeclarations(String str) {
        return OCocoParser.readDeclarations(str, null);
    }

    public static Parser.ParserProgram readProgramFromString(String str, ErrorCollector collector) {
        ParsingStatus status = OCocoParser.makeStatus(str, collector);
        OCocoParser parser = new OCocoParser(status);
        Parser.ParserProgram program = parser.readTRS();
        if (collector == null || program == null) {
            status.throwCollectedErrors();
        }
        return program;
    }

    public static Parser.ParserProgram readProgramFromString(String str) {
        return OCocoParser.readProgramFromString(str, null);
    }

    public static Parser.ParserProgram readProgramFromFile(String filename, ErrorCollector collector) throws IOException {
        boolean dothrow;
        boolean bl = dothrow = collector == null;
        if (collector == null) {
            collector = new ErrorCollector();
        }
        ParsingStatus status = new ParsingStatus(OCocoTokenData.getFileLexer(filename), collector);
        OCocoParser parser = new OCocoParser(status);
        Parser.ParserProgram program = parser.readTRS();
        if (dothrow || program == null) {
            status.throwCollectedErrors();
        }
        return program;
    }

    public static Parser.ParserProgram readProgramFromFile(String filename) throws IOException {
        return OCocoParser.readProgramFromFile(filename, null);
    }
}

