/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser;

import charlie.parser.lib.Token;
import charlie.types.Type;
import charlie.util.FixedList;
import charlie.util.LookupMap;

public interface Parser {

    public record ParserProgram(LookupMap<ParserDeclaration> fundecs, FixedList<ParserRule> rules) {
    }

    public record ParserRule(Token token, LookupMap<ParserDeclaration> vars, ParserTerm left, ParserTerm right, ParserTerm constraint) {
        public ParserRule(Token token, LookupMap<ParserDeclaration> vars, ParserTerm left, ParserTerm right) {
            this(token, vars, left, right, null);
        }

        public boolean hasErrors() {
            return this.left.hasErrors() || this.right.hasErrors() || this.constraint != null && this.constraint.hasErrors();
        }

        @Override
        public String toString() {
            return "{ " + this.vars.keySet().toString() + " } " + this.left.toString() + " -> " + this.right.toString() + (String)(this.constraint == null ? "" : " | " + this.constraint.toString());
        }
    }

    public record ParserDeclaration(Token token, String name, Type type, int extra) {
        public static final int EXTRA_PUBLIC = 0;
        public static final int EXTRA_PRIVATE = 1;

        public ParserDeclaration(Token token, String name, Type type) {
            this(token, name, type, 0);
        }
    }

    public record PErr(ParserTerm t) implements ParserTerm
    {
        @Override
        public String toString() {
            return "ERR(" + this.t.toString() + ")";
        }

        @Override
        public boolean hasErrors() {
            return true;
        }

        @Override
        public Token token() {
            return this.t.token();
        }
    }

    public record CalcSymbol(Token token, String name) implements ParserTerm
    {
        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean hasErrors() {
            return false;
        }
    }

    public record StringVal(Token token, String escapedvalue) implements ParserTerm
    {
        @Override
        public String toString() {
            return this.escapedvalue;
        }

        @Override
        public boolean hasErrors() {
            return false;
        }
    }

    public record IntVal(Token token, int value) implements ParserTerm
    {
        @Override
        public String toString() {
            return "" + this.value;
        }

        @Override
        public boolean hasErrors() {
            return false;
        }
    }

    public record BoolVal(Token token, boolean istrue) implements ParserTerm
    {
        @Override
        public String toString() {
            return this.istrue ? "TRUE" : "FALSE";
        }

        @Override
        public boolean hasErrors() {
            return false;
        }
    }

    public record Tup(Token token, FixedList<ParserTerm> args) implements ParserTerm
    {
        @Override
        public String toString() {
            return "(|" + this.args.toString() + "|)";
        }

        @Override
        public boolean hasErrors() {
            return this.args.stream().anyMatch(ParserTerm::hasErrors);
        }
    }

    public record Application(Token token, ParserTerm head, FixedList<ParserTerm> args) implements ParserTerm
    {
        @Override
        public String toString() {
            return "@(" + this.head.toString() + ", " + this.args.toString() + ")";
        }

        @Override
        public boolean hasErrors() {
            return this.head.hasErrors() || this.args.stream().anyMatch(ParserTerm::hasErrors);
        }
    }

    public record Meta(Token token, String name, FixedList<ParserTerm> args) implements ParserTerm
    {
        @Override
        public String toString() {
            return this.name.toString() + "[" + this.args.toString() + "]";
        }

        @Override
        public boolean hasErrors() {
            return this.args.stream().anyMatch(ParserTerm::hasErrors);
        }
    }

    public record Lambda(Token token, String vname, Type type, ParserTerm arg) implements ParserTerm
    {
        @Override
        public String toString() {
            return "LAMBDA " + this.vname + (String)(this.type == null ? "" : "::" + this.type.toString()) + "." + this.arg.toString();
        }

        @Override
        public boolean hasErrors() {
            return this.arg.hasErrors();
        }
    }

    public record Identifier(Token token, String name) implements ParserTerm
    {
        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public boolean hasErrors() {
            return false;
        }
    }

    public static sealed interface ParserTerm
    permits Identifier, Lambda, Meta, Application, Tup, BoolVal, IntVal, StringVal, CalcSymbol, PErr {
        public boolean hasErrors();

        public Token token();
    }
}

