/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.Token;

class CommentRemoverLexer
implements Lexer {
    private Lexer _mylexer;
    private String _commentOpenString;
    private String _commentCloseString;
    private boolean _allowNesting;

    CommentRemoverLexer(Lexer lexer, String commentOpen, String commentClose, boolean nested) {
        this._mylexer = lexer;
        this._commentOpenString = commentOpen;
        this._commentCloseString = commentClose;
        this._allowNesting = nested;
    }

    @Override
    public Token nextToken() throws LexerException {
        Token ret = this._mylexer.nextToken();
        while (!ret.isEof() && ret.getName().equals(this._commentOpenString)) {
            int opened = 1;
            while (opened > 0) {
                Token tok = this._mylexer.nextToken();
                if (tok.isEof()) {
                    throw new LexerException(ret, "end of input was reached before comment [" + ret.getText() + "] was closed");
                }
                if (tok.getName().equals(this._commentCloseString)) {
                    --opened;
                    continue;
                }
                if (!tok.getName().equals(this._commentOpenString) || !this._allowNesting) continue;
                ++opened;
            }
            ret = this._mylexer.nextToken();
        }
        if (ret.getName().equals(this._commentCloseString)) {
            throw new LexerException(ret, "unexpected comment-close token [" + ret.getText() + "] when no comment was open!");
        }
        return ret;
    }
}

