/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.ParsingException;
import java.util.ArrayList;

public class ErrorCollector {
    private ArrayList<ParsingErrorMessage> _messages = new ArrayList();
    private int _maxErrorCount;

    public ErrorCollector(int max) {
        if (max < 1) {
            max = 1;
        }
        this._maxErrorCount = max;
    }

    public ErrorCollector() {
        this._maxErrorCount = 10;
    }

    public void addError(ParsingErrorMessage message) {
        if (this._messages.size() < this._maxErrorCount) {
            this._messages.add(message);
        }
    }

    public void addErrorBefore(int pos, ParsingErrorMessage message) {
        if (this._messages.size() < this._maxErrorCount) {
            if (pos < 0) {
                pos = 0;
            }
            if (pos > this._messages.size()) {
                pos = this._messages.size();
            }
            this._messages.add(pos, message);
        }
    }

    public int queryErrorCount() {
        return this._messages.size();
    }

    public boolean queryFull() {
        return this._messages.size() >= this._maxErrorCount;
    }

    public ParsingException generateException() {
        return new ParsingException(this._messages);
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        for (int i = 0; i < this._messages.size(); ++i) {
            ret.append(this._messages.get(i).toString() + "\n");
        }
        return ret.toString();
    }
}

