/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.ParsePosition;
import charlie.parser.lib.StringLexer;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenFinder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

class FileLexer
implements ChangeableLexer {
    private TokenFinder _tokenfinder;
    private BufferedReader _reader;
    private StringLexer _currentLineLexer;
    private String _filename;
    private int _currentLine;

    FileLexer(TokenFinder finder, String filename) throws IOException {
        this._tokenfinder = finder;
        this._filename = filename;
        this._reader = new BufferedReader(new FileReader(filename));
        this._currentLine = 0;
        this.setupNextLexer();
    }

    private void setupNextLexer() throws IOException {
        ++this._currentLine;
        String line = this._reader.readLine();
        if (line == null) {
            this._currentLineLexer = null;
        } else {
            this._currentLineLexer = new StringLexer(this._tokenfinder, line + "\n");
            this._currentLineLexer.setFilename(this._filename);
            this._currentLineLexer.setLineNumber(this._currentLine);
        }
    }

    @Override
    public Token nextToken() throws LexerException {
        Token lastEof = null;
        while (this._currentLineLexer != null) {
            Token ret = this._currentLineLexer.nextToken();
            if (!ret.isEof()) {
                return ret;
            }
            lastEof = ret;
            try {
                this.setupNextLexer();
            }
            catch (IOException e) {
                this._currentLineLexer = null;
                throw new LexerException(lastEof, e.getMessage());
            }
        }
        if (lastEof == null) {
            lastEof = Token.eofToken(new ParsePosition(this._filename, this._currentLine + 1, 1));
        }
        return lastEof;
    }

    @Override
    public void changeTokenData(TokenFinder newfinder) {
        if (this._currentLineLexer != null) {
            this._currentLineLexer.changeTokenData(newfinder);
        }
        this._tokenfinder = newfinder;
    }

    @Override
    public TokenFinder getCurrentTokenData() {
        return this._tokenfinder;
    }
}

