/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.CommentRemoverLexer;
import charlie.parser.lib.ErrorLexer;
import charlie.parser.lib.FileLexer;
import charlie.parser.lib.Lexer;
import charlie.parser.lib.LongTokenLexer;
import charlie.parser.lib.MultilineStringLexer;
import charlie.parser.lib.PushbackLexer;
import charlie.parser.lib.StringEditLexer;
import charlie.parser.lib.TokenFinder;
import charlie.parser.lib.TokenQueue;
import java.io.IOException;

public class LexerFactory {
    public static ChangeableLexer createStringLexer(String[] tokens, String text) {
        return new MultilineStringLexer(new TokenFinder(tokens), text);
    }

    public static ChangeableLexer createFileLexer(String[] tokens, String filename) throws IOException {
        return new FileLexer(new TokenFinder(tokens), filename);
    }

    public static TokenFinder createTokenData(String[] tokens) {
        return new TokenFinder(tokens);
    }

    public static ChangeableLexer createLongTokenLexer(ChangeableLexer lexer, String tokenOpen, String middleExp, String closeExp, String resultName) {
        return new LongTokenLexer(lexer, tokenOpen, middleExp, closeExp, resultName);
    }

    public static Lexer createBasicCommentRemoverLexer(Lexer lexer, String copen, String cclose) {
        return new CommentRemoverLexer(lexer, copen, cclose, false);
    }

    public static Lexer createNestedCommentRemoverLexer(Lexer lexer, String copen, String cclose) {
        return new CommentRemoverLexer(lexer, copen, cclose, true);
    }

    public static Lexer createStringEditLexer(Lexer lexer, String stringTokenName, String[] replacements, char escapeChar) {
        return new StringEditLexer(lexer, stringTokenName, replacements, escapeChar);
    }

    public static Lexer createErrorLexer(Lexer lexer, String token, String message) {
        return new ErrorLexer(lexer, token, message);
    }

    public static TokenQueue createPushbackLexer(Lexer lexer) {
        return new PushbackLexer(lexer);
    }
}

