/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenFinder;

class LongTokenLexer
implements ChangeableLexer {
    private ChangeableLexer _mylexer;
    private String _openTokenName;
    private TokenFinder _myTokens;
    private String _resultName;

    LongTokenLexer(ChangeableLexer lexer, String tokenOpen, String middleExp, String closeExp, String myName) {
        this._mylexer = lexer;
        this._openTokenName = tokenOpen;
        this._myTokens = new TokenFinder(new String[]{closeExp, "LONGTOKENCLOSE", middleExp, "LONGTOKENMIDDLE"});
        this._resultName = myName;
    }

    @Override
    public Token nextToken() throws LexerException {
        StringBuilder txt;
        TokenFinder backup;
        Token ret;
        block6: {
            Token token;
            ret = this._mylexer.nextToken();
            if (ret.isEof()) {
                return ret;
            }
            if (!ret.getName().equals(this._openTokenName)) {
                return ret;
            }
            backup = this._mylexer.getCurrentTokenData();
            this._mylexer.changeTokenData(this._myTokens);
            txt = new StringBuilder(ret.getText());
            do {
                try {
                    token = this._mylexer.nextToken();
                }
                catch (LexerException e) {
                    this._mylexer.changeTokenData(backup);
                    throw new LexerException(e.queryToken(), e.queryMainMessage() + " (long token " + this._resultName + " started at " + ret.getPosition() + " not finished)");
                }
                txt.append(token.getText());
                if (token.getName().equals("LONGTOKENCLOSE")) break block6;
                if (!token.isEof()) continue;
                this._mylexer.changeTokenData(backup);
                throw new LexerException(token, "Unexpected end of input while reading long token started at " + ret.getPosition() + ".");
            } while (token.getName().equals("LONGTOKENMIDDLE"));
            this._mylexer.changeTokenData(backup);
            throw new LexerException(token, "Unexpected token: " + token.getText() + ".  Not allowed in long token " + this._resultName + " (started at " + ret.getPosition() + ").");
        }
        this._mylexer.changeTokenData(backup);
        if (this._resultName.equals(Token.SKIP)) {
            return this.nextToken();
        }
        return ret.samePositionToken(this._resultName, txt.toString());
    }

    @Override
    public void changeTokenData(TokenFinder finder) {
        this._mylexer.changeTokenData(finder);
    }

    @Override
    public TokenFinder getCurrentTokenData() {
        return this._mylexer.getCurrentTokenData();
    }
}

