/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.ParsePosition;
import charlie.parser.lib.StringLexer;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenFinder;

class MultilineStringLexer
implements ChangeableLexer {
    private TokenFinder _tokenfinder;
    private String[] _lines;
    private int _currentLine;
    private StringLexer _currentLineLexer;

    MultilineStringLexer(TokenFinder finder, String search) {
        this._tokenfinder = finder;
        this._lines = search.split("\\R");
        int i = 0;
        while (i < this._lines.length - 1) {
            int n = i++;
            this._lines[n] = this._lines[n] + "\n";
        }
        this._currentLine = 0;
        this.setupNextLexer();
    }

    private void setupNextLexer() {
        if (this._currentLine >= this._lines.length) {
            this._currentLineLexer = null;
        } else {
            this._currentLineLexer = new StringLexer(this._tokenfinder, this._lines[this._currentLine]);
            this._currentLineLexer.setLineNumber(this._currentLine + 1);
            ++this._currentLine;
        }
    }

    @Override
    public Token nextToken() {
        Token lastEof = null;
        while (this._currentLineLexer != null) {
            Token ret = this._currentLineLexer.nextToken();
            if (!ret.isEof()) {
                return ret;
            }
            lastEof = ret;
            this.setupNextLexer();
        }
        if (lastEof == null) {
            lastEof = Token.eofToken(new ParsePosition(this._currentLine + 1, 1));
        }
        return lastEof;
    }

    @Override
    public void changeTokenData(TokenFinder newfinder) {
        if (this._currentLineLexer != null) {
            this._currentLineLexer.changeTokenData(newfinder);
        }
        this._tokenfinder = newfinder;
    }

    @Override
    public TokenFinder getCurrentTokenData() {
        return this._tokenfinder;
    }
}

