/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

class ParsePosition {
    private String _file;
    private int _line;
    private int _pos;

    ParsePosition(String filename, int line, int pos) {
        this._file = filename;
        this._line = line;
        this._pos = pos;
    }

    ParsePosition(int line, int pos) {
        this._file = null;
        this._line = line;
        this._pos = pos;
    }

    ParsePosition(int pos) {
        this._file = null;
        this._line = 0;
        this._pos = pos;
    }

    String getFile() {
        return this._file;
    }

    int getLine() {
        return this._line;
    }

    int getPosition() {
        return this._pos;
    }

    public boolean before(ParsePosition other) {
        if (this._file == null && other._file != null) {
            return false;
        }
        if (this._file != null && other._file == null) {
            return false;
        }
        if (this._file != null && other._file != null && !this._file.equals(other._file)) {
            return false;
        }
        if (this._line == 0 && other._line != 0) {
            return false;
        }
        if (other._line < this._line) {
            return false;
        }
        if (this._line < other._line) {
            return true;
        }
        return this._pos < other._pos;
    }

    ParsePosition increasePosition(int offset) {
        return new ParsePosition(this._file, this._line, this._pos + offset);
    }

    public String toString() {
        Object p = "" + this._pos;
        if (this._pos <= 0) {
            p = "<unknown position>";
        }
        if (this._file == null && this._line == 0) {
            return (String)p;
        }
        if (this._file == null) {
            return this._line + ":" + (String)p;
        }
        return this._file + ":" + this._line + ":" + (String)p;
    }
}

