/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.Token;
import charlie.util.UserException;

public class ParsingErrorMessage {
    private Token _token;
    private Object[] _components;

    public ParsingErrorMessage(Token token, Object ... rest) {
        Object object;
        this._token = token;
        if (rest.length == 1 && (object = rest[0]) instanceof Object[]) {
            Object[] a = (Object[])object;
            this._components = a;
        } else {
            this._components = rest;
        }
    }

    public ParsingErrorMessage(Token token, UserException e) {
        this._token = token;
        this._components = e.makeArray();
    }

    public Token queryToken() {
        return this._token;
    }

    public int numComponents() {
        return this._components.length + (this._token == null ? 0 : 1);
    }

    public Object getComponent(int index) {
        if (this._token == null) {
            return this._components[index];
        }
        if (index == 0) {
            return this._token.getPosition() + ": ";
        }
        return this._components[index - 1];
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.numComponents(); ++i) {
            builder.append(this.getComponent(i));
        }
        return builder.toString();
    }
}

