/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenQueue;

public class ParsingStatus {
    private TokenQueue _tqueue;
    private ErrorCollector _errors;
    private Token _lastErrorToken;

    public ParsingStatus(TokenQueue queue, int maxErrors) {
        this._tqueue = queue;
        this._errors = new ErrorCollector(maxErrors);
        this._lastErrorToken = null;
    }

    public ParsingStatus(TokenQueue queue, ErrorCollector collector) {
        this._tqueue = queue;
        this._errors = collector;
        this._lastErrorToken = null;
    }

    public void throwCollectedErrors() {
        if (this._errors.queryErrorCount() > 0) {
            throw this._errors.generateException();
        }
    }

    private void checkTooManyErrors() {
        if (this._errors.queryFull()) {
            this.throwCollectedErrors();
        }
    }

    public void storeError(Token token, String message) {
        if (token != null && token == this._lastErrorToken) {
            return;
        }
        this._errors.addError(new ParsingErrorMessage(token, message));
        this._lastErrorToken = token;
        this.checkTooManyErrors();
    }

    public void storeError(ParsingErrorMessage message) {
        if (message.queryToken() != null && message.queryToken() == this._lastErrorToken) {
            return;
        }
        this._errors.addError(message);
        this._lastErrorToken = message.queryToken();
        this.checkTooManyErrors();
    }

    public void storeError(ParsingErrorMessage message, int pos) {
        this._errors.addErrorBefore(pos, message);
        this.checkTooManyErrors();
    }

    public int queryErrorPosition() {
        return this._errors.queryErrorCount();
    }

    public void abort(Token token, String message) {
        this._errors.addError(new ParsingErrorMessage(token, message));
        throw this._errors.generateException();
    }

    public Token nextToken() {
        while (true) {
            try {
                return this._tqueue.nextToken();
            }
            catch (LexerException e) {
                this._errors.addError(new ParsingErrorMessage(e.queryToken(), e.queryMainMessage()));
                this.checkTooManyErrors();
                continue;
            }
            break;
        }
    }

    public Token peekNext() {
        Token token = this.nextToken();
        this._tqueue.push(token);
        return token;
    }

    public boolean nextTokenIs(String kind) {
        return this.peekNext().getName().equals(kind);
    }

    public boolean nextTokensAre(String[] kinds) {
        int i;
        Token[] toks = new Token[kinds.length];
        boolean ok = true;
        for (i = 0; i < kinds.length && ok; ++i) {
            toks[i] = this.nextToken();
            if (toks[i].getName().equals(kinds[i])) continue;
            ok = false;
        }
        while (i > 0) {
            this._tqueue.push(toks[i - 1]);
            --i;
        }
        return ok;
    }

    public Token readNextIf(String kind) {
        Token token = this.nextToken();
        if (token.getName().equals(kind)) {
            return token;
        }
        this._tqueue.push(token);
        return null;
    }

    public Token expect(String kind, String description) {
        Token token = this.nextToken();
        if (token.getName().equals(kind)) {
            return token;
        }
        this._tqueue.push(token);
        if (description == null) {
            description = kind;
        }
        this.storeError(token, "Expected " + description + " but got " + (String)(token.isEof() ? "end of input" : token.getName() + " (" + token.getText() + ")") + ".");
        return null;
    }

    public void pushBack(Token token) {
        this._tqueue.push(token);
    }
}

