/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.Lexer;
import charlie.parser.lib.LexerException;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenEditLexer;

class StringEditLexer
extends TokenEditLexer
implements Lexer {
    private String[] _replacements;
    private char _escapeChar;

    StringEditLexer(Lexer lexer, String tokenname, String[] replacements, char escapeChar) {
        super(lexer, tokenname);
        this._replacements = replacements;
        this._escapeChar = escapeChar;
    }

    @Override
    protected void modifyToken(Token token) throws LexerException {
        String txt = token.getText();
        txt = txt.substring(1, txt.length() - 1);
        for (int i = 1; i < this._replacements.length; i += 2) {
            txt = txt.replace(this._replacements[i - 1], this._replacements[i]);
        }
        String error = null;
        if (this._escapeChar != '\u0000') {
            for (int i = 0; i < txt.length() - 1; ++i) {
                if (txt.charAt(i) != this._escapeChar) continue;
                if (txt.charAt(i + 1) == this._escapeChar) {
                    ++i;
                    continue;
                }
                error = "Unexpected escape sequence [" + txt.substring(i, i + 2) + "] at position " + (i + 1) + " of [" + txt + "].";
                break;
            }
            String escapeString = Character.toString(this._escapeChar);
            String doubleEscape = escapeString + escapeString;
            txt = txt.replace(doubleEscape, escapeString);
        }
        this.storeToken(token, 0, token.getName(), txt);
        if (error != null) {
            throw new LexerException(token, error);
        }
    }
}

