/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ChangeableLexer;
import charlie.parser.lib.ParsePosition;
import charlie.parser.lib.Token;
import charlie.parser.lib.TokenFinder;

class StringLexer
implements ChangeableLexer {
    private TokenFinder _tokenfinder;
    private String _mystring;
    private String _filename;
    private int _lineno;
    private int _linepos;
    private int _start;

    StringLexer(TokenFinder finder, String search) {
        this._tokenfinder = finder;
        this._mystring = search;
        this._filename = null;
        this._lineno = 0;
        this._linepos = 1;
        this._start = 0;
    }

    void setFilename(String filename) {
        this._filename = filename;
    }

    void setLineNumber(int number) {
        this._lineno = number;
    }

    void setPositionOffset(int offset) {
        this._linepos = offset;
    }

    @Override
    public Token nextToken() {
        Token ret;
        do {
            ParsePosition pos;
            if ((ret = this._tokenfinder.matchStart(this._mystring, this._start, pos = new ParsePosition(this._filename, this._lineno, this._linepos + this._start))) == null) {
                return Token.eofToken(pos);
            }
            this._start += ret.getText().length();
        } while (ret.getName().equals(Token.SKIP));
        return ret;
    }

    @Override
    public void changeTokenData(TokenFinder newfinder) {
        this._tokenfinder = newfinder;
    }

    @Override
    public TokenFinder getCurrentTokenData() {
        return this._tokenfinder;
    }
}

