/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ParsePosition;

public class Token {
    private ParsePosition _position;
    private String _name;
    private String _text;
    public static String EOF = "EOF";
    public static String CATCHALL = "CATCHALL";
    public static String SKIP = "SKIP";

    public static Token eofToken(ParsePosition pos) {
        return new Token(pos, null, null);
    }

    Token(ParsePosition pos, String name, String text) {
        this._position = pos;
        this._name = name;
        this._text = text;
        if (pos == null) {
            this._position = new ParsePosition(0);
        }
        if (name == null) {
            this._name = EOF;
        }
        if (text == null) {
            this._text = "";
        }
    }

    ParsePosition getRealPosition() {
        return this._position;
    }

    public String getPosition() {
        return this._position.toString();
    }

    public boolean before(Token other) {
        return this._position.before(other._position);
    }

    public String getName() {
        return this._name;
    }

    public String getText() {
        return this._text;
    }

    public String getFile() {
        return this._position.getFile();
    }

    public int getLine() {
        return this._position.getLine();
    }

    public int getColumn() {
        return this._position.getPosition();
    }

    public Token updateText(String newtext) {
        return new Token(this._position, this._name, newtext);
    }

    public Token samePositionToken(String newname, String newtext) {
        return new Token(this._position, newname, newtext);
    }

    public boolean isEof() {
        return this._name.equals(EOF);
    }

    public String toString() {
        return this._position.toString() + ": " + this._text + " (" + this._name + ")";
    }
}

