/*
 * Decompiled with CFR 0.152.
 */
package charlie.parser.lib;

import charlie.parser.lib.ParsePosition;
import charlie.parser.lib.Token;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TokenFinder {
    private PatternInfo[] _patterns;

    TokenFinder(String[] tokens) {
        this._patterns = new PatternInfo[tokens.length / 2 + 1];
        if (tokens.length % 2 == 1) {
            throw new IllegalArgumentException("TokenFinder: given a Token array wich an odd number of elements!");
        }
        for (int i = 0; i < tokens.length; i += 2) {
            String name = tokens[i + 1];
            if (name.equals(Token.EOF) || name.equals(Token.CATCHALL)) {
                throw new IllegalArgumentException("TokenFinder: Token array tries to define the " + name + " token (this name is reserved).");
            }
            for (int j = 0; j < name.length(); ++j) {
                char c = name.charAt(j);
                if (c == '_' || c >= 'A' && c <= 'Z') continue;
                throw new IllegalArgumentException("TokenFinder: Illegal token: " + name + "!  Token names should consist only of capital letters and underscores.");
            }
            this._patterns[i / 2] = new PatternInfo(this, tokens[i + 1], tokens[i]);
        }
        this._patterns[tokens.length / 2] = new PatternInfo(this, Token.CATCHALL, ".|\\R");
    }

    Token matchStart(String txt, int start, ParsePosition pos) {
        int bestsofar = 0;
        Token token = null;
        if (start < 0) {
            throw new Error("matchStart called with negative start");
        }
        if (start >= txt.length()) {
            return token;
        }
        if (pos == null) {
            pos = new ParsePosition(start + 1);
        }
        for (int i = 0; i < this._patterns.length; ++i) {
            int len;
            Matcher matcher = this._patterns[i]._pattern.matcher(txt);
            matcher.useAnchoringBounds(false);
            matcher.region(start, txt.length());
            if (!matcher.lookingAt() || (len = matcher.end()) <= bestsofar) continue;
            bestsofar = len;
            token = new Token(pos, this._patterns[i]._name, matcher.group());
            if (len != txt.length()) continue;
            return token;
        }
        if (token == null) {
            token = new Token(pos, Token.CATCHALL, txt.substring(0, 1));
        }
        return token;
    }

    private class PatternInfo {
        String _name;
        Pattern _pattern;

        PatternInfo(TokenFinder tokenFinder, String name, String regexp) {
            this._name = name;
            this._pattern = Pattern.compile(regexp);
        }
    }
}

