/*
 * Decompiled with CFR 0.152.
 */
package charlie.printer;

import charlie.printer.AsciiPrinter;
import charlie.terms.TermPrinter;
import charlie.terms.position.PositionPrinter;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.trs.Rule;
import charlie.types.Type;
import charlie.types.TypePrinter;
import java.util.Set;

public class ParseablePrinter
extends AsciiPrinter {
    public ParseablePrinter(TypePrinter ty, PositionPrinter po, TermPrinter te) {
        super(ty, po, te);
    }

    private void printDeclaration(Replaceable x, Renaming renaming) {
        this._builder.append(renaming.getName(x));
        this._builder.append(" :: ");
        Type type = x.queryType();
        if (x.queryReplaceableKind() == Replaceable.Kind.METAVAR) {
            this._builder.append("[");
            for (int i = 0; i < x.queryArity(); ++i) {
                if (i > 0) {
                    this._builder.append(", ");
                }
                this._typePrinter.print(type.subtype(1), this._builder);
                type = type.subtype(2);
            }
            this._builder.append("] -> ");
        }
        this._typePrinter.print(type, this._builder);
    }

    @Override
    protected void printRule(Rule rho, Renaming renaming) {
        Set<Replaceable> replaceables;
        if (renaming == null) {
            renaming = this._termPrinter.generateUniqueNaming(rho.queryLeftSide(), rho.queryRightSide(), rho.queryConstraint());
            replaceables = renaming.domain();
        } else {
            replaceables = rho.queryAllReplaceables();
        }
        this._builder.append("{ ");
        boolean first = true;
        for (Replaceable x : replaceables) {
            if (first) {
                first = false;
            } else {
                this._builder.append(", ");
            }
            this.printDeclaration(x, renaming);
        }
        if (!first) {
            this._builder.append(" ");
        }
        this._builder.append("} ");
        super.printRule(rho, renaming);
    }
}

