/*
 * Decompiled with CFR 0.152.
 */
package charlie.printer;

import charlie.printer.PlainTypePrinter;
import charlie.terms.CalculationSymbol;
import charlie.terms.TermPrinter;
import charlie.terms.Variable;
import charlie.types.Arrow;
import charlie.types.Type;
import charlie.types.TypePrinter;
import java.util.Set;

public class ParseableTermPrinter
extends TermPrinter {
    private TypePrinter _typePrinter;

    public ParseableTermPrinter(Set<String> avoid, TypePrinter typeprint) {
        super(avoid);
        this._typePrinter = typeprint;
    }

    public ParseableTermPrinter(Set<String> avoid) {
        super(avoid);
        this._typePrinter = new PlainTypePrinter();
    }

    @Override
    protected String queryTupleOpenBracket() {
        return "(|";
    }

    @Override
    protected String queryTupleCloseBracket() {
        return "|)";
    }

    @Override
    protected String queryLambda() {
        return "\\";
    }

    @Override
    protected String queryMetaOpenBracket() {
        return "[";
    }

    @Override
    protected String queryMetaCloseBracket() {
        return "]";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected String queryCalculationName(CalculationSymbol.Kind symbolkind, String defaultName, Type symboltype) {
        switch (symbolkind) {
            default: {
                throw new MatchException(null, null);
            }
            case IFF: {
                return "<=>";
            }
            case XOR: {
                return "xor";
            }
            case AND: {
                return "/\\";
            }
            case OR: {
                return "\\/";
            }
            case GREATER: {
                return ">";
            }
            case SMALLER: {
                return "<";
            }
            case GEQ: {
                return ">=";
            }
            case LEQ: {
                return "<=";
            }
            case EQUALS: {
                Type a;
                if (!(symboltype instanceof Arrow)) return "=";
                Arrow arrow = (Arrow)symboltype;
                try {
                    Type type;
                    a = type = arrow.left();
                    Type b = type = arrow.right();
                    if (!a.isBaseType()) return "=";
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Object object = "=_" + this._typePrinter.print(a);
                return object;
            }
            case NEQ: {
                Type a;
                if (!(symboltype instanceof Arrow)) return "!=";
                Arrow arrow = (Arrow)symboltype;
                {
                    Type type;
                    a = type = arrow.left();
                    Type b = type = arrow.right();
                    if (!a.isBaseType()) return "!=";
                }
                Object object = "!=_" + this._typePrinter.print(a);
                return object;
            }
            case NOT: {
                return "not ";
            }
            case PLUS: {
                return "+";
            }
            case TIMES: {
                return "*";
            }
            case DIV: {
                return "/";
            }
            case MOD: {
                return "%";
            }
            case MINUS: 
        }
        return "-";
    }

    @Override
    protected void printAbstractionBinder(Variable binder, String chosenName, StringBuilder builder) {
        builder.append(chosenName);
        builder.append(" :: ");
        this._typePrinter.print(binder.queryType(), builder);
    }
}

