/*
 * Decompiled with CFR 0.152.
 */
package charlie.printer;

import charlie.terms.CalculationSymbol;
import charlie.terms.TermPrinter;
import charlie.types.Type;
import java.util.Set;

public class PlainTermPrinter
extends TermPrinter {
    public PlainTermPrinter(Set<String> avoid) {
        super(avoid);
    }

    @Override
    protected String queryTupleOpenBracket() {
        return "(|";
    }

    @Override
    protected String queryTupleCloseBracket() {
        return "|)";
    }

    @Override
    protected String queryLambda() {
        return "\\";
    }

    @Override
    protected String queryMetaOpenBracket() {
        return "[";
    }

    @Override
    protected String queryMetaCloseBracket() {
        return "]";
    }

    @Override
    protected String queryCalculationName(CalculationSymbol.Kind symbolkind, String defaultName, Type symboltype) {
        return switch (symbolkind) {
            default -> throw new MatchException(null, null);
            case CalculationSymbol.Kind.IFF -> "<=>";
            case CalculationSymbol.Kind.XOR -> "xor";
            case CalculationSymbol.Kind.AND -> "/\\";
            case CalculationSymbol.Kind.OR -> "\\/";
            case CalculationSymbol.Kind.GREATER -> ">";
            case CalculationSymbol.Kind.SMALLER -> "<";
            case CalculationSymbol.Kind.GEQ -> ">=";
            case CalculationSymbol.Kind.LEQ -> "<=";
            case CalculationSymbol.Kind.EQUALS -> "=";
            case CalculationSymbol.Kind.NEQ -> "!=";
            case CalculationSymbol.Kind.NOT -> "not ";
            case CalculationSymbol.Kind.PLUS -> "+";
            case CalculationSymbol.Kind.TIMES -> "*";
            case CalculationSymbol.Kind.DIV -> "/";
            case CalculationSymbol.Kind.MOD -> "%";
            case CalculationSymbol.Kind.MINUS -> "-";
        };
    }
}

