/*
 * Decompiled with CFR 0.152.
 */
package charlie.printer;

import charlie.printer.PrintableObject;
import charlie.substitution.Substitution;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TermPrinter;
import charlie.terms.position.Position;
import charlie.terms.position.PositionPrinter;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.trs.Rule;
import charlie.types.Type;
import charlie.types.TypePrinter;
import charlie.util.Pair;
import charlie.util.UserException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public abstract class Printer {
    protected StringBuilder _builder;
    protected TypePrinter _typePrinter;
    protected TermPrinter _termPrinter;
    protected PositionPrinter _posPrinter;

    protected Printer(TypePrinter typr, TermPrinter tepr, PositionPrinter popr) {
        this._typePrinter = typr;
        this._termPrinter = tepr;
        this._posPrinter = popr;
        this._builder = new StringBuilder();
    }

    public final TypePrinter queryTypePrinter() {
        return this._typePrinter;
    }

    public final TermPrinter queryTermPrinter() {
        return this._termPrinter;
    }

    public final PositionPrinter queryPositionPrinter() {
        return this._posPrinter;
    }

    public final MutableRenaming generateUniqueNaming(Term ... terms) {
        return this._termPrinter.generateUniqueNaming(Arrays.asList(terms));
    }

    public final MutableRenaming generateNaming(List<Term> terms) {
        return this._termPrinter.generateUniqueNaming(terms);
    }

    public final boolean isEmpty() {
        return this._builder.length() == 0;
    }

    public final void clear() {
        this._builder.setLength(0);
    }

    public final String toString() {
        return this._builder.toString();
    }

    public abstract String symbRuleArrow();

    public abstract String symbTypeArrow();

    public abstract String symbMapsto();

    public abstract String symbThickArrow();

    public abstract String symbLongArrow();

    public abstract String symbDownArrow();

    public abstract String symbRevRuleArrow();

    public abstract String symbVdash();

    public abstract String symbVDash();

    public abstract String symbForall();

    public abstract String symbExists();

    public abstract String symbAnd();

    public abstract String symbOr();

    public abstract String symbNot();

    public abstract String symbImplies();

    public abstract String symbIff();

    public abstract String symbTop();

    public abstract String symbBottom();

    public abstract String symbEmptySet();

    public abstract String symbUnion();

    public abstract String symbSubterm();

    public abstract String symbSubtermeq();

    public abstract String symbSupterm();

    public abstract String symbSuptermeq();

    public abstract String symbSqSupset();

    public abstract String symbSqSupseteq();

    public abstract String symbSucc();

    public abstract String symbSucceq();

    public abstract String symbGreater();

    public abstract String symbSmaller();

    public abstract String symbGeq();

    public abstract String symbLeq();

    public abstract String symbLangle();

    public abstract String symbRangle();

    public abstract String symbDistinct();

    public abstract String symbApprox();

    public abstract String symbSharp();

    public abstract String symbBullet();

    public abstract String symbStar();

    public abstract String symbAlpha();

    public abstract String symbBeta();

    public abstract String symbGamma();

    public abstract String symbDelta();

    public abstract String symbEpsilon();

    public abstract String symbZeta();

    public abstract String symbEta();

    public abstract String symbTheta();

    public abstract String symbIota();

    public abstract String symbKappa();

    public abstract String symbLambda();

    public abstract String symbMu();

    public abstract String symbNu();

    public abstract String symbXi();

    public abstract String symbPi();

    public abstract String symbRho();

    public abstract String symbSigma();

    public abstract String symbTau();

    public abstract String symbPhi();

    public abstract String symbChi();

    public abstract String symbPsi();

    public abstract String symbOmega();

    public final void add(Object ... objects) {
        this.storeRenaming(objects);
        for (Object ob : objects) {
            this.printSingleObject(ob);
        }
    }

    private final void storeRenaming(Object[] objects) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof Term) {
                Term t = (Term)object;
                terms.add(t);
                continue;
            }
            object = objects[i];
            if (!(object instanceof Replaceable)) continue;
            Replaceable r = (Replaceable)object;
            terms.add(TermFactory.makeTerm(r));
        }
        MutableRenaming renaming = this._termPrinter.generateUniqueNaming(terms);
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof Term) {
                Term t = (Term)object;
                objects[i] = new Pair<Term, MutableRenaming>(t, renaming);
                continue;
            }
            object = objects[i];
            if (!(object instanceof Replaceable)) continue;
            Replaceable r = (Replaceable)object;
            objects[i] = new Pair<Replaceable, MutableRenaming>(r, renaming);
        }
    }

    protected final void printSingleObject(Object ob) {
        Object object = ob;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Object[].class, List.class, UserException.class, String.class, Integer.class, Type.class, Position.class, Rule.class, PrintableObject.class, Term.class}, (Object)object2, n)) {
            case 0: {
                Object[] o = (Object[])object2;
                this.add(o);
                break;
            }
            case 1: {
                List a = (List)object2;
                this.add(a.toArray());
                break;
            }
            case 2: {
                UserException e = (UserException)object2;
                this.add(e.makeArray());
                break;
            }
            case 3: {
                String s = (String)object2;
                this._builder.append(s);
                break;
            }
            case 4: {
                Integer i = (Integer)object2;
                this._builder.append(i.toString());
                break;
            }
            case 5: {
                Type y = (Type)object2;
                this._typePrinter.print(y, this._builder);
                break;
            }
            case 6: {
                Position p = (Position)object2;
                this._posPrinter.print(p, this._builder);
                break;
            }
            case 7: {
                Rule r = (Rule)object2;
                this.printRule(r, null);
                break;
            }
            case 8: {
                PrintableObject o = (PrintableObject)object2;
                o.print(this);
                break;
            }
            case 9: {
                Term t = (Term)object2;
                this._termPrinter.print(t, this._builder);
                break;
            }
            default: {
                Pair p;
                Object b;
                if (ob instanceof Pair && (b = (p = (Pair)ob).snd()) instanceof Renaming) {
                    Renaming renaming = (Renaming)b;
                    Object a = p.fst();
                    if (a instanceof Term) {
                        Term t = (Term)a;
                        this._termPrinter.print(t, renaming, this._builder);
                        break;
                    }
                    a = p.fst();
                    if (a instanceof Rule) {
                        Rule rule = (Rule)a;
                        this.printRule(rule, renaming);
                        break;
                    }
                    a = p.fst();
                    if (a instanceof Substitution) {
                        Substitution sub = (Substitution)a;
                        this.printSubstitution(sub, renaming, renaming);
                        break;
                    }
                    a = p.fst();
                    if (a instanceof Replaceable) {
                        Replaceable r = (Replaceable)a;
                        this._termPrinter.printReplaceable(r, renaming, this._builder);
                        break;
                    }
                    this.printSingleUnknownObject(ob);
                    break;
                }
                this.printSingleUnknownObject(ob);
            }
        }
    }

    protected void printRule(Rule rho, Renaming renaming) {
        if (renaming == null) {
            renaming = this._termPrinter.generateUniqueNaming(rho.queryLeftSide(), rho.queryRightSide(), rho.queryConstraint());
        }
        this._termPrinter.print(rho.queryLeftSide(), renaming, this._builder);
        this._builder.append(" " + this.symbRuleArrow() + " ");
        this._termPrinter.print(rho.queryRightSide(), renaming, this._builder);
        if (rho.isConstrained()) {
            this._builder.append(" | ");
            this._termPrinter.print(rho.queryConstraint(), renaming, this._builder);
        }
    }

    protected void printSubstitution(Substitution gamma, Renaming keyNaming, Renaming valueNaming) {
        ArrayList<Pair<Replaceable, String>> dom = new ArrayList<Pair<Replaceable, String>>();
        for (Replaceable x2 : gamma.domain()) {
            String xname = keyNaming.getName(x2);
            if (xname == null) {
                throw new IllegalArgumentException("KeyNaming given to printSubstitution does not have a mapping for " + x2.queryName() + "(" + x2.queryIndex() + ").");
            }
            dom.add(new Pair<Replaceable, String>(x2, xname));
        }
        Collections.sort(dom, (x, y) -> ((Replaceable)x.fst()).queryReplaceableKind() == ((Replaceable)y.fst()).queryReplaceableKind() ? ((String)x.snd()).compareTo((String)y.snd()) : ((Replaceable)x.fst()).queryReplaceableKind().compareTo(((Replaceable)y.fst()).queryReplaceableKind()));
        this._builder.append("[");
        for (int i = 0; i < dom.size(); ++i) {
            if (i > 0) {
                this._builder.append(", ");
            }
            this._builder.append((String)((Pair)dom.get(i)).snd());
            this._builder.append(" := ");
            this._termPrinter.print(gamma.get((Replaceable)((Pair)dom.get(i)).fst()), valueNaming, this._builder);
        }
        this._builder.append("]");
    }

    protected void printSingleUnknownObject(Object ob) {
        if (ob instanceof Pair) {
            Pair p = (Pair)ob;
            throw new PrintingUnknownObjectException(p.fst(), p.snd());
        }
        throw new PrintingUnknownObjectException(ob);
    }

    public static PrintableObject makePrintable(final Substitution subst, final Renaming keys, final Renaming values) {
        return new PrintableObject(){

            @Override
            public void print(Printer p) {
                p.printSubstitution(subst, keys, values);
            }
        };
    }

    public static PrintableObject makePrintable(final Rule rule, final Renaming renaming) {
        return new PrintableObject(){

            @Override
            public void print(Printer p) {
                p.printRule(rule, renaming);
            }
        };
    }

    public static PrintableObject makePrintable(final Term term, final Renaming renaming) {
        return new PrintableObject(){

            @Override
            public void print(Printer p) {
                p._termPrinter.print(term, renaming, p._builder);
            }

            public String toString() {
                return new TermPrinter(Set.of()).print(term, renaming);
            }
        };
    }

    public static PrintableObject makePrintable(final UserException e, final Renaming renaming) {
        return new PrintableObject(){

            @Override
            public void print(Printer p) {
                Object[] objects = e.makeArray();
                for (int i = 0; i < objects.length; ++i) {
                    Object object = objects[i];
                    if (object instanceof Term) {
                        Term t = (Term)object;
                        objects[i] = new Pair<Term, Renaming>(t, renaming);
                        continue;
                    }
                    object = objects[i];
                    if (!(object instanceof Replaceable)) continue;
                    Replaceable r = (Replaceable)object;
                    objects[i] = new Pair<Replaceable, Renaming>(r, renaming);
                }
                p.add(objects);
            }

            public String toString() {
                TermPrinter pr = new TermPrinter(Set.of());
                StringBuilder builder = new StringBuilder();
                Object[] objects = e.makeArray();
                for (int i = 0; i < objects.length; ++i) {
                    Object object = objects[i];
                    if (object instanceof Term) {
                        Term t = (Term)object;
                        pr.print(t, renaming, builder);
                        continue;
                    }
                    object = objects[i];
                    if (object instanceof Replaceable) {
                        Replaceable r = (Replaceable)object;
                        pr.printReplaceable(r, renaming, builder);
                        continue;
                    }
                    builder.append(objects[i].toString());
                }
                return builder.toString();
            }
        };
    }

    public class PrintingUnknownObjectException
    extends RuntimeException {
        private PrintingUnknownObjectException(Object ob) {
            super("Asked to print object of type " + ob.getClass().getName() + ", which is not supported by the default Printer.");
        }

        private PrintingUnknownObjectException(Object ob1, Object ob2) {
            super("Asked to print object of type Pair<" + ob1.getClass().getName() + "," + ob2.getClass().getName() + ">, which is not supported by the default Printer.");
        }
    }
}

