/*
 * Decompiled with CFR 0.152.
 */
package charlie.printer;

import charlie.printer.AsciiPrinter;
import charlie.printer.DebugTermPrinter;
import charlie.printer.ParseablePrinter;
import charlie.printer.ParseableTermPrinter;
import charlie.printer.PlainPositionPrinter;
import charlie.printer.PlainTermPrinter;
import charlie.printer.PlainTypePrinter;
import charlie.printer.Printer;
import charlie.printer.UnicodePrinter;
import charlie.terms.TermPrinter;
import charlie.terms.position.PositionPrinter;
import charlie.trs.TRS;
import charlie.types.TypePrinter;
import java.util.Set;

public class PrinterFactory {
    public static Printer createUnicodePrinter(TRS trs) {
        TypePrinter ty = new TypePrinter();
        PositionPrinter po = new PositionPrinter();
        TermPrinter te = new TermPrinter(trs.queryFunctionSymbolNames());
        return new UnicodePrinter(ty, po, te);
    }

    public static Printer createPlainPrinter(TRS trs) {
        PlainTypePrinter ty = new PlainTypePrinter();
        PlainPositionPrinter po = new PlainPositionPrinter();
        PlainTermPrinter te = new PlainTermPrinter(trs.queryFunctionSymbolNames());
        return new AsciiPrinter((TypePrinter)ty, po, te);
    }

    public static Printer createParseablePrinter(TRS trs) {
        PlainTypePrinter ty = new PlainTypePrinter();
        PlainPositionPrinter po = new PlainPositionPrinter();
        ParseableTermPrinter te = new ParseableTermPrinter(trs.queryFunctionSymbolNames());
        return new ParseablePrinter((TypePrinter)ty, po, te);
    }

    public static Printer createPrinterNotForUserOutput() {
        return new UnicodePrinter(new TypePrinter(), new PositionPrinter(), new TermPrinter(Set.of()));
    }

    public static Printer createDebugPrinter() {
        return new AsciiPrinter((TypePrinter)new PlainTypePrinter(), new PlainPositionPrinter(), new DebugTermPrinter());
    }
}

