/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.parser.AriParser;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.Token;
import charlie.reader.SymbolData;
import charlie.reader.TermTyper;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.types.Type;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;

public class AriInputReader
extends TermTyper {
    private AriInputReader(ErrorCollector collector) {
        super(new SymbolData(), collector);
    }

    private void registerVariableArity(Token token, String name, int numberArguments, TreeMap<String, Integer> arity, TreeSet<String> bound) {
        if (this._symbols.lookupFunctionSymbol(name) != null) {
            return;
        }
        if (bound.contains(name)) {
            return;
        }
        if (arity.containsKey(name) && arity.get(name) != 0) {
            this.storeError(token, "Inconsistent arity of variable " + name + ": occurs with no arguments here, while it previously occurred with " + String.valueOf(arity.get(name)) + ".");
            return;
        }
        arity.put(name, numberArguments);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void storeVariableArity(Parser.ParserTerm term, TreeMap<String, Integer> arity, TreeSet<String> bound, int numArgs) {
        Parser.ParserTerm parserTerm = term;
        Objects.requireNonNull(parserTerm);
        Parser.ParserTerm parserTerm2 = parserTerm;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.Identifier.class, Parser.Lambda.class, Parser.Application.class, Parser.PErr.class}, (Object)parserTerm2, n)) {
            case 0: {
                Parser.Identifier identifier = (Parser.Identifier)parserTerm2;
                try {
                    Object object = identifier.token();
                    Token token = object;
                    Object name = object = identifier.name();
                    this.registerVariableArity(token, (String)name, numArgs, arity, bound);
                    return;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Object arg;
                Object varname;
                Parser.Lambda lambda = (Parser.Lambda)parserTerm2;
                {
                    Object object = lambda.token();
                    Token token = object;
                    varname = object = lambda.vname();
                    Object type = object = lambda.type();
                    arg = object = lambda.arg();
                    if (bound.contains(varname)) {
                        this.storeVariableArity((Parser.ParserTerm)arg, arity, bound, 0);
                        return;
                    }
                    bound.add((String)varname);
                }
                this.storeVariableArity((Parser.ParserTerm)arg, arity, bound, 0);
                bound.remove(varname);
                return;
            }
            case 2: {
                Object object;
                Parser.Application application = (Parser.Application)parserTerm2;
                {
                    object = application.token();
                    Token token = object;
                    object = application.head();
                    FixedList<Parser.ParserTerm> head = object;
                    object = application.args();
                    FixedList<Parser.ParserTerm> args = object;
                    this.storeVariableArity((Parser.ParserTerm)((Object)head), arity, bound, args.size());
                    object = args.iterator();
                }
                while (object.hasNext()) {
                    Parser.ParserTerm t = (Parser.ParserTerm)object.next();
                    this.storeVariableArity(t, arity, bound, 0);
                }
                return;
            }
            case 3: {
                Parser.PErr e = (Parser.PErr)parserTerm2;
                return;
            }
        }
        this.storeError(term.token(), "Unexpected term shape in ARI unconstrained higher-order format.");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Parser.ParserTerm replaceMetaVariables(Parser.ParserTerm term, TreeMap<String, Integer> arity) {
        v0 = term;
        Objects.requireNonNull(v0);
        var3_3 = v0;
        var4_5 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.Identifier.class, Parser.Lambda.class, Parser.Application.class, Parser.PErr.class}, (Object)var3_3, var4_5)) {
            case 0: {
                v1 /* !! */  = id = (Parser.Identifier)var3_3;
                break;
            }
            case 1: {
                var6_7 = (Parser.Lambda)var3_3;
                var11_8 = var6_7.token();
                token = var11_8;
                varname = var11_8 = var6_7.vname();
                type = var11_8 = var6_7.type();
                arg = var11_8 = var6_7.arg();
                backup = arity.get(varname);
                if (backup == null) ** GOTO lbl25
                arity.remove(varname);
lbl25:
                // 2 sources

                ret = new Parser.Lambda(token, (String)varname, (Type)type, this.replaceMetaVariables((Parser.ParserTerm)arg, arity));
                if (backup != null) {
                    arity.put((String)varname, backup);
                }
                v1 /* !! */  = ret;
                break;
            }
            case 2: {
                var11_9 = (Parser.Application)var3_3;
                var15_16 = var11_9.token();
                token = var15_16;
                head = var15_16 = var11_9.head();
                args = var15_16 = var11_9.args();
                newargs = new FixedList.Builder<Parser.ParserTerm>();
                for (Parser.ParserTerm arg : args) {
                    newargs.add(this.replaceMetaVariables(arg, arity));
                }
                if (!(head instanceof Parser.Identifier)) ** GOTO lbl54
                var16_20 = (Parser.Identifier)head;
                var19_22 = var16_20.token();
                t = var19_22;
                name = var19_22 = var16_20.name();
                if (!arity.containsKey(name) || arity.get(name) <= 0) ** GOTO lbl54
                v1 /* !! */  = new Parser.Meta(token, (String)name, newargs.build());
                break;
lbl54:
                // 2 sources

                v1 /* !! */  = new Parser.Application(token, this.replaceMetaVariables((Parser.ParserTerm)head, arity), newargs.build());
                break;
            }
            case 3: {
                e = (Parser.PErr)var3_3;
                v1 /* !! */  = term;
                break;
            }
            default: {
                this.storeError(term.token(), new Object[]{"Unexpected term shape."});
                v1 /* !! */  = new Parser.PErr(term);
            }
        }
        return v1 /* !! */ ;
        catch (Throwable var3_4) {
            throw new MatchException(var3_4.toString(), var3_4);
        }
    }

    private Rule makeRule(Parser.ParserRule rule) {
        TreeMap<String, Integer> variableArity = new TreeMap<String, Integer>();
        TreeSet<String> bound = new TreeSet<String>();
        this.storeVariableArity(rule.left(), variableArity, bound, 0);
        Parser.ParserTerm left = this.replaceMetaVariables(rule.left(), variableArity);
        Parser.ParserTerm right = this.replaceMetaVariables(rule.right(), variableArity);
        this._symbols.clearEnvironment();
        Term l = null;
        Term r = null;
        int a = this._errors.queryErrorCount();
        if (!left.hasErrors()) {
            l = this.makeTerm(left, null, true);
        }
        if (!right.hasErrors()) {
            r = this.makeTerm(right, l == null ? null : l.queryType(), false);
        }
        int b = this._errors.queryErrorCount();
        if (l == null || r == null) {
            return null;
        }
        try {
            return TrsFactory.createRule(l, r, TrsFactory.AMS);
        }
        catch (IllegalRuleException e) {
            if (a == b) {
                this.storeError(rule.token(), e.getMessage());
            }
            return null;
        }
    }

    private void makeAlphabet(LookupMap<Parser.ParserDeclaration> fundecs) {
        for (Parser.ParserDeclaration decl : fundecs.values()) {
            String name = decl.name();
            Type type = decl.type();
            if (this._symbols.lookupFunctionSymbol(name) != null) {
                this.storeError(decl.token(), "Duplicate function symbol: " + name);
                continue;
            }
            this._symbols.addFunctionSymbol(TermFactory.createConstant(name, type));
        }
    }

    private TRS makeTRS(Parser.ParserProgram trs) {
        this.makeAlphabet(trs.fundecs());
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Parser.ParserRule rho : trs.rules()) {
            Rule r = this.makeRule(rho);
            if (r == null) continue;
            rules.add(r);
        }
        Alphabet alphabet = this._symbols.queryCurrentAlphabet();
        try {
            return TrsFactory.createTrs(alphabet, rules, TrsFactory.AMS);
        }
        catch (IllegalRuleException e) {
            this.storeError(null, e.getMessage());
            return null;
        }
    }

    private static void throwIfAnyErrors(ErrorCollector collector) {
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
    }

    private static TRS readParserProgram(Parser.ParserProgram trs, ErrorCollector collector) {
        AriInputReader.throwIfAnyErrors(collector);
        AriInputReader rd = new AriInputReader(collector);
        TRS ret = rd.makeTRS(trs);
        AriInputReader.throwIfAnyErrors(collector);
        return ret;
    }

    public static TRS readTrsFromString(String str) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = AriParser.readProgramFromString(str, collector);
        return AriInputReader.readParserProgram(trs, collector);
    }

    public static TRS readTrsFromFile(String filename) throws IOException {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = AriParser.readProgramFromFile(filename, collector);
        return AriInputReader.readParserProgram(trs, collector);
    }
}

