/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.parser.CoraParser;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.Token;
import charlie.reader.SymbolData;
import charlie.reader.TermTyper;
import charlie.terms.FunctionSymbol;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.terms.replaceable.MutableRenaming;
import charlie.terms.replaceable.Renaming;
import charlie.terms.replaceable.Replaceable;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.IllegalSymbolException;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.LookupMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class CoraInputReader
extends TermTyper {
    private CoraInputReader(SymbolData data, ErrorCollector collector) {
        super(data, collector);
    }

    private ArrayList<Parser.ParserDeclaration> sort(LookupMap<Parser.ParserDeclaration> decls) {
        ArrayList<Parser.ParserDeclaration> ret = new ArrayList<Parser.ParserDeclaration>(decls.values());
        Collections.sort(ret, new Comparator<Parser.ParserDeclaration>(this){

            @Override
            public int compare(Parser.ParserDeclaration t1, Parser.ParserDeclaration t2) {
                if (t1.token().before(t2.token())) {
                    return -1;
                }
                if (t1.token().getPosition().equals(t2.token().getPosition())) {
                    return 0;
                }
                return 1;
            }
        });
        return ret;
    }

    private void handleFunctionDeclaration(Parser.ParserDeclaration decl) {
        if (decl == null || decl.type() == null) {
            return;
        }
        String name = decl.name();
        if (this._symbols.lookupFunctionSymbol(name) != null) {
            this.storeError(decl.token(), "Redeclaration of previously declared function symbol " + name + ".");
        } else {
            FunctionSymbol symbol = TermFactory.createConstant(name, decl.type());
            this._symbols.addFunctionSymbol(symbol);
            if (decl.extra() == 1) {
                this._symbols.setPrivate(symbol);
            }
        }
    }

    private void readEnvironment(LookupMap<Parser.ParserDeclaration> vars) {
        for (Parser.ParserDeclaration decl : this.sort(vars)) {
            String name = decl.name();
            int arity = decl.extra();
            String kind = arity == 0 ? "variable" : "meta-variable";
            Type type = decl.type();
            if (this._symbols.lookupFunctionSymbol(name) != null) {
                this.storeError(decl.token(), "Name of " + kind + " " + name + " already occurs as a function symbol.");
                continue;
            }
            if (this._symbols.symbolDeclared(name)) {
                this.storeError(decl.token(), "Redeclaration of " + kind + " " + name + " in the same environment.");
                continue;
            }
            if (arity == 0) {
                this._symbols.addVariable(TermFactory.createVar(name, type));
                continue;
            }
            this._symbols.addMetaVariable(TermFactory.createMetaVar(name, type, arity));
        }
    }

    private Term moveFreshVariablesIntoConstraint(Term left, Term right, Term constr, TrsFactory.TrsKind kind, Token token) {
        for (Variable x : right.vars()) {
            if (left.freeReplaceables().contains(x)) continue;
            if (!x.queryType().isTheoryType() || !x.queryType().isBaseType()) {
                this.storeError(token, "right-hand side of rule has a fresh variable " + x.queryName() + " of type ", x.queryType(), " which does not occur on the left; only variables of theory sorts may occur fresh (and that only in some kinds of TRSs).");
                continue;
            }
            if (constr == null) {
                constr = TheoryFactory.createEquality(x, x);
                continue;
            }
            if (constr.freeReplaceables().contains(x)) continue;
            constr = TheoryFactory.createConjunction(constr, TheoryFactory.createEquality(x, x));
        }
        return constr;
    }

    private Rule makeRule(Parser.ParserRule rule, TrsFactory.TrsKind kind) {
        this._symbols.clearEnvironment();
        this.readEnvironment(rule.vars());
        Term l = null;
        Term r = null;
        Term c = null;
        if (!rule.left().hasErrors()) {
            l = this.makeTerm(rule.left(), null, true);
        }
        if (!rule.right().hasErrors()) {
            Type expected = null;
            if (l != null) {
                expected = l.queryType();
            }
            r = this.makeTerm(rule.right(), expected, false);
        }
        if (rule.constraint() != null && !rule.constraint().hasErrors()) {
            c = this.makeTerm(rule.constraint(), TypeFactory.boolSort, true);
        }
        if (l == null || r == null) {
            return null;
        }
        if (kind == null || kind.theoriesIncluded()) {
            c = this.moveFreshVariablesIntoConstraint(l, r, c, kind, rule.left().token());
        }
        try {
            if (c == null && kind == null) {
                return TrsFactory.createRule(l, r);
            }
            if (c == null) {
                return TrsFactory.createRule(l, r, kind);
            }
            if (kind == null) {
                return TrsFactory.createRule(l, r, c);
            }
            return TrsFactory.createRule(l, r, c, kind);
        }
        catch (IllegalRuleException e) {
            this.storeError(rule.token(), e);
            return null;
        }
    }

    private TRS makeTRS(Parser.ParserProgram program, TrsFactory.TrsKind kind) {
        for (Parser.ParserDeclaration parserDeclaration : this.sort(program.fundecs())) {
            this.handleFunctionDeclaration(parserDeclaration);
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Parser.ParserRule rule : program.rules()) {
            Rule rho = this.makeRule(rule, kind);
            if (rho == null) continue;
            rules.add(rho);
        }
        Alphabet alphabet = this._symbols.queryCurrentAlphabet();
        try {
            return TrsFactory.createTrs(this._symbols.queryCurrentAlphabet(), rules, this._symbols.queryPrivateSymbols(), false, kind);
        }
        catch (IllegalRuleException e) {
            this.storeError(null, e);
        }
        catch (IllegalSymbolException e) {
            this.storeError(null, e);
        }
        return null;
    }

    static void readDeclarationForUnitTest(String str, SymbolData data, boolean constrained, ErrorCollector collector) {
        Parser.ParserDeclaration decl = CoraParser.readDeclaration(str, constrained, collector);
        CoraInputReader reader = new CoraInputReader(data, collector);
        reader.handleFunctionDeclaration(decl);
    }

    public static Type readType(String str, boolean constrainedTRS) {
        return CoraParser.readType(str, constrainedTRS, null);
    }

    public static Type readType(String str) {
        return CoraParser.readType(str);
    }

    private static void throwIfErrors(ErrorCollector collector) {
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
    }

    public static Term readTerm(String str, TRS trs) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserTerm pt = CoraParser.readTerm(str, trs.theoriesIncluded(), collector);
        CoraInputReader.throwIfErrors(collector);
        SymbolData data = new SymbolData(trs);
        CoraInputReader reader = new CoraInputReader(data, collector);
        Term ret = reader.makeTerm(pt, null, true);
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    private static SymbolData setupSymbolData(TRS trs, Renaming naming) {
        SymbolData data = new SymbolData(trs);
        for (Replaceable r : naming.domain()) {
            String name = naming.getName(r);
            if (r instanceof Variable) {
                Variable x = (Variable)r;
                data.addVariable(x, name);
                continue;
            }
            if (r instanceof MetaVariable) {
                MetaVariable z = (MetaVariable)r;
                data.addMetaVariable(z, name);
                continue;
            }
            throw new IllegalArgumentException("Renaming passed to CoraInputReader::setupSymbolData contains a replaceable " + name + " which is neither a variable nor a meta-variable!");
        }
        return data;
    }

    private static void updateRenaming(MutableRenaming naming, Term t, ErrorCollector collector) {
        for (Replaceable r : t.freeReplaceables()) {
            if (naming.getName(r) != null || naming.setName(r, r.queryName())) continue;
            collector.addError(new ParsingErrorMessage(null, "(meta-)variable " + r.queryName() + " is not allowed for a variable in the given naming scheme"));
        }
    }

    public static Term readTerm(String str, Renaming naming, TRS trs) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserTerm pt = CoraParser.readTerm(str, trs.theoriesIncluded(), collector);
        CoraInputReader.throwIfErrors(collector);
        SymbolData data = CoraInputReader.setupSymbolData(trs, naming);
        CoraInputReader reader = new CoraInputReader(data, collector);
        Term ret = reader.makeTerm(pt, null, true);
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    public static Term readTermAndUpdateNaming(String str, MutableRenaming naming, TRS trs) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserTerm pt = CoraParser.readTerm(str, trs.theoriesIncluded(), collector);
        CoraInputReader.throwIfErrors(collector);
        SymbolData data = CoraInputReader.setupSymbolData(trs, naming);
        CoraInputReader reader = new CoraInputReader(data, collector);
        Term ret = reader.makeTerm(pt, null, true);
        if (ret != null) {
            CoraInputReader.updateRenaming(naming, ret, collector);
        }
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    public static Term readTerm(Parser.ParserTerm pt, Renaming naming, TRS trs) {
        ErrorCollector collector = new ErrorCollector();
        SymbolData data = CoraInputReader.setupSymbolData(trs, naming);
        CoraInputReader reader = new CoraInputReader(data, collector);
        Term ret = reader.makeTerm(pt, null, true);
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    public static Term readTermAndUpdateNaming(Parser.ParserTerm pt, MutableRenaming naming, TRS trs, Type expected) {
        ErrorCollector collector = new ErrorCollector();
        SymbolData data = CoraInputReader.setupSymbolData(trs, naming);
        CoraInputReader reader = new CoraInputReader(data, collector);
        Term ret = reader.makeTerm(pt, expected, true);
        if (ret != null) {
            CoraInputReader.updateRenaming(naming, ret, collector);
        }
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    public static Rule readRule(String str, TRS trs) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserRule rule = CoraParser.readRule(str, trs.theoriesIncluded(), collector);
        CoraInputReader.throwIfErrors(collector);
        SymbolData data = new SymbolData(trs);
        CoraInputReader reader = new CoraInputReader(data, collector);
        Rule ret = reader.makeRule(rule, null);
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    public static TRS readTrsFromString(String str, TrsFactory.TrsKind kind) {
        boolean constrained = kind.theoriesIncluded();
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = CoraParser.readProgramFromString(str, constrained, collector);
        CoraInputReader reader = new CoraInputReader(new SymbolData(), collector);
        TRS ret = reader.makeTRS(trs, kind);
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }

    public static TRS readTrsFromString(String str) {
        return CoraInputReader.readTrsFromString(str, TrsFactory.CORA);
    }

    public static TRS readTrsFromFile(String filename) throws IOException {
        ErrorCollector collector = new ErrorCollector();
        TrsFactory.TrsKind kind = TrsFactory.CORA;
        String extension = filename.substring(filename.lastIndexOf(".") + 1, filename.length()).toLowerCase();
        if (extension.equals("trs") || extension.equals("mstrs")) {
            kind = TrsFactory.MSTRS;
        } else if (extension.equals("lctrs")) {
            kind = TrsFactory.LCTRS;
        } else if (extension.equals("lcstrs")) {
            kind = TrsFactory.LCSTRS;
        } else if (extension.equals("atrs") || extension.equals("strs")) {
            kind = TrsFactory.STRS;
        } else if (extension.equals("cfs") || extension.equals("afs")) {
            kind = TrsFactory.CFS;
        } else if (extension.equals("ams") || extension.equals("afsm")) {
            kind = TrsFactory.AMS;
        } else if (!extension.equals("cora")) {
            collector.addError(new ParsingErrorMessage(null, "Unexpected file extension: " + extension + ".  For default format, use <filename>.cora"));
        }
        boolean constrained = kind.theoriesIncluded();
        Parser.ParserProgram trs = CoraParser.readProgramFromFile(filename, constrained, collector);
        CoraInputReader reader = new CoraInputReader(new SymbolData(), collector);
        TRS ret = reader.makeTRS(trs, kind);
        CoraInputReader.throwIfErrors(collector);
        return ret;
    }
}

