/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.parser.ITrsParser;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.Token;
import charlie.reader.SymbolData;
import charlie.reader.UnexpectedPatternException;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.TypingException;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.types.Arrow;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;

public class ITrsInputReader {
    private ErrorCollector _errors;
    private TreeMap<String, TreeSet<String>> _typeGraph = new TreeMap();
    private SymbolData _symbols;

    private ITrsInputReader(ErrorCollector collector) {
        this._errors = collector;
        this._typeGraph = null;
        this._symbols = null;
    }

    private void storeError(Token token, String message) {
        this._errors.addError(new ParsingErrorMessage(token, message));
    }

    private void storeError(Token token, IllegalRuleException e) {
        this._errors.addError(new ParsingErrorMessage(token, e));
    }

    /*
     * Loose catch block
     */
    private TreeMap<String, Integer> checkArities(Parser.ParserProgram trs) {
        TreeMap<String, Integer> ret = new TreeMap<String, Integer>();
        for (int i = 0; i < trs.rules().size(); ++i) {
            Parser.ParserRule rule = trs.rules().get(i);
            LookupMap<Parser.ParserDeclaration> vars = rule.vars();
            Stack<Parser.ParserTerm> terms = new Stack<Parser.ParserTerm>();
            terms.push(rule.right());
            terms.push(rule.left());
            Parser.ParserTerm pt = rule.constraint();
            if (pt != null) {
                terms.push(pt);
            }
            block25: while (!terms.isEmpty()) {
                Parser.ParserTerm s = (Parser.ParserTerm)terms.pop();
                Objects.requireNonNull(s);
                int n = 0;
                block26: while (true) {
                    Parser.ParserTerm parserTerm;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.BoolVal.class, Parser.IntVal.class, Parser.Identifier.class, Parser.Application.class, Parser.Application.class}, (Object)parserTerm, n)) {
                        case 0: {
                            boolean bl;
                            Token token;
                            Parser.BoolVal boolVal = (Parser.BoolVal)parserTerm;
                            Token token2 = token = boolVal.token();
                            boolean istrue = bl = boolVal.istrue();
                            continue block25;
                        }
                        case 1: {
                            int n2;
                            Token token;
                            Parser.IntVal intVal = (Parser.IntVal)parserTerm;
                            Token token3 = token = intVal.token();
                            int value = n2 = intVal.value();
                            continue block25;
                        }
                        case 2: {
                            Object object;
                            Parser.Identifier identifier = (Parser.Identifier)parserTerm;
                            Object token = object = identifier.token();
                            Object name = object = identifier.name();
                            this.checkFunctionalArities((Token)token, (String)name, FixedList.of(), vars, ret);
                            continue block25;
                        }
                        case 3: {
                            Object name;
                            Object token;
                            FixedList<Parser.ParserTerm> args;
                            Object object = (Parser.Application)parserTerm;
                            Object object2 = ((Parser.Application)object).token();
                            FixedList<Parser.ParserTerm> dummy = object2;
                            object2 = ((Parser.Application)object).head();
                            if (object2 instanceof Parser.Identifier) {
                                Parser.Identifier identifier = (Parser.Identifier)object2;
                                object2 = ((Parser.Application)object).args();
                                args = object2;
                                token = object2 = identifier.token();
                                name = object2 = identifier.name();
                            } else {
                                n = 4;
                                continue block26;
                            }
                            for (int j = args.size() - 1; j >= 0; --j) {
                                terms.push(args.get(j));
                            }
                            this.checkFunctionalArities((Token)token, (String)name, args, vars, ret);
                            continue block25;
                        }
                        case 4: {
                            Object name;
                            Object token;
                            FixedList<Parser.ParserTerm> args;
                            Object object2 = (Parser.Application)parserTerm;
                            Object object = ((Parser.Application)object2).token();
                            Token dummy = object;
                            object = ((Parser.Application)object2).head();
                            if (object instanceof Parser.CalcSymbol) {
                                Parser.CalcSymbol calcSymbol = (Parser.CalcSymbol)object;
                                object = ((Parser.Application)object2).args();
                                args = object;
                                token = object = calcSymbol.token();
                                name = object = calcSymbol.name();
                            } else {
                                n = 5;
                                continue block26;
                            }
                            for (int j = args.size() - 1; j >= 0; --j) {
                                terms.push(args.get(j));
                            }
                            this.checkTheoryArities((Token)token, (String)name, args);
                            continue block25;
                        }
                    }
                    break;
                }
                throw new UnexpectedPatternException("ITrsInputReader", "checkArities", "a variable or functional term", "parser term " + s.toString());
            }
        }
        return ret;
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private void checkFunctionalArities(Token token, String fname, FixedList<Parser.ParserTerm> args, LookupMap<Parser.ParserDeclaration> vars, TreeMap<String, Integer> store) {
        if (vars.containsKey(fname)) {
            if (args.size() != 0) {
                this.storeError(token, "Variable " + fname + " occurs with arguments like a function symbol.");
            }
        } else if (!store.containsKey(fname)) {
            store.put(fname, args.size());
        } else if (store.get(fname).intValue() != args.size()) {
            this.storeError(token, "Function symbol " + fname + " occurs with " + args.size() + " arguments, while it previously occurred with " + String.valueOf(store.get(fname)) + ".");
        }
    }

    private void checkTheoryArities(Token token, String fname, FixedList<Parser.ParserTerm> args) {
        if (fname.equals(ITrsParser.NOT)) {
            if (args.size() != 1) {
                this.storeError(token, "Encountered negation with " + args.size() + " arguments (expected: 1).");
            }
        } else if (fname.equals(ITrsParser.MINUS)) {
            if (args.size() != 1 && args.size() != 2) {
                this.storeError(token, "Encountered minus with " + args.size() + " arguments (expected: 1 or 2).");
            }
        } else if (args.size() != 2) {
            this.storeError(token, "Encountered " + fname + " with " + args.size() + " arguments (expected: 2).");
        }
    }

    private String funArgNode(String f, int index) {
        return "FUN." + f + "." + index;
    }

    private String funOutNode(String f) {
        return "FUN." + f + ".0";
    }

    private String varTypeNode(String varname, int rule) {
        return "VAR." + rule + "." + varname;
    }

    private String intNode() {
        return "INT";
    }

    private String boolNode() {
        return "BOOL";
    }

    private void connect(String node1, String node2) {
        if (!this._typeGraph.containsKey(node1)) {
            this._typeGraph.put(node1, new TreeSet());
        }
        if (!this._typeGraph.containsKey(node2)) {
            this._typeGraph.put(node2, new TreeSet());
        }
        if (node1.equals(node2)) {
            return;
        }
        this._typeGraph.get(node1).add(node2);
        this._typeGraph.get(node2).add(node1);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getTermOutputNode(Parser.ParserTerm term, int rule, LookupMap<Parser.ParserDeclaration> vars) {
        Parser.ParserTerm parserTerm = term;
        Objects.requireNonNull(parserTerm);
        Parser.ParserTerm parserTerm2 = parserTerm;
        int n = 0;
        block17: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.BoolVal.class, Parser.IntVal.class, Parser.Identifier.class, Parser.Application.class, Parser.Application.class, Parser.PErr.class}, (Object)parserTerm2, n)) {
                case 0: {
                    Parser.BoolVal boolVal = (Parser.BoolVal)parserTerm2;
                    try {
                        boolean bl;
                        Token token;
                        Token token2 = token = boolVal.token();
                        boolean istrue = bl = boolVal.istrue();
                        return this.boolNode();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    Parser.IntVal intVal = (Parser.IntVal)parserTerm2;
                    {
                        int n2;
                        Token token;
                        Token token3 = token = intVal.token();
                        int value = n2 = intVal.value();
                        return this.intNode();
                    }
                }
                case 2: {
                    Object object;
                    Parser.Identifier identifier = (Parser.Identifier)parserTerm2;
                    {
                        Object token = object = identifier.token();
                        Object name = object = identifier.name();
                        if (!vars.containsKey((String)name)) return this.funArgNode((String)name, 0);
                        return this.varTypeNode((String)name, rule);
                    }
                }
                case 3: {
                    Object object2;
                    Object object = (Parser.Application)parserTerm2;
                    {
                        object2 = ((Parser.Application)object).token();
                        FixedList<Parser.ParserTerm> t1 = object2;
                        object2 = ((Parser.Application)object).head();
                    }
                    if (object2 instanceof Parser.Identifier) {
                        Parser.Identifier identifier = (Parser.Identifier)object2;
                        {
                            object2 = ((Parser.Application)object).args();
                            FixedList<Parser.ParserTerm> a = object2;
                            Object t2 = object2 = identifier.token();
                            Object name = object2 = identifier.name();
                            return this.funOutNode((String)name);
                        }
                    }
                    n = 4;
                    continue block17;
                }
                case 4: {
                    Object name;
                    Object object;
                    Object object2 = (Parser.Application)parserTerm2;
                    {
                        object = ((Parser.Application)object2).token();
                        FixedList<Parser.ParserTerm> t1 = object;
                        object = ((Parser.Application)object2).head();
                    }
                    if (object instanceof Parser.CalcSymbol) {
                        Parser.CalcSymbol calcSymbol = (Parser.CalcSymbol)object;
                        {
                            object = ((Parser.Application)object2).args();
                            FixedList<Parser.ParserTerm> a = object;
                            Object t2 = object = calcSymbol.token();
                            name = object = calcSymbol.name();
                        }
                    } else {
                        n = 5;
                        continue block17;
                    }
                    if (((String)name).equals(ITrsParser.PLUS)) return this.intNode();
                    if (((String)name).equals(ITrsParser.MINUS)) return this.intNode();
                    if (((String)name).equals(ITrsParser.TIMES)) return this.intNode();
                    if (((String)name).equals(ITrsParser.DIV)) return this.intNode();
                    if (!((String)name).equals(ITrsParser.MOD)) return this.boolNode();
                    return this.intNode();
                }
                case 5: {
                    Object object = (Parser.PErr)parserTerm2;
                    {
                        Parser.ParserTerm parserTerm3;
                        Parser.ParserTerm t = parserTerm3 = ((Parser.PErr)object).t();
                        return this.getTermOutputNode(t, rule, vars);
                    }
                }
            }
            break;
        }
        throw new UnexpectedPatternException("ITrsInputReader", "getTermOutputNode", "a variable or functional term", "parser term " + term.toString());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateTypeGraph(Parser.ParserProgram trs, TreeMap<String, Integer> arities) {
        this._typeGraph = new TreeMap();
        this._typeGraph.put(this.intNode(), new TreeSet());
        this._typeGraph.put(this.boolNode(), new TreeSet());
        int rule = 0;
        while (rule < trs.rules().size()) {
            Parser.ParserRule rho = trs.rules().get(rule);
            Parser.ParserTerm left = rho.left();
            Parser.ParserTerm right = rho.right();
            Parser.ParserTerm constr = rho.constraint();
            LookupMap<Parser.ParserDeclaration> vars = rho.vars();
            this.connect(this.getTermOutputNode(left, rule, vars), this.getTermOutputNode(right, rule, vars));
            if (constr != null) {
                this.connect(this.boolNode(), this.getTermOutputNode(constr, rule, vars));
            }
            Stack<Parser.ParserTerm> todo = new Stack<Parser.ParserTerm>();
            todo.push(left);
            todo.push(right);
            if (constr != null) {
                todo.push(constr);
            }
            while (!todo.isEmpty()) {
                Parser.ParserTerm u;
                FixedList<Parser.ParserTerm> a;
                FixedList<Parser.ParserTerm> h;
                Parser.ParserTerm t = (Parser.ParserTerm)todo.pop();
                if (!(t instanceof Parser.Application)) continue;
                Object application = (Parser.Application)t;
                try {
                    FixedList<Parser.ParserTerm> fixedList = ((Parser.Application)application).token();
                    Token x = fixedList;
                    h = fixedList = ((Parser.Application)application).head();
                    a = fixedList = ((Parser.Application)application).args();
                    application = a.iterator();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                while (application.hasNext()) {
                    u = (Parser.ParserTerm)application.next();
                    todo.push(u);
                }
                String base = null;
                if (h instanceof Parser.CalcSymbol) {
                    u = (Parser.CalcSymbol)((Object)h);
                    {
                        Object object = ((Parser.CalcSymbol)u).token();
                        Token y = object;
                        object = ((Parser.CalcSymbol)u).name();
                        Object name = object;
                        base = ((String)name).equals(ITrsParser.AND) || ((String)name).equals(ITrsParser.OR) || ((String)name).equals(ITrsParser.NOT) ? this.boolNode() : this.intNode();
                    }
                }
                for (int i = 1; i <= a.size(); ++i) {
                    if (h instanceof Parser.Identifier) {
                        Parser.Identifier identifier = (Parser.Identifier)((Object)h);
                        {
                            Object object = identifier.token();
                            Token y = object;
                            Object name = object = identifier.name();
                            base = this.funArgNode((String)name, i);
                        }
                    }
                    this.connect(base, this.getTermOutputNode(a.get(i - 1), rule, vars));
                }
            }
            ++rule;
        }
        return;
    }

    private TreeSet<String> floodfill(String start) {
        TreeSet<String> visited = new TreeSet<String>();
        Stack<String> todo = new Stack<String>();
        visited.add(start);
        todo.push(start);
        while (!todo.isEmpty()) {
            String node = (String)todo.pop();
            for (String neighbour : this._typeGraph.get(node)) {
                if (visited.contains(neighbour)) continue;
                todo.push(neighbour);
                visited.add(neighbour);
            }
        }
        return visited;
    }

    private Type determineNodeType(String node, TreeSet<String> intNodes, TreeSet<String> boolNodes) {
        if (intNodes.contains(node)) {
            return TypeFactory.intSort;
        }
        if (boolNodes.contains(node)) {
            return TypeFactory.boolSort;
        }
        return TypeFactory.defaultSort;
    }

    private void determineSymbolTypes(TreeMap<String, Integer> arities) {
        TreeSet<String> intNodes = this.floodfill(this.intNode());
        TreeSet<String> boolNodes = this.floodfill(this.boolNode());
        if (intNodes.contains(this.boolNode())) {
            this._errors.addError(new ParsingErrorMessage(null, "I could not derive a valid typing (Int and Bool positions are not consistentnly used)."));
            return;
        }
        this._symbols = new SymbolData();
        for (Map.Entry<String, Integer> entry : arities.entrySet()) {
            String f = entry.getKey();
            int arity = entry.getValue();
            Type type = this.determineNodeType(this.funOutNode(f), intNodes, boolNodes);
            for (int i = arity; i > 0; --i) {
                Type inp = this.determineNodeType(this.funArgNode(f, i), intNodes, boolNodes);
                type = TypeFactory.createArrow(inp, type);
            }
            this._symbols.addFunctionSymbol(TermFactory.createConstant(f, type));
        }
    }

    /*
     * Unable to fully structure code
     */
    private Term makeTerm(Parser.ParserTerm term, Type expected) {
        v0 = term;
        Objects.requireNonNull(v0);
        var4_3 = v0;
        var5_5 = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.IntVal.class, Parser.BoolVal.class, Parser.Identifier.class, Parser.Application.class}, (Object)var4_3, var5_5)) {
            case 0: {
                var6_6 = (Parser.IntVal)var4_3;
                t = var9_7 = var6_6.token();
                value = var9_8 = var6_6.value();
                return TheoryFactory.createValue(value);
            }
            case 1: {
                var9_9 = (Parser.BoolVal)var4_3;
                t = var12_12 = var9_9.token();
                isTrue = var12_13 = var9_9.istrue();
                return TheoryFactory.createValue(isTrue);
            }
            case 2: {
                var12_14 = (Parser.Identifier)var4_3;
                var15_17 = var12_14.token();
                t = var15_17;
                name = var15_17 = var12_14.name();
                f = this._symbols.lookupFunctionSymbol((String)name);
                if (f != null) {
                    return f;
                }
                x = this._symbols.lookupVariable((String)name);
                if (x != null) {
                    return x;
                }
                if (expected != null) ** GOTO lbl36
                return TermFactory.createVar((String)name);
lbl36:
                // 1 sources

                x = TermFactory.createVar((String)name, expected);
                this._symbols.addVariable(x);
                return x;
            }
            case 3: {
                var16_22 = (Parser.Application)var4_3;
                var20_23 = var16_22.token();
                token = var20_23;
                head = var20_23 = var16_22.head();
                args = var20_23 = var16_22.args();
                f = this.readSymbol((Parser.ParserTerm)head);
                targs = new ArrayList<Term>();
                minus = false;
                if (f.equals(TheoryFactory.minusSymbol) && args.size() == 2) {
                    f = TheoryFactory.plusSymbol;
                    minus = true;
                }
                type = f.queryType();
                block21: for (Parser.ParserTerm s : args) {
                    Objects.requireNonNull(type);
                    var26_32 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Arrow.class}, (Object)var25_31, var26_32)) {
                        case 0: {
                            var27_33 = (Arrow)var25_31;
                            inp = var30_36 = var27_33.left();
                            outp = var30_36 = var27_33.right();
                            targs.add(this.makeTerm(s, inp));
                            type = outp;
                            continue block21;
                        }
                    }
                    throw new TypingException(new Object[]{"ITrsInputReader", "makeTerm", "function symbol f", f.queryType().toString(), "of arity " + args.size()});
                }
                if (minus) {
                    targs.set(1, TheoryFactory.minusSymbol.apply(targs.get(1)));
                }
                return f.apply(targs);
            }
        }
        throw new UnexpectedPatternException("ITrsInputReader", "makeTerm", "a variable or functional term", "parser term " + term.toString());
        catch (Throwable var4_4) {
            throw new MatchException(var4_4.toString(), var4_4);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private FunctionSymbol readSymbol(Parser.ParserTerm term) {
        Parser.ParserTerm parserTerm = term;
        Objects.requireNonNull(parserTerm);
        Parser.ParserTerm parserTerm2 = parserTerm;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.Identifier.class, Parser.CalcSymbol.class}, (Object)parserTerm2, n)) {
            case 0: {
                Parser.Identifier identifier = (Parser.Identifier)parserTerm2;
                try {
                    Object object = identifier.token();
                    Token t = object;
                    Object name = object = identifier.name();
                    FunctionSymbol f = this._symbols.lookupFunctionSymbol((String)name);
                    if (f != null) return f;
                    throw new Error("Somehow function symbol " + (String)name + " is not declared.");
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                Parser.CalcSymbol calcSymbol = (Parser.CalcSymbol)parserTerm2;
                {
                    Object object = calcSymbol.token();
                    Token t = object;
                    Object name = object = calcSymbol.name();
                    if (((String)name).equals(ITrsParser.PLUS)) {
                        return TheoryFactory.plusSymbol;
                    }
                    if (((String)name).equals(ITrsParser.TIMES)) {
                        return TheoryFactory.timesSymbol;
                    }
                    if (((String)name).equals(ITrsParser.MINUS)) {
                        return TheoryFactory.minusSymbol;
                    }
                    if (((String)name).equals(ITrsParser.DIV)) {
                        return TheoryFactory.divSymbol;
                    }
                    if (((String)name).equals(ITrsParser.MOD)) {
                        return TheoryFactory.modSymbol;
                    }
                    if (((String)name).equals(ITrsParser.GREATER)) {
                        return TheoryFactory.greaterSymbol;
                    }
                    if (((String)name).equals(ITrsParser.SMALLER)) {
                        return TheoryFactory.smallerSymbol;
                    }
                    if (((String)name).equals(ITrsParser.GEQ)) {
                        return TheoryFactory.geqSymbol;
                    }
                    if (((String)name).equals(ITrsParser.LEQ)) {
                        return TheoryFactory.leqSymbol;
                    }
                    if (((String)name).equals(ITrsParser.EQUALS)) {
                        return TheoryFactory.intEqualSymbol;
                    }
                    if (((String)name).equals(ITrsParser.NEQ)) {
                        return TheoryFactory.intDistinctSymbol;
                    }
                    if (((String)name).equals(ITrsParser.AND)) {
                        return TheoryFactory.andSymbol;
                    }
                    if (((String)name).equals(ITrsParser.OR)) {
                        return TheoryFactory.orSymbol;
                    }
                    if (!((String)name).equals(ITrsParser.NOT)) throw new UnexpectedPatternException("ITrsInputReader", "readSymbol", "a declared identifier or known calculation symbol", "parser term " + term.toString());
                    return TheoryFactory.notSymbol;
                }
            }
        }
        throw new UnexpectedPatternException("ITrsInputReader", "readSymbol", "a declared identifier or known calculation symbol", "parser term " + term.toString());
    }

    private Rule makeRule(Parser.ParserRule rule) {
        this._symbols.clearEnvironment();
        Term l = this.makeTerm(rule.left(), null);
        if (l.isVariable()) {
            this.storeError(rule.token(), "The left-hand side of a rule is not allowed to be a variable.");
            this.makeTerm(rule.right(), null);
            return null;
        }
        Term r = this.makeTerm(rule.right(), l.queryType());
        Term constraint = null;
        if (rule.constraint() != null) {
            constraint = this.makeTerm(rule.constraint(), TypeFactory.boolSort);
        }
        try {
            if (constraint != null) {
                return TrsFactory.createRule(l, r, constraint, TrsFactory.LCTRS);
            }
            return TrsFactory.createRule(l, r, TrsFactory.LCTRS);
        }
        catch (IllegalRuleException e) {
            this.storeError(rule.token(), e);
            return null;
        }
    }

    private TRS makeTRS(Parser.ParserProgram trs) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Parser.ParserRule rho : trs.rules()) {
            Rule r = this.makeRule(rho);
            if (r == null) continue;
            rules.add(r);
        }
        Alphabet alphabet = this._symbols.queryCurrentAlphabet();
        try {
            return TrsFactory.createTrs(alphabet, rules, TrsFactory.LCTRS);
        }
        catch (IllegalRuleException e) {
            this._errors.addError(new ParsingErrorMessage(null, e.getMessage()));
            return null;
        }
    }

    private static void throwIfAnyErrors(ErrorCollector collector) {
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
    }

    private static TRS readParserProgram(Parser.ParserProgram trs, ErrorCollector collector) {
        ITrsInputReader.throwIfAnyErrors(collector);
        ITrsInputReader rd = new ITrsInputReader(collector);
        TreeMap<String, Integer> arities = rd.checkArities(trs);
        ITrsInputReader.throwIfAnyErrors(collector);
        rd.generateTypeGraph(trs, arities);
        rd.determineSymbolTypes(arities);
        ITrsInputReader.throwIfAnyErrors(collector);
        TRS ret = rd.makeTRS(trs);
        ITrsInputReader.throwIfAnyErrors(collector);
        return ret;
    }

    public static TRS readTrsFromString(String str) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = ITrsParser.readProgramFromString(str, collector);
        return ITrsInputReader.readParserProgram(trs, collector);
    }

    public static TRS readTrsFromFile(String filename) throws IOException {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = ITrsParser.readProgramFromFile(filename, collector);
        return ITrsInputReader.readParserProgram(trs, collector);
    }
}

