/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.parser.OCocoParser;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.Token;
import charlie.reader.SymbolData;
import charlie.reader.UnexpectedPatternException;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.LookupMap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;

public class OCocoSortedInputReader {
    private SymbolData _symbols;
    private ErrorCollector _errors;

    private OCocoSortedInputReader(SymbolData data, ErrorCollector collector) {
        this._symbols = data;
        this._errors = collector;
    }

    protected void storeError(Token token, Object ... message) {
        this._errors.addError(new ParsingErrorMessage(token, message));
    }

    protected void storeError(Token token, IllegalRuleException e) {
        this._errors.addError(new ParsingErrorMessage(token, e));
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private Term makeTerm(Parser.ParserTerm pterm, Type expected) {
        texp /* !! */  = expected == null ? TypeFactory.defaultSort : expected;
        v0 = pterm;
        Objects.requireNonNull(v0);
        var5_4 = v0;
        var6_6 = 0;
        block16: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.Identifier.class, Parser.Application.class}, (Object)var5_4, var6_6)) {
                case 0: {
                    var7_10 = (Parser.Identifier)var5_4;
                    var10_11 = var7_10.token();
                    token = var10_11;
                    name = var10_11 = var7_10.name();
                    x = this._symbols.lookupVariable((String)name);
                    if (x != null && (expected == null || x.queryType().equals(expected))) {
                        return x;
                    }
                    f = this._symbols.lookupFunctionSymbol((String)name);
                    if (f != null && expected == null && f.queryArity() == 0) {
                        return f;
                    }
                    if (f != null && expected != null && f.queryType().equals(expected)) {
                        return f;
                    }
                    if (x != null || f != null) ** GOTO lbl29
                    x = TermFactory.createVar((String)name, texp /* !! */ );
                    if (expected != null) {
                        this._symbols.addVariable(x);
                    }
                    return x;
lbl29:
                    // 1 sources

                    if (x != null) {
                        this.storeError(token, new Object[]{"Expected term of type " + String.valueOf(expected), ", but got variable " + (String)name + " that was previously used with type ", x.queryType(), "."});
                    } else if (f.queryArity() == 0) {
                        this.storeError(token, new Object[]{"Expected term of type ", expected, ", but got constant symbol " + (String)name + " of type ", f.queryType(), "."});
                    } else {
                        this.storeError(token, new Object[]{"Illegal occurrence of unapplied function symbol " + (String)name + "!"});
                    }
                    return TermFactory.createConstant((String)name, texp /* !! */ );
                }
                case 1: {
                    var11_8 = (Parser.Application)var5_4;
                    var17_7 = var11_8.token();
                    token = var17_7;
                    var17_7 = var11_8.head();
                    if (var17_7 instanceof Parser.Identifier) {
                        var13_16 = (Parser.Identifier)var17_7;
                        var17_7 = var11_8.args();
                        args = var17_7;
                        t2 = var17_7 = var13_16.token();
                        name = var17_7 = var13_16.name();
                    } else {
                        var6_6 = 2;
                        continue block16;
                    }
                    f = this._symbols.lookupFunctionSymbol((String)name);
                    children = new ArrayList<Term>();
                    if (f != null && f.queryArity() == args.size() && (expected == null || f.queryType().queryOutputType().equals(expected))) {
                        t = f.queryType();
                        i = 0;
                        while (t instanceof Arrow) {
                            var19_24 = (Arrow)t;
                            inp = var23_31 = var19_24.left();
                            out = var23_31 = var19_24.right();
                            children.add(this.makeTerm(args.get(i), inp));
                            t = out;
                            ++i;
                        }
                        return TermFactory.createFunctionalTerm(f, children);
                    }
                    if (this._symbols.lookupVariable((String)name) != null) {
                        this.storeError(token, new Object[]{"Variable " + (String)name + " used as a function symbol!"});
                    } else if (f == null) {
                        this.storeError(token, new Object[]{"Undeclared function symbol: " + (String)name + "."});
                    } else if (f.queryArity() != args.size()) {
                        this.storeError(token, new Object[]{"Function symbol " + (String)name + " was declared with " + f.queryArity() + " arguments, but is used here with " + args.size() + "."});
                    } else {
                        this.storeError(token, new Object[]{"Expected term of type ", expected, ", but got functional term " + (String)name + "(...) of type ", f.queryType().queryOutputType(), "."});
                        t = f.queryType();
                        i = 0;
                        while (t instanceof Arrow) {
                            var19_25 = (Arrow)t;
                            inp = var23_32 = var19_25.left();
                            out = var23_32 = var19_25.right();
                            children.add(this.makeTerm(args.get(i), inp));
                            t = out;
                            ++i;
                        }
                    }
                    while (children.size() < args.size()) {
                        children.add(this.makeTerm(args.get(children.size()), null));
                    }
                    t = expected;
                    if (t == null) {
                        t = TypeFactory.defaultSort;
                    }
                    for (i = children.size() - 1; i >= 0; --i) {
                        t = TypeFactory.createArrow(children.get(i).queryType(), t);
                    }
                    f = TermFactory.createConstant((String)name, t);
                    return TermFactory.createFunctionalTerm(f, children);
                }
            }
            break;
        }
        throw new UnexpectedPatternException("OCocoSortedInputReader", "makeUnsortedTerm", "parser term " + pterm.toString(), "a variable or functional term");
        catch (Throwable var5_5) {
            throw new MatchException(var5_5.toString(), var5_5);
        }
    }

    private Rule makeRule(Parser.ParserRule rule) {
        Parser.ParserTerm left = rule.left();
        Parser.ParserTerm right = rule.right();
        if (left.hasErrors()) {
            return null;
        }
        Term l = this.makeTerm(left, null);
        if (l.isVariable()) {
            this.storeError(rule.token(), "The left-hand side of a rule is not allowed to be a variable.");
            if (!right.hasErrors()) {
                this.makeTerm(right, null);
            }
            return null;
        }
        if (right.hasErrors()) {
            return null;
        }
        Term r = this.makeTerm(right, l.queryType());
        this._symbols.clearEnvironment();
        try {
            return TrsFactory.createRule(l, r, TrsFactory.MSTRS);
        }
        catch (IllegalRuleException e) {
            this.storeError(rule.token(), e);
            return null;
        }
    }

    private TRS makeTRS(Parser.ParserProgram trs) {
        LookupMap<Parser.ParserDeclaration> decl = trs.fundecs();
        for (String string : decl.keySet()) {
            this._symbols.addFunctionSymbol(TermFactory.createConstant(string, decl.get(string).type()));
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Parser.ParserRule rule : trs.rules()) {
            Rule r = this.makeRule(rule);
            if (r == null) continue;
            rules.add(r);
        }
        Alphabet alphabet = this._symbols.queryCurrentAlphabet();
        return TrsFactory.createTrs(alphabet, rules, TrsFactory.MSTRS);
    }

    private static Term readTerm(String str, SymbolData data, Base expectedSort) {
        ErrorCollector collector = new ErrorCollector();
        OCocoSortedInputReader rd = new OCocoSortedInputReader(data, collector);
        Parser.ParserTerm pterm = OCocoParser.readTerm(str, collector);
        Term ret = null;
        if (collector.queryErrorCount() == 0) {
            ret = rd.makeTerm(pterm, expectedSort);
        }
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
        return ret;
    }

    public static Term readTerm(String str, String sig, Base expectedSort) {
        sig = "(SIG " + (String)sig + ")\n";
        LookupMap<Parser.ParserDeclaration> decs = OCocoParser.readDeclarations((String)sig);
        SymbolData data = new SymbolData();
        for (String d : decs.keySet()) {
            data.addFunctionSymbol(TermFactory.createConstant(d, decs.get(d).type()));
        }
        return OCocoSortedInputReader.readTerm(str, data, expectedSort);
    }

    public static Term readTerm(String str, String sig) {
        return OCocoSortedInputReader.readTerm(str, sig, null);
    }

    public static Term readTerm(String str, TRS trs) {
        return OCocoSortedInputReader.readTerm(str, new SymbolData(trs), null);
    }

    static TRS readParserProgram(Parser.ParserProgram trs, ErrorCollector collector) {
        OCocoSortedInputReader rd = new OCocoSortedInputReader(new SymbolData(), collector);
        TRS ret = rd.makeTRS(trs);
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
        return ret;
    }

    public static TRS readTrsFromString(String str) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = OCocoParser.readProgramFromString(str, collector);
        return OCocoSortedInputReader.readParserProgram(trs, collector);
    }

    public static TRS readTrsFromFile(String filename) throws IOException {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = OCocoParser.readProgramFromFile(filename, collector);
        return OCocoSortedInputReader.readParserProgram(trs, collector);
    }
}

