/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.parser.OCocoParser;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.Token;
import charlie.reader.SymbolData;
import charlie.reader.UnexpectedPatternException;
import charlie.terms.FunctionSymbol;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.Variable;
import charlie.trs.Alphabet;
import charlie.trs.IllegalRuleException;
import charlie.trs.Rule;
import charlie.trs.TRS;
import charlie.trs.TrsFactory;
import charlie.types.Arrow;
import charlie.types.Base;
import charlie.types.Product;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.LookupMap;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;

public class OCocoUnsortedInputReader {
    private SymbolData _symbols;
    private ErrorCollector _errors;

    private OCocoUnsortedInputReader(SymbolData data, ErrorCollector collector) {
        this._symbols = data;
        this._errors = collector;
    }

    private void storeError(Token token, String message) {
        this._errors.addError(new ParsingErrorMessage(token, message));
    }

    private void storeError(Token token, IllegalRuleException e) {
        this._errors.addError(new ParsingErrorMessage(token, e));
    }

    /*
     * Loose catch block
     */
    private Term makeTerm(Parser.ParserTerm pterm) {
        FunctionSymbol f;
        FixedList<Object> args;
        Object name;
        Object token;
        Parser.ParserTerm parserTerm = pterm;
        Objects.requireNonNull(parserTerm);
        Parser.ParserTerm parserTerm2 = parserTerm;
        int n = 0;
        block12: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.Identifier.class, Parser.Application.class}, (Object)parserTerm2, n)) {
                case 0: {
                    Object object;
                    Parser.Identifier identifier = (Parser.Identifier)parserTerm2;
                    Object t = object = identifier.token();
                    Object n2 = object = identifier.name();
                    token = t;
                    name = n2;
                    args = FixedList.of();
                    break block12;
                }
                case 1: {
                    Object n3;
                    FixedList<Parser.ParserTerm> a;
                    Object object = (Parser.Application)parserTerm2;
                    Object object2 = ((Parser.Application)object).token();
                    Token t1 = object2;
                    object2 = ((Parser.Application)object).head();
                    if (object2 instanceof Parser.Identifier) {
                        Parser.Identifier identifier = (Parser.Identifier)object2;
                        object2 = ((Parser.Application)object).args();
                        a = object2;
                        Object t2 = object2 = identifier.token();
                        n3 = object2 = identifier.name();
                    } else {
                        n = 2;
                        continue block12;
                    }
                    token = t1;
                    name = n3;
                    args = a;
                    break block12;
                }
                default: {
                    throw new UnexpectedPatternException("OCocoUnsortedInputReader", "makeTerm", "parser term " + pterm.toString(), "a variable or functional term");
                }
            }
            break;
        }
        Variable x = this._symbols.lookupVariable((String)name);
        if (x != null) {
            if (args.size() == 0) {
                return x;
            }
            this.storeError((Token)token, "Variable " + (String)name + " used as root of a functional term.");
        }
        if ((f = this._symbols.lookupFunctionSymbol((String)name)) == null) {
            f = TermFactory.createConstant((String)name, args.size());
            this._symbols.addFunctionSymbol(f);
        } else if (f.queryArity() != args.size()) {
            this.storeError((Token)token, "Function symbol " + (String)name + " was previously used with " + f.queryArity() + " arguments, but is here used with " + args.size() + ".");
            f = TermFactory.createConstant((String)name, args.size());
        }
        ArrayList<Term> children = new ArrayList<Term>();
        for (int i = 0; i < args.size(); ++i) {
            children.add(this.makeTerm((Parser.ParserTerm)args.get(i)));
        }
        return TermFactory.createFunctionalTerm(f, children);
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private Rule makeRule(Parser.ParserRule rule) {
        LookupMap<Parser.ParserDeclaration> vars = rule.vars();
        Parser.ParserTerm left = rule.left();
        Parser.ParserTerm right = rule.right();
        this._symbols.clearEnvironment();
        for (String name : vars.keySet()) {
            Variable x = TermFactory.createVar(name, vars.get(name).type());
            if (this._symbols.lookupFunctionSymbol(name) != null) {
                this.storeError(vars.get(name).token(), "Duplicate symbol: " + name + " occurs both as a variable and as a function symbol!");
                throw this._errors.generateException();
            }
            this._symbols.addVariable(x);
        }
        if (left.hasErrors()) {
            return null;
        }
        Term l = this.makeTerm(left);
        if (right.hasErrors()) {
            return null;
        }
        Term r = this.makeTerm(right);
        try {
            return TrsFactory.createRule(l, r, TrsFactory.MSTRS);
        }
        catch (IllegalRuleException e) {
            this.storeError(rule.token(), e);
            return null;
        }
    }

    private Boolean isUnsorted(Type t) {
        Type type = t;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Base.class, Arrow.class, Product.class}, (Object)type2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                String string;
                Base base = (Base)type2;
                String n2 = string = base.name();
                return t.equals(TypeFactory.defaultSort);
            }
            case 1: {
                Type type3;
                Arrow arrow = (Arrow)type2;
                Type a = type3 = arrow.left();
                Type b = type3 = arrow.right();
                return this.isUnsorted(a) != false && this.isUnsorted(b) != false;
            }
            case 2: 
        }
        Product product = (Product)type2;
        try {
            FixedList<Type> fixedList;
            FixedList<Type> args = fixedList = product.types();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return false;
    }

    private TRS makeTRS(Parser.ParserProgram trs) {
        LookupMap<Parser.ParserDeclaration> decl = trs.fundecs();
        boolean problems = false;
        for (String string : decl.keySet()) {
            Type t = decl.get(string).type();
            if (!this.isUnsorted(t).booleanValue()) {
                this.storeError(decl.get(string).token(), "Many-sorted function symbol " + string + " cannot occur in an unsorted TRS.");
                problems = true;
            }
            this._symbols.addFunctionSymbol(TermFactory.createConstant(string, t));
        }
        if (problems) {
            return null;
        }
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (Parser.ParserRule rule : trs.rules()) {
            Rule r = this.makeRule(rule);
            if (r == null) continue;
            rules.add(r);
        }
        Alphabet alphabet = this._symbols.queryCurrentAlphabet();
        if (!decl.isEmpty()) {
            for (FunctionSymbol f : alphabet.getSymbols()) {
                if (decl.containsKey(f.queryName())) continue;
                this.storeError(null, "Undeclared function symbol (not allowed when SIG is given): " + f.queryName());
            }
        }
        return TrsFactory.createTrs(alphabet, rules, TrsFactory.MSTRS);
    }

    public static Term readTerm(String str, String vars) {
        ErrorCollector collector = new ErrorCollector();
        vars = "(VAR " + (String)vars + ")";
        LookupMap<Parser.ParserDeclaration> decs = OCocoParser.readDeclarations((String)vars, collector);
        Parser.ParserTerm pterm = OCocoParser.readTerm(str, collector);
        SymbolData data = new SymbolData();
        for (String v : decs.keySet()) {
            data.addVariable(TermFactory.createVar(v, decs.get(v).type()));
        }
        OCocoUnsortedInputReader rd = new OCocoUnsortedInputReader(data, collector);
        Term ret = null;
        if (collector.queryErrorCount() == 0) {
            ret = rd.makeTerm(pterm);
        }
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
        return ret;
    }

    static TRS readParserProgram(Parser.ParserProgram trs, ErrorCollector collector) {
        OCocoUnsortedInputReader rd = new OCocoUnsortedInputReader(new SymbolData(), collector);
        TRS ret = rd.makeTRS(trs);
        if (collector.queryErrorCount() > 0) {
            throw collector.generateException();
        }
        return ret;
    }

    public static TRS readTrsFromString(String str) {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = OCocoParser.readProgramFromString(str, collector);
        return OCocoUnsortedInputReader.readParserProgram(trs, collector);
    }

    public static TRS readTrsFromFile(String filename) throws IOException {
        ErrorCollector collector = new ErrorCollector();
        Parser.ParserProgram trs = OCocoParser.readProgramFromFile(filename, collector);
        return OCocoUnsortedInputReader.readParserProgram(trs, collector);
    }
}

