/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.terms.FunctionSymbol;
import charlie.terms.MetaVariable;
import charlie.terms.Variable;
import charlie.trs.Alphabet;
import charlie.trs.TRS;
import charlie.types.Type;
import charlie.util.NullStorageException;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

class SymbolData {
    private TRS _trs;
    private TreeMap<String, FunctionSymbol> _alphabet;
    private TreeMap<String, Variable> _variables;
    private TreeMap<String, MetaVariable> _mvariables;
    private TreeSet<String> _private;

    SymbolData() {
        this._trs = null;
        this._alphabet = new TreeMap();
        this._variables = new TreeMap();
        this._mvariables = new TreeMap();
        this._private = new TreeSet();
    }

    SymbolData(TRS trs) {
        this._trs = trs;
        this._alphabet = new TreeMap();
        this._variables = new TreeMap();
        this._mvariables = new TreeMap();
    }

    public int queryNumberFunctionSymbols() {
        return this._alphabet.size();
    }

    public FunctionSymbol lookupFunctionSymbol(String symbol) {
        FunctionSymbol ret = this._alphabet.get(symbol);
        if (ret == null && this._trs != null) {
            ret = this._trs.lookupSymbol(symbol);
        }
        return ret;
    }

    public void addFunctionSymbol(FunctionSymbol symbol) {
        if (symbol == null) {
            throw new NullStorageException("SymbolData", "function symbol");
        }
        String name = symbol.queryName();
        Type type = symbol.queryType();
        FunctionSymbol existing = this.lookupFunctionSymbol(name);
        if (existing != null && !symbol.equals(existing)) {
            throw new IllegalArgumentException("Duplicate call to SymbolData::addFunctionSymbol: trying to overwrite previously declared symbol " + name);
        }
        this._alphabet.put(name, symbol);
    }

    public void addVariable(Variable variable) {
        this.addVariable(variable, variable.queryName());
    }

    public void addVariable(Variable variable, String varname) {
        if (variable == null) {
            throw new NullStorageException("SymbolData", "variable");
        }
        if (varname == null) {
            throw new NullStorageException("SymbolData", "varname");
        }
        Type type = variable.queryType();
        Variable existing = this._variables.get(varname);
        if (existing != null && !variable.equals(existing)) {
            throw new IllegalArgumentException("Duplicate call to SymbolData::addVariable: trying to overwrite previously declared variable " + varname);
        }
        this._variables.put(varname, variable);
    }

    public void addMetaVariable(MetaVariable mvar, String mvarname) {
        if (mvar == null) {
            throw new NullStorageException("SymbolData", "mvar");
        }
        if (mvarname == null) {
            throw new NullStorageException("SymbolData", "mvarname");
        }
        Type type = mvar.queryType();
        MetaVariable existing = this._mvariables.get(mvarname);
        if (existing != null && !mvar.equals(existing)) {
            throw new IllegalArgumentException("Duplicate call to SymbolData::addMetaVariable: trying to overwrite previously declared meta-variable " + mvarname);
        }
        this._mvariables.put(mvarname, mvar);
    }

    public void addMetaVariable(MetaVariable mvar) {
        this.addMetaVariable(mvar, mvar.queryName());
    }

    public void setPrivate(FunctionSymbol symbol) {
        if (symbol == null) {
            throw new NullStorageException("SymbolData", "private function symbol");
        }
        this._private.add(symbol.queryName());
    }

    public Variable removeVariable(String name) {
        Variable existing = this._variables.get(name);
        this._variables.remove(name);
        return existing;
    }

    public void clearEnvironment() {
        this._variables.clear();
        this._mvariables.clear();
    }

    public int queryNumberVariables() {
        return this._variables.size();
    }

    public int queryNumberMetaVariables() {
        return this._mvariables.size();
    }

    public Variable lookupVariable(String name) {
        return this._variables.get(name);
    }

    public MetaVariable lookupMetaVariable(String name) {
        return this._mvariables.get(name);
    }

    public boolean symbolDeclared(String name) {
        return this.lookupVariable(name) != null || this.lookupMetaVariable(name) != null || this.lookupFunctionSymbol(name) != null;
    }

    public Alphabet queryCurrentAlphabet() {
        if (this._trs != null) {
            throw new RuntimeException("Calling queryCurrentAlphabet for SymbolData constructed with a given TRS!");
        }
        return new Alphabet(this._alphabet.values());
    }

    public TreeSet<String> queryPrivateSymbols() {
        return new TreeSet<String>((SortedSet<String>)this._private);
    }
}

