/*
 * Decompiled with CFR 0.152.
 */
package charlie.reader;

import charlie.parser.CoraParser;
import charlie.parser.Parser;
import charlie.parser.lib.ErrorCollector;
import charlie.parser.lib.ParsingErrorMessage;
import charlie.parser.lib.Token;
import charlie.reader.SymbolData;
import charlie.reader.UnexpectedPatternException;
import charlie.terms.CalculationSymbol;
import charlie.terms.FunctionSymbol;
import charlie.terms.IncorrectStringException;
import charlie.terms.MetaVariable;
import charlie.terms.Term;
import charlie.terms.TermFactory;
import charlie.terms.TheoryFactory;
import charlie.terms.Variable;
import charlie.types.Base;
import charlie.types.Type;
import charlie.types.TypeFactory;
import charlie.util.FixedList;
import charlie.util.UserException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Objects;

class TermTyper {
    protected SymbolData _symbols;
    protected ErrorCollector _errors;
    protected Token _lastStored;

    public TermTyper(SymbolData data, ErrorCollector collector) {
        this._symbols = data;
        this._errors = collector;
        this._lastStored = null;
    }

    protected void storeError(Token token, Object ... message) {
        Object object;
        if (token != null && token == this._lastStored) {
            return;
        }
        if (message.length == 1 && (object = message[0]) instanceof UserException) {
            UserException e = (UserException)object;
            this._errors.addError(new ParsingErrorMessage(token, e));
        } else {
            this._errors.addError(new ParsingErrorMessage(token, message));
        }
        this._lastStored = token;
    }

    protected Term makeTerm(Parser.ParserTerm pt, Type expectedType, boolean typeShouldBeDerivable) {
        Parser.ParserTerm parserTerm = pt;
        Objects.requireNonNull(parserTerm);
        Parser.ParserTerm parserTerm2 = parserTerm;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.IntVal.class, Parser.BoolVal.class, Parser.StringVal.class, Parser.CalcSymbol.class, Parser.Identifier.class, Parser.Meta.class, Parser.Lambda.class, Parser.Tup.class, Parser.Application.class, Parser.PErr.class}, (Object)parserTerm2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                int n2;
                Token token;
                Parser.IntVal intVal = (Parser.IntVal)parserTerm2;
                Token t = token = intVal.token();
                int value = n2 = intVal.value();
                return this.confirmType(t, TheoryFactory.createValue(value), expectedType);
            }
            case 1: {
                boolean bl;
                Token token;
                Parser.BoolVal boolVal = (Parser.BoolVal)parserTerm2;
                Token t = token = boolVal.token();
                boolean isTrue = bl = boolVal.istrue();
                return this.confirmType(t, TheoryFactory.createValue(isTrue), expectedType);
            }
            case 2: {
                Parser.StringVal stringVal = (Parser.StringVal)parserTerm2;
                Object object = stringVal.token();
                Token t = object;
                Object txt = object = stringVal.escapedvalue();
                FunctionSymbol ret = null;
                try {
                    ret = TheoryFactory.createEscapedStringValue((String)txt);
                }
                catch (IncorrectStringException e) {
                    this.storeError(t, e.getMessage());
                    ret = TermFactory.createConstant((String)txt, TypeFactory.stringSort);
                }
                return this.confirmType(t, ret, expectedType);
            }
            case 3: {
                Parser.CalcSymbol calcSymbol = (Parser.CalcSymbol)parserTerm2;
                Object object = calcSymbol.token();
                Token t = object;
                Object name = object = calcSymbol.name();
                return this.makeCalculationSymbol(t, (String)name, expectedType);
            }
            case 4: {
                Parser.Identifier identifier = (Parser.Identifier)parserTerm2;
                Object object = identifier.token();
                Token t = object;
                Object name = object = identifier.name();
                return this.makeIdentifier(t, (String)name, expectedType, typeShouldBeDerivable);
            }
            case 5: {
                Parser.Meta meta = (Parser.Meta)parserTerm2;
                FixedList<Parser.ParserTerm> fixedList = meta.token();
                Token t = fixedList;
                FixedList<Parser.ParserTerm> name = fixedList = meta.name();
                FixedList<Parser.ParserTerm> args = fixedList = meta.args();
                return this.makeMeta(t, (String)((Object)name), args, expectedType, typeShouldBeDerivable);
            }
            case 6: {
                Parser.Lambda lambda = (Parser.Lambda)parserTerm2;
                Object object = lambda.token();
                Token t = object;
                Object varname = object = lambda.vname();
                Object type = object = lambda.type();
                Object arg = object = lambda.arg();
                return this.makeAbstraction(t, (String)varname, (Type)type, (Parser.ParserTerm)arg, expectedType, typeShouldBeDerivable);
            }
            case 7: {
                Parser.Tup tup = (Parser.Tup)parserTerm2;
                Object object = tup.token();
                Token t = object;
                Object args = object = tup.args();
                return this.makeTuple(t, (FixedList<Parser.ParserTerm>)args, expectedType, typeShouldBeDerivable);
            }
            case 8: {
                Parser.Application application = (Parser.Application)parserTerm2;
                FixedList<Parser.ParserTerm> fixedList = application.token();
                Token t = fixedList;
                FixedList<Parser.ParserTerm> head = fixedList = application.head();
                FixedList<Parser.ParserTerm> args = fixedList = application.args();
                return this.makeApplication(t, (Parser.ParserTerm)((Object)head), args, expectedType, typeShouldBeDerivable);
            }
            case 9: 
        }
        Parser.PErr pErr = (Parser.PErr)parserTerm2;
        try {
            Parser.ParserTerm parserTerm3;
            Parser.ParserTerm t = parserTerm3 = pErr.t();
            return this.makeTerm(t, expectedType, typeShouldBeDerivable);
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private Term confirmType(Token token, Term term, Type expected) {
        if (expected == null || expected.equals(term.queryType())) {
            return term;
        }
        String kind = "term ";
        if (term.isValue()) {
            kind = "value ";
        } else if (term.isConstant()) {
            kind = "function symbol ";
        } else if (term.isVariable()) {
            kind = "variable ";
        }
        this.storeError(token, "Expected term of type ", expected, ", but got " + kind, term, " which has type ", term.queryType(), ".");
        return TermFactory.createConstant(term.toString(), expected);
    }

    private boolean hasInputSort(Base sort, Type type) {
        return type != null && type.isArrowType() && type.subtype(1).equals(sort);
    }

    private Term makeCalculationSymbol(Token token, String name, Type expected) {
        CalculationSymbol ret;
        switch (name) {
            case "+": {
                CalculationSymbol calculationSymbol = TheoryFactory.plusSymbol;
                break;
            }
            case "-": {
                CalculationSymbol calculationSymbol = TheoryFactory.minusSymbol;
                break;
            }
            case "*": {
                CalculationSymbol calculationSymbol = TheoryFactory.timesSymbol;
                break;
            }
            case "/": {
                CalculationSymbol calculationSymbol = TheoryFactory.divSymbol;
                break;
            }
            case "%": {
                CalculationSymbol calculationSymbol = TheoryFactory.modSymbol;
                break;
            }
            case ">": {
                CalculationSymbol calculationSymbol = TheoryFactory.greaterSymbol;
                break;
            }
            case "<": {
                CalculationSymbol calculationSymbol = TheoryFactory.smallerSymbol;
                break;
            }
            case "\u2265": {
                CalculationSymbol calculationSymbol = TheoryFactory.geqSymbol;
                break;
            }
            case "\u2264": {
                CalculationSymbol calculationSymbol = TheoryFactory.leqSymbol;
                break;
            }
            case "=_i": {
                CalculationSymbol calculationSymbol = TheoryFactory.intEqualSymbol;
                break;
            }
            case "=_s": {
                CalculationSymbol calculationSymbol = TheoryFactory.stringEqualSymbol;
                break;
            }
            case "\u21d4": {
                CalculationSymbol calculationSymbol = TheoryFactory.iffSymbol;
                break;
            }
            case "\u2260_i": {
                CalculationSymbol calculationSymbol = TheoryFactory.intDistinctSymbol;
                break;
            }
            case "\u2260_s": {
                CalculationSymbol calculationSymbol = TheoryFactory.stringDistinctSymbol;
                break;
            }
            case "XOR": {
                CalculationSymbol calculationSymbol = TheoryFactory.xorSymbol;
                break;
            }
            case "\u2227": {
                CalculationSymbol calculationSymbol = TheoryFactory.andSymbol;
                break;
            }
            case "\u2228": {
                CalculationSymbol calculationSymbol = TheoryFactory.orSymbol;
                break;
            }
            case "\u00ac": {
                CalculationSymbol calculationSymbol = TheoryFactory.notSymbol;
                break;
            }
            case "=": {
                CalculationSymbol calculationSymbol;
                if (this.hasInputSort(TypeFactory.stringSort, expected)) {
                    calculationSymbol = TheoryFactory.stringEqualSymbol;
                    break;
                }
                if (this.hasInputSort(TypeFactory.boolSort, expected)) {
                    calculationSymbol = TheoryFactory.iffSymbol;
                    break;
                }
                calculationSymbol = TheoryFactory.intEqualSymbol;
                break;
            }
            case "\u2260": {
                CalculationSymbol calculationSymbol;
                if (this.hasInputSort(TypeFactory.stringSort, expected)) {
                    calculationSymbol = TheoryFactory.stringDistinctSymbol;
                    break;
                }
                if (this.hasInputSort(TypeFactory.boolSort, expected)) {
                    calculationSymbol = TheoryFactory.xorSymbol;
                    break;
                }
                calculationSymbol = TheoryFactory.intDistinctSymbol;
                break;
            }
            default: {
                CalculationSymbol calculationSymbol = ret = null;
            }
        }
        if (ret == null) {
            throw new UnexpectedPatternException("TermTyper", "makeCalculationSymbol", "one of the known infix symbols", name);
        }
        if (expected != null && name.equals("-") && expected.queryArity() == 2) {
            this.storeError(token, "Use of unary calculation symbol [-] with binary type: while a - b is allowed to occur in terms, this is considered syntactic sugar for a + (-b); it cannot be done in a partially applied way.  If you want to use binary subtraction, please encode it using a helper function symbol.");
            return TermFactory.createConstant("-", expected);
        }
        return this.confirmType(token, ret, expected);
    }

    private Term makeIdentifier(Token token, String name, Type expected, boolean derivable) {
        FunctionSymbol f = this._symbols.lookupFunctionSymbol(name);
        if (f != null) {
            return this.confirmType(token, f, expected);
        }
        Variable x = this._symbols.lookupVariable(name);
        if (x != null) {
            return this.confirmType(token, x, expected);
        }
        if (this._symbols.lookupMetaVariable(name) != null) {
            this.storeError(token, "Symbol " + name + " was previously used (or declared) as a meta-variable with arity > 0; here it is used as a variable.");
            if (expected == null) {
                expected = this._symbols.lookupMetaVariable(name).queryType();
            }
            return TermFactory.createVar(name, expected);
        }
        if (expected == null) {
            if (derivable) {
                this.storeError(token, "Undeclared symbol: " + name + ".  Type cannot easily be deduced from context.");
            }
            return TermFactory.createVar(name);
        }
        x = TermFactory.createVar(name, expected);
        this._symbols.addVariable(x);
        return x;
    }

    private Term makeMeta(Token token, String name, FixedList<Parser.ParserTerm> args, Type expected, boolean typeShouldBeDerivable) {
        if (args.size() == 0) {
            return this.makeFreeVarTerm(token, name, expected, typeShouldBeDerivable);
        }
        MetaVariable mvar = this._symbols.lookupMetaVariable(name);
        if (mvar != null) {
            return this.makeKnownMetaTerm(token, mvar, args, expected);
        }
        if (this._symbols.lookupFunctionSymbol(name) != null) {
            this.storeError(token, "Unexpected meta-application with meta-variable " + name + ", which was previously declared as a function symbol.");
        } else if (this._symbols.lookupVariable(name) != null) {
            String kind = "variable without meta-arguments";
            if (this._symbols.lookupVariable(name).isBinderVariable()) {
                kind = "binder variable";
            }
            this.storeError(token, "Unexpected meta-application with meta-variable " + name + ", which was previously used (or declared) as a " + kind + ".");
        }
        if (expected == null && typeShouldBeDerivable) {
            this.storeError(token, "Cannot derive output type of meta-variable " + name + " from context.");
        }
        ArrayList<Term> targs = new ArrayList<Term>();
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < args.size(); ++i) {
            Term targ = this.makeTerm(args.get(i), null, typeShouldBeDerivable);
            targs.add(targ);
            types.add(targ.queryType());
        }
        mvar = TermFactory.createMetaVar(name, types, expected == null ? TypeFactory.defaultSort : expected);
        if (expected != null) {
            this._symbols.addMetaVariable(mvar);
        }
        return TermFactory.createMeta(mvar, targs);
    }

    private Term makeFreeVarTerm(Token token, String name, Type expected, boolean deriveType) {
        boolean declare;
        Variable ret = this._symbols.lookupVariable(name);
        if (ret != null) {
            if (ret.isBinderVariable()) {
                this.storeError(token, "Binder variable " + name + " used as meta-variable.");
            }
            if (expected == null || expected.equals(ret.queryType())) {
                return ret;
            }
            this.storeError(token, "Expected term of type ", expected, ", but got " + name + ", which was previously used as a variable of type ", ret.queryType(), ".");
            return TermFactory.createVar(name, expected);
        }
        boolean bl = declare = expected != null;
        if (this._symbols.lookupMetaVariable(name) != null) {
            this.storeError(token, "Meta-application for meta-variable " + name + " has no arguments, when it previously occurred (or was declared) with arity " + this._symbols.lookupMetaVariable(name).queryArity() + ".");
            if (expected == null) {
                expected = this._symbols.lookupMetaVariable(name).queryType();
            }
            declare = false;
        } else if (this._symbols.lookupFunctionSymbol(name) != null) {
            this.storeError(token, "Meta-application for meta-variable " + name + ", which was previously declared as a function symbol.");
            if (expected == null) {
                expected = this._symbols.lookupFunctionSymbol(name).queryType();
            }
            declare = false;
        }
        if (expected != null) {
            Variable x = TermFactory.createVar(name, expected);
            if (declare) {
                this._symbols.addVariable(x);
            }
            return x;
        }
        if (deriveType) {
            this.storeError(token, "Undeclared (meta-)variable: " + name + ".  Type cannot easily be deduced from context.");
        }
        return TermFactory.createVar(name);
    }

    private Term makeKnownMetaTerm(Token token, MetaVariable mvar, FixedList<Parser.ParserTerm> children, Type expected) {
        ArrayList<Term> args = new ArrayList<Term>();
        if (mvar.queryArity() == children.size()) {
            for (i = 0; i < children.size(); ++i) {
                args.add(this.makeTerm(children.get(i), mvar.queryInputType(i + 1), true));
            }
            if (expected == null || expected.equals(mvar.queryOutputType())) {
                return TermFactory.createMeta(mvar, args);
            }
        } else {
            this.storeError(token, "Meta-variable " + mvar.queryName() + " was previously used (or declared) with arity " + mvar.queryArity() + ", but is here used with " + children.size() + " arguments.");
            for (i = 0; i < children.size(); ++i) {
                args.add(this.makeTerm(children.get(i), null, false));
            }
        }
        if (expected != null && !expected.equals(mvar.queryOutputType())) {
            this.storeError(token, "Meta-variable " + mvar.queryName() + " has output type ", mvar.queryOutputType(), " while a term of type ", expected, " was expected.");
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < args.size(); ++i) {
            types.add(args.get(i).queryType());
        }
        if (expected == null) {
            expected = mvar.queryOutputType();
        }
        mvar = TermFactory.createMetaVar(mvar.queryName(), types, expected);
        return TermFactory.createMeta(mvar, args);
    }

    private Term makeTuple(Token token, FixedList<Parser.ParserTerm> elems, Type expected, boolean typeShouldBeDerivable) {
        if (elems.size() >= 2 && (expected == null || expected.isProductType() && expected.numberSubtypes() == elems.size())) {
            ArrayList<Term> parts = new ArrayList<Term>();
            for (int i = 0; i < elems.size(); ++i) {
                Type exp = expected == null ? null : expected.subtype(i + 1);
                parts.add(this.makeTerm(elems.get(i), exp, typeShouldBeDerivable));
            }
            return TermFactory.createTuple(parts);
        }
        if (elems.size() == 0) {
            this.storeError(token, "Illegal empty tuple: tuples should have at least length 2.");
            return TermFactory.createConstant("\u2987\u2988", expected == null ? TypeFactory.defaultSort : expected);
        }
        if (elems.size() == 1) {
            this.storeError(token, "Illegal singleton tuple: tuples should have at least length 2.");
            return this.makeTerm(elems.get(0), expected, typeShouldBeDerivable);
        }
        if (!expected.isProductType()) {
            this.storeError(token, "Type error: expected a term of type ", expected, " but got a tuple, which necessarily has a product type.");
        } else {
            this.storeError(token, "Type error: expected a term of type ", expected, " but got a tuple of length " + elems.size() + ".");
        }
        ArrayList<Term> parts = new ArrayList<Term>();
        for (int i = 0; i < elems.size(); ++i) {
            parts.add(this.makeTerm(elems.get(i), null, false));
        }
        Term ret = TermFactory.createTuple(parts);
        return TermFactory.createConstant(ret.toString(), expected);
    }

    private Term makeAbstraction(Token token, String varname, Type vartype, Parser.ParserTerm arg, Type expected, boolean typeShouldBeDerivable) {
        Object expectedSubtype = null;
        if (expected == null && vartype == null) {
            if (typeShouldBeDerivable) {
                this.storeError(token, "Cannot derive type of binder " + varname + " from context; it should be denoted directly in the abstraction.");
            }
            Term subterm = this.makeTerm(arg, null, false);
            return TermFactory.createAbstraction(TermFactory.createBinder(varname, TypeFactory.defaultSort), subterm);
        }
        if (expected != null && !expected.isArrowType()) {
            this.storeError(token, "Type error: expected subterm of type ", expected, ", but got abstraction, which necessarily has an arrow type.");
            Term ret = this.makeAbstraction(token, varname, vartype, arg, null, false);
            Type helper = TypeFactory.createArrow(ret.queryType(), expected);
            FunctionSymbol wrapper = TermFactory.createConstant("abs", helper);
            return wrapper.apply(ret);
        }
        Type einp = null;
        Type eout = null;
        if (expected != null) {
            einp = expected.subtype(1);
            eout = expected.subtype(2);
        }
        if (vartype == null) {
            vartype = einp;
        } else if (expected != null && !vartype.equals(einp)) {
            this.storeError(token, "Type error: expected subterm of type ", expected, ", but got abstraction with variable of type ", vartype, ".");
            vartype = einp;
        }
        Variable tmp = this._symbols.lookupVariable(varname);
        if (tmp != null) {
            this._symbols.removeVariable(varname);
        }
        if (this._symbols.lookupFunctionSymbol(varname) != null) {
            this.storeError(token, "Ambiguous binder: this name has already been declared as a function symbol.");
        } else if (this._symbols.lookupMetaVariable(varname) != null) {
            this.storeError(token, "Ambiguous binder: this name has already been declared as a meta-variable.");
        }
        Variable binder = TermFactory.createBinder(varname, vartype);
        this._symbols.addVariable(binder);
        Term subterm = this.makeTerm(arg, eout, true);
        this._symbols.removeVariable(varname);
        if (tmp != null) {
            this._symbols.addVariable(tmp);
        }
        return TermFactory.createAbstraction(binder, subterm);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Term makeApplication(Token token, Parser.ParserTerm apphead, FixedList<Parser.ParserTerm> args, Type expected, boolean typeShouldBeDerivable) {
        Parser.ParserTerm parserTerm = apphead;
        Objects.requireNonNull(parserTerm);
        Parser.ParserTerm parserTerm2 = parserTerm;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Parser.CalcSymbol.class}, (Object)parserTerm2, n)) {
            case 0: {
                Parser.CalcSymbol calcSymbol = (Parser.CalcSymbol)parserTerm2;
                try {
                    Object object = calcSymbol.token();
                    Token t = object;
                    Object name = object = calcSymbol.name();
                    if (((String)name).equals("-")) {
                        return this.makeMinusApplication(token, args, expected);
                    }
                    if (!((String)name).equals("=")) {
                        if (!((String)name).equals("\u2260")) return this.makeStandardApplication(token, apphead, args, expected, typeShouldBeDerivable);
                    }
                    if (expected == null) return this.makeOverloadedApplication(t, (String)name, args, expected);
                    if (!expected.isArrowType()) {
                        return this.makeOverloadedApplication(t, (String)name, args, expected);
                    }
                    Type input = expected.subtype(1);
                    if (input.equals(TypeFactory.intSort)) {
                        apphead = new Parser.CalcSymbol(t, "=_i");
                        return this.makeStandardApplication(token, apphead, args, expected, typeShouldBeDerivable);
                    }
                    if (input.equals(TypeFactory.stringSort)) {
                        apphead = new Parser.CalcSymbol(t, "=_s");
                        return this.makeStandardApplication(token, apphead, args, expected, typeShouldBeDerivable);
                    }
                    if (!input.equals(TypeFactory.boolSort)) return this.makeStandardApplication(token, apphead, args, expected, typeShouldBeDerivable);
                    apphead = new Parser.CalcSymbol(t, "\u21d4");
                    return this.makeStandardApplication(token, apphead, args, expected, typeShouldBeDerivable);
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
        }
        return this.makeStandardApplication(token, apphead, args, expected, typeShouldBeDerivable);
    }

    private Term makeStandardApplication(Token token, Parser.ParserTerm apphead, FixedList<Parser.ParserTerm> args, Type expected, boolean typeShouldBeDerivable) {
        Term head = this.makeTerm(apphead, null, true);
        if (head.queryType().queryArity() >= args.size()) {
            for (int i = 0; i < args.size(); ++i) {
                Term arg = this.makeTerm(args.get(i), head.queryType().subtype(1), true);
                head = head.apply(arg);
            }
            if (expected == null || head.queryType().equals(expected)) {
                return head;
            }
        } else {
            this.storeError(token, "Arity error: ", head, " has type ", head.queryType(), ", but ", args.size(), " arguments are given.");
            return this.makeFakeApplication(head.toString(), args, expected == null ? head.queryType().queryOutputType() : expected);
        }
        this.storeError(token, "Type error: expected term of type ", expected, ", but got ", head, " of type ", head.queryType(), ".");
        return TermFactory.createConstant(head.toString(), expected);
    }

    private Term makeFakeApplication(String head, FixedList<Parser.ParserTerm> args, Type exp) {
        ArrayList<Term> parts = new ArrayList<Term>();
        for (int i = 0; i < args.size(); ++i) {
            parts.add(this.makeTerm(args.get(i), null, false));
        }
        Type type = exp;
        for (int i = parts.size() - 1; i >= 0; --i) {
            type = TypeFactory.createArrow(((Term)parts.get(i)).queryType(), type);
        }
        FunctionSymbol start = TermFactory.createConstant(head, type);
        return TermFactory.createApp((Term)start, parts);
    }

    private Term makeMinusApplication(Token token, FixedList<Parser.ParserTerm> args, Type expected) {
        if (args.size() == 0) {
            return this.makeCalculationSymbol(token, "-", expected);
        }
        ArrayList<Term> targs = new ArrayList<Term>();
        for (int i = 0; i < args.size(); ++i) {
            targs.add(this.makeTerm(args.get(i), TypeFactory.intSort, true));
        }
        if (args.size() == 1) {
            Term child = (Term)targs.get(0);
            if (child.isValue()) {
                return this.confirmType(token, TheoryFactory.createValue(-child.toValue().getInt()), expected);
            }
            return this.confirmType(token, TheoryFactory.minusSymbol.apply((Term)targs.get(0)), expected);
        }
        if (args.size() == 2) {
            Term a = (Term)targs.get(0);
            Term b = (Term)targs.get(1);
            b = b.isValue() ? TheoryFactory.createValue(-b.toValue().getInt()) : TheoryFactory.minusSymbol.apply(b);
            return this.confirmType(token, TermFactory.createApp(TheoryFactory.plusSymbol, a, b), expected);
        }
        this.storeError(token, "Arity error: [-] can be used either with 1 or 2 arguments, but here it occurs with " + args.size() + ".");
        Type type = expected == null ? TypeFactory.intSort : expected;
        for (int i = targs.size() - 1; i >= 0; --i) {
            type = TypeFactory.createArrow(((Term)targs.get(i)).queryType(), type);
        }
        FunctionSymbol fakehead = TermFactory.createConstant("[-]", type);
        return TermFactory.createApp((Term)fakehead, targs);
    }

    private Term makeOverloadedApplication(Token token, String name, FixedList<Parser.ParserTerm> args, Type expected) {
        Term head;
        Term arg2;
        if (args.size() > 2) {
            this.storeError(token, "Arity error: overloaded operator " + token.getText() + " can take 2 arguments, but " + args.size() + " are given!");
            return this.makeFakeApplication("[" + token.getText() + "]", args, expected == null ? TypeFactory.boolSort : expected);
        }
        Term arg1 = this.makeTerm(args.get(0), null, false);
        Type input = arg1.queryType();
        if (args.size() < 2) {
            arg2 = null;
        } else if (input.equals(TypeFactory.defaultSort)) {
            arg2 = this.makeTerm(args.get(1), null, false);
            input = arg2.queryType();
            arg1 = this.makeTerm(args.get(0), input, true);
        } else {
            arg2 = this.makeTerm(args.get(1), input, true);
        }
        Type expectedHeadType = expected == null ? TypeFactory.boolSort : expected;
        for (int i = 0; i < 2; ++i) {
            expectedHeadType = TypeFactory.createArrow(input, expectedHeadType);
        }
        if (input.equals(TypeFactory.defaultSort)) {
            this.storeError(token, "Cannot deduce input type of overloaded operator.  Please indicate the type by subscripting (e.g., " + token.getText() + "_Int).");
            input = TypeFactory.intSort;
            head = TermFactory.createConstant("[" + token.getText() + "]", expectedHeadType);
        } else {
            head = this.makeCalculationSymbol(token, name, expectedHeadType);
        }
        Term ret = head.apply(arg1);
        if (arg2 != null) {
            ret = ret.apply(arg2);
        }
        return ret;
    }

    static Term readTerm(String str, boolean constrained, SymbolData data, Type expected, ErrorCollector collector) {
        Parser.ParserTerm pt = CoraParser.readTerm(str, constrained, collector);
        Term ret = null;
        if (!pt.hasErrors()) {
            TermTyper typer = new TermTyper(data, collector);
            ret = typer.makeTerm(pt, expected, true);
        }
        return ret;
    }
}

