/*
 * Decompiled with CFR 0.152.
 */
package charlie.smt;

import charlie.smt.CMult;
import charlie.smt.Division;
import charlie.smt.IValue;
import charlie.smt.IVar;
import charlie.smt.IntegerExpression;
import charlie.smt.Modulo;
import charlie.smt.Multiplication;
import charlie.smt.Valuation;
import charlie.util.Pair;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;

public final class Addition
extends IntegerExpression {
    private ArrayList<IntegerExpression> _children;

    private void addChild(IntegerExpression child) {
        if (child instanceof Addition) {
            Addition a = (Addition)child;
            for (IntegerExpression c : a._children) {
                this._children.add(c);
            }
        } else {
            this._children.add(child);
        }
    }

    Addition(IntegerExpression a, IntegerExpression b) {
        this._children = new ArrayList();
        this.addChild(a);
        this.addChild(b);
        this.checkSimplified();
    }

    Addition(List<IntegerExpression> args) {
        this._children = new ArrayList();
        for (IntegerExpression arg : args) {
            this.addChild(arg);
        }
        this.checkSimplified();
    }

    private Addition(ArrayList<IntegerExpression> args, boolean simpl) {
        this._children = args;
        this._simplified = simpl;
    }

    @Override
    public IntegerExpression add(int constant) {
        if (constant == 0) {
            return this;
        }
        if (this._children.size() == 0) {
            return new IValue(constant);
        }
        IntegerExpression integerExpression = this._children.get(0);
        if (integerExpression instanceof IValue) {
            Object ret;
            IValue k = (IValue)integerExpression;
            if (k.queryValue() == -constant) {
                if (this._children.size() == 2) {
                    return this._children.get(1);
                }
                return new Addition(this._children.subList(1, this._children.size()));
            }
            if (this._simplified) {
                ret = new ArrayList<IntegerExpression>(this._children);
                ((ArrayList)ret).set(0, (IntegerExpression)new IValue(k.queryValue() + constant));
                return new Addition((ArrayList<IntegerExpression>)ret, true);
            }
            this._children.set(0, new IValue(k.queryValue() + constant));
            ret = new Addition(this._children);
            this._children.set(0, k);
            return ret;
        }
        ArrayList<IntegerExpression> parts = new ArrayList<IntegerExpression>();
        parts.add(new IValue(constant));
        parts.addAll(this._children);
        return new Addition(parts, this._simplified);
    }

    public int numChildren() {
        return this._children.size();
    }

    public IntegerExpression queryChild(int index) {
        return this._children.get(index - 1);
    }

    public Pair<IntegerExpression, IntegerExpression> split() {
        ArrayList<IntegerExpression> pos = new ArrayList<IntegerExpression>();
        ArrayList<IntegerExpression> neg = new ArrayList<IntegerExpression>();
        int constant = 0;
        for (IntegerExpression e : this._children) {
            if (!(e instanceof IValue)) continue;
            IValue k = (IValue)e;
            constant += k.queryValue();
        }
        if (constant > 0) {
            pos.add(new IValue(constant));
        } else if (constant < 0) {
            neg.add(new IValue(-constant));
        }
        block5: for (int i = 0; i < this._children.size(); ++i) {
            IntegerExpression e;
            Objects.requireNonNull(this._children.get(i));
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, CMult.class}, (Object)e, n)) {
                case 0: {
                    IValue k = (IValue)e;
                    continue block5;
                }
                case 1: {
                    CMult cm = (CMult)e;
                    if (cm.queryConstant() >= 0) {
                        pos.add(cm);
                        continue block5;
                    }
                    neg.add(cm.multiply(-1));
                    continue block5;
                }
                default: {
                    pos.add(this._children.get(i));
                }
            }
        }
        IntegerExpression p = pos.size() == 0 ? new IValue(0) : (pos.size() == 1 ? (IntegerExpression)pos.get(0) : new Addition(pos));
        IntegerExpression n = neg.size() == 0 ? new IValue(0) : (neg.size() == 1 ? (IntegerExpression)neg.get(0) : new Addition(neg));
        return new Pair<IntegerExpression, IntegerExpression>(p, n);
    }

    @Override
    public int evaluate(Valuation val) {
        int ret = 0;
        for (int i = 0; i < this._children.size(); ++i) {
            ret += this._children.get(i).evaluate(val);
        }
        return ret;
    }

    private void checkSimplified() {
        for (int i = 0; i < this._children.size(); ++i) {
            IntegerExpression prevmain;
            IntegerExpression integerExpression;
            IntegerExpression integerExpression2;
            IValue k;
            IntegerExpression child = this._children.get(i);
            if (!child.isSimplified()) {
                return;
            }
            if (child instanceof IValue && (k = (IValue)child).queryValue() == 0) {
                return;
            }
            if (i == 0) continue;
            Objects.requireNonNull(child);
            int n = 0;
            IntegerExpression childmain = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, CMult.class}, (Object)integerExpression2, n)) {
                case 0 -> {
                    IValue k = (IValue)integerExpression2;
                    yield new IValue(1);
                }
                case 1 -> {
                    CMult m = (CMult)integerExpression2;
                    yield m.queryChild();
                }
                default -> child;
            };
            Objects.requireNonNull(this._children.get(i - 1));
            int n2 = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, CMult.class}, (Object)integerExpression, n2)) {
                case 0: {
                    IValue k2 = (IValue)integerExpression;
                    IntegerExpression integerExpression3 = new IValue(1);
                    break;
                }
                case 1: {
                    CMult m = (CMult)integerExpression;
                    IntegerExpression integerExpression3 = m.queryChild();
                    break;
                }
                default: {
                    IntegerExpression integerExpression3 = prevmain = this._children.get(i - 1);
                }
            }
            if (prevmain.compareTo(childmain) < 0) continue;
            return;
        }
        this._simplified = this._children.size() >= 2;
    }

    @Override
    public IntegerExpression simplify() {
        if (this._simplified) {
            return this;
        }
        ArrayList<IntegerExpression> todo = new ArrayList<IntegerExpression>();
        for (IntegerExpression c : this._children) {
            if ((c = c.simplify()) instanceof Addition) {
                Addition a = (Addition)c;
                todo.addAll(a._children);
                continue;
            }
            todo.add(c);
        }
        TreeMap<IntegerExpression, Integer> counts = new TreeMap<IntegerExpression, Integer>();
        int constant = 0;
        for (IntegerExpression c : todo) {
            int num;
            IntegerExpression main;
            if (c instanceof IValue) {
                IValue k = (IValue)c;
                constant += k.queryValue();
                continue;
            }
            if (c instanceof CMult) {
                CMult cm = (CMult)c;
                main = cm.queryChild();
                num = cm.queryConstant();
            } else {
                main = c;
                num = 1;
            }
            Integer current = (Integer)counts.get(main);
            if (current == null) {
                counts.put(main, num);
                continue;
            }
            counts.put(main, num + current);
        }
        ArrayList<IntegerExpression> ret = new ArrayList<IntegerExpression>();
        if (constant != 0) {
            ret.add(new IValue(constant));
        }
        for (Map.Entry entry : counts.entrySet()) {
            int k = (Integer)entry.getValue();
            if (k == 1) {
                ret.add((IntegerExpression)entry.getKey());
                continue;
            }
            if (k == 0) continue;
            ret.add(new CMult(k, (IntegerExpression)entry.getKey()));
        }
        if (ret.size() == 0) {
            return new IValue(0);
        }
        if (ret.size() == 1) {
            return (IntegerExpression)ret.get(0);
        }
        return new Addition(ret, true);
    }

    @Override
    public IntegerExpression multiply(int constant) {
        if (constant == 0) {
            return new IValue(0);
        }
        if (constant == 1) {
            return this;
        }
        ArrayList<IntegerExpression> cs = new ArrayList<IntegerExpression>();
        for (int i = 0; i < this._children.size(); ++i) {
            cs.add(this._children.get(i).multiply(constant));
        }
        return new Addition(cs, this._simplified);
    }

    @Override
    public void addToSmtString(StringBuilder builder) {
        builder.append("(+");
        for (int i = 0; i < this._children.size(); ++i) {
            builder.append(" ");
            this._children.get(i).addToSmtString(builder);
        }
        builder.append(")");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int compareTo(IntegerExpression other) {
        IntegerExpression integerExpression = other;
        Objects.requireNonNull(integerExpression);
        IntegerExpression integerExpression2 = integerExpression;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IValue.class, IVar.class, CMult.class, Addition.class, Multiplication.class, Division.class, Modulo.class}, (Object)integerExpression2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                IValue v = (IValue)integerExpression2;
                return 1;
            }
            case 1: {
                IVar x = (IVar)integerExpression2;
                return 1;
            }
            case 2: {
                CMult cm = (CMult)integerExpression2;
                if (this.compareTo(cm.queryChild()) > 0) return 1;
                return -1;
            }
            case 3: {
                int n2;
                Addition a = (Addition)integerExpression2;
                int i = this._children.size() - 1;
                for (int j = a._children.size() - 1; i >= 0 && j >= 0; --i, --j) {
                    int c = this._children.get(i).compareTo(a._children.get(j));
                    if (c == 0) continue;
                    n2 = c;
                    return n2;
                }
                n2 = this._children.size() - a._children.size();
                return n2;
            }
            case 4: {
                Multiplication m = (Multiplication)integerExpression2;
                return -1;
            }
            case 5: {
                Division m = (Division)integerExpression2;
                return -1;
            }
            case 6: {
                Modulo m = (Modulo)integerExpression2;
                return -1;
            }
        }
    }

    public int hashCode() {
        return 7 * this._children.hashCode() + 3;
    }
}

